Ext.define('KioskMode.view.KioskMode', {
    extend: 'Ext.Component',
    alias: 'widget.kioskmode',
    id: 'kioskmodelistview',
    html: '<ul id="ultag" class="kiosk_box"></ul>',
    initComponent: function() {
        this.callParent();
    },
    listeners: {
        afterrender: function() {
            Ext.Ajax.request({
                url: '/final/monitor/eg_scripts/KioskMode/data/kioskJson.jsp',
                method: 'POST',
                //params : paramsForRestURL,
                scope: this,
                success: function(response) {
                    var jsonText = response.responseText;
                    var jsonData = Ext.decode(jsonText);
                    //console.log("kioskJson--->>>", jsonData);
                    var kioskData = jsonData['kioskMode'];
                    var selectedScreens = jsonData['selectedScreens'];
                    var frequencyCombo = jsonData['frequencyCombo'];

                    var timeFrequency = jsonData['kioskMode']['timeFrequency'];
                    //console.log('timeFrequency-->',kioskData[]['timeFrequency']);

                    Ext.defer(function() {
                        for (var key in kioskData) {
                            var $iframe = $('<li class="ui-state-default kiosk_box_list"><div class="box kiosk_normal"><figure class="kioskDashboard_icons"><img src="../images/clear.png" class="img_center kiosk' + kioskData[key]['module'] + '" /></figure><div style="width:100%" ><p class="kioskDashboard_listing font_normal15">' + kioskData[key]['displayDashboardName'] + '</p><p class="kioskListing_subtitle font_normal11">' + kioskData[key]['moduleName'] + '</p></div></div><div class="kiosk_hover" ><div class="kiosk_playlist" style="margin-left: 26px;"><span class="kiosk_add_remove"><img src="../images/clear.png" style="margin:2px 7px 0 1px; float:left; padding: 0;vertical-align:margin-top" id="AddRemoveTooltip"  class="AddRemove kioskAddPlayicon" /><span style=" padding: 0 0 0 0px;"><span class="setTimedelay"  style="display:inline-block; margin: -5px 0 0px ;  float:left;"></span></span></span></div></div></li>');
                            if (kioskData[key]['selected']) {
                                $iframe = $('<li class="ui-state-default ui-selected kiosk_box_list"><div class="box kiosk_normal"><span class="iconTickSelection" style="right: 3px;top: 3px; z-index: 1; position: absolute;"></span><figure class="kioskDashboard_icons"><img src="../images/clear.png" class="img_center kiosk' + kioskData[key]['module'] + ' " /></figure><div style="width:100%" ><p class="kioskDashboard_listing font_normal15">' + kioskData[key]['displayDashboardName'] + '</p><p class="kioskListing_subtitle font_normal11">' + kioskData[key]['moduleName'] + '</p></div></div><div class="kiosk_hover" ><div class="kiosk_playlist" style="margin-left:26px;"><span class="kiosk_add_remove"><img src="../images/clear.png" style="margin:2px 7px 0 1px; padding: 0 ;float:left; vertical-align:top" id="AddRemoveTooltip" class="AddRemove kioskRemovePlayicon" /><span style="    padding: 0 0 0 0px;"> <span class="setTimedelay"  style="display:inline-block; margin: -5px 0 0px;  float:left;"></span></span></span></div></div></li>');
                            }
                            $iframe.data(kioskData[key]);
                            $('#ultag').append($iframe);
                            checkSelectionScreen();
                        }

                        function checkSelectionScreen() {
                            if (selectedScreens.length == 0) {
                                Ext.getCmp('playKioskBtn').disable();
                            } else {
                                Ext.getCmp('playKioskBtn').enable();
                            }
                        }
                        var dataArry = [];
                        var $hover;
                        //console.log('<--->', frequencyCombo);
                        var pageIntervalStore = new Ext.create('Ext.data.Store', {
                            fields: ['displayField', 'valueField'],
                            data: frequencyCombo
                        });
                        $('li.ui-state-default').each(function(i, parentEl) {
                            //console.log('<--->', kioskData[i]['timeFrequency']);

                            $(parentEl).find('.setTimedelay').append('<div id="combo-' + i + '" class="selectDropdown"></div>');
                            Ext.create('Ext.Container', {
                                renderTo: 'combo-' + i,
                                style: {
                                     cursor: 'default',
                                },
                                items: [
                                    {
                                        xtype: 'combobox',
                                        margin: '0px 0 0 0',
                                        queryMode: 'local',
                                        marginTop:3,
                                        width: 90,
                                        height: 20,
                                        labelWidth:16,
                                        fieldLabel :'<img src="../images/clear.png" class="kioskClock" style="margin-top:-2px;">',
                                        iconCls: 'kioskClock',
                                        editable: false,
                                        labelSeparator:"",
                                        forceSelection: false,
                                        cls: 'dropdown kioskdropdown',
                                        id: 'KIOSK_dashboard_combo' + i,
                                        store: pageIntervalStore,
                                        value: kioskData[i]['timeFrequency'].toString(),
                                        displayField: 'displayField',
                                        valueField: 'valueField',   
                                        listConfig: {
                                            maxWidth: 62,
                                            maxHeight: 82,

                                        },

                                        createPicker: function() {
                                            var me = this,
                                                picker,
                                                pickerCfg = Ext.apply({
                                                    xtype: 'boundlist',
                                                    pickerField: me,
                                                    selModel: {
                                                        mode: me.multiSelect ? 'SIMPLE' : 'SINGLE'
                                                    },

                                                    floating: true,
                                                    hidden: true,
                                                    renderTo: Ext.fly(parentEl),
                                                    store: me.store,
                                                    displayField: me.displayField,
                                                    focusOnToFront: false,
                                                    pageSize: me.pageSize,
                                                    tpl: me.tpl
                                                }, me.listConfig, me.defaultListConfig);

                                            picker = me.picker = Ext.widget(pickerCfg);
                                            if (me.pageSize) {
                                                picker.pagingToolbar.on('beforechange', me.onPageChange, me);
                                            }

                                            me.mon(picker, {
                                                itemclick: me.onItemClick,
                                                refresh: me.onListRefresh,
                                                scope: me
                                            });

                                            me.mon(picker.getSelectionModel(), {
                                                beforeselect: me.onBeforeSelect,
                                                beforedeselect: me.onBeforeDeselect,
                                                selectionchange: me.onListSelectionChange,
                                                scope: me
                                            });

                                            return picker;
                                        },
                                        listeners: {

                                            select: function(combo,  record, index) {
                                                combo.up('container').getEl().setStyle({
                                                    "background": "#126077",
                                                    "padding": "5px 10px",
                                                    "margin": "2px 0px 0 0px"
                                                });
                                                
                                               

                                                
                                                /*checkSelectionScreen();
                                                var timefrequencyArray = [];
                                                var selectedTime = Ext.getCmp('KIOSK_dashboard_combo' + i).getValue();
                                                console.log('selectedTime',selectedTime)
                                                updateSorting();*/
                                                dataArry.length = 0;
                                   

                                    $("#ultag li.ui-state-default").each(function(k, ell) {

                                        dataArry.push($(ell).data())
                                        
                                    });
                                    //console.log('updatedArray',dataArry)
                                   // dataArry.push({'timeFrequency' : combo.getValue()});
                                   $(parentEl).data().timeFrequency = combo.getValue();
                                    //console.log('dataArry',$(parentEl).data())
                                    //dataArry.push($(parentEl).data());
                                    var tvModeTimeFrequency = "";
                                    for (var i = 0; i < dataArry.length; i++) {
                                        tvModeTimeFrequency = tvModeTimeFrequency + "," + dataArry[i].dashbordName +"^"+dataArry[i].timeFrequency*1000;
                                    }
                                    if (tvModeTimeFrequency != null && !Ext.isEmpty(tvModeTimeFrequency)) {
                                        tvModeTimeFrequency = tvModeTimeFrequency.substr(1);
                                    }
									//console.log('tvModeTimeFrequency-->>',tvModeTimeFrequency);
                                    var paramsForTvScreen = "tvModeTimeFrequency=" + encodeURIComponent(tvModeTimeFrequency) + "&action=timeFrequency";
                                    Ext.Ajax.request({
                                        url: '/final/monitor/eg_scripts/KioskMode/data/kiosk.jsp',
                                        method: 'POST',
                                        params: paramsForTvScreen,
                                        scope: this,
                                        success: function(response) {
                                            var jsonText = response.responseText;
                                            var jsonData = Ext.decode(jsonText);
                                            //console.log(jsonData)
                                            var selectedScreens = jsonData['selectedScreens'];
                                            if (selectedScreens.length == 0) {
                                                Ext.getCmp('playKioskBtn').disable();
                                            } else {
                                                Ext.getCmp('playKioskBtn').enable();
                                            }
                                        }
                                    });

                                            },
                                            focus: function(combo,  record, index) {
                                                combo.up('container').getEl().setStyle({
                                                    "background": "#126077",
                                                    "padding": "5px 10px 5px 5px",
                                                    "margin": "0px 0px 0 0px",
                                                    "width" : 105,
                                                   });
                                                combo.getEl().setStyle({
                                                     "borderLeft":"5px solid transparent"
                                                    });
                                            },
                                            blur: function(combo,  record, index) {
                                                combo.up('container').getEl().setStyle({
                                                    "background": "#64b4c1",
                                                    "padding": "5px 10px 5px 5px",
                                                    "margin": "0px 0px 0 0px",
                                                    
                                                });
                                                combo.getEl().setStyle({
                                                     "borderLeft":"0px"
                                                    });
                                            }
                                        }



                                    },

                                ]




                            });

                            var st = $("#AddRemoveTooltip").find(".kioskAddPlayicon")
                            //console.log("st-->",st);
                            $(".kioskAddPlayicon").attr("data-qtip", screenLabels.addPlaylist);
                            $(".kioskRemovePlayicon").attr("data-qtip", screenLabels.removePlaylist);
                            $(".setTimedelay").attr("data-qtip", screenLabels.delay);
                            
                            $(parentEl).on('click', 'img.AddRemove', function(evt, index) {

                                    $(parentEl).toggleClass(function(index, className, state) {

                                        if ($(parentEl).data().selected) {
                                            $(parentEl).data().selected = false;
                                            $('.hoverCLS').remove();
                                            $('.iconTickSelection', parentEl).remove();
                                            $('.kioskRemovePlayicon', parentEl).removeClass('kioskRemovePlayicon').addClass('kioskAddPlayicon');


                                            $(".kioskAddPlayicon").attr("data-qtip", screenLabels.addPlaylist);

                                        } else {
                                            $(parentEl).data().selected = true;
                                            $(parentEl).append($hover);
                                            $('.kiosk_normal', parentEl).append('<span class="iconTickSelection" style="right: 3px;top: 3px; z-index: 1; position: absolute;"></span>');
                                            $('.kioskAddPlayicon', parentEl).removeClass('kioskAddPlayicon').addClass('kioskRemovePlayicon');

                                            $(".kioskRemovePlayicon").attr("data-qtip", screenLabels.removePlaylist);
                                        }
                                        return "ui-selected";
                                    });




                                    dataArry.length = 0;
                                    $("li.ui-selected").each(function(k, ell) {
                                        dataArry.push($(ell).data())
                                    });

                                    var TVMode = "";
                                    for (var i = 0; i < dataArry.length; i++) {
                                        TVMode = TVMode + "," + dataArry[i].url;
                                    }
                                    if (TVMode != null && !Ext.isEmpty(TVMode)) {
                                        TVMode = TVMode.substr(1);
                                    }
                                    var paramsForTvScreen = "TVModuleScreens=" + encodeURIComponent(TVMode) + "&action=tvScreenChange";
                                    Ext.Ajax.request({
                                        url: '/final/monitor/eg_scripts/KioskMode/data/kiosk.jsp',
                                        method: 'POST',
                                        params: paramsForTvScreen,
                                        scope: this,
                                        success: function(response) {
                                            var jsonText = response.responseText;
                                            var jsonData = Ext.decode(jsonText);
                                            var selectedScreens = jsonData['selectedScreens'];
                                            if (selectedScreens.length == 0) {
                                                Ext.getCmp('playKioskBtn').disable();
                                            } else {
                                                Ext.getCmp('playKioskBtn').enable();
                                            }
                                        }
                                    });
                                })
                                .on('mousedown', function() {
                                    $(this).addClass("lsGrabbing");
                                })
                                .on('mouseover', function() {
                                    $(this).addClass("lsGrab");
                                    if ($(this).data().selected) {
                                        $(this).append($hover)
                                    } else {
                                        $('.hoverCLS').remove();
                                    }
                                })
                                .on('mouseup', function() {
                                    $(this).removeClass("lsGrabbing");
                                })
                                .on('mouseout', function() {

                                })
                                .on('mouseleave', function(event, l) {
                                    $('.hoverCLS').remove();

                                    var combo = Ext.getCmp('KIOSK_dashboard_combo' + i);
                                    combo.triggerBlur();
                                });
                        // JQUERY UI sortable method
                        $("#ultag").sortable({
                            connectWith: "li",
                            distance: 5,

                            placeholder: "kioskPortlet-placeholder kioskUi-corner-all",
                            stop: function(event, ui) {
                            },
                            sort: function(event, ui) {
                                var kioskPortletWidth =$('#ultag li').width();
                                 $('li.kioskPortlet-placeholder').width(kioskPortletWidth);
                                 checkSelectionScreen();
                            },
                            update: function(event, ui) {

                                var updatedArray = [];
                                $("#ultag li.ui-state-default").each(function(k, ell) {
                                    updatedArray.push($(ell).data())
                                });
                                 var screenName = "";
                                    for (var i = 0; i < updatedArray.length; i++) {
                                        screenName = screenName + "," + updatedArray[i].dashbordName;
                                    }
                                    if (screenName != null && !Ext.isEmpty(screenName)) {
                                        screenName = screenName.substr(1);
                                    }
                                    var paramsForTvScreen = "sortedArray=" + encodeURIComponent(screenName) + "&action=sorting";
                                    Ext.Ajax.request({
                                        url: '/final/monitor/eg_scripts/KioskMode/data/kiosk.jsp',
                                        method: 'POST',
                                        params: paramsForTvScreen,
                                        scope: this,
                                        success: function(response) {
                                            var jsonText = response.responseText;
                                            var jsonData = Ext.decode(jsonText);
                                            var selectedScreens = jsonData['selectedScreens'];
                                            if(selectedScreens.length == 0 ) {
                                                Ext.getCmp('playKioskBtn').disable();
                                            } else {
                                                Ext.getCmp('playKioskBtn').enable();
                                            }
                                        }
                                    });
                                    checkSelectionScreen();
                                }
                            });
                        });
                        // JQUERY list resize method
                        function resizeList() {

                            var listItems = $("#ultag li"),
                                totalCount = $("#ultag li").length ,
                                gutter = 28,
                                getViewWidth = $('#kioskMode_Box').width(),
                                defaultListViewWidth = 260,
                                ListViewDivide = Math.floor(getViewWidth / defaultListViewWidth),
                                ListViewModules = getViewWidth % defaultListViewWidth,
                                balanceAdded = Math.floor(ListViewModules / ListViewDivide),
                                assignListViewFinalWidth = Math.floor(defaultListViewWidth + balanceAdded);
                            listItems.each(function(el) {
                                $(this).width(assignListViewFinalWidth - gutter);
                            });
                        }
                        resizeList();
                        $(window).resize(function() {
                            resizeList();
                        })

                    }, 500);
                }
            });
        },
		resize:function(){
			var listItems = $("#ultag li"),
                                totalCount = $("#ultag li").length ,
                                gutter = 28,
                                getViewWidth = $('#kioskMode_Box').width(),
                                defaultListViewWidth = 260,
                                ListViewDivide = Math.floor(getViewWidth / defaultListViewWidth),
                                ListViewModules = getViewWidth % defaultListViewWidth,
                                balanceAdded = Math.floor(ListViewModules / ListViewDivide),
                                assignListViewFinalWidth = Math.floor(defaultListViewWidth + balanceAdded);
                            listItems.each(function(el) {
                                $(this).width(assignListViewFinalWidth - gutter);
                            });
		}
    },
    flex: 1,
});