var win = null;
var displayWindow = null;
Ext.define('LiveGraph.controller.Main',{
	extend:'Ext.app.Controller',
	shareListAllCheck:false,
	hidObject:null,
	gridListSelection:[],
	graphsTimeout:null,
	messages:{},
	availableViews:[],
	currentView:'',
	currentUser:'',
	hiddenGraphs:[],
	
	views:['Main','LiveGraphHome','GraphViewList','GraphContainer','Graph','LiveGraphPanelTools','ViewPanel','ConfigurePanel','GraphsList','ViewOptions'],
	stores:['Graphs','Users','Views'],
	
	refs:[{
		selector:'main',
		ref:'main'
	},{
		selector:'main livegraphpaneltools',
		ref:'liveToolbar'
	},{
		selector:'viewpanel',
		ref:'viewPanel'
	},{
		selector:'graphslist',
		ref:'graphsList'
	},{
		selector:'graphcontainer',
		ref:'graphContainer'
	},{
		selector:'configurepanel',
		ref:'configurePanel'
	},{
		selector:'viewoptions',
		ref:'viewOptions'
	},{
		selector:'livegraphhome',
		ref:'liveGraphHome'
	},{
		selector:'viewpanel graphslist gridcolumn[dataIndex=layer]',
		ref:'layerColumn'
	},{
		selector:'livegraphhome graphviewlist#availableList',
		ref:'availableViews'
	},{
		selector:'livegraphhome graphviewlist#sharedList',
		ref:'sharedViews'
	},{
		selector:'livegraphhome graphviewlist button[action=deleteView]',
		ref:'deleteViewList'
	},{
		selector:'livegraphhome graphviewlist button[action=addView]',
		ref:'addViewList'
	},{
		selector:'livegraphhome button[action=hideViews]',
		ref:'hideViewButton'
	},{
		selector:'livegraphhome button[action=showViews]',
		ref:'showViewButton'
	},{
		selector:'viewpanel textfield#name',
		ref:'viewNameField'
	},{
		selector:'viewpanel textfield#displayName',
		ref:'graphNameField'
	},{
		selector:'viewpanel radiogroup#viewBasedOn',
		ref:'viewBase'
	},{
		selector:'viewpanel radiogroup#commonMaximum',
		ref:'commonMax'
	},{
		selector:'viewpanel combo#site',
		ref:'siteCombo'
	},{
		selector:'viewpanel combo#component',
		ref:'componentCombo'
	},{
		selector:'viewpanel multiselect#componentMulti',
		ref:'componentMulti'
	},{
		selector:'viewpanel multiselect#descriptorMulti',
		ref:'descriptorMulti'
	},{
		selector:'viewpanel combo#layer',
		ref:'layerCombo'
	},{
		selector:'viewpanel combo#test',
		ref:'testCombo'
	},{
		selector:'viewpanel combo#measure',
		ref:'measureCombo'
	},{
		selector:'viewpanel combo#descriptor',
		ref:'descriptorCombo'
	},{
		selector:'viewpanel container#configView',
		ref:'configView'
	},{
		selector:'viewpanel combo#timeline',
		ref:'timelineCombo'
	},{
		selector:'viewpanel combo#interval',
		ref:'intervalCombo'
	},{
		selector:'viewpanel combo#otherInterval',
		ref:'otherIntervalCombo'
	},{
		selector:'viewpanel combo#sharing',
		ref:'sharingCombo'
	},{
		selector:'viewpanel combo#noOfTimes',
		ref:'noOfTimesCombo'
	},{
		selector:'viewpanel numberfield#refreshRate',
		ref:'refreshRateField'
	},{
		selector:'viewpanel numberfield#noOfColumns',
		ref:'noOfColulmns'
	},{
		selector:'viewpanel itemselector#userSelector',
		ref:'userSelector'
	},{
		selector:'viewpanel button#deleteGraph',
		ref:'deleteGraphButton'
	},{
		selector:'viewpanel button#deleteView',
		ref:'deleteViewFrom'
	},{
		selector:'viewpanel fieldcontainer#siteContainer',
		ref:'siteContainer'
	},{
		selector:'viewpanel fieldcontainer#componentViewBase',
		ref:'componentViewBase'
	},{
		selector:'viewpanel fieldcontainer#testViewBase',
		ref:'testViewBase'
	},/* {
		selector:'main button#iconViewOptions',
		ref:'iconViewOptions'
	}, */{
		selector:'main button#iconViewConfig',
		ref:'iconViewConfig'
	},{
		selector:'main errorpanel#liveGraphError',
		ref:'viewListError'
	},{
		selector:'viewpanel viewoptions checkbox[itemId=lookback]',
		ref:'lookbackCheck'
	}],
	
	init:function(){
		win = Ext.create('Ext.window.Window',{
			width:900,
			height:600,
			padding:'5 10 10 10',
			bodyPadding:'0 0 10 0',
			closeAction:'hide',
			autoScroll:true,
			scroll:false,
			title:'Add New Graph',
			modal:true,
			constrain: true,
			border: false,
			frame: false,
			tools:[
			{
				xtype: 'container',
				margin: '0 0px 2px 0px',
				itemId: 'addLiveGraph_help',
				cls: 'iconBg',
				items: [{
					xtype: 'button',
					iconCls: 'iconHelp',
					itemId:'addLiveGraphHelpId',
					handler:this.openHelpPage,
					listeners: {
						afterrender: function () {
							Ext.create('Ext.tip.ToolTip', {
								target: this.id,
								anchor: 'top',
								cls: 'yellowTip',
								trackMouse: true,
								html: lg_help_text
							});
						}
					},
					style: {
						background: 'none',
						border: '0px'
					}
				}]
			}],
			listeners: {
				show: function (win) {
					if (this.modal) {
						var dom = Ext.dom.Query.select('.x-mask');
						for (var y = 0; y < dom.length; y++) {
							var el = Ext.fly(dom[y]);
						}
						el.addCls('windowModal');
					}
				},
				hide: function (win) {
					var dom = Ext.dom.Query.select('.x-mask');
					if (this.modal) {

						var el = Ext.fly(dom[0]);
						el.removeCls('windowModal');
					}
				},
				afterrender: function () {
					Ext.EventManager.onWindowResize(function () {
						var me = this;
						me.center();
					}, this);
				}
			}
		});
		this.control({
			'viewpanel':{
				render:this.viewLoad
			},
			'livegraphhome':{
				render:this.loadHomePage
			},
			'main':{
				render:this.openHome
			},
			'main button[action=addView]':{
				click:this.openViewConfig
			},
			'main livegraphpaneltools button[itemId=iconHome]':{
				click:this.openHome
			},
			'main livegraphpaneltools button[itemId=iconViewList]':{
				click:this.openViewList
			},
			'main livegraphpaneltools button[itemId=helpIconId]':{
				click:this.openHelpPage
			},
			/* 'main button[itemId=iconViewOptions]':{
				click:this.displayViewSettings
			}, */
			'main button[itemId=iconViewConfig]':{
				click:this.displayViewSettings
			},
			'viewpanel button[action=addGraphToView]':{
				click:this.addGraphToView
			},
			'viewpanel button[action=deleteGraphFromView]':{
				click:this.deleteGraphFromView
			},
			'viewpanel button[action=updateView]':{
				click:this.validateViewSubmit
			},
			'viewpanel button[action=deleteView]':{
				click:this.deleteViewForm
			},
			'viewpanel radiogroup[itemId=viewBasedOn]':{
				change:this.viewBaseConfirmation,
			},
			'viewpanel graphslist':{
				selectionchange:this.graphCheckChanged
			},
			'viewpanel viewoptions combo':{
				change: this.viewOptionsComboSelect
			},
			'viewpanel viewoptions checkbox#lookback':{
				change: this.lookbackChange
			},
			'viewpanel configurepanel combo':{
				select:this.comboSelect
			},
			'viewpanel configurepanel combo[itemId=test]':{
				select:this.testComboSelect
			},
			'viewpanel configurepanel multiselect[itemId=componentMulti]':{
				change:this.componentMultiSelect
			},
			'livegraphhome graphviewlist#availableList':{
				selectionchange: this.availableCheckChanged
			},
			'livegraphhome graphviewlist#sharedList':{
				selectionchange: this.sharedCheckChanged
			},
			'livegraphhome graphviewlist button[action=deleteView]':{
				click: this.deleteViewList
			},
			'livegraphhome button[action=hideViews]':{
				click: this.hideView
			},
			'livegraphhome button[action=showViews]':{
				click: this.showView
			},
			'main graphcontainer graph':{
				move: this.graphMoved
			},
		});
	},

	graphMoved:function(portlet, x, y, eOpts){
		var dashboard = portlet.getBubbleParent();
		var itemsArray = dashboard.items.items;
		var currentPosition = itemsArray.indexOf(portlet);
		var newX = portlet.getPosition()[0];
		var newY = portlet.getPosition()[1];
		var index = 0;

		if(x!=0 && y!=0 && (x > 20 || x < -20 || y > 20 || y < -20))
		{
			for(i=0;i<itemsArray.length;i++){
				if(i == currentPosition)
					continue;
				var box = itemsArray[i].getBox();
				if((box.x + box.width) > newX && (box.y + box.height) > newY){
					index = i;
					break;
				}
			}
			portlet.setPagePosition([(newX - x),(newY - y)]);
			dashboard.insert(index,portlet);
		}
		else if(x!=0 && y!=0){
			portlet.setPagePosition([(newX - x),(newY - y)]);
		}
	},
	
	// Default page load when first the app is called
	loadHomePage:function(homepanel){
		var me = this;
		this.getMain().setTitle(liveGraphHomeData.screenLabels.liveGraphTitle);
		//this.getLiveGraphHome().setLoading(true,true);
			me.getMain().setLoading(true,true);
		Ext.Ajax.request({
			url:'/final/monitor/livegraph/EgLiveGraphList.jsp',
			disableCaching:false,
			success:function(response){
				var json = Ext.decode(response.responseText);
				if(!Ext.isEmpty(json.screenLabels))
					me.getMain().setTitle(json.screenLabels.title);
				me.messages = json.messages;
				me.currentUser = json.currentUser;
				me.hiddenGraphs = json.hiddenGraphs;
				if(Ext.isEmpty(json.userViews)){
				Ext.getCmp('LiveGraph_hometab').show();
				Ext.getCmp('LiveGraph_viewtab').show();
					me.getViewListError().show();
					me.getAvailableViews().hide();
				}
				else
				{
					Ext.getCmp('LiveGraph_hometab').show();
					Ext.getCmp('LiveGraph_viewtab').show();
					me.getViewListError().hide();
					me.getAvailableViews().getStore().loadData(json.userViews);
					me.getAvailableViews().show();
				}
				if(Ext.isEmpty(json.sharedViews) && Ext.isEmpty(json.hiddenGraphs))
				{
					if(me.getSharedViews() != null && me.getSharedViews()!= undefined)
					{
						if(me.getSharedViews().getStore() != null && me.getSharedViews().getStore() != undefined && me.getSharedViews().getStore().getCount()>0)
						{
							me.getSharedViews().getStore().removeAll();
						}
					}
					me.getLiveGraphHome().down('panel[itemId=sharedPanel]').hide();
				}
				else
				{
					if(Ext.isEmpty(json.sharedViews) && !Ext.isEmpty(json.hiddenGraphs))
					{
						me.getLiveGraphHome().down('panel[itemId=sharedPanel]').update('<table width="100%" height="100px"><tr><td align="center" valign="middle"><div class="iconInformation"></div><span style="font-size: 13px;">'+json.screenLabels.allSharedViewsAreHidden+' </span></td></tr></table>');
						me.getSharedViews().hide();
						me.getHideViewButton().hide();
						me.getShowViewButton().show();
					}
					else if(!Ext.isEmpty(json.sharedViews) && !Ext.isEmpty(json.hiddenGraphs)){
						me.getSharedViews().getStore().loadData(json.sharedViews);
						me.getSharedViews().show();
						me.getShowViewButton().show();
					}
					else if(!Ext.isEmpty(json.sharedViews) && Ext.isEmpty(json.hiddenGraphs)){
						me.getSharedViews().getStore().loadData(json.sharedViews);
						me.getSharedViews().show();
						me.getShowViewButton().hide();
						me.getHideViewButton().show();
					}

					me.getLiveGraphHome().down('panel[itemId=sharedPanel]').show();
					me.getLiveGraphHome().down('component[itemId=viewCreatorLegend]').update('<div class="iconUserIndex" style="float:left"></div>'+'<div style="float:left;padding-top:4px;padding-left:3px">'+json.screenLabels.viewCreator+'</div>');
				}
				if(!Ext.isEmpty(json.screenLabels)){
					if(!Ext.isEmpty(json.screenLabels.addNew))
						me.getAddViewList().setText(json.screenLabels.addNew);
					if(!Ext.isEmpty(json.screenLabels['delete']))
						me.getDeleteViewList().setText(json.screenLabels['delete']);
				}
				//me.getLiveGraphHome().setLoading(false);
				me.getMain().setLoading(false);
				tmpViewName = 'graphList';
			},
			failure:function(){
				//me.getLiveGraphHome().setLoading(false);
				me.getMain().setLoading(false);
				alert('Failed to load Graphs list!');
			}
		});
	},
	
	// To open home page when home button is clicked on the top tool bar
	openHome:function(object){
		tmpViewName=null;
		var dispUrl = '/final/monitor/livegraph/EgLiveGraphDisplay.jsp?requestFrom=null';
		if(!Ext.isEmpty(accessPageName) && accessPageName!=null && accessPageName!=undefined && accessPageName!='null' && (accessPageName!='Default'||accessPageName!='default'))
		{
			dispUrl = dispUrl + "&view_name="+encodeURI(accessPageName);
			//this.openGraphView(dispUrl);
		}
		this.openGraphView(dispUrl);
		jumpScroll();
	},

	// To open the view listing page when listing icon is clicked on the top tool bar
	openViewList:function(button){
		//this.getIconViewOptions().hide();
		this.getIconViewConfig().hide();
		if(!Ext.isEmpty(this.graphsTimeout))
			clearTimeout(this.graphsTimeout);
		this.getMain().removeAll();
		//Ext.getCmp('View_tbseparator').hide();
		Ext.getCmp('Config_tbseparator').hide();
		
		this.getMain().add({
			xtype:'livegraphhome'
		});
														//autoscroll show/hide functionality
			Ext.getCmp('auto_separator').hide();
			Ext.getCmp('iconAutomaticScrollRun').hide();
			Ext.getCmp('iconAutomaticScrollStop').hide();
			Ext.getCmp('iconAutomaticScrollJumpToTop').hide();
			Ext.getCmp('TabSeperator').hide();
			//jumpScroll();
	},
	openHelpPage:function(button){
		var liveHelpWin=null;
		if (Ext.getBody().getViewSize().width < 1100)
		{
			var cwidth1=Ext.getBody().getViewSize().width-64; 
			var leftPosition = 25;
			var left = (Ext.getBody().getViewSize().width/2)-(cwidth1/2);						    
		}
		else
		{
			var cwidth1=Ext.getBody().getViewSize().width-154;
			var leftPosition = 78;
			var left = (Ext.getBody().getViewSize().width/2)-(cwidth1/2);
		}
		var cwidth2=(cwidth1/2);						
		var cheight=Ext.getBody().getViewSize().height-240;
		var top = (Ext.getBody().getViewSize().height/2)-(cheight/2);
	//	liveHelpWin=window.open("/final/eghelp/EgHelpApp.jsp?forwardPage=EgMHelp.jsp&params=from|equal|LIVEGRAPH", cwidth1, cheight+20, left, top, left, top);
		liveHelpWin=window.open("/final/eghelp/EgHelpApp.jsp?forwardPage=EgMHelp.jsp&params="+encodeURI('from|equal|LIVEGRAPH'), cwidth1, cheight+20, left, top, left, top);
		liveHelpWin.focus();
		
			Ext.getCmp('iconAutomaticScrollStop').hide();
			//Ext.getCmp('iconAutomaticScrollRun').show();
			//jumpScroll();
		
		/*Ext.onReady(function(){
			Ext.widget("window",{
				title: "Help",
				resizable: false,
				width: 1000,
				frame: false,
				constrain: true,
				height: 550,
				scroll: false,
				autoScroll: false,
				border: false,
				layout: "fit",
				padding: "0 0 0 0",
				margin: "0 10 0 0",
				html: '<iframe width="100%" height="100%" scrolling="no" frameborder="0" src="/final/eghelp/EgHelpApp.jsp?forwardPage=EgMHelp.jsp&params=from|equal|LIVEGRAPH"></iframe>'
			}).show()
		});*/
	},
	// To set the size of the available grid when is empty
	/*availableViewSetting:function(store){
		console.log('In availableViewSetting....!');
		//this.getAvailableViews().setHeight(500);
	},*/

	// To load default view if there is any
	viewLoad:function(viewpanel)
	{
		var me = this;
		//viewpanel.setLoading(true,true);
		me.getMain().setLoading(true,true);
		Ext.Ajax.request({
			url:viewpanel.url,
			success:function(response){
				var json = "";
				try {
					json =  Ext.decode(response.responseText);
				} catch (ex) {
					window.opener.location.href='/final/servlet/com.egurkha.Logout?errmsg=1';
					self.close();
				}
				me.getMain().setTitle(json.screenLabels.title);
				me.messages = json.messages;
				me.availableViews = json.availableViews;
				me.getConfigurePanel().setData(json);
				if(!Ext.isEmpty(json.viewFormData.name))
				{
					oldViewName = json.viewFormData.name;
					me.getDeleteViewFrom().show();
				}
				else
				{
					oldViewName="";
					me.getDeleteViewFrom().hide();
				}
				if(!Ext.isEmpty(json.graphsData)){
					me.getGraphsStore().clearFilter();
					me.getGraphsStore().loadData(json.graphsData);
				}
				else{
					me.getGraphsStore().removeAll(true);
					me.getGraphsStore().load();
				}
				me.getViewOptions().setData(json);
				//viewpanel.setLoading(false);
				me.getMain().setLoading(false);
				me.emptyCombo = json.emptyCombo;
				me.hidObject = json.currentSelection;
				//jumpScroll();
			},
			failure:function(){
				viewpanel.setLoading(false);
				window.opener.location.href='/final/servlet/com.egurkha.Logout?errmsg=1';
					self.close();
			}
		});
	},

	// To open the view cofiguration options
	openViewConfig:function(viewUrl){
		if(!Ext.isEmpty(viewUrl) && viewUrl instanceof Object){
			viewUrl = '';
			readonlyFlag = false;
		}
		else if(Ext.isEmpty(viewUrl)){
			readonlyFlag = false;
		}
		else{
			readonlyFlag = true;
		}

		win.removeAll(true);
		win.add({
			xtype:'viewpanel',
			//autoScroll:false,
			//scroll:false,
			url:(!Ext.isEmpty(viewUrl)?encodeURI(viewUrl):'/final/monitor/livegraph/EgLiveGraphConfig.jsp?modify=false')
		});
		win.show();
		Ext.getCmp('iconAutomaticScrollStop').hide();
		//Ext.getCmp('iconAutomaticScrollRun').show();
		//jumpScroll();

		/*this.getMain().removeAll();
		this.getMain().add({
			xtype:'viewpanel',
			url:(!Ext.isEmpty(viewUrl)?viewUrl:'/final/monitor/livegraph/EgLiveGraphConfig.jsp?modify=false')
		});*/
	},
	
	// To add graph to the view
	addGraphToView:function(button){
		var me = this;
		var componentName = this.getComponentCombo().getValue();
		var layer = this.getLayerCombo().getValue();
		var test = this.getTestCombo().getValue();
		var measure = this.getMeasureCombo().getValue();
		var viewBase = this.getViewBase().getValue().viewBasedOn;

		if(viewBase != 'Test' && (Ext.isEmpty(componentName) || componentName == '-1' ||  Ext.isEmpty(layer) || layer == '-1' || Ext.isEmpty(test) || test == '-1' || Ext.isEmpty(measure) || measure == '-1')){
			this.showErrorMessage('chooseRequieredParams');
			return false;
		}
		else if(viewBase == 'Test' && (Ext.isEmpty(test) || test == '-1' || Ext.isEmpty(measure) || measure == '-1')){
			this.showErrorMessage('chooseRequieredParams');
			return false;
		}

		var multi= this.getComponentMulti().getValue();
		/*if(multi == '')
		{
			
			this.showErrorMessage('chooseRequieredParams');
			return false;

		}*/

		var multiDesp =this.getDescriptorMulti().getValue();
		
		
		/*if(multiDesp == '' || multiDesp == '-1')
		{
			this.showErrorMessage('chooseRequieredParams');
			return false;
		}*/
	
		var descriptor = this.getDescriptorCombo().getValue();	
		
		if(viewBase != 'Test' &&  descriptor == '-1' ){
			
			if(this.getDescriptorCombo().getStore().getCount() > 0)
			{
				this.showErrorMessage('chooseRequieredParams');
				return false;
			}
		}

		var graphName = this.getGraphNameField().getValue();

		var viewName = this.getViewNameField().getValue();
		var dispName = this.getGraphNameField().getValue();
		

		if(viewName!=null && (viewName.indexOf("=")>-1 || viewName.indexOf("\"")>-1 || viewName.indexOf("$")>-1)){
			Ext.Msg.alert("Error","Special Characters are not allowed in View name");
			return false;
		}
		else if(dispName!=null && (dispName.indexOf("=")>-1 || dispName.indexOf("\"")>-1 || dispName.indexOf("$")>-1) || dispName.indexOf(".")>-1){
			Ext.Msg.alert("Error","Special Characters are not allowed in Display name");
			return false;
		}
		else if(Ext.isEmpty(viewName))
		{
			Ext.Msg.alert("Error","View name Should Not Be Blank");
			return false;
		}
		else if(!this.getConfigurePanel().isModify && !Ext.isEmpty(this.availableViews))
		{
			for(i=0 ;i<this.availableViews.length;i++)
			{
				if(this.availableViews[i].toUpperCase() == viewName.toUpperCase())
				{
					Ext.Msg.alert("Error","View name Already Exists");
					return false;
				}
			}
		}

		var graphName = this.getGraphNameField().getValue();

		if(graphName.toUpperCase() == 'NULL'){
			this.showErrorMessage('displayNameShouldNotBeNull');
			return false;
		}
		else if(!Ext.isEmpty(graphName)){
			var nameCheck = this.getGraphsStore().findRecord('displayName',graphName,0,false,true,true);
			if(!Ext.isEmpty(nameCheck)){
				this.showErrorMessage('displayNameExists');
				return false;
			}
		}

		var formParams = button.up('form').getValues();
		var valueText = '';
		if(this.getViewBase().getValue().viewBasedOn != 'Test'){
			valueText = (Ext.isEmpty(formParams['displayName'])?'NULL':formParams['displayName'])+',';

			if(!Ext.isEmpty(formParams['site'])){
				valueText += ((formParams['site'] != -1 && formParams['site'] != '-1')?formParams['site']:'NULL')+',';
			}
			else{
				formParams['site'] = -1;
				valueText += 'NULL,';
			}

			var componentType = formParams['component'].substring(formParams['component'].lastIndexOf(':')+1,formParams['component'].length);
			formParams['componentType'] = componentType;
			valueText += formParams['component'].substring(0,formParams['component'].lastIndexOf(':'))+',';
			valueText += formParams['componentType']+',';
			valueText += formParams['layer']+',';
			valueText += formParams['test']+',';
			valueText += formParams['measure']+',';

			if(formParams['descriptor'] == '-2')
			{
				formParams['descriptor']='-';
			}
			else
			{
				formParams['descriptor']=formParams['descriptor'];
			}
			
			valueText += formParams['descriptor'];
		}
		else{
			valueText = formParams['displayName']+',';

			if(!Ext.isEmpty(formParams['site'])){
				valueText += ((formParams['site'] != -1 && formParams['site'] != '-1')?formParams['site']:'NULL')+',';
			}
			else{
				formParams['site'] = -1;
				valueText += 'NULL,';
			}

			var componentType = formParams['componentMulti'].substring(formParams['componentMulti'].lastIndexOf(':')+1,formParams['componentMulti'].length);
			formParams['componentType'] = componentType;
			if(formParams['componentMulti'].indexOf(',') == -1)
			{
				valueText += formParams['componentMulti'].substring(0,formParams['componentMulti'].lastIndexOf(':'))+',';
				valueText += formParams['componentType']+',';
				valueText += formParams['test']+',';
				valueText += formParams['measure']+',';
			}
		}
		var manualObject = {};
		var componentTypeList = '',componentList='',componentArray='';
		if(formParams['componentMulti'] != null && formParams['componentMulti'] != 'undefined' && formParams['componentMulti'] != "" && formParams['componentMulti'].indexOf(',') > -1)
			componentArray = formParams['componentMulti'].split(',');
		for(key in formParams){
			if(key == 'name' || key == 'viewBasedOn' || key == 'displayName' || key == 'descriptorMulti')
				continue;
			else if(key == 'site' && formParams[key] == '-1'){
				manualObject[key] = '-';
				continue;
			}
			else if(key == 'descriptor' && formParams[key] == '-2')
			{
				manualObject[key] = '-';

			}
			else if(key == 'componentType'){
				if(this.getViewBase().getValue().viewBasedOn != 'Test')
					manualObject[key] = this.getComboDisplayValue(key,formParams['component']);
				else
				{
					if(componentArray != null && componentArray != 'undefined' && componentArray != "" && componentArray.length > 1)
					{
						for(var k=0;k<componentArray.length;k++)
						{
							//manualObject[key] = this.getMultiselectDisplayValue(key,compType);
							var compType = this.getMultiselectDisplayValue(key,componentArray[k]);;
							componentTypeList += compType+',';
						}
					}
					else
					{
						manualObject[key] = this.getMultiselectDisplayValue(key,formParams['componentMulti']);
					}
				}
				continue;
			}
			else if(key == 'componentMulti'){
				if(componentArray != null && componentArray != 'undefined' && componentArray != "" && componentArray.length > 1)
				{
					for(var k=0;k<componentArray.length;k++)
					{
						//manualObject['component'] = this.getMultiselectDisplayValue(key,comp);
						var comp = this.getMultiselectDisplayValue(key,componentArray[k]);
						componentList += comp+',';
					}
				}
				else
				{
					manualObject['component'] = this.getMultiselectDisplayValue(key,formParams[key]);
				}
				continue;
			}
			else{
				manualObject[key] = this.getComboDisplayValue(key,formParams[key]);
			}
		}

		manualObject['displayName'] = (Ext.isEmpty(this.getGraphNameField().getValue())?'-':this.getGraphNameField().getValue());

		if(this.getViewBase().getValue().viewBasedOn == 'Test'){
			if(formParams['componentMulti'].indexOf(',') > -1)
			{
				var compType = componentTypeList.split(',');
				var comp = componentList.split(',');
				for(var y=0;y<compType.length-1;y++)
				{
					var dummyValueText ='';
					dummyValueText = valueText;
					manualObject['component'] = comp[y];
					dummyValueText += componentArray[y].substring(0,componentArray[y].lastIndexOf(':'))+',';
					manualObject['componentType'] = compType[y];
					dummyValueText += componentArray[y].substring(componentArray[y].lastIndexOf(':')+1,componentArray[y].length)+',';
					dummyValueText += formParams['test']+',';
					dummyValueText += formParams['measure']+',';
					if(this.getDescriptorMulti().getValue() == '-2')
					{
						manualObject['descriptor'] = '-';
					}
					else
					{
						manualObject['descriptor'] =this.getMultiselectDisplayValue('descriptorMulti',formParams['descriptorMulti']);
					}

					dummyValueText +=manualObject['descriptor'];
					manualObject['valueText'] = dummyValueText;
					this.getGraphsStore().add(manualObject);
				}
			}
			else
			{
				if(formParams['descriptorMulti'].indexOf(',') > -1){
					var descriptorArray = formParams['descriptorMulti'].split(',');
					if(descriptorArray.length > 25){
						this.showErrorMessage('only25SelectionsAllowed');
						return false;
					}
					for(i = 0;i < descriptorArray.length;i++){
						var copyValueText = valueText;
						copyValueText += descriptorArray[i];
						manualObject['descriptor'] = this.getMultiselectDisplayValue('descriptorMulti',descriptorArray[i]);
						manualObject['valueText'] = copyValueText;
						if(!Ext.isEmpty(this.getGraphsStore().findRecord('valueText',manualObject['valueText']))){
							this.showErrorMessage('currentSelectionsHaveBeenAdded');
							return false;
						}
						else{
							var flag = false;
							this.getGraphsStore().findBy(function(record,recordId){
								var regPattern = new RegExp(record.get('component'));
								if(regPattern.test(formParams['componentMulti']) && record.get('test') == manualObject['test'] && record.get('measure') == manualObject['measure'] && record.get('descriptor') == descriptorArray[i]){
									me.showErrorMessage('someEntriesCurrentSelectionsHaveBeenAdded');
									flag = true;
									return false;
								}
							});
							if(flag)
								return false;
						}
						this.getGraphsStore().add(manualObject);
					}
				}
				else{
					if(this.getDescriptorMulti().getValue() == '-2')
					{
						manualObject['descriptor'] = '-';
					}
					else
					{
						manualObject['descriptor'] =this.getMultiselectDisplayValue('descriptorMulti',formParams['descriptorMulti']);
					}

					valueText +=manualObject['descriptor'];
					//manualObject['descriptor'] = this.getMultiselectDisplayValue('descriptorMulti',formParams['descriptorMulti']);
					
					
					manualObject['valueText'] = valueText;
					if(!Ext.isEmpty(this.getGraphsStore().findRecord('valueText',manualObject['valueText']))){
						this.showErrorMessage('currentSelectionsHaveBeenAdded');
						return false;
					}
					else{
						var flag = false;
						this.getGraphsStore().findBy(function(record,recordId){
							var regPattern = new RegExp(record.get('component'));
							if(regPattern.test(formParams['componentMulti']) && record.get('test') == manualObject['test'] && record.get('measure') == manualObject['measure'] && record.get('descriptor') == manualObject['descriptorMulti']){
								me.showErrorMessage('currentSelectionsHaveBeenAdded');
								flag = true;
								return false;
							}
						});
						if(flag)
							return false;
					}
					this.getGraphsStore().add(manualObject);
				}
			}
		}
		else{
			manualObject['valueText'] = valueText;
			if(!Ext.isEmpty(this.getGraphsStore().findRecord('valueText',manualObject['valueText']))){
				this.showErrorMessage('currentSelectionsHaveBeenAdded');
				return false;
			}
			else{
				var flag = false;
				this.getGraphsStore().findBy(function(record,recordId){
					var regPattern = new RegExp(record.get('component'));
					if(regPattern.test(manualObject['component']) && record.get('layer') == manualObject['layer'] && record.get('test') == manualObject['test'] && record.get('measure') == manualObject['measure'] && record.get('descriptor') == manualObject['descriptor']){
						me.showErrorMessage('selectionAlreadyAdded');
						flag = true;
						return false;
					}
				});
				if(flag)
					return false;
			}
			this.getGraphsStore().add(manualObject);
		}
	},
	
	// To delete an existing graph from the view
	deleteGraphFromView:function(button){
		var me = this;
		var records = me.getGraphsList().getSelectionModel().getSelection();
		if(Ext.isEmpty(records)){
			this.showErrorMessage('noRowIsSelected');
			return false;
		}
		var graphStore = me.getGraphsStore();
		
		Ext.Msg.show({
			title:'delete',
			msg:me.messages['deleteConfirmation'],
			buttons:9,
			buttonText:{ok:me.messages['ok'],cancel:me.messages['cancel']},
			fn:function(buttonId){
				if(buttonId == 'ok'){
					
					for(var item=records.length; item>-1 ; item--)
					{
						graphStore.remove(records[item]);
					}
					
					/*for(i=0;i<records.length;i++)
					{
						graphStore.remove(records[i]);
					//button.hide();
					}*/
				}
				else if(buttonId == 'cancel'){
					return false;
				}
			}
		});
	},

	// To validate the form on submission
	validateViewSubmit:function(button){
		//var context = '';
		var viewName = this.getViewNameField().getValue();
		var dispName = this.getGraphNameField().getValue();
		var noOfColumn = this.getNoOfColulmns().getValue();

		if(viewName!=null && (viewName.indexOf("=")>-1 || viewName.indexOf("\"")>-1 || viewName.indexOf("$")>-1)){
			Ext.Msg.alert("Error","Special Characters are not allowed in View name");
			return false;
		}
		else if(dispName!=null && (dispName.indexOf("=")>-1 || dispName.indexOf("\"")>-1 || dispName.indexOf("$")>-1) || dispName.indexOf(".")>-1){
			Ext.Msg.alert("Error","Special Characters are not allowed in Display name");
			return false;
		}
		else if(Ext.isEmpty(viewName))
		{
			//context = 'viewNameShouldNotBeBlank';
			Ext.Msg.alert("Error","View Name Should Not Blank");
			return false;
		}
		else if(!this.getConfigurePanel().isModify && !Ext.isEmpty(this.availableViews))
		{

		//	if(this.availableViews.indexOf(this.getViewNameField().getValue()) > -1 ) 
		//	{
				
				for(i=0 ;i<this.availableViews.length;i++)
				{
					
					if(this.availableViews[i].toUpperCase() == viewName.toUpperCase())
					{
						//context = 'viewNameAlreadyExists';
						Ext.Msg.alert("Error","View Name Already Exists");
						return false;
					}
				}
			//}
		}

		
		if(noOfColumn < 0){
			Ext.Msg.alert("Error","Negative value not allowed");
			return false
			
		}
		

		if(this.getGraphsStore().getCount() == 0)
		{
			//context = 'noOptionsChoosen';
			Ext.Msg.alert("Error","No Options Choosen");
			return false;
		}

		var refreshRateFieldValue= this.getRefreshRateField().getValue();
		if(!Ext.isEmpty(refreshRateFieldValue))
			refreshRateFieldValue = String(refreshRateFieldValue);
		
		if(Ext.isEmpty(refreshRateFieldValue))
		{
			//context = 'refreshRateNotProvided';
			Ext.Msg.alert("Error","Refresh Rate Not Provided");
			return false;
		}
		else if(refreshRateFieldValue.indexOf(".") > -1)
		{
			Ext.Msg.alert("Error","Decimal value not allowed in Refresh Rate");
			return false;
		}
		else if(refreshRateFieldValue < 60  )
		{
			//context = 'minimumRefreshRate60Sec';
			Ext.Msg.alert("Error","Minimum Refresh Rate 60 Seconds");
			return false;
		}
		
		if(this.getSharingCombo().getValue() == 'Share' && Ext.isEmpty(this.getUserSelector().getValue()))
		{
			//context = 'selectUsersToShareView';
			Ext.Msg.alert("Error","Select Users To Share View");
			return false;
		}

		/*if(!Ext.isEmpty(context)){
			
			this.showErrorMessage(context);
			return false;
		}
		else*/
			this.addOrUpdateView(button);
	},

	// To add or update a view
	addOrUpdateView:function(button){
		var me = this;
		var viewName = this.getViewNameField().getValue();

		var hidAuditLogString = '';
		if(!Ext.isEmpty(this.hidObject) && !Ext.isEmpty(this.hidObject['hidAuditLogString'])){
			var hidAuditObject = this.hidObject['hidAuditLogString'].split('#');
			for(i=0;i<hidAuditObject.length;i++){
				//var stringExpression = hidAuditObject[i].replace(',','=>');
				var stringExpression = hidAuditObject[i].replace(',','>');
				stringExpression = stringExpression.replace(',','|');
				stringExpression = stringExpression.replace(',',':');
				stringExpression = stringExpression.replace(/\,/g,'|');
				if(stringExpression.lastIndexOf('|') == stringExpression.length-1)
					stringExpression = stringExpression.slice(0,-1);
				hidAuditLogString += stringExpression;
				if(i != hidAuditObject.length-1)
					hidAuditLogString += '#';
			}
		}

		me.gridListSelection = [];

		this.getGraphsStore().each(function(record){
			me.gridListSelection.push(record.get('valueText'));
		});

		var er_selection = 'er_selection=';
		var stringExpression = '';
		if(!Ext.isEmpty(this.gridListSelection)){
			stringExpression = this.gridListSelection[0];
			//stringExpression = this.gridListSelection[0].replace(',','=>');
			stringExpression = this.gridListSelection[0].replace(',','>');
			stringExpression = stringExpression.replace(',','|');
			stringExpression = stringExpression.replace(',',':');
			stringExpression = stringExpression.replace(/\,/g,'|');
			if(stringExpression.lastIndexOf('|') == stringExpression.length-1)
					stringExpression = stringExpression.slice(0,-1);
			/*stringExpression = stringExpression.replace("#","|HASH|");
			stringExpression = stringExpression.replace("%","|PERC|");
			stringExpression = stringExpression.replace("&","|AMPER|");
			stringExpression = stringExpression.replace("+","|PLUS|");
			stringExpression = stringExpression.replace("'","|SQ|");
			stringExpression = stringExpression.replace(",","|COMMA|");*/

					stringExpression = stringExpression.replace(/#/g,"|HASH|");
					stringExpression = stringExpression.replace(/%/g,"|PERC|");
					stringExpression = stringExpression.replace(/&/g,"|AMPER|");
					stringExpression = stringExpression.replace(/\+/g,"|PLUS|");
					stringExpression = stringExpression.replace(/\'/g,"|SQ|");
					stringExpression = stringExpression.replace(/,/g,"|COMMA|");
			er_selection += stringExpression;
			for(i=1;i<this.gridListSelection.length;i++){
				//stringExpression = this.gridListSelection[i].replace(',','=>');
				stringExpression = this.gridListSelection[i].replace(',','>');
				stringExpression = stringExpression.replace(',','|');
				stringExpression = stringExpression.replace(',',':');
				stringExpression = stringExpression.replace(/\,/g,'|');
				if(stringExpression.lastIndexOf('|') == stringExpression.length-1)
					stringExpression = stringExpression.slice(0,-1);
				/*stringExpression = stringExpression.replace("#","|HASH|");
				stringExpression = stringExpression.replace("%","|PERC|");
				stringExpression = stringExpression.replace("&","|AMPER|");
				stringExpression = stringExpression.replace("+","|PLUS|");
				stringExpression = stringExpression.replace("'","|SQ|");
				stringExpression = stringExpression.replace(",","|COMMA|");*/

				stringExpression = stringExpression.replace(/#/g,"|HASH|");
				stringExpression = stringExpression.replace(/%/g,"|PERC|");
				stringExpression = stringExpression.replace(/&/g,"|AMPER|");
				stringExpression = stringExpression.replace(/\+/g,"|PLUS|");
				stringExpression = stringExpression.replace(/\'/g,"|SQ|");
				stringExpression = stringExpression.replace(/,/g,"|COMMA|");

				er_selection += '&er_selection='+stringExpression;
			}
		}

		var sharedUser = '';
		var publicUsers = '';
		if(this.getSharingCombo().getValue() == 'Public'){
			publicUsers = this.getUserSelector().prevUsers;
			sharedUser = this.getUserSelector().publicUsers;
		}
		else if(this.getSharingCombo().getValue() == 'Share'){
			publicUsers = this.getUserSelector().prevUsers;
			var share = this.getUserSelector().getValue();
			for(i=0;(!Ext.isEmpty(share) && i<share.length);i++){
				sharedUser += share[i];
				if(i != share.length-1)
					sharedUser += '\t';
			}
		}
		else{
			publicUsers = '';
		}
		
		/*viewName = viewName.replace("#","|HASH|");
		viewName = viewName.replace("%","|PERC|");
		viewName = viewName.replace("&","|AMPER|");
		viewName = viewName.replace("+","|PLUS|");
		viewName = viewName.replace("'","|SQ|");
		viewName = viewName.replace(",","|COMMA|");*/

		viewName = viewName.replace(/#/g,"|HASH|");
		viewName = viewName.replace(/%/g,"|PERC|");
		viewName = viewName.replace(/&/g,"|AMPER|");
		viewName = viewName.replace(/\+/g,"|PLUS|");
		viewName = viewName.replace(/\'/g,"|SQ|");
		viewName = viewName.replace(/,/g,"|COMMA|");


		if(oldViewName!=null && oldViewName!=''){
			/*oldViewName = oldViewName.replace("#","|HASH|");
			oldViewName = oldViewName.replace("%","|PERC|");
			oldViewName = oldViewName.replace("&","|AMPER|");
			oldViewName = oldViewName.replace("+","|PLUS|");
			oldViewName = oldViewName.replace("'","|SQ|");
			oldViewName = oldViewName.replace(",","|COMMA|");*/



			oldViewName = oldViewName.replace(/#/g,"|HASH|");
			oldViewName = oldViewName.replace(/%/g,"|PERC|");
			oldViewName = oldViewName.replace(/&/g,"|AMPER|");
			oldViewName = oldViewName.replace(/\+/g,"|PLUS|");
			oldViewName = oldViewName.replace(/\'/g,"|SQ|");
			oldViewName = oldViewName.replace(/,/g,"|COMMA|");
		}
		
		if(!Ext.isEmpty(hidAuditLogString) && hidAuditLogString!=null && hidAuditLogString!=undefined && hidAuditLogString!='null' && hidAuditLogString!='undefined')
			hidAuditLogString = window.opener.filterEncode(hidAuditLogString);

		viewName = window.opener.filterEncode(viewName);

		var queryParameters = {
			modify:this.getConfigurePanel().isModify,
			publicUsers:publicUsers,
			shareUsers:sharedUser,
			$_previousUser:this.hidObject['previousUser'],
			view_name:viewName,
			old_view_name:oldViewName,
			er_view:this.getViewBase().getValue().viewBasedOn,
			er_timeline:this.getTimelineCombo().getValue(),
			er_refrate:this.getRefreshRateField().getValue(),
			er_maxview:this.getCommonMax().getValue().commonMax,
			er_interval:this.getIntervalCombo().getValue(),
			er_otherTime:this.getOtherIntervalCombo().getValue(),
			er_sharing:this.getSharingCombo().getValue(),
			$_Sharing:this.getSharingCombo().getValue(),
			er_gp_col:this.getNoOfColulmns().getValue(),
			er_history:(this.getLookbackCheck().getValue()?'on':'off'),
			er_integrate:this.getNoOfTimesCombo().getValue(),
			hidPreviousName:viewName,
			hidPreviousNoOfColm:this.hidObject['noOfColumns'],
			hidPreviousCompTest:this.hidObject['viewBasedOn'],
			hidPreviousLookback:(this.hidObject['lookback'] == 'true'?'checked':''),
			hidPreviousTimeLine:this.hidObject['timeline'],
			hidPreviousRefreshRate:this.hidObject['refreshRate'],
			hidPreviousCommonMaximum:this.hidObject['commonMaximum'].toUpperCase(),
			hidPreviousInterval:this.hidObject['interval'],
			hidPreviousNoOfTimes:this.hidObject['noOfTimes'],
			hidAuditLogString:hidAuditLogString,
			hidPreviousOtherTimeLine:this.getOtherIntervalCombo().getValue(),
		};

		this.getMain().setLoading(true,true);
		Ext.Ajax.request({
			url:'/final/monitor/livegraph/Eglivegraphconfigp.jsp?'+encodeURI(er_selection),
			params:queryParameters,
			method:'GET',
			disableCaching:false,
			success:function(response){
				var json = "";
				try {
					json =  Ext.decode(response.responseText);
				} catch (ex) {
					window.opener.location.href='/final/servlet/com.egurkha.Logout?errmsg=1';
					self.close();
				}
				if(json.status == 'success'){				
					if(!readonlyFlag)
						readonlyFlag = true;
				
				//Ext.getCmp('View_tbseparator').show();
				Ext.getCmp('Config_tbseparator').show();
					me.openGraphView('/final/monitor/livegraph/EgLiveGraphDisplay.jsp?view_name='+encodeURI(viewName));
					tmpViewName=viewName;
				}
			},
			failure:function(){
				//alert('Failed to upload data to Database server!');
				me.getMain().setLoading(false);
				window.opener.location.href='/final/servlet/com.egurkha.Logout?errmsg=1';
				self.close();
			}
		});
		if(!Ext.isEmpty(button.up('window')))
			button.up('window').close();
	},

	// To delete a view from list
	deleteViewList:function(button){
	
	//alert('------------deleteViewList');
		var me = this;
		var records = me.getAvailableViews().getSelectionModel().getSelection();
		if(Ext.isEmpty(records)){
			this.showErrorMessage('noItemsSelected');
			return false;
		}
		Ext.Msg.show({
			title:'delete',
			msg:this.messages['deleteConfirmation'],
			buttons:9,
			buttonText:{ok:this.messages['ok'],cancel:this.messages['cancel']},
			fn:function(buttonId){
				if(buttonId == 'ok'){
					var viewsName = [];
					me.getMain().setLoading(true,true);
					for(i=0;i<records.length;i++){
						viewsName.push(records[i].get('viewName'));
					}
					Ext.Ajax.request({
						url:'/final/monitor/livegraph/Eglivegraphconfigp.jsp',
						params:{
							command:'DEL',
							view_name:viewsName
						},
						success:function(response){
							var json ="";
							try {
								json =  Ext.decode(response.responseText);
							} catch (ex) {
								window.opener.location.href='/final/servlet/com.egurkha.Logout?errmsg=1';
								self.close();
							}
							if(json.status == 'deleted'){
								me.openViewList();
							}
							me.getMain().setLoading(false);
						},
						failure:function(){
							//alert('Failed to delete view!');
							me.getMain().setLoading(false);
							window.opener.location.href='/final/servlet/com.egurkha.Logout?errmsg=1';
							self.close();
						}
					});
				}
				else if(buttonId == 'cancel'){
					return false;
				}
			}
		});
	},

	// To delete the view from view list link
	deleteView:function(deleteUrl){
		var me = this;
		Ext.Msg.show({
			title:'delete',
			msg:this.messages['deleteConfirmation'],
			buttons:9,
			buttonText:{ok:this.messages['ok'],cancel:this.messages['cancel']},
			fn:function(buttonId){
				if(buttonId == 'ok'){
					me.getMain().setLoading(true,true);
					Ext.Ajax.request({
						url:deleteUrl,
						success:function(response){
							var json = Ext.decode(response.responseText);
							if(json.status == 'deleted'){
								me.openViewList();
								me.getMain().setLoading(false);
							}
						},
						failure:function(){
							alert('Failed to delete view!');
							me.getMain().setLoading(false);
						}
					});
				}
				else if(buttonId == 'cancel'){
					return false;
				}
			}
		});
	},

	// To delete view from form
	deleteViewForm:function(button){
		var me = this;
		Ext.Msg.show({
			title:'delete',
			msg:this.messages['deleteConfirmation'],
			buttons:9,
			buttonText:{ok:this.messages['ok'],cancel:this.messages['cancel']},
			fn:function(buttonId){
				if(buttonId == 'ok'){
					me.getMain().setLoading(true,true);
					Ext.Ajax.request({
						url:'/final/monitor/livegraph/Eglivegraphconfigp.jsp',
						params:{
							command:'DEL',
							view_name:me.getViewNameField().getValue()
						},
						success:function(response){
							var json = "";
							try {
								json =  Ext.decode(response.responseText);
							} catch (ex) {
								window.opener.location.href='/final/servlet/com.egurkha.Logout?errmsg=1';
								self.close();
							}
							if(json.status == 'deleted'){
								win.hide();
								me.openViewList();
								//Ext.getCmp('View_tbseparator').hide();
								Ext.getCmp('Config_tbseparator').hide();
							//	alert('deleted Json---');
								me.getMain().setLoading(false);
							}
						},
						failure:function(){
							//alert('Failed to delete view!');
							me.getMain().setLoading(false);
							window.opener.location.href='/final/servlet/com.egurkha.Logout?errmsg=1';
								self.close();
						}
					});
				}
				else if(buttonId == 'cancel'){
					return false;
				}
			}
		});
	},

	// To set a view as default
	setDefaultView:function(requestUrl){
		var me = this;
		this.getMain().setLoading(true,true);
		Ext.Ajax.request({
			url:requestUrl,
			disableCaching:false,
			success:function(response){
				me.openViewList();
				me.getMain().setLoading(false);
			},
			failure:function(){
				alert('Failed to change the default view!');
				me.getMain().setLoading(false);
			}
		});
	},
	
	// To hide the selected shared views from list
	hideView:function(button){
		var me = this;
		var records = this.getSharedViews().getSelectionModel().getSelection();
		var store = this.getSharedViews().getStore();
		if(!Ext.isEmpty(records)){
			for(i=0;i<records.length;i++){
				var viewUser = records[i].get('viewName') + '$' + records[i].get('userName');
				Ext.Ajax.request({
					url:'/final/monitor/livegraph/EgLiveGraphListp.jsp',
					params:{
						view1:viewUser,
						modi:'false',
						selectHiddenAll:'off',
						view_name1:viewUser
					},
					success:function(response){
						var json = Ext.decode(response.responseText);
						me.getHideViewButton().hide();
						me.getShowViewButton().show();

						if(i==(records.length))
						{
							me.openViewList();
						}
					},
					failure:function(){
						alert('Failed to hide view(s)!');
					}
				});
			}
		}
		else{
			this.showErrorMessage('noItemsSelected');
			this.getMain().setLoading(false);
		}
		//this.openViewList();
	},

	showView:function(button){
		var me = this;
		if(me.hiddenGraphs.length > 0){
			for(j=0;j<me.hiddenGraphs.length;j++){
				Ext.Ajax.request({
					url:'/final/monitor/livegraph/EgHiddenLiveGraphListp.jsp',
					params:{
						view1:me.hiddenGraphs[j],
						isModify:'false',
						hidden_view_name:me.hiddenGraphs[j]
					},
					success:function(response){
						var json = Ext.decode(response.responseText);
						//button.hide();
						me.getShowViewButton().hide()
						me.getHideViewButton().show();

						if(j==(me.hiddenGraphs.length))
						{
							me.openViewList();
						}
					},
					failure:function(){
						alert('Failed to hide view(s)!');
					}
				});
			}
		}
		//this.openViewList();
	},
	
	// To display the delete graph button when atleast one row is selected from the graph grid
	graphCheckChanged:function(selModel, selected, eOpts){
		/*if(!Ext.isEmpty(selected)){
			this.getDeleteGraphButton().show();
		}
		else{
			this.getDeleteGraphButton().hide();
		}*/
	},
	
	// To display the delete graph button when atleast one row is selected from the available view grid
	availableCheckChanged:function(selModel, selected, eOpts){
		/*if(!Ext.isEmpty(selected)){
			this.getDeleteViewList().show();
		}
		else{
			this.getDeleteViewList().hide();
		}*/
	},

	// To display the delete graph button when atleast one row is selected from the shared view grid
	sharedCheckChanged:function(selModel, selected, eOpts){
		/*if(!Ext.isEmpty(selected)){
			this.getHideViewButton().setText('Hide Selected Views');
		}
		else{
			this.getHideViewButton().setText('Show Hidden Views');
		}*/
	},
	
	// To handle the functionalities when a value is selected in combo box of viewoptions panel
	viewOptionsComboSelect:function(combo,newValue,oldValue,eOpts){
		var usrName=requestParams.usrName;
		if(combo.getItemId() == 'interval'){
			if(newValue == 180){
				this.getOtherIntervalCombo().show();
				this.getNoOfTimesCombo().setDisabled(true);
				this.getNoOfTimesCombo().hide();
			}
			else{
				this.getOtherIntervalCombo().hide();
				this.getNoOfTimesCombo().setDisabled(false);
				this.getNoOfTimesCombo().show();
			}
			return true;
		}
		if(combo.getItemId() == 'sharing'){
			if(newValue == 'Private'){
				this.getUserSelector().hide();
				return false;
			}
			this.getMain().setLoading(true,true);
			var me = this;
			//var url_shar='/final/servlet/com.eg.ErRemoteScriptingServlet?C=&P0=[]&P1=[livegraph]';
			var url_shar='/final/servlet/com.eg.ErRemoteScriptingServlet?C=&P0=[]&P1=[livegraph]&P2=['+usrName+']';
			Ext.Ajax.request({
				url:encodeURI(url_shar),
				method:'POST',
				params:{
					from:'live_graph',
					//F:'getValidUsers'
					F:'getValidUsersNew'
				},
				success:function(response){
					var allUsers = "";
					try {
						allUsers =  Ext.decode(response.responseText);
					} catch (ex) {
						window.opener.location.href='/final/servlet/com.egurkha.Logout?errmsg=1';
						self.close();
					}
					if(me.hidObject.sharing == 'Public')
						me.getUserSelector().prevUsers = allUsers.allUsersString;
					me.getUserSelector().publicUsers = allUsers.allUsersString;
					var tmp_Url='/final/servlet/com.eg.ErRemoteScriptingServlet?C=&P0=['+me.hidObject.reportName+']&P1=[Share]&P2=[livegraph]'
					if(newValue == 'Share'){
						Ext.Ajax.request({
							url:encodeURI(tmp_Url),
							method:'POST',
							params:{
								from:'live_graph',
								F:'getGraphsExistingUsers'
							},
							success:function(response){
								me.getUserSelector().show();
								var sharedUsers ="";
								try {
									sharedUsers =  Ext.decode(response.responseText);
								} catch (ex) {
									window.opener.location.href='/final/servlet/com.egurkha.Logout?errmsg=1';
									self.close();
								}
								me.getUserSelector().prevUsers = sharedUsers.sharedUsersString;
								try
								{
									me.getUsersStore().loadRawData(allUsers.users);
								}
								catch(err)
								{
									me.getUsersStore().loadData(allUsers.users);
								}
								me.getUserSelector().setValue(sharedUsers.users);
							},
							failure:function(){
								//alert('Failed to fetch the users for sharing!');
								window.opener.location.href='/final/servlet/com.egurkha.Logout?errmsg=1';
								self.close();
							}
						});
					}
					else{
						me.getUserSelector().hide();
					}
					me.getMain().setLoading(false);
				},
				failure:function(){
					alert('Failed to fetch the users for sharing!');
					me.getMain().setLoading(false);
					window.opener.location.href='/final/servlet/com.egurkha.Logout?errmsg=1';
					self.close();
				}
			});
		}
	},
	
	// To open respective graph view
	openGraphView:function(graphUrl){
		var me = this;
		this.getMain().setLoading(true,true);
		this.getLiveToolbar().setDisabled(true);
		//this.getIconViewOptions().show();
		this.getIconViewConfig().show();
		//this.getIconViewOptions().setDisabled(true);
		this.getIconViewConfig().setDisabled(true);
		Ext.Ajax.request({
			url:graphUrl,
			success:function(response){
				var json = "";
				try {
					json =  Ext.decode(response.responseText);
				} catch (ex) {
					window.opener.location.href='/final/servlet/com.egurkha.Logout?errmsg=1';
					self.close();
				}
				me.getMain().setTitle(json.screenLabels.title);
				if(Ext.isEmpty(json) || Ext.isEmpty(json.viewName)){
					me.getMain().setLoading(false);
					me.getLiveToolbar().setDisabled(false);
					//me.getIconViewOptions().setDisabled(false);
					me.getIconViewConfig().setDisabled(false);
					me.openViewList();
					return false;
				}
				if(json.shared == 'true'){
					//me.getIconViewOptions().hide();
					me.getIconViewConfig().hide();
				}
				else if(json.shared == 'false'){
					//me.getIconViewOptions().show();
					me.getIconViewConfig().show();
				}

				var resultItems=me.getMain().items.items;
		
				for(var item=resultItems.length-1; item>-1 ; item--)
				{
					resultItems[item].destroy();
				}

				me.getMain().removeAll();
				var isChecked = json.showLegend;
				isChecked = (isChecked == 'false' || isChecked == 'no' )?0:1;
				me.getMain().add({
					xtype: 'toolbar',
					dock: 'top',
					padding:'0 0',
					ui:'footer',
					items: [
						'->',{
					xtype:'checkboxgroup',
					cls: 'checkbt',
					id: 'er_chart_checkbox',
					layout: {
						type : 'hbox',
						pack : 'end',
						align : 'right'
					},
					margin:'0 0 0 0',
					items: [{
						boxLabel: 'Show Legends',
						inputValue: 'true',
						id: 'showLegend',						
						checked:isChecked
						 }]
				}]
						});
				me.getMain().suspendEvents(true);
				me.getMain().add({
					xtype:'graphcontainer',
					//cls:'datapanel',
					suspendLayout:true,
					border:false,
					autoDestroy:true,
					frame:false,
					graphsData:json
				});
				me.getMain().resumeEvents();
				//	alert('graphcontainer--');
						//Ext.getCmp('View_tbseparator').show();
				Ext.getCmp('Config_tbseparator').show();
				Ext.getCmp('LiveGraph_hometab').show();
				Ext.getCmp('LiveGraph_viewtab').show();
				
				var refreshRateValue = me.getGraphContainer().graphsData.refreshRate;			

				me.currentView = json.viewName;
				tmpViewName=json.viewName;
			/*	me.graphsTimeout = setInterval(function(){
					me.openGraphViewAutoRefresh(graphUrl);
				},parseInt(refreshRateValue));*/

				me.getMain().setLoading(false);
				me.getLiveToolbar().setDisabled(false);
				//me.getIconViewOptions().setDisabled(false);
				me.getIconViewConfig().setDisabled(false);
					Ext.getCmp('iconAutomaticScrollStop').hide();
				if($('#myPanel-innerCt').height() > $('#myPanel-body').height()){					//autoscroll show/hide functionality
					//Ext.getCmp('auto_separator').show();
					//Ext.getCmp('iconAutomaticScrollRun').show();
					//Ext.getCmp('iconAutomaticScrollJumpToTop').show();
					//Ext.getCmp('TabSeperator').show();
				}else{
					Ext.getCmp('auto_separator').hide();
					Ext.getCmp('iconAutomaticScrollRun').hide();
					Ext.getCmp('iconAutomaticScrollJumpToTop').hide();
					Ext.getCmp('TabSeperator').hide();
				}
				console.log($('#myPanel-body').height());
				console.log($('#myPanel-innerCt').height());
				console.log($('#myPanel-innerCt').scrollHeight +'+'+ $('#myPanel-body').innerHeight());
			},
			failure:function(){
				alert('Failure to load graph view!');
				me.getMain().setLoading(false);
				me.getLiveToolbar().setDisabled(false);
				//me.getIconViewOptions().setDisabled(false);
				me.getIconViewConfig().setDisabled(false);
				window.opener.location.href='/final/servlet/com.egurkha.Logout?errmsg=1';
				self.close();
			}
		});
	},

	openGraphViewAutoRefresh:function(graphUrl){
		
		var me = this;
		this.getMain().setLoading(true,true);
		this.getLiveToolbar().setDisabled(true);
		//this.getIconViewOptions().show();
		this.getIconViewConfig().show();
		//this.getIconViewOptions().setDisabled(true);
		this.getIconViewConfig().setDisabled(true);
		Ext.Ajax.request({
			url:graphUrl,
			success:function(response){
				var json = "";
				try {
					json =  Ext.decode(response.responseText);
				} catch (ex) {
					window.opener.location.href='/final/servlet/com.egurkha.Logout?errmsg=1';
					self.close();
				}
				me.getMain().setTitle(json.screenLabels.title);
				if(Ext.isEmpty(json) || Ext.isEmpty(json.viewName)){
					me.getMain().setLoading(false);
					me.getLiveToolbar().setDisabled(false);
					//me.getIconViewOptions().setDisabled(false);
					me.getIconViewConfig().setDisabled(false);
					me.openViewList();
					return false;
				}
				if(json.shared == 'true'){
					//me.getIconViewOptions().hide();
					me.getIconViewConfig().hide();
				}
				else if(json.shared == 'false'){
					//me.getIconViewOptions().show();
					me.getIconViewConfig().show();
				}

				var resultItems=me.getMain().items.items;
		
				for(var item=resultItems.length-1; item>-1 ; item--)
				{
					resultItems[item].destroy();
				}

				me.getMain().removeAll();
				var isChecked = json.showLegend;
				isChecked = (isChecked == 'false' || isChecked == 'no' )?0:1;
				me.getMain().add(
					{
					xtype: 'toolbar',
					dock: 'top',
					padding:'0 0',
					ui:'footer',
					items: [
						'->',{
					xtype:'checkboxgroup',
					cls: 'checkbt',
					id: 'er_chart_checkbox',
					layout: {
						type : 'hbox',
						pack : 'end',
						align : 'right'
					},
					margin:'0 20 0 0',
					items: [{
						boxLabel: 'Show Legends',
						inputValue: 'true',
						id: 'showLegend',						
						checked:isChecked
						 }]
				}]
						});

				Ext.suspendLayouts();
				me.getMain().add({
					xtype:'graphcontainer',
					//cls:'datapanel',
					border:false,
					autoDestroy:true,
					frame:false,
					graphsData:json
				});
				Ext.resumeLayouts(true);

				//	alert('graphcontainer--');
						//Ext.getCmp('View_tbseparator').show();
				Ext.getCmp('Config_tbseparator').show();
				Ext.getCmp('LiveGraph_hometab').show();
				Ext.getCmp('LiveGraph_viewtab').show();
				
				//var refreshData = me.getGraphContainer().graphsData.refreshRate;

				me.currentView = json.viewName;
				
				me.getMain().setLoading(false);
				me.getLiveToolbar().setDisabled(false);
				//me.getIconViewOptions().setDisabled(false);
				me.getIconViewConfig().setDisabled(false);

				json = null;
				Ext.destroy(json);

				resultItems = null;
				Ext.destroy(resultItems);

				isChecked = null;
				delete isChecked;
			},
			failure:function(){
				alert('Failure to load graph view!');
				me.getMain().setLoading(false);
				me.getLiveToolbar().setDisabled(false);
				//me.getIconViewOptions().setDisabled(false);
				me.getIconViewConfig().setDisabled(false);
				window.opener.location.href='/final/servlet/com.egurkha.Logout?errmsg=1';
				self.close();
			}
		});
	},
	
	// To fetch relevant data when a combo is changed
	comboSelect:function(combo,records,eOpts){
		var me = this;
		var values = '';

		if(Ext.isEmpty(combo.method))
			return false;

		if(combo.getItemId() != 'site' && (combo.getValue() == -1 || combo.getValue() == '-1')){
			this.deselectChainedCombo(combo.chainCombo);
			return false;
		}

		if(combo.getItemId() == 'layer'){
			values += '&P0='+this.getSiteCombo().getValue();
			values += '&P1='+this.getComponentCombo().getValue();
			values += '&P2='+combo.getValue();
		}
		else if(combo.getItemId() == 'measure'){
			if(this.getViewBase().getValue().viewBasedOn == 'Test')
				return false;

			values += '&P0='+this.getSiteCombo().getValue();
			values += '&P1='+this.getTestCombo().getValue();
			values += '&P2='+this.getComponentCombo().getValue();
		}
		else{
			values += '&P0='+combo.getValue();
		}

		values += '';
		if(this.getViewBase().getValue().viewBasedOn == 'Test' && combo.getItemId() == 'site')
		{
			combo.method='getTestsForSite';
			combo.chainCombo='test';
		}
		else if(this.getViewBase().getValue().viewBasedOn == 'Component' && combo.getItemId() == 'site')
		{
			combo.method='getComponentsForSite';
			combo.chainCombo='component';
		}
		
		
		Ext.Ajax.request({
			url:'/final/servlet/com.eg.ErRemoteScriptingServlet?C='+encodeURI(values),
			method:'POST',
			params:{
				from:'live_graph',
				F:combo.method
			},
			disableCaching:false,
			success:function(response){
				var json = "";
				try {
					json =  Ext.decode(response.responseText);
				} catch (ex) {
					window.opener.location.href='/final/servlet/com.egurkha.Logout?errmsg=1';
					self.close();
				}
				me.loadCombo(json,combo.chainCombo);
				var childCombo = me.getConfigurePanel().down('scrollcombo[itemId='+combo.chainCombo+']');
				if(!Ext.isEmpty(childCombo.chainCombo))
					me.deselectChainedCombo(childCombo.chainCombo);
			},
			failure:function(){
				alert('Failed to load data into '+combo.chainCombo+' combo!');
				window.opener.location.href='/final/servlet/com.egurkha.Logout?errmsg=1';
				self.close();
			}
		});
	},

	// To do Test combo related operations other than the normal
	testComboSelect:function(combo){
		var me = this;

		var descriptorLabelURL = '';
		descriptorLabelURL += '&P0='+this.getSiteCombo().getValue();
		descriptorLabelURL += '&P1='+this.getTestCombo().getValue();
		descriptorLabelURL += '&P2='+this.getComponentCombo().getValue();
		descriptorLabelURL += '';
		Ext.Ajax.request({
			url:'/final/servlet/com.eg.ErRemoteScriptingServlet?C='+descriptorLabelURL,
			method:'POST',
			params:{
				from:'live_graph',
				F:'getDescriptionForTest'
			},
			disableCaching:false,
			success:function(response){
				var json = "";
				try {
					json =  Ext.decode(response.responseText);
				} catch (ex) {
					window.opener.location.href='/final/servlet/com.egurkha.Logout?errmsg=1';
					self.close();
				}
				if(!Ext.isEmpty(json) && !Ext.isEmpty(json.descriptorLabel) && json.descriptorLabel != 'None'){
					me.getDescriptorCombo().setFieldLabel(json.descriptorLabel);
				}
			},
		});

		if(this.getViewBase().getValue().viewBasedOn == 'Test'){
			var values = '&P0=['+combo.getValue()+']';
			Ext.Ajax.request({
				url:'/final/servlet/com.eg.ErRemoteScriptingServlet?C='+values,
				method:'POST',
				params:{
					from:'live_graph',
					F:'getComponentsForTest'
				},
				disableCaching:false,
				success:function(response){
					var json ="";
					try {
					json =  Ext.decode(response.responseText);
					} catch (ex) {
						window.opener.location.href='/final/servlet/com.egurkha.Logout?errmsg=1';
						self.close();
					}
					me.loadMultiSelect(json,'componentMulti');
					var childCombo = me.getConfigurePanel().down('multiselect[itemId=componentMulti]');
					if(!Ext.isEmpty(childCombo.chainCombo)){
						me.deselectChainedMulit(childCombo.chainCombo);
					}
				},
				failure:function(){
					//alert('Failed to load data into '+combo.itemId+' combo!');
					window.opener.location.href='/final/servlet/com.egurkha.Logout?errmsg=1';
					self.close();
				}
			});
		}
	},

	// To handle the component multiselect's select event when view base is test
	componentMultiSelect:function(multi,record,eOpts){
		var me = this;
		var combo = this.getComponentMulti();
		if(Ext.isEmpty(combo.getValue()) || combo.getValue().length > 1){
			this.deselectChainedMulit(combo.chainCombo);
			return false;
		}

		var values = '&P0=['+(Ext.isEmpty(this.getSiteCombo().getValue())?"NULL":this.getSiteCombo().getValue());
		values += ']&P1=['+this.getTestCombo().getValue();
		values += ']&P2=['+encodeURI(combo.getSubmitValue());
		values += ']';

		Ext.Ajax.request({
			url:'/final/servlet/com.eg.ErRemoteScriptingServlet?C='+values,
			method:'POST',
			params:{
				from:'live_graph',
				F:combo.method
			},
			disableCaching:false,
			success:function(response){
				var json = "";
				try {
					json =  Ext.decode(response.responseText);
				} catch (ex) {
					window.opener.location.href='/final/servlet/com.egurkha.Logout?errmsg=1';
					self.close();
				}
				me.loadMultiSelect(json,combo.chainCombo);
			},
			failure:function(){
				//alert('Failed to load data into '+combo.chainCombo+' combo!');
				window.opener.location.href='/final/servlet/com.egurkha.Logout?errmsg=1';
				self.close();
			}
		});	
	},

	// To handle the change of view base between component and test
	changeViewBase:function(radiogroup,newValue,oldValue,eOpts){
		var me = this;
		var viewChangeUrl = 'EgLiveGraphConfig.jsp?fromGoToView=true&modify=true&view_name='+encodeURI(this.getViewNameField().getValue())+'&er_view='+newValue.viewBasedOn;

		this.getMain().setLoading(true,true);
		Ext.Ajax.request({
			url:viewChangeUrl,
			success:function(response){
				var json = "";
				try {
					json =  Ext.decode(response.responseText);
				} catch (ex) {
					window.opener.location.href='/final/servlet/com.egurkha.Logout?errmsg=1';
					self.close();
				}
				me.getConfigurePanel().setData(json);
				me.getMain().setLoading(false);
				if(newValue.viewBasedOn == 'Test'){
					me.getLayerColumn().hide();
					me.getGraphsStore().clearFilter();
					me.getGraphsStore().filter('check','test');
				}
				else if(newValue.viewBasedOn == 'Component'){
					me.getLayerColumn().show();
					me.getGraphsStore().clearFilter();
					me.getGraphsStore().filter('check','component');
				}
			},
			faliure:function(){
				//alert('Failed to load the new view base!');
				me.getMain().setLoading(false);
				window.opener.location.href='/final/servlet/com.egurkha.Logout?errmsg=1';
				self.close();
			}
		});
	},

	// To get confirmation from user whether to change or not the current view
	viewBaseConfirmation:function(radiogroup,newValue,oldValue,eOpts){
		/*var me = this;
		if(!readonlyFlag){*/
			this.changeViewBase(radiogroup,newValue,oldValue,eOpts);
			/*return false;
		}
		var msg = '';
		if(newValue.viewBasedOn == 'Test')
			msg = this.messages['changeFromComponentToTest'];
		else if(newValue.viewBasedOn == 'Component')
			msg = this.messages['changeFromTestToComponent'];

		Ext.Msg.show({
			title:'',
			msg:msg,
			buttons:9,
			buttonText:{ok:this.messages['ok'],cancel:this.messages['cancel']},
			fn:function(buttonId){
				if(buttonId == 'ok')
					me.changeViewBase(radiogroup,newValue,oldValue,eOpts);
				else if(buttonId == 'cancel'){
					me.getViewBase().suspendEvents(false);
					me.getViewBase().setValue({viewBasedOn:oldValue});
					me.getViewBase().resumeEvents();
				}
			}
		});*/
	},

	// Common function to display error messages
	showErrorMessage:function(msgContext){
		var msg = this.messages[msgContext];
		if(msgContext == 'viewNameAlreadyExists'){
			msg = msg.replace('<>',' \''+this.getViewNameField().getValue()+'\' ');
		}
		Ext.Msg.alert('Live Graph',msg);
	},

	// To deselect and remove data loaded in chained combo when changes made to the previous combos
	deselectChainedCombo:function(itemId){
		var combo = this.getConfigurePanel().down('scrollcombo[itemId='+itemId+']');
		if(!Ext.isEmpty(combo.chainCombo)){
			this.deselectChainedCombo(combo.chainCombo);
		}
		if(itemId == 'descriptor')
			combo.setFieldLabel(combo.actualLabel);
		this.loadCombo(this.emptyCombo,itemId);
		return true;
	},

	// To deselect and remove data loaded in chained multiselect when changes made to the previous combos
	deselectChainedMulit:function(itemId){
		var combo = this.getConfigurePanel().down('multiselect[itemId='+itemId+']');
		if(!Ext.isEmpty(combo.chainCombo)){
			this.deselectChainedMulit(combo.chainCombo);
		}
		if(itemId == 'descriptor')
			combo.setFieldLabel(combo.actualLabel);
		this.loadMultiSelect(this.emptyCombo,itemId);
		return true;
	},

	// Generic function to load data to dependent combo when a combo is selected
	loadCombo:function(json,itemId){
		var combo = this.getConfigurePanel().down('scrollcombo[itemId='+itemId+']');
		if(!Ext.isEmpty(json.combo)){
			combo.getStore().loadData(json.combo,false);
			if(!Ext.isEmpty(json.values))
				combo.setValue(json.values);
		}
		combo.doComponentLayout();
	},

	loadMultiSelect:function(json,itemId){
		var combo = this.getConfigurePanel().down('multiselect[itemId='+itemId+']');
		if(!Ext.isEmpty(json.combo)){
			var data = json.combo;
			if(data.length > 1)
				data.splice(0,1)
			combo.getStore().removeAll(true);
			try{
				combo.getStore().loadRawData(data,false);
				
				if(!Ext.isEmpty(data))
				{
					combo.setValue(data[0].value);
				}
			}
			catch(e){
				combo.getStore().loadData(data,false);
			}
		}
	},

	// Generic function to get the displayField value of the combo box
	getComboDisplayValue:function(itemId,valueField){
		var comboItemId = (itemId == 'componentType')?'component':itemId;
		var combo = this.getConfigurePanel().down('scrollcombo[itemId='+comboItemId+']');
		var value = '';
		combo.getStore().each(function(record){
			if(record.get('value') == valueField){
				if(itemId == 'componentType'){
					value = record.get('display');
					value = value.substring(value.lastIndexOf(':')+1);
				}
				else if(itemId == 'component'){
					value = record.get('display');
					value = value.substring(0,value.indexOf(':'));
				}
				else if(itemId == 'descriptor' && (valueField == -1 || valueField == '-1')){  // kaliraj
					
					
					value = '-';
				}
				else if(itemId == 'descriptor' && (valueField == -2 || valueField == '-2')){  // kaliraj
					
				
					value = '-';
				}
				
				else
					value = record.get('display');
				
				return value;
				
			}
		});
		return value;
	},

	// Generic function to get the displayField value of the multiselect field
	getMultiselectDisplayValue:function(itemId,valueField){
		var comboItemId = (itemId == 'componentType')?'componentMulti':itemId;
		var combo = this.getConfigurePanel().down('multiselect[itemId='+comboItemId+']');
		var value = '';
		combo.getStore().each(function(record){
			if(record.get('value') == valueField){
				if(itemId == 'componentType'){
					value = record.get('display');
					value = value.substring(value.lastIndexOf(':')+1);
				}
				else if(itemId == 'componentMulti'){
					value = record.get('display');
					value = value.substring(0,value.indexOf(':'));
				}
				else if(itemId == 'descriptorMulti' && (valueField == -1 || valueField == '-1')){
					value = '-';
				}
				else
					value = record.get('display');
				return false;
			}
		});
		return value;
	},

	maximizedGraph:function(url){
		Ext.create('Ext.window.Window',{
			height:600,
			width:870,
			title:'Graph',
			draggable:true,
			autoDestroy:true,
			closable:true,
			closeAction:'destroy',
			refreshRate:this.getGraphContainer().graphsData.refreshRate,
			//refreshRate:60000,
			id:'maximizedView',
			itemId:'maxWindow',
			title:'',
			url:url,
			items:[{
				xtype:'box',
				html:'<div id="maxWindow"></div>'
			}],
			listeners:{
				show:this.showMaxWindow,
				close:this.closeMaxGraphWindow
			},
		}).show();
	},

	closeMaxGraphWindow:function(){
		var windw = Ext.getCmp('maximizedView');
		clearTimeout(windw.timeout);
		windw.destroy();
	},

	showMaxWindow:function(window){
		window.setLoading(true,true);
		var errMsg = "<table border='0' height='100%' width='100%'><tr><td align='center'><img src='/final/monitor/eg_images/gray/graph_error_message.gif'></td></tr></table>";
		Ext.Ajax.request({
			url: window.url,
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 )
				{
					var jsonText = response.responseText;
					var jsonRData = null;
					if ( !Ext.isEmpty( jsonText ) )
					{
						if(jsonText == null || jsonText == undefined)
						{
							window.update(errMsg);
						}
						else
						{
							jsonRData = Ext.decode( jsonText );
							try
							{
								var lineChart = {};
								jsonRData['enableTitle'] = true;
								lineChart = jQuery.extend(true, {}, getHighChartsForLiveGraph(window.getItemId(),window.getHeight()-50,window.getWidth()-50,'close'), lineChart);
								lineChart.setData(jsonRData,currentDateFormat_js,'close','','right');
								lineChart.drawChart();

								window.timeout = setTimeout(function(){
									LiveGraph.app.getController('Main').showMaxWindow(window);
								},parseInt(window.refreshRate));
							}
							catch (e)
							{
								alert("e::"+e)
							}
						}
					}
				}
				window.setLoading(false);
			},
			failure:function(){
				window.update(errMsg);
				window.setLoading(false);
			}
		});
	},

	displayViewSettings:function(button){
		if(!Ext.isEmpty(Ext.getCmp('maximizedView'))){
			clearTimeout(Ext.getCmp('maximizedView').timeout);
			Ext.getCmp('maximizedView').destroy();
		}
		clearTimeout(this.graphsTimeout);

		/* if(button.getItemId() == 'iconViewOptions'){
			win.removeAll(true);
			displayWindow = Ext.create('Ext.window.Window',{
				title:'Configure Dashboard',
				autoDestroy:true,
				height:300,
				width:870,
				id:'viewOptionsWindow',
				layout:'fit',
				items:[{
					xtype:'scrollpanel',					
					autoScroll:true,
					scroll:false,
					defaults:{
						type:'vbox',
						align:'stretch'
					},
					items:[{
						xtype:'viewpanel',
						url:'/final/monitor/livegraph/EgLiveGraphConfig.jsp?modify=true&view_name='+this.currentView,
						from:'displaySettings'
					}]
				}]
			}).show();
		}
		else */ if(button.getItemId() == 'iconViewConfig'){
			if(!Ext.isEmpty(displayWindow))
				displayWindow.removeAll(true);
			var tempView = this.currentView;
			tempView = tempView.replace(/#/g,"|HASH|");
			tempView = tempView.replace(/%/g,"|PERC|");
			tempView = tempView.replace(/&/g,"|AMPER|");
			tempView = tempView.replace(/\+/g,"|PLUS|");
			tempView = tempView.replace(/\'/g,"|SQ|");
			tempView = tempView.replace(/,/g,"|COMMA|");
			this.openViewConfig('/final/monitor/livegraph/EgLiveGraphConfig.jsp?modify=true&view_name='+tempView);
		}
	},

	lookbackChange:function(checkbox,newValue,oldValue,eOpts){
		this.getIntervalCombo().setDisabled(!newValue);
		this.getOtherIntervalCombo().setDisabled(!newValue);
		this.getNoOfTimesCombo().setDisabled(!newValue);
	}
});