Ext.define('LiveGraph.view.ConfigurePanel',{
	extend:'Ext.form.Panel',
	alias:'widget.configurepanel',
	//width:'90%',
	height:'100%',
	layout:{type:'anchor',align:'stretch'},
	isModify:readonlyFlag,
	//defaults:{
	//	width:'100%'
	//},
	
	items:[{
		xtype:'container',
		layout:'column',
		cls:'formOuterContainer',
		padding:10,
		defaults:{
			columnWidth:.33,
			labelAlign:'top',
			labelSeparator:'',
			margin:'0 10 5 3',
			defaults:{
				//columnWidth:.22,
				labelAlign:'top',
				labelSeparator:'',

		}

		},
			items:[{
				//colummnWidth:.17,
				xtype:'textfield',
				cls:'textbox',
				name:'name',
				itemId:'name',
				fieldLabel:'Name'
			},{
				columnWidth:.33,
				xtype:'radiogroup',
				defaults:{cls:'radiobt'},
				fieldLabel:'View based on',
				itemId:'viewBasedOn',
				padding:'0 0 0 10',
				items:[{
					boxLabel:compTxt,
					itemId:'component',
					boxLabelAlign:'after',
					name:'viewBasedOn',
					checked:true,
					inputValue:'Component'
				},{
					boxLabel:testTxt,
					itemId:'test',
					boxLabelAlign:'after',
					name:'viewBasedOn',
					inputValue:'Test'
				}]
			},
			{
				xtype:'fieldcontainer',
				itemId:'siteContainer',
				id:'site_Container',
				items:[{
					xtype:'scrollcombo',
					cls:'dropdown',
					name:'site',
					itemId:'site',
					hidden:true,
					margin:0,
					width:250,
					editable:false,
					labelAlign:'top',
					fieldLabel:'Site',
					displayField:'display',
					valueField:'value',
					method:'getComponentsForSite',
					chainCombo:'component',
					queryMode:'local',
					autoScroll:true,
					store:Ext.create('Ext.data.Store',{
						fields:['display','value']
					})
				}]
		},{
			columnWidth:.50,
			xtype:'fieldcontainer',
			id:'fieldcontainer_1',
			layout:'column',
			columns:2,
			defaults:{
				columnWidth:.50,
				margin:'0 0 0 0',
				labelAlign:'top',
				labelSeparator:'',

			},
			itemId:'componentViewBase',
			items:[{
				xtype:'scrollcombo',
				cls:'dropdown',
				name:'component',
				itemId:'component',
				editable:false,
				fieldLabel:'Component',
				margin:'0 5 0 0',
				displayField:'display',
				valueField:'value',
				method:'getLayersForComponent',
				chainCombo:'layer',
				queryMode:'local',
				autoScroll:true,
				store:Ext.create('Ext.data.Store',{
					fields:['display','value']
				})
			},{
				xtype:'scrollcombo',
				cls:'dropdown',
				name:'layer',
				margin:'0 0 0 10',
				itemId:'layer',
				editable:false,
				fieldLabel:'Layer',
				displayField:'display',
				valueField:'value',
				method:'getTestsForLayer',
				chainCombo:'test',
				queryMode:'local',
				autoScroll:true,
				store:Ext.create('Ext.data.Store',{
					fields:['display','value']
				})
			}]
		},{
			columnWidth:.50,
			xtype:'fieldcontainer',
			id:'fieldcontainer_2',
			layout:'column',
			columns:2,
			defaults:{
				columnWidth:.50,
				margin:'0 10 0 0',
				labelAlign:'top',
				labelSeparator:'',

			},
			items:[
			{		
				xtype:'scrollcombo',
				cls:'dropdown',
				name:'test',
				itemId:'test',
				editable:false,
				fieldLabel:'Test',
				displayField:'display',
				valueField:'value',
				method:'getMeasuresForTest2',
				chainCombo:'measure',
				queryMode:'local',
				autoScroll:true,
				store:Ext.create('Ext.data.Store',{
					fields:['display','value']
				})
			},{
				xtype:'scrollcombo',
				cls:'dropdown',
				name:'measure',
				itemId:'measure',
				editable:false,
				margin:'0 0 0 5',
				fieldLabel:'Measure',
				displayField:'display',
				valueField:'value',
				method:'getInfos',
				chainCombo:'descriptor',
				queryMode:'local',
				autoScroll:true,
				store:Ext.create('Ext.data.Store',{
					fields:['display','value']
				})
			}
			]
			},
			{
			columnWidth:.50,
			xtype:'fieldcontainer',
			itemId:'testViewBase',			
			margin:'0 0 0 5',
			layout:'column',
			columns:4,
			defaults:{
				columnWidth:.50,
				labelAlign:'top',
				labelSeparator:'',

			},
			hidden:true,
			items:[{
					xtype:'container',
					layout:'vbox',
					height:120,
					items:[
						{
								xtype:'label',
								text:'Component',
						},
						{
							xtype:'container',
							layout:'hbox',

							items:[{
								xtype: 'multiselect',
								cls:'itemselector',
								margin:'5 0 0 0',							
								msgTarget: 'side',
								labelAlign:'top',
								labelStyle:'visibility:hidden',
								name: 'componentMulti',
								itemId: 'componentMulti',
								displayField:'display',
								valueField:'value',
								method:'getInfos',
								chainCombo:'descriptorMulti',
								hideLabel:true,
								queryMode:'local',
								width:180,
								height:108,							
								store:Ext.create('Ext.data.Store',{
									fields:['display','value']
								})
							}],
							
						}	
					]
			},{
				xtype:'container',
				
				layout:'vbox',
				height:120,
				items:[{
						xtype:'label',
						text:'Selection'

				},{
					xtype:'container',
					layout:'hbox',
					items:[
					{
						xtype: 'multiselect',
						msgTarget: 'side',
						cls:'itemselector',
						labelAlign:'top',
						hideLabel:true,
						width:180,
						labelStyle:'visibility:hidden',
						margin:'5 0 0 0',
						name: 'descriptorMulti',
						itemId: 'descriptorMulti',
						displayField:'display',
						valueField:'value',
						queryMode:'local',
						height:108,
						store:Ext.create('Ext.data.Store',{
							fields:['display','value']
						})
					}	
					]
				}]
				
			},
			]
		},
		{
				xtype:'fieldcontainer',
				xtype:'fieldcontainer',
				layout:'column',
				columnWidth:.50,
				columns:2,
				defaults:{
					columnWidth:.50,
					labelAlign:'top',
					labelSeparator:'',
					margin:'15 10 0 0',

				},
				items:[
					{
					xtype:'scrollcombo',
					cls:'dropdown',
					name:'descriptor',
					itemId:'descriptor',
					editable:false,
					fieldLabel:'Descriptor',
					margin:'5 4 0 0',
					displayField:'display',
					valueField:'value',
					queryMode:'local',
					autoScroll:true,
					store:Ext.create('Ext.data.Store',{
						fields: [{name:'display',convert:function(value, record){
								return Ext.String.htmlDecode(value);
							}},'value'],
					})
			},{
				xtype:'textfield',
				cls:'textbox',
				margin:'5 0 0 11',
				name:'displayName',
				itemId:'displayName',
				fieldLabel:displayNameTxt
			}	
				]
			
			
			}]
	},{
		xtype:'graphslist',
		height:155,
		margin:10,
	}],
		
	buttons:['->',{
		xtype:'button',
		cls:'button20',
		text:'Add',
		itemId:'addGraph',
		action:'addGraphToView'
	},{
		text:'Remove',
		xtype:'button',
		cls:'button20',
		itemId:'deleteGraph',
		action:'deleteGraphFromView',
		hidden:false
	},'->'],

	setData:function(json){
		// In every following element, the following order is followed
		// Screen Labels of the form element captions and labels is Set at first
		// Then the data to the respective form element is Set

		// Return false if there is no data to fill the form
		if(Ext.isEmpty(json.viewFormData))
			return false;

		var viewBase = json.currentSelection.viewBasedOn;

		// Sets View based on radiogroup
		var viewBaseRadio = this.down('radiogroup[itemId=viewBasedOn]');
		viewBaseRadio.getComponent('component').boxLabel = json.screenLabels.radioComponent;
		viewBaseRadio.getComponent('test').boxLabel = json.screenLabels.radioTest;
		if(!Ext.isEmpty(json.currentSelection.viewBasedOn)){
			viewBaseRadio.suspendEvents(false);
			viewBaseRadio.setValue({viewBasedOn:viewBase});
			viewBaseRadio.resumeEvents();
		}

		if(viewBase == 'Test'){
			this.down('fieldcontainer#componentViewBase').hide();
			this.down('fieldcontainer#testViewBase').show();
			this.down('multiselect#componentMulti').setDisabled(false);
			this.down('multiselect#descriptorMulti').setDisabled(false);
			this.down('combo#descriptor').hide();
			this.loadMultiSelect(json,'componentMulti');
			this.loadMultiSelect(json,'descriptorMulti');
		}
		else if(viewBase == 'Component'){
			this.down('fieldcontainer#componentViewBase').show();
			this.down('combo#descriptor').show();
			this.down('fieldcontainer#testViewBase').hide();
			this.down('multiselect#componentMulti').setDisabled(true);
			this.down('multiselect#descriptorMulti').setDisabled(true);
			this.loadCombo(json,'component');
			this.loadCombo(json,'layer');
			this.loadCombo(json,'descriptor');
		}

		// Sets view name textfield
		var viewName = this.down('textfield[itemId=name]');
		viewName.setFieldLabel(json.screenLabels.name);
		if(!Ext.isEmpty(json.viewFormData.name)){
			viewName.setValue(json.viewFormData.name);
		}

		this.isModify = readonlyFlag;
		viewName.setReadOnly(false);
		viewName.setBorder(!readonlyFlag);

		// Sets all combos
		this.loadCombo(json,'site');
		this.loadCombo(json,'test');
		this.loadCombo(json,'measure');

		this.down('button[itemId=addGraph]').setText(json.screenLabels.add);
		this.down('button[itemId=deleteGraph]').setText(json.screenLabels.remove);
	},

	loadCombo:function(json,itemId){
		var combo = this.down('scrollcombo[itemId='+itemId+']');
		if(Ext.isEmpty(json.screenLabels[itemId+'Combo'])){
			combo.hide();
			return false;
		}
		else{
			combo.setFieldLabel(json.screenLabels[itemId+'Combo']);
			if(combo.isHidden())
				combo.show();
			if(itemId == 'descriptor')
				combo.actualLabel = json.screenLabels[itemId+'Combo'];
			if(!Ext.isEmpty(json.viewFormData[itemId+'sComboData'])){
				combo.getStore().removeAll(true);
				combo.getStore().loadRawData(json.viewFormData[itemId+'sComboData']);
				var selection = json.currentSelection[itemId+'Combo'];
				if(!Ext.isEmpty(selection))
					combo.setValue(selection);
				else
					combo.setValue('-1');
			}
		}
	},

	loadMultiSelect:function(json,itemId){
		var combo = this.down('multiselect[itemId='+itemId+']');
		combo.setFieldLabel(json.screenLabels[itemId+'Combo']);
		if(itemId == 'descriptorMulti')
			combo.actualLabel = json.screenLabels[itemId+'Combo'];
		if(!Ext.isEmpty(json.viewFormData[itemId+'sComboData'])){
			combo.getStore().removeAll(true);
			try{
				combo.getStore().loadRawData(json.viewFormData[itemId+'sComboData']);
			}
			catch(e){
				combo.getStore().loadData(json.viewFormData[itemId+'sComboData']);
			}
		}
	},

	initComponent:function(){
		this.callParent();
	}
});