Ext.define('LiveGraph.view.Graph',{
	extend: 'Ext.panel.Panel',
	alias: 'widget.graph',
	height:250,
	bodyPadding:0,
	width:'100%',
	chartTitle:'',
	frame:false,
	//draggable:true,
	margin:5,
	autoDestroy:true,
	 draggable: {
        moveOnDrag: false,
    },
	initComponent:function(){
		this.callParent();

		var me = this;
		this.update(this.chartHtml);

		Ext.Ajax.request({
			url:this.url,
			 async: true,
			success:function(response){
				var jsonData = Ext.decode(response.responseText);
				if(!Ext.isEmpty(me.chartTitle))
					me.setTitle('<div class="livegrpahfont">'+me.chartTitle+'</div>');
				else
					me.setTitle('<div  class="livegrpahfont">'+jsonData.title+'</div>');
				
				if(Ext.isEmpty(jsonData.errorMsg))
				{
					var refInterval = me.refreshRateValue;
					var lineChart = {};
					Ext.suspendLayouts();
					jsonData['enableTitle'] = true;
					lineChart = jQuery.extend(true, {}, getHighChartsForLiveGraph(me.getItemId(),me.getHeight()-30,me.getWidth()-50,me.url), lineChart);
					lineChart.setData(jsonData,currentDateFormat_js,me.url,'','right',refInterval);
					lineChart.drawChart();
					Ext.resumeLayouts(true);
					jsonData = null;
					Ext.destroy(jsonData);
	 				lineChart = null;
					Ext.destroy(lineChart);
				}
				else
				{
					var errorMsg = '<div  class="livegrpahfont f12-bold" style="text-align:center;margin-top:15px;">'+jsonData.title+'</div>'
					errorMsg +='<div style="text-align:center;margin-top:15%"><div class="iconInformation" style="margin:0px auto"></div><div class="list-empty-text">'+jsonData.errorMsg+'</div></div>'
					Ext.fly(me.getItemId()).update(errorMsg);
				}
				/*$(function() {
					Highcharts.setOptions({
						global : {
							useUTC : false
						}
					});
					chartDesign = $('#'+me.getItemId()).highcharts('StockChart', {
						chart : {
							events : {
								load : function() {
									
								}
							}
						},
					
						colors : jsonData.colors,
						series : [{
							//name : 'Random data',
							data :jsonData.DataSet[0].data,
							
						}],
				
					});
					delete chartDesign;
				});*/

				//Ext.resumeLayouts(true);
				/*var lineChart = {
				};
				Ext.suspendLayouts();
				lineChart = jQuery.extend(true, {}, getHighCharts(me.getItemId(),me.getHeight(),me.getWidth(),me.url), lineChart);
				lineChart.setData(jsonData,currentDateFormat_js,me.url,'','right');
				lineChart.drawChart();
				Ext.resumeLayouts(true);

				jsonData = null;
				Ext.destroy(jsonData);

				lineChart = null;
				Ext.destroy(lineChart);*/
			},
			failure:function(){
				alert('Failed to load Graphs!');
			}
		});
	}
});