Ext.define('LiveGraph.view.GraphContainer',{
	extend: 'Ext.panel.Panel',
	alias: 'widget.graphcontainer',
	autoScroll:false,
	scroll:false,
	autoDestroy:true,
	graphsData:null,
	layout:'column',
	defaults:{
		columnWidth:.555
	},
	columns:2,
	padding:0,
	items:[{
				columnWidth:.50,
				xtype:'container',
				padding:'0 0 0 0',
				height:'auto',
				id:'col1'
			},
			{
				columnWidth:.50,
				xtype:'container',
				padding:'0 0 0 0',
				height:'auto',
				id:'col2'
			}],
	listeners :
	{
		'render' : function()
		{
			this.loadPanelData();
		}
	},
	initComponent:function(){
		this.callParent();
		var me = this;
       this.addEvents({
            validatedrop: true,
            beforedragover: true,
            dragover: true,
            beforedrop: true,
            drop: true
        });
        this.on('drop', this.doLayout, this);
	},
	 initEvents : function(){
        this.callParent();
        this.dd = Ext.create('LiveGraph.dd.PortalDropZone', this, this.dropConfig);
    },
	loadPanelData : function()
	{
		var col1=this.getComponent('col1');
		var col2=this.getComponent('col2');
		if(!Ext.isEmpty(this.graphsData.graphUrls)){
			var refRateValue = this.graphsData.refreshRate;
			var urlLength = this.graphsData.graphUrls.length;
			var isFirst = true;
			var initVal=0;
			var conVal=0;
			for(a=0;a<2;a++)
			{
				var insertItems = [];
				var isOdd = ( urlLength % 2 == 1 )?true:false;
				var linkSize = urlLength / 2;
				linkSize = Math.floor(linkSize);
				var loopSize = (isOdd && isFirst )?(linkSize+1):linkSize;
				for(j=initVal;j<loopSize;j++)
				{
					var graph = this.graphsData.graphUrls[conVal];
					insertItems.push({
						xtype:'graph',
						width:'98%',
						frame:true,
						height:250,
						title:(graph.graphName.toUpperCase() == 'NULL'?'':graph.graphName),
						autoDestroy:true,
						padding:0,
						margin:'5 5 8 5',
						cls:'datapanel',
						id:'grphId'+conVal,
						name:'grphId'+conVal,
						itemId:'highChart'+conVal,
						url:graph.url,
						refreshRateValue:refRateValue,
						chartTitle:(graph.graphName.toUpperCase() == 'NULL'?'':graph.graphName),
						chartHtml:'<div id="highChart'+conVal+'" style="height:auto;width:100%;border:0px solid green"></div>',
					});
					conVal = conVal+1;
				}
				if(isFirst)
					Ext.getCmp("col1").add(insertItems);
				else
					Ext.getCmp("col2").add(insertItems);

				isFirst = false;
			}
			this.addEvents({
				validatedrop: true,
				beforedragover: true,
				dragover: true,
				beforedrop: true,
				drop: true
			});
			this.on('drop', this.doLayout, this);
		}
	},
	

});