Ext.define('LiveGraph.view.GraphViewList',{
	//extend: 'utilities.CustomGrid',
	extend: 'Ext.grid.Panel',
	alias: 'widget.graphviewlist',
	header:false,
	//scroll:false,
	autoScroll:true,
	draggable:false,
	margin:'10',
	height:150,
	forceFit:true,
	shared:false,
	border:true,
	//cls:'gridSkin',
	ui:'newGridPanel',
	columns:[],

	viewConfig:{
		deferEmptyText: false
	},
	
	initComponent:function(){
		this.selModel = Ext.create('Ext.selection.CheckboxModel',{
			checkOnly: true,
			width:20,
			injectCheckbox:'first'
		}),
		this.columns = [];

		this.columns.push({
			dataIndex:'viewName',
			menuDisabled:true,
			sortable:false,
			width:(this.shared?750:750)
		});

		if(this.shared){
			this.emptyText = '<table width="100%" height="150px"><tr><td align="center" valign="middle"><div class="iconInformation"></div><span class="font_normal11">You have shared live graph views,but all are hidden </span></td></tr></table>';
			this.columns.push({
				dataIndex:'owner',
				menuDisabled:true,
				sortable:false
			});
		}
		else{
		
		this.dockedItems =[{
							xtype: 'toolbar',
							dock: 'top',
							padding:'5 0',
							ui:'topToolbarBorder',
							items: [{
				xtype:'button',
				border:false,
				id:'addNew',
				itemId:'addNew',
				style:{'background':'none'},
				cls:'button20',
				margin:'0 0 0 5',
				text:'Add new',
				action:'addView'
			},'->',{
				xtype:'button',
				cls:'button20',
				id:'deleteView',
				itemId:'deleteView',
				border:false,
				margin:'0 5 0 0',
				style:{'background':'none'},
				text:deletLbl,
				hidden:false,
				action:'deleteView'
			}]
						}];
		
		
			/* this.tbar = [{
				xtype:'button',
				border:false,
				id:'addNew',
				itemId:'addNew',
				style:{'background':'none'},
				cls:'button20',
				text:'Add new',
				action:'addView'
			},'->',{
				xtype:'button',
				cls:'button20',
				id:'deleteView',
				itemId:'deleteView',
				border:false,
				style:{'background':'none'},
				text:'Delete',
				hidden:false,
				action:'deleteView'
			}]; */
		}

		this.columns.push({
			dataIndex:'edit',
			menuDisabled:true,
			sortable:false,
			flex:.1
		},{
			dataIndex:'view',
			menuDisabled:true,
			sortable:false,
			flex:.1
		},{
			dataIndex:'deleteView',
			menuDisabled:true,
			sortable:false,
			flex:.1
		},{
			dataIndex:'defaultFlag',
			menuDisabled:true,
			sortable:false,
			flex:.1
		});

		this.callParent();
	}
});