Ext.define('LiveGraph.view.GraphsList',{
	//requires:['utilities.CustomGrid'],
	//extend:'utilities.CustomGrid',
	extend:'Ext.grid.Panel',
	alias:'widget.graphslist',	
    scroll:false,	
	//cls:'gridSkin favapp',
	ui:'newGridPanel',
	autoScroll:true,
	border:true,
	//style:{'overflow-x': 'hidden'},
	selModel: Ext.create('Ext.selection.CheckboxModel',{
		checkOnly: true,
		width:30,
		injectCheckbox:'first'
	}),
	store:'Graphs',
	height:100,
	columns:{
		defaults:{
			sortable:false,
			hideable:false,
			resizable:true,
			draggable:false
		},
		items:[{
			header:displayNameTxt,
			dataIndex:'displayName',
			renderer:function(value,metaData,record,rowIndex){
				if(Ext.isEmpty(value) || value == 'Null' || value == 'NULL' || value == '-')
					return '<div> - </div>';
				else
					return '<div data-qtip="'+value+'" data-qclass="yellowTip">'+value+'</div>';
			}
		},{
			header:serviceTxt,
			width:70,
			dataIndex:'site',
			renderer:function(value,metaData,record,rowIndex){
			if(Ext.isEmpty(value) || value == '-')
				return '<div> - </div>';
			else
				return '<div  data-qtip="'+value+'" data-qclass="yellowTip">'+value+'</div>';
			}
		},{
			header:compNameTxt,
			width:130,
			dataIndex:'component',
			renderer:function(value,metaData,record,rowIndex){
			if(Ext.isEmpty(value) || value == '-')
				return '<div> - </div>';
			else
				return '<div data-qtip="'+value+'" data-qclass="yellowTip">'+value+'</div>';
			}
		},{
			header:compTypeTxt,
			width:130,
			dataIndex:'componentType',
			renderer:function(value,metaData,record,rowIndex){
			if(Ext.isEmpty(value) || value == '-')
				return '<div> - </div>';
			else
				return '<div data-qtip="'+value+'" data-qclass="yellowTip">'+value+'</div>';
			}
		},{
			header:layerTxt,
			width:70,
			dataIndex:'layer',
			renderer:function(value,metaData,record,rowIndex){
			if(Ext.isEmpty(value) || value == '-')
				return '<div> - </div>';
			else
				return '<div data-qtip="'+value+'" data-qclass="yellowTip">'+value+'</div>';
			}
		},{
			header:testTxt,
			width:70,
			dataIndex:'test',
			renderer:function(value,metaData,record,rowIndex){
			if(Ext.isEmpty(value) || value == '-')
				return '<div> - </div>';
			else
				return '<div data-qtip="'+value+'" data-qclass="yellowTip">'+value+'</div>';
			}
		},{
			header:measureTxt,
			dataIndex:'measure',
			renderer:function(value,metaData,record,rowIndex){
			if(Ext.isEmpty(value) || value == '-')
				return '<div> - </div>';
			else
				return '<div  data-qtip="'+value+'" data-qclass="yellowTip">'+value+'</div>';
			}
		},{
			header:descTxt,
			dataIndex:'descriptor',
			flex:1,
			renderer:function(value,metaData,record,rowIndex){
				if(Ext.isEmpty(value) || value == '-1' || value == -1 || value == '-')
					return '<div> - </div>';
				else
					return '<div data-qtip="'+value+'" data-qclass="yellowTip">'+value+'</div>';
			}
		}]
	},	
	
	initComponent:function(){
		this.callParent();
	}
});