Ext.define('LiveGraph.view.ViewOptions', {
    extend: 'Ext.form.Panel',
    alias: 'widget.viewoptions',
	autoDestroy:true,
    //width:'100%',
    layout: {
        type: 'vbox',
        align: 'stretch'
    },
	margin:'0 0 10 0',
    autoHeight: true,
    initComponent: function () {
        //this.bodyPadding ='10 20 0 20';
        this.buttonAlign = 'center';
        this.callParent()
    },
    requires: ['Ext.ux.form.ItemSelector'],
    items: [{
            xtype: 'panel',
            layout: {
                type: 'hbox'
            },
            defaults: {
                margin: 0,
                //padding:'10px 10px 10px 10px',
                labelSeparator: '',
                labelAlign: 'top',
            },
            items: [{
                    xtype: 'scrollcombo',
                    cls: 'dropdown',
                    margin: '10 5 5 10',
                    name: 'timeline',
                    itemId: 'timeline',
					editable:false,
                    fieldLabel: 'Timeline',
                    displayField: 'display',
                    valueField: 'value',
                    queryMode: 'local',
                    store: Ext.create('Ext.data.Store', {
                        fields: ['display', 'value']
                    })
                },

                {
                    xtype: 'numberfield',
                    cls: 'textbox',
                    margin: '10 5 5 10',
                    fieldLabel: 'Refresh Rate',
                    labelWidth: 150,
                    width: 170,
                    labelAlign: 'top',
                    labelSeparator: '',
                    itemId: 'refreshRate',
                    hideTrigger: true,
                    value: 60,

                }, {
                    xtype: 'label',
                    itemId: 'refreshRateUnit',
                    padding: '36 10 0 2',
                    html: 'Secs'
                }, {

                    xtype: 'numberfield',
                    cls: 'textbox',
                    width: 150,
					allowDecimals:false,
					allowNegative:false,
					regex:/[0-9]*/,
					encode:  false,
                    margin: '10 20 5 10',
					style:{'margin-left':'14 !important'},
                    fieldLabel: 'No of Columns',
                    labelWidth: 150,
                    itemId: 'noOfColumns',
                    hideTrigger: true,
                    value: 2,
			disabled:true

                }, {
                    xtype: 'radiogroup',
                    defaults: {
                        cls: 'radiobt'
                    },
                    width: 180,
                    margin: '10 10 5 10',
                    itemId: 'commonMaximum',
                    fieldLabel: comMaxTxt,
                    items: [{
                        boxLabel: YesTxt,
                        boxLabelAlign: 'after',
                        itemId: 'yes',
                        name: 'commonMax',
                        inputValue: 'Yes'
                    }, {
                        boxLabel: NoTxt,
                        boxLabelAlign: 'after',
                        checked: true,
                        itemId: 'no',
                        name: 'commonMax',
                        inputValue: 'No'
                    }]
                }
            ]
        },

        {
            xtype: 'panel',
            layout: {
                type: 'hbox'
            },
            defaults: {
                 margin: '10 5 5 10',
                //padding:'10px 10px 10px 10px',
                labelSeparator: '',
                labelAlign: 'top',
            },
            items: [


                {
                    //columnWidth:.1,
                    xtype: 'checkbox',
                    cls: 'checkbt',
                    itemId: 'lookback',
                    fieldLabel: 'Lookback',
                    checked: true
                }, {
                    xtype: 'scrollcombo',
                    labelAlign: 'top',
                    labelSeparator: '',
                    cls: 'dropdown',
                    name: 'interval',
					editable:false,
                    //height:42,
                    itemId: 'interval',
                    labelWidth: 150,
                    fieldLabel: 'Interval',
                    displayField: 'display',
                    valueField: 'value',
                    queryMode: 'local',
                    store: Ext.create('Ext.data.Store', {
                        fields: ['display', 'value']
                    })
                }, {
                    //columnWidth:.1,
                    xtype: 'scrollcombo',
                    cls: 'dropdown',
                    name: 'otherInterval',
                    hidden: true,
					editable:false,
                    itemId: 'otherInterval',
                    labelAlign: 'top',
                    labelSeparator: '',
                    fieldLabel: '',
                    padding: '0 0 0 0',
                    height: 65,
                    width: 70,
                    displayField: 'display',
                    valueField: 'value',
                    queryMode: 'local',
                    store: Ext.create('Ext.data.Store', {
                        fields: ['display', 'value']
                    })
                }, {
                    //columnWidth:.1,	
                    xtype: 'scrollcombo',
                    cls: 'dropdown',
					editable:false,
                    name: 'noOfTimes',
                    itemId: 'noOfTimes',
                    fieldLabel: 'Number of Times',
                    displayField: 'display',
                    valueField: 'value',
                    queryMode: 'local',
                    store: Ext.create('Ext.data.Store', {
                        fields: ['display', 'value']
                    })
                }, {
                    //columnWidth:.1,	
                    xtype: 'scrollcombo',
                    cls: 'dropdown',
					editable:false,
                    name: 'sharing',
                    itemId: 'sharing',
                    fieldLabel: 'Sharing',
                    displayField: 'display',
                    valueField: 'value',
                    queryMode: 'local',
                    store: Ext.create('Ext.data.Store', {
                        fields: ['display', 'value']
                    })
                },

            ]
        },

        {
            xtype: 'panel',
            layout: {
                type: 'hbox'
            },			
            defaults: {
                margin: 10,
                //padding:'10px 10px 10px 10px',
                labelSeparator: '',
                labelAlign: 'top',
            },
            items: [

                {

                    xtype: 'itemselector',
                    cls: 'itemselector',
                    name: 'userSelector',
                    itemId: 'userSelector',
                    anchor: '90%',
                    hidden: true,
                    height: 100,
                    width: 475,
                    store: 'Users',
                    prevUsers: '',
                    publicUsers: '',
                    displayField: 'display',
                    valueField: 'value',
                    allowBlank: false,
                    buttons: ['add', 'remove'],
                    msgTarget: 'side',
                    fromTitle: 'Available Users',
                    toTitle: 'Selected Users'
                }


            ]
        },
		{
		xtype : 'panel',
		dock : 'bottom',
		layout: {                        
		type: 'hbox',
		align: 'center',
		pack:'center'
		},				
		items : [
		{
                    xtype: 'button',
                    text: updateTxt,
                    cls: 'button20',
                    action: 'updateView',
                    id: 'updateView_graph',
                    margin:'10 5 10 10'
                }, {
                    xtype: 'button',
                    text: deletLbl,
                    cls: 'button20',
                    itemId: 'deleteView',
                    id: 'deleteView_graph',
                    action: 'deleteView',
                    margin:'10 5 10 0',
                    hidden: true
                }
		]
		},

    ],



	setData:function(json){
		// In every element, the below order is followed
		// Screen Labels of the form element captions and labels is Set at first
		// Then the data to the respective form element is Set

		// Set all combos
		this.loadCombo(json,'timeline');
		this.loadCombo(json,'interval');
		this.loadCombo(json,'otherInterval');
		this.loadCombo(json,'noOfTimes');
		this.loadCombo(json,'sharing');
		// Sets the Refresh rate value
		this.down('numberfield#refreshRate').setFieldLabel(json.screenLabels.refreshRate);
		if(!Ext.isEmpty(json.currentSelection.refreshRate))
			this.down('numberfield#refreshRate').setValue(json.currentSelection.refreshRate);

		this.down('numberfield#noOfColumns').setFieldLabel("No"+json.screenLabels.noOfColumns);
		if(!Ext.isEmpty(json.currentSelection.noOfColumns))
			this.down('numberfield#noOfColumns').setValue(json.currentSelection.noOfColumns);

		// Sets the Lookback checkbox
		this.down('checkbox#lookback').setFieldLabel(json.screenLabels.lookback);
		if(!Ext.isEmpty(json.currentSelection.lookback))
			this.down('checkbox#lookback').setValue(json.currentSelection.lookback);

		// Sets Common Maximum radiogroup
		var commonMaxRadio = this.down('radiogroup[itemId=commonMaximum]');
		commonMaxRadio.getComponent('yes').boxLabel = json.screenLabels.yes;
		commonMaxRadio.getComponent('no').boxLabel = json.screenLabels.no;
		if(!Ext.isEmpty(json.currentSelection.commonMaximum)){
			commonMaxRadio.setValue({commonMax:json.currentSelection.commonMaximum});
		}
	},

	loadCombo:function(json,itemId){
		var combo = this.down('scrollcombo[itemId='+itemId+']');
		var selection = '';
		combo.setFieldLabel(json.screenLabels[itemId]);
		if(!Ext.isEmpty(json.viewOptions[itemId])){
			combo.getStore().loadRawData(json.viewOptions[itemId]);
			selection = json.currentSelection[itemId];
			if(!Ext.isEmpty(selection)){
				combo.setValue(selection);
			}
			else{
				selection = combo.getStore().getAt(0).get('value');
				combo.setValue(selection);
			}
		}
	},
		
	initComponent:function(){
		this.callParent();
	}
});