var infoTest;
var searchObj;
Ext.define('MeasureGraphGenerator.controller.Main', {
	extend : 'Ext.app.Controller',
	views : ['Main'],
	refs : [{
				selector : 'main',
				ref : 'main'
			}, {
				selector : 'settings',
				ref : 'settings'
			}, {
				selector : 'utilitiestool',
				ref : 'utilitiestool'
			}, {
				selector : 'settingsForm',
				ref : 'settingsForm'
			}, {
				selector : 'measuregraphForm',
				ref : 'measuregraphForm'
			},{
                selector : 'newwindow',
                ref : 'newwindow'
            },{
                selector : 'resultpanel',
                ref : 'resultpanel'
            }],
	init : function() {
		this.control({
					'measuregraphForm' : {
						'boxready' : this.loadForm
					},
					'settingsForm' : {
						'afterrender' : this.settingsFormRender
					},
					'measuregraphForm  scrollcombo[id="hostlist"]' : {
						'select' : this.component_onchange
					},
					'measuregraphForm  scrollcombo[id="complist"]' : {
						'select' : this.comptype_onchange
					},
					'measuregraphForm  scrollcombo[id="layerlist"]' : {
						'select' : this.layer_onchange
					},
					'measuregraphForm  scrollcombo[id="testlist"]' : {
						'select' : this.test_onchange
					},
					'measuregraphForm  scrollcombo[id="sitelist"]' : {
						'select' : this.site_onchange
					},
					'settingsForm checkbox[id="lookback"]' : {
						'change' : this.changeHistory
					},
					'settingsForm combo[id="er_interval"]' : {
						'select' : this.changeOtherCombo
					},
					'main utilitiestool' : {
						'afterrender' : this.hideTools
					},
					'measuregraphForm button[id="submit"]' : {
						'click' : this.showResult
					},
					'main utilitiestool > #saveTool > button' : {
                        'click' : this.saveFileTool
                    },
                    'main utilitiestool > #printTool > button' : {
                        'click' : this.printFile
                    },
                    'main utilitiestool > #dataTool > button' : {
                        'click' : this.dataFile
                    },
                    'measuregraphForm trigger[name="filterOpt"]':
                    {
                        'keyup': this.filterMultiselect
                    },
					'measuregraphForm trigger[name="descriptionOpt"]':
                    {
                        'keyup': this.descriptorOptSelect
                    },
					'utilitiestool > #upbutton':
						{
							'click':this.toggleForm
						}
				});
	},
	afterMainRender : function() {
		
		Ext.get('closeSettings').on('click', function() {

					Ext.get('configMod').animate({
								duration : 500,
								to : {
									y : -500
								}
							});
				});
	},
	toggleForm:function(){
		
		var ornt = this.getMeasuregraphForm();
		ornt.toggleCollapse(true);
	},
	hideTools : function() {
		this.getUtilitiestool().loadIcon(true, //save
				true, //print
				false, //mail
				true, //data
				false, //cvs
				false, // fav
				false,// schedule
				false, //daignosis
				false, //togglebutton
				false //close
				);
		Ext.getCmp('DataSeparator').hide();		
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("dataTool").setDisabled(true);
	},
	loadForm : function(thisObj) {
		Ext.getCmp('saveTool').hide();
		Ext.getCmp('printTool').hide();
		Ext.getCmp('settingsSeparator').hide();
		Ext.getCmp('saveSeparator').hide();
		Ext.getCmp('er_stmin').show();
		Ext.getCmp('er_endmin').show();
		
		var me=this;
		var form = thisObj.getForm();

		if (isSubmit != undefined && isSubmit == 'true') {
			var compName = comp.substring(0,comp.lastIndexOf(":"));
			var compType = comp.substring(comp.lastIndexOf(":")+1);
			this.doFilter('sitelist', form, 'getUserSites', '&p0=' + site,site);
			if(site=="NULL")
				site = "-1";
			if(site=='-1')
			{
				 this.doFilter('complist', form, 'getComponentTypesForSite','&P0=no' , compType);
			     this.doFilter('hostlist', form, 'getComponentsForType', '&P0=' + compType , comp);
			}
			else
			{
				this.doFilter('complist', form, 'getComponentTypesForSite','&P0=' + site , compType);
			    this.doFilter('hostlist', form, 'getComponentsForType', '&P0=' + compType , comp);
			}
			this.doFilter('layerlist', form, 'getLayersForComponent', '&P0='+ comp, layer);
			this.doFilter('testlist', form, 'getTestListsForGraph', '&P0=' + site+ '&P1=' + comp + '&P2=' + layer +'&P3=measureGraph', stest);
			this.doFilter('descriptionlist', form, 'getTestDescriptorsForGraph', '&P0=' + site + '&P1=' + comp + '&P2=' + layer+ '&P3=' +encodeURIComponent(test),'-');
			this.doFilter('msmt_host', form, 'selectMsmtHostForGraph', '&P0='+ site + '&P1=' + comp + '&P2=' + layer + '&P3='+ encodeURIComponent(test), msmt_host);
			this.doFilter('measurelist', form, 'getMeasuresForGraph', '&P0='+ encodeURIComponent(test) + '&P1=' + layer + '&',measure);
			Ext.getCmp('settings').queryString = queryString;
		    this.renderResult(queryString);			
		
		} else {
			this.loadServices(form);
			this.loadComponentTypes(form);
			this.loadComponents(form);
			this.setNotApplicable(form,'layerlist',defaultJSON.screenLabels['monitor.common.DefaultLayerOption']);
			this.setNotApplicable(form,'testlist',defaultJSON.screenLabels['monitor.common.DefaultTestOption']);
			this.setNotApplicable(form,'msmt_host',defaultJSON.screenLabels['monitor.common.DefaultMsmthostOption']);
			this.setNotApplicable(form,'measurelist',defaultJSON.screenLabels['monitor.common.DefaultMeasureOption2']);
			this.setNotApplicable(form,'descriptionlist',chooseDescriptor);
		}
	},
	settingsFormRender : function() {
		var settingsForm = this.getSettingsForm().getForm();
		var screenLabels = defaultJSON['screenLabels'];
		var objectArr = new Array();
		objectArr['er_timeline'] = screenLabels['monitor.common.Timeline'];
		objectArr['er_stdate'] = screenLabels['monitor.common.From'];
		objectArr['er_sthr'] = screenLabels['monitor.common.Hr'];
		objectArr['er_stmin'] = screenLabels['monitor.common.Min'];
		objectArr['er_enddate'] = screenLabels['monitor.common.To'];
		objectArr['er_endhr'] = screenLabels['monitor.common.Hr'];
		objectArr['er_endmin'] = screenLabels['monitor.common.Min'];
		this.loadScreenLabels(settingsForm, objectArr);

		var selectedData = defaultJSON.timelinedetails['timelineSelections'];
		var timelineCombo = defaultJSON.timelinedetails['timeline'];
		if (!Ext.isEmpty(timelineCombo)) {
			var timelineSelected = selectedData['selectedTimeline']
			this.setComboOptionsInList(settingsForm, 'er_timeline',
					timelineCombo, timelineSelected);
		}

		var startDateSelected = selectedData['selectedStartDate'];
		if (!Ext.isEmpty(startDateSelected)) {

			Ext.getCmp('er_stdate').setValue(startDateSelected);
			Ext.getCmp('er_stdate').dataArray = selectedData['startDateInMgrDateFormat'];

		}
		var endDateSelected = selectedData['selectedEndDate'];
		if (!Ext.isEmpty(endDateSelected)) {

			Ext.getCmp('er_enddate').setValue(endDateSelected);
			Ext.getCmp('er_enddate').dataArray = selectedData['endDateInMgrDateFormat'];
		}

		var startHrSelected = selectedData['selectedStartHour'];
		if (!Ext.isEmpty(startHrSelected)) {
			settingsForm.findField('er_sthr').setValue(startHrSelected);
			settingsForm.findField('er_sthr').dataArray = selectedData['startHrInMgrDate'];
		}

		var endHrSelected = selectedData['selectedEndHour'];
		if (!Ext.isEmpty(endHrSelected)) {
			settingsForm.findField('er_endhr').setValue(endHrSelected);
			settingsForm.findField('er_endhr').dataArray = selectedData['endHourInMgrDate'];
		}

		var startMinSelected = selectedData['selectedStartMin'];
		if (!Ext.isEmpty(startMinSelected)) {
			settingsForm.findField('er_stmin').setValue(startMinSelected);
			settingsForm.findField('er_stmin').dataArray = selectedData['startMinInMgrDate'];
		}

		var endMinSelected = selectedData['selectedEndMin'];
		if (!Ext.isEmpty(endMinSelected)) {
			settingsForm.findField('er_endmin').setValue(endMinSelected);
			settingsForm.findField('er_endmin').dataArray = selectedData['endMinInMgrDate'];
		}

		this.changeTimeline();		

		var durationCombo = defaultJSON.timelinedetails['durationCombo'];
		
		if (!Ext.isEmpty(durationCombo)) {
			var durationSelected = selectedData['durationSelected'];
			this.setComboOptionsInList(settingsForm, 'period', durationCombo,
					durationSelected);
		}

		var interval = defaultJSON['measuregraphintervalcombo'];

		if (!Ext.isEmpty(interval)) {
			settingsForm.findField('er_interval').getStore()
					.loadRawData(interval);
			settingsForm.findField('er_interval').setValue(settingsForm
					.findField('er_interval').getStore().getAt(0));
		}

		var othertimeline = defaultJSON['measuregraphothertimelinecombo'];

		if (!Ext.isEmpty(othertimeline)) {
			settingsForm.findField('er_otherTime').getStore()
					.loadRawData(othertimeline);
			settingsForm.findField('er_otherTime').setValue(settingsForm
					.findField('er_otherTime').getStore().getAt(0));
		}

		if (isSubmit != undefined && isSubmit == 'true') {
			Ext.getCmp('er_stdate').setValue(starttime);
			Ext.getCmp('er_stdate').dataArray = selectedData['startDateInMgrDateFormat'];
			Ext.getCmp('er_timeline').setValue(decodeURIComponent(time));
			Ext.getCmp('er_enddate').setValue(endtime);
			Ext.getCmp('er_enddate').dataArray = selectedData['endDateInMgrDateFormat'];
			
			
			settingsForm.findField('er_sthr').setValue(starthr);
			settingsForm.findField('er_sthr').dataArray =selectedData['startHrInMgrDate'];
			settingsForm.findField('er_endhr').setValue(endhr);
			settingsForm.findField('er_endhr').dataArray = selectedData['endHourInMgrDate'];
			
			try
			{
				settingsForm.findField('er_stmin').setValue(startmin);
				settingsForm.findField('er_stmin').dataArray =selectedData['startMinInMgrDate'];
				settingsForm.findField('er_endmin').setValue(endmin);
				settingsForm.findField('er_endmin').dataArray =selectedData['endMinInMgrDate'];
			}
			catch (e)
			{
				settingsForm.findField('er_stmin').setValue(0);
				settingsForm.findField('er_stmin').dataArray = selectedData['startMinInMgrDate'];
				settingsForm.findField('er_endmin').setValue(0);
				settingsForm.findField('er_endmin').dataArray = selectedData['endMinInMgrDate'];
			}
		}
		this.changeHistory();
	},
	changeTimeline : function(obj) {
		var getTimelineVal = Ext.getCmp('er_timeline').getValue();
		var stDateObj = Ext.getCmp('er_stdate');
		var endDateObj = Ext.getCmp('er_enddate');
		var stHrObj = Ext.getCmp('er_sthr');
		var endHrObj = Ext.getCmp('er_endhr');
		var stMinObj = Ext.getCmp('er_stmin');
		var endMinObj = Ext.getCmp('er_endmin');
		if (getTimelineVal == 'Any') {
			stDateObj.setDisabled(false);
			endDateObj.setDisabled(false);
			stHrObj.setDisabled(false);
			endHrObj.setDisabled(false);
			stMinObj.setDisabled(false);
			endMinObj.setDisabled(false);
		} else {
			stDateObj.setDisabled(true);
			endDateObj.setDisabled(true);
			stHrObj.setDisabled(true);
			endHrObj.setDisabled(true);
			stMinObj.setDisabled(true);
			endMinObj.setDisabled(true);
		}
		if(getTimelineVal!='Any')
		{
			
    		var strtdt = Ext.Date.dateFormat(stDateObj.getValue(), mgrDateFormat);
    		var enddt = Ext.Date.dateFormat(endDateObj.getValue(), mgrDateFormat);
    		if (!Ext.isEmpty(obj)) {
    			var param = 'beanName=com.egurkha.monitor.EgMonRemoteScriptingBean&method=getTime&P0='
    					+ getTimelineVal
    					+ '&P1='
    					+ encodeURIComponent(strtdt)
    					+ '&P2='
    					+ encodeURIComponent(enddt)
    					+ '&P3='
    					+ stHrObj.getValue()
    					+ '&P4='
    					+ endHrObj.getValue()
    					+ '&P5='
						+ stMinObj.getValue()
    					+ '&P6='
    					+ endMinObj.getValue()
    					+ '&P7='
						+ encodeURIComponent(currentDateFormat);
    			var me = this;
    
    			Ext.Ajax.request({
    						url : '/final/servlet/com.eg.RemoteScriptingServlet',
    						params : param,
    						success : function(response) {
    							var formdata = Ext.decode(response.responseText);
    							stDateObj.setValue(formdata[0]);
    							stDateObj.dataArray = formdata[0];
    							endDateObj.setValue(formdata[1]);
    							endDateObj.dataArray = formdata[1];
    							stHrObj.setValue(formdata[2]);
    							stHrObj.dataArray = formdata[2];
    							endHrObj.setValue(formdata[3]);
    							endHrObj.dataArray = formdata[3];
								stMinObj.setValue(formdata[4]);
								stMinObj.dataArray = formdata[4];
								endMinObj.setValue(formdata[5]);
								endMinObj.dataArray = formdata[5];
    						}
    					});
    		}
		}
	},
	loadScreenLabels : function(form, ObjectArr) {
		var obj = '';
		for (var key in ObjectArr) {

			obj = !Ext.isEmpty(form.findField(key)) ? form.findField(key) : Ext
					.getCmp(key);

			if (obj.getXType() != 'label') {
				form.findField(key).setFieldLabel(ObjectArr[key]);
			} else {
				Ext.getCmp(key).setText(ObjectArr[key]);
			}
		}
	},
	loadServices : function(form) {
		var param = 'beanName=com.egurkha.monitor.EgMonRemoteScriptingBean&method=getUserSites';
		var me = this;
		Ext.Ajax.request({
					url : '/final/servlet/com.eg.RemoteScriptingServlet',
					params : param,
					success : function(response) {
						var formdata = Ext.decode(response.responseText);
						formdata[0]['displayField'] = formdata[0]['displayField'];
						me.setComboOptionsInList(form, 'sitelist', formdata,
								'-1');
					}
				});
	},
	loadComponentTypes:function(form) {
		var param = 'beanName=com.egurkha.monitor.EgMonRemoteScriptingBean&method=getComponentTypesForSite&P0=no';
		var me = this;
		Ext.Ajax.request({
			url : '/final/servlet/com.eg.RemoteScriptingServlet',
			params : param,
			success : function(response) {
				var formdata = Ext.decode(response.responseText);
				componentsRawData = formdata;
				me.setComboOptionsInList(form, 'complist', formdata,'-1');
			}
		});
	},
	loadComponents : function(form) {
		var param = 'beanName=com.egurkha.monitor.EgMonRemoteScriptingBean&method=getComponentsForType&P0=no';
		var me = this;
		Ext.Ajax.request({
			url : '/final/servlet/com.eg.RemoteScriptingServlet',
			params : param,
			success : function(response) {
				if(!Ext.isEmpty(response.responseText))
				{
					var formdata = Ext.decode(response.responseText);
					componentsRawData = formdata;
					me.setComboOptionsInList(form, 'hostlist', formdata,
							'-1');
				}
			}
		});
	},
	setComboOptionsInList : function(form, fieldName, list, value)
	{
		form.findField(fieldName).getStore().loadRawData(list);
		form.findField(fieldName).suspendEvents(false);
		
		if(fieldName=='descriptionlist')
		{
			
			if(list.length>1)
			{
				infoTest=true;
				var obj = Ext.getCmp("descriptionOpt");
				Ext.get('descriptionOpt-inputEl').setStyle('width', '130');
				//obj.getEl().show();
				var decObj = Ext.getCmp("descriptionlist");
				Ext.get('descriptionlist-inputEl').setStyle('width', '210');
				decObj.getEl().show();
				this.getMain().doLayout();
			}
			else
			{
				infoTest=false;
				var obj = Ext.getCmp("descriptionOpt");
				obj.getEl().hide();
				var decObj = Ext.getCmp("descriptionlist");
				decObj.getEl().hide();
				this.getMain().doLayout();
			}
		}

		if(fieldName=='measurelist')
		{
			if(value.indexOf(",")>-1)
			{
				
				var meas=[];
				var tmp = value.split(',');
				for(var i=1;i<tmp.length;i++)
				{
					meas.push(tmp[i]);
				}
				form.findField(fieldName).setValue(meas);
			}
			else
			{
				if(value=='-')
				{
					if(form.findField(fieldName).getStore()!=null && form.findField(fieldName).getStore()!=undefined && form.findField(fieldName).getStore().length>0)
					value = form.findField(fieldName).getStore().getAt(0).get('valueField');
				}
				form.findField(fieldName).setValue(value);
			}
		}
		else
		{
			if(value=='-' )
            {
				try
				{
                    value = form.findField(fieldName).getStore().getAt(1).get('valueField');
				}
				catch (err)
				{
					value = form.findField(fieldName).getStore().getAt(0).get('valueField');
				}
            }
			
			if(fieldName=='sitelist')
			{
				if(!value || value=='NULL')
					value="-1";
			}

			if(fieldName=='testlist')
			{
			form.findField(fieldName).setValue(value);
				var fname = form.findField(fieldName).getValue();
				if(!fname)
				{
					if(value.indexOf("-"))
						value = value.substring(0,value.indexOf("-"));
					form.findField(fieldName).setValue(value);
				}
			}
			form.findField(fieldName).setValue(value);
		}
		form.findField(fieldName).resumeEvents();
		form.findField(fieldName).doComponentLayout();
	},
	setComboValue : function(form, fieldName, value) {
		form.findField(fieldName).suspendEvents(false);
		form.findField(fieldName).setValue(value);
		form.findField(fieldName).resumeEvents();
	},
	setNotApplicable : function(form, fieldname, option) {
		form.findField(fieldname).getStore().removeAll();

		form.findField(fieldname).getStore().loadRawData([{
					"displayField" : option,
					"valueField" : "-1"
				}]);
		if(fieldname != null && fieldname != undefined && fieldname != "measurelist")
			form.findField(fieldname).setValue("-1");
	},
	component_onchange : function(thisObj) {

		var val = thisObj.getValue();
		var form = thisObj.up('.form').getForm();
		this.setNotApplicable(form, 'layerlist',
				defaultJSON.screenLabels['monitor.common.DefaultLayerOption']);
		this.setNotApplicable(form, 'testlist',
				defaultJSON.screenLabels['monitor.common.DefaultTestOption']);
		this
				.setNotApplicable(
						form,
						'msmt_host',
						defaultJSON.screenLabels['monitor.common.DefaultMsmthostOption']);
		this
				.setNotApplicable(
						form,
						'measurelist',
						defaultJSON.screenLabels['monitor.common.DefaultMeasureOption2']);
		this.setNotApplicable(form,'descriptionlist',chooseDescriptor);
		Ext.getCmp("descriptionOpt").setValue("");
		var no_param = '&P0=' + val;

		this.doFilter('layerlist', form, 'getLayersForComponent', no_param,
				'-1');
	},
	layer_onchange : function(thisObj) {
		var val = thisObj.getValue();
		var form = thisObj.up('.form').getForm();

		this.setNotApplicable(form, 'testlist',
				defaultJSON.screenLabels['monitor.common.DefaultTestOption']);
		this
				.setNotApplicable(
						form,
						'msmt_host',
						defaultJSON.screenLabels['monitor.common.DefaultMsmthostOption']);
		this
				.setNotApplicable(
						form,
						'measurelist',
						defaultJSON.screenLabels['monitor.common.DefaultMeasureOption2']);
		this.setNotApplicable(form,'descriptionlist',chooseDescriptor);
		Ext.getCmp("descriptionOpt").setValue("");

		var siteName = form.findField('sitelist').getValue();
		siteName = (siteName == '-1') ? 'NULL' : siteName;
		var hostName = form.findField('hostlist').getValue();

		var no_param = '&P0=' + siteName + '&P1=' + hostName + '&P2=' + val
				+ '&P3=measureGraph';

		this.doFilter('testlist', form, 'getTestListsForGraph', no_param, '-1');
	},

	test_onchange : function(thisObj) {
		var val = Ext.getCmp("testlist").getValue();
		var form = thisObj.up('.form').getForm();

		this
				.setNotApplicable(
						form,
						'msmt_host',
						defaultJSON.screenLabels['monitor.common.DefaultMsmthostOption']);
		this
				.setNotApplicable(
						form,
						'measurelist',
						defaultJSON.screenLabels['monitor.common.DefaultMeasureOption2']);
		this.setNotApplicable(form,'descriptionlist',chooseDescriptor);
		var siteName = form.findField('sitelist').getValue();
		siteName = (siteName == '-1') ? 'NULL' : siteName;
		var hostName = form.findField('hostlist').getValue();
		var layerName = form.findField('layerlist').getValue();
		Ext.getCmp("descriptionOpt").setValue("");
		var no_param = '&P0=' + siteName + '&P1=' + hostName + '&P2=' + val+ '';
		this.doFilter('descriptionlist', form, 'getTestDescriptorsForGraph', '&P0=' + siteName + '&P1=' + hostName + '&P2=' + layerName+ '&P3=' +encodeURIComponent(val),'-');
		this.doFilter('msmt_host', form, 'selectMsmtHostForGraph', '&P0='+ siteName + '&P1=' + hostName + '&P2=' + layerName+ '&P3=' + encodeURIComponent(val), '-');
		this.doFilter('measurelist', form, 'getMeasuresForGraph', '&P0='+ encodeURIComponent(val) + '&P1=' + layerName + '&','-1');

		if(form.findField('measurelist').getStore()!=null & form.findField('measurelist').getStore()!=undefined & form.findField('measurelist').getStore().length>0)
		{
			form.findField('measurelist').getStore().getAt(0).get('valueField');
		}
	},
	site_onchange : function(thisObj) {
		var val = thisObj.getValue();
		var form = thisObj.up('.form').getForm();
		this.setNotApplicable(form,'hostlist',defaultJSON.screenLabels['monitor.common.DefaultComponentOption']);
		this.setNotApplicable(form, 'layerlist',defaultJSON.screenLabels['monitor.common.DefaultLayerOption']);
		this.setNotApplicable(form, 'testlist',defaultJSON.screenLabels['monitor.common.DefaultTestOption']);
		this.setNotApplicable(form,'msmt_host',defaultJSON.screenLabels['monitor.common.DefaultMsmthostOption']);
		this.setNotApplicable(form,'descriptionlist',chooseDescriptor);
		this.setNotApplicable(form,'measurelist',defaultJSON.screenLabels['monitor.common.DefaultMeasureOption2']);
		Ext.getCmp("descriptionOpt").setValue("");
		val = (val == '-1') ? 'no' : val;
		this.doFilter('complist', form, 'getComponentTypesForSite', '&P0=' + val + '', '-1');
		//this.doFilter('hostlist', form, 'getComponentsForSite', '&P0=' + val + '', '-1');
	},
	comptype_onchange : function(thisObj){
		var val = thisObj.getValue();
		var form = thisObj.up('.form').getForm();
		this.setNotApplicable(form,'hostlist',defaultJSON.screenLabels['monitor.common.DefaultComponentOption']);
		this.setNotApplicable(form,'layerlist',defaultJSON.screenLabels['monitor.common.DefaultLayerOption']);
		this.setNotApplicable(form,'testlist',defaultJSON.screenLabels['monitor.common.DefaultTestOption']);
		this.setNotApplicable(form,'msmt_host',defaultJSON.screenLabels['monitor.common.DefaultMsmthostOption']);
		this.setNotApplicable(form,'measurelist',defaultJSON.screenLabels['monitor.common.DefaultMeasureOption']);
	
		var site_val = '';
		if(!Ext.isEmpty(Ext.getCmp('sitelist')) && Ext.getCmp('sitelist')!=null && Ext.getCmp('sitelist')!=undefined)
			site_val = Ext.getCmp('sitelist').getValue();
		
		val = (val == '-1') ? 'no' : val;
		site_val = (site_val == '-1') ? 'NULL' : site_val;
		var no_param = '&P0=' + site_val + '&P1=' + val;
		//if((!Ext.isEmpty(val)&& val!=null && val!=undefined && val=='-1') && ((!Ext.isEmpty(site_val)&& site_val!=null && site_val!=undefined && site_val!='-1')))
			//this.doFilter('hostlist', form, 'getComponentsForSiteDD', '&P0=' + site_val + '', '-1');
		//else
		this.doFilter('hostlist', form, 'getComponentsForType',no_param, '-1');		
	},
	doFilter : function(fieldname, form, method, no_param, val) {

		var param = 'beanName=com.egurkha.monitor.EgMonRemoteScriptingBean&method='
				+ method + no_param;
		var me = this;
		Ext.Ajax.request({
					url : '/final/servlet/com.eg.RemoteScriptingServlet',
					params : param,
					success : function(response) {
					
						var formdata = Ext.decode(response.responseText);
						if(fieldname == "hostlist")
						{
							componentsRawData = formdata;
						}
						if(fieldname=="descriptionlist")
						{
							descriptorRawData = formdata;
						}
						
						me.setComboOptionsInList(form, fieldname,formdata, val);
					}
				});
	},
	changeHistory : function(thisObj) {

		var val = Ext.getCmp('lookback').getValue();
		if (val) {
			Ext.getCmp('noOfTimes').show();
			Ext.getCmp('noOfTimes').setDisabled(false);
			Ext.getCmp('er_interval').setDisabled(false);
		} else {
			Ext.getCmp('er_interval').setDisabled(true);
			Ext.getCmp('noOfTimes').setDisabled(true);
			Ext.getCmp('noOfTimes').hide();
			Ext.getCmp('er_otherTime').hide();
		}
	},
	changeOtherCombo : function(thisObj) {
		var val = thisObj.getValue();

		if (val == "180") {
			Ext.getCmp('noOfTimes').hide();
			Ext.getCmp('er_otherTime').show();
			var lookback = Ext.getCmp('lookback').getValue();
			if (lookback) {
				Ext.getCmp('er_otherTime').setDisabled(false);
			} else {
				Ext.getCmp('er_otherTime').setDisabled(true);
			}
		} else {
			Ext.getCmp('noOfTimes').show();
			Ext.getCmp('er_otherTime').hide();
		}
	},
	beforeFormSubmit : function() 
	{
		var mainForm = this.getMeasuregraphForm().getForm();
		var hostObj = mainForm.findField('hostlist');
		var layerObj = mainForm.findField('layerlist');
		var testObj = mainForm.findField('testlist');
		var msmt_Obj = mainForm.findField('msmt_host');
		var measureObj = mainForm.findField('measurelist');
		var descObj = mainForm.findField('descriptionlist');

		var valid=false;
		var defVal=null;
		if(descriptorRawData!=null && descriptorRawData!=undefined && descriptorRawData.length>0)
		{
			var defVal=descriptorRawData[0].displayField;
			for(var i=0;i<descriptorRawData.length;i++)
			{			
			if(descriptorRawData[i].valueField==descObj.getValue())
					valid=true;			
			}
		}

		var msg = '';
		if (hostObj.getValue() == '-1') {
			msg = chooseComp;
		} else if (layerObj.getValue() == '-1') {
			msg = chooseLayer;
		} else if (testObj.getValue() == '-1') {
			msg = chooseTest;
		} else if (msmt_Obj.getValue() == '-1') {
			msg = chooseMsmtHost;
		} else if (measureObj.getValue() == '-1') {
			msg = chooseMeasure;
		}
		else if(descriptorRawData!=null && descriptorRawData!=undefined && descriptorRawData.length>1)
		{
			if((descObj.getValue() =='-1' || descObj.getValue() ==null || !valid)  && infoTest)
			{
				msg = chooseDescriptor;
				if (!Ext.isEmpty(msg)) 
				{
					Ext.MessageBox.show({
							title : 'Alert',
							msg : msg,
							buttons : Ext.MessageBox.OK,
							icon : Ext.MessageBox.WARNING,
							fn : function (buttonId)
							{
								if(searchObj!=null)
								{
									searchObj.setValue("");
								}
								var compStore = descriptorRawData;
								var compObj = Ext.getCmp('descriptionlist');
								compObj.getStore().loadRawData(compStore);
								if ( compObj.getStore().findExact('valueField', '-1', 0) == -1  && valid)
								{
									compObj.getStore().insert(0, {'valueField': '-1', 'displayField': chooseDescriptor});
								}
								if ( !Ext.isEmpty( comp ) && comp!="null")
								{							
									if(valid)
										compObj.setValue("-1");
									else
										compObj.setValue(defVal);
								}
								else
								{			
									if(valid)
										compObj.setValue("-1");
									else
										compObj.setValue(defVal);
								}
							}
						});
					return false;
				} else 
				{
					return true;
				}
			}
		}

		var settingsForm = this.getSettingsForm().getForm();
		var endhr = parseInt(settingsForm.findField('er_endhr').getValue());
		var endmin = parseInt(settingsForm.findField('er_endmin').getValue());
		var endtime = formatDate(settingsForm.findField('er_enddate').getValue(), "MM/dd/yyyy");
		var starthr = parseInt(settingsForm.findField('er_sthr').getValue());
		var startmin = parseInt(settingsForm.findField('er_stmin').getValue());
		var starttime = formatDate(settingsForm.findField('er_stdate').getValue(), "MM/dd/yyyy");
		
		if(dateValidation(starttime,endtime,starthr,endhr,startmin,endmin)==-1)
		{
			msg ="From date should be lesser than to date";
		}

		if (!Ext.isEmpty(msg)) {
			Ext.MessageBox.show({
						title : 'Alert',
						msg : msg,
						buttons : Ext.MessageBox.OK,
						icon : Ext.MessageBox.WARNING
					});
			return false;
		} else {
			return true;
		}
	},
	showResult : function(obj) {
		
		var fromSubmit = true;
		if (!this.beforeFormSubmit()) {
			return;
		}

		var queryString = 'resultpage=measure';
		var mainForm = this.getMeasuregraphForm().getForm();
		var settingsForm = this.getSettingsForm().getForm();
		var objectArr = new Array();
		objectArr['comp'] = mainForm.findField('hostlist').getValue();
		var compType = mainForm.findField('hostlist').getValue();


		compType = compType.substring(compType.lastIndexOf(':') + 1);
		objectArr['comptype'] = compType;

		var endhr= settingsForm.findField('er_endhr').dataArray;
		objectArr['endhr']=endhr;
		var endmin= settingsForm.findField('er_endmin').dataArray;
		objectArr['mgendmin']=endmin;
		objectArr['endmin']=endmin;
		var endtime= formatDate(new Date(getDateFromFormat(settingsForm.findField('er_enddate').dataArray, mgrDisplayDateFormat)), "MM/dd/yyyy");
        objectArr['endtime'] =endtime;

		var host = mainForm.findField('hostlist').getValue();
		host = host.substring(0, host.indexOf(':'));
		objectArr['host'] = host;
		var hostlist = mainForm.findField('hostlist').getValue();
		var testlist = mainForm.findField('testlist').getValue();
		
		var info = mainForm.findField('descriptionlist').getValue();
		if(info==-2)
		{
			info="";
		}
		
		try
		{
			if(info.indexOf('*') > 0 && info.charAt(0)!='*')
				info = info;
			else
				info = '*' + info;
		}
		catch (e)
		{
			if(info.indexOf('*') > -1)
				info = info;
			else
				info = '*' + info;
		}
		
		

		if (info.indexOf('&') > -1)
			info = info.replace('&', '|amp|');
		if (info.indexOf('+') > -1)
			info = info.replace('+', '|plus|');
		if (info.indexOf('%') > -1)
			info = info.replace('%', '|pct|');
		if (info.indexOf('#') > -1)
			info = info.replace('#', '|hash|');
			
			

		objectArr['hostlist'] = hostlist;
		objectArr['info'] = info;
		objectArr['layer'] = mainForm.findField('layerlist').getValue();
		objectArr['measure'] = mainForm.findField('measurelist').getValue();
		objectArr['msmt_host'] = mainForm.findField('msmt_host').getValue();
       
		var tmphostlist = hostlist.substring(hostlist.indexOf(':') + 1);
		var port = tmphostlist.substring(0, tmphostlist.indexOf(':'));

		objectArr['port'] = port;

		var site = mainForm.findField('sitelist').getValue();
		if(site==-1)
		{
			site="NULL";
		}

		objectArr['site'] = site;
		var starthr= settingsForm.findField('er_sthr').dataArray;
		objectArr['starthr']=starthr;
		var startmin= settingsForm.findField('er_stmin').dataArray;
		objectArr['mgstmin']=startmin;
		objectArr['startmin']=startmin;
		var stdatetime = formatDate(new Date(getDateFromFormat(settingsForm.findField('er_stdate').dataArray, mgrDisplayDateFormat)), "MM/dd/yyyy");
		objectArr['starttime'] = stdatetime;
		var desc = mainForm.findField('descriptionlist').getValue();
		var test = mainForm.findField('testlist').getValue();
		if(desc==-2)
		{
			desc="";
		}
		var stest = test +"-+"+desc;
		var time = settingsForm.findField('er_timeline').getValue();
		stest = stest.replace('+', '*');
		stest=parent.filterEncode(stest);
		objectArr['stest'] = encodeURIComponent(stest);
		objectArr['test'] = encodeURIComponent(test);
		objectArr['time'] = encodeURIComponent(time);
		objectArr['gtype'] = "0";
		objectArr['gformat'] = "graph";


       //Date validation

		if(new Date(stdatetime) > new Date(endtime))
		{
			/*Ext.MessageBox.show({
				title: 'Alert',
				msg: "Start date should be lesser than end date",
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		*/
		}
		if(new Date(stdatetime).valueOf() == new Date(endtime).valueOf())
		{	
			/*if(starthr  >endhr)
			{
				Ext.MessageBox.show({
				title: 'Alert',
				msg: "Start date should be lesser than end date",
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
			}
			*/
		}

		var today = new Date();
		var currentDate = today.getMonth() + "/" + today.getDay() + "/" + today.getYear();
		if(today < new Date(stdatetime) )
		{
			/*
			Ext.MessageBox.show({
				title: 'Alert',
				msg: "From date should be lesser than Current date",
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
				*/
		}
		
		if (stest.indexOf('\\') > -1) {
			var tmpTest = stest.split('\\');
			var encodeTest = '';
			for (var i = 0; i < tmpTest.length; i++) {
				if (i == (tmpTest.length - 1)) {
					encodeTest += tmpTest[i];
				} else {
					encodeTest += tmpTest[i] + '/';
				}
			}
			objectArr['encodetest'] = encodeTest;
		}

		var l_back = settingsForm.findField('lookback').getValue();
		var hist;
		if (l_back)
			hist = "true";
		else
			hist = "false";

		var otherTimeInterval = settingsForm.findField('er_otherTime').getValue();
       //converting time period hr to mins
		var strarr=otherTimeInterval.split(" ");
	    var strval=strarr[0];
	    var hr=parseInt(strval);
        var mins=hr*60;
          mins=''+mins;
        otherTimeInterval= mins;


		var er_interval = settingsForm.findField('er_interval').getValue();

		if (er_interval != null && er_interval != 'undefined' && er_interval == '180') {
			objectArr['otherTimeline'] = 'true';
			objectArr['otherTimeInterval'] = encodeURIComponent(otherTimeInterval);
		}
		

		var ltime;
		if (otherTimeInterval != null && er_interval == '180'&& otherTimeInterval.indexOf(" ") > -1) 
		{
			ltime = "1";
		} 
		else if ((er_interval != null || er_interval != 'null') && er_interval != 'undefined') 
		{
			ltime = settingsForm.findField('noOfTimes').getValue();
		}

		objectArr['l_times'] = ltime;
		objectArr['l_interval'] = er_interval;
		objectArr['l_back'] = hist;
		objectArr['min'] = settingsForm.findField('min').getValue();
		objectArr['max'] = settingsForm.findField('max').getValue();
		objectArr['showLegend'] = settingsForm.findField('showLegend').getValue();


		objectArr['isSubmit'] = 'true';

		queryString += this.genQueryString(objectArr);
		
      
		this.renderResult(queryString);


	},
	renderResult : function(queryString){
		M=this.getMain();
		var n = new Ext.LoadMask(M, {
		msg: "Loading..."
		});
		n.show();
		var highChartUrls = new Array();
		var highChartIds = new Array();
		var settingsForm = this.getSettingsForm().getForm();
		var l_back = settingsForm.findField('lookback').getValue();
		var charts = this.chartType();
		
		//queryString +="&startmin="+mgr_stmin+"&endmin="+mgr_enmin+"&min="+stmin;
        var me = this;
        Ext.Ajax.request({
            url : '/final/servlet/com.eg.EgMonitorResultDispatcher',
            params : queryString,
            success : function(response) {
				n.hide();
                var jsontext = response.responseText;
				var resultItems=me.getResultpanel().items.items;

				for(var item=resultItems.length-1; item>-1 ; item--)
				{
					if(resultItems[item].id.indexOf('gPanel_')>-1)
					{
						resultItems[item].destroy();
					}
				}
                var jsonObject = Ext.decode(jsontext);
                if (!Ext.isEmpty(jsonObject)) {
                    
                       var resultArray = jsonObject['resultarray'];
                      
                       var itemsArray=[];
					   if ( !Ext.isEmpty( resultArray ) )
					   {
					   		for(var i=0;i<resultArray.length;i++)
						   {
							   var resultObj = resultArray[i];
							   
							   var imgstr = resultObj['image'];
							   var headers = resultObj['headers'];
							   var data = resultObj['data'];
							   var str='';
							   if(!Ext.isEmpty(headers) && !Ext.isEmpty(data))
							   {
									str += '<div class="mesuregraph newTable" style="display:block;border:0px solid green;width:600px;overflow-x:auto;margin:auto;padding-bottom:0px"> '
									+ '<table cellspacing="0" cellpadding="0" border="1" style="width:auto !important;min-width:80%;margin: auto;">'
									+ '<thead>'
									+ '<tr>'
									+ '<th>'
									+ '<div >'+headers[0]+'</div>'
									+ '</th>'
									+ '<th>'
									+ '<div>'+headers[1]+'</div>'
									+ '</th>'
									+ '<th>'
									+ '<div>'+headers[2]+'</div>'
									+ '</th>'
									+ '<th>'
									+ '<div>'+headers[3]+'</div>'
									+ '</th>'
									/*+ '<th  >'
									+ '<div >'+headers[4]+'</div>'
									+ '</th>'*/
									+ '</tr>'
									+ '</thead>'
									+ '<tbody>';
									
									for ( var j = 0; j < data.length ; j=j+4 )
									{
										
										str += '<tr >'
										+ '<td>'
										+ '<div  style="white-space:nowrap !important;">'+data[j]+'</div>'
										+ '</td>'
										+ '<td>'
										+ '<div>'+data[j+1]+'</div>'
										+ '</td>'
										+ '<td>'
										+ '<div>'+data[j+2]+'</div>'
										+ '</td>'
										+ '<td>'
										+ '<div>'+data[j+3]+'</div>'
										+ '</td>'
										/*+ '<td>'
										+ '<div>'+data[j+4]+'</div>'
										+ '</td>'*/
										+ '</tr>';
									}
									str += '</tbody>'
									+ '</table>'
									+ '</div>';
							  }
						   var imgdiv = '';
						   var results = '';
						  if(charts.indexOf("highchart") > -1)
						   {
							  if(l_back)
							   {
									highchartsurl = '/final/servlet/com.egurkha.LookBackTimelineMeasures?'+queryString+"&chartType=highcharts";
									highChartIds.push('highChart'+i);
									highChartUrls.push(imgstr);
							   }
							  else
							   {
									highchartsurl = '/final/servlet/com.egurkha.TimelineMeasures?'+queryString;
									highChartIds.push('highChart'+i);
									highChartUrls.push(highchartsurl);
							   }
							   
								imgdiv = '<div id="highChart'+i+' style="width:600px:height:300px;display:block;float:left;border:0px solid blue"></div>';
								results = {
									xtype : 'scrollpanel',
									id:'table_conta',
									border:true,
									cls:'containerShadow',
									autoScroll:false,
									frame:true,
									margin:'5 10 10 10' ,
									padding:0,
									style:{'border':'0px solid yellow'},
									scroll:true,
									//height:'auto',
									layout: {
										type: 'auto',
										columns: 1
									},
									//layout:{type:'vbox',align:'stretch'},
									items : [{
												xtype : 'container',
												id:'highChart'+i,
												//height:'auto',
												layout:'fit',
												style : {
													'text-align' : 'center'
												},
												border:true,
												html : imgdiv,
												chartUrl:imgstr,
												l_back:l_back,
												
											}, {
												xtype : 'container',
												margin: '0 10 10 10',
												height:'auto',
												html : str
											}]
								}
								me.getResultpanel().add([
								{
									xtype:'panel',
									cls:'dataPanel',
									//margin:'10 10 5 0',
									autoScroll:true,
									id:'gPanel_'+i,
									scroll:true,
									bodyPadding:0,
									padding:0,
									title:"",
									height:348,
									listeners:{
										'resize':function(win){
											var winH=Ext.getBody().getViewSize().height- 240;
											win.setHeight(winH);
										}
									},
									layout: {
										type: 'auto',
										columns: 1
									},
									defaults: {
										// applied to each contained panel
										bodyStyle: 'padding:10px',
										//height:'50%'
									},
									style:{'width':'100% !important','text-align':'center !important','overflow':'visible !important'},

									items:[
									{
										xtype: 'container',
										//padding: '20 10 0 20',
										id:'highChart'+i,
										style:{'overflow-x':'hidden !important','width':'100%','text-align':'center !important','border':'0px solid green'},
										layout:'fit',
										html:imgdiv,
										//height:300,
										autoScroll:false,
										scroll:false,
										//width:'100%',
										chartUrl:imgstr,
										l_back:l_back,
									},{
										xtype : 'container',
										id:'dataPanelId',
										hidden:true,
										padding: '25 0 20 0',
										height:'auto',
										html : str
									}]
								}]);

								Ext.getCmp("resultPanel").hide();
						   }
						   else
						   {
							  imgdiv = '<div id="highChart'+i+' style="width:600px:height:250px;display:block;float:left;border:0px solid yellow"><img src = '+imgstr+'/></div>';
							  results = {
									xtype : 'container',
									width:'100%',
									items : [{
												xtype : 'container',
												style : {
													'text-align' : 'center'
												},
												html : imgdiv
											}, {
												xtype : 'container',
												html : str
											}]
									};
								Ext.getCmp("resultPanel").hide();
									
						   }	
						 }
					   }
					   else
					   {
							Ext.getCmp('saveTool').hide();
							Ext.getCmp('printTool').hide();
							Ext.getCmp('settingsSeparator').hide();
							Ext.getCmp('saveSeparator').hide();
							Ext.getCmp("dataTool").setDisabled(true);
							var results =	{
								xtype : 'container',
								html: '<div style="border:width:400px;margin:12% auto 0px auto;text-align:center"><div class = "iconInformation" style="margin:0px auto;"> </div><div>No Measures Found</div></div>'
								};
							
							itemsArray.push(results);
							  var result_Panel = Ext.create(
                            'MeasureGraphGenerator.view.ResultPanel', {
                                padding:0,
								cls:'egDummyClass',
                                bodyPadding:0,
								frame:true,
								border:true,
                                autoScroll:false,
                                id:'resultpanel',
                                items:itemsArray
                            });
                            me.getMain().add(result_Panel);
						}
					if(charts.indexOf("highchart") > -1)
					{
						Ext.getCmp('saveTool').hide();
						Ext.getCmp('printTool').hide();
						Ext.getCmp('settingsSeparator').hide();
						Ext.getCmp('saveSeparator').hide();
						var dataToolObj =  Ext.getCmp("dataTool");
						var isAxisTimeReq = true;
						var legendPos = "center";
						var clientWidth = Ext.getBody().getViewSize().width;
						var containerHeight = ( highChartIds.length > 1)?350:(Ext.getBody().getViewSize().height-260);
						for( var l in highChartIds)
						{
							var clientHeight = $('#'+highChartIds[l]).height();
							clientHeight = ( clientHeight <= 100 )?300:clientHeight;
							loadMe(highChartUrls[l],highChartIds[l],clientHeight,clientWidth-50,false,isAxisTimeReq,legendPos,dataToolObj,l_back);
						}
					}
					else
					{
				
						Ext.getCmp('saveTool').show();
						Ext.getCmp('printTool').show();
						Ext.getCmp('settingsSeparator').show();
						Ext.getCmp('saveSeparator').show();
					    Ext.getCmp("saveTool").setDisabled(false);
					    Ext.getCmp("printTool").setDisabled(false);
					    Ext.getCmp("dataTool").setDisabled(false);
						if(Ext.getCmp("upbutton")!=undefined)
					    Ext.getCmp("upbutton").setDisabled(false);
					}
                        me.getMain().doLayout();

                }
			}
        });
	},
	genQueryString : function(Arr) {
		var qStr = '';
		for (var key in Arr) {
			qStr += '&' + key + '=' + Arr[key];
		}
		Ext.getCmp('settings').queryString = qStr;
		return qStr;
	},
	saveFileTool : function(){
		
		var lback = Ext.getCmp('lookback').getValue();
		var queryString =  Ext.getCmp('settings').queryString;
		
		if(lback)
		{
			var meas = Ext.getCmp('measurelist').getValue();
		
            if(meas.indexOf(",")>-1)
            {
                var tmp = meas.split(',');
                for(var i=0;i<tmp.length;i++)
                {
                  
                    url = "/final/servlet/com.egurkha.LookBackTimelineMeasures?saveToFile=true"+queryString+"&gformat=graph&measureValue="+tmp[i];
                    window.location.href=url;
                }
            }
            else
            {
                url = "/final/servlet/com.egurkha.TimelineMeasures?saveToFile=true"+queryString+"&gformat=graph";
                window.location.href=url;
            }
            
		}
		else
		{
			url = "/final/servlet/com.egurkha.TimelineMeasures?saveToFile=true"+queryString+"&gformat=graph";
            window.location.href=url;
		}
	},
	printFile : function(){
		Ext.widget('print',{title:'MEASURE GRAPH'}).show();
        var printContentDiv = Ext.select('#printContentDiv');
        printContentDiv.set(
        {
            src : "EgPrintGraph.jsp?"+Ext.getCmp('settings').queryString+"&graph_type=measuregraph" 
        });
		
	},
	dataFile : function(){
		
		var lback = Ext.getCmp('lookback').getValue();
        var queryString =  Ext.getCmp('settings').queryString;
        var url;
        if(lback)
        {
            url="/final/servlet/com.egurkha.LookBackTimelineMeasures?gformat=report&"+queryString,"Linereport","width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable=yes";
                        
        }
        else
        {
          url="/final/servlet/com.egurkha.TimelineMeasures?gformat=report&"+queryString,"Linereport","width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable=yes";
           
        }
        
        //Ext.widget('print').show();
		Ext.widget('print',{title:'GRAPH DATA'}).show();
        var printContentDiv = Ext.select('#printContentDiv');
        printContentDiv.set(
        {
        src :  url
        });
	},
	filterMultiselect:function(obj, event)
    {
        var findVal = obj.getValue();
		var mainForm = this.getMeasuregraphForm().getForm();
        var compStore = componentsRawData;
        var compObj = Ext.getCmp('hostlist');
        var isRecordFound = false;
        if ( Ext.isEmpty( obj.getValue() ) )
        {
            compObj.getStore().loadRawData(compStore);
            if ( compObj.getStore().findExact('valueField', '-1', 0) == -1 )
            {
                compObj.getStore().insert(0, {'valueField': '-1', 'displayField': chooseComp});
            }
            if ( !Ext.isEmpty( comp ) && comp!="null")
            {
                compObj.setValue(comp);    
            }
            else
            {
                compObj.setValue('-1');
            }
        }
        else
        {
            var genStore = new Ext.data.Store({
                                    fields : ['displayField', 'valueField'],
                                    data : []                               
                                });

			if(findVal!=null)
				findVal=findVal.toLowerCase();

            for ( var i = 1; i < compStore.length ; i++ )
            {
                var getRecord = compStore[i]['displayField'];
				if(getRecord!=null)
					getRecord=getRecord.toLowerCase();

                if ( getRecord.indexOf(findVal) > -1 )
                {
                    isRecordFound = true;
                    genStore.add({
                        'displayField': compStore[i]['displayField'],
                        'valueField': compStore[i]['valueField']
                    });
                }
            }
           
            if ( isRecordFound )
            {
                compObj.getStore().removeAll(); 
                for ( var i = 0; i < genStore.getCount() ; i++ )
                {
                    var getRecord = genStore.getAt(i);
                    compObj.getStore().add(getRecord);
                }
                compObj.setValue(genStore.getAt(0).get('valueField'));
            }
            else
            {
                compObj.getStore().removeAll();
                compObj.getStore().add({
                    'displayField': 'Not Applicable!',
                    'valueField': '-1'
                });
                compObj.setValue('-1');
				this.setNotApplicable(mainForm, 'layerlist',defaultJSON.screenLabels['monitor.common.DefaultLayerOption']);
				this.setNotApplicable(mainForm, 'testlist',	defaultJSON.screenLabels['monitor.common.DefaultTestOption']);
				this.setNotApplicable(mainForm, 'msmt_host',defaultJSON.screenLabels['monitor.common.DefaultMsmthostOption']);
				this.setNotApplicable(mainForm,	'measurelist',defaultJSON.screenLabels['monitor.common.DefaultMeasureOption2']);
            }
            obj.focus();
        }
        if ( isRecordFound || parseInt( event.getCharCode() ) == 13 )
        {
            this.component_onchange(Ext.getCmp('hostlist'));
        }
    },
	chartType:function()
	{
		var mainForm = this.getMeasuregraphForm().getForm();
		var settingsForm = this.getSettingsForm().getForm();

		var HIGH_CHART = "highcharts";
		var EASY_CHART = "easychart";
		var timelineCombo = defaultJSON.timelinedetails['timeline'];
		var iniChartValues = defaultJSON.timelinedetails['iniChartValues'];
		var stDateObj = Ext.getCmp('er_stdate').getValue();
		var endDateObj = Ext.getCmp('er_enddate').getValue();
		var stHr = Ext.getCmp('er_sthr').getValue();
		var endHr = Ext.getCmp('er_endhr').getValue();
		var stMin = Ext.getCmp('er_stmin').getValue();
		var endMin = Ext.getCmp('er_endmin').getValue();

		var opcArray = new Array();
		var timeOptions = new Array();
		for (var key in timelineCombo) 
		{
			timeOptions[key] = timelineCombo[key].valueField;
		}
		
		var chartOption = iniChartValues[0].chartOpt;
		var chartTimeline = iniChartValues[1].chartTime;
		var chartOpt = chartOption;
		chartOption=(chartOption==null || chartOption.trim().length ==0)?"easycharts":chartOption;
		chartOption = chartOption.toLowerCase();
		if(chartOption != null && chartOption.trim().length > 0 && chartOption.indexOf("easy") == -1)
		{
			var selectedDate = settingsForm.findField('er_timeline').getValue();
			var strtdt = Ext.Date.dateFormat(stDateObj, 'm/d/Y');
			var enddt = Ext.Date.dateFormat(endDateObj,'m/d/Y');
			chartOpt = getChartValue(chartTimeline,chartOption,selectedDate,strtdt,stHr,enddt,endHr)
		}
		else
			chartOpt = "graph";

		return chartOpt;
	},
	descriptorOptSelect :function(obj, event)
	{
		searchObj = obj;
		var findVal = obj.getValue();
		var mainForm = this.getMeasuregraphForm().getForm();
		var compStore = descriptorRawData;
		var compObj = Ext.getCmp('descriptionlist');
		var isRecordFound = false;
		if ( Ext.isEmpty( obj.getValue() ) )
		{
			compObj.getStore().loadRawData(compStore);
			if ( compObj.getStore().findExact('valueField', '-1', 0) == -1 )
			{
				compObj.getStore().insert(0, {'valueField': '-1', 'displayField': chooseDescriptor});
			}
			if ( !Ext.isEmpty( comp ) && comp!="null")
			{
				compObj.setValue(comp);    
			}
			else
			{
				compObj.setValue('-1');
			}
		}
		else
		{
			var genStore = new Ext.data.Store({
									fields : ['displayField', 'valueField'],
									data : []                               
								});
			if(findVal!=null)
				findVal=findVal.toLowerCase();
		for ( var i = 1; i < compStore.length ; i++ )
		{
			var getRecord = compStore[i]['displayField'];
			if(getRecord!=null)
				getRecord=getRecord.toLowerCase();
			if ( getRecord.indexOf(findVal) > -1 )
			{
				isRecordFound = true;
				genStore.add({
					'displayField': compStore[i]['displayField'],
					'valueField': compStore[i]['valueField']
				});
			}
		}
		if ( isRecordFound )
		{
			compObj.getStore().removeAll(); 
			for ( var i = 0; i < genStore.getCount() ; i++ )
			{
				var getRecord = genStore.getAt(i);
				compObj.getStore().add(getRecord);
			}
			compObj.setValue(genStore.getAt(0).get('valueField'));
		}
		else
		{
			compObj.getStore().removeAll();
			compObj.getStore().add({
				'displayField': 'Not Applicable!',
				'valueField': '-1'
			});
			compObj.setValue('-1');
			if(findVal=="")
			{
				this.setNotApplicable(form,'descriptionlist',chooseDescriptor);
			}
		}
		obj.focus();
	 }
	}
});
function dateValidation(starttime,endtime,starthr,endhr,startmin,tomin)
{	
	var styear = parseInt(starttime.substring((starttime.lastIndexOf("/")+1)));		
	var stday = parseInt(starttime.substring((starttime.indexOf("/")+1),starttime.lastIndexOf("/")));
	var stmon = parseInt(starttime.substring(0,starttime.indexOf("/")));
	var endyear = parseInt(endtime.substring((endtime.lastIndexOf("/")+1)));
	var endday = parseInt(endtime.substring((endtime.indexOf("/")+1),endtime.lastIndexOf("/")));
	var endmon = parseInt(endtime.substring(0,endtime.indexOf("/")));
	var state=0;	
	if(styear > endyear)			
		state=-1;		
	else if(styear == endyear)			
		if(stmon > endmon)				
			state=-1;				
		else if(stmon == endmon)
			if(stday > endday)						
				state=-1;
			else if(stday == endday)
				if(starthr > endhr)
					state = -1;
				else if(starthr == endhr)
					if(startmin >= tomin)
						state = -1;
	
	return state;
}