Ext.define('MeasureGraphGenerator.view.Main', {
		extend: 'utilities.OuterPanel',
		alias: 'widget.main',
		frame:true,
		requires: [
				'utilities.Utilities',
				'utilities.EmptyPanel',
				'utilities.Settings',
				'utilities.CommonPanel',
				'utilities.ScrollCombo',
				'utilities.Print',
				'utilities.ScrollPanel',
				'MeasureGraphGenerator.view.MeasureGraphForm',
				'MeasureGraphGenerator.view.SettingsForm',
				'MeasureGraphGenerator.view.ResultPanel'
		],
		title: pageTitle,
		padding:0,
		margin:'8 8 0 8',
		scroll:false,
		autoScroll:false,
		bodyPadding:0,
		id: 'measure_graph',
		tools: [{
            xtype: 'button',
            iconCls: 'iconSettings',
           listeners: {
                        afterrender: function () {
                            Ext.create('Ext.tip.ToolTip', {
                                target: this.id,
                                anchor: 'top',
                                cls: 'yellowTip',
                                trackMouse: true,
                                html: settings
                            });
                        }
                    },
				style:{
					background:'none',border:'0px'
					},
            handler: function (event, toolEl, panel) {
                 Ext.get('configMod').animate({to: {y: 41},listeners:{ afteranimate:function(){  Ext.get('configMod').setStyle('left', '');}}}).show();
            }

			}, {
				xtype: 'tbseparator',
				id:'settingsSeparator',
			}, {
				xtype: 'utilitiestool'
			}
		],
		layout: {
			type: 'vbox',
			align: 'stretch'
		},
		items: [{
					xtype: 'measuregraphForm'
				},
				{
					xtype:'resultpanel',
					items : [{
							xtype : 'container',
							border:false,
							frame:false,
							id:'resultPanel'
						}],
						listeners:{
							'resize':function(panel){
								var pWidth=Ext.getBody().getViewSize().width - 70;
								var pHeight=Ext.getBody().getViewSize().height - 237;
								panel.setHeight(pHeight);
								panel.doLayout();
							}
						}
					
				}
				
		],
		listeners: {
			'afterrender': function () {
				this.showConfigDropdown();

			}
		},
		showConfigDropdown: function () {
			var me = this;
			var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 4px;color:#f7f7f7" class="settingsfont"><b>'+defultSettings+'</b></div><div style="text-align:right;float:right;"><div class="iconClose3" id="close"></div></div>');
			Ext.create('Ext.container.Container', {
				padding: 5,
				id: 'configMod',
				margin:'0 0 0 0',
				cls: 'configMode_popup monitorpopup',
				items: [{
					xtype:'container',
					cls:'configMode_popupArrow',
					style:{'top':'-14px','left':'513px'}
				},
				{
					xtype:'container',
					html:tpl.apply(),
					style:{'top':'0px','margin':'0px 2px 2px 2px'}
				},{
						xtype: 'settingsForm',
						parent: me
					}
				],
				renderTo: 'measure_graph-body',
				listeners:{
				 render: function () {
                    Ext.get("close").on("click", function () {
                        Ext.get("configMod").animate({
                            duration: 500,
                            to: {
                                y: -350
                            }
                        });
                    });
                }
			}
			});
		}
	});