Ext.define('MeasureGraphGenerator.view.MeasureGraphForm',{
	extend:'Ext.form.Panel',
	alias:'widget.measuregraphForm',
	requires:['Ext.ux.form.MultiSelect'],
	collapseMode:'mini',
	initComponent: function(){
		//this.bodyPadding ='0 20 0 20';
		this.buttonAlign = 'center';
		this.callParent()
	},
	items:[
				{
					xtype:'panel',
					layout: 'column',						
					bodyPadding:'10 0 5 0',
					cls:'formOuter monitorsettingsborder',
					defaults:{
						labelAlign: 'top',
						labelSeparator:''
					},					
					items:[
					
					{
						xtype:'scrollcombo',
						cls: 'dropdown',
						width: 230,
						margin:'0 10 10 10',
						editable : false,
						fieldLabel:serviceLbl,
						id:'sitelist',
						name:'sitelist',
						store: new Ext.data.Store({
							fields : ['displayField', 'valueField'],
							data : []
						}),
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local'
						//hidden: true
					},
					{
						fieldLabel: filterBylbl+'(Optional)',
						xtype: 'triggerfield',
						id:'filterOpt',
						name:'filterOpt',
						hidden:true,
						enableKeyEvents : true,
						labelAlign: 'top',
						cls: 'whitedropdown_search',
						width: 150,
						margin:10																
					},
					{
						xtype:'scrollcombo',
						width:230,
						margin:'0 10 10 10',
						cls: 'dropdown',
						fieldLabel:componentTypeLbl,
						id:'complist',
						name:'complist',
						editable : true,
						store: new Ext.data.Store({
							fields : ['displayField', 'valueField'],
							data : []
						}),
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local'
						//hidden: true
					},
					{
						xtype:'scrollcombo',
						width:230,
						margin:'0 10 10 10',
						cls: 'dropdown',
						fieldLabel:componentLbl,
						id:'hostlist',
						name:'hostlist',
						editable : true,
						store: new Ext.data.Store({
							fields : ['displayField', 'valueField'],
							data : []
						}),
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local'
						//hidden: true
					},					
					{
						xtype:'scrollcombo',
						width: 230,
						margin:'0 10 10 10',
						cls: 'dropdown',
						editable : true,
						fieldLabel:layerLbl,
					    id:'layerlist',
					    name:'layerlist',
						store: new Ext.data.Store({
							fields : ['displayField', 'valueField'],
							data : []
						}),
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local'
						//hidden: true
						
					},
					{
						xtype:'scrollcombo',
						width: 230,
						margin:'0 10 10 10',
						cls: 'dropdown',
						fieldLabel:testLbl,
						id:'testlist',
						name:'testlist',
						editable : true,
						typeAhead:true,
						listConfig:{
							emptyText:'<li style="padding:0 10px 0 8px">No record found</li>'
						},
						store: new Ext.data.Store({
							fields : ['displayField', 'valueField'],
							data : []
						}),
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local'
						
					},
					{
						fieldLabel: 'Search',
						xtype: 'triggerfield',
						id:'descriptionOpt',
						name:'descriptionOpt',
						hidden:true,
						enableKeyEvents : true,
						labelAlign: 'top',
						cls: 'whitedropdown_search',
						width: 150,
						margin:10
					},
					{
						xtype:'scrollcombo',
						width: 230,
						margin:'0 10 10 10',
						cls: 'dropdown',
						fieldLabel:'Descriptor',
						id:'descriptionlist',
						name:'descriptionlist',
						editable : true,
						hidden:true,
						typeAhead:true,
						listConfig:{
							emptyText:'<li style="padding:0 10px 0 8px">No record found</li>'
						},
						store: new Ext.data.Store({
							//fields : ['displayField', 'valueField'],
							fields:[{name:'displayField',convert:function(value, record){
								return Ext.String.htmlDecode(value);
							}},'valueField'],
							data : []
						}),
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local'
					},
					{
						xtype:'scrollcombo',
						width: 230,
						margin:'0 10 10 10',
						cls: 'dropdown',
						fieldLabel:MsmtHostLbl,
						id:'msmt_host',
						name:'msmt_host',
						editable : false,
						typeAhead:true,
						listConfig:{
							emptyText:'<li style="padding:0 10px 0 8px">No record found</li>'
						},
						store: new Ext.data.Store({
							fields : ['displayField', 'valueField'],
							data : []
						}),
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local'
						
					},
					
					{
				xtype:'panel',
					height: 100,
					layout:{
						type: 'vbox'
					},				
					defaults:{
						margin:5,
						//padding:'10px 10px 10px 10px',
						labelSeparator:'',
					},
					//flex:2,
					items:[
						{
							xtype:'label',
							html:'<div>'+measuresLbl+'</div>',
						    margin:'10 10 5 10',	
						},
						
								{
								
								xtype: 'multiselect',
								height:60,
								margin:'0 10 0 10',	
								width:250,
								 scroll: false,
                                autoScroll: false,
								labelAlign:'left',
								allowBlank: false,
								id: 'measurelist',
								name: 'measurelist',
								value: '',
								store: new Ext.data.Store({
									fields : ['displayField', 'valueField'],
									data : [],
									listeners:{
											'load': function(store, records)
											{
												var compsObj = Ext.getCmp('components');

												if ( !Ext.isEmpty( store ) && !Ext.isEmpty( compsObj ) )
												{
													var getNAIndex = store.findExact('valueField', 'Not Applicable', 0);
													if ( getNAIndex == -1 )
													{
														var getModel = store.getAt(0);
														var getFirstValueField = getModel.get('valueField');
														compsObj.setValue(getFirstValueField);
													}
												}
												
											}
									}								
								}),
								displayField: 'displayField',
								valueField: 'valueField',
								queryMode: 'local'
								}/*,{
								xtype : 'container',
								margin : '35% 5px 0 5px',
								//cls : 'iconBg',
								items : [{
											xtype : 'button',
											iconCls : 'iconMultiselectExpand',
											id:'expandSelector',
											tooltip : '<b>components</b>',
											style : {
												background : 'none',
												border : '0px'
											}
										}]
							
						}*/
							
					]
				},
				{           xtype:'button', 
							text: graphBtn,
							cls: 'button20',
							id: 'submit',
							name: 'submit',
							margin:'29px 0px 0px 10px',			
						},
				
					]
					
				}
				
				
			]
})