Ext.define('InfosAndDescriptor.controller.Main', {
    extend: 'Ext.app.Controller',
	stores:['Measures','InfoTable'],
	models:['Measure'],
    views:['Main','EmptyPanel','InfoComponent','InfoTable','StaticDisplayFields','SearchField','Measures','MeasuresGrid','AlarmDetails','AggregateWindow','TestInfo','ThreadDetails','CompositeWindow'],
	backArray:[],
	lastInfoChoosen:'',
	refreshRate:null,
	params:'',
	
	refs:[{
		selector:'main',
		ref:'main'
	},{
		selector:'main button[itemId=back]',
		ref:'backButton'
	},{
		selector:'staticfields',
		ref:'staticFields'
	},{
		selector:'main measures',
		ref:'measures'
	},{
		selector:'main infotable',
		ref:'infoTable'
	},{
		selector:'main measures emptypanel',
		ref:'errorPanel'
	},{
		selector:'main measures button#details',
		ref:'detailButton'
	},{
		selector:'main measures button#remoteControl',
		ref:'remoteButton'
	},{
		selector:'main measures button#help',
		ref:'helpButton'
	},{
		selector:'main measures measuresgrid[itemId=measureGrid]',
		ref:'measuresGrid'
	},{
		selector:'main searchfield',
		ref:'searchField'
	},{
		selector:'main trigger',
		ref:'searchTrigger'
	},{
		ref:'testInfo',
		selector:'testinfo'
	},{
		ref:'configureThresholds',
		selector:'configurethresholds'
	},{
		ref:'alarmDetails',
		selector:'alarmdetails'
	},{
		ref:'aggregateWindow',
		selector:'aggregatewindow'
	},{
		ref:'compositeWindow',
		selector:'compositewindow'
	},{
		ref:'threadDetails',
		selector:'threaddetails'
	},{
		ref:'alarmDetailsTableContainer',
		selector:'alarmdetails container#tableContainer'
	},{
		ref:'testInfoTableContainer',
		selector:'testinfo container#tableContainer'
	}],
	
	init:function(){
		this.control({
			'testinfo button[itemId="iconTestConfig"]': {
				click: this.testConfigureEvent
			},
			'main':{
				render: function(button){
					if(Ext.isEmpty(this.getTestInfo()))
						Ext.create('InfosAndDescriptor.view.TestInfo');
					if(Ext.isEmpty(this.getAlarmDetails()))
						Ext.create('InfosAndDescriptor.view.AlarmDetails');
					if(Ext.isEmpty(this.getAggregateWindow()))
						Ext.create('InfosAndDescriptor.view.AggregateWindow');
					if(Ext.isEmpty(this.getCompositeWindow()))
						Ext.create('InfosAndDescriptor.view.CompositeWindow');
					if(Ext.isEmpty(this.getThreadDetails()))
						Ext.create('InfosAndDescriptor.view.ThreadDetails');
					if(Ext.isEmpty(this.getConfigureThresholds()))
						Ext.create('InfosAndDescriptor.view.ConfigureThresholds');
				},
			},
			'main infotable':{
				render:this.loadMoreInfoData
			},
			'main searchfield trigger':{
				specialkey:this.infoSearchKeyPress,
				click:this.loadMoreInfoData
			},
			'main infotable infocomponent':{
				render:this.renderComponent
			},
			'main button[itemId=back]':{
				click:this.backHandler
			},
			'main measures button#details':{
				click:this.detailsClicked
			},
			'main measures button#remoteControl':{
				click:this.remoteClicked
			},
			'main measures button#help':{
				click:this.helpClicked
			},
			'main measures button#logon':{
				click:this.LogonDetailsPopUpClicked
			},
			'configurethresholds slider[id="relMinCritical"]':
			{
				'drag': this.minRelCriticalSlider,
				'change': this.minRelCriticalSlider,
			},
			'configurethresholds slider[id="relMinMajor"]':
			{
				'drag': this.minRelMajorSlider,
				'change': this.minRelMajorSlider,
			},
			'configurethresholds slider[id="relMinMinor"]':
			{
				'drag': this.minRelMinorSlider,
				'change': this.minRelMinorSlider,
			},
			'configurethresholds slider[id="relMaxCritical"]':
			{
				'drag': this.maxRelCriticalSlider,
				'change': this.maxRelCriticalSlider,
			},
			'configurethresholds slider[id="relMaxMajor"]':
			{
				'drag': this.maxRelMajorSlider,
				'change': this.maxRelMajorSlider,
			},
			'configurethresholds slider[id="relMaxMinor"]':
			{
				'drag': this.maxRelMinorSlider,
				'change': this.maxRelMinorSlider,
			},
			'configurethresholds checkbox[id="minStaticCheck"]':  
			{
				'change': this.minStaticCheckChange,
			},
			'configurethresholds checkbox[id="minAutoCheck"]':
			{
				'change': this.minAutoCheckChange,
			},
			'configurethresholds checkbox[id="maxStaticCheck"]':
			{
				'change': this.maxStaticCheckChange,
			},
			'configurethresholds checkbox[id="maxAutoCheck"]':
			{
				'change': this.maxAutoCheckChange,
			},
			'configurethresholds combo[id="alarmPolicyCombo"]':
			{
				'select': this.alarmPolicyChange,
			},
			'configurethresholds button[id="updateBtn"]':
			{
				'click': this.applyThresholdsData
			}
		});
	},

	// Function to handle the search by key board Enter key press
	infoSearchKeyPress:function(field, e){
		if (e.getKey() == e.ENTER) {
			this.loadMoreInfoData(field, e);
		}
	},
	testConfigureEvent : function()
	{
		var queryStr = '/final/admin/EgSpecificTestConfiguration.jsp?reqfrom=LayerModel&showUnconfigCompType=false&testType=PerformanceTest&com.eg.CSRF_NONCE='+csrfToken;
		var tmpQueryStr = 'reqfrom=LayerModel&showUnconfigCompType=false&testType=PerformanceTest&com.eg.CSRF_NONCE='+csrfToken;

		if (!Ext.isEmpty(Ext.getCmp('testname1').layerName))
		{
			queryStr += '&layerName='+Ext.getCmp('testname1').layerName;
			tmpQueryStr += '&layerName='+Ext.getCmp('testname1').layerName;
		}
		if (!Ext.isEmpty(Ext.getCmp('testname1').testName))
		{
			queryStr += '&testName='+Ext.getCmp('testname1').testName;
			queryStr += '&layerTestName='+Ext.getCmp('testname1').testName;

			tmpQueryStr += '&testName='+Ext.getCmp('testname1').testName;
			tmpQueryStr += '&layerTestName='+Ext.getCmp('testname1').testName;
		}
		if (!Ext.isEmpty(Ext.getCmp('testname1').testStateName))
		{
			queryStr += '&clickedFrom='+Ext.getCmp('testname1').testStateName;
			tmpQueryStr += '&clickedFrom='+Ext.getCmp('testname1').testStateName;
		}
		if (!Ext.isEmpty(Ext.getCmp('testname1').compType))
		{
			queryStr += '&componentType='+Ext.getCmp('testname1').compType;
			tmpQueryStr += '&componentType='+Ext.getCmp('testname1').compType;
		}
		if (!Ext.isEmpty(Ext.getCmp('testname1').compName))
		{
			queryStr += '&componentName='+Ext.getCmp('testname1').compName;
			tmpQueryStr += '&componentName='+Ext.getCmp('testname1').compName;
		}
		
		if (!Ext.isEmpty(Ext.getCmp('testname1').monSource))
		{
			queryStr += '&monSource='+Ext.getCmp('testname1').monSource;
			tmpQueryStr += '&monSource='+Ext.getCmp('testname1').monSource;
		}

		if (!Ext.isEmpty(Ext.getCmp('testname1').monDescName))
		{
			queryStr += '&monDescName='+encodeURIComponent(Ext.getCmp('testname1').monDescName);
			tmpQueryStr += '&monDescName='+encodeURIComponent(parent.filterEncode(Ext.getCmp('testname1').monDescName));
		}
		
		if (!Ext.isEmpty(Ext.getCmp('testname1').monTestState))
		{
			queryStr += '&monTestState='+Ext.getCmp('testname1').monTestState;
			tmpQueryStr += '&monTestState='+Ext.getCmp('testname1').monTestState;
		}

		var wholeViewport = document.getElementsByTagName("body")[0];
		mask = new Ext.LoadMask(Ext.get(wholeViewport), {msg:"Loading...",cls:'maskDash'});
		mask.show();

		Ext.Ajax.request({
			url : "/final/admin/SpecificTestConfiguration/data/MonitorURL.jsp?"+tmpQueryStr,
			method : 'POST',
			params: {
				hitFrom: 'monitor'
			},
			scope:this,
			async: false,
			success : function(response, opts){
				mask.hide();
			},
			failure : function(){}
		});

		//window.parent.goToTestConfiguration(indexTabURL.adminTabURL+'&monLayerUrl='+encodeURIComponent(queryStr));
		if(window.opener){
			window.opener.goToTestConfiguration(indexTabURL.adminTabURL+'&monLayerUrl='+encodeURIComponent(parent.filterEncode(queryStr)));
			window.close();
		}
	},
	alarmPolicyChange: function()
	{
		var alarmPolicy = Ext.getCmp('alarmPolicyCombo').getValue();
		var tmpDescription = publicJson['alarmPolicyDescriptionObj'][alarmPolicy]
		Ext.getCmp('alarmDispField').setValue(tmpDescription);
	},
	maxStaticFieldChange: function(field){
		var maxStaticCheck = Ext.getCmp('maxStaticCheck').getValue();
			copyField = Ext.getCmp(field.id);

		if (maxStaticCheck) {
			copyField.reset();
		} else {
			copyField.clearInvalid();
		}
	},
	maxAutoFieldChange: function(field){
		var maxAutoCheck = Ext.getCmp('maxAutoCheck').getValue();
			copyField = Ext.getCmp(field.id);

		if (maxAutoCheck) {
			copyField.reset();
		} else {
			copyField.clearInvalid();
		}
	},
	minStaticFieldChange: function(field){
		var minStaticCheck = Ext.getCmp('minStaticCheck').getValue();
			copyField = Ext.getCmp(field.id);

		if (minStaticCheck) {
			copyField.reset();
		} else {
			copyField.clearInvalid();
		}
	},
	minAutoFieldChange: function(field){
		var minAutoCheck = Ext.getCmp('minAutoCheck').getValue();
			copyField = Ext.getCmp(field.id);

		if (minAutoCheck) {
			copyField.reset();
		} else {
			copyField.clearInvalid();
		}
    },
	maxStaticCheckChange: function(box, checked)
	{
		//max static block specific description for BusinessTransTest,KBusinessTransTest
		if (publicJson.isToolTip && !checked)
		{
			Ext.getCmp('absMaxCritical').setFieldLabel('Critical <img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
			Ext.getCmp('absMaxMajor').setFieldLabel('Major <img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
		}
		else
		{
			Ext.getCmp('absMaxCritical').setFieldLabel(criticalText);
			Ext.getCmp('absMaxMajor').setFieldLabel(majorText);
		}

		Ext.getCmp('allMeasureContainer').hide();
        var fieldset = box.ownerCt;
        Ext.Array.forEach(fieldset.query('textfield'), this.maxStaticFieldChange, this);
        Ext.Array.forEach(fieldset.query('textfield'), function(field) {
            field.setDisabled(checked);
            if (!Ext.isIE6) {
                field.el.animate({opacity: checked ? 0.3 : 1});
            }
        });

		var isAllMeasureCheck = false;
		var allMeasureCheck = publicJson['applyOtherMeasure_check_box'];
		if (allMeasureCheck != null && allMeasureCheck != 'undefined' && (allMeasureCheck == 'true'))
		{
			isAllMeasureCheck = true;
		}
		if(checked && isAllMeasureCheck)
		{
			var minStaticCheck = Ext.getCmp('minStaticCheck').getValue();
			var minAutoCheck  = Ext.getCmp('minAutoCheck').getValue();
			var maxStaticCheck = Ext.getCmp('maxStaticCheck').getValue();
			var maxAutoCheck = Ext.getCmp('maxAutoCheck').getValue();
			if(minStaticCheck && minAutoCheck && maxStaticCheck && maxAutoCheck)
			{
				Ext.getCmp('allMeasureContainer').show();
			}
			else
			{
				Ext.getCmp('allMeasureContainer').hide();
			}
		}
    },
	maxAutoCheckChange: function(box, checked)
	{
		//max auto block specific description for BusinessTransTest,KBusinessTransTest
		if (publicJson.isToolTip && !checked)
		{
			Ext.getCmp('relMaxCritical').setFieldLabel('Critical (% Tolerance) <img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
			Ext.getCmp('relMaxMajor').setFieldLabel('Major (% Tolerance) <img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
		}
		else
		{
			Ext.getCmp('relMaxCritical').setFieldLabel(autoCriText);
			Ext.getCmp('relMaxMajor').setFieldLabel(autoMajorText);
		}

		Ext.getCmp('allMeasureContainer').hide();
        var fieldset = box.ownerCt;
        Ext.Array.forEach(fieldset.query('slider'), this.maxAutoFieldChange, this);
        Ext.Array.forEach(fieldset.query('slider'), function(field) {
            field.setDisabled(checked);
            if (!Ext.isIE6) {
                field.el.animate({opacity: checked ? 0.3 : 1});
            }
        });
        Ext.Array.forEach(fieldset.query('displayfield'), this.minAutoFieldChange, this);
        Ext.Array.forEach(fieldset.query('displayfield'), function(field) {
			if (field.id == 'maxThreshDisplayField')
			{
			}
			else
			{

				field.setDisabled(checked);
				if (!Ext.isIE6) {
					field.el.animate({opacity: checked ? 0.3 : 1});
				}
			}
        });

		var isAllMeasureCheck = false;
		var allMeasureCheck = publicJson['applyOtherMeasure_check_box'];
		if (allMeasureCheck != null && allMeasureCheck != 'undefined' && (allMeasureCheck == 'true'))
		{
			isAllMeasureCheck = true;
		}
		if(checked && isAllMeasureCheck)
		{
			var minStaticCheck = Ext.getCmp('minStaticCheck').getValue();
			var minAutoCheck  = Ext.getCmp('minAutoCheck').getValue();
			var maxStaticCheck = Ext.getCmp('maxStaticCheck').getValue();
			var maxAutoCheck = Ext.getCmp('maxAutoCheck').getValue();
			if(minStaticCheck && minAutoCheck && maxStaticCheck && maxAutoCheck)
			{
				Ext.getCmp('allMeasureContainer').show();
			}
			else
			{
				Ext.getCmp('allMeasureContainer').hide();
			}
		}
    },
	minStaticCheckChange: function(box, checked)
	{
		//min static block specific description for BusinessTransTest,KBusinessTransTest
		if (publicJson.isToolTip && !checked)
		{
			Ext.getCmp('absMinCritical').setFieldLabel('Critical <img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
			Ext.getCmp('absMinMajor').setFieldLabel('Major <img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
		}
		else
		{
			Ext.getCmp('absMinCritical').setFieldLabel(criticalText);
			Ext.getCmp('absMinMajor').setFieldLabel(majorText);
		}

		Ext.getCmp('allMeasureContainer').hide();
        var fieldset = box.ownerCt;
        Ext.Array.forEach(fieldset.query('textfield'), this.minStaticFieldChange, this);
        Ext.Array.forEach(fieldset.query('textfield'), function(field) {
            field.setDisabled(checked);
            if (!Ext.isIE6) {
                field.el.animate({opacity: checked ? 0.3 : 1});
            }
        });

		var isAllMeasureCheck = false;
		var allMeasureCheck = publicJson['applyOtherMeasure_check_box'];
		if (allMeasureCheck != null && allMeasureCheck != 'undefined' && (allMeasureCheck == 'true'))
		{
			isAllMeasureCheck = true;
		}
		if(checked && isAllMeasureCheck)
		{
			var minStaticCheck = Ext.getCmp('minStaticCheck').getValue();
			var minAutoCheck  = Ext.getCmp('minAutoCheck').getValue();
			var maxStaticCheck = Ext.getCmp('maxStaticCheck').getValue();
			var maxAutoCheck = Ext.getCmp('maxAutoCheck').getValue();
			if(minStaticCheck && minAutoCheck && maxStaticCheck && maxAutoCheck)
			{
				Ext.getCmp('allMeasureContainer').show();
			}
			else
			{
				Ext.getCmp('allMeasureContainer').hide();
			}
		}
    },
	minAutoCheckChange: function(box, checked)
	{
		//min auto block specific description for BusinessTransTest,KBusinessTransTest
		if (publicJson.isToolTip && !checked)
		{
			Ext.getCmp('relMinCritical').setFieldLabel('Critical (% Tolerance) <img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
			Ext.getCmp('relMinMajor').setFieldLabel('Major (% Tolerance) <img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
		}
		else
		{
			Ext.getCmp('relMinCritical').setFieldLabel(autoCriText);
			Ext.getCmp('relMinMajor').setFieldLabel(autoMajorText);
		}

		Ext.getCmp('allMeasureContainer').hide();
        var fieldset = box.ownerCt;
        Ext.Array.forEach(fieldset.query('slider'), this.minAutoFieldChange, this);
        Ext.Array.forEach(fieldset.query('slider'), function(field) {
            field.setDisabled(checked);
            if (!Ext.isIE6) {
                field.el.animate({opacity: checked ? 0.3 : 1});
            }
        });
        Ext.Array.forEach(fieldset.query('displayfield'), this.minAutoFieldChange, this);
        Ext.Array.forEach(fieldset.query('displayfield'), function(field) {
			if (field.id == 'minThreshDisplayField')
			{
			}
			else
			{
				field.setDisabled(checked);
				if (!Ext.isIE6) {
					field.el.animate({opacity: checked ? 0.3 : 1});
				}
			}
        });

		var isAllMeasureCheck = false;
		var allMeasureCheck = publicJson['applyOtherMeasure_check_box'];
		if (allMeasureCheck != null && allMeasureCheck != 'undefined' && (allMeasureCheck == 'true'))
		{
			isAllMeasureCheck = true;
		}
		if(checked && isAllMeasureCheck)
		{
			var minStaticCheck = Ext.getCmp('minStaticCheck').getValue();
			var minAutoCheck  = Ext.getCmp('minAutoCheck').getValue();
			var maxStaticCheck = Ext.getCmp('maxStaticCheck').getValue();
			var maxAutoCheck = Ext.getCmp('maxAutoCheck').getValue();
			if(minStaticCheck && minAutoCheck && maxStaticCheck && maxAutoCheck)
			{
				Ext.getCmp('allMeasureContainer').show();
			}
			else
			{
				Ext.getCmp('allMeasureContainer').hide();
			}
		}
    },
	applyThresholdsData: function()
	{
		var flag = true;
		var v_testname = publicJson['hiddenObj']['testName'];
		if (v_testname == "null")
		{
			flag = false;
			return false;
		}

		var v_measure =  publicJson['hiddenObj']['measure'];
		if (v_measure == "null")
		{
			flag = false;
			return false;
		}

		var v_policy = "mix";
		var minThreshold = "-1";
		var maxThreshold = "-1";
		var v_alarmPolicy = Ext.getCmp('alarmPolicyCombo').getValue();
		var lastItem = "HML";

		var abs_MinCritical = "-";
		var abs_MinMajor = "-";
		var abs_MinMinor = "-";
		var abs_MinOpt = Ext.getCmp('minStaticCheck').getValue();
		var isNegativeValuesAllowed = publicJson['isNegativeValuesAllowed'];
		if (!abs_MinOpt)
		{
			abs_MinCritical = Ext.getCmp('absMinCritical').getValue();
			abs_MinMajor =  Ext.getCmp('absMinMajor').getValue();
			abs_MinMinor =  Ext.getCmp('absMinMinor').getValue();

			// Negative value check...
			if (!isNegativeValuesAllowed)
			{
				//Invalid threshold entry check...
				if (!checkValidValue(abs_MinCritical))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMinCriticalErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function(){
							Ext.getCmp('absMinCritical').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MinCritical != "-") 
				{
					if(!checkNonNegativeFormat(abs_MinCritical))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMinCriticalErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinCritical').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MinMajor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMinMajorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMajor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MinMajor != "-")
				{
					if(!checkNonNegativeFormat(abs_MinMajor))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMinMajorErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinMajor').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MinMinor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMinMinorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMinor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MinMinor != "-")
				{
					if(!checkNonNegativeFormat(abs_MinMinor))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMinMinorErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinMinor').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				var ret = checkNegativeValue(abs_MinCritical);
				if (ret)
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg5+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinCritical').focus();
						}
					});
					flag = false;
					return false;
				}

				ret = checkNegativeValue(abs_MinMajor);
				if (ret)
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg5+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMajor').focus();
						}
					});
					flag = false;
					return false;
				}

				ret = checkNegativeValue(abs_MinMinor);
				if (ret)
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg5+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMinor').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			else
			{
				//Invalid threshold entry check...
				if (!checkValidValue(abs_MinCritical))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMinCriticalErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinCritical').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MinCritical != "-") 
				{
					if(!checkNegativeFormat(abs_MinCritical))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMinCriticalErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinCritical').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MinMajor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMinMajorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMajor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MinMajor != "-")
				{
					if(!checkNegativeFormat(abs_MinMajor))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMinMajorErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinMajor').focus();
							}
						});
						flag = false;
						return false;
					}
				}
				if (!checkValidValue(abs_MinMinor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMinMinorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMinor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MinMinor != "-")
				{
					if(!checkNegativeFormat(abs_MinMinor))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMinMinorErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinMinor').focus();
							}
						});
						flag = false;
						return false;
					}
				}
			}

			//check ascending order...
			if (abs_MinCritical != "-" && abs_MinMajor != "-")
			{
				if (parseFloat(abs_MinCritical) >= parseFloat(abs_MinMajor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg7,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinCritical').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			if (abs_MinMajor != "-" && abs_MinMinor != "-")
			{
				if (parseFloat(abs_MinMajor) >= parseFloat(abs_MinMinor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg7,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMajor').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			if (abs_MinCritical != "-" && abs_MinMinor != "-")
			{
				if (parseFloat(abs_MinCritical) >= parseFloat(abs_MinMinor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg7,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinCritical').focus();
						}
					});
					flag = false;
					return false;
				}
			}
		}

		var rel_MinCritical = "-";
		var rel_MinMajor = "-";
		var rel_MinMinor = "-";
		var minAutoCheck = Ext.getCmp('minAutoCheck').getValue();
		if (!minAutoCheck)
		{
			var v_amount_A = Ext.getCmp('relMinCriticalText').getValue();
			if (v_amount_A != 0)
			{
				if (v_amount_A == 100)
				{
					rel_MinCritical = "sqc";
				}
				else
				{
					rel_MinCritical = (v_amount_A/100) + "*sqc";
				}
			}

			var v_amount_B = Ext.getCmp('relMinMajorText').getValue();
			if (v_amount_B != 0)
			{
				if (v_amount_B == 100)
				{
					rel_MinMajor = "sqc";
				}
				else
				{
					rel_MinMajor = (v_amount_B/100) + "*sqc";
				}
			}

			var v_amount_C = Ext.getCmp('relMinMinorText').getValue();
			if (v_amount_C != 0)
			{
				if (v_amount_C == 100)
				{
					rel_MinMinor = "sqc";
				}
				else
				{
					rel_MinMinor = (v_amount_C/100) + "*sqc";
				}
			}

			//check ascending order...
			var relCri,relMaj,relMin;
			relCri = rel_MinCritical;
			relMaj = rel_MinMajor;
			relMin = rel_MinMinor;
			relCri = relCri.replace(/(\*sqc)/gi,"");
			relCri = relCri.replace(/sqc/g,"1");
			relMaj = relMaj.replace(/(\*sqc)/gi,"");
			relMaj = relMaj.replace(/sqc/g,"1");
			relMin = relMin.replace(/(\*sqc)/gi,"");
			relMin = relMin.replace(/sqc/g,"1");

			if (relCri != "-" && relMaj != "-")
			{
				if (parseFloat(relCri) >= parseFloat(relMaj))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg8,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
			if (relMaj != "-" && relMin != "-")
			{
				if (parseFloat(relMaj) >= parseFloat(relMin))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg8,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
			if (relCri != "-" && relMin != "-")
			{
				if (parseFloat(relCri) >= parseFloat(relMin))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg8,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
		}

		if(abs_MinCritical.indexOf(".") != -1 )
		{
			var abs_MinCriticalDecimal = abs_MinCritical.substring(abs_MinCritical.indexOf(".")+1);
			if (abs_MinCriticalDecimal == "0000" ||
				abs_MinCriticalDecimal == "000" ||
				abs_MinCriticalDecimal == "00" ||
				abs_MinCriticalDecimal == "0" )
			{
				abs_MinCritical = abs_MinCritical.substring(0,abs_MinCritical.indexOf("."));
			}
			else if(abs_MinCriticalDecimal.length > 1)
			{
				if ((abs_MinCriticalDecimal.charAt(3) == "0" && abs_MinCriticalDecimal.charAt(2) == "0") || 
					(abs_MinCriticalDecimal.charAt(3) == "0"))
				{
					abs_MinCritical = abs_MinCritical.substring(0,abs_MinCritical.lastIndexOf("0"));
				}
			}
		}
		if(abs_MinMajor.indexOf(".") != -1 )
		{
			var abs_MinMajorDecimal = abs_MinMajor.substring(abs_MinMajor.indexOf(".")+1);
			if (abs_MinMajorDecimal == "0000" || 
				abs_MinMajorDecimal == "000" || 
				abs_MinMajorDecimal == "00" || 
				abs_MinMajorDecimal == "0")
			{
				abs_MinMajor = abs_MinMajor.substring(0,abs_MinMajor.indexOf("."));
			}
			else if(abs_MinMajorDecimal.length > 1)
			{
				if ((abs_MinMajorDecimal.charAt(3) == "0" && abs_MinMajorDecimal.charAt(2) == "0") ||
					(abs_MinMajorDecimal.charAt(3) == "0"))
				{
					abs_MinMajor = abs_MinMajor.substring(0,abs_MinMajor.lastIndexOf("0"));
				}
			}
		}
		if(abs_MinMinor.indexOf(".") != -1 )
		{
			var abs_MinMinorDecimal = abs_MinMinor.substring(abs_MinMinor.indexOf(".")+1);
			if (abs_MinMinorDecimal == "0000" || 
				abs_MinMinorDecimal == "000" || 
				abs_MinMinorDecimal == "00" || 
				abs_MinMinorDecimal == "0")
			{
				abs_MinMinor = abs_MinMinor.substring(0,abs_MinMinor.indexOf("."));
			}
			else if(abs_MinMinorDecimal.length > 1)
			{
				if ((abs_MinMinorDecimal.charAt(3) == "0" && abs_MinMinorDecimal.charAt(2) == "0") ||
					(abs_MinMinorDecimal.charAt(3) == "0"))
				{
					abs_MinMinor = abs_MinMinor.substring(0,abs_MinMinor.lastIndexOf("0"));
				}
			}
		}

		var minCritical = "-";
		if (abs_MinCritical != "-" && rel_MinCritical != "-")
		{
			if(abs_MinCritical > -1 || abs_MinCritical < 0)
			{
				if(abs_MinCritical.indexOf(".") == 0)
				{
					abs_MinCritical = "0"+abs_MinCritical;
				}
				abs_MinCritical = parseFloat(abs_MinCritical);
				minCritical = abs_MinCritical.toString() + "&" + rel_MinCritical;
			}
			else
			{
				minCritical = rel_MinCritical;
			}
		}
		else if (abs_MinCritical != "-" && rel_MinCritical == "-")
		{
			if(abs_MinCritical > -1 || abs_MinCritical < 0)
			{
				if(abs_MinCritical.indexOf(".") == 0)
				{
					abs_MinCritical = "0"+abs_MinCritical;
				}
				abs_MinCritical = parseFloat(abs_MinCritical);
				minCritical = abs_MinCritical.toString();
			}
			else
			{
				minCritical = "-";
			}
		}
		else if (abs_MinCritical == "-" && rel_MinCritical != "-")
		{
			minCritical = rel_MinCritical;
		}

		var minMajor = "-";
		if (abs_MinMajor != "-" && rel_MinMajor != "-")
		{
			if(abs_MinMajor > -1 || abs_MinMajor < 0)
			{
				if(abs_MinMajor.indexOf(".") == 0)
				{
					abs_MinMajor = "0"+abs_MinMajor;
				}
				abs_MinMajor = parseFloat(abs_MinMajor);
				minMajor = abs_MinMajor.toString() + "&" + rel_MinMajor;
			}
			else
			{
				minMajor = rel_MinMajor;
			}
		}
		else if (abs_MinMajor != "-" && rel_MinMajor == "-")
		{
			if(abs_MinMajor > -1 || abs_MinMajor < 0)
			{
				if(abs_MinMajor.indexOf(".") == 0)
				{
					abs_MinMajor = "0"+abs_MinMajor;
				}
				abs_MinMajor = parseFloat(abs_MinMajor);
				minMajor = abs_MinMajor.toString();
			}
			else
			{
				minMajor = "-";
			}
		}
		else if (abs_MinMajor == "-" && rel_MinMajor != "-")
		{
			minMajor = rel_MinMajor;
		}

		var minMinor = "-";
		if (abs_MinMinor != "-" && rel_MinMinor != "-")
		{
			if(abs_MinMinor > -1 || abs_MinMinor < 0)
			{
				if(abs_MinMinor.indexOf(".") == 0)
				{
					abs_MinMinor = "0"+abs_MinMinor;
				}
				abs_MinMinor = parseFloat(abs_MinMinor);
				minMinor = abs_MinMinor.toString() + "&" + rel_MinMinor;
			}
			else
			{
				minMinor = rel_MinMinor;
			}
		}
		else if (abs_MinMinor != "-" && rel_MinMinor == "-")
		{
			if(abs_MinMinor > -1 || abs_MinMinor < 0)
			{
				if(abs_MinMinor.indexOf(".") == 0)
				{
					abs_MinMinor = "0"+abs_MinMinor;
				}
				abs_MinMinor = parseFloat(abs_MinMinor);
				minMinor = abs_MinMinor.toString();
			}
			else
			{
				minMinor = "-";
			}
		}
		else if (abs_MinMinor == "-" && rel_MinMinor != "-")
		{
			minMinor = rel_MinMinor;
		}

		if (minCritical != "-" || minMajor != "-" || minMinor != "-")
		{
			minThreshold = minCritical + "/" + minMajor + "/" + minMinor
		}

		var abs_MaxCritical = "-";
		var abs_MaxMajor = "-";
		var abs_MaxMinor = "-";
		var abs_MaxOpt = Ext.getCmp('maxStaticCheck').getValue();
		if (!abs_MaxOpt)
		{
			abs_MaxCritical = Ext.getCmp('absMaxCritical').getValue();
			abs_MaxMajor =  Ext.getCmp('absMaxMajor').getValue();
			abs_MaxMinor =  Ext.getCmp('absMaxMinor').getValue();

			// Negative value check...
			if (!isNegativeValuesAllowed)
			{
				//Invalid threshold entry check...
				if (!checkValidValue(abs_MaxCritical))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMaxCriticalErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxCritical').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxCritical != "-")
				{
					if(!checkNonNegativeFormat(abs_MaxCritical))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMaxCriticalErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxCritical').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MaxMajor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMaxMajorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMajor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxMajor != "-")
				{
					if(!checkNonNegativeFormat(abs_MaxMajor))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMaxMajorErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxMajor').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MaxMinor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMaxMinorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMinor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxMinor != "-")
				{
					if(!checkNonNegativeFormat(abs_MaxMinor))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMaxMinorErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxMinor').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				var ret = checkNegativeValue(abs_MaxCritical);
				if (ret)
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg11+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxCritical').focus();
						}
					});
					flag = false;
					return false;
				}

				ret = checkNegativeValue(abs_MaxMajor);
				if (ret)
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg11+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMajor').focus();
						}
					});
					flag = false;
					return false;
				}

				ret = checkNegativeValue(abs_MaxMinor);
				if (ret)
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg11+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMinor').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			else
			{
				if (!checkValidValue(abs_MaxCritical))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMaxCriticalErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxCritical').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxCritical != "-")
				{
					if(!checkNegativeFormat(abs_MaxCritical))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMaxCriticalErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxCritical').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MaxMajor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMaxMajorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMajor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxMajor != "-")
				{
					if(!checkNegativeFormat(abs_MaxMajor))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMaxMajorErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxMajor').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MaxMinor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMaxMinorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMinor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxMinor != "-")
				{
					if(!checkNegativeFormat(abs_MaxMinor))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMaxMinorErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxMinor').focus();
							}
						});
						flag = false;
						return false;
					}
				}
			}
			//check descending order...
			if (abs_MaxCritical != "-" && abs_MaxMajor != "-")
			{
				if (parseFloat(abs_MaxCritical) <= parseFloat(abs_MaxMajor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg9,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxCritical').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			if (abs_MaxMajor != "-" && abs_MaxMinor != "-")
			{
				if (parseFloat(abs_MaxMajor) <= parseFloat(abs_MaxMinor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg9,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMajor').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			if (abs_MaxCritical != "-" && abs_MaxMinor != "-")
			{
				if (parseFloat(abs_MaxCritical) <= parseFloat(abs_MaxMinor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg9,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxCritical').focus();
						}
					});
					flag = false;
					return false;
				}
			}
		}

		var rel_MaxCritical = "-";
		var rel_MaxMajor = "-";
		var rel_MaxMinor = "-";
		var maxAutoCheck = Ext.getCmp('maxAutoCheck').getValue();
		if (!maxAutoCheck)
		{
			var v_amount_D = Ext.getCmp('relMaxCriticalText').getValue();
			if (v_amount_D != 0)
			{
				if (v_amount_D == 100)
				{
					rel_MaxCritical = "sqc";
				}
				else
				{
					rel_MaxCritical = (v_amount_D/100) + "*sqc";
				}
			}

			var v_amount_E =  Ext.getCmp('relMaxMajorText').getValue();
			if (v_amount_E != 0)
			{
				if (v_amount_E == 100)
				{
					rel_MaxMajor = "sqc";
				}
				else
				{
					rel_MaxMajor = (v_amount_E/100) + "*sqc";
				}
			}

			var v_amount_F = Ext.getCmp('relMaxMinorText').getValue();
			if (v_amount_F != 0)
			{
				if (v_amount_F == 100)
				{
					rel_MaxMinor = "sqc";
				}
				else
				{
					rel_MaxMinor = (v_amount_F/100) + "*sqc";
				}
			}

			//check descending order...
			var relCri,relMaj,relMin;
			relCri = rel_MaxCritical;
			relMaj = rel_MaxMajor;
			relMin = rel_MaxMinor;
			relCri = relCri.replace(/(\*sqc)/gi,"");
			relCri = relCri.replace(/sqc/g,"1");
			relMaj = relMaj.replace(/(\*sqc)/gi,"");
			relMaj = relMaj.replace(/sqc/g,"1");
			relMin = relMin.replace(/(\*sqc)/gi,"");
			relMin = relMin.replace(/sqc/g,"1");

			if (relCri != "-" && relMaj != "-")
			{
				if (parseFloat(relCri) <= parseFloat(relMaj))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg10,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
			if (relMaj != "-" && relMin != "-")
			{
				if (parseFloat(relMaj) <= parseFloat(relMin))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg10,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
			if (relCri != "-" && relMin != "-")
			{
				if (parseFloat(relCri) <= parseFloat(relMin))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg10,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
		}

		if(abs_MaxCritical.indexOf(".") != -1 )
		{
			var abs_MaxCriticalDecimal = abs_MaxCritical.substring(abs_MaxCritical.indexOf(".")+1);
			if (abs_MaxCriticalDecimal == "0000" || 
				abs_MaxCriticalDecimal == "000" || 
				abs_MaxCriticalDecimal == "00" || 
				abs_MaxCriticalDecimal == "0")
			{
				abs_MaxCritical = abs_MaxCritical.substring(0,abs_MaxCritical.indexOf("."));
			}
			else if(abs_MaxCriticalDecimal.length > 1)
			{
				if ((abs_MaxCriticalDecimal.charAt(3) == "0" && abs_MaxCriticalDecimal.charAt(2) == "0") ||
					(abs_MaxCriticalDecimal.charAt(3) == "0"))
				{
					abs_MaxCritical = abs_MaxCritical.substring(0,abs_MaxCritical.lastIndexOf("0"));
				}
			}
		}
		if(abs_MaxMajor.indexOf(".") != -1 )
		{
			var abs_MaxMajorDecimal = abs_MaxMajor.substring(abs_MaxMajor.indexOf(".")+1);
			if (abs_MaxMajorDecimal == "0000" || 
				abs_MaxMajorDecimal == "000" || 
				abs_MaxMajorDecimal == "00" || 
				abs_MaxMajorDecimal == "0")
			{
				abs_MaxMajor = abs_MaxMajor.substring(0,abs_MaxMajor.indexOf("."));
			}
			else if(abs_MaxMajorDecimal.length > 1)
			{
				if ((abs_MaxMajorDecimal.charAt(3) == "0" && abs_MaxMajorDecimal.charAt(2) == "0") ||
					(abs_MaxMajorDecimal.charAt(3) == "0"))
				{
					abs_MaxMajor = abs_MaxMajor.substring(0,abs_MaxMajor.lastIndexOf("0"));
				}
			}
		}
		if(abs_MaxMinor.indexOf(".") != -1 )
		{
			var abs_MaxMinorDecimal = abs_MaxMinor.substring(abs_MaxMinor.indexOf(".")+1);
			if (abs_MaxMinorDecimal == "0000" ||
				abs_MaxMinorDecimal == "000" ||
				abs_MaxMinorDecimal == "00" ||
				abs_MaxMinorDecimal == "0")
			{
				abs_MaxMinor = abs_MaxMinor.substring(0,abs_MaxMinor.indexOf("."));
			}
			else if(abs_MaxMinorDecimal.length > 1)
			{
				if ((abs_MaxMinorDecimal.charAt(3) == "0" && abs_MaxMinorDecimal.charAt(2) == "0") || 
					(abs_MaxMinorDecimal.charAt(3) == "0"))
				{
					abs_MaxMinor = abs_MaxMinor.substring(0,abs_MaxMinor.lastIndexOf("0"));
				}
			}
		}

		var maxCritical = "-";
		if (abs_MaxCritical != "-" && rel_MaxCritical != "-")
		{
			if(abs_MaxCritical > -1 || abs_MaxCritical < 0)
			{
				if(abs_MaxCritical.indexOf(".") == 0)
				{
					abs_MaxCritical = "0"+abs_MaxCritical;
				}
				abs_MaxCritical = parseFloat(abs_MaxCritical);
				maxCritical = abs_MaxCritical.toString() + "&" + rel_MaxCritical;
			}
			else
			{
				maxCritical = rel_MaxCritical;
			}
		}
		else if (abs_MaxCritical != "-" && rel_MaxCritical == "-")
		{
			if(abs_MaxCritical > -1 || abs_MaxCritical < 0)
			{
				if(abs_MaxCritical.indexOf(".") == 0)
				{
					abs_MaxCritical = "0"+abs_MaxCritical;
				}
				abs_MaxCritical = parseFloat(abs_MaxCritical);
				maxCritical = abs_MaxCritical.toString();
			}
			else
			{
				maxCritical = "-";
			}
		}
		else if (abs_MaxCritical == "-" && rel_MaxCritical != "-")
		{
			maxCritical = rel_MaxCritical;
		}

		var maxMajor = "-";
		if (abs_MaxMajor != "-" && rel_MaxMajor != "-")
		{
			if(abs_MaxMajor > -1 || abs_MaxMajor < 0)
			{
				if(abs_MaxMajor.indexOf(".") == 0)
				{
					abs_MaxMajor = "0"+abs_MaxMajor;
				}
				abs_MaxMajor = parseFloat(abs_MaxMajor);
				maxMajor = abs_MaxMajor.toString() + "&" + rel_MaxMajor;
			}
			else
			{
				maxMajor = rel_MaxMajor;
			}
		}
		else if (abs_MaxMajor != "-" && rel_MaxMajor == "-")
		{
			if(abs_MaxMajor > -1 || + abs_MaxMajor < 0)
			{
				if(abs_MaxMajor.indexOf(".") == 0)
				{
					abs_MaxMajor = "0"+abs_MaxMajor;
				}
				abs_MaxMajor = parseFloat(abs_MaxMajor);
				maxMajor = abs_MaxMajor.toString();
			}
			else
			{
				maxMajor = "-";
			}
		}
		else if (abs_MaxMajor == "-" && rel_MaxMajor != "-")
		{
			maxMajor = rel_MaxMajor;
		}

		var maxMinor = "-";
		if (abs_MaxMinor != "-" && rel_MaxMinor != "-")
		{
			if(abs_MaxMinor > -1 || abs_MaxMinor < 0)
			{
				if(abs_MaxMinor.indexOf(".") == 0)
				{
					abs_MaxMinor = "0"+abs_MaxMinor;
				}
				abs_MaxMinor = parseFloat(abs_MaxMinor);
				maxMinor = abs_MaxMinor.toString() + "&" + rel_MaxMinor;
			}
			else
			{
				maxMinor = rel_MaxMinor;
			}
		}
		else if (abs_MaxMinor != "-" && rel_MaxMinor == "-")
		{
			if(abs_MaxMinor > -1  || abs_MaxMinor < 0)
			{
				if(abs_MaxMinor.indexOf(".") == 0)
				{
					abs_MaxMinor = "0"+abs_MaxMinor;
				}
				abs_MaxMinor = parseFloat(abs_MaxMinor);
				maxMinor = abs_MaxMinor.toString();
			}
			else
			{
				maxMinor = "-";
			}
		}
		else if (abs_MaxMinor == "-" && rel_MaxMinor != "-")
		{
			maxMinor = rel_MaxMinor;
		}

		if (maxCritical != "-" || maxMajor != "-" || maxMinor != "-")
		{
			maxThreshold = maxCritical + "/" + maxMajor + "/" + maxMinor
		}

		//resultStr = this.updateThresholds(v_testname,v_threshold);
		if (flag)
		{
			var me = this;
			var maskHome = null;
			var wholeViewport = document.getElementsByTagName("body")[0];
			if(!Ext.isEmpty(Ext.get(wholeViewport))){
				maskHome = new Ext.LoadMask(Ext.get(wholeViewport), {msg:"Loading...",cls:'maskDash'});
				maskHome.show();
			}

			var v_threshold = v_measure + ":" + v_policy + ":" + minThreshold + ":" + maxThreshold + ":" + v_alarmPolicy + ":" + lastItem;
			var params = '';
			var urlVal = '';
			if (!Ext.isEmpty(threshTypeVar) && threshTypeVar != undefined && threshTypeVar == 'DefaultDescriptor')
			{
				var descVal = publicJson['selectedDescriptor'];
				strDescName = descVal;
				var check = Ext.getCmp('allMeasureCheck').getValue();
				var allMeasVal = "";
				if(check)
				{
					allMeasVal = "true";
				}
				if (isGlobalWithInfoPattern)
				{
					var descVal = publicJson['selectedDescriptor'];
					strDescName = descVal;


					params = "testName="+v_testname+"&descName="+encodeURIComponent(descVal)+"&threshold="+escape(v_threshold)+"&operation=updateThresholds&allMeasure="+allMeasVal;
					urlVal = '/final/admin/DescriptorPatternThreshold/data/EgApplyDescThresholds.jsp?'+params+'&com.eg.CSRF_NONCE='+csrfToken;
				}
				else
				{
					var strCompType = '';
					var strCompName = '';
					var strTestName = v_testname;
					var strDescName = '';
					var from = publicJson['hiddenObj']['from'];

					var tmpCompType = publicJson['hiddenObj']['componentType'];
					if (tmpCompType != null && !Ext.isEmpty(tmpCompType))
					{
						strCompType = tmpCompType;
					}
					
					tmpCompName = publicJson['hiddenObj']['componentName'];
					if (tmpCompName != null && !Ext.isEmpty(tmpCompName))
					{
						strCompName = tmpCompName;
					}
					tmpTestName = publicJson['hiddenObj']['testName'];
					if (tmpTestName != null && !Ext.isEmpty(tmpTestName))
					{
						strTestName = tmpTestName;
					}

					tmpDescName = publicJson['hiddenObj']['descriptorName'];
					if (tmpDescName != null && !Ext.isEmpty(tmpDescName))
					{
						strDescName = tmpDescName;
					}
					params = "componentType="+encodeURI(strCompType)+"&componentName="+encodeURI(strCompName)+"&testName="+encodeURIComponent(v_testname)+"&descriptorName="+encodeURIComponent(strDescName)+"&from="+from+"&threshold="+escape(v_threshold)+"&operation=updateThresholds";

					urlVal = '/final/admin/SpecificThreshold/data/EgApplySpecificThresholds.jsp?'+params+'&com.eg.CSRF_NONCE='+csrfToken;
				}
			}
			else if (!Ext.isEmpty(threshTypeVar) && threshTypeVar != undefined && threshTypeVar == 'Global')
			{
				var compType = publicJson['hiddenObj']['componentType'];
				params = "componentType="+compType+"&testName="+v_testname+"&threshold="+escape(v_threshold)+"&operation=updateThresholds";
				urlVal = '/final/admin/DefaultThreshold/data/EgApplyThresholds.jsp?'+params+'&com.eg.CSRF_NONCE='+csrfToken;
			}
			else if (!Ext.isEmpty(threshTypeVar) && threshTypeVar != undefined && threshTypeVar == 'Group')
			{
				var policyName = publicJson['hiddenObj']['strPolicyName'];
				params = "policyName="+policyName+"&testName="+v_testname+"&threshold="+escape(v_threshold)+"&operation=updateThresholds";
				//urlVal = '/final/admin/GroupThreshold/data/EgApplyGroupThresholdsJson.jsp?'+params+'&com.eg.CSRF_NONCE='+csrfToken;

				var strCompType = '';
				var strCompName = '';
				var strTestName = v_testname;
				var strDescName = '';
				var from = publicJson['hiddenObj']['from'];

				var tmpCompType = publicJson['hiddenObj']['componentType'];
				if (tmpCompType != null && !Ext.isEmpty(tmpCompType))
				{
					strCompType = tmpCompType;
				}
				
				tmpCompName = publicJson['hiddenObj']['componentName'];
				if (tmpCompName != null && !Ext.isEmpty(tmpCompName))
				{
					strCompName = tmpCompName;
				}
				tmpTestName = publicJson['hiddenObj']['testName'];
				if (tmpTestName != null && !Ext.isEmpty(tmpTestName))
				{
					strTestName = tmpTestName;
				}

				tmpDescName = publicJson['hiddenObj']['descriptorName'];
				if (tmpDescName != null && !Ext.isEmpty(tmpDescName))
				{
					strDescName = tmpDescName;
				}
				params = "componentType="+encodeURI(strCompType)+"&componentName="+encodeURI(strCompName)+"&testName="+encodeURIComponent(v_testname)+"&descriptorName="+encodeURIComponent(strDescName)+"&from="+from+"&threshold="+escape(v_threshold)+"&operation=updateThresholds";

				urlVal = '/final/admin/SpecificThreshold/data/EgApplySpecificThresholds.jsp?'+params+'&com.eg.CSRF_NONCE='+csrfToken;
			}
			else 
			{
				var strCompType = '';
				var strCompName = '';
				var strTestName = v_testname;
				var strDescName = '';
				var from = publicJson['hiddenObj']['from'];

				var tmpCompType = publicJson['hiddenObj']['componentType'];
				if (tmpCompType != null && !Ext.isEmpty(tmpCompType))
				{
					strCompType = tmpCompType;
				}
				
				tmpCompName = publicJson['hiddenObj']['componentName'];
				if (tmpCompName != null && !Ext.isEmpty(tmpCompName))
				{
					strCompName = tmpCompName;
				}
				tmpTestName = publicJson['hiddenObj']['testName'];
				if (tmpTestName != null && !Ext.isEmpty(tmpTestName))
				{
					strTestName = tmpTestName;
				}

				tmpDescName = publicJson['hiddenObj']['descriptorName'];
				if (tmpDescName != null && !Ext.isEmpty(tmpDescName))
				{
					strDescName = tmpDescName;
				}

				params = "componentType="+encodeURIComponent(strCompType)+"&componentName="+encodeURIComponent(strCompName)+"&testName="+encodeURIComponent(v_testname)+"&descriptorName="+encodeURIComponent(strDescName)+"&from="+from+"&threshold="+escape(v_threshold)+"&operation=updateThresholds";
				urlVal = '/final/admin/SpecificThreshold/data/EgApplySpecificThresholds.jsp?'+params+'&com.eg.CSRF_NONCE='+csrfToken;
			}
			Ext.Ajax.request({
				url:urlVal,
				method:'POST',
				timeout: 6000000,
				//async: false,
				scope:this,
				success:function(response)
				{
					if (response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						maskHome.hide();
						Ext.Msg.alert(pageName,successAlert1, function (){
							var mask = null;
							var wholeViewport = document.getElementsByTagName("body")[0];
							if(!Ext.isEmpty(Ext.get(wholeViewport))){
								mask = new Ext.LoadMask(Ext.get(wholeViewport), {msg:"Loading...",cls:'maskDash'});
								mask.show();
							}
							setTimeout(function() {
								mask.hide();
								me.getConfigureThresholds().close();
								me.getTestInfo().close();
								me.openTestInfoWindow(testInfoGlobalURL);
							},5000);
						});
					}
				},
				failure: function(response)
				{
					maskHome.hide();
					Ext.Msg.show({
						title: pageName,
						msg: 'Updating problem in server side...',
						icon: 'iconExclamation',
						buttons: Ext.Msg.OK
					});
				}
			});
		}
	},
	maxRelCriticalSlider: function()
	{
		Ext.getCmp('relMaxCriticalText').setValue(Ext.getCmp('relMaxCritical').getValue());
	},
	maxRelMajorSlider: function()
	{
		Ext.getCmp('relMaxMajorText').setValue(Ext.getCmp('relMaxMajor').getValue());
	},
	maxRelMinorSlider: function()
	{
		Ext.getCmp('relMaxMinorText').setValue(Ext.getCmp('relMaxMinor').getValue());
	},
	minRelCriticalSlider: function()
	{
		Ext.getCmp('relMinCriticalText').setValue(Ext.getCmp('relMinCritical').getValue());
	},
	minRelMajorSlider: function()
	{
		Ext.getCmp('relMinMajorText').setValue(Ext.getCmp('relMinMajor').getValue());
	},
	minRelMinorSlider: function()
	{
		Ext.getCmp('relMinMinorText').setValue(Ext.getCmp('relMinMinor').getValue());
	},
	getHiddenFields : function(jsonVal,measureActualVal)
	{
		var hiddenFields = jsonVal[measureActualVal.trim()];
		var hiddenQstr = '';
		for (key in hiddenFields)
		{
			hiddenQstr += key+'='+encodeURIComponent(hiddenFields[key])+"&";
		}
		return hiddenQstr;
	},
	clearAllThresholdsValues: function()
	{
		Ext.getCmp('minStaticCheck').setValue(true);
		Ext.getCmp('absMinCritical').setValue('-');
		Ext.getCmp('absMinMajor').setValue('-');
		Ext.getCmp('absMinMinor').setValue('-');

		Ext.getCmp('minAutoCheck').setValue(true);
		Ext.getCmp('relMinCritical').setValue(0);
		Ext.getCmp('relMinCriticalText').setValue('0');
		Ext.getCmp('relMinMajor').setValue(0);
		Ext.getCmp('relMinMajorText').setValue('0');
		Ext.getCmp('relMinMinor').setValue(0);
		Ext.getCmp('relMinMinorText').setValue('0');

		Ext.getCmp('maxStaticCheck').setValue(true);
		Ext.getCmp('absMaxCritical').setValue('-');
		Ext.getCmp('absMaxMajor').setValue('-');
		Ext.getCmp('absMaxMinor').setValue('-');

		Ext.getCmp('maxAutoCheck').setValue(true);
		Ext.getCmp('relMaxCritical').setValue(0);
		Ext.getCmp('relMaxCriticalText').setValue('0');
		Ext.getCmp('relMaxMajor').setValue(0);
		Ext.getCmp('relMaxMajorText').setValue('0');
		Ext.getCmp('relMaxMinor').setValue(0);
		Ext.getCmp('relMaxMinorText').setValue('0');
		
	},

	// Functions to retrieve and load infos data and search through given field
	loadMoreInfoData:function(infotable,eopts){
		var me = this;
		var searchString = this.getSearchTrigger().getValue();
		this.getInfoTable().setLoading(true,true);
		if(parameters.indexOf('&searchBox=') > -1)
			parameters = parameters.substring(0,parameters.indexOf('&searchBox='));
		if(!Ext.isEmpty(infotable) && infotable != 'refresh' && infotable.getXType() == 'triggerfield')
		{
			var tempInfo = infotable.value;
			if (tempInfo.indexOf("#")>-1)
				tempInfo=tempInfo.replace('#','|hash|');
			if (tempInfo.indexOf("&")>-1)
				tempInfo=tempInfo.replace('&','|amp|');
			if (tempInfo.indexOf("+")>-1)
				tempInfo=tempInfo.replace('+','|plus|');
			if (tempInfo.indexOf("%")>-1)
				tempInfo=tempInfo.replace('%','|pct|');
			infotable.value = tempInfo;
			if(parameters.indexOf('&searchBox=') > -1)
				parameters = parameters.substring(0,parameters.indexOf('&searchBox='));
			parameters += '&searchBox='+infotable.value;
			
		}else if(infotable == 'refresh' && searchString != null && searchString != undefined && searchString != ''){
			if(parameters.indexOf('&searchBox=') > -1)
				parameters = parameters.substring(0,parameters.indexOf('&searchBox='));
			parameters += '&searchBox='+searchString;
		}	
		this.params = parameters;
		Ext.Ajax.request({
			url:'/final/monitor/EgMoreInfos.jsp?'+parameters,
			disableCaching:false,
			success:function(response){
				var json = Ext.decode(response.responseText);

				if(Ext.isEmpty(me.refreshRate))
					me.refreshRate = setInterval('refresh()',json.refreshRate);

				me.getStaticFields().setData(json);

				if(!Ext.isEmpty(json.searchKey) && !Ext.isEmpty(json.screenLabels.pageInfo))
					me.getSearchField().setData(json.searchKey,json.screenLabels.pageInfo);

				if(!Ext.isEmpty(json.infoArray))
				{
					if(me.getMeasures().isHidden()){
						me.getMeasures().show();
						me.getInfoTable().setHeight(300);
					}
					me.getInfoTableStore().removeAll(true);
					me.getInfoTableStore().loadRawData(json.infoArray);
					if(infotable != 'refresh')
						me.loadMeasures('/final/monitor/egDashBoardDispCompMeasure.jsp');
					else if(infotable == 'refresh')
					{
						if(json.infoArray.length > 0 && selectedInfo!=null && selectedInfo!=undefined)
						{
							var countLen=0;
							for(var kk=0;kk<json.infoArray.length;kk++)
							{
								var tmp_info_arr=json.infoArray[kk];
								
								if(tmp_info_arr!=null && tmp_info_arr!=undefined && tmp_info_arr.infoText == selectedInfo)
								{
									var measureComponent = me.backArray[me.backArray.length-1];

									var kk_id=kk+1;
									if(kk_id!=measureComponent.infoId)
										measureComponent.infoId=kk_id;

									me.loadMeasures(measureComponent.measureLocator,measureComponent.infoId,true);
									if(!Ext.isEmpty(measureComponent.infoId))
										jQuery('#'+measureComponent.infoId).addClass('textBold');
								}
								else
								{
									countLen++;
								}

								if(json.infoArray.length==countLen)
								{
									me.loadMeasures('/final/monitor/egDashBoardDispCompMeasure.jsp');
								}
							}
						}
						else
						{
							me.loadMeasures('/final/monitor/egDashBoardDispCompMeasure.jsp');
						}
					}
				}
				else if(!Ext.isEmpty(json.error)){
					me.getInfoTable().down('dataview[itemId=dataViewId]').emptyText = '<table style="position:absolute;top:100px;height:100%;width:100%;"><tr><td style="text-align:center"><div class = "iconAlert" style="margin:0 auto"></div><div>'+json.error+'</div><td></tr></table>';
					me.getInfoTableStore().loadRawData([]);
					if(!me.getMeasures().isHidden()){
						me.getMeasures().hide();
						me.getInfoTable().setHeight(550);
					}
				}
				me.getInfoTable().setLoading(false);
			},
			failure:function(resCode){
				window.location.href = "/final/monitor/egMonDashboard.jsp";
				alert('Error while loading Info Data!');
				me.getInfoTable().setLoading(false);
			}
		});
	},
	configureMainRender: function(jsonData,threshType,measureName)
	{
		var me = this;
		var urlVal = '';
		if (!Ext.isEmpty(threshType) && threshType != undefined && threshType == 'DefaultDescriptor')
		{
			var strTestName = jsonData.hiddenObj.strTestName;
			var descName = jsonData.hiddenObj.strDescName;
			var measCount = jsonData.hiddenObj.measCount;
			var strServer = jsonData.hiddenObj.strServer;
			var component = jsonData.hiddenObj.component;
			var hiddenFieldsVal = this.getHiddenFields(jsonData.hiddenDataObj,measureName.trim());
			urlVal = '/final/admin/DescriptorPatternThreshold/data/EgConfigureDescThresholdsJson.jsp?thruLayer=true&testName='+strTestName+'&descName='+descName+'&measCount='+measCount+'&com.eg.CSRF_NONCE='+csrfToken;

			if (!Ext.isEmpty(strServer))
			{
				urlVal +='&strServer='+strServer;
			}

			if (!Ext.isEmpty(component))
			{ 
				urlVal +='&component='+component;
			}

			if (!Ext.isEmpty(hiddenFieldsVal))
			{
				urlVal +='&'+hiddenFieldsVal;
			}
		}
		else if (!Ext.isEmpty(threshType) && threshType != undefined && threshType == 'Global')
		{
			var hiddenFieldsVal = this.getHiddenFields(jsonData.hiddenDataObj,measureName.trim());
			urlVal = '/final/admin/DefaultThreshold/data/EgConfigureThresholdsJson.jsp?';

			var strServer = jsonData.hiddenObj.strServer;
			var component = jsonData.hiddenObj.component;

			if (!Ext.isEmpty(hiddenFieldsVal))
			{
				urlVal +=hiddenFieldsVal;
			}
			urlVal = urlVal+'&com.eg.CSRF_NONCE='+csrfToken+"&thruLayer=true";

			if (!Ext.isEmpty(strServer))
			{
				urlVal +='&strServer='+strServer;
			}

			if (!Ext.isEmpty(component))
			{ 
				urlVal +='&component='+component;
			}

		}
		else if (!Ext.isEmpty(threshType) && threshType != undefined && threshType == 'Group')
		{
			var strCompType = jsonData.hiddenObj.server;
			var strCompName = jsonData.hiddenObj.component;
			var strTestName = jsonData.hiddenObj.testName;

			var hiddenFieldsVal = this.getHiddenFieldsForMeasure(jsonData.hiddenDataObj,measureName.trim());
			urlVal =  '/final/admin/GroupThreshold/data/EgConfigureGroupThresholdsJson.jsp?thruLayer=true&specthreshpage=yes&testName='+strTestName+'&strServer='+strCompType+'&component='+strCompName+'&comeFrom=admin'+'&com.eg.CSRF_NONCE='+csrfToken;
			if (!Ext.isEmpty(hiddenFieldsVal))
			{
				urlVal += '&'+hiddenFieldsVal;
			}
		}
		else 
		{
			params = '';
			var qStr = '';
			var strCompType = jsonData.hiddenObj.componentType;
			var strCompName = jsonData.hiddenObj.componentName;
			var strTestName = jsonData.hiddenObj.testName;
			var strDescName = jsonData.hiddenObj.descriptorName;
			var isRefine = jsonData.hiddenObj.isRefine;
			var comeFrom = jsonData.hiddenObj.comeFrom;

			if (!Ext.isEmpty(strCompType) && strCompType != undefined)
			{
				qStr = 'componentType='+strCompType+'&server='+strCompType;
			}
			if (!Ext.isEmpty(strCompName) && strCompName != undefined)
			{
				qStr += '&componentName='+encodeURIComponent(strCompName);
			}
			if (!Ext.isEmpty(strTestName) && strTestName != undefined)
			{
				qStr += '&testName='+strTestName;
			}
			if ( !Ext.isEmpty(strDescName) && strDescName != undefined)
			{
				qStr += '&descriptorName='+encodeURIComponent(strDescName);
			}
			if (!Ext.isEmpty(threshTypeVar) && threshTypeVar != undefined)
			{
				if (threshTypeVar == 'Specific' || threshTypeVar == 'Descriptor')
				{
					qStr += '&from=specificTest';
				}
				else if (threshTypeVar == 'Group' )
				{
					qStr += '&from=grpRuleTest';
				}
				else  if(threshTypeVar == 'DefaultDescriptor')
				{
					qStr += '&from=defaultDescriptorTest';
				}
				else
				{
					qStr += '&from=defaultTest';
				}
				
			}
			if (!Ext.isEmpty(isRefine) && isRefine != undefined)
			{
				qStr += '&isRefine='+isRefine;
			}
			if (!Ext.isEmpty(comeFrom) && comeFrom != undefined)
			{
				qStr += '&comeFrom='+comeFrom;
			}
			
			if (qStr != null && qStr.length > 0)
			{
				params = qStr;
			}
			urlVal = '/final/admin/SpecificThreshold/data/EgConfigureSpecificThresholdsJson.jsp?'+params+'&com.eg.CSRF_NONCE='+csrfToken+"&thruLayer=true";
			var hiddenFieldsVal = this.getHiddenFields(jsonData.hiddenDataObj,measureName.trim());
			if (!Ext.isEmpty(hiddenFieldsVal))
			{
				urlVal +='&'+hiddenFieldsVal;
			}
		}
		
		Ext.Ajax.request({
			url:urlVal,
			method:'POST',
			scope:this,
			success:function(response)
			{
				var jsonText = response.responseText;
				publicJson = Ext.decode(jsonText);
				me.getConfigureThresholds().show();
				var testDescription =  '';
				if (threshType == 'Specific' || threshType == 'Descriptor' || threshType == 'Default')
				{
					testDescription = publicJson['screenLabels']['disp_title'];
				}
				else
				{
					testDescription = publicJson['screenLabels']['test_description'];
				}
				me.clearAllThresholdsValues();
				if (Ext.getCmp('allMeasureContainer').isVisible())
				{
					Ext.getCmp('allMeasureContainer').hide();
				}
				var descComp = Ext.getCmp('testDescriptionId');
				var alarmPolicyCombo = publicJson['alarmPolicyArr'];
				var minThreshObj = publicJson['minThreshObj'];
				var maxThreshObj = publicJson['maxThreshObj'];
				var selectAlarm = publicJson['selectedAlarmType'];
				var selectedAlarmDescription = publicJson['selectedAlarmDescription'];
				var isNegativeValuesAllowed = publicJson['isNegativeValuesAllowed'];
				var isGlobalThresholds = publicJson['isGlobalThresholds'];
				if(isGlobalThresholds)
				{
					Ext.getCmp('minAutoCheck').hide();
					Ext.getCmp('minAutoFieldContainer').hide();
					Ext.getCmp('maxAutoCheck').hide();
					Ext.getCmp('maxAutoFieldContainer').hide();
				}

				var toolTipMsg = publicJson.isToolTip;

				var minStaticOption = minThreshObj.minStaticOption;
				var minStaticBlock = minThreshObj.minStaticBlock;
				if(minStaticOption != null && !Ext.isEmpty(minStaticOption) && minStaticOption == 'selected')
				{
					//min static block specific description for BusinessTransTest,KBusinessTransTest
					if (toolTipMsg)
					{
						Ext.getCmp('absMinCritical').setFieldLabel('Critical <img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
						Ext.getCmp('absMinMajor').setFieldLabel('Major <img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
					}
					else
					{
						Ext.getCmp('absMinCritical').setFieldLabel(criticalText);
						Ext.getCmp('absMinMajor').setFieldLabel(majorText);
					}

					var absMinCritical = minThreshObj.absMinCritical;
					var absMinMajor = minThreshObj.absMinMajor;
					var absMinMinor = minThreshObj.absMinMinor;
					Ext.getCmp('minStaticCheck').setValue(false);
					Ext.getCmp('absMinCritical').setValue(absMinCritical);
					Ext.getCmp('absMinMajor').setValue(absMinMajor);
					Ext.getCmp('absMinMinor').setValue(absMinMinor);
					
				}
				if (!isGlobalThresholds)
				{
					if (!isNegativeValuesAllowed)
					{
						var minAutomaticOption = minThreshObj.minAutomaticOption;
						var minAutomaticBlock = minThreshObj.minAutomaticBlock;
						Ext.getCmp('minAutoCheck').show();
						Ext.getCmp('minAutoFieldContainer').show();
						if (minAutomaticOption != null && !Ext.isEmpty(minAutomaticOption) && minAutomaticOption == 'selected')
						{
							var relMinCritical = minThreshObj.relMinCritical;
							var relMinMajor = minThreshObj.relMinMajor;
							var relMinMinor = minThreshObj.relMinMinor;
							//Ext.getCmp('minAutoCheck').show();
							//Ext.getCmp('minAutoFieldContainer').show();
							Ext.getCmp('minAutoCheck').setValue(false);
							Ext.getCmp('relMinCritical').setValue(relMinCritical);
							Ext.getCmp('relMinCriticalText').setValue(relMinCritical);
							Ext.getCmp('relMinMajor').setValue(relMinMajor);
							Ext.getCmp('relMinMajorText').setValue(relMinMajor);
							Ext.getCmp('relMinMinor').setValue(relMinMinor);
							Ext.getCmp('relMinMinorText').setValue(relMinMinor);

							if (toolTipMsg)
							{
								Ext.getCmp('relMinCritical').setFieldLabel('Critical (% Tolerance) <img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
								Ext.getCmp('relMinMajor').setFieldLabel('Major (% Tolerance) <img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
							}
							else
							{
								Ext.getCmp('relMinCritical').setFieldLabel(autoCriText);
								Ext.getCmp('relMinMajor').setFieldLabel(autoMajorText);
							}

						}
					}
				}

				var maxStaticOption = maxThreshObj.maxStaticOption;
				var maxStaticBlock = maxThreshObj.maxStaticBlock;
				if (maxStaticOption != null && !Ext.isEmpty(maxStaticOption) && maxStaticOption == 'selected')
				{
					//max static block specific description for BusinessTransTest,KBusinessTransTest
					if (toolTipMsg)
					{
						Ext.getCmp('absMaxCritical').setFieldLabel('Critical <img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
						Ext.getCmp('absMaxMajor').setFieldLabel('Major <img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
					}
					else
					{
						Ext.getCmp('absMaxCritical').setFieldLabel(criticalText);
						Ext.getCmp('absMaxMajor').setFieldLabel(majorText);
					}

					var absMaxCritical = maxThreshObj.absMaxCritical;
					var absMaxMajor = maxThreshObj.absMaxMajor;
					var absMaxMinor = maxThreshObj.absMaxMinor;
					Ext.getCmp('maxStaticCheck').setValue(false);
					Ext.getCmp('absMaxCritical').setValue(absMaxCritical);
					Ext.getCmp('absMaxMajor').setValue(absMaxMajor);
					Ext.getCmp('absMaxMinor').setValue(absMaxMinor);
					
				}

				if (!isGlobalThresholds)
				{
					if (!isNegativeValuesAllowed)
					{
						var maxAutomaticOption = maxThreshObj.maxAutomaticOption;
						var maxAutomaticBlock = maxThreshObj.maxAutomaticBlock;
						Ext.getCmp('maxAutoCheck').show();
						Ext.getCmp('maxAutoFieldContainer').show();
						if (maxAutomaticOption != null && !Ext.isEmpty(maxAutomaticOption) && maxAutomaticOption == 'selected')
						{
							var relMaxCritical = maxThreshObj.relMaxCritical;
							var relMaxMajor = maxThreshObj.relMaxMajor;
							var relMaxMinor = maxThreshObj.relMaxMinor;
							//Ext.getCmp('maxAutoCheck').show();
							//Ext.getCmp('maxAutoFieldContainer').show();
							Ext.getCmp('maxAutoCheck').setValue(false);
							Ext.getCmp('relMaxCritical').setValue(relMaxCritical);
							Ext.getCmp('relMaxCriticalText').setValue(relMaxCritical);
							Ext.getCmp('relMaxMajor').setValue(relMaxMajor);
							Ext.getCmp('relMaxMajorText').setValue(relMaxMajor);
							Ext.getCmp('relMaxMinor').setValue(relMaxMinor);
							Ext.getCmp('relMaxMinorText').setValue(relMaxMinor);

							if (toolTipMsg)
							{
								Ext.getCmp('relMaxCritical').setFieldLabel('Critical (% Tolerance) <img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
								Ext.getCmp('relMaxMajor').setFieldLabel('Major (% Tolerance) <img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
							}
							else
							{
								Ext.getCmp('relMaxCritical').setFieldLabel(autoCriText);
								Ext.getCmp('relMaxMajor').setFieldLabel(autoMajorText);
							}
						}
					}
				}
				var isHostTest = publicJson['isHostTest'];
				descComp.update(publicJson['parenthtml']);

				descComp.setTitle('<div style="text-transform: none;">'+testDescription+'</div>');
				var alarmDispField = Ext.getCmp('alarmDispField');
				var alarmCombo = Ext.getCmp('alarmPolicyCombo');
				if(alarmPolicyCombo != null && !Ext.isEmpty(alarmPolicyCombo))
				{
					alarmDispField.el.animate({opacity: 1});
					alarmCombo.getStore().suspendEvents(true);
					alarmCombo.getStore().removeAll();
					alarmCombo.getStore().loadRawData(alarmPolicyCombo);
					alarmCombo.getStore().resumeEvents();

					if (selectAlarm != null && !Ext.isEmpty(selectAlarm))
					{
						alarmCombo.setValue(selectAlarm);
					}
					else
					{
						//selectAlarm = alarmPolicyCombo[0].valueField;
						alarmCombo.setValue(alarmPolicyCombo[0].valueField);
					}
					if (selectedAlarmDescription != null && !Ext.isEmpty(selectedAlarmDescription))
					{
						//alarmDispField.el.update(selectedAlarmDescription);
						alarmDispField.setValue(selectedAlarmDescription);
					}
					else
					{
						var tmpDescription = publicJson['alarmPolicyDescriptionObj'][alarmPolicyCombo[0].valueField]
						//alarmDispField.el.update(tmpDescription);
						alarmDispField.setValue(tmpDescription);
					}
				}
				var isShowAllMeasureCheckBox = publicJson['applyOtherMeasure_check_box'];
				if (!Ext.isEmpty(isShowAllMeasureCheckBox) && isShowAllMeasureCheckBox != undefined && isShowAllMeasureCheckBox == 'true')
				{
					var allMeasureCheck = publicJson['allMeasureCheck'];
					if (allMeasureCheck != null && allMeasureCheck != 'undefined' && (allMeasureCheck == 'true'))
					{
						Ext.getCmp('allMeasureContainer').show();
					}
				}
			},
			failure: function()
			{
			}
		});
	},
	// Function to load meaures	panel data
	loadMeasures:function(measureUrl,backId,isBack){
		var me = this;
		if(!isBack){
			this.backArray.push({
				infoId:backId,
				measureLocator:measureUrl
			});
		}
		else{
			jQuery('.textBold').removeClass('textBold');
			jQuery('#'+backId).addClass('textBold');
		}
		this.getMeasures().setLoading(true,true);
		Ext.Ajax.request({
			url:measureUrl,
			disableCaching:false,
			success:function(response){
				var json = Ext.decode(response.responseText);

				if(!Ext.isEmpty(json.errormsg)){
					me.setEmptyMeasures(json);
				}
				else{
					Ext.Ajax.request({
						url:json.measuresUrl,
						success:function(innerResponse){
							var innerJson = Ext.decode(innerResponse.responseText);

							// To set the static display fields value only if a info is clicked
							me.getStaticFields().setData(json);

							// To set the title and last measure time to the measures panel
							if(!Ext.isEmpty(innerJson.screenLabels) && !Ext.isEmpty(innerJson.screenLabels.Measurements) && !Ext.isEmpty(innerJson.screenLabels.LastMeasurementTime))
								me.getMeasures().setData(innerJson.screenLabels.Measurements,innerJson.screenLabels.LastMeasurementTime);

							// To set the measures link data at the top toolbar
							me.getMeasures().setToolbarData(innerJson);
							var resultItems = me.getMeasures().items.items;
							for(var item=resultItems.length-1; item>-1 ; item--)
							{
								resultItems[item].destroy();
							}
							if(!Ext.isEmpty(innerJson.gridInfo)){
								// To show back button only if there is a history to navigate back
								if(me.getBackButton().isHidden())
									me.getBackButton().show();

								// To show measures grids and hide error panel
								if(!Ext.isEmpty(innerJson.groupingGrid) && (innerJson.groupingGrid==true || innerJson.groupingGrid=='true')){
									var measureStore = null;
									var measureConfig = null;
									measureStore = Ext.create('InfosAndDescriptor.store.Measures',{
										data : innerJson,
										groupField : "groupingIndex",
										remoteGroup: true
									});
									measureConfig={store:measureStore,features: [{ftype:'grouping',collapsible:false,groupHeaderTpl: '{name}'}]};
								}
								else
								{ 
									measureStore = Ext.create('InfosAndDescriptor.store.Measures',{
									data : innerJson,
									sortOnLoad : false
									});
									measureConfig={store:measureStore};
								}
								
								var measureGrid=Ext.create('InfosAndDescriptor.view.MeasuresGrid',
									measureConfig);
								me.getMeasures().add(measureGrid);
							}
							else if(Ext.isEmpty(innerJson.gridInfo) && !Ext.isEmpty(innerJson.unknownInfo)){
								var unknownGridInfo = innerJson.unknownInfo;
								var propertyGridSource = {};
								for(var sourceCounter = 0 ; sourceCounter < unknownGridInfo.length ; sourceCounter++){
									propertyGridSource[""+unknownGridInfo[sourceCounter]["key"]]=unknownGridInfo[sourceCounter]["value"];
								}
								var unknownGrid = Ext.create('Ext.grid.property.Grid', {
									source : propertyGridSource,
									cls : "propertyGrid gridSkin",
									hideHeaders : true,
									border:false,
									width : '100%',
									//style:{border:'1px solid red'},
									margin:0,
									nameColumnWidth : "40%",
									listeners: {
										'beforeedit':{
											fn:function(){
												return false;
											}
										}
									}
								});
								me.getMeasures().add(unknownGrid);
							}
							else if(!Ext.isEmpty(innerJson.errormsg)){
								me.setEmptyMeasures(innerJson);
							}
						}
					});
				}
				me.getMeasures().setLoading(false);
			},
			failure:function(resCode){
				//window.location.href = "/final/monitor/egMonDashboard.jsp";
				//alert('Error while loading Measures Data!');
				me.getMeasures().setLoading(false);
			}
		});
	},
	// Function to handle back operations
	backHandler:function(){
		if(!Ext.isEmpty(this.backArray)){
			this.backArray.pop();
			var backObj = this.backArray[this.backArray.length-1];
			if(!Ext.isEmpty(backObj))
				this.loadMeasures(backObj.measureLocator,backObj.infoId,true);
		}
	},
	
	// Function to set measures panel while no data is available
	setEmptyMeasures:function(json){
		if(!this.getBackButton().isHidden())
			this.getBackButton().hide();
		this.getMeasures().setData(json.screenLabels.Measurements,json.screenLabels.LastMeasurementTime);
		this.getMeasures().setTopBar(false);
		if(!Ext.isEmpty(this.getMeasuresGrid()))
			this.getMeasuresGrid().hide();
		if(!Ext.isEmpty(this.getErrorPanel()))
		{
			this.getErrorPanel().child('container').update('<div class = "iconAlert" style="margin:0 auto"></div><div>'+json.errormsg.msg+'</div>');
			this.getErrorPanel().show();
		}
		else
		{
			var panel = Ext.create('Ext.panel.Panel',{
						html: '<table style="margin:8% auto 0"><tr><td><div style="margin:auto" class = "iconAlert" ></div></td></tr><tr><td><div>'+json.errormsg.msg+'</div></td</tr</table>'
			});
			this.getMeasures().removeAll();
			this.getMeasures().add(panel);
		}
	},
	
	detailsClicked:function(detailButton){
		var testInfoUrl = '/final/monitor/EgTestStatusInfo.jsp?'+detailButton.urlParam1+"&layer="+detailButton.urlParam2+"&badmeslist="+detailButton.urlParam3;
		testInfoGlobalURL = testInfoUrl;
		this.openTestInfoWindow(testInfoUrl);
	},

	remoteClicked:function(remoteButton){
		openRemoteControl(remoteButton.url);
	},
	LogonDetailsPopUpClicked:function(logonButton){
		
		var titleforLogon=logonButton.titleforLogon;
		if(titleforLogon!=null && titleforLogon.indexOf("\\")>-1)
		{
			titleforLogon=titleforLogon.replace("\\\\","\\");
		}
		
		LogonDetailsPopUp(logonButton.urlParam1,titleforLogon);
	},
	
	helpClicked:function(helpButton){
		if(helpButton.methodSuper == 'true' || helpButton.methodSuper == true)
			HelpWin_Sm(helpButton.urlParam1);
		else
			HelpWin(helpButton.urlParam1);
	},
	
	openTestInfoWindow:function(infoUrl){
		var me = this;
		Ext.Ajax.request({
			url:infoUrl,
			disableCaching:false,
			success:function(response){
				var json = Ext.decode(response.responseText);
				me.getTestInfo().setTestDetailsData(json);
				csrfToken = json.strCsrfToken;
				me.getTestInfoTableContainer().removeAll();
				if (json.isAdminLinkEnabled)
				{
					me.getTestInfoTableContainer().add(me.createTableViewForThreshold('Measure','Max/Min','Critical','Major','Minor','Alarm policy',' ',json.jsonArrayValue));
				}
				else
				{
					me.getTestInfoTableContainer().add(me.createTableViewForThreshold('Measure','Max/Min','Critical','Major','Minor','Alarm policy',json.jsonArrayValue));
				}
				if(!Ext.isEmpty(json.measureDescription))
					me.getTestInfoTableContainer().add(me.createTableViewNoThresh('Measures without Thresholds',json.measureDescription));
			//	if(!Ext.isEmpty(json.policyNames1ObjectValue))
					//me.getTestInfoTableContainer().add(me.createTableView('Quick Maintenance Details',json.policyNames1ObjectValue));
			
				me.getTestInfo().show();
			},
			failure:function(){
				window.location.href = "/final/monitor/egMonDashboard.jsp";
			}
		});
	},
	
	showAlarmDetails:function(alarmDetailUrl){
		var me = this;
		Ext.Ajax.request({
			url:alarmDetailUrl,
			success:function(response){
				var json = Ext.decode(response.responseText);
				me.getAlarmDetails().setData(json);
				me.getAlarmDetailsTableContainer().removeAll();
				me.getAlarmDetailsTableContainer().add(me.createTableView(alarmDetailsT1,alarmDetailsT2,json.eventDetails));
				Ext.getCmp('acknowledge').hide();
				if(!Ext.isEmpty(json.ackDetails))
				{
					Ext.getCmp('acknowledge').show();
					me.getAlarmDetailsTableContainerAcknowledge().add(me.createTableView(alarmDetailsT3,alarmDetailsT1,alarmDetailsT4,json.ackDetails));
				}
				me.getAlarmDetails().show();
			},
			failure:function(){
				window.location.href = "/final/monitor/egMonDashboard.jsp";
				alert('Failed to load Alarm Details!');
			}
		});
	},

	openAggregateDetails:function(aggUrl){
		var me = this;
		Ext.Ajax.request({
			url:aggUrl,
			success:function(response){
				var json = Ext.decode(response.responseText);
				me.getAggregateWindow().setData(json);
				me.getAggregateWindow().show();
			},
			failure:function(){
				window.location.href = "/final/monitor/egMonDashboard.jsp";
				alert('Failed to load Aggregate Details!');
			}
		});
	},
	openCompositeDetails:function(compUrl){
		var me = this;
		Ext.Ajax.request({
			url:compUrl,
			success:function(response){
				var json = Ext.decode(response.responseText);
				me.getCompositeWindow().setData(json);
				me.getCompositeWindow().show();
			},
			failure:function(){
				window.parent.location.href="/final/servlet/com.egurkha.Logout";
			}
		});
	},
	openJVMThreadStackTrace:function(stackTraceUrl){
		var me= this;
		var details = null;
		Ext.Ajax.request({
			url:stackTraceUrl,
			success:function(response){
				var formdata = Ext.decode(response.responseText);
				var subformdata =null;
				if(!Ext.isEmpty(formdata)){
					for(var i = 0;i<formdata.data.length;i++){
						var name=formdata.data[i].name;
						if(!Ext.isEmpty(name)){
							if(name=="memtime"){
								var selectedvalue = formdata.data[i].selectedvalue;
								if(selectedvalue==null)
									selectedvalue ='';
								subformdata = formdata.data[i].time;
								me.setComboOptionsInList('time', subformdata,selectedvalue);
							}
							else if(name=="Measurement"){
								var selectedvalue = formdata.data[i].selectedvalue;
								if(selectedvalue==null)
									selectedvalue ='';
								subformdata = formdata.data[i].measure;
								me.setComboOptionsInList('measure', subformdata,selectedvalue);
							}
							else if(name=="memsortname"){
								var selectedvalue = formdata.data[i].selectedValue;
								if(selectedvalue==null)
									selectedvalue ='';
								subformdata = formdata.data[i].sortByOrder;
								me.setComboOptionsInList('sortByOrder', subformdata,selectedvalue);
							}
							else{
								var	selectedvalue = formdata.data[i].selectedValue;
								subformdata = formdata.data[i].threadname;
								me.setComboOptionsInList('threadname', subformdata,selectedvalue);
								var threadCombo = me.getThreadDetails().down('multiselect[itemId=threadname]');
								threadCombo.setValue(selectedvalue);
							}
						}
					}

					var resultPanel = Ext.getCmp("threadResulPanel");
					var measureTime = Ext.getCmp('time').value;
					params="time="+measureTime+"&details="+encodeURIComponent(selectedvalue);
					Ext.Ajax.request({
						url : '/final/monitor/jvmThreads.jsp',
						params:params,
						method:'POST',
						success : function(response) {
							resultPanel.update(Ext.decode(response.responseText));
						}
					});
				}
				me.getThreadDetails().show();
			},
			failure:function(){
				window.location.href = "/final/monitor/egMonDashboard.jsp";
				alert('Error in loading Stack Trace');
			}
		});
	},

	setComboOptionsInList : function(fieldName, list, value) {
		var selector = '';
		if(fieldName == 'threadname'){
			selector = 'multiselect[itemId='+fieldName+']';
		}
		else{
			selector = 'combo[itemId='+fieldName+']'
		}
		var field = this.getThreadDetails().down(selector);
		field.getStore().loadRawData(list);
		//field.suspendEvents(false);
		if(value=='')
		{
			value = field.getStore().getAt(0).get('value');
		}
		field.setValue(value);
		//field.resumeEvents();
	},

	stackTraceCombo:function(obj){
		var elementId = obj.getId();

		var url = stackTraceUrl;

		if(elementId=="time")
		{
			if(!Ext.isEmpty(obj.value))
			{
				url = url+"&time="+obj.value;
				meas = Ext.getCmp("measure").value;
				url += '&s_measure='+meas;
			}
		}
		else if(elementId=="measure")
		{
			if(!Ext.isEmpty(obj.value))
			{
				var timeTemp = Ext.getCmp("time").value;
				url = url+"&time="+timeTemp;
				meas = obj.value;
				url += '&s_measure='+meas;
			}
		}
		else if(elementId=="sortByOrder")
		{
			var sortValue = obj.value;
			url = url + "&sortby="+sortValue;
			var timeTemp = Ext.getCmp("time").value;
			url = url+"&time="+timeTemp;
			var meas = Ext.getCmp("measure").value;
			url += '&s_measure='+meas;
		}
		else if(elementId=="threadnameSelect")
		{
			var selectedThreadName = this.getThreadDetails().down('multiselect[itemId=threadname]').getValue();
			var timeTemp = Ext.getCmp("time").value;
			url = url+"&time="+timeTemp;
			var meas = Ext.getCmp("measure").value;
			url += '&s_measure='+meas;
			url = url+"&selectedThreadName="+encodeURIComponent(selectedThreadName);
		}
		if(!Ext.isEmpty(meas) && !Ext.isEmpty(elementId) && elementId!="sortByOrder")
		{
			if(meas == 'Total_current_threads')
				sortValue ="1";
			else if(meas == 'Blocked_threads')
				sortValue ="8";
			else if(meas == 'Deadlock_threads')
				sortValue ="8";
			else if(meas == 'Waiting_threads')
				sortValue ="11";
			else if(meas == 'Timed_waiting_threads')
				sortValue ="11";
			else
				sortValue ="5";
			url = url+"&sortby="+sortValue;
		}
		this.openJVMThreadStackTrace(url);
	},

	createTableView:function(){
		/*
		* Used arguments concept of javascript function
		* It is done so to accept any number of arguments for the function
		* so that this function can be globally used to create dynamic table of any size
		*/

		var headers = Array.prototype.slice.call(arguments);
		var bodyData = headers.pop();

		var table = '<div class="x-table-outer-border"><div class="x-table" style="margin:0 0 0px 0"><table style="table-layout:auto" class="x-grid-table" cellspacing="0" cellpadding="0" border="0" ><col width="1354"><thead ><tr class="x-grid-row">';

		for(h=0;h<headers.length;h++)
		{
			if (!Ext.isEmpty(headers[h]))
			{
				table += '<th class=" x-grid-cell"><div class="x-grid-cell-inner" >'+headers[h]+'</div></th>';
			}
		}
		table += '</tr></thead>';

		table += '<tbody>';

		if(typeof bodyData == 'string'){
			table += '<tr class="x-grid-row"><td class=" x-grid-cell" wrap><div class="x-grid-cell-inner">'+bodyData+'</div></td></tr>';
		}
		else if(!Ext.isEmpty(bodyData)){
			for( p = 0; p < bodyData.length; p++){
				var data = bodyData[p];
				var keys = [];
				for (var key in data) {
					keys.push(key);
				}
				table += '<tr class="x-grid-row">';
				for(q = 0; q < keys.length; q++){
					table += '<td class=" x-grid-cell"><div class="x-grid-cell-inner">'+data[keys[q]]+'</div></td>';
				}
				table += '</tr>';
			}
		}
		else
			return false;

		table += '</tbody></table></div></div>';
		var container = {
			xtype:'container',
			padding:0,
			margin:'0 0 10 0',
			html:table
		};
		return container;
	},
	createTableViewNoThresh:function(){
		/*
		* Used arguments concept of javascript function
		* It is done so to accept any number of arguments for the function
		* so that this function can be globally used to create dynamic table of any size
		*/

		var headers = Array.prototype.slice.call(arguments);
		var bodyData = headers.pop();

		var table = '<div class="x-table"><table width="100%" class="x-grid-table" cellspacing="0" cellpadding="0" border="0"><thead ><tr class="x-grid-row">';
		for(h=0;h<headers.length;h++)
			table += '<th class=" x-grid-cell"><div class="x-grid-cell-inner" >'+headers[h]+'</div></th>';
		table += '</tr></thead>';

		table += '<tbody>';

		if(typeof bodyData == 'string'){
			table += '<tr class="x-grid-row"><td class=" x-grid-cell" wrap><div class="x-grid-cell-inner">'+bodyData+'</div></td></tr>';
		}
		else if(!Ext.isEmpty(bodyData)){
			for( p = 0; p < bodyData.length; p++){
				var data = bodyData[p];
				var keys = [];
				for (var key in data) {
					keys.push(key);
				}
				table += '<tr class="x-grid-row">';
				for(q = 0; q < keys.length; q++){
					table += '<td class=" x-grid-cell"><div class="x-grid-cell-inner">'+data[keys[q]]+'</div></td>';
				}
				table += '</tr>';
			}
		}
		else
			return false;

		table += '</tbody></table></div>';
		var container = {
			xtype:'panel',
			cls:'block1',
			frame:true,
			border:true,
			margin:'0 0 10 0',
			html:table
		};
		return container;
	},
	createTableViewForThreshold:function(){
		/*
		* Used arguments concept of javascript function
		* It is done so to accept any number of arguments for the function
		* so that this function can be globally used to create dynamic table of any size
		*/
		var headers = Array.prototype.slice.call(arguments);
		var bodyData = headers.pop();

		var table = '<div class="x-table-outer-border"><div class="x-table" style="margin:0 0 0px 0"><table style="table-layout:auto" class="x-grid-table" cellspacing="0" cellpadding="0" border="0" ><col width="1354"><thead ><tr class="x-grid-row">';
		for(h=0;h<headers.length;h++)
		{
			if (!Ext.isEmpty(headers[h]))
			{
				table += '<th class=" x-grid-cell"><div class="x-grid-cell-inner" >'+headers[h]+'</div></th>';
			}
		}
		table += '</tr></thead>';

		table += '<tbody>';

		if(typeof bodyData == 'string'){
			table += '<tr class="x-grid-row"><td class=" x-grid-cell"><div class="x-grid-cell-inner" style="white-space:nowrap!important">'+bodyData+'</div></td></tr>';
		}
		else if(!Ext.isEmpty(bodyData)){
			for( p = 0; p < bodyData.length; p++){
				var data = bodyData[p];
				var keys = [];
				for (var key in data) {
					keys.push(key);
				}
				table += '<tr class="x-grid-row">';
				for(q = 0; q < keys.length; q++){
					table += '<td class=" x-grid-cell"><div class="x-grid-cell-inner" style="white-space:nowrap!important">'+data[keys[q]]+'</div></td>';
				}
				table += '</tr>';
			}
		}
		else
			return false;

		table += '</tbody></table></div></div>';
		var container = {
			xtype:'container',
			padding:0,
			margin:'0 0 10 0',
			html:table
		};
		return container;
	},
	refresh:function(){
		//parameters += '&searchBox='+this.getSearchTrigger().getValue();
		this.loadMoreInfoData('refresh');
	}
});