Ext.define('InfosAndDescriptor.view.CompositeWindow',{
	extend:'Ext.window.Window',
	alias:'widget.compositewindow',
	height:500,
	width:900,
	bodyBorder:true,
	bodyPadding:10,
	padding:'4 10 10 10',
	title:'Details Of Performance Rating Test Measure Calculation',
	closable:true,
	draggable:true,
	modal:true,
	scroll:true,
	autoScroll:true,
	closeAction:'hide',
	layout:'vbox',
	defaults:{
		margin:5
	},

	items:[{
			xtype:'panel',
			itemId:'informationPanel_common',
			width:'100%',
			cls:'aggMeasureInfoTableHeader',
			id:'compositeMeasureInfoHeader',
			title:'',
			hidden: false,
			//layout:'hbox',
			height:'auto',
			border:false,
			manageOverflow:2,
			layout: {
				type: 'table',
				align:'stretch',
				// The total column count must be specified here
				columns:2,
				tableAttrs: {
					cls:'aggMeasureInfoTable',
					width:'100%',
				},
				tdAttrs: {
					width:'50%',
				}
			},
			defaults:{
				labelWidth:150,
				labelSeparator:'',
				margin:0,
				padding:0,
				width:'50%',
				labelAlign:'left',

			},
			items:[{
					xtype:'displayfield',
					width:'100%',
					fieldLabel:'Conponent Type',
					itemId:'componentType',
					id:'componentType',
					value:'-'
				},{
					xtype:'displayfield',
					width:'100%',
					fieldLabel:'Conponent Name',
					itemId:'componentName',
					id:'componentName',
					value:'-'
				},{
					xtype:'displayfield',
					width:'100%',
					fieldLabel:'Test Name',
					itemId:'test',
					id:'test',
					value:'-'
				},{
					xtype:'displayfield',
					width:'100%',
					fieldLabel:'Measure Name',
					itemId:'measureName',
					id:'measureName',
					value:'-'
				},{
					xtype:'displayfield',
					width:'100%',
					fieldLabel:'Descriptor',
					itemId:'descriptor',
					id:'descriptor',
					value:'-'
				},{
					xtype:'displayfield',
					width:'100%',
					fieldLabel:'Measure Value ',
					itemId:'measurevalue',
					id:'measurevalue',
					value:'-'
				},{
					xtype:'displayfield',
					width:'100%',
					fieldLabel:'Weightage for key measures',
					itemId:'wfkm',
					id:'wfkm',
					value:'1/None/None/0'
				},{
					xtype:'displayfield',
					width:'100%',
					fieldLabel:'Weightage for non-key measures',
					itemId:'wfnkm',
					id:'wfnkm',
					value:'1/None/None/0'
				}]
	},
	{
		xtype:'panel',
		width:'100%',
		manageOverflow:2,
		border:false,
		defaults: {
			margin:'0 0 10 0',
		},
		headerStyle:{'border':'0px !important'},
		layout: {
			type: 'accordion',
			//collapseAll:false,
			//titleCollapse: true,
			animate: true,
			activeOnTop: true,
			hideCollapseTool:false,
			fill : true,
			multi:true,
		},
		id:'accordionTableView',
		items: []
	}],
	listeners: {
		show: function (f) {
			if (this.modal) {
			var g = Ext.dom.Query.select(".x-mask");
			var e = Ext.fly(g[0]);
			e.addCls("windowModal");
			}
		},
		hide: function (f) {
			if (this.modal) {
			var g = Ext.dom.Query.select(".x-mask");
			var e = Ext.fly(g[0]);
			e.removeCls("windowModal");
			}
		},
		afterrender: function () {
				Ext.EventManager.onWindowResize(function () {
				var e = this;
				e.center();
				}, this);
			}
		},
	initComponent:function(){
		this.callParent();
	},

	setData:function(json){

		Ext.getCmp('compositeMeasureInfoHeader').setTitle(json.screenLabels.measurementTime+' : '+json.measurementTime);

		Ext.getCmp('componentType').setFieldLabel(json.screenLabels.componentType);
		Ext.getCmp('componentType').setValue(json.componentType);

		Ext.getCmp('componentName').setFieldLabel(json.screenLabels.componentName);
		Ext.getCmp('componentName').setValue(json.componentName);

		Ext.getCmp('test').setFieldLabel(json.screenLabels.test);
		Ext.getCmp('test').setValue(json.test);

		Ext.getCmp('measureName').setFieldLabel(json.screenLabels.measure);
		Ext.getCmp('measureName').setValue(json.measure);

		Ext.getCmp('descriptor').setFieldLabel(json.screenLabels.descriptor);
		Ext.getCmp('descriptor').setValue(json.descriptor);

		Ext.getCmp('measurevalue').setFieldLabel(json.screenLabels.measurevalue);
		Ext.getCmp('measurevalue').setValue(json.measurevalue);

		if(json.rawWeightageType=='SystemDefined')
		{
			Ext.getCmp('wfkm').setValue('1 - Normal, 0 - Critical');
			Ext.getCmp('wfnkm').setValue('1 - Normal, 0 - Critical');
		}
		else
		{
			var keyStr = json.keyNormal+' - Normal, ';
			var kmin=json.keyMinor;
			var kmaj=json.keyMajor;
			var kcri=json.keyCritical;
			if(kmin.toLowerCase()!='none')
			{
				keyStr+=kmin+' - Minor, ';
			}
			if(kmaj.toLowerCase()!='none')
			{
				keyStr+=kmaj+' - Major, ';
			}
			if(kcri.toLowerCase()!='none')
			{
				keyStr+=kcri+' - Critical';
			}
			Ext.getCmp('wfkm').setValue(keyStr);
			//Ext.getCmp('wfkm').setValue(json.keyNormal+'-Normal, '+json.keyMinor+'-Minor, '+json.keyMajor+'-Major, '+json.keyCritical+'-Critical');

			var supStr = json.supportNormal+' - Normal, ';
			var smin=json.supportMinor;
			var smaj=json.supportMajor;
			var scri=json.supportCritical;
			if(smin.toLowerCase()!='none')
			{
				supStr+=smin+' - Minor, ';
			}
			if(smaj.toLowerCase()!='none')
			{
				supStr+=smaj+' - Major, ';
			}
			if(scri.toLowerCase()!='none')
			{
				supStr+=scri+' - Critical';
			}
			Ext.getCmp('wfnkm').setValue(supStr);
			//Ext.getCmp('wfnkm').setValue(json.supportNormal+'-Normal, '+json.supportMinor+'-Minor, '+json.supportMajor+'-Major, '+json.supportCritical+'-Critical');
		}
		var cntnrObj = Ext.getCmp('accordionTableView');
		cntnrObj.removeAll();
		var testDisplayNames = json.testDisplayNames;
		var keyMeasuresArray = json.keyMeasuresArray;
		var gridColumns = json.columnDataArrayGlobal;
		var selectedTableRowsArray = json.rowDataArrayGlobal;

		var idx = 1;
		for(var key1 in gridColumns){
			var selectedTableColumns = gridColumns[key1];
			var selectedKeyMeasuresArray = keyMeasuresArray[key1];
			var displayTableColumns = new Array();
			for(var key2 in selectedTableColumns)
			{
				var DB_COLUMN_NAME = selectedTableColumns[key2];
				displayTableColumns.push({dataIndex: DB_COLUMN_NAME,
				header: DB_COLUMN_NAME,
				flex: 1
				});
			}
			var mytitle = 'Test name : '+testDisplayNames[key1];
			if(idx==1)
			{
				mytitle = testDisplayNames[key1];//first table is for showing minimum and maximum ranges of associated test measures.
			}
			cntnrObj.add(
			{
				xtype:'gridpanel',
				id: "gp_" + (idx++),
				store: new Ext.data.Store({fields:selectedTableColumns,
					data:selectedTableRowsArray[key1]}),
				cls:'gridSkin',
				border:true,
				title:mytitle,
				style:{'border':'1px solid red'},
				columns: displayTableColumns
			});

			if(selectedKeyMeasuresArray.length>0)//only when key measures were set
			{
				var gridObj = Ext.getCmp('gp_'+(idx-1));
				var newGridColumns = gridObj.headerCt.getGridColumns();
				for(var i = 0; i < newGridColumns.length; i++)
				{
					if (selectedKeyMeasuresArray.indexOf(newGridColumns[i].dataIndex)>-1)
					{
						gridObj.columns[i].setText("<span style='line-height:16px;float:left' class='eg_9bold'>"+newGridColumns[i].dataIndex+"</span><div class='iconKey' style='float:left;margin-left:5px;margin-top:1px' title='key measure'></div>");
					}
				}
			}
		}
	}
});