Ext.define('InfosAndDescriptor.view.GraphViewList',{
	extend: 'Ext.view.View',
	alias: 'widget.graphviewlist',
	emptyText:'No images available',
	store:Ext.create('Ext.data.Store', {
		id:'imagesStore',
		fields:['scr','caption'],
		data: [
			{ src:'http://www.sencha.com/img/20110215-feat-drawing.png', caption:'Drawing & Charts' },
			{ src:'http://www.sencha.com/img/20110215-feat-data.png', caption:'Advanced Data' },
			{ src:'http://www.sencha.com/img/20110215-feat-html5.png', caption:'Overhauled Theme' },
			{ src:'http://www.sencha.com/img/20110215-feat-perf.png', caption:'Performance Tuned' }
		]
	}),
	
	tpl:new Ext.XTemplate(
		'<tpl for=".">',
			'<div class="dataview-element">',
			  '<img src="{src}" height="75px" width="75px"/>',
			  '<br/><span>{caption}</span>',
			'</div>',
		'</tpl>'
	),

	initComponent:function(){
		this.callParent();
	}
});