Ext.define('InfosAndDescriptor.view.Measures',{
	extend : 'Ext.panel.Panel',
	alias:'widget.measures',
	margin:'0 10 10 10',
	padding:0,
	id:'measuresPanel',
	layout: {
		type: 'vbox',
		align : 'stretch'
		
	},
	title:'Measurements',
	cls:'datapanel',
	frame:true,
	border:true,
	tools:[{
		xtype:'text',
		style:{'font-size':'11px'},
		styleSelector:'.svgText',
		itemId:'lastMeasureTime'
	}],
	
	dockedItems:[{
        xtype: 'toolbar',
        dock: 'top',
		itemId:'topbar',
		cls:'splToolbar',
		height:25,
		hidden:true,
		padding:'0 5 0 5',
		margin:0,
        items:[{
				
				xtype:'label',
				style:{fontWeight:'bold',fontSize:'13px',color:'#ffffff',lineHeight:'27px'},
				itemId:'measureName'
					
		},'->',
			{
			xtype:'button',
			//cls:'button20',
			margin:0,
			padding:0,
			style:{background:'none',border:'0px'},
			//text:'Help',
			itemId:'logon',
			//tooltip:'Help',
			//iconCls:'iconLogonDetails',
			iconCls:'iconDDLogonDetails',
			hidden:true
		},{   xtype: 'tbseparator'},{
			xtype:'button',
			//cls:'button20',
			//text:'Details',
			//tooltip:'Details',
			iconCls:'iconInfo',
			margin:0,
			padding:0,
			style:{background:'none',border:'0px'},
			itemId:'details',
			hidden:true
		},{   xtype: 'tbseparator'},{
			xtype:'button',
			//cls:'button20',
			style:{background:'none',border:'0px'},
			//text:'Remote',
			margin:0,
			padding:0,
			//tooltip:'Remote Control',
			iconCls:'iconRemoteControl',
			itemId:'remoteControl',
			hidden:true
		},{   xtype: 'tbseparator'},{
			xtype:'button',
			//cls:'button20',
			margin:0,
			padding:0,
			style:{background:'none',border:'0px'},
			//text:'Help',
			itemId:'help',
			//tooltip:'Help',
			iconCls:'iconHelp',
			hidden:true
		}]
	}],
	
	items:[{
		xtype:'measuresgrid',
		name:'measureGrid',
		id:'measureGrid',
		border:false,
		hidden:true,
		flex:1,
		autoScroll:true,
		scroll:true,
		store:'Measures',
		width:'100%'
	},{
		xtype:'emptypanel',
		hidden:true,
		name:'emptyPanel',
		id:'emptyPanel',
		flex:1,
		border:false,
		//height:'100%'
	}],
	
	setData:function(title,lastMeasureTime){
		this.setTitle(title);
		
		if(!Ext.isEmpty(lastMeasureTime)){
		
		this.down('text#lastMeasureTime').setText(lastMeasureTime);
		}
	},

	setToolbarData:function(json){
		if(!Ext.isEmpty(json.detailInfo)){
			this.setTopBar(true);
		//this.down('button#details').setText(json.detailInfo.detailText);
			this.down('button#details').tooltip = Ext.create('Ext.tip.ToolTip', {
																	target: this.down('button#details').id,
																	anchor: 'top',
																	cls: 'yellowTip',
																	trackMouse: true,
																	html: json.detailInfo.detailText
																});
			this.down('button#details').urlParam1 = encodeURI(json.detailInfo.urlParam1);
			this.down('button#details').urlParam2 = encodeURI(json.detailInfo.urlParam2);
			this.down('button#details').urlParam3 = encodeURI(json.detailInfo.urlParam3);
			this.down('button#details').methodSuper = json.detailInfo.methodSuper;
			this.down('button#details').show();
		}
		if(!Ext.isEmpty(json.remoteInfo)){
			this.setTopBar(true);
		//	this.down('button#remoteControl').setText(json.remoteInfo.remoteText);
			this.down('button#remoteControl').tooltip=  Ext.create('Ext.tip.ToolTip', {
																	target: this.down('button#remoteControl').id,
																	anchor: 'top',
																	cls: 'yellowTip',
																	trackMouse: true,
																	html: json.remoteInfo.remoteText
																});
			this.down('button#remoteControl').url = json.remoteInfo.url;
			this.down('button#remoteControl').show();
		}
		if(!Ext.isEmpty(json.helpInfo)){
			this.setTopBar(true);
		//	this.down('button#help').setText(json.helpInfo.helpText);
			this.down('button#help').tooltip = Ext.create('Ext.tip.ToolTip', {
																	target: this.down('button#help').id,
																	anchor: 'top',
																	cls: 'yellowTip',
																	trackMouse: true,
																	html: json.helpInfo.helpText
																});
			this.down('button#help').urlParam1 = json.helpInfo.urlParam1;
			this.down('button#help').methodSuper = json.helpInfo.methodSuper;
			this.down('button#help').show();
		}
		if(!Ext.isEmpty(json.testInfo)){
			
			var testInfoDiv = '<div style="margin-top:0px;"><div style="margin-top:3px;margin-left:3px;border:0px solid red;float:left;width:20px"><img class="state_'+json.testInfo["State"]+'" src="/final/images/clear.png"/></div><div class="comp-dash-layers-measures-icon-text" style="float:right">'+json.testInfo["Testname"]+(json.testInfo["TestDesc"]?json.testInfo["TestDesc"]:"")+(json.testInfo["unit"]?" ("+json.testInfo["unit"]+")":"");
			
			if(!Ext.isEmpty(json.testInfo.Infoname))
				testInfoDiv = testInfoDiv +" - "+json.testInfo.Infoname;
			testInfoDiv = testInfoDiv + '</div></div>'
			this.down('label#measureName').update(testInfoDiv);
		
		}
		
		if(!Ext.isEmpty(json.Logon_Details_Support) && json.Logon_Details_Support!=undefined && json.Logon_Details_Support!="undefined" && json.Logon_Details_Support!="null" && json.Logon_Details_Support!=null){
			this.setTopBar(true);
			this.down('button#logon').logonTooltip = Ext.create('Ext.tip.ToolTip', {
																	target: this.down('button#logon').id,
																	anchor: 'top',
																	cls: 'yellowTip',
																	trackMouse: true,
																	html: json.Logon_Details_Support.logonTooltip
																});
			this.down('button#logon').urlParam1 = json.Logon_Details_Support.urlParam1;
			this.down('button#logon').titleforLogon = json.Logon_Details_Support.titleforLogon;
			this.down('button#logon').show();
		}
		else
		{
			this.down('button#logon').hide();
		}
	},
	
	setTopBar:function(flag){
		if(flag && this.getDockedItems('toolbar')[0].isHidden())
			this.getDockedItems('toolbar')[0].show();
		else if(!(flag || this.getDockedItems('toolbar')[0].isHidden()))
			this.getDockedItems('toolbar')[0].hide();
	},
	
	initComponent:function(){
		this.callParent();
	}
});