Ext.define('InfosAndDescriptor.view.SearchField',{
	extend:'Ext.form.FieldContainer',
	alias:'widget.searchfield',
	width:'100%',
	layout:'hbox',
	margin:'10 0 0 0',
	items:[{
		xtype:'trigger',
		name:'search',
		cls: 'whitedropdown_search',
		itemId:'search',
		fieldLabel:'Test Descriptor',
		onTriggerClick : function(e){
			this.fireEvent('click',this);
		}
	},{
		xtype:'label',
		itemId:'searchDescription',
		html:'<span style="font-size:11px;font-weight:normal;color:#9c9c9c">&nbsp;&nbsp; * Multiple search strings should be separated using a comma</span>'
	}],
	
	setData:function(searchText,searchDesc){
		var tempInfo = searchText;
		if (tempInfo.indexOf("|hash|")>-1)
			tempInfo=tempInfo.replace('|hash|','#');
		if (tempInfo.indexOf("|amp|")>-1)
			tempInfo=tempInfo.replace('|amp|','&');
		if (tempInfo.indexOf("|plus|")>-1)
			tempInfo=tempInfo.replace('|plus|','+');
		if (tempInfo.indexOf("|pct|")>-1)
			tempInfo=tempInfo.replace('|pct|','%');
		searchText = tempInfo;
		this.getComponent('search').setValue(searchText);
		this.getComponent('searchDescription').setText(searchDesc);
	}
});