Ext.define('QInsight.view.EditView', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.editview',
    id: 'editview',
	  dataAvailable : false,
	  margin:'10 10 10 10',
    meGridObj: null,
    maintainFlex: true,
    //cls: 'gridSkin qickinsightable',
	  ui:'newGridPanel newGridPanelBorder',
	  border:true,
	  columnLines:true,
    border: false,	
    frame: false,
    enableColumnMove: true,
    enableColumnHide: false,
    sortableColumns: true,
    height: 300,
    store: new Ext.data.Store({
        fields: [],
        data: []
    }),
	scroll:true,
	autoScroll:true,
	border: false,
	initComponent : function()
	{
		var me=this;
		var hideSearchTextBoxAndAddBtn = false;
		if(this.dataAvailable)
		{
			this.selModel = new Ext.selection.CheckboxModel({
				checkOnly: true,
				width: 50,
				injectCheckbox: 0
			});
			this.columns = [
			{
				header: nameLbl,
				dataIndex: 'COLUMN_0',
				flex: 1,
				renderer: function (value, metaData, record, row, col, store, gridView) {
					var href = record.get("COLUMN_3_href");
					var action = 'view';
					var QInsName = record.get("COLUMN_0");
					QInsName = qinsightApp.getController("Main").replaceBackSlash(QInsName);
					QInsName = qinsightApp.getController("Main").replaceHtmlTag(QInsName);	
					var refrate = record.get("COLUMN_1_refreshRate");
					var userName = record.get("COLUMN_1_users");
					if (href != null && href != "-") {
						value = qinsightApp.getController("Main").replaceQuotes(value);
						value = qinsightApp.getController("Main").replaceAmp(value);						
						value = '<a href="javascript:void(0);" onClick="openView(\'' + href + '\',\'' + action + '\',\'' + refrate + '\',\'' + userName + '\',\'' + QInsName + '\')">' + value + ' </a>';
					}
					return value;

				}
			}, {
				dataIndex: 'COLUMN_1',
				menuDisabled:true,
				header: '&nbsp;',
				width: 30,
				renderer: function (value, metaData, record, row, col, store, gridView) {
					var action = 'layout';
					var QInsName = record.get("COLUMN_0");
					QInsName = qinsightApp.getController("Main").replaceBackSlash(QInsName);
					QInsName = qinsightApp.getController("Main").replaceHtmlTag(QInsName);	
					var refrate = record.get("COLUMN_1_refreshRate");
					var href = record.get("COLUMN_1_href");
					var userName = record.get("COLUMN_1_users");
					if (href != null && href != "-") {						
						value = qinsightApp.getController("Main").replaceQuotes(value);
						value = qinsightApp.getController("Main").replaceAmp(value);
						value = '<div class="iconDashboard" data-qclass="yellowTip"  data-qtip="'+toolLayout+'" style="margin:0px auto;cursor:pointer;margin-top: 2px;"  onClick="viewFunction(\'' + href + '\',\'' + action + '\',\'' + refrate + '\',\'' + userName + '\',\'' + QInsName + '\')" ></div>';
					}
					return value;
				}
			}, {
				dataIndex: 'COLUMN_2',
				menuDisabled:true,
				header: '&nbsp;',
				width:30,
				renderer: function (value, metaData, record, row, col, store, gridView) {
					var QInsName = record.get("COLUMN_0");	
					QInsName = qinsightApp.getController("Main").replaceBackSlash(QInsName);
					QInsName = qinsightApp.getController("Main").replaceHtmlTag(QInsName);	
					var action = 'config';
					var href = record.get("COLUMN_2_href");
					var refrate = record.get("COLUMN_1_refreshRate");
					var userName = record.get("COLUMN_1_users");
					if (href != null && href != "-") {
						value = qinsightApp.getController("Main").replaceQuotes(value);
						value = qinsightApp.getController("Main").replaceAmp(value);
						value = '<div class="iconDashboardModify" style="margin:0px auto;cursor:pointer;margin-top: 2px;"  onClick="viewFunction(\'' + href + '\',\'' + action + '\',\'' + refrate + '\',\'' + userName + '\',\'' + QInsName + '\')" data-qclass="yellowTip"  data-qtip="'+toolConfig+'"></div>';
					}
					return value;
				}
			}, {
				xtype: 'actioncolumn',
				menuDisabled:true,
				header: '&nbsp;',
				dataIndex: 'COLUMN_3',
				width:30,
				renderer: function (value, metaData, record, row, col, store, gridView) {
					var href = record.get("COLUMN_3_href");
					var action = 'view';
					var QInsName = record.get("COLUMN_0");
					QInsName = qinsightApp.getController("Main").replaceBackSlash(QInsName);
					QInsName = qinsightApp.getController("Main").replaceHtmlTag(QInsName);	
					var refrate = record.get("COLUMN_1_refreshRate");
					var userName = record.get("COLUMN_1_users");
					if (href != null && href != "-") {
						value = qinsightApp.getController("Main").replaceQuotes(value);
						value = qinsightApp.getController("Main").replaceAmp(value);
						value = '<div class="iconDashboardView" style="cursor:pointer;margin-top: 3px;" onClick="openView(\'' + href + '\',\'' + action + '\',\'' + refrate + '\',\'' + userName + '\',\'' + QInsName + '\')"  data-qclass="yellowTip"  data-qtip='+view+'></div>';
					}
					return value;
				}
			}, {
				header: '&nbsp;',
				menuDisabled:true,
				dataIndex: 'COLUMN_4',
				width:30,
				renderer: function (value, metaData, record, row, col, store, gridView) {
					var action = 'set as default';
					var QInsName = record.get("COLUMN_0");
					QInsName = qinsightApp.getController("Main").replaceBackSlash(QInsName);
					QInsName = qinsightApp.getController("Main").replaceHtmlTag(QInsName);	
					var set_as_default = record.get("COLUMN_4");
					var href = record.get("COLUMN_4_href");
					var refrate = record.get("COLUMN_1_refreshRate");
					var userName = record.get("COLUMN_1_users");
					if (href != null && href != "-") {
						if (set_as_default == '') {
							value = '';
						} else {
							value = qinsightApp.getController("Main").replaceQuotes(value);
							value = qinsightApp.getController("Main").replaceAmp(value);
							value = '<div class="iconSetAsDefault" data-qclass="yellowTip"  data-qtip="'+setasHome+'" style="margin:0px auto;cursor:pointer;margin-top: 2px;"  onClick="viewFunction(\'' + href + '\',\'' + action + '\',\'' + refrate + '\',\'' + userName + '\',\'' + QInsName + '\')" ></div>';
						}
					}
					return value;
				}
			},
			{
				header: '<img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" id="removeALL" class="iconDeleteAll" style="cursor:pointer" data-qclass="yellowTip"  data-qtip="'+tooltipQISRemoveAll+'"/>',
				xtype: 'actioncolumn',
				renderer : function(value, meta, record, row, col) {
					//meta['tdAttr'] = 'data-qtip="Remove"';
					meta.tdAttr = 'data-qclass="yellowTip" data-qtip='+toolRemove+' style="padding-top: 2px" ';
					return value;
				},
				menuDisabled:true,
				width: 30,
				items: [{
					iconCls: 'iconDelete',
					//tooltip: 'Remove',
					handler: function (grid, htmlRow, index, columnIndex,
						mouseEvent, record) {				
						var mid = '&view_name=' + encodeURIComponent(record.get('COLUMN_0'));
						Ext.Msg.show({
							title: alertMsg,
							msg: deleteLayout,
							buttons: Ext.Msg.YESNO,
							icon: Ext.Msg.QUESTION,
							fn: function (buttonId) {
								if (buttonId == "yes") {
									Ext.Ajax.request({
										url: '/final/monitor/qinsight/EgQInsightLayoutp.jsp?' + mid + '&command=del',
										method: 'post',
										scope: this,
										success: function (response) {							
											var jsonText = response.responseText;
											var publicJson = Ext.decode(jsonText);
											if (publicJson['result'] == 'success') {			
												qinsightApp.getController("Main").showViewConfig();
											}

										}
									});
								}
							}
						});

					}
				}]
			}
			];
		}
		else
		{
			hideSearchTextBoxAndAddBtn = true;
			this.columns = [{dataIndex : 'COLUMN_0',header : '',flex : 1,hidden : true}];
			this.store =  Ext.create('Ext.data.Store',{
			   fields:[{name : 'COLUMN_0'  , type : 'string'}],
			   data:[]
			});
		}
		me.dockedItems =[{
			xtype: 'toolbar',
			padding: '0 0 0 0',
			margin:0,
			ui: 'footer',
			layout: {
				pack: 'left'
			},
			cls:'borderbottom_alt',			
			buttonAlign: 'center',
			dock: 'top',
			items: [
					{					
						xtype:'trigger',
						hidden : hideSearchTextBoxAndAddBtn,
						fieldLabel:'',
						cls: 'whitedropdown_search',
						emptyText:'Search',
						id : 'searchQInsight',
						name : 'searchQInsight',
						labelSeparator:'',
						labelWidth:50,
						padding:'5 0 5 0',
						margin:'5 0 5 5',
						width:200,
						dock:'top',		
						enableKeyEvents: true,					
						//fieldLabel:'<b>'+QISSearch+'</b>',
						listeners: {				 
							change: {
								fn: me.onTextFieldChange,
								scope: this,
								buffer: 100
							}
						},
					},
				'->', {
					xtype: 'button',
					cls: 'button20',
					margin:'5 5 5 5',
					action: 'addNew',
					text: QISaddNewBtn
				}
			]
		}];
		this.callParent();
	},
    viewConfig: {
        deferEmptyText: false,
		//emptyText: '<div style="text-align:center;margin:8% auto 0px auto;width:500px"><div class="iconInformation" style="text-align:center;margin:0px auto"></div><div>'+noQISViewfound+'.</div><div style="cursor:pointer;margin-top:5px" onClick="javascript:newView()">click here to Configure a new view</div></div>'
		emptyText: '<div style="text-align:center;margin:8% auto 0px auto;width:500px"><div class="iconInformation" style="text-align:center;margin:0px auto"></div><div>'+noQISViewfound+'.</div></div>'
    },      
	onTextFieldChange: function(triggerField, newValue, oldValue, eOpts) {
        var me = this;
		var grid = me;
		if(newValue=="*")
		{
			grid.store.clearFilter();
		}
		else
		{
			if(newValue.lastIndexOf("*")==(newValue.length-1))
			{
				newValue = newValue.substr(0,(newValue.length-1));
			}
			grid.store.clearFilter();
			if (newValue) {
				var matcher = new RegExp(Ext.String.escapeRegex(newValue), "i");
				grid.store.filter({
					filterFn: function(record) {
						return matcher.test(record.get('COLUMN_0')) ;
					}
				});
			}
			triggerField.focus();			
		}
    },
    listeners: {
        'afterrender': function (grid, scle) {
            var cols = grid.down('gridcolumn');
            Ext.each(cols, function (col) {
                var icon = Ext.select('#removeALL');
                if (icon) {
                    grid.mon(icon, 'click', function () {
                        var meGrid = Ext.getCmp('editview');
                        var meGridStore = meGrid.getStore();
                        var noOfrecords = meGridStore.getCount();
                        var selectionModelObj = meGrid.getSelectionModel();
                        if (noOfrecords > 0) {
                            var selected = selectionModelObj.getSelection();
                            if (selected.length == 0) {
                                Ext.Msg.show({
                                    title: alertMsg,
                                    msg: selectoneLayout,
                                    buttons: Ext.MessageBox.OK,
                                    icon: Ext.MessageBox.WARNING
                                });
                                return;
                            }
                            Ext.Msg.show({
                                title: alertMsg,
                                msg: deleteLayout,
                                buttons: Ext.Msg.YESNO,
                                icon: Ext.Msg.QUESTION,
                                fn: function (buttonId) {
                                    if (buttonId == "yes") {
                                        var mid = "";
                                        meGrid.suspendEvents(false);
                                        meGridStore.suspendEvents(false);
                                        for (var i = 0; i < selected.length; i++) {
                                            var recOrg1 = selected[i];
                                            mid += '&view_name=' + encodeURIComponent(recOrg1.get('COLUMN_0'));
                                            if (recOrg1 != null && !Ext.isEmpty(recOrg1)) {
                                                meGridStore.remove(recOrg1);
                                            }
                                        }
                                        meGridStore.resumeEvents();
                                        meGrid.resumeEvents();

                                        Ext.Ajax.request({
                                            url: '/final/monitor/qinsight/EgQInsightLayoutp.jsp?' + mid + '&command=del',
                                            method: 'post',
                                            scope: this,
                                            success: function (response) {
                                                var jsonText = response.responseText;
                                                var publicJson = Ext.decode(jsonText);
                                                if (publicJson['result'] == 'success') {
                                                    if (meGrid.getStore().getCount() == 0) {														
                                                        qinsightApp.getController("Main").showViewConfig();
                                                    } else {
                                                        meGrid.getView().refresh();
                                                        meGrid.selModel.toggleUiHeader();
                                                        qinsightApp.getController("Main").showViewConfig();
                                                    }
                                                }

                                            }
                                        });
                                    }
                                }
                            });
                        }

                    })
                }
            })
        }
    }

});