Ext.define('QInsight.view.LayoutDisplay', {
    extend: 'Ext.container.Container',
	requires: ['QInsight.view.QISPanelTools'],
    id: 'demolayout',
    alias: 'widget.showdemo',
    viewName: '',
    userid: '',
    refreshFreq: '',
    onRender: function () {
        this.loadQInsightView(this.viewName, this.userid);
        this.callParent();
    },
    listeners: {
        'afterrender': function () {
			if ( this.refreshFreq > 0 )
			{
				refreskTsk = setInterval('javascript:refreshViewPage()', this.refreshFreq);
			}
        }
    },
    loadQInsightView: function (viewName, userid) {
		var currentView = "";
		if (viewName=='' || viewName == undefined || Ext.isEmpty(viewName))
		{
			var colwidth = Ext.state.Manager.get(user_id+defViewName+"ColumnWidth");
		}
		else
		{
			var colwidth = Ext.state.Manager.get(user_id+viewName+"ColumnWidth");
		}
		displayWindowValue = colwidth;
		if ( displayWindowValue =='' || displayWindowValue == undefined || Ext.isEmpty(displayWindowValue))
		{
			displayWindowValue = 1;
		}
		if ( colwidth == null || colwidth == undefined || Ext.isEmpty(colwidth))
		{
			colwidth = 1;
		}
		//Ext.getCmp('displaySettings').show();
        var me = this;
        this.up('panel').setLoading(true, true);
		var mainViewObj = Ext.getCmp('livegraph');

		if(!isNewWindow){
			mainViewObj.add({
					xtype: 'scrollcombo',
					fieldLabel:selectView,
					cls:'dropdown qinsigtviewcombo',
					maxWidth: 250,
					labelSeparator:'',
					labelStyle: {'white-space':'nowrap;','font-size':'13px','font-weight':'normal'},
					name:'viewsCombo',
					id:'viewsCombo',
					labelAlign:'right',
					margin:"10px 0px 0px -15px",
					displayField : 'name',
					valueField : 'value',
					queryMode : 'local',
					hidden:true,
					emptyText :selectView,
					store:Ext.create('Ext.data.Store',{
							fields:['name','value','user','refreshRate']
					}),
					listeners: {
						'select': function (combo, records, eOpts ) {
							var value = records[0].get('value');
							//var selectedView = Ext.getCmp("viewsCombo").getRawValue();
							var selectedView =records[0].get('name');
							if(selectedView!=currentView)
								viewFunction(value,"view",records[0].get('refreshRate'),records[0].get('user'),selectedView);
						}
					}
				});

				Ext.Ajax.request({
					url : '/final/monitor/qinsight/EgQInsightListJSON.jsp?loadViewsCombo=true',
					method : 'POST',
					scope:this,
					success : function(response, opts){
						if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
						{
							var jsonText = response.responseText;
							var jsonData = Ext.decode(jsonText);
							var combo = Ext.getCmp('viewsCombo');
							if(jsonData["ViewsComboData"]=="NO_DATA"){
								combo.hide();
							}else{
								combo.getStore().loadRawData(jsonData["ViewsComboData"]);
								if(!hideViewsCombo)
									combo.show();
								else
									combo.hide();
							}
						}
					},
					failure : function()
					{
						alert("failure");
					}
				});
		}
        var qInsightViewCont = Ext.getCmp('qInsightViewCont');
        if (qInsightViewCont == null || qInsightViewCont == 'undefined' || Ext.isEmpty(qInsightViewCont)) {
            mainViewObj.add({
                xtype: 'container',
                id: 'qInsightViewCont',
                name: 'qInsightViewCont',
                layout: {
                    type: 'column'
                },
                defaults: {
                    columnWidth: colwidth
                }
            });
            mainViewObj.doLayout();
        }
        if (userid == null || userid == undefined || Ext.isEmpty(userid))
		{
            userid = '';
        }
		if (viewName=='' || viewName == undefined || Ext.isEmpty(viewName))
		{
			viewName = '';
		}
        Ext.Ajax.request({
            url: '/final/monitor/qinsight/EgQInsightDisplayJSON.jsp?view_name=' + encodeURIComponent(viewName) + '&user_id=' + userid,
            success: function (response, opts) {
                var previeBtn = Ext.getCmp('previewbt');
                var iconAutomaticScrollRunBtn = Ext.getCmp('iconAutomaticScrollRun');
				var iconAutomaticScrollStopBtn = Ext.getCmp('iconAutomaticScrollStop');
                var iconAutomaticScrollJumpToTopBtn = Ext.getCmp('iconAutomaticScrollJumpToTop');
                var tabTVmode1Obj = Ext.getCmp('tabTVmode1');
                var tabTVmode2Obj = Ext.getCmp('tabTVmode2');
				//var displaySet = Ext.getCmp('displaySettings');
                var plotLayout = Ext.getCmp('qInsightViewCont');
                if (!Ext.isEmpty(plotLayout)) {
                    plotLayout.removeAll();
                    plotLayout.doLayout();
                }
                var jsonText = response.responseText;
				var publicJson="";
                if(jsonText != "")
				{
					publicJson = Ext.decode(jsonText);
                }

                var newView = publicJson['newView'];
				if( newView!=null && newView!='undefined' )
				{
					me.up('panel').setLoading(false);
					window.clearInterval(refreskTsk);
					if (newView == 'true') {
						previeBtn.hide();
						iconAutomaticScrollRunBtn.hide();
						iconAutomaticScrollJumpToTopBtn.hide();
						tabTVmode1Obj.hide();
						tabTVmode2Obj.hide();
						//displaySet.hide();
						Ext.getCmp('livegraph').setTitle(mainQIStitle);
						var noConfig = Ext.create('Ext.container.Container', {
							style: {
								'text-align': 'center',
								'margin-top': '1%',
							},
							html: '<div class = "iconInformation" style="margin: 5% auto 0% auto;"></div><div>'+noQuickInsightanyView+'&nbsp;&nbsp;<span><a href="#" style="font-weight:bold;text-decoration: underline" title='+newViewQIS+' id="linkId" onClick="javascript:newView()">'+newViewQIS+'.</span></a></div>'
						});
						Ext.getCmp('livegraph').add(noConfig)
						Ext.getCmp('livegraph').doLayout();
						return;
					}
					else
					{
						qinsightApp.getController("Main").showViewConfig();
					}
				}
				else {
					var previewToolTip = Ext.getCmp('previewbtnTollTip');
					if (isSharedViewAsDefault == 'false')
					{
						previewToolTip.update(modifytoolTip);
						previeBtn.show();
						//iconAutomaticScrollRunBtn.show();
						//iconAutomaticScrollJumpToTopBtn.show();
						tabTVmode1Obj.show();
						tabTVmode2Obj.show();
						previeBtn.setIconCls('iconDashboardModify');
					}
					else
					{
						previeBtn.hide();
						iconAutomaticScrollRunBtn.hide();
						iconAutomaticScrollJumpToTopBtn.hide();
						tabTVmode1Obj.hide();
						tabTVmode2Obj.hide();
					}
					//displaySet.show();
					if(isNewWindow){
						Ext.getCmp('displaySettings').hide();
						Ext.getCmp('previewbt').hide();
						Ext.getCmp('viewbt').hide();
					}

                    var tierView = publicJson;
                    var layoutName = publicJson['LayoutName'];
					currentView = layoutName;
                   var mainObj = Ext.getCmp('livegraph');
				    layoutName = qinsightApp.getController("Main").replaceHtmlTag(layoutName);
					mainObj.setTitle(mainQIStitle+" [" + layoutName + "]");
					mainObj.mainPanelTitle = layoutName;
                    if(!isNewWindow)
						Ext.getCmp('viewsCombo').setRawValue(currentView);
					var tierCnt = publicJson['tiers'];
                    tierCnt = parseInt(tierCnt);
                    var serverCnt = publicJson['servers'];
                    serverCnt = parseInt(serverCnt);
                    var metricsCnt = publicJson['metrics'];
                    metricsCnt = parseInt(metricsCnt);
                    var isTierDataAvailable = false;
                    var serverDatas;
                    var isServerDataAvailable = false;
                    if (tierView != null && !Ext.isEmpty(tierView)) {
                        isTierDataAvailable = true;
                    }
                    var arr = new Array();
                    for (var i = 0; i < tierCnt; i++) {
                        var tierTitle = '-';
                        if (isTierDataAvailable) {
                            var tierData = publicJson['tierData']['tierPos_' + (i + 1)];
                            if (!Ext.isEmpty(tierData)) {
                                tierTitle = tierData[0];
                                serverDatas = tierData[1];
                                if (serverDatas != null && !Ext.isEmpty(serverDatas)) {
                                    isServerDataAvailable = true;
                                }
								var Layoutdispaytier='<div style="font-size: 12px;font-weight:bold"><div style="float:left">' +tierTitle + '</div></div>';
                                if (tierTitle == 'None') {
                                    tierTitle = '&nbsp;';
									Layoutdispaytier='<div style="font-size: 12px;font-weight:bold"><div style="float:left">' +tierTitle + '</div></div>'
                                }
                            }

                        }

                        var tier = Ext.create('Ext.panel.Panel', {
                            title: Layoutdispaytier,
                            margin: '10',
                            padding: 0,
                            bodyStyle: {
                                'border-radius': '0px '
                            },
							id:"myId"+i,
                            cls: 'containerShadow headercaps post',
							header:{cls:'qinsightierpanel'},
							bodyCls:'qinsightinnerpan',
                            frame: true,
                            layout: {
                                type: 'hbox'

                            },
                            defaults: {
                                flex: 1,
								margin:10
                            }
                        });

                        var metricsData;
                        var isMetricsDataAvailable = false;
                        var serverArr = new Array();
                        for (j = 0; j < serverCnt; j++) {
                            var serverTitle = '-';
                            if (isServerDataAvailable) {
                                var serverData = serverDatas['ServerPos_' + (j + 1)];
                                if (serverData != null && !Ext.isEmpty(serverData)) {
                                    serverTitle = serverData[0];
                                }
                                metricsData = serverData[1];
                                if (metricsData != null && !Ext.isEmpty(metricsData)) {
                                    isMetricsDataAvailable = true;
                                }
                                if (serverTitle == 'None') {
                                    serverTitle = '&nbsp;';
                                }
                            }

                            var addServers = Ext.create('Ext.panel.Panel', {
                                cls: 'inside_block headercaps post',
                                //suspendLayout: true,
								padding:0,
								header:{
									cls:'header'
								},
								border:true,
                                frame: true,
								title: '<div style="font-size: 12px;font-weight:bold">' +serverTitle + '</div>',
                                //title: serverTitle
                            });
                            var metricArr = new Array();
                            for (var k = 0; k < metricsCnt; k++) {
                                var metricTitle = '-';
                                var metData;
                                var qryString = '';
                                var measures = '';
                                var state = '';
                                if (isMetricsDataAvailable) {
                                    metData = metricsData['MetricPos_' + (k + 1)];
                                    if (metData != null && !Ext.isEmpty(metData) && metData != 'undefined' && metData != 'None') {
                                        metData = metData.split('$');
                                        metricTitle = metData[0];
                                        qryString = metData[1];
                                        state = metData[2];
                                        measures = metData[3];
                                        metricTitle=metricTitle.replace("|dollar|","$");
                                        if (metricTitle != null && metricTitle == '')
                                            metricTitle = '&nbsp;';

                                        if (state == 'GOOD') {
                                            state = "textState_GOOD";
                                        } else if (state == 'HIGH') {
                                            state = "textState_HIGH";
                                        } else if (state == 'UNKNOWN') {
                                            state = "textState_UNKNOWN";
                                        } else if (state == 'INTERMEDIATE') {
                                            state = "textState_INTERMEDIATE";
                                        } else if (state == 'LOW') {
                                            state = "textState_LOW";
                                        }
										if(measures == undefined || measures == "" || measures=="undefined"){
											measures = '-';
											state = "textState_GRAY";
										}
										if(qryString == undefined || qryString == "" || qryString =="undefined")
										{
											var addMetrics = Ext.create('Ext.container.Container', {
												cls: 'metricscols',
	                                            frame: true,
	                                            //html: '<a style="font-size:11px;font-weight:normal;margin-left: 4px;">' + metricTitle + '</a>' + '<font class="' + state + '" style="font-weight:bold;text-align:left;margin-left: 4px;">' + measures + '</font>'
	                                            html: '<table style="width:100%"><tr><td width="80%" style="padding:3px"><a style="font-size:11px;font-weight:normal;margin-left:0px;">' + metricTitle + '</a></td><td width="20%"><span style="font-weight:bold;text-align:left;margin-left:0px;">' + measures + '</span></td></tr></table>'
		                                    });
										}
										else
										{
											var addMetrics = Ext.create('Ext.container.Container', {
												cls: 'metricscols',
	                                            frame: true,
	                                            html: '<table style="width:100%"><tr><td width="80%" style="padding:3px"><a style="font-size:11px;font-weight:normal" href="javascript:void(0)" onClick="javascript:wayToLayerModel(\'' + qryString + '\');">' + metricTitle + '</a></td><td width="20%"><a style="font-size:11px" href="javascript:void(0)" onClick="javascript:wayToLayerModel(\'' + qryString + '\');"><span style="text-align:left;font-weight:bold;" class="' + state + '">' + measures + '</span></a></td></tr></table>'
		                                    });
										}
                                    } else {
										var addMetrics = Ext.create('Ext.container.Container', {
                                            cls: 'metricscols',
                                            frame: true,
                                            html: '<div style="margin-left: 7px;">' + metricTitle + '</div>'
                                        });
                                    }
                                    metricArr.push(addMetrics);
                                }
                                addServers.add(metricArr);

                                serverArr.push(addServers);
                            }
                            tier.add(serverArr);
                            arr.push(tier);
                        }
                        plotLayout.add(arr)
                        plotLayout.doLayout();
                    }
                    me.up('panel').setLoading(false);
                }
				Ext.getCmp('iconAutomaticScrollStop').hide();
				if($('#livegraph-innerCt').height() > $('#livegraph-body').height()){				//autoscroll hide/show functionality
					Ext.getCmp('tabTVmode1').show();	
					//Ext.getCmp('iconAutomaticScrollRun').show();
					Ext.getCmp('tabTVmode2').show();
					//Ext.getCmp('iconAutomaticScrollJumpToTop').show();
				}else{
					Ext.getCmp('tabTVmode1').hide();
					Ext.getCmp('iconAutomaticScrollRun').hide();
					Ext.getCmp('tabTVmode2').hide();
					Ext.getCmp('iconAutomaticScrollJumpToTop').hide();
				}
				//console.log($('#livegraph-body').height())
				//console.log($('#livegraph-innerCt').height())
            }
        });
    }

});