Ext.define('QInsight.view.Main', {
		extend: 'utilities.OuterPanel',
		alias: 'widget.main',
		title: 'QUICK INSIGHT',
		id:'livegraph',
		mainPanelTitle:'',
		bodyCls:'OuterPanelblackbg',
		requires: [
				'utilities.Utilities',
				'utilities.EmptyPanel',
				'utilities.Settings',
				'utilities.CommonPanel',
				'utilities.ScrollCombo',				
				'Ext.selection.CheckboxModel',
				'QInsight.view.EditView',
				'QInsight.view.ViewsShared',
				'QInsight.view.QISPanelTools',
				'QInsight.view.LayoutConfig',
				'QInsight.view.QIStatusBar',
				'QInsight.view.LayoutDisplay', 
				'Ext.ux.statusbar.StatusBar'
		],
		config : {
			noConfig:null
		},
		dockedItems: [{
			xtype: 'toolbar',
			ui:'footerUI',
			border:0,
			padding:0,
			margin:0,
			dock: 'bottom',
			items: [
				{
					xtype:'qistatusbar',
					hidden:true
				}
			]
		}],
		
		initComponent: function () {
			this.initConfig();
			var me = this;				
			if((!Ext.isEmpty(fromQuickLaunch) && fromQuickLaunch=='true') && (!Ext.isEmpty(accessPageName) && accessPageName!=null && accessPageName!=undefined && accessPageName!='null' && (accessPageName!='Default'||accessPageName!='default')))
			{
				curr_viewName = accessPageName;
			}
			var ty = Ext.create('QInsight.view.LayoutDisplay',{
				viewName:curr_viewName,
				userid:curr_userId,
				refreshFreq:refreshRate
			});
			me.callParent();
			me.add(ty);
			me.doLayout();

		},
		layout: {
			type: 'vbox',
			align: 'stretch'
		},
		tools: [
			{
				xtype: 'container',
				margin: '10 0 0 0',	
				id:'icondisplay',
				items: [{
				xtype:'button',
				hidden:true,
				iconCls:'iconDisplaySettings',
				id:'displaySettings',
				listeners: {
					afterrender: function () {
						Ext.create('Ext.tip.ToolTip', {
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: dispViewSett
						});
					}
				},
				style:{
					background:'none',border:'0px'
					},
					handler: function (event, toolEl, panel) {
						Ext.get('display_pan').animate({to: {y: 51},listeners:{ afteranimate:function(){  Ext.get('display_pan').setStyle('left', '');}}}).show();
						var radioObj = Ext.getCmp('displayRadioGrp');
						 radioObj.setValue({
							 layout1:displayWindowValue});	
					}
				}]
			},{ xtype: 'tbspacer', width: 20 },
				{xtype:'component',
				margin:'0 5 0 5',	
				id:'today',listeners: {
						render: function () {
							Ext.TaskManager.start({
								run: function () {							
									var mgrtime = egClock1();
									Ext.getCmp('today').update( '<span style="font-size:10px" class="currentalarmlabel">'+mgrtime+'</span>');
								},
								interval: 1000,
								scope:this
							});
						}
					}},
				{xtype: 'tbseparator',margin:0}, 
				{xtype: 'qipaneltools'}				
				],
		items:[
				{
					xtype:'container',
					id:'plotlayout',
					
					layout:{
						type:'column'
					},
					defaults:{
						columnWidth:1
					}
				}
		]

	});
/*  Script for automatic scroll options   start here   */

var divCount = 2;
var gettingComponentDivId=0;
var scrolldelay;
var gettingDivId;
var dom;
function pageScroll() {
	var getMainBody = Ext.getCmp('livegraph').body;
	var divHeight = 0;
	var top = document.getElementById('viewsCombo');
	var top_height = top.offsetHeight;
	console.log(top.offsetHeight)
	if(gettingComponentDivId == 0){
		gettingDivId ='myId'+gettingComponentDivId;
		dom=Ext.get(gettingDivId).dom;
		divHeight+= Math.round(dom.offsetHeight + top_height + 40);
		gettingComponentDivId++
	}else{
		gettingDivId ='myId'+gettingComponentDivId;
		dom=Ext.get(gettingDivId).dom;
		divHeight+= Math.round(dom.offsetHeight + 20);
		gettingComponentDivId++
	}
	console.log(divHeight)
	getMainBody.scrollBy(0,divHeight);
	scrolldelay = setTimeout('pageScroll()', 3000);
	if($('#livegraph-body').scrollTop() + $('#livegraph-body').innerHeight()>=$('#livegraph-body')[0].scrollHeight)
	{
		gettingComponentDivId=0;
		getDiv=0;

		if (window.parent.tvModePlayAction!=undefined && window.parent.tvModePlayAction=='pause')
		{
			stopScroll();
			setTimeout('startTvModePlayAction()',3000);
		}
		else
		{
			clearTimeout(scrolldelay);
			scrolldelay = setTimeout('beforeContinueScroll()',3000);
		}
	}
}

function startTvModePlayAction(){
	jumpScroll();
	window.parent.startTvModePlayAction();
}
function beforeContinueScroll(){
	$('#livegraph-body').scrollTop(0);
	scrolldelay = setTimeout('pageScroll()',3000);
}
function stopScroll(){
	clearTimeout(scrolldelay);
}

function jumpScroll(){
	clearTimeout(scrolldelay);
	gettingComponentDivId=0;
	$('#livegraph-body').scrollTop(0); // horizontal and vertical scroll targets
}

	scrolldelay = null;
	delete scrolldelay;
/*  Script for automatic scroll options   end here   */




