var flow = (function(data){
	if(Ext){
		Ext.tip.QuickTipManager.init();	
	}
	//console.log(data);
	var url = data.rumTopology.header_Info.URL,
		urlRquestDataTime = data.rumTopology.header_Info.REQUEST_DATE,
		urlZone = data.rumTopology.header_Info.REQUEST_TIME_ZONE,
		userData = data.rumTopology.user_Info,
		browserData = data.rumTopology.browser_Info,
		contentData = data.rumTopology.contentDownload_Info,
		contentData = data.rumTopology.contentDownload_Info,
		networkData = data.rumTopology.network_Info,
		backendData = data.rumTopology.backend_Info,
		pieChartData = data.rumTopology.pieChart_Info,
		mappingNameData = data.rumTopology.mappingName_Info,
		ajaxType = data.rumTopology.browser_Info.PAGETYPE,
		skin = data.rumTopology.skin,
		error_Count = userData.ERROR_MSG_COUNT,
		resourceData = data.gridData;



	function trimString(str,len,stringlen) {
	  if (str.length > len) {
		return str.substr(0, stringlen) + ' ... ' + str.substr(str.length-10, str.length);
	  }
	  return str;
	}
var loadResourceData = function(data,x,y){
	//console.log(data);
	if(!Ext.isEmpty(data)){
			var store = Ext.create('Ext.data.Store', {
				 storeId: 'resourceStore',
				 fields: ['Resource_Name', 'Resource_Domain', 'Resource_Type', 'Resource_Time'],
				data: data
			});
		
		var grid = Ext.create('Ext.grid.Panel', {
				closeAction:'destroy',
				cls:'gridSkin',
				flex:1,
				emptyText:'NO Data Found',
				store: store,
				columns: [{
					text: '<span style="text-transform: uppercase">Resources</span>',
					dataIndex: 'Resource_Name',
					flex: 1.98
				},{
					text: '<span style="text-transform: uppercase">Domain</span>',
					dataIndex: 'Resource_Domain',
					flex: 0.9
				},{
					text: '<span style="text-transform: uppercase">Type</span>',
					dataIndex: 'Resource_Type',
					flex: 0.5
				}, {
					text: '<span style="text-transform: uppercase">Duration</span><span style="text-transform: lowercase"><br>(ms)</span>',
					flex: 0.62,
					dataIndex: 'Resource_Time'
				}]
			});

			Ext.create('Ext.window.Window',{
				floating:true,
				width:500,
				height:300,
				modal:true,
				tools:[
				{
					xtype:'button',
					tooltip:'Maximize',
					border:false,
					margin:'0 5 0 5',
					handler:function(){
								 var win = this.up('window');
								 win.setWidth(Ext.getBody().getViewSize().width - 20,true);
								win.setHeight(Ext.getBody().getViewSize().height - 20,true);
								win.center();
								this.hide();
								this.next('button').show();

					},
					cls:'iconMaximizeGray'
				},
				{
					xtype:'button',
					hidden:true,
					tooltip:'Minimize',
					border:false,
					margin:'0 5 0 5',
					handler:function(){
						var win = this.up('window');
								win.setWidth(500,true);
								win.setHeight(300,true);
								win.showAt(x,y);
								this.hide();
								this.prev('button').show();
					},
					cls:'iconMinimizeGray'
				}
				],
				ghost:false,
				padding:'5 10 10 10',
				
				renderTo:Ext.getBody(),
				layout:{
					type:'vbox',
					align:'stretch'
				},
				closeAction:'destroy',
				title: '<span style="text-transform: uppercase;font-size:12px;">Details Of Page Contents</span>',
				items:[grid]
			}).showAt(x,y);
	}else{
		return false;
	}
}
	$.fn.loadData = function(){
		this.userBlock = function(data) {

			$toogle = $("<div>",{id:"toogleGrp","class":"toogleGrp"});
			$toogleList = $("<div>",{id:"toogleList"});
			$toogle.append($toogleList);
			$toogle.append('<button id="toggleButton" class="rumtogglearrow"></button>');
			if(userData){
				var _this = $(this);
				for (var keys in data)
				{
					if (data.hasOwnProperty(keys)) {
						// console.log(keys);
						switch(keys){
							case 'USER_NAME':
								_this.append('<div class="username">'+data['USER_NAME']+'</div>');
							break;
							case "DEVICE":
								var device = "DEVICE";
								_this.append('<div class="rumuserIcon"><div class="deviceinfo" data-qtip="Device:&nbsp;'+data['DEVICE']+'" data-qclass="yellowTip"><div class='+data['DEVICE']+' ></div></div></div>');
							break;
							case "RUM_USER_EXPERIENCE":
								_this.append('<div class="rumUX'+data['RUM_USER_EXPERIENCE']+'"></div><div class="font24 " style="margin-top:15px">'+data['PAGE_LOAD_TIME']+'<span style="font-size:12px;letter-spacing: 0px;vertical-align:2px" class="ms"> (ms)</span></div><div class="font_bold" style="margin:10px auto;">Page Load Time</div>');
							break;
							case "PAGE_LOAD_TIME":
								_this.append('');
							break;
							default:
								$list = $("<div>",{"class":"list","style":"margin-bottom:5px"});
								var tipdata = "", tipmessage;

								if(keys === "CITY"){
								
								$list.html('<div class="iconRUM'+keys+'" style="float:left" data-qtip="Location" data-qclass="yellowTip"></div><div class="block'+keys+' listblk brlist" style="float:left;margin-left:5px;font-weight:bold" data-qtip="Location" data-qclass="yellowTip">'+data["CITY"]+', '+data["REGION"]+', '+data["COUNTRY"]+', '+data["COUNTRY_CODE"]+'</div><div style="clear:both"></div></div>');
								}else{
								if(keys == "ERROR_MESSAGE"){
									tipdata = mappingNameData[keys]+"&nbsp;:&nbsp;"+data[keys];
									_this.append('<div class="rum_errorview"></div>');
									_this.append('<div class="rum_error"><div class="rumError_cont"><div style="padding:3px;font-size:12px;word-wrap:break-word;" class="error_con">'+tipdata+'</div></div><div>');
									//console.log($('.error_con').height())
									if($('.error_con').height() > 58){
										$('.rum_error').append('<button id="error_toggleButton" class="error_tgleButt rumtogglearrow"></button>');
									}
									tipmessage = trimString(data[keys] ,70,8);

								}else{
									tipdata = mappingNameData[keys];
									tipmessage = data[keys];
								}
									if(keys != "ERROR_MESSAGE"){
										$list.html('<div class="iconRUM'+keys+'" style="float:left;" data-qtip="'+tipdata+'" data-qclass="yellowTip"></div><div style="float:left;margin-left:5px;font-weight:bold;width: 100px;text-align: left;word-wrap: break-word;word-break: break-word;" class="block'+keys+' listblk brlist" data-qtip="'+tipdata+'" data-qclass="yellowTip">'+tipmessage+'</div><div style="clear:both"></div></div>');
									}
									if(keys == "ERROR_MSG_COUNT"){
											$list.html(' ');
									}
								}
								_this.append($toogle);
								$toogleList.append($list);
							break;
						}


					}
				}
				
			}
		};
		this.browserBlock = function(browserData){
			$bwrDiv = $('<div>',{"class":"bwrDiv"});
			$bwrContentDiv = $('<div>',{"class":"bwrContent"});
			$bwrlistDiv = $('<div>',{"class":"bwrlistDiv",id:"listDiv"});
			$bwrFooter = $('<div>',{"class":"bwrfooter"});
			$bwrFooter.append('<button id="browserToggle" class="rumtogglearrow" style="margin-left:120px"></button>');
			$bwrDiv.append($bwrContentDiv);
			$bwrDiv.append($bwrFooter);
			if(browserData){
				var _this = $(this);
				for(var keys in browserData){
					if(browserData.hasOwnProperty(keys)){
						$list = $("<div>",{"class":"list","style":"margin-bottom:5px" ,"data-qtip":""+mappingNameData[keys]+"" , "data-qclass":"yellowTip"});
						$list.html('<div class="iconRUM'+keys+'" style="float:left"></div><div style="float:left;margin-left:5px;font-weight:bold;width: 100px;text-align: left;word-wrap: break-word;word-break: break-word;" class="brlist" >'+browserData[keys]+'</div></div><div style="clear:both;padding:0px 0px!important"></div>');
						if(keys == "PAGE_RENDER_TIME"){
						
							var contentAjax = ajaxType == "Ajax" ? "Ajax Callback Time" : "Browser Time";
							$bwrContentDiv.append("<div style='padding:15px 0px 0px 0px'><div class='font24 bfont' >"+browserData["PAGE_RENDER_TIME"]+"<span style='font-size:12px;letter-spacing: 0px;vertical-align: 2px' class='ms'> (ms)</span></div><div><div class='font_bold' style='margin:5px auto 0px auto;padding:0px 0px 15px 0px '>"+contentAjax+"</div>");
							_this.append($bwrDiv);
						}else{
							$bwrContentDiv.append($bwrlistDiv)
							$bwrlistDiv.append($list);
							_this.append($bwrDiv);
						}


					}
				}
			}
		};
		this.contentDownload = function(contentdownloaddata){
			$cntlistDiv = $('<div>',{"class":"listDiv contentdownload",id:"cntDiv","data-qclass":"yellowTip","data-qtip":"Content Download Time Break-up","style":"min-width: 250px;"});
			$cntlistdetail = $('<div>',{"class":"cntlistdetail","style":"padding:20px 20px 10px 20px;color:#FFF"});
			$cntlistdetail.html('<div class="font24" style="color:#FFF;padding-bottom:10px">'+contentdownloaddata['DOCUMENT_READY_TIME']+'<span style="color:#FFF;font-size:12px;letter-spacing: 0px;vertical-align:2px" class="ms"> (ms)</span></div><div class="font_bold"  style="color:#FFF;margin:0px auto" >Content Download Time</div>');
				$cntlistDiv.append($cntlistdetail);
			if(contentdownloaddata){
				var _this = $(this);
				var pointer ="cursor:auto";
				for (var keys in contentdownloaddata)
				{
					if(contentdownloaddata.hasOwnProperty(keys)){
						if(keys == "DOCUMENT_READY_TIME"){
							
							var contentAjax = ajaxType == "Ajax" ? "hidden" : "visible";
							_this.append('<div><div class="font24 cfont"><span class="fbg cntText">'+contentdownloaddata[keys]+'<span style="font-size:12px;letter-spacing: 0px;vertical-align:2px" class="ms"> (ms)</span></span><button id="contentdownload" style="visibility:'+contentAjax+'"></button></div><div class="font_bold" style="margin:10px auto;width:150px"><span class="fbg">Content Download Time</span></div></div>');
						}else{
							$list = $("<div>",{"class":"list"});
							var resourceDetaillinkID ="";
							$src_details = "";
								if(!Ext.isEmpty(data.gridData)){
									if(keys == "Document Processing Time (ms)"){
										pointer ="cursor:pointer";
										resourceDetaillinkID = "link";
										$src_details = '<img  data-qtip="Resource details" style="cursor:pointer;vertical-align:middle" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconTopologySearch"/>';
										
									}
								}

							
							$list.html('<div style="float:left;width:70%;white-space: nowrap;"><div><span id='+resourceDetaillinkID+' data-qtip="Resource details" style="'+pointer+';position:relative;z-index:1">'+keys+' '+$src_details+'</span></div></div><div style="float:right;text-align:right;width:30%">'+contentdownloaddata[keys]+'</div><div style="clear:both;padding:0px 0px!important"></div>');
							$cntlistDiv.append($list);
							_this.append($cntlistDiv);
						}

					}
				}
			}
		};
		this.isAjax = function(ajaxType){
				var _this = $(this);
				$nwtDetail = $('<div>',{"class":"nwtDetail","style":"padding:20px 20px 10px 20px;"});
				$nwtDetail.html('<div class="fbg" style="padding:10px;width:40px;margin:-20px  auto"><span class="font_bold14">'+ajaxType+'<br>Call</span></div>');
				_this.append($nwtDetail);
		}
		this.networkInfo = function(networkInfodata){
			$nwtlistDiv = $('<div>',{"class":"listDiv",id:"nwtDiv","data-qclass":"yellowTip","data-qtip":"Network Connection Time Break-up"});
			$nwtDetail = $('<div>',{"class":"nwtDetail","style":"padding:20px 20px 10px 20px;color:#FFF"});
			$nwtDetail.html('<div class="font24" style="color:#FFF;padding-bottom:10px">'+networkInfodata['SERVER_CONNECTION_TIME']+'<span style="color:#FFF;font-size:12px;letter-spacing: 0px;vertical-align:2px" class="ms"> (ms)</span></div><div class="font_bold"  style="color:#FFF;margin:0px auto" >Network Connection Time</div>');
			$nwtlistDiv.append($nwtDetail);

			if(contentDownloadInfo){
				var _this = $(this);
				for (var keys in networkInfodata)
				{
					if(networkInfodata.hasOwnProperty(keys)){

						if(keys == "SERVER_CONNECTION_TIME"){
							
									_this.append('<div id="networkBlock"><div class="font24 nfont"><span class="fbg ntText">'+networkInfodata["SERVER_CONNECTION_TIME"]+'<span style="font-size:12px;letter-spacing: 0px;vertical-align:2px" class="ms">	(ms)</span></span><button id="shownetworkconnections"></button></div><div class="font_bold" style="margin:10px auto;width:150px"><span class="fbg">Network Connection Time</span></div></div>');
								
						}else{
							$list = $("<div>",{"class":"list"});
							$list.html('<div><div style="float:left;margin-right:10px;">'+keys+'</div><div style="float:right">'+networkInfodata[keys]+'</div><div style="clear:both;padding:0px 0px!important"></div></div>');
							$nwtlistDiv.append($list);

						}
					}
				}
				_this.append($nwtlistDiv);
			}
		};
		this.backendInfo = function(backendInfodata){
			if(backendInfodata){
				var _this = $(this);
				for (var keys in backendInfodata)
				{
					if(backendInfodata.hasOwnProperty(keys)){ 
						 _this.append('<div style="position:absolute;top:45%;bottom:50%;left:0%;right:0%"><div class="font24 be_font">'+backendInfodata[keys]+'<span style="font-size:12px;letter-spacing: 0px;vertical-align:2px" class="ms"> (ms)</span></span></div><div class="font_bold" style="margin:10px auto;">Server Time</div></div>');
					}
				}
			}
		};
		this.loadChart = function(pieChartData){
			if(pieChartData){
				var _this = $(this),chartData=[],k=0;
				// console.log(pieChartData);
				for (k;k<pieChartData.length;k++ )
				{
					//console.log("pieChartData[k]",pieChartData[k])
						chartData.push({
							name: pieChartData[k].value,
							y: pieChartData[k].value,
							legend: pieChartData[k].legend,
							color: pieChartData[k].color,
							dataLabels: {
								enabled: true,
								formatter: function(){
								 return((this.point.percentage>9.9?Highcharts.numberFormat(this.point.percentage,0)+" % ": null));
								}
							}	
						});
				}

				// console.log(chartData);
				_this.highcharts({
					chart: {
						type: 'pie',
						marginLeft:11,
						marginTop:6,
						marginRight:11,
						marginBottom:36,
						backgroundColor:'transparent'
						
					},
					exporting: {
					 enabled: false
					},
					credits: {
					  enabled: false
				  },
					title: {
						text: 'Break-up of'+'<br>'+'Page Load Time (%)',
						y:10,
						style: {
							color: skin == "Dark" ? '#c6c6c6' : '#000000',
							fontSize:"13px",
							fontWeight: 'normal'
						}
					},
					plotOptions: {
						 
						pie: {
							showInLegend: true,
							point:{
								events : {
									 legendItemClick: function(e){
									 this.select();
									 var chart =  $('#chartBlock').highcharts();
									 chart.tooltip.refresh(this);
									 return false;
									}
								}
							},
							startAngle: 0,
							endAngle: 360,
							 borderWidth: 0,
							shadow: false,
							
							 dataLabels: {
									distance:-25,
									enabled: true,
									style: {
										fontWeight:'bold',
										color: '#FFFFFF'
									}
								}
						}
						
					},
					tooltip: {
						formatter: function() {
							var tooltipText;
							switch(this.point.legend){
								case "CONTENT_DOWNLOAD_PERCENTAGE":
									tooltipText = "Content Download Time";
								break;
								case "BROWSER_PERCENTAGE":
									tooltipText  = ajaxType == "Ajax" ? "Ajax Callback Time" : "Browser Time";
								break;
								case "NETWORK_PERCENTAGE":
									tooltipText = "Network Connection Time";
								break;
								case "BACKEND_PERCENTAGE":
									tooltipText = "Server Time";
								break;
							}
							return tooltipText;
						}
					},
					/*"tooltip": {
						"formatter": function(){
							return this.point.name+": <b>"+this.y+" ms </b>("+Highcharts.numberFormat(this.percentage,2)+" %) ";
						}
					},*/
					legend: {
						align: 'left',
						
						 labelFormatter: function () {
							var legendText;
							switch(this.legend){
								case "CONTENT_DOWNLOAD_PERCENTAGE":
									legendText = "Content Download Time";
								break;
								case "BROWSER_PERCENTAGE":
									legendText = ajaxType == "Ajax" ? "Ajax Callback Time" : "Browser Time";
								break;
								case "NETWORK_PERCENTAGE":
									legendText = "Network Connection Time";
								break;
								case "BACKEND_PERCENTAGE":
									legendText = "Server Time";
								break;
							}
							return legendText;
						},
						layout: 'vertical',
						itemHoverStyle:{
							"color": "#84b8e4"
						},
						itemStyle:{
									"fontSize": "11px", 
									"dy":"10px",
									"fontWeight": "normal",
									"color": skin == "Dark" ? '#c6c6c6' : '#000000',
								},
						lineHeight:10,
						symbolHeight:8,
						symbolWidth:8,
						verticalAlign: 'bottom',
						x: 0,
						dy:5,
						y: 3
					},
					series: [{
						data: chartData,
						innerSize: '44%',
						size: '100%'
					}]
				});

				_this.append('<div class="chartMirror"></div>');
			}
			
		}
 
		return this;
	}


	var $mainDiv = $("<div>", {id: "rumTopology", "class": "RUMTopologywrapper"});
	var $mainBODY = $("<div>", {id: "rumTopology-body", "class": "RUMTopologybodywrapper"});
	var $headerDiv = $("<div>", {"class": "rumTopologyheader"});
	var $rumTopologyTitle = $("<div>", {"class": "rumTopologyTitle"});
	var $topologyBlock = $("<div >", {id:"topologyBlock","class": "topologyBlock"});
	var $userBlock = $("<div>", {"class": "userBlock"});
	var $arrowBlock = $("<div>", {"class": "arrowBlock"});
	var $browerBlock = $("<div>", {"class": "browerblock"});
	var $browerlayerBlock = $("<div>", {"class": "browerlayer"});
	var $requestrespondblock = $("<div>", {"class": "requestrespondblock"});
	//var $requestrespondblockarrow = $("<div>", {class: "requestrespondblockarrow"});
	var $contentDownloadInfo = $("<div>", {"class": "contentdownloadinfo"});
	var $networkInfo = $("<div>", {"class": "networkinfo"});
	var $cloudBlock = $("<div>", {"class": "cloudBlock"});
	var $ajaxBlock = $("<div>",{"class":"ajaxBlock","style":"height:120px"});
	var $chartBlock = $("<div>", {"class": "chartBlock",id:"chartBlock"});
	
	//console.info(data);
	flow.renderFlowDiagram = function(selector){
		$('#'+selector).append($mainDiv);	
	}
	//this.renderFlowDiagram()
	//$('body').append($mainDiv);
	
	
	$mainDiv.append($headerDiv);

	$mainDiv.append($mainBODY);
	$headerDiv.html('<span>RUM Transaction Details</span>');
	// back button
	$headerDiv.html('<span style="float:left;font-size:13px">RUM Transaction Details</span> <div  id="rumbackbt" class="x-btn backbutton x-box-item x-btn-default-small x-icon-text-left x-btn-icon-text-left x-btn-default-small-icon-text-left" style="float:right;position:relative !important;margin-top: 7px;" data-qclass="yellowTip" data-qtip="Back"><em ><button type="button" class="x-btn-center" hidefocus="true" role="button" autocomplete="off" style="height: 16px;"><span  class="x-btn-inner" style="">Back</span><span class="x-btn-icon iconBack"></span></button></em></div>');

	$mainBODY.append($rumTopologyTitle);
	$rumTopologyTitle.html('<span class="outerBg"><span class="bold">Request for </span><span data-qclass="yellowTip" data-qtip='+url+' >'+trimString(url,10,50)+'</span><span class="bold"> at </span>'+urlRquestDataTime+'&nbsp;'+ urlZone+'<span>');

	$mainBODY.append($topologyBlock);
	$topologyBlock.append($userBlock);
	$topologyBlock.append($arrowBlock);
	$topologyBlock.append($browerBlock);
	$browerBlock.append($browerlayerBlock);
	$topologyBlock.append($requestrespondblock);
	$mainBODY.append($chartBlock);
	
	//$topologyBlock.append($requestrespondblockarrow);
	$topologyBlock.append($cloudBlock);
	
	if(ajaxType == "Ajax"){
		$mainBODY.append('<div style="position:absolute;bottom:10px;left:10px;">*For Ajax requests, server time includes network time</div>');
		$requestrespondblock.append($ajaxBlock);
		$requestrespondblock.append($contentDownloadInfo);
	}else{
		$requestrespondblock.append($networkInfo);
		$requestrespondblock.append($contentDownloadInfo);
		
	}
	$topologyBlock.append('<div style="clear:both"></div>');
	/*
	* Initialization of each block
	*/
	var initUserdata = $userBlock.loadData(),
		initBrowserdata = $browerBlock.loadData(),
		contentDownloadInfo = $contentDownloadInfo.loadData(),
		networkInfo = $networkInfo.loadData(),
		backendInfo = $cloudBlock.loadData(),
		ajaxBlock = $ajaxBlock.loadData(),
		chartBlock = $chartBlock.loadData();
	/*
	*	Loading each data
	*/
	initUserdata.userBlock(userData);
	initBrowserdata.browserBlock(browserData);
	contentDownloadInfo.contentDownload(contentData);
	networkInfo.networkInfo(networkData);
	backendInfo.backendInfo(backendData);
	chartBlock.loadChart(pieChartData);
	ajaxBlock.isAjax(ajaxType);

	//Events
	
	//Window close
	$('#rumbackbt').click(function(){
	 var win = window.parent.Ext.getCmp('rumTopologyBuildWindow');
    if(win)win[win.closeAction]();
});

	$('#toggleButton').click(function(){
		var _this = $(this);
		_this.css('z-index',999);
		//$(_this).css({bottom:$('#toogleList').height - 50+"px"});
		if ($toogleList.is(':hidden')) {
					//$('.toogleGrp').css('z-index',99);
					//$('.rumuserIcon').css('z-index',100);
					
				}
		
		$toogleList.slideToggle( "slow", function() {
			if ($toogleList.is(':hidden')) {
					//$('.toogleGrp').css('z-index',999);
					_this.removeClass('rumtogglearrowRotate');
					$(_this).css({bottom:"-4px"});
				}else{
					_this.addClass('rumtogglearrowRotate');
			
					if ($bwrlistDiv.is(':hidden')){
					}else{
						$bwrlistDiv.slideToggle();
						$('#browserToggle').removeClass('rumtogglearrowRotate');
							
						
					}
				}
		});
	});
	$('#browserToggle').click(function(){
		var _this = $(this);
		$bwrlistDiv.slideToggle( "slow", function() {
			if ($bwrlistDiv.is(':hidden')) {
					_this.removeClass('rumtogglearrowRotate');
				}else{
					_this.addClass('rumtogglearrowRotate');
					if($toogleList.is(':hidden')) {
					}else{
						$toogleList.slideToggle();
						//$('#toggleButton').css({bottom:"-50px"});
						$('.toogleGrp').css('z-index',999);
						$('#toggleButton').removeClass('rumtogglearrowRotate');
							
					}
					
				}
		});
	});
	$('#error_toggleButton').click(function(){
		var _this = $(this);

		if($('#error_toggleButton').hasClass("rumtogglearrowRotate")){
			$('.rumError_cont').animate({height:58},500,function(){
					$('.rum_error').animate({marginTop:0});
					$(this).css({"overflow":"hidden"});
					$(this).find('.error_con').animate({marginTop:$(this).scrollTop()});
					
					Ext.defer(function(){
						$('.rum_error').css({"z-index":"0"});
					},550);
				_this.removeClass('rumtogglearrowRotate');
			});
			
		}else{
			$('.rumError_cont').animate({height:177},500,function(){
				$(this).css({"overflow-y":"auto","z-index":"9"});
				$(this).find('.error_con').animate({marginTop:0});
				$(this).animate({scrollTop: 0 });
				
				$('.rum_error').animate({marginTop:-115});
				
				$('.rum_error').css({"z-index":"9999"});
				_this.addClass('rumtogglearrowRotate')
			});
			
		}
	})
	$('#shownetworkconnections, .ntText').mouseover(function() {
		$nwtlistDiv.show();
	}).mouseout(function() {
		//$nwtlistDiv.show();
	});
	$('#nwtDiv, .ntText').mouseenter(function() {
		$('#nwtDiv').show();
	}).mouseleave(function() {
		$('#nwtDiv').hide();
	});
	$('body').on('click','#link',function(e){
	
		loadResourceData(resourceData,e.clientX - 300,e.clientY-280);	
		//loadResourceData(resourceData,372,370);
		//loadResourceData(resourceData,650,437);
	});
   
	$('#contentdownload, .cntText').mouseover(function() {
		
		if(ajaxType != "Ajax")  $cntlistDiv.show();
		
	}).mouseout(function() {
		//$nwtlistDiv.show();
	});
	$('#cntDiv, .cntText').mouseenter(function() {
		if(ajaxType != "Ajax") $('#cntDiv').show();
	}).mouseleave(function() {
		$('#cntDiv').hide();
	});

	$(window).resize(function(){
		// console.log($(document).width());
		if($mainBODY){
			//$mainBODY.width($(document).width() - 10);
			//console.log('--',$('.outerBg').width() + 105);
			var titleWidth = $('.outerBg').width();
			var outerWidth = $mainBODY.width();
			var lengthURL = parseInt(url.length)*16;
			var urlLength = parseInt(url.length);
			//console.log(lengthURL);
			var len = 40;
			/*	if(lengthURL > outerWidth){
					len = 35;
				}*/
			if(outerWidth >= 500 && outerWidth <= 1190){
				if (urlLength > 52)
				{
					$rumTopologyTitle.html('<span class="outerBg"><span class="bold">Request for </span><span data-qclass="yellowTip" data-qtip='+url+' data-qclass="yellow-tip">'+trimString(url,10,len)+'</span><span class="bold"> at </span>'+urlRquestDataTime+'&nbsp;'+ urlZone+'<span>');
				} else {
					$rumTopologyTitle.html('<span class="outerBg"><span class="bold">Request for </span><span data-qclass="yellowTip" data-qtip='+url+' data-qclass="yellow-tip">'+url+'</span><span class="bold"> at </span>'+urlRquestDataTime+'&nbsp;'+ urlZone+'<span>');
				}
			}else{
				$rumTopologyTitle.html('<span class="outerBg"><span class="bold">Request for </span><span data-qclass="yellowTip" data-qtip='+url+' data-qclass="yellow-tip">'+url+'</span><span class="bold"> at </span>'+urlRquestDataTime+'&nbsp;'+ urlZone+'<span>');
			
			}
			delete $rumTopologyTitle;
		}


	}).resize();

})(data);