var fromLayersFlag=false;
var dailyLimitExceed =1;
Ext.define('RealUserMonitor.controller.Main',{
	extend:'Ext.app.Controller',
	requires:['RealUserMonitor.view.Main','RealUserMonitor.view.MapAndChart','RealUserMonitor.view.SiteList','RealUserMonitor.view.GroupedRequest','RealUserMonitor.view.Base','RealUserMonitor.view.Alarms','RealUserMonitor.view.ShowDD','RealUserMonitor.view.SlowLocations','RealUserMonitor.view.DDAlerts','RealUserMonitor.view.RumTabPanel','RealUserMonitor.view.RumOverviewTab','RealUserMonitor.view.RumGeoView','RealUserMonitor.view.RumTimelineGraph','RealUserMonitor.view.RumMap','RealUserMonitor.view.LocationInfo','RealUserMonitor.view.GeoDataGrid','RealUserMonitor.view.GenericViewPanel','RealUserMonitor.view.BrowserAndDevices','RealUserMonitor.view.BrowserDeviceGrid','RealUserMonitor.view.PagesAndAjax','RealUserMonitor.view.LocationsMap','RealUserMonitor.view.LocationsMapContainer'],
	stores:['GeoData','BrowserData'],
	refs:[{
		ref:'main',
		selector:'main'
	},{
		ref:'groupedRequest',
		selector:'groupedrequest'
	},{
		ref:'siteList',
		selector:'sitelist'
	},{
		ref:'alarms',
		selector:'alarms'
	},{
		ref:'showdd',
		selector:'showdd'
	},{
		ref:'slowLocations',
		selector:'slowlocations'
	},{
		ref:'mapAndChart',
		selector:'mapandchart'
	},{
		ref:'ddalerts',
		selector:'ddalerts'
	},{
		ref:'rumTabPanel',
		selector:'rumtabpanel'
	},{
		ref:'locationsMapContainer',
		selector:'locationsmapcontainer'
	},{
		ref:'LocationsMap',
		selector:'locationsmap'
	},{
		ref:'rumOverviewTab',
		selector:'rumoverviewtab'
	},{
		ref:'rumoverviewBottomPanel',
		selector:'rumoverviewtab container[itemId=bottomPanel]'
	},{
		ref:'rumTimelineGraphs',
		selector:'rumtimelinegraph'
	},{
		ref:'locationInfo',
		selector:'locationinfo'
	},{
		ref:'rummap',
		selector:'rummap'
	},{
		ref:'genericViewPanel',
		selector:'genericviewpanel'
	},{
		ref:'rumBDView',
		selector:'browserdevice'
	},{
		ref:'rumBDPanel',
		selector:'browserdevice container[itemId=contentBD]'
	},{
		ref:'rumDeviceGraph',
		selector:'browserdevice container[itemId=bdGraphContainer]'
	},{
		ref:'rumBDGrid',
		selector:'browserdevice container[itemId=bdGrid]'
	},{
		ref:'pagesAndAjax',
		selector:'pagesandajax'
	}],
	init:function()
	{
		//refreshVar = setInterval("refreshRUM()", refreshFrequency);
		setInterval("refreshJsonData()", refreshFrequency);
		refreshRUMDash = setInterval("refreshRUMDashboard()", refreshRUMFrequency);
		this.control({
			'main':
			{
				'render':this.mainFormRender
			},
			'main button[id=backButton]':
			{
				'click':this.handlingBack
			},
			'main combo[id=sitesComboId]':
			{
				'select':this.upateSecPanel
			},
			'rumtabpanel':
			{
				tabchange:this.rumTabPanelChange
			},
			'browserdevice combo':
			{
				'select':this.BDCombo_onchange
			},
			'pagesandajax button[id=paBack]':
			{
				'click':this.onClickPagesAndAjaxDD
			},
			'pagesandajax combo[id=filterby]':
			{
				'select':this.onChangePagesAndAjax
			},
			'main locationsmapcontainer combo[id=countryCombo]':{
				'select':this.comboChange 
			},
			'main locationsmapcontainer combo[id=regionCombo]':{
				'select':this.comboChange 
			}
		});
	},
	comboChange:function(combo){
		var ref = combo.id;
		if(ref != null && ref != undefined){

			if(listenerArray != undefined && listenerArray != null){
				for(var l=0;l<listenerArray.length;l++){
					google.maps.event.removeListener(listenerArray[l]);
				}
			}

			var counCombo = Ext.getCmp('countryCombo');
			var regCombo = Ext.getCmp('regionCombo');
			
			var countryComboVal = counCombo.getValue();
			var regionComboVal = regCombo.getValue();
			
			findAccess = countryComboVal;


			
			if( ref == 'countryCombo' && countryComboVal != undefined && countryComboVal !=null )
			{
				if(countryComboVal=='All'){
					regCombo.setValue('All');
					cntClick('Country',tabBackUp,null,true);
					regCombo.setDisabled(true);
					
				}
				else if(countryComboVal != 'All')
				{
					nextMap = 'Region';
					isCityMap = false;
					cntClick(countryComboVal,tabBackUp,null,true);
					regCombo.setDisabled(false);
				}
			}else{
				if(regionComboVal== 'All'){
					nextMap = 'Region';
					isCityMap = false;
					cntClick(countryComboVal,tabBackUp,null,true);
				}
				else{
					nextMap = 'City';
					cntClick(countryComboVal,tabBackUp,regionComboVal,true);
				}
			}
		}
	},
	mainFormRender:function(){
		var accessType = 'allAccessType';
		//url = '/final/servlet/com.eg.RUMController?site='+site+'&accessType='+accessType;
		//url = "/final/servlet/com.eg.RUMController?getSites=yes&accessData="+accessType;
		//url = "/final/servlet/com.eg.RUMController?getComponents=yes&accessData="+accessType;
		url = "/final/servlet/com.eg.RUMController?getComponents=yes&accessData=allAccessType";
		var me = this;

		var resultObj = me.getMain();
		var jsonDataObj =null;
		Ext.Ajax.request({
			url:url,
			timeout:300000,
			success:function(response)
			{
				var jsonText = response.responseText;
				if (!Ext.isEmpty( jsonText))
				{
					var jsonData = Ext.decode(jsonText);
					jsonDataObj = jsonData;
					delete jsonText;
					Ext.destroy(jsonText);
					jsonText = null;
					if (!Ext.isEmpty( jsonData.testFreqInMin ) && jsonData.testFreqInMin!=undefined && jsonData.testFreqInMin!="")
					{
						//me.getMain().setTitle('<div style="float:left">Real User Monitoring Dashboard</div><div style="float:right">Showing data for last '+jsonData.testFreqInMin+' minutes</div>');
						me.getMain().setTitle('<div id="titleDiv" style="float:left">'+pageTitle+'</div>');
					}
					else if (!Ext.isEmpty( jsonData.testFreq ))
					{
						if(jsonData.testFreq!=undefined && jsonData.testFreq=='N/A')
						{
							//me.getMain().setTitle('<div style="float:left">Real User Monitoring Dashboard</div><div style="float:right">The test has not been configured</div>');
							me.getMain().setTitle('<div id="titleDiv" style="float:left">'+pageTitle+'</div>');
						}
						else if(jsonData.testFreq!=undefined && jsonData.testFreqInMin!="")
						{
							//me.getMain().setTitle('<div style="float:left">Real User Monitoring Dashboard</div><div style="float:right">Showing data for last '+jsonData.testFreq+' seconds</div>');
							me.getMain().setTitle('<div id="titleDiv" style="float:left">'+pageTitle+'</div>');
						}
					}

					if ( !Ext.isEmpty( jsonData ))
					{
						var layersSiteId='';
						if (!Ext.isEmpty( resultObj))
						{
							var resultItems=resultObj.items.items;
							for(var item=resultItems.length-1; item>-1 ; item--)
							{
								resultItems[item].destroy()
							}
						}

						if (!Ext.isEmpty( jsonData.No_Sites ))
						{
							var errorMsg='<center><div style="margin:10% 0 auto 0"><div class="iconInformation" ></div><div class="commonErrorMsgText">No data available</div></div></center>';
							var err ={
										xtype:'panel',
										html:errorMsg
									};
							me.getMain().add(err);

							// For Automatic Scroll icon show hide function

							var scrollRun = Ext.getCmp('iconAutomaticScrollRun');
							if (!Ext.isEmpty(scrollRun) )
							{
								scrollRun.hide();
							}
							ScrollJumpToTop = Ext.getCmp('iconAutomaticScrollJumpToTop');
							if (!Ext.isEmpty(ScrollJumpToTop) )
							{
								ScrollJumpToTop.hide();
							}
							Ext.Element.select('.removeLineForTvMode').hide();

							// For Automatic Scroll icon show hide function

						}
						else if (!Ext.isEmpty( jsonData.sitesArray ))
						{
							var sitesJsonArray=jsonData.sitesArray;
							var isRedirect=false;
							for(var item=0; item<sitesJsonArray.length; item++)
							{
								var siteItemJson=sitesJsonArray[item];

								if(selectedName!=null && selectedName!=undefined && siteItemJson.siteName!=null && siteItemJson.siteName!=undefined && selectedName==siteItemJson.siteName)
								{
									isRedirect = true;
									break;
								}

								if( selDrilldown && selCompName!=null && selCompName!=undefined && siteItemJson.siteName!=null && siteItemJson.siteName!=undefined && selCompName==siteItemJson.siteName)
								{
									isRedirect = true;
									break;
								}
							}
							
							for(var item=0; item<sitesJsonArray.length; item++)
							{
								var siteItemJson=sitesJsonArray[item];

								var testFreqDiv="";
								if (!Ext.isEmpty( siteItemJson.testFreqInMin ) && siteItemJson.testFreqInMin!=undefined && siteItemJson.testFreqInMin!="")
								{
									if(siteItemJson.testFreqInMin != null && siteItemJson.testFreqInMin == '1')
										testFreqDiv='<div style="float:right;font-weight:normal;font-size:10px">'+showingDataForLast+' '+siteItemJson.testFreqInMin+'&nbsp;'+minutes+'</div>';
									else
										testFreqDiv='<div style="float:right;font-weight:normal;font-size:10px">'+showingDataForLast+' '+siteItemJson.testFreqInMin+'&nbsp;'+minutes+'</div>';
								}
								else if (!Ext.isEmpty( siteItemJson.testFreq ))
								{
									if(siteItemJson.testFreq!=undefined && siteItemJson.testFreq=='N/A')
									{
										testFreqDiv='<div style="float:right;font-weight:normal;font-size:10px">The test has not been configured</div>';
									}
									else if(siteItemJson.testFreq!=undefined && siteItemJson.testFreqInMin!="")
									{
										testFreqDiv='<div style="float:right;font-weight:normal;font-size:10px">'+showingDataForLast+' '+siteItemJson.testFreq+'&nbsp;'+seconds+'</div>';
									}
								}

								//var title= "<div style='float:left;margin-left:-5px;padding-left:-5px;margin-top:5px'><img src='/final/images/spacer.gif' class='state_"+siteItemJson.siteState+"'/> </div><div style='float:left;padding-left:2px;padding-top:2px'>"+siteItemJson.siteName+"</div>";
								
								//var title= "<div style='margin-left:-5px;'><img src='/final/images/spacer.gif' class='state_"+siteItemJson.siteState+"'/> ";

								//var title='<div style="float:left"><a href="javascript:void(0);" onclick = \'javascript:goToTabsetPage("site_'+item+'",false);\'>'+siteItemJson.siteDispName+'</a></div><div style="margin-left:5px;float:left" class="iconRumToLayermodel handSymbol"  data-qclass="yellowTip" data-qtip="'+siteItemJson.siteDispName+'" href="javascript:void(0);" onclick = \'javascript:DashboardToLayers("'+siteItemJson.siteName+'");\'></div>';

								var title= "";
								if(isEnableStateInRUM)
								{
									title= "<div style='float:left;margin-left:-5px;margin-right:3px;padding-left:-5px;'><img src='/final/images/spacer.gif' class='state_"+siteItemJson.siteState+"'/> </div><div style='margin-left:5px;float:left'><a>"+siteItemJson.siteDispName+"</a> </div><div style='margin-left:5px;float:left' class='iconRumToLayermodel handSymbol'  data-qclass='yellowTip' data-qtip='Layer Model' href='javascript:void(0);' onclick = \"javascript:DashboardToLayers('"+siteItemJson.siteName+"');\"></div><div style='margin-left:5px;float:left' class='iconGridWeb handSymbol' onclick = \"javascript:DashboardToRumApp('"+siteItemJson.siteName+"');\" data-qclass='yellowTip' data-qtip='RUM Dashboard' href='javascript:void(0);' ></div>";
								}
								else
								{
									title= "<div style='margin-left:-5px;float:left;margin-right:3px;'><a class='rumLink' >"+siteItemJson.siteDispName+"</a> </div><div style='margin-left:5px;float:left' class='iconRumToLayermodel handSymbol'  data-qclass='yellowTip' data-qtip='Layer Model' href='javascript:void(0);' onclick = \"javascript:DashboardToLayers('"+siteItemJson.siteName+"');\"></div><div style='display: inline-block;margin-left:5px;float:left' class='iconGridWeb handSymbol' onclick = \"javascript:DashboardToRumApp('"+siteItemJson.siteName+"');\"    data-qclass='yellowTip' data-qtip='RUM Dashboard' href='javascript:void(0);' ></div>";
								}
								
								
								//var titleNoLink= "<span style='font-size:18px'><div style='margin-left:-5px;'>"+siteItemJson.siteDispName+"</div></span>";
								var titleNoLink= '<span style="font-size:18px"><div style="margin-left:-5px;float:left">'+siteItemJson.siteDispName+'</div><div style="margin-left:5px;float:left;width:20px" class="iconRumToLayermodel handSymbol"  data-qclass="yellowTip" data-qtip="Layer Model" href="javascript:void(0);" onclick = \'javascript:DashboardToLayers("'+siteItemJson.siteName+'");\'></div><div style=\'margin-left:5px;float:left\' class=\'iconGridWeb handSymbol\' onclick = \'javascript:DashboardToRumApp("'+siteItemJson.siteName+'");\' data-qclass=\'yellowTip\' data-qtip=\'RUM Dashboard\' href=\'javascript:void(0);\' ></div></span>';

								if(fromLayersToDashboard!=null && fromLayersToDashboard && layersTitle!=null && layersTitle!=undefined && siteItemJson.siteDispName!=null && siteItemJson.siteDispName!=undefined && layersTitle == siteItemJson.siteDispName)
								{
									layersSiteId = 'site_'+item;
								}

								var site = {
									xtype:'panel',
									cls:'rumDatapanel',
									id:'site_'+item,
									name:'site',
									title:'<span style="float:left;font-size:15px">'+title+'</span><span style="float:right;">'+testFreqDiv+'</span>',
									margin:'10 10 10 10',
									header:{
										padding:'7 0',
										margin:'0 10'
									},
									//baseCls:'rumLeft rumRight',
									//style:{'border':'0px solid red'},
									siteName:siteItemJson.siteName,
									siteDispName:siteItemJson.siteDispName,
									siteState:siteItemJson.siteState,
									siteTestFreqInMin:siteItemJson.testFreqInMin,
									siteTestFreq:siteItemJson.testFreq,
									jsonDataObj:jsonData,
									noLinkTitle:titleNoLink,
									height:164,
									border:true,
									collapsible: false,
									frame:false,
									idNo:item,
									bodyPadding:'10',
									layout:{
										type:'hbox',
										align:'stretch'
									},
									//align:'fit',
									width:'100%',
									defaults:{/*columnWidth:.24,*/padding:'0 0 0 0'},
									items:[],
									listeners:{
										'resize':function( panel, width, height, oldWidth, oldHeight, eOpts){
											//if(!Ext.isEmpty(oldWidth)){
												if(width < 1150){
												
													Ext.defer(function(){
														Ext.select('.responsive').setStyle('font-size','10px');
														
													},500);
													
												}else{
													Ext.defer(function(){
														Ext.select('.responsive').setStyle('font-size','12px');
													},500);
													

												}
											//}

										},
										'afterrender': function(thisObj){
											var inner_url = '/final/servlet/com.eg.RUMController?site='+encodeURI(thisObj.siteName)+'&accessType=allAccessType&fromService='+fromSerFlag;

											var mask = new Ext.LoadMask(Ext.getCmp('site_'+item), {
												msg: "Loading..."
											});
											var siteItemNo=thisObj.idNo;
											var siteNameVal=thisObj.siteName;
											var noLinkTitleVal=thisObj.noLinkTitle;
											mask.show();
											Ext.Ajax.request({
												url:inner_url,
												method : 'POST',
												scope:this,
												timeout:300000,
												success:function(res)
												{
													//mask.hide();
													Ext.destroy(mask);
													var innerJsonText = res.responseText;
													if (!Ext.isEmpty( innerJsonText))
													{
														var innerJsonData = Ext.decode(innerJsonText);

														delete innerJsonText;
														Ext.destroy(innerJsonText);
														innerJsonText = null;
														if ( !Ext.isEmpty( innerJsonData ))
														{
															if(!Ext.isEmpty( innerJsonData.NoSiteData ))
															{
																var errorMsg='<center><div style="margin:2% 0 auto 0"><div class="iconInformation" ></div><div class="commonErrorMsgText">No Traffic Detected</div></div></center>';
																thisObj.setTitle(noLinkTitleVal);
																var err ={
																			xtype:'container',
																			columnWidth:1.0,
																			html:errorMsg
																		};
																thisObj.add(err);
															}
															else if(!Ext.isEmpty(innerJsonData.siteMeaDataArray ))
															{
																var sitesDataArray=innerJsonData.siteMeaDataArray;
																if(sitesDataArray.length==0)
																{
																	var errorMsg='<center><div style="margin:2% 0 auto 0"><div class="iconInformation" ></div><div class="commonErrorMsgText">No Traffic Detected</div></div></center>';
																	thisObj.setTitle(noLinkTitleVal);
																	var err ={
																				xtype:'container',
																				columnWidth:1.0,
																				html:errorMsg
																			};
																	thisObj.add(err);
																}
																else
																{
																	for(var mditem=0; mditem<sitesDataArray.length; mditem++)
																	{
																		var siteDataItemJson=sitesDataArray[mditem];

																		if ( !Ext.isEmpty( siteDataItemJson.sitePanelArray ))
																		{
																			var sitePanelArray=siteDataItemJson.sitePanelArray;
																			if(sitePanelArray.length==0)
																			{
																				var errorMsg='<center><div style="margin:2% 0 auto 0"><div class="iconInformation" ></div><div class="commonErrorMsgText">No Traffic Detected</div></div></center>';
																				thisObj.setTitle(noLinkTitleVal);
																				var err ={
																							xtype:'container',
																							columnWidth:1.0,
																							html:errorMsg
																						};
																				thisObj.add(err);
																			}
																			else
																			{
																				for(var vitem=0; vitem<sitePanelArray.length; vitem++)
																				{
																					var sitePanelItemJson=sitePanelArray[vitem];

																					if(!Ext.isEmpty( sitePanelItemJson.DayLimitExceed ) && sitePanelItemJson.DayLimitExceed=='true')
																					{
																						var errorMsg='<table height="100%" align="center" style="margin:2% auto"><tr><td ><img style="margin-top:-2px" src="/final/images/spacer.gif" class="iconAlert"/></td><td>&nbsp;<span class="rumGraphErrorMsgText">Daily limit has been exceeded</span></td><tr></table>';
																						
																						thisObj.setTitle(noLinkTitleVal);
																						var err ={
																									xtype:'container',
																									columnWidth:1.0,
																									html:errorMsg
																								};
																						thisObj.add(err);
																					}
																					else
																					{
																						var topDataVal=sitePanelItemJson.topData;

																						var middleDataValArray=sitePanelItemJson.middleDataArray;
																						var bottomDataArray=sitePanelItemJson.bottomData;

																						var bottomDataVal=sitePanelItemJson.bottomData;
																						var panelWidth=sitePanelItemJson.panelWidth;

																						var panelID="";
																						var padding = "0 10 0 10";
																						if (vitem==0)
																						{
																							panelID=thisObj.id;
																							padding = "0 10 0 0";
																							//panelID.setWidth(200);
																						}
																						var conDiv="";
																						if ( !Ext.isEmpty( topDataVal ))
																						{
																							var tool_tip="";
																							if ( !Ext.isEmpty( topDataVal.Text_ToolTip ))
																							{
																								tool_tip=topDataVal.Text_ToolTip;
																							}

																							var info_tip="";
																							if ( !Ext.isEmpty( topDataVal.Info_Tip ))
																							{
																								info_tip=topDataVal.Info_Tip;
																							}

																							if ( !Ext.isEmpty( topDataVal.NoState ) && topDataVal.NoState=='YES')
																							{
																								//<div style='height:22px;width:16px;float:left;margin-top:-1px;margin-right:3px'><img class='rumIUnqUsers' src='/final/images/spacer.gif' /></div> 
																								//conDiv=conDiv+"<table  width='100%' style='border:1px solid green'>";
																									//conDiv=conDiv+"<tr>";
																										conDiv=conDiv+"<div class='rumHeaderText'>";
																											if ( !Ext.isEmpty( topDataVal.NoIcon ) && topDataVal.NoIcon=='YES')
																											{
																												conDiv=conDiv+"<div style='text-align:left;padding-left:1px' data-qclass='yellowTip' data-qtip='"+tool_tip+"'>"+topDataVal.Title+"</div>";
																											}
																											else
																											{
																												if (info_tip!=null && info_tip!=undefined && info_tip!="")
																												{
																													conDiv=conDiv+"<table cellspacing='0' cellpadding='0' border='0'><tr><td><div class='rumHeaderText' style='text-align:center;padding-left:1px;margin-top:-1px' data-qclass='yellowTip' data-qtip=''><span>"+topDataVal.Title+"</span></div></td><td style='padding-left:3px'><div class='iconRumInfo' style='float:left;margin-top:-1px' data-qclass='yellowTip' data-qtip='"+info_tip+"'></div></td></tr></table>";
																												}
																												else
																												{
																													conDiv=conDiv+"<div style='text-align:left;padding-left:1px' data-qclass='yellowTip' data-qtip='"+tool_tip+"'>"+topDataVal.Title+"</div>";
																												}
																												
																											}
																										conDiv=conDiv+"</div><div class='crl'></div>";
																									//conDiv=conDiv+"</tr></table>";

																									//conDiv=conDiv+"<table style='margin-top:60px'><tr>";
																										conDiv=conDiv+"<div style='border:0px solid orange;white-space:nowrap;display:inline;margin-top:5px' class='rumSubheadText'>";
																											conDiv=conDiv+"<span class='rumValuesBig' style='margin-top:25px;'>"+topDataVal.Value+"</span>&nbsp;"+topDataVal.Text;
																										conDiv=conDiv+"</div>";
																									//conDiv=conDiv+"</tr>";

																								//conDiv=conDiv+"</table>";
																							}
																							else if ( !Ext.isEmpty( topDataVal.NoState ) && topDataVal.NoState=='NO')
																							{
																								conDiv=conDiv+"<div class='rumHeaderText'>";
																									if ( !Ext.isEmpty( topDataVal.NoIcon ) && topDataVal.NoIcon=='YES')
																									{
																										conDiv=conDiv+"<table width='100%'>";
																											conDiv=conDiv+"<tr>";
																												conDiv=conDiv+"<td width='20'>";
																													//conDiv=conDiv+"<div style='margin-top:-3px'><table ><tr><td ><img src='/final/images/spacer.gif' class='stateSymbol_"+topDataVal.State+"'/></td></tr></table></div>";
																												conDiv=conDiv+"</td>";
																												var topDataValTitle = topDataVal.Title;
																												if(!Ext.isEmpty(topDataValTitle) && topDataValTitle.indexOf('Unique Sessions/IPs')>-1)
																												{	
																													conDiv=conDiv+"<th width='100%' style='text-align:center;white-space:normal' data-qclass='yellowTip' data-qtip='"+tool_tip+"'>";
																													conDiv=conDiv+"<div class='rumHeaderText'  style='text-align:center;'><span>"+topDataValTitle+"</span></div>";
																												}
																												else{
																													conDiv=conDiv+"<th width='100%'  style='text-align:center;padding-left:4px' data-qclass='yellowTip' data-qtip='"+tool_tip+"'>";
																													conDiv=conDiv+"<div class='rumHeaderText' style='text-align:center;'><span>"+topDataValTitle+"</span></div>";
																												}
																												conDiv=conDiv+"</th>";
																											conDiv=conDiv+"</tr>";
																										conDiv=conDiv+"</table>";
																									}
																									else
																									{
																										//<div style='height:22px;width:16px;float:left;margin-top:-1px;margin-right:3px'><img class='rumIUnqUsers' src='/final/images/spacer.gif' /></div> 
																										conDiv=conDiv+"<div style='text-align:center;padding-left:4px' data-qclass='yellowTip' data-qtip='"+tool_tip+"'>"+topDataVal.Title+"</div>";
																									}
																								conDiv=conDiv+"</div><div class='crl'></div>";

																								conDiv=conDiv+"<div style='border:0px solid blue;white-space:normal;display:block;' class='rumSubheadText'>";
																									conDiv=conDiv+"<span class='rumValuesBig rum_"+topDataVal.State+"'  style='margin-top:25px;'>"+topDataVal.Value+"</span>&nbsp;"+topDataVal.Text;
																								conDiv=conDiv+"</div>";
																							}
																							else
																							{

																								var headerAlign="";
																								if (middleDataValArray.length<=1)
																								{
																									headerAlign="";
																								}
																								else
																								{
																									headerAlign="width:100%;";
																								}

																								conDiv=conDiv+"<table  style='"+headerAlign+";border:0px solid green'>";
																									conDiv=conDiv+"<tr>";
																										conDiv=conDiv+"<td width='20'>";
																											conDiv=conDiv+"<div style='margin-top:-3px'><table ><tr><td ><img src='/final/images/spacer.gif' class='stateSymbol_"+topDataVal.State+"'/></td></tr></table></div>";
																										conDiv=conDiv+"</td>";
																										conDiv=conDiv+"<th class='rumHeaderText' style='text-align:left;padding-left:4px' data-qclass='yellowTip' data-qtip='"+tool_tip+"'><span>";
																											conDiv=conDiv+topDataVal.Title;
																										conDiv=conDiv+"</span></th>";
																									conDiv=conDiv+"</tr>";
																								conDiv=conDiv+"</table>";
																							}
																						}

																						var conMiddleDiv="";
																						var innerWidth1="";
																						if ( !Ext.isEmpty( middleDataValArray ) && middleDataValArray.length>0)
																						{
																							//conMiddleDiv=conMiddleDiv+"<div style='float:none;width:100%;border:1px solid violet;margin-top:0px;display:inline'>";
																							//conMiddleDiv=conMiddleDiv+"<div style='border:0px solid red;display:inline-block;width:20%'></div>";

																							var innerWidth=(middleDataValArray.length == 5)?'21%':'100%';

																							//var innerWidth1=(middleDataValArray.length == 5)?'21%':'50%';
																							if (!Ext.isEmpty(bottomDataVal))
																							{

																								if (bottomDataVal.length==1 && middleDataValArray.length>=1)
																								{
																									innerWidth1="100%";

																								}
																								else if (bottomDataVal.length>=1 && middleDataValArray.length==2)
																								{
																									innerWidth1="50%";
																								}
																								else if (bottomDataVal.length>=1 && middleDataValArray.length==5)
																								{
																									innerWidth1="21%";
																								}
																								else
																								{
																									innerWidth1="50%";
																								}

																							}
																							middleDataValArray.reverse();
																							for(var maitem=0; maitem<middleDataValArray.length; maitem++)
																							{
																								var middleDataObj=middleDataValArray[maitem];
																								
																								var rumLine="rumSeparatorSmall";
																								var marginLeft='0';
																								if(maitem == 0){
																									
																									rumLine="";
																									
																								}
																								else if(maitem != middleDataValArray.length)
																								{
																									rumLine="rumSeparatorSmall";
																									marginLeft='0';
																									
																								}
																								else
																								{
																								
																									marginLeft='0';
																								}
																								

																								if ( !Ext.isEmpty(middleDataObj.Icon) && !Ext.isEmpty(middleDataObj.Text) && middleDataObj.Value>=0)
																								{
																									
																									if(!Ext.isEmpty(middleDataObj.DD_URL))
																									{
																										conMiddleDiv=conMiddleDiv+"<div class='responsive' style='position:relative;margin-left:"+marginLeft+";border:0px solid blue;display:inline-block;float:right;margin-top:29px;height:30px;padding:0px 0px 0px 0px'><div style='float:left;'><img class='rum"+middleDataObj.Icon+"' style='margin-top:3px' src='/final/images/spacer.gif'/></div><div style='text-align:left;float:left;margin-right:5px'><a href='javascript:void(0)'  onclick='javascript:showDDPopup(\""+middleDataObj.DD_URL+"\")'><span class='rumVisitsText'>"+middleDataObj.Value+"</span><br/> "+middleDataObj.Text+"</a></div><div class='"+rumLine+"' style='position: absolute;right:0px;height:30px;width:2px;bottom: inherit;margin-right:-2px;'></div></div>";
																									}
																									else
																									{
																										conMiddleDiv=conMiddleDiv+"<div class='responsive' style='position:relative;display:inline-block;float:right;margin-top:29px;'><div style='float:left;'><img class='rum"+middleDataObj.Icon+"' src='/final/images/spacer.gif'/></div><div style='text-align:center;float:none;margin-right:3px'><span class='rumVisitsText'>"+middleDataObj.Value+"</span> <br/>"+middleDataObj.Text+"</div><div class='"+rumLine+" ' style='position: absolute;right:0px;height:30px;width:2px;bottom: inherit;'></div></div>";
																									}

																									//<a href='javascript:void(0)' onclick='javascript:showDDDetails(\""+paramFor_dd+"\")'>"+sorted_info+"</a>
																								}
																								else if ( !Ext.isEmpty( middleDataObj.Text ))
																								{
																									if (!Ext.isEmpty(middleDataObj.Unit))
																									{
																										if(!Ext.isEmpty(middleDataObj.DD_URL))
																										{
																											//conMiddleDiv=conMiddleDiv+"<table align='left' style='margin-top:10px;width:"+innerWidth1+";text-align:center;border:0px solid violet' class='rumSubheadText'><tr><td style='white-space:nowrap;text-align:center'><a href='javascript:void(0)' onclick='javascript:showDDPopup(\""+middleDataObj.DD_URL+"\")'><span class='rumValuesBig rum_"+middleDataObj.State+"'>"+middleDataObj.Value+'&nbsp;'+middleDataObj.Unit+"<\/span>&nbsp;"+middleDataObj.Text+"</a></td></tr></table>";
																											conMiddleDiv=conMiddleDiv+"<div style='float:left;margin-top:10px;width:"+innerWidth1+";text-align:center;padding:0px;border:0px solid violet;white-space:nowrap;' class='rumSubheadText'><a href='javascript:void(0)' onclick='javascript:showDDPopup(\""+middleDataObj.DD_URL+"\")'><span style='margin-top:0px;border:0px solid' class='rumValuesBig rum_"+middleDataObj.State+"'>"+middleDataObj.Value+'<span style="font-size:18px;">'+middleDataObj.Unit+"</span><\/span>"+middleDataObj.Text+"</a></div>";
																										}
																										else
																										{
																											conMiddleDiv=conMiddleDiv+"<div align='left' style='float:left;width:50%;padding-top:18px;text-align:center;border:0px solid yellow' class='rumSubheadText'><span class='rumValuesBig rum_"+middleDataObj.State+"'>"+middleDataObj.Value+'<span style="font-size:18px;">'+middleDataObj.Unit+"</span></span>&nbsp;"+middleDataObj.Text+"</div>";
																										}
																									}
																									else
																									{
																										
																										if(!Ext.isEmpty(middleDataObj.DD_URL))
																										{
																											conMiddleDiv=conMiddleDiv+"<div align='center' style='float:left;width:"+innerWidth1+";margin-top:4px;text-align:center;border:0px solid red' class='rumSubheadText'><a href='javascript:void(0)' onclick='javascript:showDDPopup(\""+middleDataObj.DD_URL+"\")'><span class='rumValuesBig rum_"+middleDataObj.State+"'\>"+middleDataObj.Value+"<\/span>"+middleDataObj.Text+"<\/a></div>";
																										}
																										else
																										{
																											//var sparkWidth=(botObj.bottomArray.length == 1)?'100%':'21%';

																											

																											conMiddleDiv=conMiddleDiv+"<div align='center' style='margin-top:4px;float:left;width:"+innerWidth+";text-align:center;border:0px solid green;white-space:nowrap' class='rumSubheadText'><span class='rumValuesBig rum_"+middleDataObj.State+"'>"+middleDataObj.Value+"</span>"+middleDataObj.Text+"</div>";
																										}
																									}
																								}
																							}
																							//conMiddleDiv=conMiddleDiv+"</div>";
																						}

																						var conBottomDiv="<div></div>";
																						var flag= false;
																						var gDataVal="";
																						var gTooltip="";
																						if ( Ext.isEmpty( bottomDataArray ))
																						{
																							flag=true;
																							//var errorMsg = '<center><div style="height:30px;margin:5px 0 0 0"><img class="iconAlert" src="/final/images/spacer.gif"/>&nbsp;No measures available</div></center>';

																							/*var errorMsg = '<div style="height:50px"><img src="/final/images/spacer.gif"/></div>';
																							bottomCompSize = bottomDataVal.graphData.length;
																							if(!Ext.isEmpty(bottomDataVal.graphData[0].DataSet) && !Ext.isEmpty(bottomDataVal.graphData[0].DataSet[0]))
																							{
																								gDataVal=bottomDataVal.graphData[0].DataSet[0].sparkdata;
																								if ( !Ext.isEmpty( bottomDataVal.graphToolTip ))
																								{
																									gTooltip=bottomDataVal.graphToolTip;
																								}
																							}*/
																						}
																						else
																						{
																							flag=true;
																						}
																						
																						var separator={
																							xtype:'tbseparator',
																							//cls:'rumSeparator',
																							padding:0,
																							margin:'0 0 0 0'
																						};
																						var newPanel = {
																							id:'dataConId_'+siteItemNo+"_"+mditem+"_"+vitem,
																							name:'sitePanelContainer',
																							xtype:'container',
																							style:{'border':'0px solid yellow'},
																							//layout:'column',
																							width:panelWidth,
																							layout:{type:'vbox',align:'stretch'},
																							//flex:1,
																							border:	false,
																							height:'auto',
																							margin:'0 0 0 0',
																							padding:padding,
																							collapsible: false,
																							items:[
																								{
																									xtype:'component',
																									name:'topPanel',
																									itemid:'top_'+siteItemNo+'_'+mditem+'_'+vitem,
																									html:conDiv,

																									align:'center',
																									layout:{type:'vbox',pack:'center'},
																									collapsible: false,
																									style:{'text-align':'center !important'},
																									width:'100%'
																								},
																								{
																									xtype:'component',
																									name:'middlePanel',
																									itemid:'middle_'+siteItemNo+'_'+mditem+"_"+vitem,
																									html:conMiddleDiv,
																									align:'center',
																									flex:1,

																									layout:{type:'vbox',pack:'center',align:'stretch'},
																									//cls:'rumMoreBox',
																									collapsible: true,
																									hidden:false,
//																									style:{'margin-top':'-11px','border':'0px solid green','text-align':'center !important'},
																									width:'100%'
																								},
																								{
																									xtype:'container',
																									itemid:'container_bottom_'+siteItemNo+'_'+mditem+"_"+vitem,
																									html:conBottomDiv,
																									//hidden:flag,
																									hidden:false,
																									collapsible: true,
																									align:'center',
																									width:'100%',
																									layout:'hbox',
																									margin:'0 0 0 0',
																									bottomArray:bottomDataArray,
																									style:{'border':'0px solid violet','text-align':'right !important'},
																									items:[],
																									listeners:{
																										'afterrender': function(botObj){
																											if( !Ext.isEmpty( botObj.bottomArray ) )
																											{
																												var sparkWidth=(botObj.bottomArray.length == 1)?'100%':'20%';
																												if( botObj.bottomArray.length == 2 && middleDataValArray.length == 2)
																												sparkWidth = "50%";

																												for( var s=0; s < botObj.bottomArray.length; s++ )
																												{
																													var tmpGrpData = botObj.bottomArray[s];
																													if(tmpGrpData!=null && tmpGrpData!=undefined)
																													{
																														if(tmpGrpData.graphData!=null && tmpGrpData.graphData!=undefined && tmpGrpData.graphData.length>0)
																														{
																															if(tmpGrpData.graphData[0].DataSet!=null && tmpGrpData.graphData[0].DataSet!=undefined && tmpGrpData.graphData[0].DataSet.length>0)
																															{
																																var sparkGrpData = tmpGrpData.graphData[0].DataSet[0].sparkdata;
																																if(sparkGrpData!=null && sparkGrpData!=undefined)
																																{
																																	var sparkToolTip = tmpGrpData.graphToolTip;
																																	if(sparkToolTip==null || sparkGrpData==undefined)
																																		sparkToolTip="";

																																	botObj.add({
																																		xtype:'component',
																																		name:'bottomPanel',
																																		id:'bottom_'+siteItemNo+'_'+mditem+"_"+vitem+"_"+s,
																																		html:conBottomDiv,
																																		//hidden:flag,
																																		hidden:false,
																																		collapsible: true,
																																		align:'center',
																																		gValue:sparkGrpData,
																																		gTip:sparkToolTip,
																																		width:sparkWidth,
																																		margin:'7 10 0 5',
																																		layout:{type:'fit'},
																																		style:{'border':'0px solid violet','text-align':'center !important'},
																																		listeners:{
																																			'afterrender': function(grpObj){
																																				if(grpObj.gValue.length > 0)
																																				{
																																					jQuery("#"+grpObj.id).sparkline(grpObj.gValue, {
																																						type: 'line',
																																						width: '80',
																																						lineColor: '#3e6abb',
																																						fillColor: '#3e6abb',
																																						spotColor: '',
																																						minSpotColor: '#d5870b',
																																						spotRadius: 0,
																																						height:'20',
																																						lineWidth:1.5,
																																						highlightSpotColor:'#d5870b',
																																						highlightLineColor:'#eed10f',
																																						//disableTooltips:false,
																																						//disableInteraction:false,
																																						//tooltipClassname:'rumTooltip',
																																						drawNormalOnTop: false,
																																						tooltipClassname:'jqstooltip',
																																						tooltipFormat:jQuery.spformat('{{y}} '+grpObj.gTip, 'tooltip-class')
																																					});
																																				}
																																				else
																																				{
																																					grpObj.update(errorMsg);
																																				}
																																			}
																																		}
																																	});
																																}
																															}
																														}
																													}
																												}
																											}
																										}
																									}
		
																								}
																								/**/	
																								
																							]
																						};
																						
																						thisObj.add(newPanel);
																						if (vitem != sitePanelArray.length-1)
																						{
																							thisObj.add(separator);
																						}
																					}
																				}
																			}
																		}
																		else
																		{
																			//var errorMsg='<center><img style="margin:4% 0 auto 0" src="/final/images/spacer.gif" class="iconAlert"/>&nbsp;&nbsp;<span class="rumGraphErrorMsgText">Agent/Controller - Not Responding</span></center>';

																			var errorMsg='<table align="center" style="margin:4% auto"><tr><td ><img style="margin-top:0px" src="/final/images/spacer.gif" class="iconAlert"/></td><td>&nbsp;<span class="rumGraphErrorMsgText">Agent/Collector - Not Responding</span></td><tr></table>';

																			thisObj.setTitle(noLinkTitleVal);
																			var err ={
																						xtype:'container',
																						columnWidth:1.0,
																						flex:1,
																						html:errorMsg
																					};
																			thisObj.add(err);
																		}
																	}
																}
															}
															else
															{
																var errorMsg='<center><div style="margin:2% 0 auto 0"><div class="iconInformation" ></div><div class="commonErrorMsgText">No Traffic Detected</div></div></center>';
																thisObj.setTitle(noLinkTitleVal);
																var err ={
																			xtype:'container',
																			columnWidth:1.0,
																			flex:1,
																			html:errorMsg
																		};
																thisObj.add(err);
															}
														}
													}
												}
											});
										}
									}
								};
								
								if(!isRedirect)
								{
									me.getMain().add(site);
								}

								if(selectedName!=null && selectedName!=undefined && siteItemJson.siteName!=null && siteItemJson.siteName!=undefined && selectedName==siteItemJson.siteName)
								{
									me.getMain().add(site);
									goToTabsetPage('site_'+item,false);
									break;
								}

								if( selDrilldown && selCompName!=null && selCompName!=undefined && siteItemJson.siteName!=null && siteItemJson.siteName!=undefined && selCompName==siteItemJson.siteName)
								{
									me.getMain().add(site);
									goToTabsetPage('site_'+item,false);
									break;
								}
							}
							if(!Ext.isEmpty(layersSiteId) && layersSiteId!=null && layersSiteId!=undefined)
								goToTabsetPage(layersSiteId,false);
						}
					}

					var backButton = Ext.getCmp('backButton');

					if ( !Ext.isEmpty( backButton) && (!selDrilldown) )
					{
						backButton.hide();
					}
					if( (!Ext.isEmpty(fromLayersToDashboard) && fromLayersToDashboard!=null && fromLayersToDashboard!=undefined && fromLayersToDashboard ) && (!Ext.isEmpty(layersSiteId) && layersSiteId!=null && layersSiteId!=undefined) )
					{
						backButton.show();
						fromLayersFlag = true;
					}
					if ($('#rumAutoScroll-body')[0] != undefined &&  $('#rumAutoScroll-body')[0].scrollHeight > $('#rumAutoScroll-body').innerHeight())
					{
						Ext.Element.select('.removeLineForTvMode').show();
						//Ext.getCmp('iconAutomaticScrollRun').show();
						//Ext.getCmp('iconAutomaticScrollJumpToTop').show();
					}
					else
					{
						Ext.getCmp('iconAutomaticScrollRun').hide();
						Ext.Element.select('.removeLineForTvMode').hide();
						Ext.getCmp('iconAutomaticScrollJumpToTop').hide();
					}
					var tvModeBackButton = Ext.getCmp('backButton');
					if(isTvMode)
					{
						tvModeBackButton.hide();
					}
				}
			}
		});
	},
	refreshJsonDataAlone:function(){
		
		var tvModeBackButton = Ext.getCmp('backButton');
		if(isTvMode)
		{
			tvModeBackButton.hide();
		}
		if(!Ext.isEmpty(this.getRumOverviewTab()))
		{
			var tabpanelObj=this.getRumTabPanel();
			var totalPanels = 0;
			totalPanels=tabpanelObj.mPCnt.panelCount;
			var allPanelUrl = "/final/servlet/com.eg.RUMController?comp="+encodeURI(tabpanelObj.siteName)+"&genericPanel=yes&tabName=rumOverview&panelRegion=middle,bottom&totalMiddlePanels="+totalPanels+"&accessType=genericPanel&rumRefreshFlag=true&totalBottomPanels="+tabpanelObj.bPCnt.panelCount+"&fromService="+fromSerFlag;
			var header_url = '/final/servlet/com.eg.RUMController?site='+encodeURI(tabpanelObj.siteName)+'&accessType=allAccessType';
			var mapUrl = '/final/servlet/com.eg.RUMController?accessType=overviewMap&site='+encodeURI(tabpanelObj.siteName)+'&tabName=rumOverview&fromService='+fromSerFlag;

			var countCheck = new Array();
			
			dataObject = new Array();

			Ext.Ajax.request({
				url:allPanelUrl,
				timeout:300000,
				success:function(response)
				{
					var jsonText1 = response.responseText;
					var Obj1  = new Object();
					Obj1.name='GRAPH';
					Obj1.value= Ext.decode(jsonText1);
					dataObject.push(Obj1);
					dataCheck();
					Ext.Ajax.request({
						url:header_url,
						timeout:300000,
						success:function(response)
						{
							var jsonText2 = response.responseText;
							var Obj2  = new Object();
							Obj2.name='HEADER';
							Obj2.value= Ext.decode(jsonText2);
							dataObject.push(Obj2);
							dataCheck();
						},
						faliure:function(){
							var Obj2  = new Object();
							Obj2.name='HEADER';
							Obj2.value= null;
							dataObject.push(Obj2);
							dataCheck();
						}
					});

					Ext.Ajax.request({
						url:mapUrl,
						timeout:300000,
						success:function(response)
						{
							var jsonText3 = response.responseText;
							var Obj3  = new Object();
							Obj3.name='MAP';
							Obj3.value= Ext.decode(jsonText3);
							dataObject.push(Obj3);
							dataCheck();
						},
						faliure:function(){
							var Obj3  = new Object();
							Obj3.name='MAP';
							Obj3.value= null;
							dataObject.push(Obj3);
							dataCheck();
						}
					});

					//refreshJsonData();

				},
				faliure:function(){
					var Obj1  = new Object();
					Obj1.name='GRAPH';
					Obj1.value= null;
					dataObject.push(Obj1);
					dataCheck();
					//refreshJsonData();
				}
			});
		}
	},
	/*Reloads all the Pages*/
	refresh:function()
	{
		if(isTvMode)
		{
			var tvModeBackButton = Ext.getCmp('backButton');
			tvModeBackButton.hide();
		}
					
		if(!Ext.isEmpty(this.getRumOverviewTab()))
		{
			if(this.getRumTabPanel().getActiveTab().id=='rumOverviewId')
			{
				var rumOverviewTabObj = this.getRumOverviewTab();

				topPoc=Ext.get(this.getRumTabPanel().id+'-body').getScroll().top;
				this.goToTabsetPage(this.getRumTabPanel().siteId,true);
			}
			else if(this.getRumTabPanel().getActiveTab().id=='rumGeoId')
			{
				var refurl = "/final/servlet/com.eg.RUMController?getComponents=yes&accessData=allAccessType&fromService="+fromSerFlag;
				var me = this;
				var tabpanelObj=this.getRumTabPanel();
				Ext.Ajax.request({
					url:refurl,
					timeout:300000,
					success:function(response)
					{
						var jsonText = response.responseText;
						var inner_flage=false;
						if (!Ext.isEmpty( jsonText))
						{
							var jsonData = Ext.decode(jsonText);
							if (!Ext.isEmpty( jsonData))
							{
								if (!Ext.isEmpty( jsonData.sitesArray ))
								{
									var sitesJsonArray=jsonData.sitesArray;
									for(var item=0; item<sitesJsonArray.length; item++)
									{
										var siteItemJson=sitesJsonArray[item];
										if(tabpanelObj.siteName==siteItemJson.siteName)
										{
											var gmapView=tabpanelObj.view;
											if(gmapView!=null && gmapView!=undefined && (gmapView=="" || gmapView.indexOf('Country')>-1))
											{
												me.updateGeoDashboard(tabpanelObj,true);
											}
											inner_flage = true;
											break;
										}
									}
								}
							}
						}

						if(!inner_flage)
						{
							me.goToTabsetPage(tabpanelObj.siteId,true);
						}
					},
					failure:function(){
						me.goToTabsetPage(tabpanelObj.siteId,true);
					}
				});
			}
			else if(this.getRumTabPanel().getActiveTab().id=='rumPagesAjaxId')
			{
				var refurl = "/final/servlet/com.eg.RUMController?getComponents=yes&accessData=allAccessType&fromService="+fromSerFlag;
				var me = this;
				var tabpanelObj=this.getRumTabPanel();
				Ext.Ajax.request({
					url:refurl,
					timeout:300000,
					success:function(response)
					{
						var jsonText = response.responseText;
						var inner_flage=false;
						if (!Ext.isEmpty( jsonText))
						{
							var jsonData = Ext.decode(jsonText);
							if (!Ext.isEmpty( jsonData))
							{
								if (!Ext.isEmpty( jsonData.sitesArray ))
								{
									var sitesJsonArray=jsonData.sitesArray;
									for(var item=0; item<sitesJsonArray.length; item++)
									{
										var siteItemJson=sitesJsonArray[item];
										if(tabpanelObj.siteName==siteItemJson.siteName)
										{
											var filterByObj = Ext.getCmp("filterby");
											var paBackObj = Ext.getCmp("paBack");

											if (!Ext.isEmpty(filterByObj) && filterByObj!=undefined && filterByObj.isVisible() && !Ext.isEmpty(paBackObj) && paBackObj!=undefined && !paBackObj.isVisible())
											{
												me.updatePagesAndAjax(tabpanelObj,filterByObj.getValue());
											}
											else if (!Ext.isEmpty(filterByObj) && filterByObj!=undefined && filterByObj.isVisible() && !Ext.isEmpty(paBackObj) && paBackObj!=undefined && paBackObj.isVisible())
											{
												var ddUrlVal = me.getPagesAndAjax().currUrl;
												me.updatePagesAndAjaxDD(ddUrlVal,filterByObj.getValue());
											}
											/*else
											{
												me.updatePagesAndAjax(tabpanelObj);
											}*/

											inner_flage = true;
											break;
										}
									}
								}
							}
						}

						if(!inner_flage)
						{
							me.goToTabsetPage(tabpanelObj.siteId,true);
						}
					},
					failure:function(){
						me.goToTabsetPage(tabpanelObj.siteId,true);
					}
				});
			}
			else if(this.getRumTabPanel().getActiveTab().id=='rumBD')
			{
				var refurl = "/final/servlet/com.eg.RUMController?getComponents=yes&accessData=allAccessType&fromService="+fromSerFlag;
				var me = this;
				var tabpanelObj=this.getRumTabPanel();
				Ext.Ajax.request({
					url:refurl,
					timeout:300000,
					success:function(response)
					{
						var jsonText = response.responseText;
						var inner_flage=false;
						if (!Ext.isEmpty( jsonText))
						{
							var jsonData = Ext.decode(jsonText);
							if (!Ext.isEmpty( jsonData))
							{
								if (!Ext.isEmpty( jsonData.sitesArray ))
								{
									var sitesJsonArray=jsonData.sitesArray;
									for(var item=0; item<sitesJsonArray.length; item++)
									{
										var siteItemJson=sitesJsonArray[item];
										if(tabpanelObj.siteName==siteItemJson.siteName)
										{
											var filterByObj = Ext.getCmp("BDCombo");
											var filterByObj2 = Ext.get("BDCombo");
											//var filterByObj23 = Ext.componentQuery.query("BDCombo");
											if ( !Ext.isEmpty(filterByObj) && filterByObj!=undefined && filterByObj.isVisible() )
											{
												me.devicePanelUpdate(tabpanelObj.siteName,filterByObj.getValue(),true);
												//me.getPanelList(tabpanelObj);
											}

											
											inner_flage = true;
											break;
										}
									}
								}
							}
						}

						if(!inner_flage)
						{
							me.goToTabsetPage(tabpanelObj.siteId,true);
						}
					},
					failure:function(){
						me.goToTabsetPage(tabpanelObj.siteId,true);
					}
				});
			}
		}
		else
		{
			this.mainFormRender();
		}
	},
	/*Handles the Back Action*/
	handlingBack:function()
	{
		if( (selDrilldown!=null && selDrilldown!=undefined && selDrilldown!=''&& selDrilldown) || (fromLayersToDashboard && fromLayersFlag) )
		{
			window.location.href="/final/monitor/realUserMonitorsDashboard.jsp?";
		}
		else
		{
			this.mainFormRender(this.getMain());
		}

		/*if(backUI=='homePage')
		{
			this.mainFormRender(this.getMain());
		}
		else if(backUI=='separateSite')
		{
			url = '/final/servlet/com.eg.RUMController?site='+singleSite+'&accessType=particularAccessType';
			this.mainFormRender(url);
			backUI = 'homePage';
		}
		else if(backUI=='groupedRequest')
		{
			var selectedComboValue = "";
			url = backUrl;
			var splitURL = url.split("&");
			for(var i=0;i<splitURL.length;i++)
			{
				var splitValue = splitURL[i];
				if(!Ext.isEmpty(splitValue))
				{
					if(splitValue.indexOf('groupRequestType') > -1)
					{
						selectedComboValue = splitValue.substring(splitValue.indexOf("=")+1,splitValue.length);
					}
				}
			}
			this.groupedRequest(selectedComboValue);
			backUI='separateSite'
		}*/
	},
	devicePanelUpdate:function(currentSite, selectedOpt,comboChanged){
		var me = this;
		var rumDeviceNames = [];
	
		var rumPieContent = this.getRumBDPanel();
		if (!Ext.isEmpty( rumPieContent))
		{
			var resultItems=rumPieContent.items.items;
			for(var item=resultItems.length-1; item>-1 ; item--)
			{
				resultItems[item].destroy();
			}
		}
		var RumGraphObj = this.getRumDeviceGraph();
		if (!Ext.isEmpty( RumGraphObj))
		{
			var resultItems=RumGraphObj.items.items;
			for(var item=resultItems.length-1; item>-1 ; item--)
			{
				resultItems[item].destroy();
			}
		}
		var panelU = "/final/servlet/com.eg.RUMController?site="+encodeURI(currentSite)+"&accessType=tabInfo&tabName=rumBD&selectedOpt="+selectedOpt;
		Ext.Ajax.request({
			url:panelU,
			async: false,
			timeout:300000,
			success:function(response){
				var resText = response.responseText;
				var respData = Ext.decode(resText);
				var devices = respData.devices;
				rumDeviceNames = respData.devices;
				var deviceNames = '';
				for(var a=0;a< devices.length; a++ )
				{
					if( a > 0 )deviceNames = deviceNames+",";
					
					deviceNames = deviceNames+devices[a];
				}
				deviceNames = deviceNames.trim();
				var graphSubPanel = me.getRumDeviceGraph();
				if(rumDeviceNames.length > 0)
				{
					for(var a=0;a< rumDeviceNames.length; a++ )
					{
						var tempVar = {
							xtype:'panel',
							id:'devicePanel'+a,
							cls:'rumDatapanel',
							title:rumDeviceNames[a],
							height:200,
							columnWidth:1,
							layout:'column',
							style:{'border':'0px solid red'},
							items:[]
						};
						graphSubPanel.add(tempVar);
						var panelUrl = "/final/servlet/com.eg.RUMController?&getPanels=yes&tabName=rumBD&selectedOpt="+selectedOpt;
						Ext.Ajax.request({
							url:panelUrl,
							async: false,
							timeout:300000,
							success:function(response){
								var resText = response.responseText;
								var respData = Ext.decode(resText);
								var toDelete = ( a > 0 )?true:false;
								toDelete = ( comboChanged )?false:true;
								var tabInfo = rumDeviceNames[a];
								var outerPanelId = a;
								me.createDBPanels(currentSite,respData,selectedOpt,"rumBD",toDelete,tabInfo,outerPanelId);
								//me.createDBPanels(currentSite,Object.keys(respData).length,selectedOpt);
							}
						});
					}
				}
				else
				{
					//me.getRumBDGrid().setTitle("Performance by "+selectedOpt+'s');
					var gridUrl = "/final/servlet/com.eg.RUMController?site="+encodeURI(currentSite)+"&accessType=browserDD&selectedOpt="+selectedOpt+":DD:Test&tabName=rumBD";
					Ext.Ajax.request({
						url:gridUrl,
							async: true,
						timeout:300000,
						success:function(response)
						{
							var jsonText = response.responseText;
							if (!Ext.isEmpty( jsonText))
							{
								var jsonData = Ext.decode(jsonText);
								if( !Ext.isEmpty(jsonData) )
								{
									var ddResultArray = jsonData.ArrayData;
									var ddResult = ddResultArray[0];
									me.getRumBDGrid().setTitle("Performance by "+selectedOpt+'s');
									var dbGridStore = Ext.create('Ext.data.Store',{
									fields:ddResult.fields,
									data:ddResult.data});
									me.getRumBDGrid().reconfigure(dbGridStore,ddResult.columns);
								}
								
							}
						}
					});

				}
				var sitePanel = me.getRumBDPanel();
				var graphId = selectedOpt+'c';
				sitePanel.add({
					xtype:'panel',
					cls:'rumDatapanel',
					id:graphId,
					name:'panelGraph',
					style:{'border':'0px solid red'},
					//width:300,
					height:240,
					//gValue:gDataVal,
					listeners:{
						'afterrender': function(thisObj){
							//var piePanelBody = Ext.get(me.getLocationInfo().getComponent(dataBlock[1]).body.id);
							var pieId = thisObj.body.id;
							var pieUrl = "/final/servlet/com.eg.RUMController?site="+encodeURI(currentSite)+"&accessType=PieChart&selectedOpt="+selectedOpt+"&tabName=rumBD";
							//var piePanelBody = Ext.get(me.getLocationInfo().getComponent(dataBlock[1]).body.id);
							Ext.Ajax.request({
								url:pieUrl,
								async: true,
								timeout:300000,
								success:function(response)
								{
									var jsonText = response.responseText;
									var jsonData = Ext.decode(jsonText);
									thisObj.setTitle(jsonData.pieTitle);
									me.createRumPieHighchart(pieId,200,290,jsonData.pieChart);
								}
							});
						}
					}
				});
			}
		});
	},
	BDCombo_onchange:function(obj){
		var selectedOpt = obj.getValue();
		var me = this;
		if(selectedOpt!=null)
		{
			var comboChanged = isChanged;

			if( selectedOpt == "Device" )
			{
				var rumPieContent = this.getRumBDPanel();
				if (!Ext.isEmpty( rumPieContent))
				{
					var resultItems=rumPieContent.items.items;
					for(var item=resultItems.length-1; item>-1 ; item--)
					{
						resultItems[item].destroy();
					}
				}
				var RumGraphObj = this.getRumDeviceGraph();
				if (!Ext.isEmpty( RumGraphObj))
				{
					var resultItems=RumGraphObj.items.items;
					for(var item=resultItems.length-1; item>-1 ; item--)
					{
						resultItems[item].destroy();
					}
				}
				me.devicePanelUpdate(currentSite, selectedOpt, comboChanged);
				/*var rumDeviceNames = [];
				var panelU = "/final/servlet/com.eg.RUMController?site="+encodeURI(currentSite)+"&accessType=tabInfo&tabName=rumBD&selectedOpt="+selectedOpt;
				Ext.Ajax.request({
					url:panelU,
					async: false,
					success:function(response){
						var resText = response.responseText;
						var respData = Ext.decode(resText);
						var devices = respData.devices;
						rumDeviceNames = respData.devices;
						var deviceNames = '';
						for(var a=0;a< devices.length; a++ )
						{
							if( a > 0 )deviceNames = deviceNames+",";
							
							deviceNames = deviceNames+devices[a];
						}
						deviceNames = deviceNames.trim();
						var graphSubPanel = me.getRumDeviceGraph();
						
						for(var a=0;a< rumDeviceNames.length; a++ )
						{
							var tempVar = {
								xtype:'panel',
								id:'devicePanel'+a,
								cls:'rumDatapanel',
								title:rumDeviceNames[a],
								height:200,
								columnWidth:1,
								layout:'column',
								style:{'border':'2px solid red'},
								items:[]
							};
							graphSubPanel.add(tempVar);
							var panelUrl = "/final/servlet/com.eg.RUMController?&getPanels=yes&tabName=rumBD&selectedOpt="+selectedOpt;
							Ext.Ajax.request({
								url:panelUrl,
								async: false,
								success:function(response){
									var resText = response.responseText;
									var respData = Ext.decode(resText);
									var toDelete = ( a > 0 )?true:false;
									toDelete = ( comboChanged )?false:true;
									var tabInfo = rumDeviceNames[a];
									var outerPanelId = a;
									me.createDBPanels(currentSite,respData,selectedOpt,"rumBD",toDelete,tabInfo,outerPanelId);
									//me.createDBPanels(currentSite,Object.keys(respData).length,selectedOpt);
								}
							});
						}

						var sitePanel = me.getRumBDPanel();
						var graphId = selectedOpt+'c';
						sitePanel.add({
							xtype:'panel',
							cls:'rumDatapanel',
							id:graphId,
							name:'panelGraph',
							style:{'border':'4px solid red'},
							//width:300,
							height:240,
							//gValue:gDataVal,
							listeners:{
								'afterrender': function(thisObj){
									//var piePanelBody = Ext.get(me.getLocationInfo().getComponent(dataBlock[1]).body.id);
									var pieId = thisObj.body.id;
									var pieUrl = "/final/servlet/com.eg.RUMController?site="+encodeURI(currentSite)+"&accessType=PieChart&selectedOpt="+selectedOpt+"&tabName=rumBD";
									//var piePanelBody = Ext.get(me.getLocationInfo().getComponent(dataBlock[1]).body.id);
									Ext.Ajax.request({
										url:pieUrl,
										async: true,
										success:function(response)
										{
											var jsonText = response.responseText;
											var jsonData = Ext.decode(jsonText);
											thisObj.setTitle(jsonData.pieTitle);
											me.createRumPieHighchart(pieId,200,290,jsonData.pieChart);
										}
									});
								}
							}
						});*/

						/*for(var a=0;a< devices.length; a++ )
						{
							var panelUrl = "/final/servlet/com.eg.RUMController?&getPanels=yes&tabName=rumBD&selectedOpt="+selectedOpt;
							Ext.Ajax.request({
								url:panelUrl,
								async: false,
								success:function(response){
									var resText = response.responseText;
									var respData = Ext.decode(resText);
									var toDelete = ( a > 0 )?true:false;
									toDelete = ( comboChanged )?false:true;
									var tabInfo = devices[a];
									me.createDBPanels(currentSite,respData,selectedOpt,"rumBD",toDelete,tabInfo);
									//me.createDBPanels(currentSite,Object.keys(respData).length,selectedOpt);
								}
							});
						}*/
						//me.createDBPanels(currentSite,respData,selectedOpt,"rumBD");
						//me.createDBPanels(currentSite,Object.keys(respData).length,selectedOpt);
					/*}
				});*/
			}
			else
			{
				var panelUrl = "/final/servlet/com.eg.RUMController?&getPanels=yes&tabName=rumBD&selectedOpt="+selectedOpt;
				Ext.Ajax.request({
					url:panelUrl,
					timeout:300000,
					success:function(response){
						var resText = response.responseText;
						var respData = Ext.decode(resText);
						me.createDBPanels(currentSite,respData,selectedOpt,"rumBD",false,'','');

						//me.createDBPanels(currentSite,Object.keys(respData).length,selectedOpt);
					}
				});
			}

			
		}
		isChanged = true;
	},
	getPanelList:function(tabpanel,comboVal,refresh){
		var me = this;
		var respData = 1;
		comboVal = (Ext.isEmpty( comboVal ))?'Browser':comboVal;
		var panelUrl = "/final/servlet/com.eg.RUMController?site="+encodeURI(tabpanel.siteName)+"&getPanels=yes&tabName="+tabpanel.activeTab.id+"&selectedOpt="+comboVal;
		Ext.Ajax.request({
			url:panelUrl,
			timeout:300000,
			success:function(response){
				var resText = response.responseText;
				var rrespData = Ext.decode(resText);
				respData = Object.keys(rrespData).length;
				me.createDBPanels(tabpanel.siteName,rrespData,comboVal,tabpanel.activeTab.id,false,'');
			}
		});
		return respData;
	},
	createDBPanels:function(siteName,presData,selectedVal,tabName,isrepeat,device,outerPanelId){
		var sitePanel = this.getRumBDPanel();
		if( !Ext.isEmpty( presData ) )
		{
			
			if(!isrepeat)
			{
				/*if (!Ext.isEmpty( RumMapObj))
				{
					var resultItems=RumMapObj.items.items;
					for(var item=resultItems.length-1; item>-1 ; item--)
					{
						resultItems[item].destroy();
					}
				}*/
				
				/*var RumGraphObj = this.getRumDeviceGraph();
				if (!Ext.isEmpty( RumGraphObj))
				{
					var resultItems=RumGraphObj.items.items;
					for(var item=resultItems.length-1; item>-1 ; item--)
					{
						resultItems[item].destroy();
					}
				}*/
			}
			if( selectedVal.indexOf("Device") > -1 )
				this.getRumDeviceGraph().show();
			else
			{
				if(!isrepeat)
				{
					var DeviceObj = this.getRumBDPanel();
					if (!Ext.isEmpty( DeviceObj))
					{
						var resultItems=DeviceObj.items.items;
						for(var item=resultItems.length-1; item>-1 ; item--)
						{
							resultItems[item].destroy();
						}
					}
				}
				this.getRumDeviceGraph().hide();
			}
		
			var graphSubPanel = this.getRumDeviceGraph();
			currentSite = siteName;
			var no = Object.keys(presData).length;
			var me = this;
			var c = 1;
			var d=0;
			var tempSubPanels = graphSubPanel.items.items;
			var devicesPanel = tempSubPanels[outerPanelId];
			var titleStr = selectedVal;
			if( !Ext.isEmpty(presData) )
			{
				for (key in presData) {
				
					if (presData.hasOwnProperty(key)) {
						var jsonChartType =  presData[key];
						if( ( key.indexOf(":") == -1 ) && jsonChartType.indexOf("Pie") > -1 )
						{
							if( selectedVal.indexOf("Browser") > -1 )
							{
								var graphId = selectedVal+c;
								sitePanel.add({
									xtype:'panel',
									id:graphId,
									//cls:'rumDatapanel',
									title:'',
									name:'panelGraph',
									style:{'border':'0px solid blue'},
									width:'100%',
									height:240,
									padding:'23 0 0 0',
									//height:sitePanel.height-20,
									//gValue:gDataVal,
									listeners:{
										'afterrender': function(thisObj){
											var pieUrl = "/final/servlet/com.eg.RUMController?site="+encodeURI(currentSite)+"&accessType=PieChart&selectedOpt="+selectedVal+"&tabName="+tabName;
											//var piePanelBody = Ext.get(me.getLocationInfo().getComponent(dataBlock[1]).body.id);
											var pieId = thisObj.id;
											Ext.Ajax.request({
												url:pieUrl,
												async: false,
												timeout:300000,
												success:function(response)
												{
													var jsonText = response.responseText;
													var jsonData = Ext.decode(jsonText);
													titleStr = ( Ext.isEmpty( jsonData.pieTitle ) )?selectedVal:jsonData.pieTitle;
													thisObj.setTitle(titleStr);
													me.createRumPieHighchart(pieId,200,320,jsonData.pieChart);
												}
											});
										}
									}
								});
								
							}

						}
						else if( key.indexOf(":DD") == -1 )
						{
							var accType = ( jsonChartType.indexOf("Pie") > -1 )?"PieChart":"lineChart";
							var isAreaChart = ( jsonChartType.indexOf("Area") > -1 || jsonChartType.indexOf("area") > -1 )?"true":"false";
							//var graphId = selectedVal+c;
							var graphId = selectedVal+inc;
							inc = inc+1;
							//var graphPanel = {xtype:'panel',title:'Graph Title',height:50};
							//graphSubPanel.add(graphPanel);
							
							devicesPanel.add({
								xtype:'panel',
								id:graphId,
								cls:'rumDatapanelWithoutHeader',
								style:{'border':'0px solid violet'},
								columnWidth:0.33,
								height:200,
								title:'',
								//gValue:gDataVal,
								listeners:{
									'afterrender': function(thisObj){
										var pieUrl = "/final/servlet/com.eg.RUMController?site="+encodeURI(siteName)+"&accessType="+accType+"&selectedOpt="+key+"&tabName="+tabName+"&info="+device;
										//var piePanelBody = Ext.get(me.getLocationInfo().getComponent(dataBlock[1]).body.id);
										var pieId = thisObj.id;
										Ext.Ajax.request({
											url:pieUrl,
											async: false,
											timeout:300000,
											success:function(response)
											{
												var jsonText = response.responseText;
												var jsonData = Ext.decode(jsonText);
												
												if( accType == 'PieChart')
												{
													thisObj.setTitle(jsonData.pieTitle);
													var pieWidth = Ext.getBody().getViewSize().width/3;
													me.createRumPieHighchart(pieId,160,pieWidth,jsonData.pieChart);
												}
												else
												{
													var urlList = jsonData.urls;
													if( !Ext.isEmpty(urlList) )
													{
														var chartUrl = urlList[0];
														chartUrl = chartUrl+"&rumSub=RUM_BROWSER_DEVICES&rumVar="+key+"&isAreaChart="+isAreaChart;
														Ext.Ajax.request({
															url:chartUrl,
															async: false,
															timeout:300000,
															success:function(response)
															{
																var jsonText = response.responseText;
																if (!Ext.isEmpty( jsonText) && jsonText.indexOf("<HTML") == -1 )
																{
																	var chartJsonData = Ext.decode(jsonText);
																	thisObj.setTitle(chartJsonData.title);
																	//currObj.setTitle(dispTitle);
																	var timeWidth = Ext.getBody().getViewSize().width/3;
																	me.createRumTimelineHighchart(graphId,160,timeWidth-50,chartJsonData,'',false);
																}
																else
																	thisObj.update(errMsg);
																	thisObj.setHeight(331);
															}
														});
													}
												}
											}
										});
									}
								}
							});
							devicesPanel.add({xtype:'tbseparator'});
						}
						else if( key.indexOf("DD:Test") > -1 )
						{
							var gridUrl = "/final/servlet/com.eg.RUMController?site="+encodeURI(siteName)+"&accessType=browserDD&selectedOpt="+key+"&tabName="+tabName;
							Ext.Ajax.request({
								url:gridUrl,
								timeout:300000,
								success:function(response)
								{
									var jsonText = response.responseText;
									if (!Ext.isEmpty( jsonText))
									{
										var jsonData = Ext.decode(jsonText);
										if( !Ext.isEmpty(jsonData) )
										{
											var ddResultArray = jsonData.ArrayData;
											var ddResult = ddResultArray[0];
											me.getRumBDGrid().setTitle("Performance by "+selectedVal+'s');
											var dbGridStore = Ext.create('Ext.data.Store',{
											fields:ddResult.fields,
											data:ddResult.data});
											me.getRumBDGrid().reconfigure(dbGridStore,ddResult.columns);
										}
										
									}
								}
							});
						}
						c = c+1;
					}
				}
			}
			else
			{
				me.getRumBDGrid().setTitle("Performance by "+selectedVal+'s');
			}
		}
	},
	updateBADTab:function(tabpanel,isUpdateMap){
		this.getPanelList(tabpanel,"Browser",false);
	},
	updateGeoDashboard:function(tabpanel,isUpdateMap){
		var me = this;
		if(isUpdateMap)
		{
			var RumMapObj = this.getRummap();
			if (!Ext.isEmpty( RumMapObj))
			{
				var resultItems=RumMapObj.items.items;
				for(var item=resultItems.length-1; item>-1 ; item--)
				{
					resultItems[item].destroy();
				}
				RumMapObj.add(this.getSiteMapDetail(tabpanel,"true",null));
			}
		}
		var view=tabpanel.view;
		var in_info="";
		var in_gridinfo="";
		var gview="";
		var gcountry=tabpanel.country;
		if(gcountry==null || gcountry==undefined || gcountry=="")
		{
			gcountry = "";
		}

		var gregion=tabpanel.region;
		if(gregion==null || gregion==undefined || gregion=="")
		{
			gregion = "";
		}
		if(view==null || view==undefined || view=="" || view=="Country" || view.indexOf("Country")>-1)
		{
			gcountry="";
			gregion="";
			gview="Country";
			in_gridinfo="Country:%";
		}
		else if(view!=null && view!=undefined && view.indexOf("Region:")>-1)
		{
			gview="Region";
			if(gcountry!=null && gcountry!="")
			{
				in_gridinfo=gview+":%("+gcountry+")";
				in_info="Country:"+gcountry;
			}
		}
		else if(view!=null && view!=undefined && view.indexOf("City:")>-1)
		{
			gview="City";
			if(gcountry!=null && gcountry!="" && gregion!=null && gregion!="")
			{
				in_gridinfo=gview+":%("+gregion+"-"+gcountry+")";
				in_info="Region:"+gregion+"("+gcountry+")";
			}
		}
		var dataBlock = me.getLocationInfo().items.items;
		var gridUrl = "/final/servlet/com.eg.RUMController?site="+encodeURI(tabpanel.siteName)+"&accessType=GeoResponse&view="+gview+"&info="+encodeURI(in_gridinfo)+"&geoview="+gview;
		var gridCon = dataBlock[0];
		if (!Ext.isEmpty( gridCon))
		{
			var resultItems=gridCon.items.items;
			for(var item=resultItems.length-1; item>-1 ; item--)
			{
				resultItems[item].destroy();
			}
			gridCon.removeAll(false);
		}
		
		Ext.Ajax.request({
			url:gridUrl,
			async: false,
			timeout:300000,
			success:function(response)
			{
				var jsonText = response.responseText;
				if (!Ext.isEmpty( jsonText))
				{
					var jsonData = Ext.decode(jsonText);
					if(!Ext.isEmpty(gridCon) && !Ext.isEmpty(jsonData) && !Ext.isEmpty(jsonData.ArrayData) && jsonData.ArrayData=='NoData')
					{
						gridCon.update('<center><div class="iconInformation" style="margin:10% 0 auto 0"></div><div class="commonErrorMsgText">No Traffic Detected</div></center>');
					}
					else if(!Ext.isEmpty(jsonData) && !Ext.isEmpty(jsonData.ArrayData))
					{
						var jsonArray=jsonData.ArrayData;
						if(!Ext.isEmpty(jsonArray))
						{
							for(var a=0;a<jsonArray.length;a++)
							{
								var jsonArrayData = jsonArray[a];

								if(!Ext.isEmpty(gridCon) && !Ext.isEmpty(jsonArrayData) && !Ext.isEmpty(jsonArrayData.fields) && !Ext.isEmpty(jsonArrayData.data) && !Ext.isEmpty(jsonArrayData.columns))
								{

									Ext.define('processModel',{
										extend: 'Ext.data.Model',
										fields:jsonArrayData.fields
									});

									var processStore = Ext.create('Ext.data.Store', {
										model: 'processModel',
										autoLoad: true,
										proxy: {
											type: 'memory',
											data: jsonArrayData.data
										}
									});
									var tempGrid=Ext.create('Ext.grid.Panel', {
										title:"<span style='text-transform:none'>"+jsonArrayData.gridTitle+"</span>",
										store: processStore,
										columns: jsonArrayData.columns,
										cls:'gridSkin',
										flex:1,
										forceFit:true,
										margin:'5 5 0 0',
										//width: '100%',
										height: 145
									});

									gridCon.add(tempGrid);

								}
							}
						}
					}
				}
			}
		});

		var pieUrl = "/final/servlet/com.eg.RUMController?site="+encodeURI(tabpanel.siteName)+"&accessType=PieChart&view="+gview+"&info="+encodeURI(in_info)+"&geoview="+gview;

		var piePanelBody = Ext.get(me.getLocationInfo().getComponent(dataBlock[1]).body.id);
		var pieId = piePanelBody.id;

		var cwidth = (Ext.getBody().getViewSize().width/3) - 160;
		var cheight = Ext.getBody().getViewSize().height - 425;

		Ext.Ajax.request({
			url:pieUrl,
			timeout:300000,
			success:function(response)
			{
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				me.getLocationInfo().getComponent(dataBlock[1]).setTitle(jsonData.pieTitle);
				me.createRumPieHighchart(pieId,cheight,360,jsonData.pieChart);
			}
		});

		var mask = new Ext.LoadMask(this.getRumTimelineGraphs(), {msg:"Loading...",cls:'maskDashUpperGrid'});
		mask.show();
		
		var graphIds = [];
		var chartIds = [];
		var graphHeight = [];
		if( !Ext.isEmpty(this.getRumTimelineGraphs().items.items) )
		{
			var graphItemObj = this.getRumTimelineGraphs().items.items;
			for(var i=0;i<graphItemObj.length;i++)
			{
				graphIds[i] = graphItemObj[i].itemId;
				if( !Ext.isEmpty( this.getRumTimelineGraphs().getComponent(graphIds[i]) ) )
				{
					var chartIdObj = Ext.get(this.getRumTimelineGraphs().getComponent(graphIds[i]).body.id);
					chartIds[i] = chartIdObj.id;
					graphHeight[i] = graphItemObj[i].height;
				}
			}

			if ( !Ext.isEmpty( graphItemObj ) )
			{
				var resultItems = graphItemObj;
				for(var item=resultItems.length-1; item>-1 ; item--)
				{
					resultItems[item].destroy();
				}
			}
		}

		Ext.destroy(mask);
		var graphTimelineObj = this.getRumTimelineGraphs();
		var graphUrl = "/final/servlet/com.eg.RUMController?site="+encodeURI(tabpanel.siteName)+"&getGraphUrls=yes&view="+gview+"&info="+encodeURI(in_info)+"&geoview="+gview;
		Ext.Ajax.request({
			url:graphUrl,
			timeout:300000,
			success:function(response)
			{
				//var chartIds=[];
				var jsonText = response.responseText;
				if (!Ext.isEmpty( jsonText))
				{
					var jsonData = Ext.decode(jsonText);
					var urlList = jsonData.urls;
					for(var a=0;a<urlList.length;a++)
					{
						var chartUrl = urlList[a];
						var colWidth = 0.33;
						graphTimelineObj.add({
										cls:'rumDatapanel',
										margin:'0 5 0 0',
										id:'graphLineChart'+a,
										columnWidth:colWidth,
										curUrl:chartUrl,
										listeners:{
											'afterrender': function(currObj){
												var chartPId = currObj.body.id;
												var panId = currObj.id;
												Ext.Ajax.request({
													url:currObj.curUrl,
													async: false,
													timeout:300000,
													success:function(response)
													{
														var jsonText = response.responseText;
														if (!Ext.isEmpty( jsonText))
														{
															if(jsonText.indexOf("<HTML>") > -1 || jsonText.indexOf("png") > -1 || jsonText.indexOf("GIF") > -1 || jsonText.indexOf("gif") > -1 || jsonText.indexOf("PNG") > -1)
															{
																var chartIdObj = Ext.get(chartPId);
																if (!Ext.isEmpty( chartIdObj))
																{
																	chartIdObj.update(errMsg);
																	chartIdObj.setHeight(331);
																}
															}
															else
															{
																var jsonData = Ext.decode(jsonText);
																var panelTitle = jsonData.title;
																var meaSubStr = (panelTitle.indexOf(" -") > -1)?panelTitle.substring(0,panelTitle.indexOf(" -")):panelTitle;
																var uintSubStr = (panelTitle.indexOf("(") > -1)?panelTitle.substring(panelTitle.indexOf("(")):panelTitle;
																me.getRumTimelineGraphs().getComponent(panId).setTitle(panelTitle);
																//var cwidth = (Ext.getBody().getViewSize().width/3) - 60;
																var cwidth = (Ext.getBody().getViewSize().width/3) - 160;
																var cheight = Ext.getBody().getViewSize().height - 460;
																me.createRumTimelineHighchart(chartPId,cheight,cwidth,jsonData,'',false);
																/*var lineChart = {};
																lineChart = jQuery.extend(true, {}, getHighCharts(chartI,cheight,cwidth,''), lineChart);
																lineChart.setData(jsonData,currentDateFormat,'','','right');
																lineChart.drawChart();*/
															}
														}
													}
												});
											}
										}
						});
						//me.getChartData(chartUrl,chartIds[a],graphHeight[a],graphIds[a]);
					}
				}
			}
		});

		if(!Ext.isEmpty(mask)){
			//mask.hide();
			Ext.destroy(mask);
		}
	},
	onClickPagesAndAjaxDD:function()
	{
		if (!Ext.isEmpty(this.getPagesAndAjax()))
		{
			var tabPanel = this.getPagesAndAjax().currTabPanel;
			this.updatePagesAndAjax(tabPanel,null);
		}
	},
	onChangePagesAndAjax:function(currObj)
	{
		if (!Ext.isEmpty(this.getPagesAndAjax()) && !Ext.isEmpty(currObj))
		{
			var dataBlock = me.getPagesAndAjax().items.items;

			var commonCon=dataBlock[0].items.items;

			var filterByObj = commonCon[0];
			var filterTitleObj = commonCon[1];
			var backBut = commonCon[2];

			if (!Ext.isEmpty(filterByObj) && filterByObj.isVisible() && !Ext.isEmpty(backBut) && !backBut.isVisible())
			{
				var tabPanel = this.getPagesAndAjax().currTabPanel;
				this.updatePagesAndAjax(tabPanel,currObj.getValue());
			}
			else
			{
				var ddUrlVal = this.getPagesAndAjax().currUrl;
				this.updatePagesAndAjaxDD(ddUrlVal,currObj.getValue());
			}
		}
	},
	updatePagesAndAjax:function(tabpanel,selectedMea)
	{
		me = this;
		var dataBlock = me.getPagesAndAjax().items.items;

		//var dataBlock = me.getPagesAndAjax().getDockedItems();
		var commonCon=dataBlock[0].items.items;
		var filterByObj = commonCon[0];
		if (!Ext.isEmpty(filterByObj))
		{
			filterByObj.show();
		}
		var filterTitleObj = commonCon[1];
		if (!Ext.isEmpty(filterTitleObj))
		{
			filterTitleObj.update("");
			filterTitleObj.hide();
		}
		var backBut = commonCon[2];
		if (!Ext.isEmpty(backBut))
		{
			backBut.hide();
		}
		var gridCon = dataBlock[1];
		//var gridCon = me.getPagesAndAjax();
		if (!Ext.isEmpty(gridCon))
		{
			var resultItems=gridCon.items.items;
			for(var item=resultItems.length-1; item>-1 ; item--)
			{
				resultItems[item].destroy();
			}
			gridCon.update('');
			gridCon.removeAll(false);
		}

		me.getPagesAndAjax().currTabPanel=tabpanel;

		var gridUrl = "/final/servlet/com.eg.RUMController?site="+encodeURI(tabpanel.siteName)+"&accessType=groupedRequest";

		if (!Ext.isEmpty(selectedMea) && selectedMea!=null && selectedMea!=undefined && selectedMea!="")
		{
			gridUrl=gridUrl+"&selectedMeasures="+encodeURI(selectedMea);
		}

		var mask = new Ext.LoadMask(gridCon, {
			msg: "Loading..."
		});
		mask.show();

		Ext.Ajax.request({
			url:gridUrl,
			timeout:300000,
			success:function(response)
			{
				var jsonText = response.responseText;
				if (!Ext.isEmpty( jsonText))
				{
					var jsonData = Ext.decode(jsonText);
					if(!Ext.isEmpty(jsonData.comboArrayData) && jsonData.comboArrayData!='NoData')
					{
						var comboArrayData = jsonData.comboArrayData;
						filterByObj.getStore().loadRawData(comboArrayData);
					}
					if(!Ext.isEmpty(jsonData.comboSelected) && jsonData.comboSelected!=undefined && jsonData.comboSelected!="")
					{
						filterByObj.setValue(jsonData.comboSelected);
					}

					if(!Ext.isEmpty(gridCon) && !Ext.isEmpty(jsonData) && !Ext.isEmpty(jsonData.ArrayData) && jsonData.ArrayData=='NoData')
					{
						gridCon.update('<center><div class="iconInformation" style="margin:10% 0 auto 0"></div><div class="commonErrorMsgText">No Traffic Detected</div></center>');
					}
					else if(!Ext.isEmpty(jsonData) && !Ext.isEmpty(jsonData.ArrayData))
					{
						var jsonArray=jsonData.ArrayData;
						if(!Ext.isEmpty(jsonArray))
						{
							for(var a=0;a<jsonArray.length;a++)
							{
								var jsonArrayData = jsonArray[a];

								if(!Ext.isEmpty(gridCon) && !Ext.isEmpty(jsonArrayData) && !Ext.isEmpty(jsonArrayData.fields) && !Ext.isEmpty(jsonArrayData.data) && !Ext.isEmpty(jsonArrayData.columns))
								{

									Ext.define('processModel',{
										extend: 'Ext.data.Model',
										fields:jsonArrayData.fields
									});

									var processStore = Ext.create('Ext.data.Store', {
										model: 'processModel',
										autoLoad: true,
										proxy: {
											type: 'memory',
											data: jsonArrayData.data
										}
									});

									var tempGrid=Ext.create('Ext.grid.Panel', {
										//title:jsonArrayData.gridTitle,
										store: processStore,
										columns: jsonArrayData.columns,
										style:{'border':'0px solid blue'},
										//cls:'rumGridSkin',
										forceFit:true,
										autoScroll:true,
										scroll:true,
										//margin:'0 6 6 6',
										//width: '100%',
										height: Ext.getBody().getViewSize().height-100
									});

									gridCon.add(tempGrid);

								}
							}
						}
					}

					//mask.hide();
					Ext.destroy(mask);
				}
			}
		});
	},
	updatePagesAndAjaxDD:function(ddurl,selectedMea)
	{
		me = this;
		var dataBlock = me.getPagesAndAjax().items.items;

		me.getPagesAndAjax().currUrl=ddurl;

		var commonCon=dataBlock[0].items.items;

		var filterByObj = commonCon[0];
		if (!Ext.isEmpty(filterByObj))
		{
			filterByObj.show();
		}
		var filterTitleObj = commonCon[1];
		if (!Ext.isEmpty(filterTitleObj))
		{
			filterByObj.show();
			//filterTitleObj.update("");
		}
		var backBut = commonCon[2];
		if (!Ext.isEmpty(backBut))
		{
			backBut.show();
		}

		var gridCon = dataBlock[1];
		//var gridCon = me.getPagesAndAjax();
		if (!Ext.isEmpty(gridCon))
		{
			var resultItems=gridCon.items.items;
			for(var item=resultItems.length-1; item>-1 ; item--)
			{
				resultItems[item].destroy();
			}
			gridCon.update('');
			gridCon.removeAll(false);
		}

		var ddGridUrl = ddurl;

		if (!Ext.isEmpty(selectedMea) && selectedMea!=null && selectedMea!=undefined && selectedMea!="")
		{
			ddGridUrl=ddGridUrl+"&selectedDDMeasures="+encodeURI(selectedMea);
		}

		var mask = new Ext.LoadMask(gridCon, {
			msg: "Loading..."
		});
		mask.show();

		Ext.Ajax.request({
			url:ddGridUrl,
			timeout:300000,
			success:function(response)
			{
				var jsonText = response.responseText;
				if (!Ext.isEmpty( jsonText))
				{
					var jsonData = Ext.decode(jsonText);
					if(!Ext.isEmpty(jsonData.comboArrayData) && jsonData.comboArrayData!='NoData')
					{
						var comboArrayData = jsonData.comboArrayData;
						filterByObj.getStore().loadRawData(comboArrayData);
					}
					if(!Ext.isEmpty(jsonData.comboSelected) && jsonData.comboSelected!=undefined && jsonData.comboSelected!="")
					{
						filterByObj.setValue(jsonData.comboSelected);
					}
					if(!Ext.isEmpty(jsonData.URLTitle) && jsonData.URLTitle!=undefined && jsonData.URLTitle!="")
					{
						filterTitleObj.update(jsonData.URLTitle);
					}

					if(!Ext.isEmpty(gridCon) && !Ext.isEmpty(jsonData) && !Ext.isEmpty(jsonData.ArrayData) && jsonData.ArrayData=='NoData')
					{
						gridCon.update('<center><div class="iconInformation" style="margin:10% 0 auto 0"></div><div class="commonErrorMsgText">No Traffic Detected</div></center>');
					}
					else if(!Ext.isEmpty(jsonData) && !Ext.isEmpty(jsonData.ArrayData))
					{
						var jsonArray=jsonData.ArrayData;
						if(!Ext.isEmpty(jsonArray))
						{
							for(var a=0;a<jsonArray.length;a++)
							{
								var jsonArrayData = jsonArray[a];

								if(!Ext.isEmpty(gridCon) && !Ext.isEmpty(jsonArrayData) && !Ext.isEmpty(jsonArrayData.fields) && !Ext.isEmpty(jsonArrayData.data) && !Ext.isEmpty(jsonArrayData.columns))
								{

									Ext.define('processModel',{
										extend: 'Ext.data.Model',
										fields:jsonArrayData.fields
									});

									var processStore = Ext.create('Ext.data.Store', {
										model: 'processModel',
										autoLoad: true,
										proxy: {
											type: 'memory',
											data: jsonArrayData.data
										}
									});

									var tempGrid=Ext.create('Ext.grid.Panel', {
										//title:jsonArrayData.gridTitle,
										store: processStore,
										//defaults:{width:250},
										columns: jsonArrayData.columns,
										style:{'border':'0px solid red !important'},
										//cls:'rumGridSkin',
										//flex:1,
										width:Ext.getBody().getViewSize().width-500,
										autoScroll:true,
										//forceFit:false,
										
										viewConfig: {    
											forceFit: true,  
											//layout:'fit',
										},

										//margin:'0 6 6 6',
										//width: Ext.getBody().getViewSize().width-130,
										height: Ext.getBody().getViewSize().height-130
									});

									gridCon.add(tempGrid);

								}
							}
						}
					}

					//mask.hide();
					Ext.destroy(mask);
				}
			}
		});
	},
	showDDErrorDetails:function(erDetails)
	{
		if(!Ext.isEmpty(erDetails))
		{
			Ext.create('Ext.window.Window', {
				//title:'Error Details',
				bodyPadding:'8 8 30 8',
				resizable:false,
				draggable: true,
				padding:'5 5 32 5',
				height:'500',
				modal:true,
				items:[
					{
						xtype:'container',
						html:erDetails
					}
				],
			}).show();
		}
	},
	showDDPopup:function(url)
	{
		if(!Ext.isEmpty(url))
		{
			if(fromSerFlag != null && fromSerFlag != undefined && (fromSerFlag == 'true' || fromSerFlag== true))
				window.parent.outerWindow(url);
			else{
			Ext.create('Ext.window.Window', {
				resizable:false,
				width:'95%',
				draggable: true,
				ghost:false,
				flex:1,
				layout:{
						type:'fit',
						align:'stretch'
				},
				modal:true,
				constrain:true,
				renderTo:Ext.getBody(),
				height:'95%',
				items:[ {
								xtype: 'component',
								//minWidth : 1024,
								flex:1,
								autoEl: {
									tag: 'iframe',
									scrolling:"no",
									height:'100%',
									width:'100%',
									frameBorder:0,
									style: 'height: 100%; width: 100%; border: none;',
									src: url
								}
							}],
				listeners:
				{
					show: function(win)
					{
						if (this.modal)
						{
							var dom = Ext.dom.Query.select('.x-mask');
							
							var el = Ext.fly(dom[dom.length-1]);
							
							el.addCls('windowModal');
						}
					},
					hide: function(win)
					{
						if (this.modal)
						{
							var dom = Ext.dom.Query.select('.x-mask');
							var el = Ext.fly(dom[dom.length-1]);
							el.removeCls('windowModal');
						}
					},
					afterrender: function()
					{
						Ext.EventManager.onWindowResize(function()
						{
							var me = this;
							me.center();
						}, this);
					}
				}
			}).show();
		}
		}
	},
	rumTabPanelChange:function(tabpanel,newcard,oldcard)
	{
		me = this;
		if(newcard.id=='rumOverviewId')
		{
			me.createRumOverviewDashboard(tabpanel,false);
		}
		else if(newcard.id=='rumGeoId')
		{
			me.updateGeoDashboard(tabpanel,true);
		}
		else if(newcard.id=='rumPagesAjaxId')
		{
			me.updatePagesAndAjax(tabpanel,null);
		}
		else if(newcard.id=='rumBD')
		{
			me.updateBADTab(tabpanel);
		}
	},
	upateSecPanel:function(obj)
	{
		this.goToTabsetPage(obj,false);
	},
	createRumTimelineHighchart:function(chartId,chartHeight,chartWidth,chartDatas,maxUrl,isCombinationChart){
		if(isCombinationChart)
		{
			var combinationChart = {};
			combinationChart = jQuery.extend(true, {}, getCombinationChart(chartId,chartHeight+20,chartWidth,maxUrl), combinationChart);
			combinationChart.setData(chartDatas,currentDateFormat,'','','right');
			combinationChart.drawChart(chartDatas);
		}
		else
		{
			var rumChartType = ( Ext.isEmpty( chartDatas['rumChartType'] ) )?"line":chartDatas['rumChartType'];
			if( rumChartType == 'stackedarea' )
			{
				chartDatas['stacking']='normal';
			}
			chartDatas['isTabsetPage'] = true;
			chartDatas['rumLine'] = true;
			var lineChart = {};
			lineChart = jQuery.extend(true, {}, getHighCharts(chartId,chartHeight+40,chartWidth,maxUrl), lineChart);
			lineChart.setData(chartDatas,currentDateFormat,'',true,'right');
			lineChart.drawChart();
		}
	},
	createRumPieHighchart:function(pieId,pieHeight,pieWidth,pieData){

		if(pieData!=null && pieData!=undefined)
		{
			pieData['customMsg'] = 'yes';
			pieData['formatTip'] = 'yes';
			pieData['rumPie'] = 'yes';
			var pieChart = {};
			pieChart = jQuery.extend(true, {}, createPie(pieId,pieHeight,pieWidth), pieChart);
			pieChart.setData(pieData,'','','pie');
			pieChart.drawChart();
		}
	},
	createRumBarHighchart:function(barId,barHeight,barWidth,barData){
		barData['customMsg'] = 'yes';
		barData['formatTip'] = 'yes';
		barData['showLegend'] = false;
		var barChart = {};
		barChart = jQuery.extend(true, {}, createBar(barId,barHeight,barWidth), barChart);
		barChart.setData(barData,'','','bar');
		barChart.drawChart();
	},
	destroyPanelItems:function(parent){
		if( !Ext.isEmpty( parent.items.items ) )
		{
			var resultItems = parent.items.items;
			for( var item=resultItems.length-1; item>-1 ; item-- )
			{
				//if(resultItems[item].id!='overviewMapContainer')
				{
					if(resultItems[item].id!='overviewMapContainerExtMap')
						resultItems[item].destroy();
				}
			}
		}
	},
	createRumOverviewDashboard:function(tabpanel,refresh,flagChec){

		var me = this;
		
		var rumDash = false;
		/*if(fromDashboard != null && ( fromDashboard == true || fromDashboard == 'true' ) )
			rumDash = true;*/

		var wholeViewport = document.getElementsByTagName("body")[0];
		var mainMask = new Ext.LoadMask(wholeViewport, {
			msg: "Loading...",
			cls:'maskDash',
		});
		mainMask.show();

		var totalPanels = 0;
		var panelCountUrl = "/final/servlet/com.eg.RUMController?accessType=getPanelCount&tabName=rumOverview&panelRegion=middle";
		
		totalPanels=tabpanel.mPCnt.panelCount;

		/*var mainMask = new Ext.LoadMask(me.getMain(), {
			msg: "Loading..."
		});
		mainMask.show();*/

		var allPanelUrl = "/final/servlet/com.eg.RUMController?comp="+encodeURI(tabpanel.siteName)+"&genericPanel=yes&tabName=rumOverview&panelRegion=middle,bottom&totalMiddlePanels="+totalPanels+"&accessType=genericPanel&rumRefreshFlag="+refresh+"&totalBottomPanels="+tabpanel.bPCnt.panelCount+"&fromService="+fromSerFlag;

		siteNameGl = tabpanel.siteName;
		var rumtabpanelID=Ext.get('rumtabpanelId-body');
		var rumMainId=Ext.get('mainId')
		//alert('rumMainId-------------------'+rumMainId);
		//alert("rumtabpanelID---------"+rumtabpanelID);
		var rumBottomPanelID=Ext.getCmp("bottomPanel");
		var rumMiddlePanelID=Ext.getCmp("middlePanel");
		var rumGridDataPanelID=Ext.getCmp("rumGridData");
		//var rumDataPanelID=Ext.getCmp("rumDataPanel");

		
		//tempGrid

		/*if(window.addEventListener)
			document.addEventListener('DOMMouseScroll',moveObject, false);
		window.onmousewheel = document.onmousewheel = moveObject;*/

		flagChec = true;
		/*glTabObj=tabpanel;
		glRefresh=refresh;*/
		
		if( fromSerFlag == 'true' || fromSerFlag == true)
		{
			var rumTempGrid=Ext.getCmp("tempGrid");
			//alert("rumTempGrid----------"+rumTempGrid);
			rumtabpanelID.setStyle('overflow','hidden');
			rumtabpanelID.setStyle('border-right','0px solid #e3e3e3');
			rumtabpanelID.setStyle('padding','0px 0px 0px 0px');
			rumMainId.addCls('uxtab-outerpanel');
			var width = Ext.getBody().getViewSize().width - 40;
			var height = Ext.getBody().getViewSize().height;
			//alert('Ext.getBody().getViewSize().height-------------------------'+Ext.getBody().getViewSize().height);
			//alert("Ext.getCmp(mapIds)--------------"+Ext.getCmp("mapIds"));
			var mapPanelID=Ext.getCmp("mapIds");

			var sWidth = window.screen.availWidth;
			var sHeight = window.screen.availHeight;
			//console.log("sWidth-->",sWidth+" , sHeight-->",sHeight);
			//alert("sWidth----------------"+sWidth+"---"+sHeight);

			/*$( window ).resize(function() {
			  if (sHeight>=1500 && sHeight<=2500)
				{
					 sHeight=window.innerHeight - 700;
					//sHeight=(sHeight/2)-55;
					rumMiddlePanelID.setHeight(sHeight);
					rumBottomPanelID.setHeight(sHeight);

					//mapPanelID.setHeight(height);
					//mapPanelID.setWidth(width);
					//rumDataPanelID.setHeight(130);
					$("#map_canvas").css('margin-top','100');
				}
				else if (sHeight>=768 && sHeight<=1500 )
				{
					sHeight=height-370;
					rumMiddlePanelID.setHeight(sHeight);
					rumBottomPanelID.setHeight(sHeight);
					//rumDataPanelID.setHeight(80);
					$("#map_canvas").css('margin-top','0')
				}
			});*/

			//alert("sHeight------"+sHeight+"----window.screen.availHeight-----------"+window.screen.availHeight);
			/*if (sHeight>=1500 && sHeight<=2500)
			{
				 sHeight=window.innerHeight - 800;
				//sHeight=(sHeight/2)-55;
				rumMiddlePanelID.setHeight(sHeight);
				rumBottomPanelID.setHeight(sHeight);

				if (rumTempGrid)
				{
					sHeight=(rumBottomPanelID.getHeight()/2)-100;
					rumTempGrid.setHeight(sHeight);
				}
				//mapPanelID.setHeight(height);
				//mapPanelID.setWidth(width);
				//rumDataPanelID.setHeight(130);
				$("#map_canvas").css('margin-top','100');
			}
			else if (sHeight>=768 && sHeight<=1500 )
			{
				//alert("sHeight------"+sHeight);
				sHeight=window.screen.availHeight-470;
				rumMiddlePanelID.setHeight(sHeight);
				rumBottomPanelID.setHeight(sHeight);
				//rumDataPanelID.setHeight(80);
				$("#map_canvas").css('margin-top','0')
			}
			else if (sHeight<=768)
			{
				//alert("sHeight------"+sHeight);
				sHeight=window.screen.availHeight-310;
				//console.log("33 sHeight-->",sHeight);
				//console.log("33 rumTempGrid-->",rumTempGrid);
				rumMiddlePanelID.setHeight(sHeight);
				rumBottomPanelID.setHeight(sHeight);

				if (rumTempGrid)
				{
					sHeight=(rumBottomPanelID.getHeight()/2)-60;
					rumTempGrid.setHeight(sHeight);
				}
				//rumDataPanelID.setHeight(80);
				$("#map_canvas").css('margin-top','0')
			}*/
		}
		/*else
		{

			var rumTempGrid=Ext.getCmp("tempGrid");
			//alert("rumTempGrid----------"+rumTempGrid);
			//rumtabpanelID.setStyle('overflow','hidden');
			//rumtabpanelID.setStyle('border-right','0px solid #e3e3e3');
			//rumMainId.addCls('uxtab-outerpanel');

			var width = Ext.getBody().getViewSize().width - 40;
			var height = Ext.getBody().getViewSize().height;
			//alert('Ext.getBody().getViewSize().height-------------------------'+Ext.getBody().getViewSize().height);
			//alert("Ext.getCmp(mapIds)--------------"+Ext.getCmp("mapIds"));
			console.log("main view width-->",width+" , height-->",height);

			var sWidth = window.screen.availWidth;
			var sHeight = window.screen.availHeight;
			console.log("main view  sWidth-->",sWidth+" , sHeight-->",sHeight);

			if (sHeight>=1500 && sHeight<=2500)
			{
				 sHeight=window.innerHeight - 800;
				//sHeight=(sHeight/2)-55;
				rumMiddlePanelID.setHeight(sHeight);
				rumBottomPanelID.setHeight(sHeight);

				if (rumTempGrid)
				{
					sHeight=(rumBottomPanelID.getHeight()/2)-100;
					rumTempGrid.setHeight(sHeight);
				}
				//mapPanelID.setHeight(height);
				//mapPanelID.setWidth(width);
				//rumDataPanelID.setHeight(130);
				$("#map_canvas").css('margin-top','100');
			}
			else if (sHeight>=768 && sHeight<=1500 )
			{
				//alert("sHeight------"+sHeight);
				sHeight=window.screen.availHeight-470;
				rumMiddlePanelID.setHeight(sHeight);
				rumBottomPanelID.setHeight(sHeight);
				//rumDataPanelID.setHeight(80);
				$("#map_canvas").css('margin-top','0')
			}
			else if (sHeight<=768)
			{
				//alert("sHeight------"+sHeight);
				sHeight=window.screen.availHeight-310;
				//console.log("33 sHeight-->",sHeight);
				console.log("33 rumTempGrid-->",rumTempGrid);
				//rumMiddlePanelID.setHeight(sHeight);
				//rumBottomPanelID.setHeight(sHeight);

				if (rumTempGrid)
				{
					sHeight=(rumBottomPanelID.getHeight()/2)-60;
					rumTempGrid.setHeight(sHeight);
					console.log("---inside---");
				}
				//rumDataPanelID.setHeight(80);
				$("#map_canvas").css('margin-top','0')
			}
		}*/
		//alert("createRumOverviewDashboard refresh----------"+refresh);
		if(refresh == true || refresh == 'true')
		{
			var checkTimeToLoad = false;
			
			if(dataObject!=null && dataObject!=undefined && dataObject.length == 3)
				checkTimeToLoad = true;
			/*else{
				console.log(new Date().getTime())
				sleep(10000);
				console.log(new Date().getTime())
				
				var temp = dataObject;
				//temp.pushAll(dataObject);
				console.log("dataObject--222->",temp)
				if(temp!=null && temp!=undefined && temp.length == 3)
					checkTimeToLoad = true;
			}*/

			if(checkTimeToLoad)
			{
					var allGraphJson,headerJson,mapJson;
					if(refreshMapObject.name == 'Country'){
						var cbg = Ext.getCmp('barCheckBoxPanel').items.items[0].items.items;
						var cbgUncheck = new Array();
						for(var p=0;p<cbg.length;p++)
						{
							cbg[p].setVisible(false);
							if(cbg[p].checked == false || cbg[p].checked == 'false')
							{
								cbg[p].setValue(1);
								cbgUncheck.push(p);
							}
						}
						refreshMapObject.cbg=cbgUncheck;
						var rs = Ext.getCmp('resCheck');
						var rq = Ext.getCmp('reqCheck');
						if(rs!=null && rs!=undefined)
						{
							refreshMapObject.rs=rs.checked;
						}
						if(rq!=null && rq!=undefined)
						{
							refreshMapObject.rq=rq.checked;
						}
					}

					for(var d=0;d<dataObject.length;d++){
						var objVal = dataObject[d];
						if(objVal.name =='GRAPH')
							allGraphJson=objVal.value;
						else if(objVal.name =='HEADER')
							headerJson=objVal.value;
						else if(objVal.name =='MAP')
							mapJson=objVal.value;
					}
					var rumOverviewObj = me.getRumOverviewTab();
					
					var  errorSiteDetailId = Ext.getCmp('errorSiteDetail');

					if(refresh && Ext.isEmpty(errorSiteDetailId))
					{
						//me.getUpdateSiteDetail(tabpanel);
						if(headerJson != null && headerJson != 'null' && headerJson!=undefined)
							me.getUpdateSiteDetailJson(headerJson,tabpanel);
					}
					else
					{
						var topPanels = rumOverviewObj.items.items;
						if (!Ext.isEmpty( topPanels[0]))
						{
							var resultItems=topPanels[0].items.items;
							for(var item=resultItems.length-1; item>-1 ; item--)
							{
								resultItems[item].destroy();
							}
						}

						var siteDetailsData=me.getSiteDetail(tabpanel);
						topPanels[0].add(siteDetailsData);
					}
					
					if(allGraphJson != null && allGraphJson != 'null')
						me.destroyPanelItems(me.getRumoverviewBottomPanel());

					
					var gmapView=tabpanel.view;
					var middleChartPanel = me.getGenericViewPanel();
					if (!Ext.isEmpty(middleChartPanel))
					{
						var resultItems=middleChartPanel.items.items;
						for(var item=resultItems.length-1; item>-1 ; item--)
						{
							resultItems[item].destroy();
						}
					}
					
					var graphContainer = me.getRumoverviewBottomPanel();

					
					var allJsonData = allGraphJson;

					if(gmapView!=null && gmapView!=undefined && (gmapView=="" || gmapView.indexOf('Country')>-1))
					{
						var graphContainerItems=0;
						/*if (!Ext.isEmpty(graphContainer))
						{
							if (!Ext.isEmpty(graphContainer.items.items))
							{
								//graphContainerItems = graphContainer.items.items.length;
							}
						}
						console.log("graphContainerItems--->"+graphContainerItems);
						if(graphContainerItems==0)
						{
							graphContainer.add({
								xtype:'container',
								cls:'rumDataInnerpanel',
								margin:'0 5 0 0',
								id:'overviewMapContainer',
								//width:540,
								columnWidth:.5,
								height:425,
								border:false,
								style:{'border':'0px solid red'},
								listeners:{
									'afterrender': function(currObj){
										currObj.add(me.getSiteMapDetail(tabpanel,"false","Overview",mainMask));
									}
								}
							});
						}
						else if(graphContainerItems==1)
						{
							me.refreshSiteMapDetail(tabpanel,"false","Overview",mainMask)
						}*/

						var checkMap = Ext.getCmp('mapIds');
						if(checkMap == null || checkMap == undefined || checkMap == 'undefined'){
							if (ErrCode != null && ErrCode != undefined && ErrCode=='ERROR-1')
							{
								graphContainer.add({
									xtype: 'panel',
									cls:'rumDataInnerpanel rumPanelBg',
									margin:'0 20 0 5',
									id:'ErrmapContainer',
									title:'Geo Performance',
									columnWidth:.55,
									//width:530,
									//height: 400,
									style:{'border':'0px solid blue'},
									html:'<center><div style="margin:30% 0 auto 0"><img class="iconInformation" src="/final/images/spacer.gif"/><div class="commonErrorMsgText">No internet connection to display Geo Map</div></div></center>'
								});
							}
							else
							{
								graphContainer.add({
									//xtype:'locationsmap',
									xtype: 'locationsmapcontainer',
									cls:'rumDataInnerpanel rumPanelBg',
									margin:'0 20 0 5',
									//bodyPadding:'0 10 0 10',
									id:'overviewMapContainerExtMap',
									//margin:'0',
									//width:540,
									columnWidth:.5,
									//height:425,
									style:{'border':'0px solid red'}
								});

								var	mapObj = null;
								try
								{
									if(Ext.getCmp('mapIds')!=null && Ext.getCmp('mapIds')!=undefined)
									{
										mapObj = Ext.getCmp('mapIds').gmap;
										if(!Ext.isEmpty(mapObj) && mapObj!=undefined && mapObj!=null)
										{
											var customMapType = new google.maps.StyledMapType(featureOpts, styledMapOptions);
											mapObj.mapTypes.set(MY_MAPTYPE_ID, customMapType);
										}
									}
								}
								catch (e)
								{
								}
							}
						}else if(mapJson != null && mapJson != 'null'){
							//console.log('*********************')
							var mapObj = checkMap.gmap;
							for (var j = 0; j < prevFeaturesArray.length; j++){
								var features = prevFeaturesArray[j];
								// Loop through each feature
								for (var i = 0; i < features.length; i++)
									 features[i].setMap(null);
							}
							prevFeaturesArray = new Array();
							for (var j = 0; j < markersArray.length; j++){
								var mak = markersArray[j];
									mak.setMap(null);
							}
							markersArray = new Array();
							//mapObj.clearMapMarkers();
							for (var j = 0; j < iconMarkerArray.length; j++){
								var mak = iconMarkerArray[j];

								if(mak == null  || mak == undefined)
									continue;

								//mak.labelContent='';
								mak.setMap(null);
							}
							iconMarkerArray = new Array();
						}
						
						var mapObj = null;
						if(!Ext.isEmpty(Ext.getCmp('mapIds')) && Ext.getCmp('mapIds')!=null && Ext.getCmp('mapIds')!=undefined)
						{
							mapObj = Ext.getCmp('mapIds').gmap;
							if(!Ext.isEmpty(mapObj) && mapObj!=undefined && mapObj!=null)
							{
								var customMapType = new google.maps.StyledMapType(featureOpts, styledMapOptions);
								mapObj.mapTypes.set(MY_MAPTYPE_ID, customMapType);
							}
						}

						var site_name=tabpanel.siteName;

						//url = encodeURI('/final/servlet/com.eg.RUMController?accessType=overviewMap&site='+site_name+'&tabName=rumOverview&fromService='+fromSerFlag);
						//Ext.Ajax.request(
						{
							//url : url,
							//scope:this,
							//success: function(response) 
							{
								//if(response.status == 200 && !Ext.isEmpty(response))
								{
									//var jsonText = response.responseText;
									//if (!Ext.isEmpty( jsonText))
									if (mapJson != null && mapJson != 'null' && false)
									{
										//var innerJsonData = Ext.decode(jsonText);
										var innerJsonData = mapJson;
										var jsonArray=innerJsonData.resultArray;
										if (!Ext.isEmpty( jsonArray)){
											var idCounter = 0;
											for(var item=0; item<jsonArray.length; item++)
											{
												var jsonItem=jsonArray[item];
												var tempCon = new Array();
												tempCon.push(jsonItem.DispInfo);
												tempCon.push(jsonItem.magnitude);
												tempCon.push(jsonItem.RealInfo);
												tempCon.push(jsonItem.State);
												tempCon.push(jsonItem.CountryLAT);
												tempCon.push(jsonItem.CountryLNG);
												tempCon.push(jsonItem.LocDetails);
												tempCon.push(jsonItem.BottomLocDetails);
												tempCountryDataMap.push(tempCon);

												//console.log(jsonItem.DispInfo);
												if(jsonItem.CountryCode == 'NIL' )
													continue;

												var  mapId = Ext.getCmp('mapIds');
												if(mapId!=null && mapId!=undefined)
												{
													map = mapId.gmap;
													var markerLocation =  new google.maps.LatLng(jsonItem.CountryLAT,jsonItem.CountryLNG);

													var infobox = new InfoBox({
														content: "",
														 //disableAutoPan: true,
														 maxWidth: "300px",
														 pixelOffset: new google.maps.Size(-180, -30),
														 zIndex: null,
														 boxStyle: {
															border: "0px solid red",
															background: "url('https://google-maps-utility-library-v3.googlecode.com/svn/trunk/infobox/examples/tipbox.gif') no-repeat",
															opacity: 0.85,
															width: "300px",
															height:"100px",
														},
														closeBoxMargin: "-6px -6px 0px 0px", //-108px -58px 2px 2px  - Normal:12px 4px 2px 2px   -58px 130px 2px 2px
														closeBoxURL: "/final/images/Light/rum-close.png",
														infoBoxClearance: new google.maps.Size(1, 1)
													});

													
													var marker = new MarkerWithLabel
													({
													   position: markerLocation,
													   draggable: false,
													   raiseOnDrag: false,
													   map: map,
													  // id: idCounter,
													   //labelContent: jsonItem.DispInfo,
													   labelAnchor: new google.maps.Point(2,8),//may be (0,5) --> if so then it display the label from center of bubble
													   labelClass: "labels", 
													   labelStyle: {opacity: 0.90, color:labelColor},
													   icon : image
													});
												}
												if(jsonItem.DispInfo == 'New Zealand')
													marker.set("labelAnchor",new google.maps.Point(28,2));
												
												
												var locDetailsDiv="";
												var info_height="height:100px";
												if(jsonItem.BottomLocDetails.length>3)
													info_height="height:150px";
												locDetailsDiv = locDetailsDiv+"<div id='infobox' style='"+info_height+";'>";
												locDetailsDiv = locDetailsDiv+"<ul class='rumMapData' style='	list-style:none;margin:0px;padding:3px 0 10px 0;height:27px;border-bottom:1px solid #cccccc'>";

												locDetailsDiv = locDetailsDiv+"<li style='width:70%'><a href='javascript:void(0)' data-qclass='yellowTip' data-qtip='"+jsonItem.DispInfo+"' style='text-decoration:none;cursor:default;'><div  data-qclass='yellowTip' data-qtip='"+jsonItem.DispInfo+"' ><table cellspacing='0' cellpadding='0' border='0'><tr><td><img data-qclass='yellowTip' data-qtip='"+jsonItem.DispInfo+"' src='/final/images/clear.png' class='state_"+jsonItem.State+"' width='15' height='15' border='0' style='margin-top:3px'/></td><td style='padding:1px 0 0 5px;width:185px;width:206px;float:left;font-size:18px;text-align:left;color:"+jsonItem.StateCode+";white-space: nowrap'><div style='text-overflow:ellipsis;width:auto;overflow:hidden;'>"+jsonItem.DispInfo+"</div></td></tr></table></div></a></li>";

												
												if(jsonItem.HeaderMeasureName!=null && jsonItem.HeaderMeasureName!=undefined && jsonItem.HeaderMeasureName!="")
												{
													if(!Ext.isEmpty(jsonItem.DD_URL) && jsonItem.DD_URL!=null && jsonItem.DD_URL!=undefined)
													{
														locDetailsDiv = locDetailsDiv+"<li style='width:25%;white-space:normal;display:inline-block;padding:4px 0px 0px 0px !important;float:right;text-align:right'><a style='text-decoration:none;color:#000' href='javascript:void(0)' onclick='javascript:showDDPopup(\""+jsonItem.DD_URL+"\")'><span style='font-size:17px;text-transform:lowercase;color:#000;font-weight:bold' class='rumVisitsText'>"+jsonItem.HeaderMeasureValue+"</span>&nbsp;"+jsonItem.HeaderMeasureDispName+"</a></li>";
													}
													else
													{
														locDetailsDiv = locDetailsDiv+"<li style='width:25%;white-space:normal;display:inline-block;padding:4px 0px 0px 0px !important;float:right;text-align:right'><span style='font-size:17px;text-transform:lowercase;color:#000;font-weight:bold' > "+jsonItem.HeaderMeasureValue+"</span>&nbsp;"+jsonItem.HeaderMeasureDispName+"</li>";
													}
												}

												locDetailsDiv = locDetailsDiv+"</ul><br/>";
												locDetailsDiv = locDetailsDiv+"<ul class='rumMapData' style='	list-style:none;margin:0px;padding:0px;display:inline-block;line-height:1.5em;'>";
												// Preparing the content to be shown on the popup window
												// || jsonDetailsItem.MeasureDispName == 'Apdex Score'
												for(var d=0; d<jsonItem.BottomLocDetails.length; d++)
												{
													var jsonDetailsItem=jsonItem.BottomLocDetails[d];
													if(jsonDetailsItem!=null && jsonDetailsItem!=undefined)
													{
														var mapInfoMeasure = jsonDetailsItem.MeasureDispName;
														//if(mapInfoMeasure == 'Page Requests' || mapInfoMeasure == 'Average Page Loading Time' || mapInfoMeasure == 'Error Requests' || mapInfoMeasure == 'Requests' || mapInfoMeasure == 'Errors' || mapInfoMeasure == 'Avg Page Loading Time' ||  mapInfoMeasure == 'Avg Page Load Time' || mapInfoMeasure =='Error %')

														if(!Ext.isEmpty(jsonDetailsItem.DD_URL) && jsonDetailsItem.DD_URL!=null && jsonDetailsItem.DD_URL!=undefined)
														{
															locDetailsDiv = locDetailsDiv+"<li style='text-align:center;padding:3px 8px 10px 8px;white-space:normal;display:inline-block;float:left'><a style='text-decoration:none;color:#000' href='javascript:void(0)' onclick='javascript:showDDPopup(\""+jsonDetailsItem.DD_URL+"\")'><span style='font-size:17px;font-weight:bold;text-transform:lowercase;color:"+jsonDetailsItem.StateCode+" !important;' class='rumVisitsText'> "+jsonDetailsItem.MeasureValue+" "+jsonDetailsItem.MeasureUnit+" </span><br/>"+jsonDetailsItem.MeasureDispName+"</a></li>";
														}
														else
														{
															locDetailsDiv = locDetailsDiv+"<li style='text-align:center;padding:0px 5px 0px 5px;white-space:normal;display:inline-block;float:left'><span style='font-size:17px;font-weight:bold;text-transform:lowercase;color:"+jsonDetailsItem.StateCode+" !important;'> "+jsonDetailsItem.MeasureValue+" "+jsonDetailsItem.MeasureUnit+" </span><br/>"+jsonDetailsItem.MeasureDispName+"</li>";
														}
													}
												}
												
												//locDetailsDiv = locDetailsDiv+"<li style='padding:3px 5px 10px 10px;white-space:normal;display:inline-block;float:left;text-align:center'><span style='font-size:17px;text-transform:lowercase;color:#000;font-weight:bold;color:#0c9a12'> 2</span><br/>Errors(%)</li>";
												locDetailsDiv = locDetailsDiv+"</ul>";
												locDetailsDiv = locDetailsDiv+"</div>";
												
												if (Ext.isEmpty( jsonItem.CountryCode))
												{
													tempCon.push("No_Code");
												}
												else
												{
													tempCon.push(jsonItem.CountryCode);
													var xhr = new XMLHttpRequest();
													
													var url = "geojson/"+jsonItem.CountryCode+".geojson" ;
													//var url = "geojson/US.geojson" ;
													xhr.open('GET', url, false);
													var style = GOOD;
													if(jsonItem.State == "HIGH")
														style = HIGH;
													else if(jsonItem.State == "INTERMEDIATE")
														style = INTERMEDIATE;
													else if(jsonItem.State == "LOW")
														style = LOW;
													else if(jsonItem.State == "UNKNOWN")
														style = UNKNOWN;

													xhr.onload = function() {
														if(xhr.status == 200)
															loadGeoJSON(xhr.responseText,style,marker,infobox,markerLocation,locDetailsDiv);
													};
													xhr.send();
												}
												var  mapId = Ext.getCmp('mapIds');
												map = mapId.gmap;

												google.maps.event.addListener(map, 'dragend', function() {
													map.setOptions({draggable: true});
													if(map.getZoom() != 1){
														if (strictBounds.contains(map.getCenter())) return;

														// We're out of bounds - Move the map back within the bounds
														var c = map.getCenter(),
														x = c.lng(),
														y = c.lat(),
														maxX = strictBounds.getNorthEast().lng(),
														maxY = strictBounds.getNorthEast().lat(),
														minX = strictBounds.getSouthWest().lng(),
														minY = strictBounds.getSouthWest().lat();
														if (y > minY) y = minY;
														if (y < maxY) y = maxY;
														//map.setCenter(new google.maps.LatLng(y, x));
													}
												});
												
												/*google.maps.event.addListener(map, 'zoom_changed', function() {
													//document.getElementById('map_canvas');
													//document.getElementById('geoOverviewIframeId').width = "100%";
													if(map.getZoom() == 1){
														//map.setCenter(new google.maps.LatLng(40.3780, 10.4359));
														map.setOptions({draggable: false});
													}
													else
														map.setOptions({draggable: true});
												});*/
												
												google.maps.event.addListener(map, 'drag', function() {
													var c = map.getCenter();
													if(map.getZoom() == 1){
														//map.setCenter(new google.maps.LatLng(40.3780, 10.4359));
														map.setOptions({draggable: false});
													}
													else{
														if (strictBounds.contains(map.getCenter())) return;

														// We're out of bounds - Move the map back within the bounds
														var c = map.getCenter(),
														x = c.lng(),
														y = c.lat(),
														maxX = strictBounds.getNorthEast().lng(),
														maxY = strictBounds.getNorthEast().lat(),
														minX = strictBounds.getSouthWest().lng(),
														minY = strictBounds.getSouthWest().lat();
														if (y > minY){ 
															y = minY;
															map.setOptions({draggable: false});
														}
														if (y < maxY) {
															y = maxY;
															map.setOptions({draggable: false});
														}
														//map.setCenter(new google.maps.LatLng(y, x));
													}
												});
												idCounter++;
											}
										}
									}else{
										if(refreshMapObject != null && refreshMapObject != undefined){

											var cname =refreshMapObject.name;
											var tl=refreshMapObject.tabPl;
											var region =refreshMapObject.region;
											cntClick(cname,tl,region);
											//this.loadSubMap(cname,tabpanel,region);
										}
									}
								}
							}
						}
						//);
					}

					//me.getLocationsMap().show();
					var rightMask = null;
					graphContainer.add({
						//cls:'gridSkin',
						xtype:'panel',
						margin:'0 5 0 0',
						//title:'Add Title',
						id:'graphHeatContainer',
						columnWidth:0.45,
						//title:"Load Time by Country",
						//height:'100%',
						//layout:'fit',
						//flex: 3,
						layout:{type:'vbox',align:'stretch'},
						cls:'rumDataInnerpanel rumPanelBg',
						bodyPadding:'0 0 0 0',
						border:false,
						style:{'border':'0px solid blue'},
						listeners:{
							'afterrender': function(currObj){
								/*rightMask = new Ext.LoadMask(currObj, {
									msg: "Loading..."
								});
								rightMask.show();*/
								//Ext.destroy(mainMask);
							}
						}
					});
					
					
					//if (!Ext.isEmpty( jsonText))
					{
						//var allJsonData = Ext.decode(jsonText);
						if (!Ext.isEmpty( allJsonData) && allJsonData!=undefined && allJsonData != null)
						{
							//if(!rumDash)
							if(true)
							{
								var middlePanelArr=allJsonData.middle;
								if (!Ext.isEmpty( middlePanelArr) && middlePanelArr!=undefined)
								{
									var bb=1;
									for(var b=0;b<middlePanelArr.length;b++)
									{
										var jsonData = middlePanelArr[b];
										if( !Ext.isEmpty(jsonData.chartType) )
										{
											var dispTitle = jsonData.chartDispTitle;
											var timeTitle="<div><div class='rumDataInnerHeader' style='float:left;width:84%;line-height:16px'>"+dispTitle+"</div><div class='rumDataInnerHeaderBg' style='width:80px;text-align:center;line-height:15px;float:right'>Last 1 hour</div></div>";
											var highChartType = jsonData.chartType;
											var isAreaChart = ( highChartType.indexOf("Area") > -1 || highChartType.indexOf("area") > -1 )?"true":"false";
											var colWdt = ( highChartType == 'pie' )?0.33:0.5;
											var winWidth = Ext.getBody().getViewSize().width;
											winWidth = ( colWdt >= 0.5)?winWidth/2:winWidth/4;
											if( highChartType == 'line' || highChartType == 'area' || highChartType == 'column' || highChartType == 'stackedarea' )
											{
												var axisDispTitle = jsonData.chartDispAxisTitle;
												var iniChartCount = jsonData.iniChartCount;
												var marginValues = ( bb % 2 == 0 )?'15 5 0 0':'15 20 0 0';
												if(!Ext.isEmpty(jsonData.urls) )
												{
													var urlList = jsonData.urls;
													var errorPanel='<div class="rumErrorPanelBg" style="height:320px;display:block;padding-top:140px;"><table align="center"><tr><td><img style="margin-top:-1px" src="/final/images/spacer.gif" class="iconAlert"/></td><td>&nbsp;<span class="rumGraphErrorMsgText">No Traffic Detected</span></td><tr></table></div>';

													for(var a=0;a<jsonData.urls.length;a++)
													{
														var chartUrl = decodeURI(jsonData.urls[a]);
														var pcrefreshStr = (refresh)?"yes":"no";
														chartUrl = encodeURI(chartUrl+"&isAreaChart="+isAreaChart+'&rumRefresh='+pcrefreshStr+"&iniChartCount="+iniChartCount);
														middleChartPanel.add({
															cls:'rumDataInnerpanel',
															margin:marginValues,
															id:'lineChart'+inc,
															bodyPadding:'10 0 20 0',
															style:{'border':'0px solid red'},
															columnWidth:colWdt,
															curUrl:chartUrl,
															axisTitle:axisDispTitle,
															highCType:highChartType,
															dispLocTitle:dispTitle,
															timeLocTitle:timeTitle,
															listeners:{
																'afterrender': function(currObj){
																	var chartPId = currObj.body.id;

																	Ext.Ajax.request({
																		url:currObj.curUrl,
																		async: false,
																		timeout:300000,
																		success:function(response)
																		{
																			var jsonText = response.responseText;
																			if (!Ext.isEmpty( jsonText) && jsonText.indexOf("<HTML") == -1 )
																			{
																				var chartJsonData = Ext.decode(jsonText);
																				chartJsonData['rumChartType'] = currObj.highCType;
																				chartJsonData['rumAxisTitle'] = currObj.axisTitle;
																				chartJsonData['trimLegendUnit'] = true;
																				try
																				{
																					if(chartJsonData['max'] < 10)
																					{
																						chartJsonData['isFromRUM'] = true;
																						chartJsonData['max']=10;
																					}
																				}
																				catch (e)
																				{
																				}

																				currObj.setTitle(currObj.timeLocTitle);
																				var graphHeight = Ext.getBody().getViewSize().height-450;
																				me.createRumTimelineHighchart(chartPId,250,winWidth-80,chartJsonData,'',false);
																				Ext.defer(function(){
																					var chart = $('#'+currObj.body.id).highcharts();
																						chart.redraw();
																				},100);
																				
																			}
																			else
																			{
																				currObj.setTitle(currObj.dispLocTitle);
																				currObj.setHeight(331);
																				currObj.update(errorPanel);
																			}
																		}
																	});

																}
															}
														});
														inc = inc+1;
													}
												}
											}

											if( highChartType == 'combination' )
											{
												if(!Ext.isEmpty(jsonData.urls) )
												{
													var marginValues = ( bb % 2 == 0 )?'15 5 0 0':'15 20 0 0';
													var iniChartCount = jsonData.iniChartCount;
													var urlList = jsonData.urls;
													var errorPanel='<div class="rumErrorPanelBg" style="height:320px;display:block;padding-top:140px;"><table align="center"><tr><td><img style="margin-top:-1px" src="/final/images/spacer.gif" class="iconAlert"/></td><td>&nbsp;<span class="rumGraphErrorMsgText">No Traffic Detected</span></td><tr></table></div>';

													for(var a=0;a<jsonData.urls.length;a++)
													{
														var chartUrl = decodeURI(jsonData.urls[a]);
														var crefreshStr = (refresh)?"yes":"no";
														chartUrl = encodeURI(chartUrl+"&isAreaChart="+isAreaChart+"&rumtabName=overview&rumRefresh="+crefreshStr+"&iniChartCount="+iniChartCount);
														var ctype = (a > 0 )?"column":"spline";
														middleChartPanel.add({
															cls:'rumDataInnerpanel',
															margin:marginValues,
															id:'lineChart'+inc,
															style:{'border':'0px solid blue'},
															columnWidth:colWdt,
															bodyPadding:'10 0 20 0',
															curUrl:chartUrl,
															dispLocTitle:dispTitle,
															cLoctype:ctype,
															timeLocTitle:timeTitle,
															listeners:{
																'afterrender': function(currObj){
																	var chartPId = currObj.body.id;

																	Ext.Ajax.request({
																		url:currObj.curUrl,
																		async: false,
																		timeout:300000,
																		success:function(response)
																		{
																			var jsonText = response.responseText;
																			if (!Ext.isEmpty( jsonText))
																			{
																				if( jsonText.indexOf("<HTML") == -1)
																				{
																					var chartJsonData = Ext.decode(jsonText);
																					chartJsonData['rumChartType'] = currObj.cLoctype;
																					chartJsonData['trimLegendUnit'] = true;
																					//currObj.setTitle(currObj.dispLocTitle);
																					currObj.setTitle(currObj.timeLocTitle);
																					var graphHeight = Ext.getBody().getViewSize().height-450;
																					me.createRumTimelineHighchart(chartPId,250,winWidth-80,chartJsonData,'',true);
																				}
																				else
																				{
																					currObj.setTitle(currObj.dispLocTitle);
																					currObj.setHeight(331);
																					currObj.update(errorPanel);
																				}
																			}
																		}
																	});
																}
															}
														});
														inc = inc+1;
													}
												}
											}
											else if(jsonData.chartType == 'pie')
											{
												var marginValues = ( bb % 2 == 0 )?'15 5 0 0':'15 20 0 0';
												if( !Ext.isEmpty(jsonData.pieChart) )
												{
													middleChartPanel.add({
														cls:'rumDataInnerpanel',
														columnWidth:0.5,
														id:'pieChart'+inc,
														margin:marginValues,
														style:{'border':'0px solid orange','text-align':'center !important'},
														bodyPadding:'10 0 0 0',
														autoScroll:false,
														scroll:false,
														pieData:jsonData.pieChart,
														dispLocTitle:dispTitle,
														listeners:{
															'afterrender': function(currObj){
																var pieId = currObj.body.id;
																currObj.setTitle(currObj.dispLocTitle);
																var graphHeight = Ext.getBody().getViewSize().height-450;
																winWidth = (Ext.getBody().getViewSize().width/2)-10;
																me.createRumPieHighchart(pieId,250,winWidth,currObj.pieData);
																currObj.setHeight(331);
																//me.createRumPieHighchart(pieId,220,200,jsonData.pieChart);
															}
														}
													});
													inc = inc+1;
												}
											}
										}

										bb=bb+1;
									}
								}
							}

							var bottomPanelArr=allJsonData.bottom;
							if (!Ext.isEmpty( bottomPanelArr) && bottomPanelArr!=undefined)
							{
								var currObj = Ext.getCmp('graphHeatContainer');
								var chartPId = currObj;
								var panId = currObj.id;

								for( var p=0; p < bottomPanelArr.length; p++ )
								{
									var bottomJsonData = bottomPanelArr[p];
									if( !Ext.isEmpty(bottomJsonData.chartType) )
									{
										var dispTitle = bottomJsonData.chartDispTitle;
										if(bottomJsonData.chartType == 'pie')
										{
											var winWidth = Ext.getBody().getViewSize().width;
											var piesWidth = (winWidth/2)-60;
											 piesWidth = (piesWidth/2)-60;
											var pieHeight = currObj.height-20;
											me.createRumPieHighchart(chartPId,pieHeight,piesWidth,bottomJsonData.pieChart);
											//me.createRumPieHighchart(chartPId,180,200,bottomJsonData.pieChart);
										}
										if(bottomJsonData.chartType == 'bar')
										{
											var winWidth = Ext.getBody().getViewSize().width;
											var piesWidth = winWidth/2;
											me.createRumBarHighchart(chartPId,198,piesWidth/2,bottomJsonData.barChart);
										}
										if( bottomJsonData.chartType == 'combination' || bottomJsonData.chartType.indexOf('line') > -1 )
										{
											var isCombinationChart = ( bottomJsonData.chartType == 'combination' )?true:false;
											var urlList = bottomJsonData.urls;
											if( !Ext.isEmpty(urlList) )
											{
												var chartUrl = decodeURI(urlList[0]);
												var isAreaChart = false;
												var refreshStr = (refresh)?"yes":"no";
												chartUrl = encodeURI(chartUrl+"&isAreaChart="+isAreaChart+"&rumtabName=overview&rumRefresh="+refreshStr);
												var ctype = "column";

												Ext.Ajax.request({
													url:chartUrl,
													async: false,
													success:function(response)
													{
														var jsonText = response.responseText;
														if (!Ext.isEmpty( jsonText))
														{
															var winWidth = Ext.getBody().getViewSize().width;
															var piesWidth = (winWidth/2);
															 //piesWidth = (piesWidth/2);
															var pieHeight = currObj.height-60;
															if( jsonText.indexOf("<HTML") == -1)
															{
																var chartJsonData = Ext.decode(jsonText);
																chartJsonData['rumChartType'] = ctype;
																chartJsonData['isBigCombination'] = true;
																currObj.setTitle(chartJsonData.title);
																me.createRumTimelineHighchart(chartPId,pieHeight,piesWidth,chartJsonData,'',isCombinationChart);
															}
															else
															{
																//currObj.update(jsonText);
																currObj.setTitle(dispTitle);
																currObj.setHeight(pieHeight);
																currObj.update(errMsg);
															}
														}
													}
												});
											}
										}
										else if( bottomJsonData.chartType == 'heatmap' )
										{
											if( !Ext.isEmpty( Ext.getCmp('heatGrid') ) )
											{
												var heatGridCont =  Ext.getCmp('heatGrid');
												if( !Ext.isEmpty(bottomJsonData.loop) )
												{
													var dispTitle = Ext.isEmpty ( bottomJsonData.chartDispTitle )?'':bottomJsonData.chartDispTitle; 
													var apdexVal = Ext.isEmpty ( bottomJsonData.heatApdexTitle )?'':bottomJsonData.heatApdexTitle; 
													var apdexTitle = "<table width='100%' style='height:20px' class='f13-bold'><tr><td width='60%' >"+dispTitle+"</td></tr></table>";
													
													var heatMapContent = '<table style="float:left;border:0px solid blue"><tr><td style="width:80px;vertical-align:top"><div id="mainSquareDiv" class="mainSquareDiv" style="width:80px;border:0px solid green;"></div></td><td width="*" >'+bottomJsonData.tableLabel+"</td></tr></table>";
													heatGridCont.add({
														cls:'rumDataInnerpanel',
														//style:{'border':'1px solid blue'},
														//width:250,
														width:248,
														id:'heat'+inc,
														margin:'0 15 0 0',
														//layout:'fit',
														bodyPadding:'23 0 10 0',
														autoScroll:false,
														scroll:false,
														height:'auto',
														title:apdexTitle,
														html:"<div style='float:left;border:0px solid green;padding-bottom:12px;height:34px !important;display:block !important'>"+apdexVal+"</div><div class='iconRumInfo' style='float:left;margin-left:3px;margin-top:23px' data-qclass='yellowTip' data-qtip='"+bottomJsonData.Info_Tip+"'></div><div class='crl'></div>"+heatMapContent,
														loopData:bottomJsonData.loop,
														listeners:{
															'afterrender': function(currObj){
																var measData = currObj.loopData;
																var mainDiv = jQuery('.mainSquareDiv');
																if( Ext.isEmpty( measData.notraffic ))
																{
																	if( !Ext.isEmpty(measData.satisfied) )
																	{
																		var satis = measData.satisfied;
																		if( satis > 0 )
																		{
																			for(i=0; i<satis; i++){
																				var satisfiedDivVar = $('<div></div>').addClass('satisfiedDiv');
																				mainDiv.append(satisfiedDivVar);
																			}
																		}
																	}
																	
																	
																	if( !Ext.isEmpty(measData.Tolerated) )
																	{
																		var Toler = measData.Tolerated;
																		if( Toler > 0 )
																		{
																			for(i=0; i<Toler; i++){
																				var toleratingDivVar = $('<div></div>').addClass('toleratingDiv');
																				mainDiv.append(toleratingDivVar);
																			}
																		}
																	}

																	if( !Ext.isEmpty(measData.frustrated) )
																	{
																		var frus = measData.frustrated;
																		if( frus > 0 )
																		{
																			for(i=0; i<frus; i++){
																				var frustratedDivVar = $('<div></div>').addClass('frustratedDiv'); 
																				mainDiv.append(frustratedDivVar);
																			}
																		}
																	}

																	if( !Ext.isEmpty(measData.Desktop) )
																	{
																		var satis = measData.Desktop;
																		if( satis > 0 )
																		{
																			for(i=0; i<satis; i++){
																				var desktopDivVar = $('<div></div>').addClass('desktopDiv');
																				mainDiv.append(desktopDivVar);
																			}
																		}
																	}
																	
																	
																	if( !Ext.isEmpty(measData.Mobile) )
																	{
																		var Toler = measData.Mobile;
																		if( Toler > 0 )
																		{
																			for(i=0; i<Toler; i++){
																				var mobileDivVar = $('<div></div>').addClass('mobileDiv');
																				mainDiv.append(mobileDivVar);
																			}
																		}
																	}

																	if( !Ext.isEmpty(measData.Tablet) )
																	{
																		var frus = measData.Tablet;
																		if( frus > 0 )
																		{
																			for(i=0; i<frus; i++){
																				var tabletDivVar = $('<div></div>').addClass('tabletDiv'); 
																				mainDiv.append(tabletDivVar);
																			}
																		}
																	}
																}
																else
																{
																	var notraffic = measData.notraffic;
																	if( notraffic > 0 )
																	{
																		for(i=0; i<notraffic; i++){
																			var notrafficDivVar = $('<div></div>').addClass('notrafficDiv');
																			mainDiv.append(notrafficDivVar);
																		}
																	}
																}
															}
														}
													});
													inc = inc+1;
												}
												else
												{
													var dispTitle = Ext.isEmpty ( bottomJsonData.chartDispTitle )?'':bottomJsonData.chartDispTitle; 
													var heatMapContent = '<div style="font-size:12px;height:23px !important;display:block !important"><span style="font-size:16px;">N/A</span> Apdex</div><table style="border:0px solid blue;"><tr><td style="width:80px;vertical-align:top" ><div id="mainSquareDiv" class="mainSquareDiv" style="width:80px;border:0px solid green;"></div></td><td width="*" style="padding-left:3px"><div><ul class="report-tripple-data"><li class="li_triple_data"><span class="percentage" style="text-align:right;width:47px;display:inline-block">0% - </span><span>&nbsp;&nbsp;Satisfied<em>(0)</em></span></li><li class="li_triple_data"><span class="percentage" style="text-align:right;width:47px;display:inline-block">0% - </span><span>&nbsp;&nbsp;Tolerated<em>(0)</em></span></li><li class="li_triple_data"><span class="percentage" style="text-align:right;width:47px;display:inline-block">0% - </span><span>&nbsp;&nbsp;Frustrated<em>(0)</em></span></li></ul></div></td></tr></table>';
													heatGridCont.add({
														cls:'rumDataInnerpanel',
														style:{'border':'0px solid red'},
														width:270,
														id:'heat'+inc,
														margin:'0 15 0 0',
														bodyPadding:'45 0 10 0',
														autoScroll:false,
														scroll:false,
														height:198,
														title:dispTitle,
														html:heatMapContent,
														loopData:bottomJsonData.loop,
														listeners:{
															'afterrender': function(currObj){
															var mainDiv = jQuery('.mainSquareDiv');
															for(i=0; i<100; i++){
																var notrafficDivVar = $('<div></div>').addClass('notrafficDiv');
																mainDiv.append(notrafficDivVar);
															}
															}
														}
													});
												}
											}
										}
									}
									else if( !Ext.isEmpty(bottomJsonData.gridNo) )
									{
										if( bottomJsonData.gridNo == 1)
										{
											if( !Ext.isEmpty(bottomJsonData.columns) )
											{
												var gridJson = bottomJsonData;
												if(!Ext.isEmpty(gridJson.fields))
												{
													Ext.define('processModel',{
													extend: 'Ext.data.Model',
													fields:gridJson.fields
													});

													var processStore = Ext.create('Ext.data.Store', {
														model: 'processModel',
														autoLoad: true,
														proxy: {
															type: 'memory',
															data: gridJson.data
														},
														sortOnLoad : true,
														sorters : {
															property : gridJson.SortBy,
															direction : 'DESC'
														}
													});
													
													
													var tempGrid=Ext.create('Ext.grid.Panel', {
														//title:gridJson.gridTitle,
														store: processStore,
														//defaults:{width:250},
														columns: gridJson.columns,
														//style:{'border':'0px solid red !important'},
														//cls:'rumGridSkin',
														ui:'newGridPanel',
														stateful: true,
														//flex:1,
														border:true,
															id:'tempGrid',
														//width:500,
														stateId:'loadCountry',
														margin:'7 0 7 0',
														width:'100%',
														//width:Ext.getBody().getViewSize().width-630,
														autoScroll:true,
														scroll:true,
														//forceFit: true,
														layout:'fit',
														//flex:1,
														//layout:{type:'anchor'},
														height:160,
														viewConfig: {    
															//forceFit: true,  
															//layout:'fit',
															//style:{'overflow-x':'auto !important','overflow-y':'auto !important'},
															//style:{'overflow-x':'auto !important'},
														},

														//margin:'0 6 6 6',
														//width: Ext.getBody().getViewSize().width-130,
														//height: Ext.getBody().getViewSize().height-130
													});

													var tempPanel={
														xtype:'panel',
														layout:'column',
														style:{'padding':'0 0 0 0 !important','border':'0px solid yellow'},
														height:198,
														autoScroll:false,
														scroll:false,
														id:'heatGrid',
														items:[
														]
													};
													currObj.setTitle(gridJson.gridTitle);
													currObj.add(tempGrid);
													currObj.add(tempPanel);
												}
												else
												{
													currObj.add({
														cls:'rumDataInnerpanel',
														margin:'0 5 0 0',
														//title:'Add Title',
														id:'gridContainer'+p,
														columnWidth:0.5,
														//title:"Locations details",
														height:370,	
														bodyPadding:'16 0 0 0',
														style:{'border':'0px solid yellow'},
														html:'<div class="rumErrorPanelBg" style="height:320px;display:block;padding-top:140px;"><table align="center"><tr><td><img style="margin-top:-1px" src="/final/images/spacer.gif" class="iconAlert"/></td><td>&nbsp;<span class="rumGraphErrorMsgText">No Traffic Detected</span></td><tr></table></div>',
													});

													var tempPanel={
														xtype:'container',
														layout:'column',
														id:'heatGrid',
														style:{'border':'0px solid yellow'},
														height:190,
														autoScroll:false,
														scroll:false,
														items:[]
													};
													currObj.add(tempPanel);
												}
											}
											else
											{
												Ext.create('Ext.panel.Panel', {
													layout:'',
													id:'errorPanel',
													margin:'0 0 0 0',
													style:{'border':'0px solid red'},
													items:[]
												});

												var errorPanel=Ext.getCmp("errorPanel");

												currObj.add({
													cls:'rumDataInnerpanel',
													margin:'0 5 0 0',
													title:"Top N Countries by Performance",
													//title:'Add Title',
													id:'gridContainer'+p,
													columnWidth:0.6,
													height:190,	
													bodyPadding:'10 0 0 0',
													style:{'border':'0px solid yellow'},
													html:'<div class="rumErrorPanelBg" style="height:170px;display:block;padding-top:60px;"><table align="center"><tr><td><img style="margin-top:-1px" src="/final/images/spacer.gif" class="iconAlert"/></td><td>&nbsp;<span class="rumGraphErrorMsgText">No Traffic Detected</span></td><tr></table></div>',
												});

												var tempPanel={
													xtype:'container',
													layout:'column',
													id:'heatGrid',
													style:{'border':'0px solid yellow'},
													height:190,
													autoScroll:false,
													scroll:false,
													items:[]
												};
												currObj.add(tempPanel);
											}
										}
										else if( bottomJsonData.gridNo > 2 )
										{
											if( !Ext.isEmpty( Ext.getCmp('heatGrid') ) )
											{
												var heatGridCont =  Ext.getCmp('heatGrid');
												if( !Ext.isEmpty(bottomJsonData.columns) )
												{
													var gridJson = bottomJsonData;
													if(!Ext.isEmpty(gridJson.fields))
													{
														Ext.define('browsersModel',{
														extend: 'Ext.data.Model',
														fields:gridJson.fields
														});

														var browsersStore = Ext.create('Ext.data.Store', {
															model: 'browsersModel',
															autoLoad: true,
															proxy: {
																type: 'memory',
																data: gridJson.data
															}
														});

														var tempGrid=Ext.create('Ext.grid.Panel', {
															//title:gridJson.gridTitle,
															store: browsersStore,
															//defaults:{width:250},
															columns: gridJson.columns,
															columnWidth:1.0,
															margin:'7 0 0 0',
															//style:{'border':'0px solid blue !important'},
															//cls:'rumGridSkin',
															ui:'newGridPanel',
															//flex:1,
															border:true,
															stateId:'grpRequest',
															stateful: true,
															//width:'auto',
															scroll:true,
															autoScroll:true,
															//forceFit:false,
															layout:'fit',
															height:160,
															viewConfig: {  
																//style:{'overflow-y':'hidden !important'},
																//style:{'overflow-x':'hidden !important'},
																//forceFit: true,  
																//layout:'fit',
															},

															//margin:'0 6 6 6',
															//width: Ext.getBody().getViewSize().width-130,
															//height: Ext.getBody().getViewSize().height-130
														});
														Ext.create('Ext.panel.Panel', {
															title:gridJson.gridTitle,
															columnWidth:1.0,
															id:'heattitleGrid',
															margin:'0 0 0 0',
															style:{'border':'0px solid red'},
															height:198,
															autoScroll:false,
															scroll:false,
															items:[]
														});
														var gridTitlePanel = Ext.getCmp('heattitleGrid');
														gridTitlePanel.add(tempGrid);
														//heatGridCont.add(tempGrid);
														heatGridCont.add(gridTitlePanel);
														//gridTitlePanel.add(tempGrid);
														//heatGridCont.setTitle("skldfsfjklsdfjkl");
													}
													else
													{
														heatGridCont.add({
														cls:'rumDataInnerpanel',
														margin:'0 0 0 0',
														//title:'Add Title',
														id:'gridContainer'+p,
														columnWidth:1.0,
														title:"Load by Page Groups",
														height:120,	
														bodyPadding:'16 0 0 0',
														style:{'border':'0px solid yellow'},
														html:'<table style="margin:20% auto" align="center"><tr><td><img style="margin-top:-1px" src="/final/images/spacer.gif" class="iconAlert"/></td><td>&nbsp;<span class="rumGraphErrorMsgText">No Traffic Detected</span></td><tr></table>',
														});
													}
												}
												else
												{
													Ext.create('Ext.panel.Panel', {
															title:"Load by Page Groups",
															columnWidth:1.0,
															id:'errorPanel',
															margin:'0 0 0 0',
															style:{'border':'0px solid red'},
															items:[]
														});

													var errorPanel=Ext.getCmp("errorPanel");

													heatGridCont.add(errorPanel);

													errorPanel.add({
														cls:'rumErrorPanelBg',
														margin:'0 5 0 0',
														//title:'Add Title',
														id:'gridContainer'+p,
														columnWidth:1.0,
														height:200,
														margin:'10 0 0 0',
														bodyPadding:'16 0 0 0',
														style:{'border':'0px solid yellow'},
														html:'<table style="margin:20% auto" align="center"><tr><td><img style="margin-top:-1px" src="/final/images/spacer.gif" class="iconAlert"/></td><td>&nbsp;<span class="rumGraphErrorMsgText">No Traffic Detected</span></td><tr></table>',
													});
												}
											}
										}
									}
								}

								if(rumDash)
								{
									var button  = Ext.create('Ext.Button', {
										text: 'Load More',
										id : 'loadMoreDet',
										height:20,
										width:70,
										style:{'float':'right', 'margin-right':'10px'},
										handler: function() {
												this.setVisible(false);
												var middlePanelArr=allJsonData.middle;
												if (!Ext.isEmpty( middlePanelArr) && middlePanelArr!=undefined)
												{
													var bb=1;
													for(var b=0;b<middlePanelArr.length;b++)
													{
														var jsonData = middlePanelArr[b];
														if( !Ext.isEmpty(jsonData.chartType) )
														{
															var dispTitle = jsonData.chartDispTitle;
															var timeTitle="<div><div class='rumDataInnerHeader' style='float:left;width:84%;line-height:16px'>"+dispTitle+"</div><div class='rumDataInnerHeaderBg' style='width:80px;text-align:center;line-height:15px;float:right'>Last 1 hour</div></div>";
															var highChartType = jsonData.chartType;
															var isAreaChart = ( highChartType.indexOf("Area") > -1 || highChartType.indexOf("area") > -1 )?"true":"false";
															var colWdt = ( highChartType == 'pie' )?0.33:0.5;
															var winWidth = Ext.getBody().getViewSize().width;
															winWidth = ( colWdt >= 0.5)?winWidth/2:winWidth/4;
															if( highChartType == 'line' || highChartType == 'area' || highChartType == 'column' || highChartType == 'stackedarea' )
															{
																var axisDispTitle = jsonData.chartDispAxisTitle;
																var iniChartCount = jsonData.iniChartCount;
																var marginValues = ( bb % 2 == 0 )?'15 5 0 0':'15 20 0 0';
																if(!Ext.isEmpty(jsonData.urls) )
																{
																	var urlList = jsonData.urls;
																	var errorPanel='<div class="rumErrorPanelBg" style="height:320px;display:block;padding-top:140px;"><table align="center"><tr><td><img style="margin-top:-1px" src="/final/images/spacer.gif" class="iconAlert"/></td><td>&nbsp;<span class="rumGraphErrorMsgText">No Traffic Detected</span></td><tr></table></div>';

																	for(var a=0;a<jsonData.urls.length;a++)
																	{
																		var chartUrl = decodeURI(jsonData.urls[a]);
																		var pcrefreshStr = (refresh)?"yes":"no";
																		chartUrl = encodeURI(chartUrl+"&isAreaChart="+isAreaChart+'&rumRefresh='+pcrefreshStr+"&iniChartCount="+iniChartCount);
																		middleChartPanel.add({
																			cls:'rumDataInnerpanel',
																			margin:marginValues,
																			id:'lineChart'+inc,
																			bodyPadding:'10 0 20 0',
																			style:{'border':'0px solid red'},
																			columnWidth:colWdt,
																			curUrl:chartUrl,
																			axisTitle:axisDispTitle,
																			highCType:highChartType,
																			dispLocTitle:dispTitle,
																			timeLocTitle:timeTitle,
																			listeners:{
																				'afterrender': function(currObj){
																					var chartPId = currObj.body.id;

																					Ext.Ajax.request({
																						url:currObj.curUrl,
																						async: false,
																						timeout:300000,
																						success:function(response)
																						{
																							var jsonText = response.responseText;
																							if (!Ext.isEmpty( jsonText) && jsonText.indexOf("<HTML") == -1 )
																							{
																								var chartJsonData = Ext.decode(jsonText);
																								chartJsonData['rumChartType'] = currObj.highCType;
																								chartJsonData['rumAxisTitle'] = currObj.axisTitle;
																								chartJsonData['trimLegendUnit'] = true;
																								currObj.setTitle(currObj.timeLocTitle);
																								var graphHeight = Ext.getBody().getViewSize().height-450;
																								me.createRumTimelineHighchart(chartPId,250,winWidth-80,chartJsonData,'',false);
																							}
																							else
																							{
																								currObj.setTitle(currObj.dispLocTitle);
																								currObj.setHeight(331);
																								currObj.update(errorPanel);
																							}
																						}
																					});
																				}
																			}
																		});
																		inc = inc+1;
																	}
																}
															}

															if( highChartType == 'combination' )
															{
																if(!Ext.isEmpty(jsonData.urls) )
																{
																	var marginValues = ( bb % 2 == 0 )?'15 5 0 0':'15 20 0 0';
																	var iniChartCount = jsonData.iniChartCount;
																	var urlList = jsonData.urls;
																	var errorPanel='<div class="rumErrorPanelBg" style="height:320px;display:block;padding-top:140px;"><table align="center"><tr><td><img style="margin-top:-1px" src="/final/images/spacer.gif" class="iconAlert"/></td><td>&nbsp;<span class="rumGraphErrorMsgText">No Traffic Detected</span></td><tr></table></div>';

																	for(var a=0;a<jsonData.urls.length;a++)
																	{
																		var chartUrl = decodeURI(jsonData.urls[a]);
																		var crefreshStr = (refresh)?"yes":"no";
																		chartUrl = encodeURI(chartUrl+"&isAreaChart="+isAreaChart+"&rumtabName=overview&rumRefresh="+crefreshStr+"&iniChartCount="+iniChartCount);
																		var ctype = (a > 0 )?"column":"spline";
																		middleChartPanel.add({
																			cls:'rumDataInnerpanel',
																			margin:marginValues,
																			id:'lineChart'+inc,
																			style:{'border':'0px solid blue'},
																			columnWidth:colWdt,
																			bodyPadding:'10 0 20 0',
																			curUrl:chartUrl,
																			dispLocTitle:dispTitle,
																			cLoctype:ctype,
																			timeLocTitle:timeTitle,
																			listeners:{
																				'afterrender': function(currObj){
																					var chartPId = currObj.body.id;
																					Ext.Ajax.request({
																						url:currObj.curUrl,
																						async: false,
																						timeout:300000,
																						success:function(response)
																						{
																							var jsonText = response.responseText;
																							if (!Ext.isEmpty( jsonText))
																							{
																								if( jsonText.indexOf("<HTML") == -1)
																								{
																									var chartJsonData = Ext.decode(jsonText);
																									chartJsonData['rumChartType'] = currObj.cLoctype;
																									chartJsonData['trimLegendUnit'] = true;
																									//currObj.setTitle(currObj.dispLocTitle);
																									currObj.setTitle(currObj.timeLocTitle);
																									var graphHeight = Ext.getBody().getViewSize().height-450;
																									me.createRumTimelineHighchart(chartPId,250,winWidth-80,chartJsonData,'',true);
																								}
																								else
																								{
																									currObj.setTitle(currObj.dispLocTitle);
																									currObj.setHeight(331);
																									currObj.update(errorPanel);
																								}
																							}
																						}
																					});
																				}
																			}
																		});
																		inc = inc+1;
																	}
																}
															}
															else if(jsonData.chartType == 'pie')
															{
																var marginValues = ( bb % 2 == 0 )?'15 5 0 0':'15 20 0 0';
																if( !Ext.isEmpty(jsonData.pieChart) )
																{
																	middleChartPanel.add({
																		cls:'rumDataInnerpanel',
																		columnWidth:0.5,
																		id:'pieChart'+inc,
																		margin:marginValues,
																		style:{'border':'0px solid orange','text-align':'center !important'},
																		bodyPadding:'10 0 0 0',
																		autoScroll:false,
																		scroll:false,
																		pieData:jsonData.pieChart,
																		dispLocTitle:dispTitle,
																		listeners:{
																			'afterrender': function(currObj){
																				var pieId = currObj.body.id;
																				currObj.setTitle(currObj.dispLocTitle);
																				var graphHeight = Ext.getBody().getViewSize().height-450;
																				winWidth = (Ext.getBody().getViewSize().width/2)-10;
																				me.createRumPieHighchart(pieId,250,winWidth,currObj.pieData);
																				currObj.setHeight(331);
																				//me.createRumPieHighchart(pieId,220,200,jsonData.pieChart);
																			}
																		}
																	});
																	inc = inc+1;
																}
															}
														}

														bb=bb+1;
													}
												}
										}
									});
									currObj.add(button);
								}
							}
						}
					}

					if(mainMask != null && mainMask != undefined && mainMask != 'undefined')
					{
						var task = new Ext.util.DelayedTask(function() {
							Ext.destroy(mainMask);
							task=null;
						});
						task.delay(3000);
					}
			}
			else
			{
				if(mainMask != null && mainMask != undefined && mainMask != 'undefined')
				{
					var task = new Ext.util.DelayedTask(function() {
						Ext.destroy(mainMask);
						task=null;
					});
					task.delay(3000);
					//setTimeout(timoutMethod(mainMask),13000);
					//setTimeout(Ext.bind(me.timoutMethod(mainMask), me), 13000);
				}
			}
			
		}else{
			Ext.Ajax.request({
				url:allPanelUrl,
				//async: false,
				timeout:300000,
				success:function(response)
				{
					//Ext.destroy(mainMask);
					/*if(rightMask!=null && rightMask!=undefined)
					{
						Ext.destroy(rightMask);
					}*/

					var rumOverviewObj = me.getRumOverviewTab();
					/*var topPanels = rumOverviewObj.items.items;
					
					if (!Ext.isEmpty( topPanels[0]))
					{
						var resultItems=topPanels[0].items.items;
						for(var item=resultItems.length-1; item>-1 ; item--)
						{
							resultItems[item].destroy();
						}
					}*/

					//var ff=me.getSiteDetail(tabpanel)

					//topPanels[0].add(me.getSiteDetail(tabpanel));

					var  errorSiteDetailId = Ext.getCmp('errorSiteDetail');

					if(refresh && Ext.isEmpty(errorSiteDetailId))
					{
						me.getUpdateSiteDetail(tabpanel);
					}
					else
					{
						var topPanels = rumOverviewObj.items.items;
						if (!Ext.isEmpty( topPanels[0]))
						{
							var resultItems=topPanels[0].items.items;
							for(var item=resultItems.length-1; item>-1 ; item--)
							{
								resultItems[item].destroy();
							}
						}

						var siteDetailsData=me.getSiteDetail(tabpanel);
						topPanels[0].add(siteDetailsData);
					}

					me.destroyPanelItems(me.getRumoverviewBottomPanel());

					//var bottomDataBlock = me.getRumoverviewBottomPanel().items.items;
					//var overViewMap = bottomDataBlock[0];
					var gmapView=tabpanel.view;
					var middleChartPanel = me.getGenericViewPanel();
					if (!Ext.isEmpty(middleChartPanel))
					{
						var resultItems=middleChartPanel.items.items;
						for(var item=resultItems.length-1; item>-1 ; item--)
						{
							resultItems[item].destroy();
						}
					}
					
					var graphContainer = me.getRumoverviewBottomPanel();

					var jsonText = response.responseText; 
					var allJsonData = Ext.decode(jsonText);
						glJson = allJsonData;

					if(gmapView!=null && gmapView!=undefined && (gmapView=="" || gmapView.indexOf('Country')>-1))
					{
						var graphContainerItems=0;
						/*if (!Ext.isEmpty(graphContainer))
						{
							if (!Ext.isEmpty(graphContainer.items.items))
							{
								//graphContainerItems = graphContainer.items.items.length;
							}
						}
						console.log("graphContainerItems--->"+graphContainerItems);
						if(graphContainerItems==0)
						{
							graphContainer.add({
								xtype:'container',
								cls:'rumDataInnerpanel',
								margin:'0 5 0 0',
								id:'overviewMapContainer',
								//width:540,
								columnWidth:.5,
								height:425,
								border:false,
								style:{'border':'0px solid red'},
								listeners:{
									'afterrender': function(currObj){
										currObj.add(me.getSiteMapDetail(tabpanel,"false","Overview",mainMask));
									}
								}
							});
						}
						else if(graphContainerItems==1)
						{
							me.refreshSiteMapDetail(tabpanel,"false","Overview",mainMask)
						}*/

						var checkMap = Ext.getCmp('mapIds');
						if(checkMap == null || checkMap == undefined || checkMap == 'undefined'){
							if (ErrCode != null && ErrCode != undefined && ErrCode=='ERROR-1')
							{
								graphContainer.add({
									xtype: 'panel',
									cls:'rumDataInnerpanel rumPanelBg',
									margin:'0 20 0 5',
									id:'ErrmapContainer',
									title:'Geo Performance',
									columnWidth:.55,
									//width:530,
									//height: 400,
									style:{'border':'0px solid red'},
									html:'<center><div style="margin:30% 0 auto 0"><img class="iconInformation" src="/final/images/spacer.gif"/><div class="commonErrorMsgText">No internet connection to display Geo Map</div></div></center>'
								});
								//ErrCode=null;
							}
							else
							{
								graphContainer.add({
									//xtype:'locationsmap',
									xtype: 'locationsmapcontainer',
									cls:'rumDataInnerpanel rumPanelBg',
									margin:'0 20 0 5',
									//bodyPadding:'0 10 0 10',
									id:'overviewMapContainerExtMap',
									//margin:'0',
									//width:540,
									columnWidth:.55,
									layout:{
										type:'vbox',
										align:'stretch'
									},
									//height:425,
									style:{'border':'0px solid red'}
								});
								var	mapObj = null;
								try
								{
									if(Ext.getCmp('mapIds')!=null && Ext.getCmp('mapIds')!=undefined)
									{
										mapObj = Ext.getCmp('mapIds').gmap;
										if(!Ext.isEmpty(mapObj) && mapObj!=undefined && mapObj!=null)
										{
											var customMapType = new google.maps.StyledMapType(featureOpts, styledMapOptions);
											mapObj.mapTypes.set(MY_MAPTYPE_ID, customMapType);
										}
									}
								}
								catch (e)
								{
								}
							}
						}else{
							//console.log('*********************')
							var mapObj = checkMap.gmap;
							for (var j = 0; j < prevFeaturesArray.length; j++){
								var features = prevFeaturesArray[j];
								// Loop through each feature
								for (var i = 0; i < features.length; i++)
									 features[i].setMap(null);
							}
							prevFeaturesArray = new Array();
							for (var j = 0; j < markersArray.length; j++){
								var mak = markersArray[j];
									mak.setMap(null);
							}
							markersArray = new Array();
							for (var j = 0; j < iconMarkerArray.length; j++){
								var mak = iconMarkerArray[j];

								if(mak == null  || mak == undefined)
									continue;

								//mak.labelContent='';
								mak.setMap(null);
							}
							iconMarkerArray = new Array();
							//mapObj.clearMapMarkers();

							for (var j = 0; j < infoBoxArr.length; j++){
								var inf = infoBoxArr[j];

								if(inf == null  || inf == undefined)
									continue;

								//mak.labelContent='';
								inf.setMap(null);
							}
							infoBoxArr = new Array();
						}
						findAccess = undefined;

						if(Ext.getCmp('mapIds')!=null && Ext.getCmp('mapIds')!=undefined)
						{
							var mapObj = Ext.getCmp('mapIds').gmap;
							if(!Ext.isEmpty(mapObj) && mapObj!=undefined && mapObj!=null)
							{
								var customMapType = new google.maps.StyledMapType(featureOpts, styledMapOptions);
								mapObj.mapTypes.set(MY_MAPTYPE_ID, customMapType);

								var center = mapObj.getCenter();
								mapObj.setCenter(center); 
								google.maps.event.addDomListener(window, "resize", function() {
									var center = mapObj.getCenter();
									google.maps.event.trigger(mapObj, "resize");
									mapObj.setCenter(center);
								});
							}
						}

						var site_name=tabpanel.siteName;
						url = encodeURI('/final/servlet/com.eg.RUMController?accessType=overviewMap&site='+site_name+'&tabName=rumOverview&comp='+site_name+'&fromService='+fromSerFlag);
						var counCombo = Ext.getCmp('countryCombo');
						var regCombo = Ext.getCmp('regionCombo');
						
						if(counCombo != null && counCombo != 'undefined'){
							var counStore = counCombo.getStore();

							counStore.removeAll();
							counStore.loadRawData('');
							counStore.insert(0, {
								displayField: 'All',
								valueField: 'All'
							});
							counCombo.setValue('All');
						}

						if(regCombo != null && regCombo != 'undefined'){
							var regStore = regCombo.getStore();
							regStore.removeAll();
							regStore.loadRawData('');
							regStore.insert(0, {
								displayField: 'All',
								valueField: 'All'
							});
							regCombo.setValue('All');
						}
						
						refreshMapObject = new Object();
						refreshMapObject.name = 'Country';
						refreshMapObject.tabPl = tabpanel;
						refreshMapObject.region = '';
						Ext.Ajax.request(
						{
							url : url,
							scope:this,
							success: function(response) 
							{
								if(response.status == 200 && !Ext.isEmpty(response))
								{
									var jsonText = response.responseText;
									if (!Ext.isEmpty( jsonText)){
										var innerJsonData = Ext.decode(jsonText);
										var jsonArray=innerJsonData.resultArray;
										var totScale=innerJsonData.overAllScale;
										
										if(true && (jsonArray != undefined && jsonArray.length ==1)){
											var counObj = jsonArray[0];
											nextMap = 'Region';
											isCityMap = false;
											regCombo.setDisabled(false);
											cntClick(counObj.RealInfo,tabBackUp,null,true);
											return;
										}

										var stateArray = innerJsonData.stateArray;
										var colorArray = innerJsonData.colorArray;
										if(!Ext.isEmpty( stateArray)){
											var cbg = Ext.getCmp('barCheckBoxPanel').items.items[0].items.items;
											for(var p=0;p<cbg.length;p++)
											{
												cbg[p].setVisible(true);
												cbg[p].addCls("geoState_chkbt_GRAY");
											}

											for(var i=0;i<stateArray.length;i++){
												var st=stateArray[i];
												if(st=='GOOD')
												{
													//cbg[0].setVisible(true);
													cbg[0].removeCls("geo_chkbt_GRAY");
													cbg[0].removeCls("geoState_chkbt_GRAY");
													cbg[0].addCls("geo_chkbt_GOOD");
												}
												else if(st=='UNKNOWN')
												{
													//cbg[1].setVisible(true);
													cbg[1].removeCls("geo_chkbt_GRAY");
													cbg[1].removeCls("geoState_chkbt_GRAY");
													cbg[1].addCls("geo_chkbt_UNKNOWN");
												}
												else if(st=='LOW')
												{
													//cbg[2].setVisible(true);
													cbg[2].removeCls("geo_chkbt_GRAY");
													cbg[2].removeCls("geoState_chkbt_GRAY");
													cbg[2].addCls("geo_chkbt_LOW");
												}
												else if(st=='INTERMEDIATE')
												{
													cbg[3].removeCls("geo_chkbt_GRAY");
													cbg[3].removeCls("geoState_chkbt_GRAY");
													cbg[3].addCls("geo_chkbt_INTERMEDIATE");
												}
												else if(st=='HIGH')
												{
													//cbg[4].setVisible(true);
													cbg[4].removeCls("geo_chkbt_GRAY");
													cbg[4].removeCls("geoState_chkbt_GRAY");
													cbg[4].addCls("geo_chkbt_HIGH");

												}
												/*if(st=='GOOD')
													cbg[0].setVisible(true);
												else if(st=='UNKNOWN')
													cbg[1].setVisible(true);
												else if(st=='LOW')
													cbg[2].setVisible(true);
												else if(st=='INTERMEDIATE')
													cbg[3].setVisible(true);
												else if(st=='HIGH')
													cbg[4].setVisible(true);*/
											}
										}
										if (!Ext.isEmpty( jsonArray)){
											var idCounter = 0;
											var colorClass;
											for(var item=0; item<jsonArray.length; item++)
											{
												var jsonItem=jsonArray[item];
												var tempCon = new Array();
												tempCon.push(jsonItem.DispInfo);
												tempCon.push(jsonItem.magnitude);
												tempCon.push(jsonItem.RealInfo);
												tempCon.push(jsonItem.State);
												tempCon.push(jsonItem.CountryLAT);
												tempCon.push(jsonItem.CountryLNG);
												tempCon.push(jsonItem.LocDetails);
												tempCon.push(jsonItem.BottomLocDetails);
												tempCountryDataMap.push(tempCon);
												
												colorClass =colorArray[jsonItem.Info];

												if(jsonItem.CountryCode == 'NIL' )
													continue;
												var cntDetails = new Object();
												cntDetails.latlng = ""+jsonItem.CountryLAT+":"+jsonItem.CountryLNG;
												cntDetails.lat = jsonItem.CountryLAT;
												cntDetails.lng = jsonItem.CountryLNG;
												cntDetails.name = jsonItem.RealInfo;
												cntDetailsArray.push(cntDetails);

												
												if(counCombo != null && counCombo != 'undefined'){
													var counStore = counCombo.getStore();

													var pos = counStore.data.length;
													counStore.insert(pos, {
														displayField: jsonItem.RealInfo,
														valueField: jsonItem.RealInfo
													});
												}
												//console.log(jsonItem.DispInfo);
												
												var  mapId = Ext.getCmp('mapIds');
												if(mapId!=null && mapId!=undefined)
												{
													map = mapId.gmap;
													var markerLocation =  new google.maps.LatLng(jsonItem.CountryLAT,jsonItem.CountryLNG);

													var infobox = new InfoBox({
														content: "",
														 //disableAutoPan: true,
														 maxWidth: "340px",
														 pixelOffset: new google.maps.Size(-180, -30),
														 zIndex: null,
														 boxStyle: {
															border: "0px solid red",
															//background: "url('https://google-maps-utility-library-v3.googlecode.com/svn/trunk/infobox/examples/tipbox.gif') no-repeat",
															opacity: 0.85,
															width: "340px",
															height:"100px",
														},
														closeBoxMargin: "-6px -6px 0px 0px", //-108px -58px 2px 2px  - Normal:12px 4px 2px 2px   -58px 130px 2px 2px
														closeBoxURL: "/final/images/Light/rum-close.png",
														infoBoxClearance: new google.maps.Size(1, 1)
													});

													infoBoxArr.push(infobox);
													var marker = new MarkerWithLabel
													({
													   position: markerLocation,
													   draggable: false,
													   raiseOnDrag: false,
													   map: map,
													  // id: idCounter,
													   labelContent: '',
													  // labelContent: jsonItem.DispInfo,
													   labelAnchor: new google.maps.Point(2,8),//may be (0,5) --> if so then it display the label from center of bubble
													   labelClass: "labels", 
													   labelStyle: {opacity: 0.90, color:labelColor},
													   icon : image
													});
												}
												if(jsonItem.DispInfo == 'New Zealand')
													marker.set("labelAnchor",new google.maps.Point(28,2));
												
												markersArray.push(marker);
												var locDetailsDiv="";
												var info_height="height:100px";
												if(jsonItem.BottomLocDetails.length>3)
													info_height="height:150px";
												locDetailsDiv = locDetailsDiv+"<div id='infobox' style='width:340px;"+info_height+";'>";
												locDetailsDiv = locDetailsDiv+"<ul class='rumMapData' style='	list-style:none;margin:0px;padding:3px 0 10px 0;height:27px;border-bottom:1px solid #cccccc'>";

												locDetailsDiv = locDetailsDiv+"<li style='width:70%'><a  href='javascript:moveMapNext(\"Region\",\""+jsonItem.DispInfo+"\")' data-qclass='yellowTip' data-qtip='"+jsonItem.DispInfo+"' style='text-decoration:none;cursor:default;'><div  data-qclass='yellowTip' data-qtip='"+jsonItem.DispInfo+"' ><table cellspacing='0' cellpadding='0' border='0'><tr><td><img data-qclass='yellowTip' data-qtip='"+jsonItem.DispInfo+"' src='/final/images/clear.png' class='state_"+jsonItem.State+"' width='15' height='15' border='0' style='margin-left:5px'/></td><td style='padding:1px 0 0 5px;width:185px;font-size:18px;text-align:left;color:"+jsonItem.StateCode+" !important;white-space: nowrap'><div class='mouse' title='"+jsonItem.DispInfo+"' style='text-overflow:ellipsis;width:auto;overflow:hidden;text-align:left !important'>"+jsonItem.DispInfo+"</div></td></tr></table></div></a></li>";


												if(jsonItem.HeaderMeasureName!=null && jsonItem.HeaderMeasureName!=undefined && jsonItem.HeaderMeasureName!="")
												{
													if(!Ext.isEmpty(jsonItem.DD_URL) && jsonItem.DD_URL!=null && jsonItem.DD_URL!=undefined)
													{
														locDetailsDiv = locDetailsDiv+"<li style='width:25%;padding-top:4px;white-space:normal;display:inline-block;padding:4px 0px 0px 0px !important;float:right;text-align:right'><a style='text-decoration:none;color:#000' href='javascript:void(0)' onclick='javascript:showDDPopup(\""+jsonItem.DD_URL+"\")'><span style='font-size:17px;text-transform:lowercase;color:#000;font-weight:bold' class='rumVisitsText'>"+jsonItem.HeaderMeasureValue+"</span>&nbsp;"+jsonItem.HeaderMeasureDispName+"</a></li>";
													}
													else
													{
														locDetailsDiv = locDetailsDiv+"<li style='width:25%;padding-top:4px;white-space:normal;display:inline-block;padding:4px 0px 0px 0px !important;float:right;text-align:right'><span style='font-size:17px;text-transform:lowercase;color:#000;font-weight:bold' > "+jsonItem.HeaderMeasureValue+"</span>&nbsp;"+jsonItem.HeaderMeasureDispName+"</li>";
													}
												}

												locDetailsDiv = locDetailsDiv+"</ul><br/>";
												locDetailsDiv = locDetailsDiv+"<ul class='rumMapData' style='	list-style:none;margin:0px;padding:0px;display:inline-block;line-height:1.5em;'>";
												// Preparing the content to be shown on the popup window
												// || jsonDetailsItem.MeasureDispName == 'Apdex Score'
												for(var d=0; d<jsonItem.BottomLocDetails.length; d++)
												{
													var jsonDetailsItem=jsonItem.BottomLocDetails[d];
													if(jsonDetailsItem!=null && jsonDetailsItem!=undefined)
													{
														var mapInfoMeasure = jsonDetailsItem.MeasureDispName;
														//if(mapInfoMeasure == 'Page Requests' || mapInfoMeasure == 'Average Page Loading Time' || mapInfoMeasure == 'Error Requests' || mapInfoMeasure == 'Requests' || mapInfoMeasure == 'Errors' || mapInfoMeasure == 'Avg Page Loading Time' ||  mapInfoMeasure == 'Avg Page Load Time' || mapInfoMeasure =='Error %')
														
														if(jsonDetailsItem.MeasureUnit == 'milliseconds')
															jsonDetailsItem.MeasureUnit='ms';

														if(!Ext.isEmpty(jsonDetailsItem.DD_URL) && jsonDetailsItem.DD_URL!=null && jsonDetailsItem.DD_URL!=undefined)
														{
															locDetailsDiv = locDetailsDiv+"<li style='text-align:center;padding:3px 8px 10px 8px;white-space:normal;display:inline-block;float:left'><a style='text-decoration:none;color:#000' href='javascript:void(0)' onclick='javascript:showDDPopup(\""+jsonDetailsItem.DD_URL+"\")'><span style='font-size:17px;font-weight:bold;text-transform:lowercase;color:"+jsonDetailsItem.StateCode+" !important;' class='rumVisitsText'> "+jsonDetailsItem.MeasureValue+" "+jsonDetailsItem.MeasureUnit+" </span><br/>"+jsonDetailsItem.MeasureDispName+"</a></li>";
														}
														else
														{
															locDetailsDiv = locDetailsDiv+"<li style='text-align:center;padding:0px 5px 0px 5px;white-space:normal;display:inline-block;float:left'><span style='font-size:17px;font-weight:bold;text-transform:lowercase;color:"+jsonDetailsItem.StateCode+" !important;'> "+jsonDetailsItem.MeasureValue+" "+jsonDetailsItem.MeasureUnit+" </span><br/>"+jsonDetailsItem.MeasureDispName+"</li>";
														}
													}
												}
												
												//locDetailsDiv = locDetailsDiv+"<li style='padding:3px 5px 10px 10px;white-space:normal;display:inline-block;float:left;text-align:center'><span style='font-size:17px;text-transform:lowercase;color:#000;font-weight:bold;color:#0c9a12'> 2</span><br/>Errors(%)</li>";
												locDetailsDiv = locDetailsDiv+"</ul>";
												locDetailsDiv = locDetailsDiv+"</div>";

												if (Ext.isEmpty( jsonItem.CountryCode))
												{
													tempCon.push("No_Code");
												}
												else
												{
													tempCon.push(jsonItem.CountryCode);
													var xhr = new XMLHttpRequest();
													
													var url = "geojson/"+jsonItem.CountryCode+".geojson" ;
													//var url = "geojson/US.geojson" ;
													xhr.open('GET', url, false);
													var style = GOOD;
													if(jsonItem.State == "HIGH")
														style = HIGH;
													else if(jsonItem.State == "INTERMEDIATE")
														style = INTERMEDIATE;
													else if(jsonItem.State == "LOW")
														style = LOW;
													else if(jsonItem.State == "UNKNOWN")
														style = UNKNOWN;
													
													
													xhr.onload = function() {
														if(xhr.status == 200)
															loadGeoJSON(xhr.responseText,style,marker,infobox,markerLocation,locDetailsDiv,jsonItem.DispInfo,jsonItem.CountryLAT,jsonItem.CountryLNG,jsonItem.RealInfo,tabpanel,colorClass);
													};
													xhr.send();
												}
												
												idCounter++;
											}

											try
											{
												if(!Ext.isEmpty(google) && google!=undefined && google!=null)
												{
													/*if(listenerArray != undefined && listenerArray != null){
														for(var l=0;l<listenerArray.length;l++){
															google.maps.event.removeListener(listenerArray[l]);
														}
													}

													var zl = google.maps.event.addListener(map, 'zoom_changed',function(e)
													{
														//console.log('findAccess--->',findAccess)
														if(findAccess != undefined && findAccess != ''){
															nextMap='Region';
															cntClick(findAccess,tabpanel);
														}
														//$(".gm-style").css({'border':'1px solid #e3e3e3'});
														$("#map_canvas").css({'width':'100% !important'});
														//google.maps.event.removeListener(zl);
													});

													listenerArray.push(zl);*/
												}
											}
											catch (e)
											{
												//console.log('error-->',e)
											}
											
										}
									}
								}
							}
						});
					}

					//me.getLocationsMap().show();
					var rightMask = null;
					graphContainer.add({
						//cls:'gridSkin',
						xtype:'panel',
						margin:'0 5 0 0',
						//title:'Add Title',
						id:'graphHeatContainer',
						columnWidth:0.45,
						//title:"Load Time by Country",
						//height:'100%',
						//layout:'fit',
						//flex: 3,
						layout:{type:'vbox',align:'stretch'},
						cls:'rumDataInnerpanel rumPanelBg',
						bodyPadding:'0 0 0 0',
						border:false,
						style:{'border':'0px solid blue'},
						listeners:{
							'afterrender': function(currObj){
								/*rightMask = new Ext.LoadMask(currObj, {
									msg: "Loading..."
								});
								rightMask.show();*/
								//Ext.destroy(mainMask);
							}
						}
					});
					
					
					if (!Ext.isEmpty( jsonText))
					{
						var allJsonData = Ext.decode(jsonText);
						if (!Ext.isEmpty( allJsonData) && allJsonData!=undefined)
						{
							//if(!rumDash)
							if(flagChec)
							{
								var middlePanelArr=allJsonData.middle;
								if (!Ext.isEmpty( middlePanelArr) && middlePanelArr!=undefined)
								{
									var bb=1;
									for(var b=0;b<middlePanelArr.length;b++)
									{
										var jsonData = middlePanelArr[b];
										if( !Ext.isEmpty(jsonData.chartType) )
										{
											var dispTitle = jsonData.chartDispTitle;
											var timeTitle="<div><div class='rumDataInnerHeader' style='float:left;width:84%;line-height:16px'>"+dispTitle+"</div><div class='rumDataInnerHeaderBg' style='width:80px;text-align:center;line-height:15px;float:right'>Last 1 hour</div></div>";
											var highChartType = jsonData.chartType;
											var isAreaChart = ( highChartType.indexOf("Area") > -1 || highChartType.indexOf("area") > -1 )?"true":"false";
											var colWdt = ( highChartType == 'pie' )?0.33:0.5;
											var winWidth = Ext.getBody().getViewSize().width;
											winWidth = ( colWdt >= 0.5)?winWidth/2:winWidth/4;
											if( highChartType == 'line' || highChartType == 'area' || highChartType == 'column' || highChartType == 'stackedarea' )
											{
												var axisDispTitle = jsonData.chartDispAxisTitle;
												var iniChartCount = jsonData.iniChartCount;
												var marginValues = ( bb % 2 == 0 )?'15 5 0 0':'15 20 0 0';
												if(!Ext.isEmpty(jsonData.urls) )
												{
													var urlList = jsonData.urls;
													var errorPanel='<div class="rumErrorPanelBg" style="height:320px;display:block;padding-top:140px;"><table align="center"><tr><td><img style="margin-top:-1px" src="/final/images/spacer.gif" class="iconAlert"/></td><td>&nbsp;<span class="rumGraphErrorMsgText">No Traffic Detected</span></td><tr></table></div>';

													for(var a=0;a<jsonData.urls.length;a++)
													{
														var chartUrl = decodeURI(jsonData.urls[a]);
														var pcrefreshStr = (refresh)?"yes":"no";
														chartUrl = encodeURI(chartUrl+"&isAreaChart="+isAreaChart+'&rumRefresh='+pcrefreshStr+"&iniChartCount="+iniChartCount);
														middleChartPanel.add({
															cls:'rumDataInnerpanel',
															margin:marginValues,
															id:'lineChart'+inc,
															bodyPadding:'10 0 20 0',
															style:{'border':'0px solid red'},
															columnWidth:colWdt,
															curUrl:chartUrl,
															axisTitle:axisDispTitle,
															highCType:highChartType,
															dispLocTitle:dispTitle,
															timeLocTitle:timeTitle,
															listeners:{
																'afterrender': function(currObj){
																	var chartPId = currObj.body.id;

																	Ext.Ajax.request({
																		url:currObj.curUrl,
																		async: false,
																		timeout:300000,
																		success:function(response)
																		{
																			var jsonText = response.responseText;
																			if (!Ext.isEmpty( jsonText) && jsonText.indexOf("<HTML") == -1 )
																			{
																				var chartJsonData = Ext.decode(jsonText);
																				chartJsonData['rumChartType'] = currObj.highCType;
																				chartJsonData['rumAxisTitle'] = currObj.axisTitle;
																				chartJsonData['trimLegendUnit'] = true;
																				try
																				{
																					if(chartJsonData['max'] < 10)
																					{
																						chartJsonData['isFromRUM'] = true;
																						chartJsonData['max']=10;
																					}
																				}
																				catch (e)
																				{
																				}
																				currObj.setTitle(currObj.timeLocTitle);
																				var graphHeight = Ext.getBody().getViewSize().height-450;
																				me.createRumTimelineHighchart(chartPId,250,winWidth-80,chartJsonData,'',false);
																			}
																			else
																			{
																				currObj.setTitle(currObj.dispLocTitle);
																				currObj.setHeight(331);
																				currObj.update(errorPanel);
																			}
																		}
																	});

																}
															}
														});
														inc = inc+1;
													}
												}
											}

											if( highChartType == 'combination' )
											{
												if(!Ext.isEmpty(jsonData.urls) )
												{
													var marginValues = ( bb % 2 == 0 )?'15 5 0 0':'15 20 0 0';
													var iniChartCount = jsonData.iniChartCount;
													var urlList = jsonData.urls;
													var errorPanel='<div class="rumErrorPanelBg" style="height:320px;display:block;padding-top:140px;"><table align="center"><tr><td><img style="margin-top:-1px" src="/final/images/spacer.gif" class="iconAlert"/></td><td>&nbsp;<span class="rumGraphErrorMsgText">No Traffic Detected</span></td><tr></table></div>';

													for(var a=0;a<jsonData.urls.length;a++)
													{
														var chartUrl = decodeURI(jsonData.urls[a]);
														var crefreshStr = (refresh)?"yes":"no";
														chartUrl = encodeURI(chartUrl+"&isAreaChart="+isAreaChart+"&rumtabName=overview&rumRefresh="+crefreshStr+"&iniChartCount="+iniChartCount);
														var ctype = (a > 0 )?"column":"spline";
														middleChartPanel.add({
															cls:'rumDataInnerpanel',
															margin:marginValues,
															id:'lineChart'+inc,
															style:{'border':'0px solid blue'},
															columnWidth:colWdt,
															bodyPadding:'10 0 20 0',
															curUrl:chartUrl,
															dispLocTitle:dispTitle,
															cLoctype:ctype,
															timeLocTitle:timeTitle,
															listeners:{
																'afterrender': function(currObj){
																	var chartPId = currObj.body.id;

																	Ext.Ajax.request({
																		url:currObj.curUrl,
																		async: false,
																		timeout:300000,
																		success:function(response)
																		{
																			var jsonText = response.responseText;
																			if (!Ext.isEmpty( jsonText))
																			{
																				if( jsonText.indexOf("<HTML") == -1)
																				{
																					var chartJsonData = Ext.decode(jsonText);
																					chartJsonData['rumChartType'] = currObj.cLoctype;
																					chartJsonData['trimLegendUnit'] = true;
																					//currObj.setTitle(currObj.dispLocTitle);
																					currObj.setTitle(currObj.timeLocTitle);
																					var graphHeight = Ext.getBody().getViewSize().height-450;
																					me.createRumTimelineHighchart(chartPId,250,winWidth-80,chartJsonData,'',true);
																				}
																				else
																				{
																					currObj.setTitle(currObj.dispLocTitle);
																					currObj.setHeight(331);
																					currObj.update(errorPanel);
																				}
																			}
																		}
																	});
																}
															}
														});
														inc = inc+1;
													}
												}
											}
											else if(jsonData.chartType == 'pie')
											{
												var marginValues = ( bb % 2 == 0 )?'15 5 0 0':'15 20 0 0';
												if( !Ext.isEmpty(jsonData.pieChart) )
												{
													middleChartPanel.add({
														cls:'rumDataInnerpanel',
														columnWidth:0.5,
														id:'pieChart'+inc,
														margin:marginValues,
														style:{'border':'0px solid orange','text-align':'center !important'},
														bodyPadding:'10 0 0 0',
														autoScroll:false,
														scroll:false,
														pieData:jsonData.pieChart,
														dispLocTitle:dispTitle,
														listeners:{
															'afterrender': function(currObj){
																var pieId = currObj.body.id;
																currObj.setTitle(currObj.dispLocTitle);
																var graphHeight = Ext.getBody().getViewSize().height-450;
																winWidth = (Ext.getBody().getViewSize().width/2)-10;
																me.createRumPieHighchart(pieId,250,winWidth,currObj.pieData);
																currObj.setHeight(331);
																//me.createRumPieHighchart(pieId,220,200,jsonData.pieChart);
															}
														}
													});
													inc = inc+1;
												}
											}
										}

										bb=bb+1;
									}
								}
							}

							var bottomPanelArr=allJsonData.bottom;
							if (!Ext.isEmpty( bottomPanelArr) && bottomPanelArr!=undefined)
							{
								var currObj = Ext.getCmp('graphHeatContainer');
								var chartPId = currObj;
								var panId = currObj.id;

								for( var p=0; p < bottomPanelArr.length; p++ )
								{
									var bottomJsonData = bottomPanelArr[p];
									if( !Ext.isEmpty(bottomJsonData.chartType) )
									{
										var dispTitle = bottomJsonData.chartDispTitle;
										if(bottomJsonData.chartType == 'pie')
										{
											var winWidth = Ext.getBody().getViewSize().width;
											var piesWidth = (winWidth/2)-60;
											 piesWidth = (piesWidth/2)-60;
											var pieHeight = currObj.height-20;
											me.createRumPieHighchart(chartPId,pieHeight,piesWidth,bottomJsonData.pieChart);
											//me.createRumPieHighchart(chartPId,180,200,bottomJsonData.pieChart);
										}
										if(bottomJsonData.chartType == 'bar')
										{
											var winWidth = Ext.getBody().getViewSize().width;
											var piesWidth = winWidth/2;
											me.createRumBarHighchart(chartPId,198,piesWidth/2,bottomJsonData.barChart);
										}
										if( bottomJsonData.chartType == 'combination' || bottomJsonData.chartType.indexOf('line') > -1 )
										{
											var isCombinationChart = ( bottomJsonData.chartType == 'combination' )?true:false;
											var urlList = bottomJsonData.urls;
											if( !Ext.isEmpty(urlList) )
											{
												var chartUrl = decodeURI(urlList[0]);
												var isAreaChart = false;
												var refreshStr = (refresh)?"yes":"no";
												chartUrl = encodeURI(chartUrl+"&isAreaChart="+isAreaChart+"&rumtabName=overview&rumRefresh="+refreshStr);
												var ctype = "column";

												Ext.Ajax.request({
													url:chartUrl,
													async: false,
													success:function(response)
													{
														var jsonText = response.responseText;
														if (!Ext.isEmpty( jsonText))
														{
															var winWidth = Ext.getBody().getViewSize().width;
															var piesWidth = (winWidth/2);
															 //piesWidth = (piesWidth/2);
															var pieHeight = currObj.height-60;
															if( jsonText.indexOf("<HTML") == -1)
															{
																var chartJsonData = Ext.decode(jsonText);
																chartJsonData['rumChartType'] = ctype;
																chartJsonData['isBigCombination'] = true;
																currObj.setTitle(chartJsonData.title);
																me.createRumTimelineHighchart(chartPId,pieHeight,piesWidth,chartJsonData,'',isCombinationChart);
															}
															else
															{
																//currObj.update(jsonText);
																currObj.setTitle(dispTitle);
																currObj.setHeight(pieHeight);
																currObj.update(errMsg);
															}
														}
													}
												});
											}
										}
										else if( bottomJsonData.chartType == 'heatmap' )
										{
											if( !Ext.isEmpty( Ext.getCmp('heatGrid') ) )
											{
												var heatGridCont =  Ext.getCmp('heatGrid');
												if( !Ext.isEmpty(bottomJsonData.loop) )
												{
													var dispTitle = Ext.isEmpty ( bottomJsonData.chartDispTitle )?'':bottomJsonData.chartDispTitle; 
													var apdexVal = Ext.isEmpty ( bottomJsonData.heatApdexTitle )?'':bottomJsonData.heatApdexTitle; 
													var apdexTitle = "<table width='100%' style='height:20px'><tr><td width='60%' class='f13-bold'>"+dispTitle+"</td></tr></table>";
													
													var heatMapContent = '<table style="float:left;border:0px solid blue"><tr><td style="width:80px;vertical-align:top"><div id="mainSquareDiv" class="mainSquareDiv" style="width:80px;border:0px solid green;"></div></td><td width="*" >'+bottomJsonData.tableLabel+"</td></tr></table>";
													heatGridCont.add({
														cls:'rumDataInnerpanel',
														//style:{'border':'1px solid blue'},
														//width:250,
														width:248,
														id:'heat'+inc,
														margin:'0 15 0 0',
														//layout:'fit',
														bodyPadding:'23 0 10 0',
														autoScroll:false,
														scroll:false,
														height:'auto',
														title:apdexTitle,
														html:"<div style='float:left;border:0px solid green;padding-bottom:12px;height:34px !important;display:block !important'>"+apdexVal+"</div><div class='iconRumInfo' style='float:left;margin-left:3px;margin-top:23px' data-qclass='yellowTip' data-qtip='"+bottomJsonData.Info_Tip+"'></div><div class='crl'></div>"+heatMapContent,
														loopData:bottomJsonData.loop,
														listeners:{
															'afterrender': function(currObj){
																var measData = currObj.loopData;
																var mainDiv = jQuery('.mainSquareDiv');
																if( Ext.isEmpty( measData.notraffic ))
																{
																	if( !Ext.isEmpty(measData.satisfied) )
																	{
																		var satis = measData.satisfied;
																		if( satis > 0 )
																		{
																			for(i=0; i<satis; i++){
																				var satisfiedDivVar = $('<div></div>').addClass('satisfiedDiv');
																				mainDiv.append(satisfiedDivVar);
																			}
																		}
																	}
																	
																	
																	if( !Ext.isEmpty(measData.Tolerated) )
																	{
																		var Toler = measData.Tolerated;
																		if( Toler > 0 )
																		{
																			for(i=0; i<Toler; i++){
																				var toleratingDivVar = $('<div></div>').addClass('toleratingDiv');
																				mainDiv.append(toleratingDivVar);
																			}
																		}
																	}

																	if( !Ext.isEmpty(measData.frustrated) )
																	{
																		var frus = measData.frustrated;
																		if( frus > 0 )
																		{
																			for(i=0; i<frus; i++){
																				var frustratedDivVar = $('<div></div>').addClass('frustratedDiv'); 
																				mainDiv.append(frustratedDivVar);
																			}
																		}
																	}

																	if( !Ext.isEmpty(measData.Desktop) )
																	{
																		var satis = measData.Desktop;
																		if( satis > 0 )
																		{
																			for(i=0; i<satis; i++){
																				var desktopDivVar = $('<div></div>').addClass('desktopDiv');
																				mainDiv.append(desktopDivVar);
																			}
																		}
																	}
																	
																	
																	if( !Ext.isEmpty(measData.Mobile) )
																	{
																		var Toler = measData.Mobile;
																		if( Toler > 0 )
																		{
																			for(i=0; i<Toler; i++){
																				var mobileDivVar = $('<div></div>').addClass('mobileDiv');
																				mainDiv.append(mobileDivVar);
																			}
																		}
																	}

																	if( !Ext.isEmpty(measData.Tablet) )
																	{
																		var frus = measData.Tablet;
																		if( frus > 0 )
																		{
																			for(i=0; i<frus; i++){
																				var tabletDivVar = $('<div></div>').addClass('tabletDiv'); 
																				mainDiv.append(tabletDivVar);
																			}
																		}
																	}
																}
																else
																{
																	var notraffic = measData.notraffic;
																	if( notraffic > 0 )
																	{
																		for(i=0; i<notraffic; i++){
																			var notrafficDivVar = $('<div></div>').addClass('notrafficDiv');
																			mainDiv.append(notrafficDivVar);
																		}
																	}
																}
															}
														}
													});
													inc = inc+1;
												}
												else
												{
													var dispTitle = Ext.isEmpty ( bottomJsonData.chartDispTitle )?'':bottomJsonData.chartDispTitle; 
													var heatMapContent = '<div style="font-size:12px;height:23px !important;display:block !important"><span class="f16-bold" >N/A</span> Apdex</div><table style="border:0px solid blue;"><tr><td style="width:80px;vertical-align:top" ><div id="mainSquareDiv" class="mainSquareDiv" style="width:80px;border:0px solid green;"></div></td><td width="*" style="padding-left:3px"><div><ul class="report-tripple-data"><li class="li_triple_data"><span class="percentage" style="text-align:right;width:47px;display:inline-block">0% - </span><span>&nbsp;&nbsp;Satisfied<em>(0)</em></span></li><li class="li_triple_data"><span class="percentage" style="text-align:right;width:47px;display:inline-block">0% - </span><span>&nbsp;&nbsp;Tolerated<em>(0)</em></span></li><li class="li_triple_data"><span class="percentage" style="text-align:right;width:47px;display:inline-block">0% - </span><span>&nbsp;&nbsp;Frustrated<em>(0)</em></span></li></ul></div></td></tr></table>';
													heatGridCont.add({
														cls:'rumDataInnerpanel',
														style:{'border':'0px solid red'},
														width:270,
														id:'heat'+inc,
														margin:'0 15 0 0',
														bodyPadding:'45 0 10 0',
														autoScroll:false,
														scroll:false,
														height:198,
														title:dispTitle,
														html:heatMapContent,
														loopData:bottomJsonData.loop,
														listeners:{
															'afterrender': function(currObj){
															var mainDiv = jQuery('.mainSquareDiv');
															for(i=0; i<100; i++){
																var notrafficDivVar = $('<div></div>').addClass('notrafficDiv');
																mainDiv.append(notrafficDivVar);
															}
															}
														}
													});
												}
											}
										}
									}
									else if( !Ext.isEmpty(bottomJsonData.gridNo) )
									{
										if( bottomJsonData.gridNo == 1)
										{
											if( !Ext.isEmpty(bottomJsonData.columns) )
											{
												var gridJson = bottomJsonData;
												if(!Ext.isEmpty(gridJson.fields))
												{
													Ext.define('processModel',{
													extend: 'Ext.data.Model',
													fields:gridJson.fields
													});
	
													gridColumn = gridJson.fields;
													var processStore = Ext.create('Ext.data.Store', {
														model: 'processModel',
														autoLoad: true,
														proxy: {
															type: 'memory',
															data: gridJson.data
														},
														sortOnLoad : true,
														sorters : {
															property : gridJson.SortBy,
															direction : 'DESC'
														}
													});
													
													
													var tempGrid=Ext.create('Ext.grid.Panel', {
														//title:gridJson.gridTitle,
														store: processStore,
														//defaults:{width:250},
														columns: gridJson.columns,
														//style:{'border':'0px solid red !important'},
														//cls:'rumGridSkin',
														ui:'newGridPanel',
														stateful: true,
														//flex:1,
														border:true,
															id:'tempGrid',
														//width:500,
														stateId:'loadCountry',
														margin:'7 0 7 0',
														width:'100%',
														//width:Ext.getBody().getViewSize().width-630,
														autoScroll:true,
														scroll:true,
														//forceFit: true,
														layout:'fit',
														//flex:1,
														//layout:{type:'anchor'},
														height:160,
														viewConfig: {    
															//forceFit: true,  
															//layout:'fit',
															//style:{'overflow-x':'auto !important','overflow-y':'auto !important'},
															//style:{'overflow-x':'auto !important'},
														},

														//margin:'0 6 6 6',
														//width: Ext.getBody().getViewSize().width-130,
														//height: Ext.getBody().getViewSize().height-130
													});

													var tempPanel={
														xtype:'panel',
														layout:'column',
														style:{'padding':'0 0 0 0 !important','border':'0px solid yellow'},
														height:198,
														autoScroll:false,
														scroll:false,
														id:'heatGrid',
														items:[
														]
													};
													currObj.setTitle(gridJson.gridTitle);
													currObj.add(tempGrid);
													currObj.add(tempPanel);
												}
												else
												{
													currObj.add({
														cls:'rumDataInnerpanel',
														margin:'0 5 0 0',
														//title:'Add Title',
														id:'gridContainer'+p,
														columnWidth:0.5,
														//title:"Locations details",
														height:370,	
														bodyPadding:'16 0 0 0',
														style:{'border':'0px solid yellow'},
														html:'<div class="rumErrorPanelBg" style="height:320px;display:block;padding-top:140px;"><table align="center"><tr><td><img style="margin-top:-1px" src="/final/images/spacer.gif" class="iconAlert"/></td><td>&nbsp;<span class="rumGraphErrorMsgText">No Traffic Detected</span></td><tr></table></div>',
													});

													var tempPanel={
														xtype:'container',
														layout:'column',
														id:'heatGrid',
														style:{'border':'0px solid yellow'},
														height:190,
														autoScroll:false,
														scroll:false,
														items:[]
													};
													currObj.add(tempPanel);
												}
											}
											else
											{
												Ext.create('Ext.panel.Panel', {
													layout:'',
													id:'errorPanel',
													margin:'0 0 0 0',
													style:{'border':'0px solid red'},
													items:[]
												});

												var errorPanel=Ext.getCmp("errorPanel");

												currObj.add({
													cls:'rumDataInnerpanel',
													margin:'0 5 0 0',
													title:"Top N Countries by Performance",
													//title:'Add Title',
													id:'gridContainer'+p,
													columnWidth:0.6,
													height:190,	
													bodyPadding:'10 0 0 0',
													style:{'border':'0px solid yellow'},
													html:'<div class="rumErrorPanelBg" style="height:170px;display:block;padding-top:60px;"><table align="center"><tr><td><img style="margin-top:-1px" src="/final/images/spacer.gif" class="iconAlert"/></td><td>&nbsp;<span class="rumGraphErrorMsgText">No Traffic Detected</span></td><tr></table></div>',
												});

												var tempPanel={
													xtype:'container',
													layout:'column',
													id:'heatGrid',
													style:{'border':'0px solid yellow'},
													height:190,
													autoScroll:false,
													scroll:false,
													items:[]
												};
												currObj.add(tempPanel);
											}
										}
										else if( bottomJsonData.gridNo > 2 )
										{
											if( !Ext.isEmpty( Ext.getCmp('heatGrid') ) )
											{
												var heatGridCont =  Ext.getCmp('heatGrid');
												if( !Ext.isEmpty(bottomJsonData.columns) )
												{
													var gridJson = bottomJsonData;
													if(!Ext.isEmpty(gridJson.fields))
													{
														Ext.define('browsersModel',{
														extend: 'Ext.data.Model',
														fields:gridJson.fields
														});

														var browsersStore = Ext.create('Ext.data.Store', {
															model: 'browsersModel',
															autoLoad: true,
															proxy: {
																type: 'memory',
																data: gridJson.data
															}
														});

														var tempGrid=Ext.create('Ext.grid.Panel', {
															//title:gridJson.gridTitle,
															store: browsersStore,
															//defaults:{width:250},
															columns: gridJson.columns,
															columnWidth:1.0,
															margin:'7 0 0 0',
															//style:{'border':'0px solid blue !important'},
															//cls:'rumGridSkin',
															ui:'newGridPanel',
															//flex:1,
															border:true,
															stateId:'grpRequest',
															stateful: true,
															//width:'auto',
															scroll:true,
															autoScroll:true,
															//forceFit:false,
															layout:'fit',
															height:160,
															viewConfig: {  
																//style:{'overflow-y':'hidden !important'},
																//style:{'overflow-x':'hidden !important'},
																//forceFit: true,  
																//layout:'fit',
															},

															//margin:'0 6 6 6',
															//width: Ext.getBody().getViewSize().width-130,
															//height: Ext.getBody().getViewSize().height-130
														});
														Ext.create('Ext.panel.Panel', {
															title:gridJson.gridTitle,
															columnWidth:1.0,
															id:'heattitleGrid',
															margin:'0 0 0 0',
															style:{'border':'0px solid red'},
															height:198,
															layout:'fit',
															autoScroll:false,
															scroll:false,
															items:[]
														});
														var gridTitlePanel = Ext.getCmp('heattitleGrid');
														gridTitlePanel.add(tempGrid);
														//heatGridCont.add(tempGrid);
														heatGridCont.add(gridTitlePanel);
														//gridTitlePanel.add(tempGrid);
														//heatGridCont.setTitle("skldfsfjklsdfjkl");
													}
													else
													{
														heatGridCont.add({
														cls:'rumDataInnerpanel',
														margin:'0 0 0 0',
														//title:'Add Title',
														id:'gridContainer'+p,
														columnWidth:1.0,
														title:"Load by Page Groups",
														height:120,	
														bodyPadding:'16 0 0 0',
														style:{'border':'0px solid yellow'},
														html:'<table style="margin:20% auto" align="center"><tr><td><img style="margin-top:-1px" src="/final/images/spacer.gif" class="iconAlert"/></td><td>&nbsp;<span class="rumGraphErrorMsgText">No Traffic Detected</span></td><tr></table>',
														});
													}
												}
												else
												{
													Ext.create('Ext.panel.Panel', {
															title:"Load by Page Groups",
															columnWidth:1.0,
															id:'errorPanel',
															margin:'0 0 0 0',
															style:{'border':'0px solid red'},
															items:[]
														});

													var errorPanel=Ext.getCmp("errorPanel");

													heatGridCont.add(errorPanel);

													errorPanel.add({
														cls:'rumErrorPanelBg',
														margin:'0 5 0 0',
														//title:'Add Title',
														id:'gridContainer'+p,
														columnWidth:1.0,
														height:200,
														margin:'10 0 0 0',
														bodyPadding:'16 0 0 0',
														style:{'border':'0px solid yellow'},
														html:'<table style="margin:20% auto" align="center"><tr><td><img style="margin-top:-1px" src="/final/images/spacer.gif" class="iconAlert"/></td><td>&nbsp;<span class="rumGraphErrorMsgText">No Traffic Detected</span></td><tr></table>',
													});
												}
											}
										}
									}
								}

								if(rumDash)
								{
									var button  = Ext.create('Ext.Button', {
										text: 'Load More',
										id : 'loadMoreDet',
										height:20,
										width:70,
										style:{'float':'right', 'margin-right':'10px'},
										handler: function() {
												this.setVisible(false);
												var middlePanelArr=allJsonData.middle;
												if (!Ext.isEmpty( middlePanelArr) && middlePanelArr!=undefined)
												{
													var bb=1;
													for(var b=0;b<middlePanelArr.length;b++)
													{
														var jsonData = middlePanelArr[b];
														if( !Ext.isEmpty(jsonData.chartType) )
														{
															var dispTitle = jsonData.chartDispTitle;
															var timeTitle="<div><div class='rumDataInnerHeader' style='float:left;width:84%;line-height:16px'>"+dispTitle+"</div><div class='rumDataInnerHeaderBg' style='width:80px;text-align:center;line-height:15px;float:right'>Last 1 hour</div></div>";
															var highChartType = jsonData.chartType;
															var isAreaChart = ( highChartType.indexOf("Area") > -1 || highChartType.indexOf("area") > -1 )?"true":"false";
															var colWdt = ( highChartType == 'pie' )?0.33:0.5;
															var winWidth = Ext.getBody().getViewSize().width;
															winWidth = ( colWdt >= 0.5)?winWidth/2:winWidth/4;
															if( highChartType == 'line' || highChartType == 'area' || highChartType == 'column' || highChartType == 'stackedarea' )
															{
																var axisDispTitle = jsonData.chartDispAxisTitle;
																var iniChartCount = jsonData.iniChartCount;
																var marginValues = ( bb % 2 == 0 )?'15 5 0 0':'15 20 0 0';
																if(!Ext.isEmpty(jsonData.urls) )
																{
																	var urlList = jsonData.urls;
																	var errorPanel='<div class="rumErrorPanelBg" style="height:320px;display:block;padding-top:140px;"><table align="center"><tr><td><img style="margin-top:-1px" src="/final/images/spacer.gif" class="iconAlert"/></td><td>&nbsp;<span class="rumGraphErrorMsgText">No Traffic Detected</span></td><tr></table></div>';

																	for(var a=0;a<jsonData.urls.length;a++)
																	{
																		var chartUrl = decodeURI(jsonData.urls[a]);
																		var pcrefreshStr = (refresh)?"yes":"no";
																		chartUrl = encodeURI(chartUrl+"&isAreaChart="+isAreaChart+'&rumRefresh='+pcrefreshStr+"&iniChartCount="+iniChartCount);
																		middleChartPanel.add({
																			cls:'rumDataInnerpanel',
																			margin:marginValues,
																			id:'lineChart'+inc,
																			bodyPadding:'10 0 20 0',
																			style:{'border':'0px solid red'},
																			columnWidth:colWdt,
																			curUrl:chartUrl,
																			axisTitle:axisDispTitle,
																			highCType:highChartType,
																			dispLocTitle:dispTitle,
																			timeLocTitle:timeTitle,
																			listeners:{
																				'afterrender': function(currObj){
																					var chartPId = currObj.body.id;

																					Ext.Ajax.request({
																						url:currObj.curUrl,
																						async: false,
																						timeout:300000,
																						success:function(response)
																						{
																							var jsonText = response.responseText;
																							if (!Ext.isEmpty( jsonText) && jsonText.indexOf("<HTML") == -1 )
																							{
																								var chartJsonData = Ext.decode(jsonText);
																								chartJsonData['rumChartType'] = currObj.highCType;
																								chartJsonData['rumAxisTitle'] = currObj.axisTitle;
																								chartJsonData['trimLegendUnit'] = true;
																								currObj.setTitle(currObj.timeLocTitle);
																								var graphHeight = Ext.getBody().getViewSize().height-450;
																								me.createRumTimelineHighchart(chartPId,250,winWidth-80,chartJsonData,'',false);
																							}
																							else
																							{
																								currObj.setTitle(currObj.dispLocTitle);
																								currObj.setHeight(331);
																								currObj.update(errorPanel);
																							}
																						}
																					});
																				}
																			}
																		});
																		inc = inc+1;
																	}
																}
															}

															if( highChartType == 'combination' )
															{
																if(!Ext.isEmpty(jsonData.urls) )
																{
																	var marginValues = ( bb % 2 == 0 )?'15 5 0 0':'15 20 0 0';
																	var iniChartCount = jsonData.iniChartCount;
																	var urlList = jsonData.urls;
																	var errorPanel='<div class="rumErrorPanelBg" style="height:320px;display:block;padding-top:140px;"><table align="center"><tr><td><img style="margin-top:-1px" src="/final/images/spacer.gif" class="iconAlert"/></td><td>&nbsp;<span class="rumGraphErrorMsgText">No Traffic Detected</span></td><tr></table></div>';

																	for(var a=0;a<jsonData.urls.length;a++)
																	{
																		var chartUrl = decodeURI(jsonData.urls[a]);
																		var crefreshStr = (refresh)?"yes":"no";
																		chartUrl = encodeURI(chartUrl+"&isAreaChart="+isAreaChart+"&rumtabName=overview&rumRefresh="+crefreshStr+"&iniChartCount="+iniChartCount);
																		var ctype = (a > 0 )?"column":"spline";
																		middleChartPanel.add({
																			cls:'rumDataInnerpanel',
																			margin:marginValues,
																			id:'lineChart'+inc,
																			style:{'border':'0px solid blue'},
																			columnWidth:colWdt,
																			bodyPadding:'10 0 20 0',
																			curUrl:chartUrl,
																			dispLocTitle:dispTitle,
																			cLoctype:ctype,
																			timeLocTitle:timeTitle,
																			listeners:{
																				'afterrender': function(currObj){
																					var chartPId = currObj.body.id;
																					Ext.Ajax.request({
																						url:currObj.curUrl,
																						async: false,
																						timeout:300000,
																						success:function(response)
																						{
																							var jsonText = response.responseText;
																							if (!Ext.isEmpty( jsonText))
																							{
																								if( jsonText.indexOf("<HTML") == -1)
																								{
																									var chartJsonData = Ext.decode(jsonText);
																									chartJsonData['rumChartType'] = currObj.cLoctype;
																									chartJsonData['trimLegendUnit'] = true;
																									//currObj.setTitle(currObj.dispLocTitle);
																									currObj.setTitle(currObj.timeLocTitle);
																									var graphHeight = Ext.getBody().getViewSize().height-450;
																									me.createRumTimelineHighchart(chartPId,250,winWidth-80,chartJsonData,'',true);
																								}
																								else
																								{
																									currObj.setTitle(currObj.dispLocTitle);
																									currObj.setHeight(331);
																									currObj.update(errorPanel);
																								}
																							}
																						}
																					});
																				}
																			}
																		});
																		inc = inc+1;
																	}
																}
															}
															else if(jsonData.chartType == 'pie')
															{
																var marginValues = ( bb % 2 == 0 )?'15 5 0 0':'15 20 0 0';
																if( !Ext.isEmpty(jsonData.pieChart) )
																{
																	middleChartPanel.add({
																		cls:'rumDataInnerpanel',
																		columnWidth:0.5,
																		id:'pieChart'+inc,
																		margin:marginValues,
																		style:{'border':'0px solid orange','text-align':'center !important'},
																		bodyPadding:'10 0 0 0',
																		autoScroll:false,
																		scroll:false,
																		pieData:jsonData.pieChart,
																		dispLocTitle:dispTitle,
																		listeners:{
																			'afterrender': function(currObj){
																				var pieId = currObj.body.id;
																				currObj.setTitle(currObj.dispLocTitle);
																				var graphHeight = Ext.getBody().getViewSize().height-450;
																				winWidth = (Ext.getBody().getViewSize().width/2)-10;
																				me.createRumPieHighchart(pieId,250,winWidth,currObj.pieData);
																				currObj.setHeight(331);
																				//me.createRumPieHighchart(pieId,220,200,jsonData.pieChart);
																			}
																		}
																	});
																	inc = inc+1;
																}
															}
														}

														bb=bb+1;
													}
												}
										}
									});
									currObj.add(button);
								}
							}
						}
					}
				}
			});
			if(mainMask != null && mainMask != undefined && mainMask != 'undefined')
			{
				var task = new Ext.util.DelayedTask(function() {
					Ext.destroy(mainMask);
					task=null;
				});
				task.delay(3000);
				//setTimeout(timoutMethod(mainMask),13000);
				//setTimeout(Ext.bind(me.timoutMethod(mainMask), me), 13000);
			}
		}
		//this.getRumTabPanel().setScrollBarposition(topPoc);
		
	},
	loadSubMap:function(cname,tabpanel,region,cenPos){
		tabBackUp = tabpanel;
		findAccess = undefined;
		tempCountryMap = new Array();
		tempCountryDataMap = new Array();
		var checkMap = Ext.getCmp('mapIds');

		

		var counCombo = document.getElementById('countryCombo');
		var regCombo = document.getElementById('regionCombo');

		var regCombo = Ext.getCmp('regionCombo');
		var counCombo = Ext.getCmp('countryCombo');
		
		//counCombo.disabled=false;
		//regCombo.disabled=false;
		if(counCombo != null && counCombo != undefined && nextMap == 'Region'){
			
			if(cname.indexOf("-") != -1)
			{
				cname = cname.substring(cname.indexOf("-")+1);
				cname = cname.trim();
			}
			//counCombo.value=cname;
			counCombo.setValue(cname);
		}
		
		if(regCombo != null && regCombo != 'undefined' && nextMap =='City' && region != undefined ){
			//regCombo.value = region;
			regCombo.setValue(region);
		}
		
		var cbg = Ext.getCmp('barCheckBoxPanel').items.items[0].items.items;
		for(var p=0;p<cbg.length;p++)
			cbg[p].setVisible(false);

		Ext.getCmp('locationmap').setVisible(false);

		if(checkMap != undefined && checkMap != 'undefined'){
			var mapObj = checkMap.gmap;
			for (var j = 0; j < prevFeaturesArray.length; j++){
				var features = prevFeaturesArray[j];
				if(features == null || features == undefined)
					continue;
				// Loop through each feature
				for (var i = 0; i < features.length; i++)
					 features[i].setMap(null);
			}
			prevFeaturesArray = new Array();
			for (var j = 0; j < markersArray.length; j++){
				var mak = markersArray[j];

				if(mak == null  || mak == undefined)
					continue;

				//mak.labelContent='';
				mak.setMap(null);
			}
			markersArray = new Array();

			for (var j = 0; j < iconMarkerArray.length; j++){
				var mak = iconMarkerArray[j];

				if(mak == null  || mak == undefined)
					continue;

				//mak.labelContent='';
				mak.setMap(null);
			}
			iconMarkerArray = new Array();
			for (var j = 0; j < infoBoxArr.length; j++){
				var inf = infoBoxArr[j];

				if(inf == null  || inf == undefined)
					continue;

				//mak.labelContent='';
				inf.setMap(null);
			}
			infoBoxArr = new Array();
		}
		var mapObj = Ext.getCmp('mapIds').gmap;
		
		var site_name = siteNameGl;
		refreshMapObject = new Object();
		refreshMapObject.name = cname;
		refreshMapObject.tabPl = tabpanel;
		refreshMapObject.region = region;

		var url = encodeURI('/final/servlet/com.eg.RUMController?accessType=overviewMap1&site='+site_name+'&reqfrom='+nextMap+'&countryName='+cname+'');
		if(nextMap=='City')
			url = url+'&region='+region;
		if(nextMap == 'Country'){
			nextMap = 'Region';
			isCityMap= false;
		}
		Ext.Ajax.request(
		{
			url : url,
			scope:this,
			success: function(response) 
			{
				if(response.status == 200 && !Ext.isEmpty(response))
				{
					regionDetailsArray = [];
					cntDetailsArray = new Array();
					var jsonText = response.responseText;
					if (!Ext.isEmpty( jsonText))
					{
						var innerJsonData = Ext.decode(jsonText);

						if (!Ext.isEmpty( innerJsonData.NoData ))
						{
							var geoLoadingDivObj=document.getElementById("geoLoadingDiv");
							if(geoLoadingDivObj!=null && geoLoadingDivObj!=undefined)
							{
								geoLoadingDivObj.style.display="none";
							}

							var geoNoDataDivObj = document.getElementById("geoNoDataDiv");
							if(geoNoDataDivObj!=null && geoNoDataDivObj!=undefined)
							{
								geoNoDataDivObj.style.display="block";
							}
						}
						else if (!Ext.isEmpty( innerJsonData.resultArray ))
						{
							var jsonArray=innerJsonData.resultArray;
							var totScale=innerJsonData.overAllScale;

							var stateArray = innerJsonData.stateArray;
							var colorArray = innerJsonData.colorArray;

							
							
							if(!Ext.isEmpty( stateArray)){
								
								var cbg = Ext.getCmp('barCheckBoxPanel').items.items[0].items.items;
								for(var p=0;p<cbg.length;p++)
								{
									cbg[p].removeCls("geoState_chkbt_GOOD");
									cbg[p].removeCls("geoState_chkbt_UNKNOWN");
									cbg[p].removeCls("geoState_chkbt_LOW");
									cbg[p].removeCls("geoState_chkbt_INTERMEDIATE");
									cbg[p].removeCls("geoState_chkbt_HIGH");

									cbg[p].addCls("geoState_chkbt_GRAY");
									cbg[p].setVisible(true);
									cbg[p].setDisabled(true);
									cbg[p].reset();
								}

								for(var i=0;i<stateArray.length;i++){
									var st=stateArray[i];
									if(st=='GOOD')
									{
										//cbg[0].setVisible(true);
										cbg[0].removeCls("geo_chkbt_GRAY");
										cbg[0].removeCls("geoState_chkbt_GRAY");
										cbg[0].addCls("geo_chkbt_GOOD");
									}
									else if(st=='UNKNOWN')
									{
										//cbg[1].setVisible(true);
										cbg[1].removeCls("geo_chkbt_GRAY");
										cbg[1].removeCls("geoState_chkbt_GRAY");
										cbg[1].addCls("geo_chkbt_UNKNOWN");
									}
									else if(st=='LOW')
									{
										//cbg[2].setVisible(true);
										cbg[2].removeCls("geo_chkbt_GRAY");
										cbg[2].removeCls("geoState_chkbt_GRAY");
										cbg[2].addCls("geo_chkbt_LOW");
									}
									else if(st=='INTERMEDIATE')
									{
										//cbg[3].setVisible(true);
										cbg[3].removeCls("geo_chkbt_GRAY");
										cbg[3].removeCls("geoState_chkbt_GRAY");
										cbg[3].addCls("geo_chkbt_INTERMEDIATE");
									}
									else if(st=='HIGH')
									{
										//cbg[4].setVisible(true);
										cbg[4].removeCls("geo_chkbt_GRAY");
										cbg[4].removeCls("geoState_chkbt_GRAY");
										cbg[4].addCls("geo_chkbt_HIGH");
									}
								}
							}


							totalCounts = jsonArray.length;
							var idCounter = 0;
							var colorClass;
							var allUnknown = true;
							for(var item=0; item<jsonArray.length; item++)
							{
								var jsonItem=jsonArray[item];
								var info_text = jsonItem.RealInfo;
								try
								{
									info_text = info_text.trim();
									var res = info_text.toLowerCase();
									if(res.indexOf('unknown') != -1)
									{
										totalCounts = totalCounts-1;
										continue;
									}
								}
								catch (e)
								{
								}
								allUnknown = false;
								jsonItem.overAllScale = innerJsonData.overAllScale;
								tempCountryDataMap.push(jsonItem);
								colorJson = colorArray;
								colorClass =colorArray[jsonItem.Info];
								var geocoderObj = new google.maps.Geocoder();
								var jsonInfo = jsonItem.Info;
								if(jsonInfo.indexOf("+") > -1)
									jsonInfo = jsonInfo.substring(1);
								geocoderObj.geocode( { 'address':jsonInfo},function(results, status) {
								if ( ( status == google.maps.GeocoderStatus.OK || jsonItem.CountryLAT ) && results != undefined && results[0] != undefined ) 
								{
									tempCountryMap.push(results[0]);
									colorClassArray.push(colorClass);
								}else
									totalCounts = totalCounts-1;

									callbackfunction(tabpanel,cenPos);
								});
							} // END OF FOR LOOP
							
							if(allUnknown)
							{
								if(nextMap=='City')
								{
									var regCombo = Ext.getCmp('regionCombo');
									var counCombo = Ext.getCmp('countryCombo');
									var countryComboVal = counCombo.getValue();
									regCombo.setValue('All');
									nextMap = 'Region';
									isCityMap = false;
									cntClick(countryComboVal,tabBackUp,null,true);
									regCombo.setDisabled(false);
									//regCombo.setValue('All');
								}
								else
								{
									var regCombo = Ext.getCmp('regionCombo');
									var counCombo = Ext.getCmp('countryCombo');
									var countryComboVal = counCombo.getValue();
									counCombo.setValue('All');
									this.loadCountryMap(tabpanel);
								}
								return;
							}
							var gridDatatmp = Ext.getCmp('tempGrid');
							var jsonGrid= innerJsonData.gridData;
							if(gridDatatmp != null && gridDatatmp != undefined && jsonGrid != undefined){
								
								var prev_pro =jsonGrid.SortBy;
								var prev_dir = 'DESC';
								try
								{
									if(gridDatatmp.sort != undefined){
										prev_pro = gridDatatmp.sort.property;
										prev_dir = gridDatatmp.sort.direction;
									}
								}
								catch (e)
								{
									prev_pro =jsonGrid.SortBy;
									prev_dir = 'DESC';
								}
								//gridColumn
								var dbGridStore=Ext.create('Ext.data.Store',{
									fields:jsonGrid.fields,
									autoDestroy:true,
									proxy: {
										type: 'memory',
										reader: {
											type: 'json',
											root:'items'
										}
									},
									data:jsonGrid.data,
									sorters : {
										property : prev_pro,
										//property : jsonGrid.SortBy,
										direction : prev_dir,
										//direction : 'DESC'
									}
								});
								gridDatatmp.reconfigure(dbGridStore);
								//gridDatatmp.reconfigure(dbGridStore,jsonGrid.columns);
								var currObj = Ext.getCmp('graphHeatContainer');
								//currObj.setTitle('3245=-09876345');
								//console.log('jsonGrid.title------>',jsonGrid.gridTitle)
								currObj.setTitle(jsonGrid.gridTitle);
							}
						}
					}
					else{
						this.loadCountryMap(tabpanel);
					}
				}
			}
		});
		
	},
	loadCountryMap:function(tabpanel){
		
		tempCountryMap = new Array();
		tempCountryDataMap = new Array();
		var checkMap = Ext.getCmp('mapIds');
		findAccess = undefined;
		if(checkMap != undefined && checkMap != 'undefined')
			var mapObj = checkMap.gmap;

			for (var j = 0; j < iconMarkerArray.length; j++){
				var mak = iconMarkerArray[j];

				if(mak == null  || mak == undefined)
					continue;

				//mak.labelContent='';
				mak.setMap(null);
			}
			iconMarkerArray = new Array();

			for (var j = 0; j < prevFeaturesArray.length; j++){
				var features = prevFeaturesArray[j];
				if(features == null || features == undefined)
					continue;
				// Loop through each feature
				for (var i = 0; i < features.length; i++)
					 features[i].setMap(null);
			}
			prevFeaturesArray = new Array();
			for (var j = 0; j < markersArray.length; j++){
				var mak = markersArray[j];

				if(mak == null  || mak == undefined)
					continue;

				//mak.labelContent='';
				mak.setMap(null);
			}
			markersArray = new Array();

			for (var j = 0; j < infoBoxArr.length; j++){
				var inf = infoBoxArr[j];

				if(inf == null  || inf == undefined)
					continue;

				//mak.labelContent='';
				inf.setMap(null);
			}
			infoBoxArr = new Array();
	
		
		var site_name=siteNameGl;
		var url = encodeURI('/final/servlet/com.eg.RUMController?accessType=overviewMap&site='+site_name+'&tabName=rumOverview&fromService='+fromSerFlag);

		var counCombo = Ext.getCmp('countryCombo');
		var regCombo = Ext.getCmp('regionCombo');
		
		if(counCombo != null && counCombo != 'undefined'){
			var counStore = counCombo.getStore();

			counStore.removeAll();
			counStore.loadRawData('');
			counStore.insert(0, {
				displayField: 'All',
				valueField: 'All'
			});
			counCombo.setValue('All');
		}

		if(regCombo != null && regCombo != 'undefined'){
			var regStore = regCombo.getStore();
			regStore.removeAll();
			regStore.loadRawData('');
			regStore.insert(0, {
				displayField: 'All',
				valueField: 'All'
			});
			regCombo.setValue('All');
		}

		Ext.Ajax.request(
		{
			url : url,
			scope:this,
			success: function(response) 
			{
				if(response.status == 200 && !Ext.isEmpty(response))
				{
					var jsonText = response.responseText;
					if (!Ext.isEmpty( jsonText))
					{
						var mapId = Ext.getCmp('mapIds');
						if(!Ext.isEmpty(mapId) && mapId!=undefined && mapId!=null)
						{
						map = mapId.gmap;
						map.setZoom(1);
						map.setCenter(new google.maps.LatLng(40.3780, 10.4359));
						nextMap = 'Region';
						//map.setOptions({draggable: false});
						}
						var innerJsonData = Ext.decode(jsonText);

						var jsonArray=innerJsonData.resultArray;
						var totScale=innerJsonData.overAllScale;
						cntDetailsArray = [];
						var stateArray = innerJsonData.stateArray;
						var colorArray = innerJsonData.colorArray;
						if(!Ext.isEmpty( stateArray)){
							var cbg = Ext.getCmp('barCheckBoxPanel').items.items[0].items.items;
							for(var p=0;p<cbg.length;p++)
							{
									cbg[p].removeCls("geoState_chkbt_GOOD");
									cbg[p].removeCls("geoState_chkbt_UNKNOWN");
									cbg[p].removeCls("geoState_chkbt_LOW");
									cbg[p].removeCls("geoState_chkbt_INTERMEDIATE");
									cbg[p].removeCls("geoState_chkbt_HIGH");

									cbg[p].addCls("geoState_chkbt_GRAY");
									cbg[p].setVisible(true);
									cbg[p].setDisabled(true);
									cbg[p].reset();
							}
							for(var i=0;i<stateArray.length;i++){
								var st=stateArray[i];
								if(st=='GOOD')
								{
									//cbg[0].setVisible(true);
									cbg[0].removeCls("geo_chkbt_GRAY");
									cbg[0].removeCls("geoState_chkbt_GRAY");
									cbg[0].addCls("geo_chkbt_GOOD");
								}
								else if(st=='UNKNOWN')
								{
									//cbg[1].setVisible(true);
									cbg[1].removeCls("geo_chkbt_GRAY");
									cbg[1].removeCls("geoState_chkbt_GRAY");
									cbg[1].addCls("geo_chkbt_UNKNOWN");
								}
								else if(st=='LOW')
								{
									//cbg[2].setVisible(true);
									cbg[2].removeCls("geo_chkbt_GRAY");
									cbg[2].removeCls("geoState_chkbt_GRAY");
									cbg[2].addCls("geo_chkbt_LOW");
								}
								else if(st=='INTERMEDIATE')
								{
									//cbg[3].setVisible(true);
									cbg[3].removeCls("geo_chkbt_GRAY");
									cbg[3].removeCls("geoState_chkbt_GRAY");
									cbg[3].addCls("geo_chkbt_INTERMEDIATE");
								}
								else if(st=='HIGH')
								{
									//cbg[4].setVisible(true);
									cbg[4].removeCls("geo_chkbt_GRAY");
									cbg[4].removeCls("geoState_chkbt_GRAY");
									cbg[4].addCls("geo_chkbt_HIGH");
								}
							}
						}

						if (!Ext.isEmpty( jsonArray)){
							var idCounter = 0;
							var colorClass;
							Ext.getCmp('locationmap').setVisible(true);
							for(var item=0; item<jsonArray.length; item++)
							{
								var jsonItem=jsonArray[item];
								try
								{
									var temp = jsonItem.DispInfo;
									if(!Ext.isEmpty(temp)){
										var lower_temp = temp.toLowerCase();	
										if(lower_temp.indexOf('unknown') != -1)
											continue;
									}
								}
								catch (e)
								{
								}
								
								var tempCon = new Array();
								tempCon.push(jsonItem.DispInfo);
								tempCon.push(jsonItem.magnitude);
								tempCon.push(jsonItem.RealInfo);
								tempCon.push(jsonItem.State);
								tempCon.push(jsonItem.CountryLAT);
								tempCon.push(jsonItem.CountryLNG);
								tempCon.push(jsonItem.LocDetails);
								tempCon.push(jsonItem.BottomLocDetails);
								tempCountryDataMap.push(tempCon);
								
								colorClass =colorArray[jsonItem.Info];

								if(jsonItem.CountryCode == 'NIL' )
									continue;
								
								var cntDetails = new Object();
								cntDetails.latlng = ""+jsonItem.CountryLAT+":"+jsonItem.CountryLNG;
								cntDetails.lat = jsonItem.CountryLAT;
								cntDetails.lng = jsonItem.CountryLNG;
								cntDetails.name = jsonItem.RealInfo;
								cntDetailsArray.push(cntDetails);

								if(counCombo != null && counCombo != 'undefined'){
									var counStore = counCombo.getStore();

									var pos = counStore.data.length;
									counStore.insert(pos, {
										displayField: jsonItem.RealInfo,
										valueField: jsonItem.RealInfo
									});
								}
								
								if(!Ext.isEmpty(mapId) && mapId!=undefined && mapId!=null)
								{
								var markerLocation =  new google.maps.LatLng(jsonItem.CountryLAT,jsonItem.CountryLNG);

								var infobox = new InfoBox({
									content: "",
									 maxWidth: "300px",
									 pixelOffset: new google.maps.Size(-180, -30),
									 zIndex: null,
									 boxStyle: {
										border: "0px solid red",
										//background: "url('https://google-maps-utility-library-v3.googlecode.com/svn/trunk/infobox/examples/tipbox.gif') no-repeat",
										opacity: 0.85,
										width: "300px",
										height:"100px",
									},
									closeBoxMargin: "-6px -6px 0px 0px", //-108px -58px 2px 2px  - Normal:12px 4px 2px 2px   -58px 130px 2px 2px
									closeBoxURL: "/final/images/Light/rum-close.png",
									infoBoxClearance: new google.maps.Size(1, 1)
								});
								infoBoxArr.push(infobox);
								var scalVal = threshScale*parseInt(jsonItem.MeasureValue)/totScale; 
								var marker = new MarkerWithLabel
								({
								   position: markerLocation,
								   draggable: false,
								   raiseOnDrag: false,
								   map: map,
								  // id: idCounter,
								   //labelContent: jsonItem.DispInfo,
								   labelAnchor: new google.maps.Point(2,8),//may be (0,5) --> if so then it display the label from center of bubble
								   labelClass: "labels", 
								   labelStyle: {opacity: 0.90, color:labelColor},
								   icon : image
								});

								if(jsonItem.DispInfo == 'New Zealand')
									marker.set("labelAnchor",new google.maps.Point(28,2));
								
								markersArray.push(marker);
								}
								/*var locDetailsDiv="";
								var info_height="height:100px";
								if(jsonItem.BottomLocDetails.length>3)
									info_height="height:150px";
								locDetailsDiv = locDetailsDiv+"<div id='infobox'"+info_height+";'>";
								locDetailsDiv = locDetailsDiv+"<ul class='rumMapData' style='	list-style:none;margin:0px;padding:3px 0 10px 0;height:27px;border-bottom:1px solid #cccccc'>";

								locDetailsDiv = locDetailsDiv+"<li><a href='javascript:void(0)' data-qclass='yellowTip' data-qtip='"+jsonItem.DispInfo+"' style='text-decoration:none;cursor:default;'><div  data-qclass='yellowTip' data-qtip='"+jsonItem.DispInfo+"' ><table cellspacing='0' cellpadding='0' border='0'><tr><td><img data-qclass='yellowTip' data-qtip='"+jsonItem.DispInfo+"' src='/final/images/clear.png' class='state_"+jsonItem.State+"' width='15' height='15' border='0' style='margin-left:5px'/></td><td style='padding:1px 0 0 5px;width:185px;float:left;font-size:18px;text-align:left;color:"+jsonItem.StateCode+" !important;white-space: nowrap'><div style='text-overflow:ellipsis;width:185px;overflow:hidden;'>"+jsonItem.DispInfo+"</div></td></tr></table></div></a></li>";



								if(jsonItem.HeaderMeasureName!=null && jsonItem.HeaderMeasureName!=undefined && jsonItem.HeaderMeasureName!="")
								{
									if(!Ext.isEmpty(jsonItem.DD_URL) && jsonItem.DD_URL!=null && jsonItem.DD_URL!=undefined)
									{
										locDetailsDiv = locDetailsDiv+"<li style='margin-top:4px;white-space:normal;display:inline-block;float:left;text-align:right'><a style='text-decoration:none;color:#000' href='javascript:void(0)' onclick='javascript:showDDPopup(\""+jsonItem.DD_URL+"\")'><span style='font-size:17px;text-transform:lowercase;color:#000;font-weight:bold' class='rumVisitsText'>"+jsonItem.HeaderMeasureValue+"</span>&nbsp;"+jsonItem.HeaderMeasureDispName+"</a></li>";
									}
									else
									{
										locDetailsDiv = locDetailsDiv+"<li style='margin-top:4px;white-space:normal;display:inline-block;float:left;text-align:right'><span style='font-size:17px;text-transform:lowercase;color:#000;font-weight:bold' > "+jsonItem.HeaderMeasureValue+"</span>&nbsp;"+jsonItem.HeaderMeasureDispName+"</li>";
									}
								}

								locDetailsDiv = locDetailsDiv+"</ul><br/>";
								locDetailsDiv = locDetailsDiv+"<ul class='rumMapData' style='	list-style:none;margin:0px;padding:0px;display:inline-block;line-height:1.5em;'>";
								// Preparing the content to be shown on the popup window
								// || jsonDetailsItem.MeasureDispName == 'Apdex Score'
								for(var d=0; d<jsonItem.BottomLocDetails.length; d++)
								{
									var jsonDetailsItem=jsonItem.BottomLocDetails[d];
									if(jsonDetailsItem!=null && jsonDetailsItem!=undefined)
									{
										var mapInfoMeasure = jsonDetailsItem.MeasureDispName;
										//if(mapInfoMeasure == 'Page Requests' || mapInfoMeasure == 'Average Page Loading Time' || mapInfoMeasure == 'Error Requests' || mapInfoMeasure == 'Requests' || mapInfoMeasure == 'Errors' || mapInfoMeasure == 'Avg Page Loading Time' ||  mapInfoMeasure == 'Avg Page Load Time' || mapInfoMeasure =='Error %')
										
										if(jsonDetailsItem.MeasureUnit == 'milliseconds')
											jsonDetailsItem.MeasureUnit='ms';

										if(!Ext.isEmpty(jsonDetailsItem.DD_URL) && jsonDetailsItem.DD_URL!=null && jsonDetailsItem.DD_URL!=undefined)
										{
											locDetailsDiv = locDetailsDiv+"<li style='text-align:center;padding:3px 11px 10px 11px;white-space:normal;display:inline-block;float:left'><a style='text-decoration:none;color:#000' href='javascript:void(0)' onclick='javascript:showDDPopup(\""+jsonDetailsItem.DD_URL+"\")'><span style='font-size:17px;font-weight:bold;text-transform:lowercase;color:"+jsonDetailsItem.StateCode+" !important;' class='rumVisitsText'> "+jsonDetailsItem.MeasureValue+" "+jsonDetailsItem.MeasureUnit+" </span><br/>"+jsonDetailsItem.MeasureDispName+"</a></li>";
										}
										else
										{
											locDetailsDiv = locDetailsDiv+"<li style='text-align:center;padding:0px 5px 0px 5px;white-space:normal;display:inline-block;float:left'><span style='font-size:17px;font-weight:bold;text-transform:lowercase;color:"+jsonDetailsItem.StateCode+" !important;'> "+jsonDetailsItem.MeasureValue+" "+jsonDetailsItem.MeasureUnit+" </span><br/>"+jsonDetailsItem.MeasureDispName+"</li>";
										}
									}
								}
								locDetailsDiv = locDetailsDiv+"</ul>";
								locDetailsDiv = locDetailsDiv+"</div>";*/
								

								var locDetailsDiv="";
								var info_height="height:100px";
								if(jsonItem.BottomLocDetails.length>3)
									info_height="height:150px";
								locDetailsDiv = locDetailsDiv+"<div id='infobox'"+info_height+";'>";
								locDetailsDiv = locDetailsDiv+"<ul class='rumMapData' style='	list-style:none;margin:0px;padding:3px 0 10px 0;height:27px;border-bottom:1px solid #cccccc'>";

								locDetailsDiv = locDetailsDiv+"<li style='width:70%'><a href='javascript:moveMapNext(\"Region\",\""+jsonItem.DispInfo+"\")' data-qclass='yellowTip'  data-qtip='"+jsonItem.DispInfo+"' style='text-decoration:none;cursor:default;'><div  data-qclass='yellowTip' data-qtip='"+jsonItem.DispInfo+"' ><table cellspacing='0' cellpadding='0' border='0'><tr><td><img data-qclass='yellowTip' data-qtip='"+jsonItem.DispInfo+"' src='/final/images/clear.png' class='state_"+jsonItem.State+"' width='15' height='15' border='0' style='margin-left:5px'/></td><td style='padding:1px 0 0 5px;width:185px;float:left;font-size:18px;text-align:left;color:"+jsonItem.StateCode+" !important;white-space: nowrap'><div class='mouse' title='"+jsonItem.DispInfo+"' style='text-overflow:ellipsis;width:auto;overflow:hidden;text-align:left !important'>"+jsonItem.DispInfo+"</div></td></tr></table></div></a></li>";



								if(jsonItem.HeaderMeasureName!=null && jsonItem.HeaderMeasureName!=undefined && jsonItem.HeaderMeasureName!="")
								{
									if(!Ext.isEmpty(jsonItem.DD_URL) && jsonItem.DD_URL!=null && jsonItem.DD_URL!=undefined)
									{
										locDetailsDiv = locDetailsDiv+"<li style='width:25%;margin-top:4px;white-space:normal;display:inline-block;float:right;padding:4px 0px 0px 0px !important;text-align:right'><a style='text-decoration:none;color:#000' href='javascript:void(0)' onclick='javascript:showDDPopup(\""+jsonItem.DD_URL+"\")'><span style='font-size:17px;text-transform:lowercase;color:#000;font-weight:bold' class='rumVisitsText'>"+jsonItem.HeaderMeasureValue+"</span>&nbsp;"+jsonItem.HeaderMeasureDispName+"</a></li>";
									}
									else
									{
										locDetailsDiv = locDetailsDiv+"<li style='width:25%;margin-top:4px;white-space:normal;display:inline-block;float:right;padding:4px 0px 0px 0px !important;text-align:right'><span style='font-size:17px;text-transform:lowercase;color:#000;font-weight:bold' > "+jsonItem.HeaderMeasureValue+"</span>&nbsp;"+jsonItem.HeaderMeasureDispName+"</li>";
									}
								}

								locDetailsDiv = locDetailsDiv+"</ul><br/>";
								locDetailsDiv = locDetailsDiv+"<ul class='rumMapData' style='	list-style:none;margin:0px;padding:0px;display:inline-block;line-height:1.5em;'>";
								// Preparing the content to be shown on the popup window
								// || jsonDetailsItem.MeasureDispName == 'Apdex Score'
								for(var d=0; d<jsonItem.BottomLocDetails.length; d++)
								{
									var jsonDetailsItem=jsonItem.BottomLocDetails[d];
									if(jsonDetailsItem!=null && jsonDetailsItem!=undefined)
									{
										var mapInfoMeasure = jsonDetailsItem.MeasureDispName;
										//if(mapInfoMeasure == 'Page Requests' || mapInfoMeasure == 'Average Page Loading Time' || mapInfoMeasure == 'Error Requests' || mapInfoMeasure == 'Requests' || mapInfoMeasure == 'Errors' || mapInfoMeasure == 'Avg Page Loading Time' ||  mapInfoMeasure == 'Avg Page Load Time' || mapInfoMeasure =='Error %')
										
										if(jsonDetailsItem.MeasureUnit == 'milliseconds')
											jsonDetailsItem.MeasureUnit='ms';

										if(!Ext.isEmpty(jsonDetailsItem.DD_URL) && jsonDetailsItem.DD_URL!=null && jsonDetailsItem.DD_URL!=undefined)
										{
											locDetailsDiv = locDetailsDiv+"<li style='text-align:center;padding:3px 11px 10px 11px;white-space:normal;display:inline-block;float:left'><a style='text-decoration:none;color:#000' href='javascript:void(0)' onclick='javascript:showDDPopup(\""+jsonDetailsItem.DD_URL+"\")'><span style='font-size:17px;font-weight:bold;text-transform:lowercase;color:"+jsonDetailsItem.StateCode+" !important;' class='rumVisitsText'> "+jsonDetailsItem.MeasureValue+" "+jsonDetailsItem.MeasureUnit+" </span><br/>"+jsonDetailsItem.MeasureDispName+"</a></li>";
										}
										else
										{
											locDetailsDiv = locDetailsDiv+"<li style='text-align:center;padding:0px 5px 0px 5px;white-space:normal;display:inline-block;float:left'><span style='font-size:17px;font-weight:bold;text-transform:lowercase;color:"+jsonDetailsItem.StateCode+" !important;'> "+jsonDetailsItem.MeasureValue+" "+jsonDetailsItem.MeasureUnit+" </span><br/>"+jsonDetailsItem.MeasureDispName+"</li>";
										}
									}
								}
								locDetailsDiv = locDetailsDiv+"</ul>";
								locDetailsDiv = locDetailsDiv+"</div>";

								if (Ext.isEmpty( jsonItem.CountryCode))
								{
									tempCon.push("No_Code");
								}
								else
								{
									tempCon.push(jsonItem.CountryCode);
									var xhr = new XMLHttpRequest();
									
									var url = "geojson/"+jsonItem.CountryCode+".geojson" ;
									xhr.open('GET', url, false);
									var style = GOOD;
									if(jsonItem.State == "HIGH")
										style = HIGH;
									else if(jsonItem.State == "INTERMEDIATE")
										style = INTERMEDIATE;
									else if(jsonItem.State == "LOW")
										style = LOW;
									else if(jsonItem.State == "UNKNOWN")
										style = UNKNOWN;
									
									
									xhr.onload = function() {
										if(xhr.status == 200)
											loadGeoJSON(xhr.responseText,style,marker,infobox,markerLocation,locDetailsDiv,jsonItem.DispInfo,jsonItem.CountryLAT,jsonItem.CountryLNG,jsonItem.RealInfo,tabpanel,colorClass);
									};
									xhr.send();
								}
								
								idCounter++;
							}

							try
							{
								/*if(listenerArray != undefined && listenerArray != null){
									for(var l=0;l<listenerArray.length;l++){
										google.maps.event.removeListener(listenerArray[l]);
									}
								}	
								var zl = google.maps.event.addListener(map, 'zoom_changed',function(e)
								{	
									if(findAccess != undefined && findAccess != ''){
										nextMap='Region';
										isCityMap=false;
										cntClick(findAccess,tabpanel);
									}
									//google.maps.event.removeListener(zl);
								});
								listenerArray.push(zl);*/
							}
							catch (e)
							{
								//console.log('error-->',e)
							}

							if( true )
							{
								if(!Ext.isEmpty(Ext.getCmp('barCheckBoxPanel')) && Ext.getCmp('barCheckBoxPanel')!=undefined && Ext.getCmp('barCheckBoxPanel')!=null)
								{
									var cbg = Ext.getCmp('barCheckBoxPanel').items.items[0].items.items;
									//console.log('cbg-->',cbg)
									var uncheckCbg =  refreshMapObject.cbg;
									if(uncheckCbg != undefined ){
										for(var n=0;n<uncheckCbg.length;n++){
											var cbgIndex = uncheckCbg[n];
											cbg[cbgIndex].setValue(0);
											removeCbg(cbgIndex);
										}
									}
								}
								
								if(refreshMapObject.rs != undefined){
									var rs = Ext.getCmp('resCheck');
									var rsc = refreshMapObject.rs;
									if(rsc== false || rsc == 'false'){
										for (var j = 0; j < prevFeaturesArray.length; j++){
											var features = prevFeaturesArray[j];
											// Loop through each feature
											for (var i = 0; i < features.length; i++)
												features[i].setMap(null);
										}
									}
								}

								if(refreshMapObject.rq  != undefined){
									var rq = Ext.getCmp('reqCheck');
									var rqc = refreshMapObject.rq;
									if(rqc== false || rqc == 'false'){
										for (var j = 0; j < iconMarkerArray.length; j++)
											iconMarkerArray[j].setMap(null);
										
									}
								}
								
							}

							refreshMapObject = new Object();
							refreshMapObject.name = 'Country';
							refreshMapObject.tabPl = tabpanel;
							refreshMapObject.region = '';

							var gridDatatmp = Ext.getCmp('tempGrid');
							var jsonGrid= innerJsonData.gridData;
							if(gridDatatmp != null && gridDatatmp != undefined && jsonGrid != undefined){
								
								var prev_pro =jsonGrid.SortBy;
								var prev_dir = 'DESC';
								try
								{
									if(gridDatatmp.sort != undefined){
										prev_pro = gridDatatmp.sort.property;
										prev_dir = gridDatatmp.sort.direction;
									}
								}
								catch (e)
								{
									prev_pro =jsonGrid.SortBy;
									prev_dir = 'DESC';
								}
								//gridColumn
								var dbGridStore=Ext.create('Ext.data.Store',{
									fields:jsonGrid.fields,
									autoDestroy:true,
									proxy: {
										type: 'memory',
										reader: {
											type: 'json',
											root:'items'
										}
									},
									data:jsonGrid.data,
									sorters : {
										property : prev_pro,
										//property : jsonGrid.SortBy,
										direction : prev_dir,
										//direction : 'DESC'
									}
								});
								gridDatatmp.reconfigure(dbGridStore);
								//gridDatatmp.reconfigure(dbGridStore,jsonGrid.columns);
								var currObj = Ext.getCmp('graphHeatContainer');
								currObj.setTitle(jsonGrid.gridTitle);
								//gridDatatmp.setTitle(jsonGrid.title);
							}
							
						}
					}
				}
			}
		});
		
	},
	goToTabsetPage:function(siteId,refresh)
	{
		var me = this;
		var site = Ext.getCmp(siteId);
		var siteIdVal="";
		var selectedSiteName ="";
		var selectedSiteDispName ="";
		var siteTestFreqInMin=null;
		var siteTestFreq=null;
		var selectedidNo = "";
		var jsonDataObj = null;

		if(Ext.isEmpty(site) || site==null || site==undefined || site=='undefined')
		{
			siteIdVal = siteId.getValue();
			var store_data=siteId.getStore();
			for(var k=0;k<store_data.getCount();k++)
			{
				var vm=store_data.getAt(k).data.value;
				if(vm==siteIdVal)
				{
					selectedSiteName=store_data.getAt(k).data.name;
					currSelectedName = selectedSiteName;
					selectedidNo=store_data.getAt(k).data.no;
					break;
				}
			}
		}
		else
		{
			siteIdVal = siteId;
			selectedSiteName = site.siteName;
			currSelectedName = selectedSiteName;
			selectedSiteDispName = site.siteDispName;
			siteTestFreqInMin=site.siteTestFreqInMin;
			siteTestFreq=site.siteTestFreq;
			selectedidNo = site.idNo;
			jsonDataObj = site.jsonDataObj;
		}
		if( Ext.isEmpty( selectedSiteDispName ) )
		{
			selectedSiteDispName = ( selectedSiteName.indexOf(":NULL") > -1 )?selectedSiteName.substring(0,selectedSiteName.indexOf(":NULL")):selectedSiteName;
		}
		url = "/final/servlet/com.eg.RUMController?getComponents=yes&accessData=allAccessType&tabName=rumOverview&comp="+site.siteName+"&fromService="+fromSerFlag;

		var resultObj = me.getMain();
		//me.getMain().removeAll(false);
		if(jsonDataObj==null || jsonDataObj==undefined || jsonDataObj=="")
		{
			Ext.Ajax.request({
				url:url,
				timeout:300000,
				success:function(response)
				{
					var jsonText = response.responseText;
					if (!Ext.isEmpty( jsonText))
					{
						var jsonData = Ext.decode(jsonText);
						delete jsonText;
						Ext.destroy(jsonText);
						jsonText = null;

						var selectedState="GOOD";
						if ( !Ext.isEmpty( jsonData ))
						{
							if (!Ext.isEmpty( jsonData.sitesArray ))
							{
								var sitesJsonArray=jsonData.sitesArray;
						
								if(sitesJsonArray!=null && sitesJsonArray!=undefined && sitesJsonArray.length>0)
								{
									for(var item=0; item<sitesJsonArray.length; item++)
									{
										var siteItemJson=sitesJsonArray[item];

										if(siteItemJson!=null && siteItemJson!=undefined)
										{
											if(selectedSiteName==siteItemJson.siteName)
											{
												selectedState = siteItemJson.siteState;
												siteTestFreqInMin=siteItemJson.testFreqInMin;
												siteTestFreq=siteItemJson.testFreq;
												break;
											}
										}
									}
								}
							}
						}

						if (!Ext.isEmpty( siteTestFreqInMin ) && siteTestFreqInMin!=undefined && siteTestFreqInMin!="")
						{
							if(siteTestFreqInMin != null && siteTestFreqInMin == '1')
								me.getMain().setTitle('<div id="titleDiv" style="float:left">'+pageTitle+' - '+selectedSiteDispName+'</div><div style="float:left;margin-left:5px" class="iconRumToLayermodel handSymbol"  data-qclass="yellowTip" data-qtip="Layer Model" href="javascript:void(0);" onclick=\'DashboardToLayers("'+selectedSiteName+'","2");\'> </div><div style="float:right">'+showingDataForLast+'  '+siteTestFreqInMin+minutes+'</div>');
							else

								me.getMain().setTitle('<div id="titleDiv" style="float:left">'+pageTitle+' - '+selectedSiteDispName+'</div><div style="float:left;margin-left:5px" class="iconRumToLayermodel handSymbol"  data-qclass="yellowTip" data-qtip="Layer Model" href="javascript:void(0);" onclick=\'DashboardToLayers("'+selectedSiteName+'","2");\'> </div><div style="float:right"> '+showingDataForLast+'  '+siteTestFreqInMin+'  '+minutes+'</div>');
						}
						else if (!Ext.isEmpty( siteTestFreq ) && siteTestFreq!=null && siteTestFreq!=undefined && siteTestFreq!="")
						{
							if(siteTestFreq!=undefined && siteTestFreq=='N/A')
							{
								me.getMain().setTitle('<div id="titleDiv" style="float:left">'+pageTitle+' - '+selectedSiteDispName+'</div><div style="float:left;margin-left:5px" class="iconRumToLayermodel handSymbol"  data-qclass="yellowTip" data-qtip="Layer Model" href="javascript:void(0);" onclick=\'DashboardToLayers("'+selectedSiteName+'","2");\'> </div><div style="float:right">The test has not been configured</div>');
							}
							else if(siteTestFreq!=undefined && siteTestFreq!="")
							{

								me.getMain().setTitle('<div id="titleDiv" style="float:left">'+pageTitle+' - '+selectedSiteDispName+'</div><div style="float:left;margin-left:5px" class="iconRumToLayermodel handSymbol"  data-qclass="yellowTip" data-qtip="Layer Model" href="javascript:void(0);" onclick=\'DashboardToLayers("'+selectedSiteName+'","2");\'> </div><div style="float:right"> '+showingDataForLast+'  '+siteTestFreq+' seconds</div>');
							}
						}
						else if (!Ext.isEmpty( jsonData.testFreqInMin ) && jsonData.testFreqInMin!=undefined && jsonData.testFreqInMin!="")
						{
							//me.getMain().setTitle('<div style="float:left">Real User Monitoring Dashboard - '+selectedSiteDispName+'</div><div style="float:right">Showing data for last '+jsonData.testFreqInMin+' minutes</div>');
							me.getMain().setTitle('<div id="titleDiv" style="float:left">'+pageTitle+' - '+selectedSiteDispName+'</div><div style="float:left;margin-left:5px" class="iconRumToLayermodel handSymbol"  data-qclass="yellowTip" data-qtip="Layer Model" href="javascript:void(0);" onclick=\'DashboardToLayers("'+selectedSiteName+'","2");\'> </div>');
						}
						else if (!Ext.isEmpty( jsonData.testFreq ))
						{
							if(jsonData.testFreq!=undefined && jsonData.testFreq=='N/A')
							{
								//me.getMain().setTitle('<div style="float:left">Real User Monitoring Dashboard - '+selectedSiteDispName+'</div><div style="float:right">The test has not been configured</div>');
								me.getMain().setTitle('<div id="titleDiv" style="float:left">'+pageTitle+' - '+selectedSiteDispName+'</div><div style="float:left;margin-left:5px" class="iconRumToLayermodel handSymbol"  data-qclass="yellowTip" data-qtip="Layer Model" href="javascript:void(0);" onclick=\'DashboardToLayers("'+selectedSiteName+'","2");\'> </div>');
							}
							else if(jsonData.testFreq!=undefined && jsonData.testFreqInMin!="")
							{
								//me.getMain().setTitle('<div style="float:left">Real User Monitoring Dashboard - '+selectedSiteDispName+'</div><div style="float:right">Showing data for last '+jsonData.testFreq+' seconds</div>');
								me.getMain().setTitle('<div id="titleDiv" style="float:left">'+pageTitle+' - '+selectedSiteDispName+'</div><div style="float:left;margin-left:5px" class="iconRumToLayermodel handSymbol"  data-qclass="yellowTip" data-qtip="Layer Model" href="javascript:void(0);" onclick=\'DashboardToLayers("'+selectedSiteName+'","2");\'> </div>');
							}
						}

						//resultObj.setTitle('<div style="float:left">Real User Monitoring - Dashboard - '+selectedSiteName+' </div><div style="float:right">Showing data for last 5 Minutes</div>');

						if ( !Ext.isEmpty( jsonData ))
						{
							if (!Ext.isEmpty( resultObj))
							{
								//resultObj.removeAll(true);
								/*var resultItems=resultObj.items.items;
								for(var item=resultItems.length-1; item>-1 ; item--)
								{
									resultItems[item].destroy()
								}*/
							}

							if (!Ext.isEmpty( jsonData.No_Sites ))
							{
								resultObj.removeAll(true);
								var errorMsg='<center><div style="margin:10% 0 auto 0"><div class="iconInformation" ></div><div class="commonErrorMsgText">No data available</div></div></center>';
								var err ={
											xtype:'panel',
											id:'errId',
											html:errorMsg
										};
								resultObj.add(err);
							}
							else if (!Ext.isEmpty( jsonData.sitesArray ))
							{
								var errIdObj = Ext.getCmp('errId');
								if (!Ext.isEmpty( errIdObj))
								{
									resultObj.removeAll(true);
								}
								var sitesJsonArray=jsonData.sitesArray;
								var sitesCombo=new Array();
								var sitesArrayCombo = new Array();
								//var selectedState="GOOD";
								/*for(var item=0; item<sitesJsonArray.length; item++)
								{
									var siteItemJson=sitesJsonArray[item];

									var temp=new Object();
									temp.name=siteItemJson.siteName;
									//temp.value=siteItemJson.siteName;
									temp.value='site_'+item;
									temp.no=item;
									temp.state=siteItemJson.siteState;

									if(selectedSiteName==siteItemJson.siteName)
									{
										selectedState = siteItemJson.siteState;
									}

									sitesArrayCombo.push(temp);
								}

								sitesCombo.push({
									label:'Select a Site',
									name: "site" ,
									value: sitesArrayCombo,
									selected:selectedSiteName,
								});

								var siteDataStore = Ext.create('Ext.data.Store',{
									data : sitesCombo[0].value,
									fields:['name','value','no','state']
								});

								var siteComboObj = {
									xtype: 'combo',
									cls:'dropdown',
									id:'sitesComboId',
									labelWidth:70,
									width:260,
									labelSeparator:'',
									margin:'2 0 0 0',
									fieldLabel:sitesCombo[0].label,
									name:sitesCombo[0].name,
									displayField : 'name',
									valueField : 'value',
									noField : 'no',
									store : siteDataStore,
									value:sitesCombo[0].selected,
								};*/

								//resultObj.add(siteComboObj);

								/*resultObj.add(
								{
									xtype:'rumtabpanel',
									id:'rumtabpanelId',
									style:{'border':'0px solid blue'},
									siteName:selectedSiteName,
									siteId:siteIdVal,
									siteState:selectedState,
									itemNo:selectedidNo,
									mPCnt:jsonData.getMiddlePanelCount,
									bPCnt:jsonData.getBottomPanelCount,
									view:'',
									country:'',
									region:'',
									tabBar: {
										hidden:true,
										items: [{
											xtype: 'tbfill'
										},{
											xtype:'container',
											id:'tabhead'
										}]
									},
									listeners:{
										'afterrender': function(currObj){
											var activetab = currObj.getActiveTab();
											Ext.EventManager.onWindowResize(function () {
												var height = Ext.getBody().getViewSize().height - 42;
												var rumTabId = Ext.getCmp(currObj.id);
												if(!Ext.isEmpty(rumTabId))
												{
													rumTabId.setHeight(height);
													
												}

											});
											var height = Ext.getBody().getViewSize().height - 42;
											var rumTabId = Ext.getCmp('rumtabpanelId');
											if(!Ext.isEmpty(rumTabId))
												rumTabId.setHeight(height);

											//rumTabId.body.scrollTo('bottom', 1);


											//rumTabId.scrollBy(500, 500, true);

											if(activetab.id=='rumOverviewId')
											{
												me.createRumOverviewDashboard(currObj,refresh);
											}
											else if(activetab.id=='rumGeoId')
											{
												me.updateGeoDashboard(currObj,true,refresh);
											}
											else if(activetab.id=='rumPagesAjaxId')
											{
												me.updatePagesAndAjax(currObj,null,refresh);
											}
											else if(newcard.id=='rumBD')
											{
												me.updateBADTab(currObj,refresh);
											}
										}
									}
								});*/

								var rumTabpanelIdObj = Ext.getCmp('rumtabpanelId');
								if (!Ext.isEmpty( rumTabpanelIdObj))
								{
									rumTabpanelIdObj.siteName=selectedSiteName;
									rumTabpanelIdObj.siteId=siteIdVal;
									rumTabpanelIdObj.siteState=selectedState;
									rumTabpanelIdObj.itemNo=selectedidNo;
									rumTabpanelIdObj.mPCnt=jsonData.getMiddlePanelCount;
									rumTabpanelIdObj.bPCnt=jsonData.getBottomPanelCount;
									rumTabpanelIdObj.view='';
									rumTabpanelIdObj.country='';
									rumTabpanelIdObj.region='';

									var activetab = rumTabpanelIdObj.getActiveTab();
									if(activetab.id=='rumOverviewId')
									{
										me.createRumOverviewDashboard(rumTabpanelIdObj,refresh);
									}
								}
							}
						}
						var backButton = Ext.getCmp('backButton');
						if (!Ext.isEmpty( backButton))
						{
							backButton.show();
						}
						if(isTvMode)
						{
							Ext.getCmp('backButton').hide();
						}
					}
				}
			});
		}
		else
		{
			if (!Ext.isEmpty( jsonDataObj) && jsonDataObj!=null && jsonDataObj!=undefined && jsonDataObj!="")
			{
				var jsonData = jsonDataObj;

				if (!Ext.isEmpty( siteTestFreqInMin ) && siteTestFreqInMin!=undefined && siteTestFreqInMin!="")
				{
					if(siteTestFreqInMin != null && siteTestFreqInMin == '1')
						me.getMain().setTitle('<div id="titleDiv" style="float:left">'+pageTitle+' - '+selectedSiteDispName+'</div><div style="float:left;margin-left:5px" class="iconRumToLayermodel handSymbol"  data-qclass="yellowTip" data-qtip="Layer Model" href="javascript:void(0);" onclick=\'DashboardToLayers("'+selectedSiteName+'","2");\'> </div><div style="float:right">'+showingDataForLast+'  '+siteTestFreqInMin+'  '+minutes+'</div>');
					else
						me.getMain().setTitle('<div id="titleDiv" style="float:left">'+pageTitle+' - '+selectedSiteDispName+'</div><div style="float:left;margin-left:5px" class="iconRumToLayermodel handSymbol"  data-qclass="yellowTip" data-qtip="Layer Model" href="javascript:void(0);" onclick=\'DashboardToLayers("'+selectedSiteName+'","2");\'> </div><div style="float:right"> '+showingDataForLast+'  '+siteTestFreqInMin+'  '+minutes+'</div>');
				}
				else if (!Ext.isEmpty( siteTestFreq ) && siteTestFreq!=null && siteTestFreq!=undefined && siteTestFreq!="")
				{
					if(siteTestFreq!=undefined && siteTestFreq=='N/A')
					{
						me.getMain().setTitle('<div id="titleDiv" style="float:left">'+pageTitle+' - '+selectedSiteDispName+'</div><div style="float:left;margin-left:5px" class="iconRumToLayermodel handSymbol"  data-qclass="yellowTip" data-qtip="Layer Model" href="javascript:void(0);" onclick=\'DashboardToLayers("'+selectedSiteName+'","2");\'> </div><div style="float:right">The test has not been configured</div>');
					}
					else if(siteTestFreq!=undefined && siteTestFreq!="")
					{
						me.getMain().setTitle('<div id="titleDiv" style="float:left">'+pageTitle+' - '+selectedSiteDispName+'</div><div style="float:left;margin-left:5px" class="iconRumToLayermodel handSymbol"  data-qclass="yellowTip" data-qtip="Layer Model" href="javascript:void(0);" onclick=\'DashboardToLayers("'+selectedSiteName+'","2");\'> </div><div style="float:right"> '+showingDataForLast+'  '+siteTestFreq+'  '+seconds+' </div>');
					}
				}
				else if (!Ext.isEmpty( jsonData.testFreqInMin ) && jsonData.testFreqInMin!=undefined && jsonData.testFreqInMin!="")
				{
					if(jsonData.testFreqInMin != null && jsonData.testFreqInMin == '1')
						me.getMain().setTitle('<div id="titleDiv" style="float:left">'+pageTitle+' - '+selectedSiteDispName+'</div><div style="float:left;margin-left:5px" class="iconRumToLayermodel handSymbol"  data-qclass="yellowTip" data-qtip="Layer Model" href="javascript:void(0);" onclick=\'DashboardToLayers("'+selectedSiteName+'","2");\'> </div><div style="float:right">'+showingDataForLast+'  '+jsonData.testFreqInMin+' '+seconds+'</div>');
					else
						me.getMain().setTitle('<div id="titleDiv" style="float:left">'+pageTitle+' - '+selectedSiteDispName+'</div><div style="float:left;margin-left:5px" class="iconRumToLayermodel handSymbol"  data-qclass="yellowTip" data-qtip="Layer Model" href="javascript:void(0);" onclick=\'DashboardToLayers("'+selectedSiteName+'","2");\'> </div><div style="float:right">'+showingDataForLast+'  '+jsonData.testFreqInMin+'  '+minutes+'</div>');
				}
				else if (!Ext.isEmpty( jsonData.testFreq ))
				{
					if(jsonData.testFreq!=undefined && jsonData.testFreq=='N/A')
					{
						me.getMain().setTitle('<div id="titleDiv" style="float:left">'+pageTitle+' - '+selectedSiteDispName+'</div><div style="float:left;margin-left:5px" class="iconRumToLayermodel handSymbol"  data-qclass="yellowTip" data-qtip="Layer Model" href="javascript:void(0);" onclick=\'DashboardToLayers("'+selectedSiteName+'","2");\'> </div><div style="float:right">The test has not been configured</div>');
					}
					else if(jsonData.testFreq!=undefined && jsonData.testFreq!="")
					{
						me.getMain().setTitle('<div id="titleDiv"  style="float:left">'+pageTitle+' - '+selectedSiteDispName+'</div><div style="float:left;margin-left:5px" class="iconRumToLayermodel handSymbol"  data-qclass="yellowTip" data-qtip="Layer Model" href="javascript:void(0);" onclick=\'DashboardToLayers("'+selectedSiteName+'","2");\'> </div><div style="float:right">'+showingDataForLast+'  '+jsonData.testFreq+'  '+seconds+'</div>');
					}
				}
				//resultObj.setTitle('<div style="float:left">Real User Monitoring - Dashboard - '+selectedSiteName+' </div><div style="float:right">Showing data for last 5 Minutes</div>');

				if ( !Ext.isEmpty( jsonData ))
				{
					if (!Ext.isEmpty( resultObj))
					{
						resultObj.removeAll(true);
						/*var resultItems=resultObj.items.items;
						for(var item=resultItems.length-1; item>-1 ; item--)
						{
							resultItems[item].destroy()
						}*/
					}
					if (!Ext.isEmpty( jsonData.No_Sites ))
					{
						var errorMsg='<center><div style="margin:10% 0 auto 0"><div class="iconInformation" ></div><div class="commonErrorMsgText">No data available</div></div></center>';
						var err ={
									xtype:'panel',
									html:errorMsg
								};
						resultObj.add(err);
					}
					else if (!Ext.isEmpty( jsonData.sitesArray ))
					{
						var sitesJsonArray=jsonData.sitesArray;
						var sitesCombo=new Array();
						var sitesArrayCombo = new Array();
						var selectedState="GOOD";
						/*for(var item=0; item<sitesJsonArray.length; item++)
						{
							var siteItemJson=sitesJsonArray[item];

							var temp=new Object();
							temp.name=siteItemJson.siteName;
							//temp.value=siteItemJson.siteName;
							temp.value='site_'+item;
							temp.no=item;
							temp.state=siteItemJson.siteState;

							if(selectedSiteName==siteItemJson.siteName)
							{
								selectedState = siteItemJson.siteState;
							}

							sitesArrayCombo.push(temp);
						}*/
						/*sitesCombo.push({
							label:'Select a Site',
							name: "site" ,
							value: sitesArrayCombo,
							selected:selectedSiteName,
						});

						var siteDataStore = Ext.create('Ext.data.Store',{
							data : sitesCombo[0].value,
							fields:['name','value','no','state']
						});

						var siteComboObj = {
							xtype: 'combo',
							cls:'dropdown',
							id:'sitesComboId',
							labelWidth:70,
							width:260,
							labelSeparator:'',
							margin:'2 0 0 0',
							fieldLabel:sitesCombo[0].label,
							name:sitesCombo[0].name,
							displayField : 'name',
							valueField : 'value',
							noField : 'no',
							store : siteDataStore,
							value:sitesCombo[0].selected,
						};*/

						//resultObj.add(siteComboObj);
						resultObj.add(
						{
							xtype:'rumtabpanel',
							id:'rumtabpanelId',
							siteName:selectedSiteName,
							siteId:siteIdVal,
							siteState:selectedState,
							itemNo:selectedidNo,
							mPCnt:jsonData.getMiddlePanelCount,
							bPCnt:jsonData.getBottomPanelCount,
							view:'',
							country:'',
							region:'',
							tabBar: {
								hidden:true,
								items: [{
									xtype: 'tbfill'
								},{
									xtype:'container',
									id:'tabhead'
								}]
							},
							listeners:{
								'afterrender': function(currObj){
									var activetab = currObj.getActiveTab();
									Ext.EventManager.onWindowResize(function () {
										var height = Ext.getBody().getViewSize().height - 42;
										var heightFromService = Ext.getBody().getViewSize().height;
										var rumTabId = Ext.getCmp(currObj.id);
										if(!Ext.isEmpty(rumTabId))
										{
											if(fromSerFlag != null && fromSerFlag != undefined && (fromSerFlag == 'true' || fromSerFlag== true))
												rumTabId.setHeight(heightFromService);
											else
												rumTabId.setHeight(height);
											
										}

									});
									var height = Ext.getBody().getViewSize().height - 42;
									var heightFromService = Ext.getBody().getViewSize().height;
									var rumTabId = Ext.getCmp('rumtabpanelId');
									if(!Ext.isEmpty(rumTabId))
									{
										if(fromSerFlag != null && fromSerFlag != undefined && (fromSerFlag == 'true' || fromSerFlag== true))
											rumTabId.setHeight(heightFromService);
										else
											rumTabId.setHeight(height);
									}
									//rumTabId.body.scrollTo('bottom', 1);


									//rumTabId.scrollBy(500, 500, true);

									if(activetab.id=='rumOverviewId')
									{
										me.createRumOverviewDashboard(currObj,refresh);
									}
									else if(activetab.id=='rumGeoId')
									{
										me.updateGeoDashboard(currObj,true,refresh);
									}
									else if(activetab.id=='rumPagesAjaxId')
									{
										me.updatePagesAndAjax(currObj,null,refresh);
									}
									else if(newcard.id=='rumBD')
									{
										me.updateBADTab(currObj,refresh);
									}
									//Ext.getCmp('tabhead').add(siteComboObj); removed selected site combo
								}
								 /*'click': function () {
										Ext.getCmp('rumtabpanelId').scrollBy(500, 500, true);
									}*/
							}
						});
					}
				}
				var backButton = Ext.getCmp('backButton');
				if (!Ext.isEmpty( backButton))
				{
					backButton.show();
				}
				if(isTvMode)
				{
					Ext.getCmp('backButton').hide();
				}
			}
		}
		
		if( fromSerFlag == 'true' || fromSerFlag == true)
		{
			me.getMain().getHeader().hide();
			me.getRumTabPanel().removeCls('tabLayout');
			me.getRumTabPanel().addCls('uxtab');
		}
	},
	getSiteMapDetail:function(obj,isUpdate,fromPage,mainMask)
	{
		if (!Ext.isEmpty(obj))
		{
			var site_name=obj.siteName;
			var map_view=obj.view;
			var map_country=obj.country;
			var map_region=obj.region;
			var map_details="Country";
			if (!Ext.isEmpty(site_name))
			{
				var map_url="/final/monitor/geo.jsp?accessType=map&site="+encodeURI(site_name);

				if (!Ext.isEmpty(fromPage) && fromPage!=null && fromPage!=undefined && fromPage!="" && fromPage=='Overview')
				{
					map_url="/final/monitor/RumOverviewMap.jsp?accessType=overviewMap&site="+encodeURI(site_name);
					//map_url="/final/monitor/RumOverviewMap.jsp?accessType=map&site="+site_name;
				}

				if (!Ext.isEmpty(map_country) && map_country!=null && map_country!=undefined && map_country!="")
				{
					map_url = map_url+"&selectedCountry="+encodeURI(map_country);
					map_details = "Region";
				}

				if (!Ext.isEmpty(map_region) && map_region!=null && map_region!=undefined && map_region!="")
				{
					map_url = map_url+"&regionName="+encodeURI(map_region);
					map_details = "City";
				}

				if (!Ext.isEmpty(isUpdate) && isUpdate!=null && isUpdate!=undefined && isUpdate!="")
				{
					map_url = map_url+"&updatePanel="+isUpdate;
				}

				if (!Ext.isEmpty(map_details) && map_details!=null && map_details!=undefined && map_details!="")
				{
					map_url = map_url+"&updateDetails="+map_details;
				}

				if (!Ext.isEmpty(rumSkin) && rumSkin!=null && rumSkin!=undefined && rumSkin!="")
				{
					map_url = map_url+"&rumSkin="+rumSkin;
				}
				

				var geoId="geoPanelId";
				var geoIframeId="geoIframeId";
				if (!Ext.isEmpty(fromPage) && fromPage!=null && fromPage!=undefined && fromPage!="" && fromPage=='Overview')
				{
					geoId="geoOverViewPanelId";
					geoIframeId="geoOverviewIframeId";
				}
				var geoDashMap = {
					xtype:'panel',
					cls:'rumDataInnerpanel',
					height:370,
					title:'Geo Performance',
					columnWidth:.50,
					//layout:{type:'vbox',align:'stretch'},
					layout:'fit',
					//width:540,
					minWidth:520,
					padding:'6 0 0 10',
					margin:'0 15 0 0',
					//cls:'content-frame',
					//id:'geoMapPanel',
					id:geoId,
					mMask:mainMask,
					style:{'background':'transparent !important','border':'0px solid yellow','text-align':'center'},
					html:"<iframe id='"+geoIframeId+"'  width='520' height='370' src='"+map_url+"' border='0' scrolling='yes' marginwidth='0px' marginheight='0px' frameborder='0' allowtransparency='true' style='border:0px solid red' ></iframe>",
					listeners:{
						'afterrender': function(thisMapObj){
							if(thisMapObj.mMask!=null && thisMapObj.mMask!=null)
							{
								Ext.destroy(mainMask);
							}
						}
					}
				};
				return geoDashMap;
			}
		}
	},
	refreshSiteMapDetail:function(obj,isUpdate,fromPage,mainMask)
	{
		if (!Ext.isEmpty(obj))
		{
			var site_name=obj.siteName;
			var map_view=obj.view;
			var map_country=obj.country;
			var map_region=obj.region;
			var map_details="Country";
			if (!Ext.isEmpty(site_name))
			{
				var map_url="/final/monitor/geo.jsp?accessType=map&site="+encodeURI(site_name);

				if (!Ext.isEmpty(fromPage) && fromPage!=null && fromPage!=undefined && fromPage!="" && fromPage=='Overview')
				{
					map_url="/final/monitor/RumOverviewMap.jsp?accessType=overviewMap&site="+encodeURI(site_name);
					//map_url="/final/monitor/RumOverviewMap.jsp?accessType=map&site="+site_name;
				}

				if (!Ext.isEmpty(map_country) && map_country!=null && map_country!=undefined && map_country!="")
				{
					map_url = map_url+"&selectedCountry="+encodeURI(map_country);
					map_details = "Region";
				}

				if (!Ext.isEmpty(map_region) && map_region!=null && map_region!=undefined && map_region!="")
				{
					map_url = map_url+"&regionName="+encodeURI(map_region);
					map_details = "City";
				}

				if (!Ext.isEmpty(isUpdate) && isUpdate!=null && isUpdate!=undefined && isUpdate!="")
				{
					map_url = map_url+"&updatePanel="+isUpdate;
				}

				if (!Ext.isEmpty(map_details) && map_details!=null && map_details!=undefined && map_details!="")
				{
					map_url = map_url+"&updateDetails="+map_details;
				}

				if (!Ext.isEmpty(rumSkin) && rumSkin!=null && rumSkin!=undefined && rumSkin!="")
				{
					map_url = map_url+"&rumSkin="+rumSkin;
				}

				var geoId="geoPanelId";
				var geoIframeId="geoIframeId";
				if (!Ext.isEmpty(fromPage) && fromPage!=null && fromPage!=undefined && fromPage!="" && fromPage=='Overview')
				{
					geoId="geoOverViewPanelId";
					geoIframeId="geoOverviewIframeId";
				}

				var geoIframeIdObj=jQuery('#'+geoIframeId);
				//console.log("1 geoIframeIdObj-->",geoIframeIdObj);
				if(geoIframeIdObj==null || geoIframeIdObj==undefined)
				{
					geoIframeIdObj=Ext.getCmp(geoIframeId);
					//console.log("2 geoIframeIdObj-->",geoIframeIdObj);
				}

				if(geoIframeIdObj==null || geoIframeIdObj==undefined)
				{
					var geoDashMap = {
						xtype:'panel',
						cls:'rumDataInnerpanel',
						height:370,
						title:'Geo Performance',
						columnWidth:.50,
						//layout:{type:'vbox',align:'stretch'},
						layout:'fit',
						//width:540,
						minWidth:520,
						padding:'6 0 0 10',
						margin:'0 15 0 0',
						//cls:'content-frame',
						//id:'geoMapPanel',
						id:geoId,
						mMask:mainMask,
						style:{'background':'transparent !important','border':'0px solid yellow','text-align':'center'},
						html:"<iframe id='"+geoIframeId+"' width='520' height='370' src='"+map_url+"' border='0' scrolling='yes' marginwidth='0px' marginheight='0px' frameborder='0' allowtransparency='true' style='border:0px solid red' ></iframe><iframe id='tmp_Demo' width='0' height='0' src='' border='0' scrolling='no' marginwidth='0px' marginheight='0px' frameborder='0' allowtransparency='true' style='border:0px solid red' ></iframe>",
						listeners:{
							'afterrender': function(thisMapObj){
								if(thisMapObj.mMask!=null && thisMapObj.mMask!=null)
								{
									Ext.destroy(mainMask);
								}
							}
						}
					};
					return geoDashMap;
				}
				else if(geoIframeIdObj!=null && geoIframeIdObj!=undefined)
				{
					var RumMapObj = this.getMain();
					if (!Ext.isEmpty( RumMapObj))
					{
						var resultItems=RumMapObj.items.items;
						for(var item=resultItems.length-1; item>-1 ; item--)
						{
							if(resultItems[item].id=='tmpMapRefPanel')
							{
								resultItems[item].destroy();
							}
						}
					}

					var geoDashMap2 = {
						xtype:'panel',
						id:'tmpMapRefPanel',
						height:0,
						width:0,
						minWidth:0,
						mMask:mainMask,
						style:{'background':'transparent !important','border':'0px solid yellow','text-align':'center'},
						html:"<iframe id='tmp_Demo' width='520' height='370' src='"+map_url+"' border='0' scrolling='yes' marginwidth='0px' marginheight='0px' frameborder='0' allowtransparency='true' style='border:0px solid red' ></iframe>",
						listeners:{
							'afterrender': function(thisMapObj){
								//geoIframeIdObj[0].src=map_url;
								jQuery('#'+geoIframeId).contents().find('body').html(jQuery('#tmp_Demo').contents().find('body'));
								if(thisMapObj.mMask!=null && thisMapObj.mMask!=null)
								{
									Ext.destroy(mainMask);
								}
							}
						}
					};
					this.getMain().add(geoDashMap2);

					//var map_canvasObj=jQuery('#map_canvas');
					//console.log("1 map_canvasObj-->",map_canvasObj);

					//geoIframeIdObj[0].src=map_url;
					/*var geoIframeIdDemoObj=jQuery('#tmp_Demo');
					console.log("geoIframeIdDemoObj-->",geoIframeIdDemoObj);
					console.log("geoIframeIdDemoObj.src-->",geoIframeIdDemoObj.src);
					geoIframeIdDemoObj.src=map_url;
					//setTimeout(jQuery('#'+geoIframeId).contents().find('body').html(jQuery('#'+geoIframeId+"_Demo").contents().find('body').html()), 1000);
					//jQuery('#'+geoIframeId).contents().find('body').html(innerJsonText);
					Ext.Ajax.request({
						url:map_url+"&refresh=true",
						timeout:300000,
						success:function(res)
						{
							var innerJsonText = res.responseText;
							//console.log("1 innerJsonText-->",innerJsonText);
							jQuery('#'+geoIframeId).contents().find('body').html(innerJsonText);
							//console.log("geoIframeIdObj.src-->",geoIframeIdObj[0].src);
							if(mainMask!=null && mainMask!=null)
							{
								Ext.destroy(mainMask);
							}
						}
					});*/
				}
			}
		}
	},
	updateGeoMap:function(url)
	{
		var RumMapObj = this.getRummap();
		if (!Ext.isEmpty( RumMapObj))
		{
			var resultItems=RumMapObj.items.items;
			for(var item=resultItems.length-1; item>-1 ; item--)
			{
				resultItems[item].destroy();
			}
		}
		this.getRummap().add(this.updateMapDetails(url));
	},
	updateMapDetails:function(url)
	{
		if (!Ext.isEmpty( url) && url!=undefined && url!="")
		{
			var geoId="geoPanelId";
			var geoIframeId="geoIframeId";

			var geoDashMap = {
				xtype:'container',
				id:geoId,
				height:'100%',
				cls:'content-frame',
				style:{'border':'0px solid red'},
				html:"<iframe id='"+geoIframeId+"'  width='100%' height='100%' src='"+url+"' border='0' scrolling='yes' marginwidth='0px' marginheight='0px' frameborder='0' style='border-width:0px; border-style:solid; border-color:yellow;' class='content-frame' ></iframe>",
			};

			return geoDashMap;
		}
	},
	getSiteDetail:function(obj)
	{
		var title= "<div><img src='/final/images/spacer.gif' class='state_"+obj.siteState+"'/> <a href='javascript:void(0);'>"+obj.siteName+"</a></div>";

		var site = {
			xtype:'panel',
			id:obj.siteId,
			name:'site',
			//title:title,
			header:false,
			style:{'border':'0px solid red'},
			siteName:obj.siteName,
			siteState:obj.siteState,
			collapsible: false,
			bodyPadding:'7 0 0 0',
			frame:false,
			idNo:obj.itemNo,
			height:100,
			width:'100%',
			viewConfig:{forceFit:true},
			defaults:{/*columnWidth:.24,*/padding:'0 10 0 10'},
			layout:{type:'column'},
			objObject:obj,
			items:[],
			listeners:{
				'afterrender': function(thisObj){
					var inner_url = '/final/servlet/com.eg.RUMController?site='+encodeURI(thisObj.siteName)+'&accessType=allAccessType&fromService='+fromSerFlag;

					var siteItemNo=thisObj.idNo;
					var siteNameVal=thisObj.siteName;
					/*var wholeViewport = document.getElementsByTagName("body")[0];
					var mask = new Ext.LoadMask(wholeViewport, {
						//msg: "Loading upper panel details..."
						msg: "Loading...",
						cls:'maskDash'
					});
					mask.show();*/
					Ext.Ajax.request({
						url:inner_url,
						method : 'POST',
						scope:this,
						timeout:300000,
						success:function(res)
						{
							//mask.hide();
							//Ext.destroy(mask);
							var innerJsonText = res.responseText;
							if (!Ext.isEmpty( innerJsonText))
							{
								var innerJsonData = Ext.decode(innerJsonText);

								delete innerJsonText;
								Ext.destroy(innerJsonText);
								innerJsonText = null;
								if ( !Ext.isEmpty( innerJsonData ))
								{
									if(!Ext.isEmpty( innerJsonData.NoSiteData ))
									{
										var errorMsg='<center><div style="margin:3% 0 auto 0"><div class="iconInformation" ></div><div class="commonErrorMsgText">No Traffic Detected</div></div></center>';
										var err ={
													xtype:'container',
													columnWidth:1.0,
													html:errorMsg
												};
										thisObj.add(err);
									}
									else if(!Ext.isEmpty(innerJsonData.siteMeaDataArray ))
									{
										var sitesDataArray=innerJsonData.siteMeaDataArray;
										for(var mditem=0; mditem<sitesDataArray.length; mditem++)
										{
											var siteDataItemJson=sitesDataArray[mditem];

											if ( !Ext.isEmpty( siteDataItemJson.sitePanelArray ))
											{
												var sitePanelArray=siteDataItemJson.sitePanelArray;
												for(var vitem=0; vitem<sitePanelArray.length; vitem++)
												{
													var sitePanelItemJson=sitePanelArray[vitem];
													if(!Ext.isEmpty( sitePanelItemJson.DayLimitExceed ) && sitePanelItemJson.DayLimitExceed=='true')
													{
														dailyLimitExceed = -100;
														var errorMsg='<table height="100%" align="center" style="margin:1.35% auto"><tr><td ><img style="margin-top:-2px" src="/final/images/spacer.gif" class="iconAlert"/></td><td>&nbsp;<span class="rumErrorMsgText">Daily limit has been exceeded</span></td><tr></table>';
														
														var err ={
																	xtype:'container',
																	columnWidth:1.0,
																	html:errorMsg
																};
														thisObj.add(err);
													}
													else
													{
														var topDataVal=sitePanelItemJson.topData;

														var middleDataValArray=sitePanelItemJson.middleDataArray;

														var bottomDataVal=sitePanelItemJson.bottomData;

														var panelWidth=sitePanelItemJson.panelWidth;

														var conDiv="";

														if ( !Ext.isEmpty( topDataVal ))
														{
															var tool_tip="";
															if ( !Ext.isEmpty( topDataVal.Text_ToolTip ) && topDataVal.Text_ToolTip!=undefined)
															{
																tool_tip=topDataVal.Text_ToolTip;
															}

															if ( !Ext.isEmpty( topDataVal.NoState ) && topDataVal.NoState=='YES')
															{
																//conDiv=conDiv+"<table  width='100%' style='border:1px solid green'>";
																	//conDiv=conDiv+"<tr>";
																		var info_tip="";
																		if ( !Ext.isEmpty( topDataVal.Info_Tip ))
																		{
																			info_tip=topDataVal.Info_Tip;
																		}

																		conDiv=conDiv+"<div class='rumHeaderText' style='border:0px solid red'>";
																			if ( !Ext.isEmpty( topDataVal.NoIcon ) && topDataVal.NoIcon=='YES')
																			{
																				conDiv=conDiv+"<span style='text-align:left;padding-left:0px' data-qclass='yellowTip' data-qtip='"+tool_tip+"'>"+topDataVal.Title+"</span>";
																			}
																			else
																			{
																				//<div style='height:22px;width:16px;float:left;margin-top:-1px;margin-right:3px'> <img class='rumIUnqUsers' src='/final/images/spacer.gif' /></div>
																				
																				if (info_tip!=null && info_tip!=undefined && info_tip!="")
																				{
																					conDiv=conDiv+"<table cellpadding='0' border='0' cellspacing='0' style='border:0px;'><tr><td><div class='rumHeaderText' style='margin-top:0px;text-align:center;padding-left:0px' data-qclass='yellowTip' data-qtip=''><span>"+topDataVal.Title+"</span></div></td><td style='padding-left:3px'><div class='iconRumInfo' style='border:none;margin-top:-1px' data-qclass='yellowTip' data-qtip='"+info_tip+"' border='0'></div></td></tr></table>";
																				}
																				else
																				{
																					conDiv=conDiv+"<div class='rumHeaderText' style='margin-top:0px;text-align:center;padding-left:0px'><span>"+topDataVal.Title+"</span></div>";
																				}
																				
																			}
																		conDiv=conDiv+"</div><div class='crl'></div>";
																	//conDiv=conDiv+"</tr></table>";

																	//conDiv=conDiv+"<table style='margin-top:60px'><tr>";
																		conDiv=conDiv+"<div style='white-space:nowrap;display:inline;margin-top:13px' class='rumSubheadText'>";
																			conDiv=conDiv+"<span class='rumValuesBig' style='margin-top:-9px;'>"+topDataVal.Value+"</span>&nbsp;"+topDataVal.Text;
																		conDiv=conDiv+"</div>";
																	//conDiv=conDiv+"</tr>";

																//conDiv=conDiv+"</table>";
															}
															else if ( !Ext.isEmpty( topDataVal.NoState ) && topDataVal.NoState=='NO')
															{
																conDiv=conDiv+"<div class='rumHeaderText' style='border:0px solid green'>";
																	if ( !Ext.isEmpty( topDataVal.NoIcon ) && topDataVal.NoIcon=='YES')
																	{
																		conDiv=conDiv+"<table width='100%' style='border:0px solid green'>";
																			conDiv=conDiv+"<tr>";
																				conDiv=conDiv+"<td width='20'><span>";
																					//conDiv=conDiv+"<div style='margin-top:-3px'><table ><tr><td ><img src='/final/images/spacer.gif' class='stateSymbol_"+topDataVal.State+"'/></td></tr></table></div>";
																				conDiv=conDiv+"</span></td>";
																				//conDiv=conDiv+"<th width='100%' class='rumHeaderText' style='padding-left:6px' data-qclass='yellowTip' data-qtip='"+tool_tip+"'>";
																				//conDiv=conDiv+topDataVal.Title;
																				var topDataValTitle = topDataVal.Title;
																				if(!Ext.isEmpty(topDataValTitle) && topDataValTitle.indexOf('Unique Sessions/IPs')>-1)
																				{	
																					conDiv=conDiv+"<th width='100%' class='rumHeaderText' style='text-align:center;white-space:normal' data-qclass='yellowTip' data-qtip='"+tool_tip+"'><span>";
																					conDiv=conDiv+topDataValTitle;
																				}
																				else{
																					conDiv=conDiv+"<th width='100%' class='rumHeaderText' style='text-align:center;padding-left:4px' data-qclass='yellowTip' data-qtip='"+tool_tip+"'><span>";
																					conDiv=conDiv+topDataValTitle;
																				}
																				conDiv=conDiv+"</span></th>";
																			conDiv=conDiv+"</tr>";
																		conDiv=conDiv+"</table>";
																	}
																	else
																	{
																		//<div style='height:22px;width:16px;float:left;margin-top:-1px;margin-right:3px'><img class='rumIUnqUsers' src='/final/images/spacer.gif' /></div> 
																		conDiv=conDiv+"<div style='text-align:center;padding-left:0px;white-space:nowrap' data-qclass='yellowTip' data-qtip='"+tool_tip+"'>"+topDataVal.Title+"</div>";
																	}
																conDiv=conDiv+"</div><div class='crl'></div>";

																conDiv=conDiv+"<div style='border:0px solid yellow;text-align:center;display:block;' class='rumSubheadText'>";
																	conDiv=conDiv+"<span style='border:0px solid red;margin-top:-9px' class='rumValuesBig rum_"+topDataVal.State+"'>"	+topDataVal.Value+"</span>&nbsp;"+topDataVal.Text;
																conDiv=conDiv+"</div>";
															}
															else
															{
																var headerAlign="";
																if (middleDataValArray.length<=1)
																{
																	headerAlign="margin:auto;";
																}
																else
																{
																	headerAlign="width:100%";
																}

																conDiv=conDiv+"<table style='"+headerAlign+";border:0px solid green'>";
																	conDiv=conDiv+"<tr>";
																		conDiv=conDiv+"<td width='20'>";
																			conDiv=conDiv+"<div style='margin-top:-3px'><table ><tr><td ><img src='/final/images/spacer.gif' class='stateSymbol_"+topDataVal.State+"'/></td></tr></table></div>";
																		conDiv=conDiv+"</td>";
																		conDiv=conDiv+"<th class='rumHeaderText' style='padding-left:6px' data-qclass='yellowTip' data-qtip='"+tool_tip+"'><span>";
																			conDiv=conDiv+topDataVal.Title;
																		conDiv=conDiv+"</span></th>";
																	conDiv=conDiv+"</tr>";
																conDiv=conDiv+"</table>";
															}
														}

														var conMiddleDiv="";
														if ( !Ext.isEmpty( middleDataValArray ) && middleDataValArray.length>0)
														{
															//conMiddleDiv=conMiddleDiv+"<div style='border:0px solid blue;margin-top:10px;display:block'><table align='left' style='text-align:right;border:0px solid red' class='rumSubheadText'><tr>";
															//conMiddleDiv=conMiddleDiv+"<div style='display:inline-block;border:0px solid red;width:20%'></div>";
															for(var maitem=0; maitem<middleDataValArray.length; maitem++)
															{
																var middleDataObj=middleDataValArray[maitem];

																var rumLine="";

																var panelW1="";

																if (maitem != middleDataValArray.length-1)
																{
																	rumLine="rumSeparatorSmall";
																}
																else
																{
																	rumLine="";
																}

																var panelW=(middleDataValArray.length==5)?"21%":"100%";

																if (!Ext.isEmpty(middleDataValArray))
																{
																		if (middleDataValArray.length==1)
																		{
																			panelW1="100%";
																		}
																		else if(middleDataValArray.length==2 && bottomDataVal.length==1)
																		{
																			panelW1="100%";
																		}
																		else if(middleDataValArray.length==5)
																		{
																			panelW1="21%";
																		}
																		else 
																		{
																			panelW1="50%";
																		}
																}
																//var panelW1=(middleDataValArray.length==5)?"21%":"50%";
		
																if ( !Ext.isEmpty(middleDataObj.Icon) && !Ext.isEmpty(middleDataObj.Text) && middleDataObj.Value>=0)
																{
																	
																	if(!Ext.isEmpty(middleDataObj.DD_URL))
																	{
																		conMiddleDiv=conMiddleDiv+"<div class='"+rumLine+"' style='border:0px solid blue;vertical-align:top;margin-top:0px;display:inline-block;float:none;'><div style='float:left;'><img class='rum"+middleDataObj.Icon+"' src='/final/images/spacer.gif'/></div><div style='padding-right:3px;float:left;text-align:left'><a href='javascript:void(0)' onclick='javascript:showDDPopup(\""+middleDataObj.DD_URL+"\")'><span class='rumVisitsText'>"+middleDataObj.Value+"</span><br/>"+middleDataObj.Text+"</a></div></div>";
																	}
																	else
																	{
																		conMiddleDiv=conMiddleDiv+"<div class='"+rumLine+"' style='border:0px solid black;vertical-align:top;margin-top:7px;display:inline-block;float:none;'><div style='float:left;'><img class='rum"+middleDataObj.Icon+"' src='/final/images/spacer.gif'/></div><div style='text-align:center;padding-right:3px;float:left'><span class='rumVisitsText'>"+middleDataObj.Value+"</span><br/>"+middleDataObj.Text+"</div></div>";
																	}
		

																	//<a href='javascript:void(0)' onclick='javascript:showDDDetails(\""+paramFor_dd+"\")'>"+sorted_info+"</a>
																}
																else if ( !Ext.isEmpty( middleDataObj.Text ))
																{
																	if (!Ext.isEmpty(middleDataObj.Unit))
																	{
																		if(!Ext.isEmpty(middleDataObj.DD_URL))
																		{
																			//conMiddleDiv=conMiddleDiv+"<table align='left' style='width:50%;text-align:right;border:0px solid orange;white-space:nowrap' class='rumSubheadText'><tr><td style='white-space:nowrap;text-align:center'><a href='javascript:void(0)' onclick='javascript:showDDPopup(\""+middleDataObj.DD_URL+"\")'><span class='rumValuesBig rum_"+middleDataObj.State+"' style='margin-top:5px'>"+middleDataObj.Value+'&nbsp;'+middleDataObj.Unit+"<\/span>&nbsp;"+middleDataObj.Text+"</a></td></tr></table>";
																			conMiddleDiv=conMiddleDiv+"<div style='width:50%;float:left;margin-top:-18px;text-align:center;border:0px solid orange;white-space:nowrap' class='rumSubheadText'><a href='javascript:void(0)' onclick='javascript:showDDPopup(\""+middleDataObj.DD_URL+"\")'><span class='rumValuesBig rum_"+middleDataObj.State+"' style='margin-top:5px'>"+middleDataObj.Value+'&nbsp;'+middleDataObj.Unit+"<\/span>&nbsp;"+middleDataObj.Text+"</a></div>";
																		}
																		else
																		{
																			conMiddleDiv=conMiddleDiv+"<div align='left' style='float:left;width:50%;text-align:right;border:0px solid red;white-space:nowrap' class='rumSubheadText'><span class='rumValuesBig rum_"+middleDataObj.State+"'>"+middleDataObj.Value+'&nbsp;'+middleDataObj.Unit+"</span>&nbsp;"+middleDataObj.Text+"</div>";
																		}
																	}
																	else
																	{
																		if(!Ext.isEmpty(middleDataObj.DD_URL))
																		{

																			conMiddleDiv=conMiddleDiv+"<div align='center' style='margin-top:-23px;float:left;width:"+panelW1+";text-align:center;border:0px solid red;white-space:nowrap' class='rumSubheadText'><a href='javascript:void(0)' onclick='javascript:showDDPopup(\""+middleDataObj.DD_URL+"\")'><span class='rumValuesBig rum_"+middleDataObj.State+"'>"+middleDataObj.Value+"<\/span>"+middleDataObj.Text+"</a></div>";
																		}
																		else
																		{
																			//var sparkWidth=(middleDataValArray.length==5)?"":"";
																			

																			conMiddleDiv=conMiddleDiv+"<div align='center' style='margin-top:-23px;float:left;width:"+panelW+";text-align:center;border:0px solid violet;white-space:nowrap' class='rumSubheadText'><span class='rumValuesBig rum_"+middleDataObj.State+"'>"+middleDataObj.Value+"</span>"+middleDataObj.Text+"</div>";
																		}
																	}
																}
															}
															//conMiddleDiv=conMiddleDiv+"</div>";
														}

														var conBottomDiv="<div></div>";
														var flag= false;
														var gDataVal="";
														var gTooltip="";
														if ( Ext.isEmpty( bottomDataVal ))
														{
															//var errorMsg = '<center><div style="height:30px;margin:5px 0 0 0"><img class="iconAlert" src="/final/images/spacer.gif"/>&nbsp;No measures available</div></center>';
															flag=true;
														}
															/*var errorMsg = '<div style="height:50px"><img src="/final/images/spacer.gif"/></div>';

															if(!Ext.isEmpty(bottomDataVal.graphData[0].DataSet) && !Ext.isEmpty(bottomDataVal.graphData[0].DataSet[0]))
															{
																gDataVal=bottomDataVal.graphData[0].DataSet[0].sparkdata;
																if ( !Ext.isEmpty( bottomDataVal.graphToolTip ))
																{
																	gTooltip=bottomDataVal.graphToolTip;
																}
															}
														}
														/*else
														{
															flag=true;
														}*/
														
														var separator={
															xtype:'tbseparator',
															cls:'rumSeparatorInner',
															padding:'0 0 0 0',
															margin:'0 0 0 0'
														};
														var newPanel = {
															id:'dataConId_'+siteItemNo+"_"+mditem+"_"+vitem,
															name:'sitePanelContainer',
															xtype:'container',
															style:{'border':'0px solid green'},
															//layout:'column',
															width:panelWidth,
															layout:'vbox',
															border:	false,
															padding:'0 0 0 0',
															height:130,
															margin:'8 0 0 0',
															collapsible: false,
															items:[
																{
																	xtype:'component',
																	name:'topPanel',
																	id:'top_'+siteItemNo+'_'+mditem+'_'+vitem,
																	itemid:'top_'+siteItemNo+'_'+mditem+'_'+vitem,
																	html:conDiv,
																	align:'center',
																	layout:{type:'vbox',pack:'center'},
																	collapsible: false,
																	style:{'text-align':'center !important'},
																	width:'100%'
																},															
																{
																	xtype:'component',
																	name:'middlePanel',
																	//cls:'xxxxxxxx',
																	id:'middle_'+siteItemNo+'_'+mditem+"_"+vitem,
																	itemid:'middle_'+siteItemNo+'_'+mditem+"_"+vitem,
																	html:conMiddleDiv,
																	align:'center',
																	collapsible: true,
																	//layout:{type:'vbox',pack:'center',align:'fit'},
																	style:{'margin-top':'6px','border':'0px solid green','text-align':'center !important'},
																	width:'100%',
																	hidden:false,
																},
																/*{
																				xtype:'component',
																				name:'bottomPanel',
																				itemid:'bottom_'+siteItemNo+'_'+mditem+"_"+vitem,
																				html:conBottomDiv,
																				//hidden:flag,
																				hidden:false,
																				collapsible: true,
																				align:'center',
																				gValue:gDataVal,
																				gTip:gTooltip,
																				width:150,
																				margin:'10 0 0 0',
																				style:{'border':'0px solid violet','text-align':'right !important'},
																				listeners:{
																					'afterrender': function(grpObj){
																						if(grpObj.gValue.length > 0)
																						{
																							jQuery("#"+grpObj.id).sparkline(grpObj.gValue, {
																							type: 'line',
																							width: '150',
																							lineColor: '#5994e9',
																							fillColor: '',
																							spotColor: '#d5870b',
																							minSpotColor: '#d5870b',
																							spotRadius: 3,
																							//gValue:gDataVal,
																							//gTip:gTooltip,
																							height:'50',
																							height:'30',
																							lineWidth:1.5,
																							highlightSpotColor:'#d5870b',
																							highlightLineColor:'#eed10f',
																							drawNormalOnTop: false,
																							tooltipClassname:'jqstooltip',
																							tooltipFormat:jQuery.spformat('{{y}} '+grpObj.gTip, 'tooltip-class')
																							});
																						}
																						else
																						{
																							grpObj.update(errorMsg);
																						}
																					}
																				}
																			}*/
																
															]
														};
														//thisObj.add(newPanel);
														thisObj.add(newPanel);
														if (vitem != sitePanelArray.length-1)
														{
															thisObj.add(separator);
														}
													}
												}
											}
											else
											{
												//var errorMsg='<center><img style="margin:3% 0 auto 0" src="/final/images/spacer.gif" class="iconAlert"/>&nbsp;&nbsp;<span class="rumErrorMsgText">Agent/Collector - Not Responding</span></center>';
												var errorMsg='<table align="center" style="margin:3% auto"><tr><td ><img style="margin-top:-2px" src="/final/images/spacer.gif" class="iconAlert"/></td><td>&nbsp;<span class="rumErrorMsgText">Agent/Collector - Not Responding</span></td><tr></table>';

												
												var err ={
															xtype:'container',
															columnWidth:1.0,
															html:errorMsg
														};
												thisObj.add(err);
											}
										}

												


										var showMoreLess = {
											xtype:'button',
											text:'Show More',
											idtext:'ShowMore',
											id:'showMoreLess_'+siteItemNo,
											name:'showMoreLess',
											style:{'border':'0px solid red'},
											hidden:false,
											align:'bottom',
											inxNo:siteItemNo,
											sName:siteNameVal,
											collapsible: true,
											width:80,
											height:20,
											listeners:{
												'click':function(lbl){
													var site = lbl.up('panel[name=site]');
													if(!Ext.isEmpty(site))
													{
														var sitePanels = site.items.items;
														if(!Ext.isEmpty(sitePanels))
														{
															if(!Ext.isEmpty(sitePanels) && sitePanels.length>0)
															{
																for(var q=0;q<sitePanels.length;q++)
																{
																	if(!Ext.isEmpty(sitePanels[q]) && sitePanels[q].name=='sitePanelContainer')
																	{
																		var siteInnerItem = sitePanels[q].items.items;
																		if(!Ext.isEmpty(siteInnerItem) && siteInnerItem.length>0)
																		{
																			for(var w=0;w<siteInnerItem.length;w++)
																			{
																				var pan = siteInnerItem[w];
																				if(!Ext.isEmpty(pan) && pan.name=='middlePanel')
																				{
																					if(pan.isVisible())
																					{
																						pan.hide();
																					}
																					else
																					{
																						pan.show();
																					}
																				}
																				else if(!Ext.isEmpty(pan) && pan.name=='bottomPanel')
																				{
																					if(!Ext.isEmpty(pan.gValue))
																					{
																						if(pan.isVisible())
																						{
																							pan.hide();
																						}
																						else
																						{
																							pan.show();
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
													if(lbl.idtext=='ShowMore')
													{
														lbl.setText('Show Less');
														lbl.idtext='ShowLess';
														//refSiteNames.push(name: lbl.sName);
													}
													else if(lbl.idtext=='ShowLess')
													{
														lbl.setText('Show More');
														lbl.idtext='ShowMore';
													}
												}
											}
										}

										//thisObj.add(showMoreLess);
									}
								}
							}
						}
					});
				}
			}
		};
		if(dailyLimitExceed==-100)
		{
			return dailyLimitExceed;
		}
		else
		{
			return site;
		}
	},
	getUpdateSiteDetailJson:function(jsonData,obj){
		
		if(obj!=null && obj!=undefined)
		{
			var inner_url = '/final/servlet/com.eg.RUMController?site='+encodeURI(obj.siteName)+'&accessType=allAccessType';

			var siteItemNo=obj.itemNo;
			var siteNameVal=obj.siteName;
			//Ext.Ajax.request({
				//url:inner_url,
				//method : 'POST',
				//scope:this,
				//timeout:300000,
				//topPanels:obj,
				///success:function(res)
				{
					//var innerJsonText = res.responseText;
					//if (!Ext.isEmpty( innerJsonText))
					{
						//var innerJsonData = Ext.decode(innerJsonText);
						var innerJsonData = jsonData;

						//delete innerJsonText;
						//Ext.destroy(innerJsonText);
						//innerJsonText = null;

						if ( !Ext.isEmpty( innerJsonData ))
						{
							if(!Ext.isEmpty( innerJsonData.NoSiteData ))
							{
								var errorMsg='<center><div style="margin:2% 0 auto 0"><div class="iconInformation" ></div><div class="commonErrorMsgText">No Traffic Detected</div></div></center>';
								var err ={
											xtype:'container',
											id:'errorSiteDetail',
											columnWidth:1.0,
											html:errorMsg
										};

								var rumOverviewObj = this.getRumOverviewTab();

								var topPanels = rumOverviewObj.items.items;
								if (!Ext.isEmpty( topPanels[0]))
								{
									var resultItems=topPanels[0].items.items;
									for(var item=resultItems.length-1; item>-1 ; item--)
									{
										resultItems[item].destroy();
									}
								}

								topPanels[0].add(err);
							}
							else if(!Ext.isEmpty(innerJsonData.siteMeaDataArray ))
							{
								var sitesDataArray=innerJsonData.siteMeaDataArray;
								for(var mditem=0; mditem<sitesDataArray.length; mditem++)
								{
									var siteDataItemJson=sitesDataArray[mditem];

									if ( !Ext.isEmpty( siteDataItemJson.sitePanelArray ))
									{
										var sitePanelArray=siteDataItemJson.sitePanelArray;
										for(var vitem=0; vitem<sitePanelArray.length; vitem++)
										{
											var sitePanelItemJson=sitePanelArray[vitem];
											if(!Ext.isEmpty( sitePanelItemJson.DayLimitExceed ) && sitePanelItemJson.DayLimitExceed=='true')
											{
												var errorMsg='<table height="100%" align="center" style="margin:2% auto"><tr><td ><img style="margin-top:-2px" src="/final/images/spacer.gif" class="iconAlert"/></td><td>&nbsp;<span class="rumErrorMsgText">Daily limit has been exceeded</span></td><tr></table>';

												var err ={
															xtype:'container',
															id:'errorSiteDetail',
															columnWidth:1.0,
															html:errorMsg
														};

												var rumOverviewObj = this.getRumOverviewTab();

												var topPanels = rumOverviewObj.items.items;
												if (!Ext.isEmpty( topPanels[0]))
												{
													var resultItems=topPanels[0].items.items;
													for(var item=resultItems.length-1; item>-1 ; item--)
													{
														resultItems[item].destroy();
													}
												}

												topPanels[0].add(err);
											}
											else
											{
												var topDataVal=sitePanelItemJson.topData;

												var middleDataValArray=sitePanelItemJson.middleDataArray;

												var bottomDataVal=sitePanelItemJson.bottomData;

												var panelWidth=sitePanelItemJson.panelWidth;

												var conDiv="";

												if ( !Ext.isEmpty( topDataVal ))
												{
													var tool_tip="";
													if ( !Ext.isEmpty( topDataVal.Text_ToolTip ) && topDataVal.Text_ToolTip!=undefined)
													{
														tool_tip=topDataVal.Text_ToolTip;
													}

													if ( !Ext.isEmpty( topDataVal.NoState ) && topDataVal.NoState=='YES')
													{
														//conDiv=conDiv+"<table  width='100%' style='border:1px solid green'>";
															//conDiv=conDiv+"<tr>";
																var info_tip="";
																if ( !Ext.isEmpty( topDataVal.Info_Tip ))
																{
																	info_tip=topDataVal.Info_Tip;
																}

																conDiv=conDiv+"<div class='rumHeaderText' style='border:0px solid red'>";
																	if ( !Ext.isEmpty( topDataVal.NoIcon ) && topDataVal.NoIcon=='YES')
																	{
																		conDiv=conDiv+"<div style='text-align:center;padding-left:0px' data-qclass='yellowTip' data-qtip='"+tool_tip+"'>"+topDataVal.Title+"</div>";
																	}
																	else
																	{
																		//<div style='height:22px;width:16px;float:left;margin-top:-1px;margin-right:3px'> <img class='rumIUnqUsers' src='/final/images/spacer.gif' /></div>
																		
																		if (info_tip!=null && info_tip!=undefined && info_tip!="")
																		{
																			conDiv=conDiv+"<table cellpadding='0' border='0' cellspacing='0' style='border:0px solid red;margin:auto'><tr><td><div class='rumHeaderText' style='margin-top:0px;text-align:center;padding-left:0px' data-qclass='yellowTip' data-qtip=''>"+topDataVal.Title+"</div></td><td style='padding-left:3px'><div class='iconRumInfo' style='border:none;margin-top:-1px' data-qclass='yellowTip' data-qtip='"+info_tip+"' border='0'></div></td></tr></table>";
																		}
																		else
																		{
																			conDiv=conDiv+"<div class='rumHeaderText' style='margin-top:0px;text-align:center;padding-left:0px'><span>"+topDataVal.Title+"</span></div>";
																		}
																		
																	}
																conDiv=conDiv+"</div><div class='crl'></div>";
															//conDiv=conDiv+"</tr></table>";

															//conDiv=conDiv+"<table style='margin-top:60px'><tr>";
																conDiv=conDiv+"<div style='border:0px solid red;margin-top:-18px;white-space:nowrap;' class='rumSubheadText'>";
																	conDiv=conDiv+"<span class='rumValuesBig' style='border:0px solid red;'>"+topDataVal.Value+"</span>&nbsp;"+topDataVal.Text;
																conDiv=conDiv+"</div>";
															//conDiv=conDiv+"</tr>";

														//conDiv=conDiv+"</table>";
													}
													else if ( !Ext.isEmpty( topDataVal.NoState ) && topDataVal.NoState=='NO')
													{
														conDiv=conDiv+"<div class='rumHeaderText' style='border:0px solid green'>";
															if ( !Ext.isEmpty( topDataVal.NoIcon ) && topDataVal.NoIcon=='YES')
															{
																conDiv=conDiv+"<table width='100%' style='border:0px solid green'>";
																	conDiv=conDiv+"<tr>";
																		conDiv=conDiv+"<td width='20'>";
																			//conDiv=conDiv+"<div style='margin-top:-3px'><table ><tr><td ><img src='/final/images/spacer.gif' class='stateSymbol_"+topDataVal.State+"'/></td></tr></table></div>";
																		conDiv=conDiv+"</td>";
																		//conDiv=conDiv+"<th width='100%' class='rumHeaderText' style='padding-left:6px' data-qclass='yellowTip' data-qtip='"+tool_tip+"'>";
																			//conDiv=conDiv+topDataVal.Title;
																		var topDataValTitle = topDataVal.Title;
																		if(!Ext.isEmpty(topDataValTitle) && topDataValTitle.indexOf('Unique Sessions/IPs')>-1)
																		{	
																			conDiv=conDiv+"<th width='100%' class='rumHeaderText' style='text-align:center;white-space:normal' data-qclass='yellowTip' data-qtip='"+tool_tip+"'><span>";
																			conDiv=conDiv+topDataValTitle;
																		}
																		else{
																			conDiv=conDiv+"<th width='100%' class='rumHeaderText' style='text-align:center;padding-left:4px' data-qclass='yellowTip' data-qtip='"+tool_tip+"'><span>";
																			conDiv=conDiv+topDataValTitle;
																		}
																		conDiv=conDiv+",</span></th>";
																	conDiv=conDiv+"</tr>";
																conDiv=conDiv+"</table>";
															}
															else
															{
																//<div style='height:22px;width:16px;float:left;margin-top:-1px;margin-right:3px'><img class='rumIUnqUsers' src='/final/images/spacer.gif' /></div> 
																conDiv=conDiv+"<div style='text-align:center;padding-left:0px;white-space:nowrap' data-qclass='yellowTip' data-qtip='"+tool_tip+"'>"+topDataVal.Title+"</div>";
															}
														conDiv=conDiv+"</div><div class='crl'></div>";

														conDiv=conDiv+"<div style='border:0px solid blue;text-align:center;display:block;' class='rumSubheadText'>";
															conDiv=conDiv+"<span style='margin-top:-9px' class='rumValuesBig rum_"+topDataVal.State+"'>"+topDataVal.Value+"</span>&nbsp;"+topDataVal.Text;
														conDiv=conDiv+"</div>";
													}
													else
													{
														var headerAlign="";
														if (middleDataValArray.length<=1)
														{
															headerAlign="margin:auto;";
														}
														else
														{
															headerAlign="width:100%;";
														}

														conDiv=conDiv+"<table style='"+headerAlign+";border:0px solid green'>";
															conDiv=conDiv+"<tr>";
																conDiv=conDiv+"<td width='20'>";
																	conDiv=conDiv+"<div style='margin-top:-3px'><table ><tr><td ><img src='/final/images/spacer.gif' class='stateSymbol_"+topDataVal.State+"'/></td></tr></table></div>";
																conDiv=conDiv+"</td>";
																conDiv=conDiv+"<th class='rumHeaderText' style='padding-left:6px' data-qclass='yellowTip' data-qtip='"+tool_tip+"'><span>";
																	conDiv=conDiv+topDataVal.Title;
																conDiv=conDiv+"</span></th>";
															conDiv=conDiv+"</tr>";
														conDiv=conDiv+"</table>";
													}
												}

												var conMiddleDiv="";
												if ( !Ext.isEmpty( middleDataValArray ) && middleDataValArray.length>0)
												{
													//conMiddleDiv=conMiddleDiv+"<div style='border:0px solid blue;margin-top:10px;display:block'><table align='left' style='text-align:right;border:0px solid red' class='rumSubheadText'><tr>";
													//conMiddleDiv=conMiddleDiv+"<div style='display:inline-block;border:0px solid red;width:20%'></div>";
													for(var maitem=0; maitem<middleDataValArray.length; maitem++)
													{
														var middleDataObj=middleDataValArray[maitem];

														var rumLine="";

														var panelW1="";

														if (maitem != middleDataValArray.length-1)
														{
															rumLine="rumSeparatorSmall";
														}
														else
														{
															rumLine="";
														}

														var panelW=(middleDataValArray.length==5)?"21%":"100%";

														if (!Ext.isEmpty(middleDataValArray))
														{
																if (middleDataValArray.length==1)
																{
																	panelW1="100%";
																}
																else if(middleDataValArray.length==2 && bottomDataVal.length==1)
																{
																	panelW1="100%";
																}
																else if(middleDataValArray.length==5)
																{
																	panelW1="21%";
																}
																else 
																{
																	panelW1="50%";
																}
														}
														//var panelW1=(middleDataValArray.length==5)?"21%":"50%";

														if ( !Ext.isEmpty(middleDataObj.Icon) && !Ext.isEmpty(middleDataObj.Text) && middleDataObj.Value>=0)
														{
															
															if(!Ext.isEmpty(middleDataObj.DD_URL))
															{
																conMiddleDiv=conMiddleDiv+"<div class='"+rumLine+"' style='border:0px solid blue;vertical-align:top;margin-top:-15px;display:inline-block;float:none;'><div style='float:left;'><img class='rum"+middleDataObj.Icon+"' src='/final/images/spacer.gif'/></div><div style='padding-right:3px;float:left;text-align:center'><a href='javascript:void(0)' onclick='javascript:showDDPopup(\""+middleDataObj.DD_URL+"\")'><span class='rumVisitsText'>"+middleDataObj.Value+"</span><br/>"+middleDataObj.Text+"</a></div></div>";
															}
															else
															{
																conMiddleDiv=conMiddleDiv+"<div class='"+rumLine+"' style='vertical-align:top;margin-top:7px;display:inline-block;float:none;'><div style='float:left;'><img class='rum"+middleDataObj.Icon+"' src='/final/images/spacer.gif'/></div><div style='text-align:center;padding-right:3px;float:left'><span class='rumVisitsText'>"+middleDataObj.Value+"</span><br/>"+middleDataObj.Text+"</div></div>";
															}


															//<a href='javascript:void(0)' onclick='javascript:showDDDetails(\""+paramFor_dd+"\")'>"+sorted_info+"</a>
														}
														else if ( !Ext.isEmpty( middleDataObj.Text ))
														{
															if (!Ext.isEmpty(middleDataObj.Unit))
															{
																if(!Ext.isEmpty(middleDataObj.DD_URL))
																{
																	//conMiddleDiv=conMiddleDiv+"<table align='left' style='width:50%;text-align:right;border:0px solid orange;white-space:nowrap' class='rumSubheadText'><tr><td style='white-space:nowrap;text-align:center'><a href='javascript:void(0)' onclick='javascript:showDDPopup(\""+middleDataObj.DD_URL+"\")'><span class='rumValuesBig rum_"+middleDataObj.State+"' style='margin-top:5px'>"+middleDataObj.Value+'&nbsp;'+middleDataObj.Unit+"<\/span>&nbsp;"+middleDataObj.Text+"</a></td></tr></table>";
																	conMiddleDiv=conMiddleDiv+"<div style='width:50%;float:left;margin-top:-15px;text-align:center;border:0px solid orange;white-space:nowrap' class='rumSubheadText'><a href='javascript:void(0)' onclick='javascript:showDDPopup(\""+middleDataObj.DD_URL+"\")'><span class='rumValuesBig rum_"+middleDataObj.State+"' style='margin-top:5px'>"+middleDataObj.Value+'&nbsp;'+middleDataObj.Unit+"<\/span>&nbsp;"+middleDataObj.Text+"</a></div>";
																}
																else
																{
																	conMiddleDiv=conMiddleDiv+"<div align='left' style='float:left;width:50%;text-align:right;border:0px solid red;white-space:nowrap' class='rumSubheadText'><span class='rumValuesBig rum_"+middleDataObj.State+"'>"+middleDataObj.Value+'&nbsp;'+middleDataObj.Unit+"</span>&nbsp;"+middleDataObj.Text+"</div>";
																}
															}
															else
															{
																if(!Ext.isEmpty(middleDataObj.DD_URL))
																{

																	conMiddleDiv=conMiddleDiv+"<div align='center' style='margin-top:-23px;float:left;width:"+panelW1+";text-align:center;border:0px solid violet;white-space:nowrap' class='rumSubheadText'><a href='javascript:void(0)' onclick='javascript:showDDPopup(\""+middleDataObj.DD_URL+"\")'><span class='rumValuesBig rum_"+middleDataObj.State+"'>"+middleDataObj.Value+"<\/span>"+middleDataObj.Text+"</a></div>";
																}
																else
																{
																	//var sparkWidth=(middleDataValArray.length==5)?"":"";
																	

																	conMiddleDiv=conMiddleDiv+"<div align='center' style='margin-top:-23px;float:left;width:"+panelW+";text-align:center;border:0px solid orange;white-space:nowrap' class='rumSubheadText'><span class='rumValuesBig rum_"+middleDataObj.State+"'>"+middleDataObj.Value+"</span>"+middleDataObj.Text+"</div>";
																}
															}
														}
													}
													//conMiddleDiv=conMiddleDiv+"</div>";
												}

												var conBottomDiv="<div></div>";
												var flag= false;
												var gDataVal="";
												var gTooltip="";
												if ( Ext.isEmpty( bottomDataVal ))
												{
													//var errorMsg = '<center><div style="height:30px;margin:5px 0 0 0"><img class="iconAlert" src="/final/images/spacer.gif"/>&nbsp;No measures available</div></center>';
													flag=true;
												}

												var  topPanelId = Ext.getCmp('top_'+siteItemNo+'_'+mditem+'_'+vitem);

												if(topPanelId!=null && topPanelId!=undefined)
												{
													topPanelId.update(conDiv);
												}

												var  middlePanelId = Ext.getCmp('middle_'+siteItemNo+'_'+mditem+"_"+vitem);

												if(middlePanelId!=null && middlePanelId!=undefined)
												{
													middlePanelId.update(conMiddleDiv);
												}
												
												/*var separator={
													xtype:'tbseparator',
													cls:'rumSeparatorInner',
													padding:'0 0 0 0',
													margin:'8 0 0 0'
												};

												var newPanel = {
													id:'dataConId_'+siteItemNo+"_"+mditem+"_"+vitem,
													name:'sitePanelContainer',
													xtype:'container',
													style:{'border':'0px solid green'},
													//layout:'column',
													width:panelWidth,
													layout:'vbox',
													border:false,
													padding:'0 0 0 0',
													height:130,
													margin:'8 0 0 0',
													collapsible: false,
													items:[
														{
															xtype:'component',
															name:'topPanel',
															itemid:'top_'+siteItemNo+'_'+mditem+'_'+vitem,
															html:conDiv,
															align:'center',
															layout:{type:'vbox',pack:'center'},
															collapsible: false,
															style:{'text-align':'center !important'},
															width:'100%'
														},
														{
															xtype:'component',
															name:'middlePanel',
															//cls:'xxxxxxxx',
															itemid:'middle_'+siteItemNo+'_'+mditem+"_"+vitem,
															html:conMiddleDiv,
															align:'center',
															collapsible: true,
															//layout:{type:'vbox',pack:'center',align:'fit'},
															style:{'margin-top':'6px','border':'0px solid green','text-align':'center !important'},
															width:'100%',
															hidden:false,
														},
													]
												};

												thisObj.add(newPanel);

												if (vitem != sitePanelArray.length-1)
												{
													thisObj.add(separator);
												}*/
											}
										}
									}
									else
									{
										//var errorMsg='<center><img style="margin:3% 0 auto 0" src="/final/images/spacer.gif" class="iconAlert"/>&nbsp;&nbsp;<span class="rumErrorMsgText">Agent/Collector - Not Responding</span></center>';
										var errorMsg='<table align="center" style="margin:3% auto"><tr><td ><img style="margin-top:-2px" src="/final/images/spacer.gif" class="iconAlert"/></td><td>&nbsp;<span class="rumErrorMsgText">Agent/Collector - Not Responding</span></td><tr></table>';
										var err ={
													xtype:'container',
													id:'errorSiteDetail',
													columnWidth:1.0,
													html:errorMsg
												};
										var rumOverviewObj = this.getRumOverviewTab();

										var topPanels = rumOverviewObj.items.items;
										if (!Ext.isEmpty( topPanels[0]))
										{
											var resultItems=topPanels[0].items.items;
											for(var item=resultItems.length-1; item>-1 ; item--)
											{
												resultItems[item].destroy();
											}
										}

										topPanels[0].add(err);
									}
								}
							}
						}
					}
				}
			//});
		}
	},
	getUpdateSiteDetail:function(obj)
	{
		if(obj!=null && obj!=undefined)
		{
			var inner_url = '/final/servlet/com.eg.RUMController?site='+encodeURI(obj.siteName)+'&accessType=allAccessType';

			var siteItemNo=obj.itemNo;
			var siteNameVal=obj.siteName;
			Ext.Ajax.request({
				url:inner_url,
				method : 'POST',
				scope:this,
				timeout:300000,
				topPanels:obj,
				success:function(res)
				{
					var innerJsonText = res.responseText;
					if (!Ext.isEmpty( innerJsonText))
					{
						var innerJsonData = Ext.decode(innerJsonText);

						delete innerJsonText;
						Ext.destroy(innerJsonText);
						innerJsonText = null;

						if ( !Ext.isEmpty( innerJsonData ))
						{
							if(!Ext.isEmpty( innerJsonData.NoSiteData ))
							{
								var errorMsg='<center><div style="margin:2% 0 auto 0"><div class="iconInformation" ></div><div class="commonErrorMsgText">No Traffic Detected</div></div></center>';
								var err ={
											xtype:'container',
											id:'errorSiteDetail',
											columnWidth:1.0,
											html:errorMsg
										};

								var rumOverviewObj = this.getRumOverviewTab();

								var topPanels = rumOverviewObj.items.items;
								if (!Ext.isEmpty( topPanels[0]))
								{
									var resultItems=topPanels[0].items.items;
									for(var item=resultItems.length-1; item>-1 ; item--)
									{
										resultItems[item].destroy();
									}
								}

								topPanels[0].add(err);
							}
							else if(!Ext.isEmpty(innerJsonData.siteMeaDataArray ))
							{
								var sitesDataArray=innerJsonData.siteMeaDataArray;
								for(var mditem=0; mditem<sitesDataArray.length; mditem++)
								{
									var siteDataItemJson=sitesDataArray[mditem];

									if ( !Ext.isEmpty( siteDataItemJson.sitePanelArray ))
									{
										var sitePanelArray=siteDataItemJson.sitePanelArray;
										for(var vitem=0; vitem<sitePanelArray.length; vitem++)
										{
											var sitePanelItemJson=sitePanelArray[vitem];
											if(!Ext.isEmpty( sitePanelItemJson.DayLimitExceed ) && sitePanelItemJson.DayLimitExceed=='true')
											{
												var errorMsg='<table height="100%" align="center" style="margin:3% auto"><tr><td ><img style="margin-top:-2px" src="/final/images/spacer.gif" class="iconAlert"/></td><td>&nbsp;<span class="rumErrorMsgText">Daily limit has been exceeded</span></td><tr></table>';

												var err ={
															xtype:'container',
															id:'errorSiteDetail',
															columnWidth:1.0,
															html:errorMsg
														};

												var rumOverviewObj = this.getRumOverviewTab();

												var topPanels = rumOverviewObj.items.items;
												if (!Ext.isEmpty( topPanels[0]))
												{
													var resultItems=topPanels[0].items.items;
													for(var item=resultItems.length-1; item>-1 ; item--)
													{
														resultItems[item].destroy();
													}
												}

												topPanels[0].add(err);
											}
											else
											{
												var topDataVal=sitePanelItemJson.topData;

												var middleDataValArray=sitePanelItemJson.middleDataArray;

												var bottomDataVal=sitePanelItemJson.bottomData;

												var panelWidth=sitePanelItemJson.panelWidth;

												var conDiv="";

												if ( !Ext.isEmpty( topDataVal ))
												{
													var tool_tip="";
													if ( !Ext.isEmpty( topDataVal.Text_ToolTip ) && topDataVal.Text_ToolTip!=undefined)
													{
														tool_tip=topDataVal.Text_ToolTip;
													}

													if ( !Ext.isEmpty( topDataVal.NoState ) && topDataVal.NoState=='YES')
													{
														//conDiv=conDiv+"<table  width='100%' style='border:1px solid green'>";
															//conDiv=conDiv+"<tr>";
																var info_tip="";
																if ( !Ext.isEmpty( topDataVal.Info_Tip ))
																{
																	info_tip=topDataVal.Info_Tip;
																}

																conDiv=conDiv+"<div class='rumHeaderText' style='border:0px solid red'>";
																	if ( !Ext.isEmpty( topDataVal.NoIcon ) && topDataVal.NoIcon=='YES')
																	{
																		conDiv=conDiv+"<div style='text-align:center;padding-left:0px' data-qclass='yellowTip' data-qtip='"+tool_tip+"'>"+topDataVal.Title+"</div>";
																	}
																	else
																	{
																		//<div style='height:22px;width:16px;float:left;margin-top:-1px;margin-right:3px'> <img class='rumIUnqUsers' src='/final/images/spacer.gif' /></div>
																		
																		if (info_tip!=null && info_tip!=undefined && info_tip!="")
																		{
																			conDiv=conDiv+"<table cellpadding='0' border='0' cellspacing='0' style='border:0px;margin:auto'><tr><td><div class='rumHeaderText' style='margin-top:0px;text-align:center;padding-left:0px' data-qclass='yellowTip' data-qtip=''>"+topDataVal.Title+"</div></td><td style='padding-left:3px'><div class='iconRumInfo' style='border:none;margin-top:-1px' data-qclass='yellowTip' data-qtip='"+info_tip+"' border='0'></div></td></tr></table>";
																		}
																		else
																		{
																			conDiv=conDiv+"<div class='rumHeaderText' style='margin-top:0px;text-align:center;padding-left:0px'>"+topDataVal.Title+"</div>";
																		}
																		
																	}
																conDiv=conDiv+"</div><div class='crl'></div>";
															//conDiv=conDiv+"</tr></table>";

															//conDiv=conDiv+"<table style='margin-top:60px'><tr>";
																conDiv=conDiv+"<div style='white-space:nowrap;display:inline;margin-top:23px' class='rumSubheadText'>";
																	conDiv=conDiv+"<span class='rumValuesBig' style='margin-top:17px;'>"+topDataVal.Value+"</span>&nbsp;"+topDataVal.Text;
																conDiv=conDiv+"</div>";
															//conDiv=conDiv+"</tr>";

														//conDiv=conDiv+"</table>";
													}
													else if ( !Ext.isEmpty( topDataVal.NoState ) && topDataVal.NoState=='NO')
													{
														conDiv=conDiv+"<div class='rumHeaderText' style='border:0px solid green'>";
															if ( !Ext.isEmpty( topDataVal.NoIcon ) && topDataVal.NoIcon=='YES')
															{
																conDiv=conDiv+"<table width='100%' style='border:0px solid green'>";
																	conDiv=conDiv+"<tr>";
																		conDiv=conDiv+"<td width='20'>";
																			//conDiv=conDiv+"<div style='margin-top:-3px'><table ><tr><td ><img src='/final/images/spacer.gif' class='stateSymbol_"+topDataVal.State+"'/></td></tr></table></div>";
																		conDiv=conDiv+"</td>";
																		//conDiv=conDiv+"<th width='100%' class='rumHeaderText' style='padding-left:6px' data-qclass='yellowTip' data-qtip='"+tool_tip+"'>";
																			//conDiv=conDiv+topDataVal.Title;
																			var topDataValTitle = topDataVal.Title;
																			if(!Ext.isEmpty(topDataValTitle) && topDataValTitle.indexOf('Unique Sessions/IPs')>-1)
																			{	
																				conDiv=conDiv+"<th width='100%' class='rumHeaderText' style='text-align:center;white-space:normal' data-qclass='yellowTip' data-qtip='"+tool_tip+"'><span>";
																				conDiv=conDiv+topDataValTitle;
																			}
																			else{
																				conDiv=conDiv+"<th width='100%' class='rumHeaderText' style='text-align:center;padding-left:4px' data-qclass='yellowTip' data-qtip='"+tool_tip+"'><span>";
																				conDiv=conDiv+topDataValTitle;
																			}
																		conDiv=conDiv+"</span></th>";
																	conDiv=conDiv+"</tr>";
																conDiv=conDiv+"</table>";
															}
															else
															{
																//<div style='height:22px;width:16px;float:left;margin-top:-1px;margin-right:3px'><img class='rumIUnqUsers' src='/final/images/spacer.gif' /></div> 
																conDiv=conDiv+"<div style='text-align:center;padding-left:0px;white-space:nowrap' data-qclass='yellowTip' data-qtip='"+tool_tip+"'>"+topDataVal.Title+"</div>";
															}
														conDiv=conDiv+"</div><div class='crl'></div>";

														conDiv=conDiv+"<div style='border:0px solid blue;text-align:center;display:block;' class='rumSubheadText'>";
															conDiv=conDiv+"<span style='margin-top:14px' class='rumValuesBig rum_"+topDataVal.State+"'>"+topDataVal.Value+"</span>&nbsp;"+topDataVal.Text;
														conDiv=conDiv+"</div>";
													}
													else
													{
														var headerAlign="";
														if (middleDataValArray.length<=1)
														{
															headerAlign="margin:auto;";
														}
														else
														{
															headerAlign="width:100%;";
														}

														conDiv=conDiv+"<table style='"+headerAlign+";border:0px solid green'>";
															conDiv=conDiv+"<tr>";
																conDiv=conDiv+"<td width='20'>";
																	conDiv=conDiv+"<div style='margin-top:-3px'><table ><tr><td ><img src='/final/images/spacer.gif' class='stateSymbol_"+topDataVal.State+"'/></td></tr></table></div>";
																conDiv=conDiv+"</td>";
																conDiv=conDiv+"<th class='rumHeaderText' style='padding-left:6px' data-qclass='yellowTip' data-qtip='"+tool_tip+"'><span>";
																	conDiv=conDiv+topDataVal.Title;
																conDiv=conDiv+"</span></th>";
															conDiv=conDiv+"</tr>";
														conDiv=conDiv+"</table>";
													}
												}

												var conMiddleDiv="";
												if ( !Ext.isEmpty( middleDataValArray ) && middleDataValArray.length>0)
												{
													//conMiddleDiv=conMiddleDiv+"<div style='border:0px solid blue;margin-top:10px;display:block'><table align='left' style='text-align:right;border:0px solid red' class='rumSubheadText'><tr>";
													//conMiddleDiv=conMiddleDiv+"<div style='display:inline-block;border:0px solid red;width:20%'></div>";
													for(var maitem=0; maitem<middleDataValArray.length; maitem++)
													{
														var middleDataObj=middleDataValArray[maitem];

														var rumLine="";

														var panelW1="";

														if (maitem != middleDataValArray.length-1)
														{
															rumLine="rumSeparatorSmall";
														}
														else
														{
															rumLine="";
														}

														var panelW=(middleDataValArray.length==5)?"21%":"100%";

														if (!Ext.isEmpty(middleDataValArray))
														{
																if (middleDataValArray.length==1)
																{
																	panelW1="100%";
																}
																else if(middleDataValArray.length==2 && bottomDataVal.length==1)
																{
																	panelW1="100%";
																}
																else if(middleDataValArray.length==5)
																{
																	panelW1="21%";
																}
																else 
																{
																	panelW1="50%";
																}
														}
														//var panelW1=(middleDataValArray.length==5)?"21%":"50%";

														if ( !Ext.isEmpty(middleDataObj.Icon) && !Ext.isEmpty(middleDataObj.Text) && middleDataObj.Value>=0)
														{
															
															if(!Ext.isEmpty(middleDataObj.DD_URL))
															{
																conMiddleDiv=conMiddleDiv+"<div class='"+rumLine+"' style='border:0px solid blue;vertical-align:top;margin-top:7px;display:inline-block;float:none;'><div style='float:left;'><img class='rum"+middleDataObj.Icon+"' src='/final/images/spacer.gif'/></div><div style='padding-right:3px;float:left;text-align:center'><a href='javascript:void(0)' onclick='javascript:showDDPopup(\""+middleDataObj.DD_URL+"\")'><span class='rumVisitsText'>"+middleDataObj.Value+"</span><br/>"+middleDataObj.Text+"</a></div></div>";
															}
															else
															{
																conMiddleDiv=conMiddleDiv+"<div class='"+rumLine+"' style='vertical-align:top;margin-top:7px;display:inline-block;float:none;'><div style='float:left;'><img class='rum"+middleDataObj.Icon+"' src='/final/images/spacer.gif'/></div><div style='text-align:center;padding-right:3px;float:left'><span class='rumVisitsText'>"+middleDataObj.Value+"</span><br/>"+middleDataObj.Text+"</div></div>";
															}


															//<a href='javascript:void(0)' onclick='javascript:showDDDetails(\""+paramFor_dd+"\")'>"+sorted_info+"</a>
														}
														else if ( !Ext.isEmpty( middleDataObj.Text ))
														{
															if (!Ext.isEmpty(middleDataObj.Unit))
															{
																if(!Ext.isEmpty(middleDataObj.DD_URL))
																{
																	//conMiddleDiv=conMiddleDiv+"<table align='left' style='width:50%;text-align:right;border:0px solid orange;white-space:nowrap' class='rumSubheadText'><tr><td style='white-space:nowrap;text-align:center'><a href='javascript:void(0)' onclick='javascript:showDDPopup(\""+middleDataObj.DD_URL+"\")'><span class='rumValuesBig rum_"+middleDataObj.State+"' style='margin-top:5px'>"+middleDataObj.Value+'&nbsp;'+middleDataObj.Unit+"<\/span>&nbsp;"+middleDataObj.Text+"</a></td></tr></table>";
																	conMiddleDiv=conMiddleDiv+"<div style='width:50%;float:left;margin-top:6px;text-align:center;border:0px solid orange;white-space:nowrap' class='rumSubheadText'><a href='javascript:void(0)' onclick='javascript:showDDPopup(\""+middleDataObj.DD_URL+"\")'><span class='rumValuesBig rum_"+middleDataObj.State+"' style='margin-top:5px'>"+middleDataObj.Value+'&nbsp;'+middleDataObj.Unit+"<\/span>&nbsp;"+middleDataObj.Text+"</a></div>";
																}
																else
																{
																	conMiddleDiv=conMiddleDiv+"<div align='left' style='float:left;width:50%;text-align:right;border:0px solid red;white-space:nowrap' class='rumSubheadText'><span class='rumValuesBig rum_"+middleDataObj.State+"'>"+middleDataObj.Value+'&nbsp;'+middleDataObj.Unit+"</span>&nbsp;"+middleDataObj.Text+"</div>";
																}
															}
															else
															{
																if(!Ext.isEmpty(middleDataObj.DD_URL))
																{

																	conMiddleDiv=conMiddleDiv+"<div align='center' style='float:left;width:"+panelW1+";text-align:center;border:0px solid blue;white-space:nowrap' class='rumSubheadText'><a href='javascript:void(0)' onclick='javascript:showDDPopup(\""+middleDataObj.DD_URL+"\")'><span class='rumValuesBig rum_"+middleDataObj.State+"'>"+middleDataObj.Value+"<\/span>"+middleDataObj.Text+"</a></div>";
																}
																else
																{
																	//var sparkWidth=(middleDataValArray.length==5)?"":"";
																	

																	conMiddleDiv=conMiddleDiv+"<div align='center' style='float:left;width:"+panelW+";text-align:center;border:0px solid orange;white-space:nowrap' class='rumSubheadText'><span class='rumValuesBig rum_"+middleDataObj.State+"'>"+middleDataObj.Value+"</span>"+middleDataObj.Text+"</div>";
																}
															}
														}
													}
													//conMiddleDiv=conMiddleDiv+"</div>";
												}

												var conBottomDiv="<div></div>";
												var flag= false;
												var gDataVal="";
												var gTooltip="";
												if ( Ext.isEmpty( bottomDataVal ))
												{
													//var errorMsg = '<center><div style="height:30px;margin:5px 0 0 0"><img class="iconAlert" src="/final/images/spacer.gif"/>&nbsp;No measures available</div></center>';
													flag=true;
												}

												var  topPanelId = Ext.getCmp('top_'+siteItemNo+'_'+mditem+'_'+vitem);

												if(topPanelId!=null && topPanelId!=undefined)
												{
													topPanelId.update(conDiv);
												}

												var  middlePanelId = Ext.getCmp('middle_'+siteItemNo+'_'+mditem+"_"+vitem);

												if(middlePanelId!=null && middlePanelId!=undefined)
												{
													middlePanelId.update(conMiddleDiv);
												}
												
												/*var separator={
													xtype:'tbseparator',
													cls:'rumSeparatorInner',
													padding:'0 0 0 0',
													margin:'8 0 0 0'
												};

												var newPanel = {
													id:'dataConId_'+siteItemNo+"_"+mditem+"_"+vitem,
													name:'sitePanelContainer',
													xtype:'container',
													style:{'border':'0px solid green'},
													//layout:'column',
													width:panelWidth,
													layout:'vbox',
													border:false,
													padding:'0 0 0 0',
													height:130,
													margin:'8 0 0 0',
													collapsible: false,
													items:[
														{
															xtype:'component',
															name:'topPanel',
															itemid:'top_'+siteItemNo+'_'+mditem+'_'+vitem,
															html:conDiv,
															align:'center',
															layout:{type:'vbox',pack:'center'},
															collapsible: false,
															style:{'text-align':'center !important'},
															width:'100%'
														},
														{
															xtype:'component',
															name:'middlePanel',
															//cls:'xxxxxxxx',
															itemid:'middle_'+siteItemNo+'_'+mditem+"_"+vitem,
															html:conMiddleDiv,
															align:'center',
															collapsible: true,
															//layout:{type:'vbox',pack:'center',align:'fit'},
															style:{'margin-top':'6px','border':'0px solid green','text-align':'center !important'},
															width:'100%',
															hidden:false,
														},
													]
												};

												thisObj.add(newPanel);

												if (vitem != sitePanelArray.length-1)
												{
													thisObj.add(separator);
												}*/
											}
										}
									}
									else
									{
										//var errorMsg='<center><img style="margin:3% 0 auto 0" src="/final/images/spacer.gif" class="iconAlert"/>&nbsp;&nbsp;<span class="rumErrorMsgText">Agent/Collector - Not Responding</span></center>';
										var errorMsg='<table align="center" style="margin:3% auto"><tr><td ><img style="margin-top:-2px" src="/final/images/spacer.gif" class="iconAlert"/></td><td>&nbsp;<span class="rumErrorMsgText">Agent/Collector - Not Responding</span></td><tr></table>';
										var err ={
													xtype:'container',
													id:'errorSiteDetail',
													columnWidth:1.0,
													html:errorMsg
												};
										var rumOverviewObj = this.getRumOverviewTab();

										var topPanels = rumOverviewObj.items.items;
										if (!Ext.isEmpty( topPanels[0]))
										{
											var resultItems=topPanels[0].items.items;
											for(var item=resultItems.length-1; item>-1 ; item--)
											{
												resultItems[item].destroy();
											}
										}

										topPanels[0].add(err);
									}
								}
							}
						}
					}
				}
			});
		}
	},
	loadOverviewTab:function(obj)
	{
		var me = this;
		var siteName = obj.up().up().siteName;
		url = '/final/servlet/com.eg.RUMController?site='+encodeURI(siteName)+'&accessType=particularAccessType';
		Ext.Ajax.request({
			url:url,
			timeout:300000,
			success:function(response)
			{
				var responseText = response.responseText;
				var jsonData = Ext.decode(responseText);
	
				var graphCount=0;
				var itemArray=new Array();
			
					for(obj in jsonData.AppTestresult.resultData[0].sitePanels)
					{
						var valueState= "<div><table style='font-size:100%'><tr><td><img src='/final/images/spacer.gif' class='state_GOOD'/></td></tr></table></div>";
						
						//var measureVal = jsonData.AppTestresult.resultData[i].sitePanels[j].value;

						//var ss = jsonData.AppTestresult.resultData[i].sitePanels[j];
						var val = jsonData.AppTestresult.resultData[0].sitePanels[obj];
						var tabDesktop=true;
						var tabMobile=true;
						var tabTablet=true;

						//var htmlValue = '<div>'+val+'<div><div>'+titleInside+'</div><div>'+obj+  '  is Normal</div>';
						
						var sitePanelId = 'overviewSiteId_'+obj;
						sitePanelId = sitePanelId.replace(/ +/g, "");

						
						var sitePanel = Ext.create('Ext.container.Container',{
								layout:'vbox',
								margin:'0 0 0 10',
								id:sitePanelId,
								name:'sitePanelContainer',
								height:300,
								width:200,
								//style:{'border':'1px solid red'},
								items:[
									{
										xtype:'displayfield',
										itemId:'panelTitle',
										value:obj
									},
									{
										xtype:'displayfield',
										itemId:'panelState',
										labelSeparator:'',
										labelAlign:'top',
										value:valueState,
									},
									{
										xtype:'displayfield',
										itemId:'panelStateText',
										labelSeparator:'',
										labelAlign:'top',
										value:obj+ ' is Normal',
									},
									{
										xtype:'displayfield',
										itemId:'panelValue',
										value:val,
										hidden:true,
									}
								]
						
						});

						
						//itemArray.push();
						
						if(obj.indexOf('Unique') > -1)
						{
							var deskVal=jsonData.deviceTestresult.resultData[0].siteAndValue["desktop_Page_Requests"];
							var mobVal=jsonData.deviceTestresult.resultData[0].siteAndValue["mobile_Page_Requests"];
							var tabVal=jsonData.deviceTestresult.resultData[0].siteAndValue["tablet_Page_Requests"];

							if(deskVal > 0)
								tabDesktop = false;
							else if(tabVal > 0)
								tabTablet = false;
							else if(mobVal > 0)
								tabMobile = false;
							titleInside='';

							sitePanel.add(
								{
									xtype:'container',
									layout:'vbox',
									hidden:true,
									itemId:'uniqueUsersContainer',
									items:[
											{
												xtype:'displayfield',
												itemId:'panelDesktopUsers',
												hidden:tabDesktop,
												value:'<div>'+deskVal+'Desktop users</div>',
											},{
												xtype:'displayfield',
												itemId:'panelTabletUsers',
												hidden:tabTablet,
												value:'<div>'+tabVal+'Tablet users</div>',
											},{
												xtype:'displayfield',
												itemId:'panelMobileUsers',
												hidden:tabMobile,
												value:'<div>'+mobVal+'Mobile users</div>',
										}]
								}	
							);
						}
							
						
						if(!Ext.isEmpty(jsonData.AppTestresult.resultData[0].graphData[graphCount].DataSet) && obj!="Unique users")
						{
							var graphId = 'graph_'+obj;
							graphId = graphId.replace(/ +/g, "");
							var errorMsg = '<center><div style="margin:10% 0 auto 0"><img class="iconInformation" src="/final/images/spacer.gif"/><div class="commonErrorMsgText">No Traffic Detected</div></div></center>';
							sitePanel.add({
								xtype:'container',
								id:graphId,
								itemId:'panelGraph',
								//style:{'border':'1px solid blue'},
								width:300,
								hidden:true,
								height:500,
								gValue:jsonData.AppTestresult.resultData[0].graphData[graphCount].DataSet[0].sparkdata,
								listeners:{
									'afterrender': function(thisObj){

										if(thisObj.gValue.length > 0)
										{
											jQuery("#"+thisObj.id).sparkline(thisObj.gValue, {
											type: 'line',
													width: '150',
													lineColor: '#E22121',
													fillColor: '#EEF828',
													spotColor: '#0000bf',
													minSpotColor: '#ff7f00',
													spotRadius: 2,
													height:'75',
											});
										}
										else
										{
											thisObj.update(errorMsg);
										}

									}
								}
							})

							graphCount++;
						}
						itemArray.push(sitePanel);
					}
					var inside = {
						xtype:'panel',
						style:{'border':'0px solid green'},
						frame:true,
						name:'overviewSitePanels',
						id:'overviewSitePanels',
						layout:'hbox',
						width:'auto',
						//title:'Health Summary',
						items:itemArray,
						bbar: [{
												//dock: 'bottom',
												xtype: 'toolbar',
												height:25,
												items: [
													
												{
													xtype: 'button',
													text: 'Show More',
													name:'showmore',
													hidden:false,
													//width:30,
													listeners:{
														'click':function(lbl){
															var site = lbl.up('panel[name=overviewSitePanels]');
															var sitePanelContainer = site.items.items;
															for(x=0;x<sitePanelContainer.length;x++)
															{
																var sitePanel = sitePanelContainer[x];
																var sitePanelItems = sitePanel.items.items;
																for(y=0;y<sitePanelItems.length;y++)
																{
																	sitePanelItems[y].show();
																}
															}
															
															var showless = lbl.up().down('button[name=showless]');
															showless.show();
															lbl.hide();
														}
													}
												},
												{
													xtype: 'button',
													text: 'Show Less',
													name:'showless',
													hidden:true,
													//width:100,
													listeners:{
														'click':function(lbl){
															
															var site = lbl.up('panel[name=overviewSitePanels]');
															var sitePanelContainer = site.items.items;
															for(x=0;x<sitePanelContainer.length;x++)
															{
																var sitePanel = sitePanelContainer[x];
																var sitePanelItems = sitePanel.items.items;
																for(y=0;y<sitePanelItems.length;y++)
																{
																	var sitePanelIt = sitePanelItems[y];
																	if(sitePanelIt.itemId=="panelTitle" || sitePanelIt.itemId=="panelState" || sitePanelIt.itemId=="panelStateText")
																	{
																		sitePanelItems[y].show();
																	}
																	else
																	{
																		sitePanelItems[y].hide();
																	}
																}

															}

															var showMore = lbl.up().down('button[name=showmore]');
															showMore.show();
															lbl.hide();
														}
													}
												}
													
												]
											}],
					};

					//obj.items = inside;
					me.getRumOverviewTab().add(inside);
			},
			failure:function(){
			}
			
		});
	},
	mouseOverMove:function(tabpanel,refresh,val,id){
		//this.createRumOverviewDashboard(tabpanel,refresh,val);
		if(id < 0 && scrollObj.down ==true){
			scrollObj.up = true;
			scrollObj.down = false;
			var allJsonData = glJson;
			var me = this;
			var middleChartPanel = me.getGenericViewPanel();
			var middlePanelArr=allJsonData.middle;
			if (!Ext.isEmpty( middlePanelArr) && middlePanelArr!=undefined)
			{
				var bb=1;
				for(var b=0;b<middlePanelArr.length;b++)
				{
					var jsonData = middlePanelArr[b];
					if( !Ext.isEmpty(jsonData.chartType) )
					{
						var dispTitle = jsonData.chartDispTitle;
						var timeTitle="<div><div class='rumDataInnerHeader' style='float:left;width:84%;line-height:16px'>"+dispTitle+"</div><div class='rumDataInnerHeaderBg' style='width:80px;text-align:center;line-height:15px;float:right'>Last 1 hour</div></div>";
						var highChartType = jsonData.chartType;
						var isAreaChart = ( highChartType.indexOf("Area") > -1 || highChartType.indexOf("area") > -1 )?"true":"false";
						var colWdt = ( highChartType == 'pie' )?0.33:0.5;
						var winWidth = Ext.getBody().getViewSize().width;
						winWidth = ( colWdt >= 0.5)?winWidth/2:winWidth/4;
						if( highChartType == 'line' || highChartType == 'area' || highChartType == 'column' || highChartType == 'stackedarea' )
						{
							var axisDispTitle = jsonData.chartDispAxisTitle;
							var iniChartCount = jsonData.iniChartCount;
							var marginValues = ( bb % 2 == 0 )?'15 5 0 0':'15 20 0 0';
							if(!Ext.isEmpty(jsonData.urls) )
							{
								var urlList = jsonData.urls;
								var errorPanel='<div class="rumErrorPanelBg" style="height:320px;display:block;padding-top:140px;"><table align="center"><tr><td><img style="margin-top:-1px" src="/final/images/spacer.gif" class="iconAlert"/></td><td>&nbsp;<span class="rumGraphErrorMsgText">No Traffic Detected</span></td><tr></table></div>';

								for(var a=0;a<jsonData.urls.length;a++)
								{
									var chartUrl = decodeURI(jsonData.urls[a]);
									var pcrefreshStr = (refresh)?"yes":"no";
									chartUrl = encodeURI(chartUrl+"&isAreaChart="+isAreaChart+'&rumRefresh='+pcrefreshStr+"&iniChartCount="+iniChartCount);
									middleChartPanel.add({
										cls:'rumDataInnerpanel',
										margin:marginValues,
										id:'lineChart'+inc,
										bodyPadding:'10 0 20 0',
										style:{'border':'0px solid red'},
										columnWidth:colWdt,
										curUrl:chartUrl,
										axisTitle:axisDispTitle,
										highCType:highChartType,
										dispLocTitle:dispTitle,
										timeLocTitle:timeTitle,
										listeners:{
											'afterrender': function(currObj){
												var chartPId = currObj.body.id;

												Ext.Ajax.request({
													url:currObj.curUrl,
													async: false,
													timeout:300000,
													success:function(response)
													{
														var jsonText = response.responseText;
														if (!Ext.isEmpty( jsonText) && jsonText.indexOf("<HTML") == -1 )
														{
															var chartJsonData = Ext.decode(jsonText);
															chartJsonData['rumChartType'] = currObj.highCType;
															chartJsonData['rumAxisTitle'] = currObj.axisTitle;
															chartJsonData['trimLegendUnit'] = true;
															currObj.setTitle(currObj.timeLocTitle);
															var graphHeight = Ext.getBody().getViewSize().height-450;
															me.createRumTimelineHighchart(chartPId,250,winWidth-80,chartJsonData,'',false);
														}
														else
														{
															currObj.setTitle(currObj.dispLocTitle);
															currObj.setHeight(331);
															currObj.update(errorPanel);
														}
													}
												});
											}
										}
									});
									inc = inc+1;
								}
							}
						}

						if( highChartType == 'combination' )
						{
							if(!Ext.isEmpty(jsonData.urls) )
							{
								var marginValues = ( bb % 2 == 0 )?'15 5 0 0':'15 20 0 0';
								var iniChartCount = jsonData.iniChartCount;
								var urlList = jsonData.urls;
								var errorPanel='<div class="rumErrorPanelBg" style="height:320px;display:block;padding-top:140px;"><table align="center"><tr><td><img style="margin-top:-1px" src="/final/images/spacer.gif" class="iconAlert"/></td><td>&nbsp;<span class="rumGraphErrorMsgText">No Traffic Detected</span></td><tr></table></div>';

								for(var a=0;a<jsonData.urls.length;a++)
								{
									var chartUrl = decodeURI(jsonData.urls[a]);
									var crefreshStr = (refresh)?"yes":"no";
									chartUrl = encodeURI(chartUrl+"&isAreaChart="+isAreaChart+"&rumtabName=overview&rumRefresh="+crefreshStr+"&iniChartCount="+iniChartCount);
									var ctype = (a > 0 )?"column":"spline";
									middleChartPanel.add({
										cls:'rumDataInnerpanel',
										margin:marginValues,
										id:'lineChart'+inc,
										style:{'border':'0px solid blue'},
										columnWidth:colWdt,
										bodyPadding:'10 0 20 0',
										curUrl:chartUrl,
										dispLocTitle:dispTitle,
										cLoctype:ctype,
										timeLocTitle:timeTitle,
										listeners:{
											'afterrender': function(currObj){
												var chartPId = currObj.body.id;
												Ext.Ajax.request({
													url:currObj.curUrl,
													async: false,
													timeout:300000,
													success:function(response)
													{
														var jsonText = response.responseText;
														if (!Ext.isEmpty( jsonText))
														{
															if( jsonText.indexOf("<HTML") == -1)
															{
																var chartJsonData = Ext.decode(jsonText);
																chartJsonData['rumChartType'] = currObj.cLoctype;
																chartJsonData['trimLegendUnit'] = true;
																//currObj.setTitle(currObj.dispLocTitle);
																currObj.setTitle(currObj.timeLocTitle);
																var graphHeight = Ext.getBody().getViewSize().height-450;
																me.createRumTimelineHighchart(chartPId,250,winWidth-80,chartJsonData,'',true);
															}
															else
															{
																currObj.setTitle(currObj.dispLocTitle);
																currObj.setHeight(331);
																currObj.update(errorPanel);
															}
														}
													}
												});
											}
										}
									});
									inc = inc+1;
								}
							}
						}
						else if(jsonData.chartType == 'pie')
						{
							var marginValues = ( bb % 2 == 0 )?'15 5 0 0':'15 20 0 0';
							if( !Ext.isEmpty(jsonData.pieChart) )
							{
								middleChartPanel.add({
									cls:'rumDataInnerpanel',
									columnWidth:0.5,
									id:'pieChart'+inc,
									margin:marginValues,
									style:{'border':'0px solid orange','text-align':'center !important'},
									bodyPadding:'10 0 0 0',
									autoScroll:false,
									scroll:false,
									pieData:jsonData.pieChart,
									dispLocTitle:dispTitle,
									listeners:{
										'afterrender': function(currObj){
											var pieId = currObj.body.id;
											currObj.setTitle(currObj.dispLocTitle);
											var graphHeight = Ext.getBody().getViewSize().height-450;
											winWidth = (Ext.getBody().getViewSize().width/2)-10;
											me.createRumPieHighchart(pieId,250,winWidth,currObj.pieData);
											currObj.setHeight(331);
											//me.createRumPieHighchart(pieId,220,200,jsonData.pieChart);
										}
									}
								});
								inc = inc+1;
							}
						}
					}
					bb=bb+1;
				}
			}
			//Ext.getCmp('genviewPanel').setFocus();
		}
		/*else if(id > 0 && scrollObj.up == true){
			scrollObj.up = false;
			scrollObj.down = true;
			var me = this;
			var middleChartPanel = me.getGenericViewPanel();
			middleChartPanel.removeAll();
		}*/
	}
});