
Ext.define('RealUserMonitor.view.Base',{
	extend:'Ext.panel.Panel',
	alias:'widget.base',
	layout:'hbox',
	frame:false,
	margin:'0 8 8 8',
	padding:'10 0 10 10',
	height:160,
	border:true,
	baseCls:'rumPanel',
	style:{'border':'0px solid red'},
	defaults:{
		xtype: 'displayfield',
		labelSeparator:'',
		labelAlign:'top',
		flex:1,
	},
	items:[{
		xtype:'container',
		flex:3,
		margin:'10 0 0 9',
		style:{'border':'0px solid red'},
		layout:'vbox',
		items:[{
				xtype: 'displayfield',
				margin:'5 0 0 0',
				fieldLabel: "<table style='font-size:90%'><tr><td class='rumSubheadText'>End User Reponse Time</td></tr></table>",
				labelWidth:140,
				padding:0,
				style:{'margin-bottom':'20px'},
				fieldCls:'rumHeaderText',
				id:screenLabel.avg_res_time,
				value:'0',
				labelSeparator:'',
				flex:1.5,
				
			},{
				xtype:'panel',
				height:40,
				flex:3,
				margin:'6 0 0 0',
				id:'guagePanel'
			},{
				xtype:'container',
				id:'chartLegend',
				margin:'15 0 0 0',
				flex:1,
				html:''
		}]
	},{
		xtype:'container',
		cls:'rumInnerBox',
		height:160,
		padding:'0 10 0 10',
		flex:.75,
		items:[{
				xtype:'container',
				cls:'rumSubheadText',
				html:'<center><div class="rumIconPageReq"></div>Page Requests</center>'
			},{
				xtype: 'displayfield',
				id:screenLabel.page_requests,
				labelAlign:'top',
				width:'auto',
				padding:0,
				margin:'15 auto 0 55%',
				fieldCls:'rumValues mouse',
				fieldStyle:'color:'+goodStateColor,
				value:'0',
				labelSeparator:'',
				listeners:{
					'render':function(obj)
					{
						obj.getEl().on('click',function()
						{
							obj.fireEvent('click',obj);
						});
					}
				}
			},{
				xtype: 'displayfield',
				fieldLabel: "Req. Per Min.",
				width:'100%',
				margin:'20 0 0 0',
				cls:'rumSublevelBorder',
				labelWidth:80,
				fielCls:'rumSubheadSublevel',
				fieldStyle:'color:'+goodStateColor,
				labelSeparator:'',
				id:'REQUEST_PER_MINUTE',
				value:'0',
			}
		]
	},{
		xtype:'container',
		flex:.75,
		height:160,
		cls:'rumInnerBox',
		padding:'0 10 0 10',
		items:[{
			xtype:'container',
			cls:'rumSubheadText',
			html:'<center><div class="rumIconSlowReq"></div>Slow Requests</center>'
		},{
			xtype:'displayfield',
			fieldCls:'rumValues',
			fieldStyle:'color:'+goodStateColor,
			width:'auto',
			padding:0,
			margin:'15 auto 0 55%',
			id:screenLabel.slow_requests,
			fieldCls:'rumValues mouse',
			labelSeparator:'',
			flex:0.5,
			value:'0',
			link:"-",
			listeners:{
				'render':function(obj)
				{
					obj.getEl().on('click',function()
					{
						obj.fireEvent('click',obj);
					});
				}
			}
		},{
			xtype: 'displayfield',
			margin:'20 0 0 0',
			width:'100%',
			cls:'rumSublevelBorder',
			labelCls:'rumSubheadSublevel',
			id:'slowRequestPercentageDetails',
			labelSeparator:'',
			value:'-'
		}]
	},{
		xtype:'container',
		flex:.75,
		height:160,
		cls:'rumInnerBox',
		padding:'0 10 0 10',
		items:[{
					xtype:'container',
					cls:'rumSubheadText',
					html:'<center><div class="rumIconSlowLoc"></div>Slow Locations</center>'
				},{
					xtype:'displayfield',
					width:'auto',
					margin:'15 auto 0 55%',
					fieldCls:'rumValues mouse',
					id:'Avg_Slow_Transactions',
					labelSeparator:'',
					value:'0',
					listeners:{
						'render':function(obj)
						{
							obj.getEl().on('click',function()
							{
								obj.fireEvent('click',obj);
							});
						}
					}
				}
			]
		},{
			xtype:'container',
			flex:.75,
			height:160,
			cls:'rumInnerBox',
			padding:'0 10 0 10',
			items:[{
					xtype:'container',
					cls:'rumSubheadText',
					html:'<center><div class="rumIconErrReq"></div>Error Requests</center>'
				},{
					xtype:'displayfield',
					flex:0.5,
					width:'auto',
					margin:'15 auto 0 55%',
					fieldCls:'rumValues',
					fieldStyle:'color:'+goodStateColor,
					id:'ERROR_REQUESTS',
					labelSeparator:'',
					labelAlign:'top',
					value:'0'
				},{
					xtype: 'displayfield',
					fieldLabel: "",
					width:'100%',
					margin:'10 0 0 0',
					cls:'rumSublevelBorder',
					labelCls:'rumSubheadSublevel',
					id:'errorRequestPercentageDetails',
					labelAlign:'top',
					labelSeparator:'',
					value:'-'
				}
			]
		},{
			xtype:'container',
			flex:.75,
			height:160,
			padding:'0 10 0 10',
			cls:'rumInnerBox',
			items:[{
						xtype:'container',
						cls:'rumSubheadText',
						html:'<center><div class="rumIUnqUsers"></div>Unique Users</center>'
					},{
						xtype: 'displayfield',
						id:screenLabel.user_session,
						value:'0',
						labelSeparator:'',
						width:'auto',
						margin:'15 auto 0 55%',
						fieldCls:'rumValues mouse',
						fieldStyle:'color:'+goodStateColor,
						labelAlign:'top',
						listeners:{
							'render':function(obj)
							{
								obj.getEl().on('click',function()
								{
									obj.fireEvent('click',obj);
								});
							}
						}
					},{
						xtype:'container',
						margin:'15 0 0 0',
						items:[{
							xtype: 'displayfield',
							margin:'0 0 0 0',
							cls:'rumSublevelBorder',
							labelCls:'rumSubheadSublevel',
							fieldLabel: "<div style='float:left' class='rumDesktop'></div>&nbsp;<div style='float:left'>Desktop</div>",
							id:'desktop_Page_Requests',
							fieldCls:'rumSubheadSublevel',
							fieldStyle:'color:'+goodStateColor,
							value:'0',
							frame:true,
							labelSeparator:'',
							labelAlign:'left'
						},{
							xtype: 'displayfield',
							margin:'0 0 0 0',
							cls:'rumSublevelBorder',
							labelCls:'rumSubheadSublevel',
							fieldLabel: "<div style='float:left' class='rumMobile'></div>&nbsp;<div style='float:left'>Mobile</div>",
							id:'mobile_Page_Requests',
							fieldCls:'rumSubheadSublevel',
							fieldStyle:'color:'+goodStateColor,
							value:'0',
							labelSeparator:'',
							labelAlign:'left'
						},{
							xtype: 'displayfield',
							margin:'0 0 0 0',
							cls:'rumSublevelBorder',
							labelCls:'rumSubheadSublevel',
							fieldLabel: "<div style='float:left' class='rumTablet'></div>&nbsp;<div style='float:left'>Tablet</div>",
							id:'tablet_Page_Requests',
							fieldCls:'rumSubheadSublevel',
							fieldStyle:'color:'+goodStateColor,
							value:'0',
							labelSeparator:'',
							labelAlign:'left'
						}]
					}
				]
			}
	],
	initComponent:function()
	{
		this.callParent();
	}
});