Ext.define('RealUserMonitor.view.DDAlerts',{
	extend:'Ext.panel.Panel',
	alias:'widget.ddalerts',
	id:'ddalerts',
	layout:{type:'vbox'},
	margin:0,
	padding:0,
	columns:1,
	width:'100%',
	autoScroll:'true',
	items:[{
			xtype:'fieldset',
			width:'100%',
			layout:'hbox',
			title:'Browser Trace',
			items:[{
				xtype:'displayfield',
				id:'dd_browser',
				labelSeparator:'',
				padding:'0 20 0 0',
				labelClsExtra:'rumPopupSubText',
				fieldCls:'rumPopupSubValue',
				fieldLabel:'Browser',
				labelAlign:'top',
				value:'0'
			},{
				xtype:'displayfield',
				id:'dd_REQUEST_TIME',
				padding:'0 20 0 0',
				labelSeparator:'',
				labelClsExtra:'rumPopupSubText',
				fieldCls:'rumPopupSubValue',
				fieldLabel:'Time',
				labelAlign:'top',
				value:'0'
			},{
				xtype:'displayfield',
				id:'dd_ip',
				padding:'0 20 0 0',
				labelSeparator:'',
				fieldLabel:'IP',
				labelClsExtra:'rumPopupSubText',
				fieldCls:'rumPopupSubValue',
				labelAlign:'top',
				value:'0'
			},{
				xtype:'displayfield',
				labelSeparator:'',
				padding:'0 20 0 0',
				id:'dd_city',
				labelAlign:'top',
				labelClsExtra:'rumPopupSubText',
				fieldCls:'rumPopupSubValue',
				fieldLabel:'City',
				value:'0'
			}
			]
		},{
			xtype:'fieldset',
			width:'100%',
			layout:'hbox',
			title:'Response Time',			
			items:[
					{
						xtype:'displayfield',
						id:'dd_res_time',
						labelSeparator:'',
						padding:'0 20 0 0',
						labelClsExtra:'rumPopupSubText',
						fieldCls:'rumPopupSubValue',
						fieldLabel:'End User Response Time',
						labelAlign:'top',
						value:'0'
					},{
						xtype:'displayfield',
						id:'dd_first_byte_time',
						labelSeparator:'',
						labelClsExtra:'rumPopupSubText',
						fieldCls:'rumPopupSubValue',
						padding:'0 20 0 0',
						fieldLabel:'First Byte Time',
						labelAlign:'top',
						value:'0'
					},{
						xtype:'displayfield',
						padding:'0 20 0 0',
						id:'dd_front_end_time',
						labelClsExtra:'rumPopupSubText',
						fieldCls:'rumPopupSubValue',
						labelSeparator:'',
						fieldLabel:'Front End Time',
						labelAlign:'top',
						value:'0'
					},{
						xtype:'displayfield',
						padding:'0 20 0 0',
						id:'dd_Document_Ready_Time',
						labelSeparator:'',
						labelClsExtra:'rumPopupSubText',
						fieldCls:'rumPopupSubValue',
						fieldLabel:'Document Ready Time',
						labelAlign:'top',
						value:'0'
					}	
			]},{
			xtype:'fieldset',
			id:'errror_msg_container',
			hidden: true,		
			width:'100%',
			layout:'vbox',
			title:'JS Errors',	
			myTooltip: Ext.create('Ext.tip.ToolTip', {
				renderTo: Ext.getBody()
			}),
			defaults: {
				listeners: {
					boxready: function (field) {
						field.el.on({
							mouseover: function (e) {
								var tip = field.up('fieldset').myTooltip;
								tip.update(field.value);
								tip.showAt(e.getXY());
							}
							, mouseout: function () { field.up('fieldset').myTooltip.hide(); }
						});
					}
				}
			},
			items:[
					{
						xtype:'displayfield',
						id:'error_url',
						labelSeparator:'',
						padding:'0 20 0 0',
						labelClsExtra:'rumPopupSubText',
						fieldCls:'rumPopupSubValue',
						fieldLabel:'URL',
						labelAlign:'top',
						value:''
					},{
						xtype:'displayfield',
						id:'error_lineNumber',
						labelSeparator:'',
						labelClsExtra:'rumPopupSubText',
						fieldCls:'rumPopupSubValue',
						padding:'0 20 0 0',
						fieldLabel:'Line Number',
						labelAlign:'top',
						value:''
					},{
						xtype:'displayfield',
						padding:'0 20 0 0',
						id:'error_errorMsg',
						labelClsExtra:'rumPopupSubText',
						fieldCls:'rumPopupSubValue',
						labelSeparator:'',
						fieldLabel:'Error Description',
						labelAlign:'top',
						value:''
					},
			]
		}
	],
	initComponent:function()
	{
		this.callParent();
	}
});