try
{
	var centerMap = new google.maps.LatLng(40.3780, 10.4359);
	//var centerMap = new google.maps.LatLng(40.3780, 60.4359);

	Ext.define('RealUserMonitor.view.LocationsMap',{
		extend:'Ext.ux.GMapPanel',
		alias:'widget.locationsmap',
		autoDestroy:true,
		//layout: 'fit',
		//anchor: '100%',
		//layout:{type:'vbox',align:'stretch',pack:'center'},
		mapData:null,
		border:false,
		style:{'border':'0px solid blue'},
		cls: 'datapanel1',
		align:'center',
		//bodyPadding:10,
		gmapType: 'map',
		xtype: 'gmappanel',
		//itemId:'mapIds',
		id:'mapIds',
		//width: '100%',
		//flex:1,
		//width:530,
		//height: 350,
		//margin: 0px,
		//padding: '5px',
		markers:null,
		//height:350,
		//margin:'0px auto !important',
		mapOptions: {
			center: centerMap,
			minZoom:1,
			zoom: 1,
			//maxZoom:3,
			draggable: true,
			scrollwheel: true,
			navigationControl: false,
			mapTypeControl:false,
			zoomControl: false,
			scaleControl:false,
			panControl: false,
			streetViewControl:false,
			disableDoubleClickZoom: true,
			drawingControl: false,
			mapTypeControlOptions: 
			{
			  mapTypeIds: [google.maps.MapTypeId.ROADMAP]
			},
			mapTypeId: MY_MAPTYPE_ID
		},
		setMapMarkers:function(markersArray){
			this.mapData = [];
			this.mapData = markersArray;
			this.fireEvent('mark',this);
		},
		clearMapMarkers:function(){
			return this.fireEvent('clearmark',this);
		},
		initialize:function(markersArray) {
		},
		
		setMarkers:function(map, locations) {
		var bounds = new google.maps.LatLngBounds();
		for (var i = 0; i < locations.length; i++) 
		{
				var beach = locations[i];
				var coords = new google.maps.LatLng(beach[1], beach[2]);
				var contentString = '<div id="content">'+
					'Info Window Test:' +  beach[0] + 
					'</div>';
				var infowindow = new google.maps.InfoWindow({content: contentString});
				var markerImage = new google.maps.MarkerImage
				(
					"http://www.alawar.com/games_img/games/sky-bubbles/sky-bubbles-deluxe-logosmall.gif"
				);
				var marker = new google.maps.Marker({
					position: coords,
					map: map,
					icon: markerImage,
					title: beach[0],
					zIndex: beach[3]
				});
				google.maps.event.addListener(marker, 'click', 
					function (infowindow, marker) {
						return function () {
							infowindow.open(map, marker);
						};
					}(infowindow, marker)
				);
				bounds.extend(coords);
		}
	},
		initComponent:function(){
			//google.maps.visualRefresh = true;
			this.callParent();
			this.initialize();
		}
	});
}
catch (e)
{
	Ext.define('RealUserMonitor.view.LocationsMap',{
		extend:'Ext.panel.Panel',
		autoDestroy:true,
		layout:{type:'vbox',align:'stretch',pack:'center'},
		mapData:null,
		border:false,
		style:{'border':'0px solid blue'},
		cls: 'datapanel1',
		align:'center',
		id:'errMapIds',
		flex:1,
		width:530,
		height: 350,
		markers:null
	});

}