
Ext.define('RealUserMonitor.view.Main',{
	extend:'Ext.panel.Panel',
	requires:['RealUserMonitor.view.Base','RealUserMonitor.view.MapAndChart','RealUserMonitor.view.GroupedRequest','RealUserMonitor.view.SiteList','RealUserMonitor.view.ShowDD','RealUserMonitor.view.Alarms','RealUserMonitor.view.DDAlerts','utilities.ScrollTabPanel','RealUserMonitor.view.PagesAndAjax'],
	alias:'widget.main',
	layout:'anchor',
	autoDestroy:true,
	frame:false,
	cls:'outerpanel',
	flex:1,
	id:'mainId',
	//autoScroll:true,
	autoScroll:true,
	//scroll:true,
	scroll:false,
	margin:'7 7 4 7',
	title:'Real User Monitor',
	tools:[
		{
			xtype : 'button',
			cls:'iconAutomaticScrollRun',
			id:'iconAutomaticScrollRun',
			//text:'Click to Automatic Scroll 111',
			margin: '0px 4px 0px 4px',
			ui: 'action',
			hidden:true,
			border:true,
			style: {
				border: '0px'
			},
			handler:function(){
				scrollFlag=true;
				pageScroll();
				Ext.getCmp('iconAutomaticScrollRun').hide();
				//Ext.getCmp('iconAutomaticScrollStop').show();
			},
			listeners: {
				afterrender: function () {
					Ext.create('Ext.tip.ToolTip', {
						target: this.id,
						anchor: 'top',
						cls: 'yellowTip',
						trackMouse: true,
						autoDestroy:true,
						html: 'Auto Scroll'
					});
				}
			}
		},
		{
			xtype : 'button',
			cls:'iconAutomaticScrollStop',
			id:'iconAutomaticScrollStop',
			margin: '0px 4px 0px 4px',
			ui: 'action',
			hidden:true,
			style: {
				border: '0px'
			},
			handler:function(){
				scrollFlag=false;
				stopScroll();
				Ext.getCmp('iconAutomaticScrollStop').hide();
				//Ext.getCmp('iconAutomaticScrollRun').show();
			},
			listeners: {
				afterrender: function () {
					Ext.create('Ext.tip.ToolTip', {
						target: this.id,
						anchor: 'top',
						cls: 'yellowTip',
						trackMouse: true,
						autoDestroy:true,
						html: 'Pause'
					});
				},
				'viewready': function()
		{
			
			Ext.defer(function(){
			//TV MODE AUTO SCROLL FUNCTION
			if(!Ext.isEmpty(window.parent.isTvMode)){
				$.fn.hasScrollBar = function() {
						return this.get(0).scrollHeight - 10 > this.height();
				}
				if(window.parent.isTvMode){
					//console.log("getTimeFrequency"+window.parent.Ext.getCmp('tvmode').getTimeFrequency)
						var silderAction = window.parent.Ext.getCmp('tvmode').sliderAction;
						window.parent.Ext.getCmp('playBtn').ifScroll = false;
						var ifPageHasScroll = $('#mainId-body').hasScrollBar();
						var getTvModePlayAction = function () {
								silderAction = window.parent.Ext.getCmp('tvmode').sliderAction;
								if(Ext.get('mainId-body').getActiveAnimation()){
										if(silderAction == "pause"){
												alert('pause')
													Ext.get('mainId-body').getActiveAnimation().paused = false;
												}else{
													alert('play')
													Ext.get('mainId-body').getActiveAnimation().paused = true;
												}
										}
							}
						var runner = new Ext.util.TaskRunner();
						 var task = runner.start({
											 run: getTvModePlayAction,
											 interval: 1000
										 });
						
						var totalScrollLength = Ext.get('mainId-body').dom.scrollHeight  - Ext.get('mainId-body').dom.offsetHeight;
						var scrollHeightx = totalScrollLength * 100;
						var scrollHeightDurationx = totalScrollLength * 70;
						
						//console.log('rum',window.parent.Ext.getCmp('tvmode').getTimeFrequency)
						if(ifPageHasScroll){
							Ext.get('mainId-body').getActiveAnimation().paused = true;
							window.parent.Ext.getCmp('tvmode').sliderObj.pause();
							window.parent.Ext.getCmp('playBtn').ifScroll = true;
						}
						else{
							window.parent.Ext.getCmp('playBtn').ifScroll = false;
							Ext.defer(function(){
									window.parent.Ext.getCmp('tvmode').sliderObj.play();

							},window.parent.Ext.getCmp('tvmode').getTimeFrequency)
							
						}
						
						//window.parent.Ext.getCmp('playBtn').ifScroll = false;
						Ext.get('mainId-body').scroll("b",
						scrollHeightx, 
						{
						duration:scrollHeightDurationx,
						listeners: {
								beforeanimate:function( el, eOpts ){		},
								afteranimate:function(el, startTime, eOpts ){
									Ext.get('mainId-body').stopAnimation( );
									window.parent.Ext.getCmp('playBtn').ifScroll = false;				
									Ext.defer(function(){
										window.parent.Ext.getCmp('tvmode').sliderObj.play();
										runner.destroy();
									},1000);
								}
							}
						},
						{
							scope: Ext.get('mainId-body')
						});
							
					
				}	
			}
			//end TV MODE AUTO SCROLL FUNCTION	
			else{
				$('#mainId-body').scrollTop(val)
			}
			},500);
		}
			}
		},
		{
			xtype:'tbseparator',
			cls:'removeLineForTvMode',
			hidden:false,
		},
		{
			xtype : 'button',
			cls:'iconAutomaticScrollJumpToTop',
			id:'iconAutomaticScrollJumpToTop',
			margin: '0px 4px 0px 4px',
			ui: 'action',
			hidden:true,
			style: {
				border: '0px'
			},
			handler:function(){
				scrollFlag=false;
				jumpScroll();
				Ext.getCmp('iconAutomaticScrollStop').hide();
				//Ext.getCmp('iconAutomaticScrollRun').show();
			},
			listeners: {
				afterrender: function () {
					Ext.create('Ext.tip.ToolTip', {
						target: this.id,
						anchor: 'top',
						cls: 'yellowTip',
						trackMouse: true,
						autoDestroy:true,		//
						html: 'Jump to top'
					});
				}
			}
		},
		{
			xtype:'tbseparator',
			cls:'removeLineForTvMode',
			hidden:false,
		},
		{
			xtype:'button',
			id:'backButton',
			cls:'backbutton',
			iconCls:'iconBack',
			text:back,
			dock:'top',
			hidden:true,
			margin:'2 0 2 0'
		}],
	initComponent:function(){
		this.callParent();
	},
	listeners:{
		'afterrender':function(){
			try
			{
				if( fromSerFlag == 'true' || fromSerFlag == true)
				{
					this.getHeader().hide();
				}
			}
			catch (e)
			{
			}
		}
	}
});




