Ext.define('RealUserMonitor.view.RumTabPanel', {
	extend: 'Ext.tab.Panel',
	alias:'widget.rumtabpanel',
	cls:'tablayout',
	
	margin:'0 0 0 0',
	siteName:'',
	layout:'vbox',
	border:false,
	scroll:true,
	autoScroll:true,
	tabsInfo:null,
	style:{'border':'0px solid blue'},
	setScrollBarposition:function(val){
		Ext.defer(function(){
			//TV MODE AUTO SCROLL FUNCTION
		if(!Ext.isEmpty(window.parent.isTvMode)){
			$.fn.hasScrollBar = function() {
					return this.get(0).scrollHeight - 50 > this.height();
			}
			if(window.parent.isTvMode){
					var silderAction = window.parent.Ext.getCmp('tvmode').sliderAction;
					window.parent.Ext.getCmp('playBtn').ifScroll = false;
					var ifPageHasScroll = $('#rumtabpanelId-body').hasScrollBar();
					var getTvModePlayAction = function () {
					silderAction = window.parent.Ext.getCmp('tvmode').sliderAction;
					if(Ext.get('rumtabpanelId-body').getActiveAnimation()){
						if(silderAction == "pause"){
									Ext.get('rumtabpanelId-body').getActiveAnimation().paused = false;
								}else{
									Ext.get('rumtabpanelId-body').getActiveAnimation().paused = true;
								}
						}
						}
					var runner = new Ext.util.TaskRunner();
					 var task = runner.start({
										 run: getTvModePlayAction,
										 interval: 1000
									 });
					
					var totalScrollLength = Ext.get('rumtabpanelId-body').dom.scrollHeight  - Ext.get('rumtabpanelId-body').dom.offsetHeight;
					var scrollHeightx = totalScrollLength * 100;
					var scrollHeightDurationx = totalScrollLength * 70;
					if(ifPageHasScroll){
						Ext.get('rumtabpanelId-body').getActiveAnimation().paused = true;
						window.parent.Ext.getCmp('tvmode').sliderObj.pause();
						window.parent.Ext.getCmp('playBtn').ifScroll = true;
					}else{
						window.parent.Ext.getCmp('playBtn').ifScroll = false;
						Ext.defer(function(){
								window.parent.Ext.getCmp('tvmode').sliderObj.play();

						},50000)
					}
					//window.parent.Ext.getCmp('playBtn').ifScroll = false;
					Ext.get('rumtabpanelId-body').scroll("b",
					scrollHeightx, 
					{
					duration:scrollHeightDurationx,
					listeners: {
							beforeanimate:function( el, eOpts ){		},
							afteranimate:function(el, startTime, eOpts ){
								Ext.get('rumtabpanelId-body').stopAnimation( );
								window.parent.Ext.getCmp('playBtn').ifScroll = false;				
								Ext.defer(function(){
									window.parent.Ext.getCmp('tvmode').sliderObj.play();
									runner.destroy();
								},1000);
							}
						}
					},
					{
						scope: Ext.get('rumtabpanelId-body')
					});
						
				
			}	
			}
			//end TV MODE AUTO SCROLL FUNCTION	
			else{
				$('#rumtabpanelId-body').scrollTop(val)
			}
			},500);
		
	},
	height:Ext.getBody().getViewSize().height-60,
	id:'rumtabpanelId',
	items:[
		{
			title:'Overview',
			xtype:'rumoverviewtab',
			id:'rumOverviewId',
			hidden:true
		},
		{
			title:'Geo Dashboard',
			xtype:'rumgeoview',
			id:'rumGeoId',
			hidden:true
		},
		{
			title:'Pages and Ajax Requests',
			xtype:'pagesandajax',
			id:'rumPagesAjaxId',
			hidden:true
		},
		{
			title:'Browsers and Devices',
			xtype:'browserdevice',
			id:'rumBD',
			hidden:true
		}
	],
	initComponent : function(){
		this.addListener('afterrender',this.setScrollBarposition,this);
		this.addListener('scroll',this.scrollEvent,this);
		this.callParent();
	}
});
