Ext.define('RealUserMonitor.view.ShowDD',{
	extend:'Ext.container.Container',
	alias:'widget.showdd',
	id:'showdd',
	align:'center',
	cls:'innerBodyBg',
	frame:false,
	margin:'0 8 8 8',
	height:'97%',
	style:{'border':'0px solid yellow'},
	autoScroll:false,
	items:[{
				xtype: "combo",
				cls: "dropdown",
				width: 230,
				margin:'5 0 8 8',
				editable: true,
				fieldLabel: 'Filter By',
				labelWidth:60,
				labelSeparator:'',
				id: "filterbyDD",
				name: "filterby",
				store: new Ext.data.Store({
					fields: ["displayField", "valueField"],
					data: [{"displayField":"Slow","valueField":"Slow_Requests"},{"displayField":"Error","valueField":"Error_Requests"},{"displayField":"Slow&Error","valueField":"SlowAndError"}],
				}),
				displayField: "displayField",
				valueField: "valueField",
				value:"",
				queryMode: "local"
        },{			
				xtype:'container',
				padding:'0 8 8 8',
				id:'gridPanel',
				style:{'background':'none !important'},
				autoScroll:false,
				items:[{
					xtype:'grid',
					cls:'gridSkin',
					style:{'border':'none'},
					id:'ddGrid',
					layout:'fit',
					store:Ext.create('Ext.data.Store', {
						fields:['REQUEST_TIME','REQUEST_TIME_link','URL','URL_link','PAGETYPE','PAGETYPE_link',{name:'Page_Load_Time',sortType:'asFloat'},'Page_Load_Time_link',{name:'First_byte_Time',sortType:'asFloat'},'First_byte_Time_link',{name:'Front_End_Time',sortType:'asFloat'},'Front_End_Time_link',{name:'Document_Ready_Time',sortType:'asFloat'},'Document_Ready_Time_link','CITY','CITY_link','DEVICE','DEVICE_link','BROWSER','BROWSER_link'],
						autoLoad:true,
						proxy: {
							type: 'pagingmemory'
						},
							pageSize: DDLimit,
						sorters: [{
							property : 'Id',
							direction:'ASC'
						}]
					}),
					height:565,
					columns:[{
							text:'Time',
							dataIndex:'REQUEST_TIME',
							flex:1.0,
							renderer:function(value, metaData, record, rowIndex, colIndex, store){
								return record.get("REQUEST_TIME_link");
							}
						},{
							text:'URL',
							dataIndex:'URL',
							flex:3.0,
							renderer:function(value, metaData, record, rowIndex, colIndex, store){
								return record.get("URL_link");
							}
						},{
							text:'Type',
							dataIndex:'PAGETYPE',
							flex:.4,
							renderer:function(value, metaData, record, rowIndex, colIndex, store){
								return record.get("PAGETYPE_link");
							}
						},{
							text:'End User Response Time',
							dataIndex:'Page_Load_Time',
							flex:.8,
							renderer:function(value, metaData, record, rowIndex, colIndex, store){
								return record.get("Page_Load_Time_link");
							}
						},{
							text:'First Byte Time',
							dataIndex:'First_byte_Time',
							flex:.6,
							renderer:function(value, metaData, record, rowIndex, colIndex, store){
								return record.get("First_byte_Time_link");
							}
						},{
							text:'Front End Time',
							dataIndex:'Front_End_Time',
							flex:.6,
							renderer:function(value, metaData, record, rowIndex, colIndex, store){
								return record.get("Front_End_Time_link");
							}
						},{
							text:'Document Ready Time',
							dataIndex:'Document_Ready_Time',
							flex:.8,
							renderer:function(value, metaData, record, rowIndex, colIndex, store){
								return record.get("Document_Ready_Time_link");
							}
						},{
							text:'Location',
							dataIndex:'CITY',
							flex:.7,
							renderer:function(value, metaData, record, rowIndex, colIndex, store){
								return record.get("CITY_link");
							}
						},{
							text:'Device',
							dataIndex:'DEVICE',
							flex:.5,
							renderer:function(value, metaData, record, rowIndex, colIndex, store){
								return record.get("DEVICE_link");
							}
						},{
							text:'Browser',
							dataIndex:'BROWSER',
							flex:1,
							renderer:function(value, metaData, record, rowIndex, colIndex, store){
								return record.get("BROWSER_link");
							}
						}]
				}]
			}],
	initComponent:function()
	{
		this.callParent();
	}
});
