var gridStore = Ext.create('Ext.data.Store',{
	fields:['Info',{name:'AVG_RESPONSE_TIME',sortType:'asFloat'},{name:'SLOW_REQUESTS',sortType:'asFloat'},{name:'ERROR_REQUESTS',sortType:'asFloat'}],
	data:[],
	pageSize:3
});
	//Info,Avg_Response_Time,Slow_Requests,Percentage_Error
Ext.define('RealUserMonitor.view.SlowLocations',{
	extend:'Ext.panel.Panel',
	alias:'widget.slowlocations',
	requires:['RealUserMonitor.view.Alarms'],
	id:'slowlocations',
	height:'auto',
	align:'center',
	width:'100%',
	margin:8,
	frame:false,
	border:false,
	cls:'datapanel1',
	layout:{type:'vbox',align:'stretch'},
	autoScroll:'true',
	items:[{
					xtype:'grid',
					cls:'gridSkin',
					id:'groupRequestGrid',
					style:{'border':'none','background':'none','overflow-x':'hidden'},
					store:gridStore,
					flex:1,
					columns:[
					{
						text:'Location',
						dataIndex:'Info',
						flex:1.5,
					},{
						text:'Response Time',
						dataIndex:'AVG_RESPONSE_TIME',
						flex:1,
						renderer:function(value,metaData,record,rowIndex){
							var state="GOOD";
							if(value!=null)
							{
								var value1 = value.split(' ');
								value = value1[0];
								state = value1[1];
							}
							var returnValue="<table style='font-size:90%'><tr><td><img src='/final/images/spacer.gif' class='"+state+"'/></td><td style='padding-left:5px;'>"+value+"</td></tr></table>";
							return returnValue;
						}
					},{
						text:'Slow Request',
						dataIndex:'SLOW_REQUESTS',
						flex:1,
						renderer:function(value,metaData,record,rowIndex){
							var state="GOOD";
							if(value!=null)
							{
								var value1 = value.split(' ');
								value = value1[0];
								state = value1[1];
							}
							var returnValue="<table style='font-size:90%'><tr><td><img src='/final/images/spacer.gif' class='"+state+"'/></td><td style='padding-left:5px;'>"+value+"</td></tr></table>";
							return returnValue;
						}
					},{
						//dataIndex:'Percentage_Slow',
						text:'Error Request',
						dataIndex:'ERROR_REQUESTS',
						flex:1,
						renderer:function(value,metaData,record,rowIndex){
							var state="GOOD";
							if(value!=null)
							{
								var value1 = value.split(' ');
								value = value1[0];
								state = value1[1];
							}
							var returnValue="<table style='font-size:90%'><tr><td><img src='/final/images/spacer.gif' class='"+state+"'/></td><td style='padding-left:5px;'>"+value+"</td></tr></table>";
							return returnValue;
						}
					}],
				}],
	initComponent:function()
	{
		this.callParent();
	}
});
