Ext.define("RemoteControl.controller.Main", {
    extend: "Ext.app.Controller",
    views: ["Main"],
    refs: [{
        selector: "main",
        ref: "main"
    }, {
        selector: "settings",
        ref: "settings"
    }, {
        selector: "utilitiestool",
        ref: "utilitiestool"
    }, {
        selector: "resultpanel",
        ref: "resultpanel"
    }, {
        selector: "emptypanel",
        ref: "emptypanel"
    }, {
        selector: "emptypanel #emptyPanelContainer",
        ref: "emptyPanelContainer"
    }, {
        selector: "remotecontrolForm",
        ref: "remotecontrolForm"
    }, {
        selector: "remotecontrolForm #agentmode",
        ref: "agentModeCombo"
    }, {
        selector: "remotecontrolForm #filterOpt",
        ref: "filterOptTextBox"
    }, {
        selector: "resultpanel #agentDatas",
        ref: "agentDatasTable"
    }, ],
    init: function () {
        this.control({
            "main": {
                "boxready": this.afterMainRender
            },
            'remotecontrolForm combo[name="agentmode"]': {
                "select": this.getAgentDataForSelection
            },
            "remotecontrolForm #filterOpt": {
                "keyup": this.searchAgents
            }
        });
    },
    refresh: function (){
		try
		{
			Ext.Ajax.request({
				url: refreshUrl,
				method: "POST",
				scope: this,
				success: function (c) {
					var e = c.responseText;
					var d = Ext.decode(e);
					if (!Ext.isEmpty(d)) {
						document.location = d.url;
					}
				}
			});
		}
		catch (e)
		{
			console.log(e)
		}
	},
    getAgentDataForSelection: function (b) {
        var a = b.getValue();
		Ext.getCmp("filterOpt").setValue("");
        Ext.Ajax.request({
            url: "/final/monitor/ControlAgentsJson.jsp",
            method: "POST",
            params: "agentMode=" + encodeURIComponent(a),
            scope: this,
            success: function (c) {
                var e = c.responseText;
                var d = Ext.decode(e);
                this.loadAgentsData(d);
            }
        });
    },
    loadAgentsData: function (d) {
        var g = d["errorMsg"];
        if (g != null && g == "-") {
            var h = this.getResultpanel();
            h.removeAll();
            this.getEmptypanel().hide();
            h.show();
            var a = d["agentInfoJson"];
            if (!Ext.isEmpty(a)) {
                var b = Ext.create("Ext.data.Store", {
                    fields: ["displayAgentName", "toolTip", "remoteCtrlUrl"],
                    data: a
                });
                var c = Ext.create("Ext.panel.Panel", {
					        flex:1,
					        layout: {
					        	type: "vbox",
						        align: "stretch"
					        },
					
                  items: Ext.create("Ext.view.View", {
                  id: "agentDatas",
		    			    margin:'0',
						      scroll:true,
						      autoScroll:true,
						      padding:5,
                  deferInitialRefresh: false,
                  store: b,
						      flex:1,
                  tpl: Ext.create("Ext.XTemplate", "<ul class='remote-list'>", '<tpl for=".">', '<li id={displayAgentName} class="agent-wrap">', '<div class="remoteagent"><a href="{remoteCtrlUrl}" alt="{toolTip}"><div class="iconAgent" style="margin: 40px auto 0% auto;"></div><div style="text-align: center;margin-top:10px">',"{displayAgentName}</div></a></div>", "</li>", "</tpl>", "</ul>", '<div class="x-clear"></div>'),
                  emptyText: '<table width="100%"><tr><td align="center" valign="middle"><div class="iconInformation" style="margin:12% auto 0% auto"></div>'+ searchErrAlert +' </td></tr></table>',
                  itemSelector: "li.agent-wrap",
						listeners:{
							viewready:function(view){
								
								if($('li.agent-wrap').length > 0){
									$('li.agent-wrap').each(function(i, div) {
									
										if((view.getWidth() - 150) <= ($(div).position().left + $(div).width())){
												$(div).addClass('last-col')
										}else{
												
												$(div).addClass('mid-col')
										}
									});
								}
							}
						}
                    })
                });
                h.add(c);
               
                h.show();
				h.doComponentLayout();
				Ext.getCmp("filterOpt").setDisabled(false);//enable the search option when the data is displayed.
				
				
            }
        } else {
            this.getResultpanel().hide();
            var f = this.getEmptypanel();
            var e = this.getEmptyPanelContainer();
            e.update('<table width="100%" height="100%"><tr><td style="text-align:center" ><div class = "iconInformation" style="margin:0 auto"></div><div>' + g + "</div></td</tr></table>");
            f.show();
			Ext.getCmp("filterOpt").setDisabled(true);//disable the search option when the data is not displayed.
        }
    },
    searchAgents: function (d, b) {
        var c = this.getAgentDatasTable();
		
		if(c != null && typeof c !== 'undefined' ) {
			if (Ext.String.trim(d.value).length > 0 && (Ext.String.trim(d.value) != "" || Ext.String.trim(d.value) != null)) {
				var a = RegExp(d.value, "i");
				c.getStore().filter(new Ext.util.Filter({
					caseSensitive: true,
					filterFn: function (f) {
						var e = false;
						Ext.Object.each(f.data, function (h, g) {
							e = e || a.test(String(g));
						});
						return e;
					}
				}));
			} else {
				c.getStore().clearFilter();
			}
			d.focus();
		}
    },
    transformeToAgent: function () {
        Ext.getCmp("agentDatas").on("itemclick", function (d, a, f, b, g, c) {
            var h = d.getStore().getAt(b).get("agentName");
            Ext.MessageBox.progress({
                title: remoteCntelLbl,
                value: 5,
                width: 350,
                increment: 15,
                closable: false,
                buttonText: {
                    cancel: "BACK"
                },
                progressText: "Connecting..",
                styleHtmlContent: true,
                wait: true,
                waitConfig: {
                    interval: 200
                },
                style: {
                    "text-align": "center"
                },
                msg: "<div class='panelwithoutheader'>Changing to Control Mode will take some time.<br> Please wait for a few minutes...</br>Mode of Operation: <b>WAITING MODE</b></br>This agent will soon change to Control Mode</div>",
                text: "Updating...",
                scope: this,
                fn: function () {
                    this.updateText("Done!");
                },
                buttons: Ext.MessageBox.CANCEL,
            });
        }, this);
    },
    afterMainRender: function () {
        var b = publicJson["screenLabels"];
        var c = this.getAgentModeCombo();
        c.getStore().loadRawData(publicJson["comboArr"]);
        c.setValue(publicJson["pageParams"]["selectedAgentMode"]);
        c.setFieldLabel(b["monitor.remotecontrol.Agent mode"]);
        var a = this.getFilterOptTextBox();
        a.setFieldLabel(b["monitor.remotecontrol.Agent IP"]);
        this.loadAgentsData(publicJson);
    }
});