Ext.define('RemoteControlAction.view.RemoteControlActionForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.remotecontrolactionForm',
    collapseMode: 'mini',
    id: 'remotecontrolform',
	cls:'formOuter',
    initComponent: function () {
        this.buttonAlign = "center";
        this.callParent();
    },
    collapseMode: "mini",
    layout: "column",
    defaults: {
        labelAlign: "top",
        labelSeparator: "",
    },
    items: [{
        xtype: 'scrollcombo',
        cls: 'dropdown',
		fieldLabel: actions_label,
        editable: false,
        store: new Ext.data.Store({
            fields: ['displayField', 'valueField','groupField'],
            data: []
        }),
		margin: 10,
        displayField: 'displayField',
        valueField: 'valueField',
		groupField:'groupField',
	    queryMode: 'local',
        id: 'rmt_cmds',
        name: 'rmt_cmds',
        width: 320,
		listConfig: {
			tpl: Ext.create('Ext.XTemplate',
				'<ul><tpl for=".">',
						'<tpl if="xindex == 1 || this.getGroupLabel(parent[xindex - 2]) != this.getGroupLabel(values)">',
							'<li class="x-combo-list-group"><b>{[this.getGroupLabel(values)]}</b></li>',
						'</tpl>',
						'<li role="option" class="x-boundlist-item" style="<tpl if="xindex != 1">padding-left: 12px</tpl>">{displayField}</li>',
					'</tpl>' +
				'</ul>',
				{
					getGroupLabel: function (values) {
						return (values.groupField);
					}
				}
			),
			emptyText: '<center>--- No item(s) found ---</center>'
		}
    },{
        xtype: 'scrollcombo',
        cls: 'dropdown',
        fieldLabel: users_label,
        editable: true,
        store: new Ext.data.Store({
            fields: ['displayField', 'valueField'],
            data: []
        }),
		margin: 10,
        displayField: 'displayField',
        valueField: 'valueField',
        queryMode: 'local',
        id: 'usernames',
        name: 'usernames',
        width: 210

    },{
        xtype: 'scrollcombo',
        cls: 'dropdown',
        fieldLabel: modes_label,
        editable: false,
        store: new Ext.data.Store({
            fields: ['displayField', 'valueField'],
            data: []
        }),
		margin: 10,
        displayField: 'displayField',
        valueField: 'valueField',
        queryMode: 'local',
        id: 'logonModes',
        name: 'logonModes',
        width: 210,
		hidden: true

    },{
        xtype: 'scrollcombo',
        cls: 'dropdown',
        fieldLabel: session_ids_label,
        editable: false,
        store: new Ext.data.Store({
            fields: ['displayField', 'valueField'],
            data: []
        }),
		margin: 10,
        displayField: 'displayField',
        valueField: 'valueField',
        queryMode: 'local',
        id: 'user_session_id',
        name: 'user_session_id',
        width: 110,
		hidden: true

    },{
        xtype: 'scrollcombo',
        cls: 'dropdown',
        fieldLabel: processes_label,
        editable: true,
        store: new Ext.data.Store({
            fields: ['displayField', 'valueField'],
            data: []
        }),
		margin: 10,
        displayField: 'displayField',
        valueField: 'valueField',
        queryMode: 'local',
        id: 'user_process_name',
        name: 'user_process_name',
        width: 210,
		hidden: true

    },{
        xtype: 'textfield',
        fieldLabel: message_label,
        cls: 'textbox',
        width: 300,
        id: 'msg_box',
        name: 'msg_box',
        margin: 10,
		hidden: true
    },{
        xtype: 'scrollcombo',
        cls: 'dropdown',
        fieldLabel: machine_name_label,
        editable: false,
        store: new Ext.data.Store({
            fields: ['displayField', 'valueField'],
            data: []
        }),
		margin: 10,
        displayField: 'displayField',
        valueField: 'valueField',
        queryMode: 'local',
        id: 'machine_name',
        name: 'machine_name',
        width: 210,
		hidden: true
    },{
        xtype: 'scrollcombo',
        cls: 'dropdown',
        fieldLabel: delivery_group_label,
        editable: false,
        store: new Ext.data.Store({
            fields: ['displayField', 'valueField'],
            data: []
        }),
		margin: 10,
        displayField: 'displayField',
        valueField: 'valueField',
        queryMode: 'local',
        id: 'delivery_grp_name',
        name: 'delivery_grp_name',
        width: 210,
		hidden: true
    },{
		xtype: 'radiogroup',
		fieldLabel: status_label,
		columns: 2,
		cls:'radiobt',
		margin: 10,
		id: 'delivery_group_status',
		hidden: true,
        width: 180,
		items: [
			{
				xtype: 'radiofield',
				boxLabel: 'Enable',
				name: 'delivery_group_enable_disable',
				id:'dged1',
				inputValue: 'Enable'
			},
			{
				xtype: 'radiofield',
				boxLabel: 'Disable',
				name: 'delivery_group_enable_disable',
				id:'dged2',
				inputValue: 'Disable',
				checked: true
			}
		]
		},{
		xtype: 'radiogroup',
		fieldLabel: show_label,
		columns: 2,
		cls:'radiobt',
		id: 'ctx_user_machine_name',
		hidden: true,
        width: 225,
		margin: 10,
		style:{'cursor':'pointer !important'},
		listeners:{
			click:{
				element:"el",
				fn:function(a)
				{
					me.getRemotecontrolactionForm().changeLicenseUsenameAndMachinename(Ext.getCmp(this.id).getValue().ctx_usermachine_name);
				}
		}},
		items: [
			{
				xtype: 'radiofield',
				boxLabel: user_name_label,
				name: 'ctx_usermachine_name',
				id:'ctxumn1',
			
				inputValue: 'username'
			},
			{
				xtype: 'radiofield',
				boxLabel: machine_name_label,
				name: 'ctx_usermachine_name',
				id:'ctxumn2',
				style:{'cursor':'pointer'},
				inputValue: 'machinename'
			}
		]
		},{
			xtype: 'scrollcombo',
			cls: 'dropdown',
			fieldLabel: user_name_label,
			editable: false,
			store: new Ext.data.Store({
				fields: ['displayField', 'valueField'],
				data: []
			}),
			margin: 10,
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local',
			id: 'license_username',
			name: 'license_username',
			width: 210,
			hidden: true
		},{
			xtype: 'scrollcombo',
			cls: 'dropdown',
			fieldLabel: machine_name_label,
			editable: false,
			store: new Ext.data.Store({
				fields: ['displayField', 'valueField'],
				data: []
			}),
			margin: 10,
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local',
			id: 'license_machinename',
			name: 'license_machinename',
			width: 210,
			hidden: true
		},{
        xtype: 'scrollcombo',
        cls: 'dropdown',
        fieldLabel: ad_username_label,
        editable: false,
        store: new Ext.data.Store({
            fields: ['displayField', 'valueField'],
            data: []
        }),
		margin: 10,
        displayField: 'displayField',
        valueField: 'valueField',
        queryMode: 'local',
        id: 'ad_username',
        name: 'ad_username',
        width: 210,
		hidden: true
    },{
		xtype: 'scrollcombo',
		cls: 'dropdown',
		fieldLabel: ad_username_label,
		editable: false,
		store: new Ext.data.Store({
			fields: ['displayField', 'valueField'],
			data: []
		}),
		margin: 10,
		displayField: 'displayField',
		valueField: 'valueField',
		queryMode: 'local',
		id: 'ad_username',
		name: 'ad_username',
		width: 210,
		hidden: true
	},{
        xtype: 'textfield',
        fieldLabel: password_label,
		inputType:"password",
        cls: 'textbox',
        width: 150,
        id: 'ad_password',
        name: 'ad_password',
        margin: 10,
		hidden: true
    },{
        xtype: 'textfield',
        fieldLabel: confirm_password_label,
		inputType:"password",
        cls: 'textbox',
        width: 150,
        id: 'ad_confirm_password',
        name: 'ad_confirm_password',
        margin: 10,
		hidden: true
    },
	{
        xtype: 'textfield',
        fieldLabel: "User name",
		cls: 'textbox',
		emptyText:"<<Domain\\User name>>",
        width: 150,
        id: 'serv_user',
        name: 'serv_user',
        margin: 10,
		hidden: true
    },
    {
        xtype: 'textfield',
        fieldLabel: "Task Name",
		cls: 'textbox',
 		width: 150,
        id: 'custom_taskname',
        name: 'custom_taskname',
        margin: 10,
		hidden: true
    },
    {
        xtype: 'textareafield',
        grow: true,
        cls: 'text-area',
        fieldLabel: 'Command',
        id: 'cmdSyntax',
        name: 'cmdSyntax',
        hidden: true,
		height:90,
        cols:45,
        margin: 10,
    }, 
    {
        xtype: 'textfield',
        fieldLabel: 'Arguments',
        cls: 'textbox',
        width: 130,
        id: 'arugumentsTextBox',
        name: 'arugumentsTextBox',
        margin: 10,
    }, 
  	{
  		xtype: 'radiogroup',
  		fieldLabel: 'Mode',
  		columns: 2,
  		cls:'radiobt',
  		margin:'10 10 0 10',
  		id: 'shadow_mode',
  		hidden: true,
		width: 180,
  		items: [
  			{
  				xtype: 'radiofield',
  				boxLabel: 'View',
  				name: 'shadow_mode',
  				id:'shadow_view',
  				inputValue: 'View',
  				checked: true
  			},
  			{
  				xtype: 'radiofield',
  				boxLabel: 'Control',
  				name: 'shadow_mode',
  				id:'shadow_control',
  				inputValue: 'Control'
  			}
  		]
  	},
    {
		xtype: 'fileuploadfield',
		width:350,
		cls: 'fileupload',
		fieldLabel: "File Upload",
		buttonText: 'Browse',
		margin:'10 10 0 10',
		width:200,
		name : 'fileupload',
		id : 'fileupload',
		hidden: true,
		listeners:{
			change:function(cmp,value,eOpts ){
				var fileName;
				if(value.indexOf("\\")>-1){
					fileName = value.substring(value.lastIndexOf("\\")+1);
				}
				Ext.getCmp('fileupload').setRawValue(fileName);
				Ext.getCmp('execute').setDisabled(true);
				Ext.getCmp('upload').setDisabled(false);
			},
		},
    },
    {
        xtype: "scrollcombo",
        width: 130,
        margin: 10,
        cls: "dropdown",
        fieldLabel: 'Output Required',
        editable: false,
        store: new Ext.data.Store({
            fields: ['displayField', 'valueField'],
            data: []
        }),
        displayField: 'displayField',
        valueField: 'valueField',
        queryMode: 'local',
        id: 'outputRqrd',
        name: 'outputRqrd'
    }, {

        xtype: 'textfield',
        fieldLabel: 'Timeout (in sec)',
        cls: 'textbox',
        width: 130,
        margin: 10,
        id: 'timeOutTextbox',
        name: 'timeOutTextbox',
    },
    {
        xtype: 'button',
        text: 'Upload',
		cls: 'button20',
		id: 'upload',
		width: 80,
        margin: "30 0 10 10",
        name: 'upload',
		hidden: true
    },{
        xtype: 'button',
        text: 'Execute',
        cls: 'button20',
        id: 'execute',
        width: 80,
        margin: "30 0 10 10",
        name: 'execute',
		hidden: true
    }],
	loadDefaultFormData: function()
	{
		var thisForm = this.getForm();
		thisForm.findField('rmt_cmds').hide();
		thisForm.findField('msg_box').hide();
		thisForm.findField('user_session_id').hide();
		thisForm.findField('user_process_name').hide();
		Ext.getCmp('execute').setVisible(false);
		rcLoadMask.show();
		Ext.Ajax.request({
			url : '/final/monitor/RemoteControlActionSessionJson.jsp?comptype='+init_comp_type+'&layername='+init_layer_name+'&test='+init_test_name+'&init_active_sessions_found='+init_active_sessions_found+'&port='+init_port,
			method : 'POST',
			scope:this,
			timeout:60000,
			success: function(response)
			{
				rcLoadMask.hide();
				var jsonData=Ext.decode(response.responseText);
				var thisForm = this.getForm();
				
				var rmtCmdOpts = thisForm.findField('rmt_cmds');
				rmtCmdOpts.getStore().loadRawData(jsonData['RemoteCmds']);
				rmtCmdOpts.setValue(jsonData['pageParams']['selectedCmd']);
					
				thisForm.findField('usernames').hide();
				thisForm.findField('rmt_cmds').show();
				if(init_test_name=='ChangeLoginTest' || init_test_name=='CtxXcXDSiteTest' || init_test_name=='CtxXcXDSiteSiteTest' || init_test_name=='CtxXcXDCGroupTest' || init_test_name=='CtxXcXDCBrMachTest' || init_test_name=='ADUserLockOutTest'  || init_test_name=='CitrixLicenseTest'  || init_test_name=='ADUsersTest')
				{
					//this.loadFormData();
				}
				else {
					var usernamesOpts = thisForm.findField('usernames');
					usernamesOpts.getStore().removeAll();
					usernamesOpts.getStore().loadRawData(jsonData['usernamesOpts']);
					usernamesOpts.setValue("-1");
					var aa=jsonData['usernamesOpts'];
					if(aa.length == 1){
						thisForm.findField('rmt_cmds').hide();
						Ext.getCmp('remotecontrolform').hide();
						var height=Ext.getCmp('remote_control').getHeight();
						var updatepanel=Ext.getCmp('remote_control');
						var output="<ul align='center' style='font-family:LucidaGrandeBold; font-size:11px; font-weight:bold;margin:10px; width:100%; height:100%; display:table;'><div style='text-align:center; vertical-align:middle;display:table-cell;'><div><img src='/final/images/Light/info_mgs_icon.png'></div>";
						output = output +"<div style='margin-top:15px;'><span style='color:"+outputColorCode+";'><li>No Users found!<\/li></span></div></div></ul>";
						updatepanel.add({
						xtype: 'container',
						height:height-2,
						html:output
						});
						updatepanel.doLayout();
					}
					
				}
			},
			failure: function(response)
			{
				rcLoadMask.hide();
			}
		});
	},   
	loadSessionData: function()
	{
		var selected_user_name = Ext.getCmp('usernames').getValue();
		var s_session_id = Ext.getCmp('user_session_id').getValue();
		rcLoadMask.show();
		Ext.Ajax.request({
			url : '/final/monitor/RemoteControlActionProcessJson.jsp?sel_user_sess_id='+s_session_id+'&selected_user_name='+encodeURIComponent(selected_user_name),
			method : 'POST',
			scope:this,
			timeout:60000,
			success: function(response)
			{
				rcLoadMask.hide();
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);

				var thisForm = this.getForm();
				if(jsonData.isTimeout)
				{
					Ext.getCmp('execute').setVisible(false);
					Ext.MessageBox.alert('Remote Control Action',jsonData.timeout_message);

					var thisForm = this.getForm();
					var userSessionOpts = thisForm.findField('user_session_id');
					userSessionOpts.setValue("-1");

					var userProcessOpts = thisForm.findField('user_process_name');
					userProcessOpts.setValue("-1");
					Ext.getCmp('user_process_name').hide();
				}
				else
				{
					var userProcessOpts = thisForm.findField('user_process_name');
					userProcessOpts.getStore().removeAll();
					userProcessOpts.getStore().loadRawData(jsonData['processOpts']);
					if(jsonData.s_process_id=='-1') {
						userProcessOpts.setValue('-1');
					}
					else {
						userProcessOpts.setValue(jsonData.s_process_id);
						Ext.getCmp('execute').setVisible(true);
					}
					Ext.getCmp('user_process_name').show();
				}
			},
			failure: function(response)
			{
				Ext.getCmp('execute').setVisible(false);
				rcLoadMask.hide();

				Ext.MessageBox.alert('Actions For The User','Failed to get user process details');

				var thisForm = this.getForm();
				var userSessionOpts = thisForm.findField('user_session_id');
				userSessionOpts.setValue("-1");

				var userProcessOpts = thisForm.findField('user_process_name');
				userProcessOpts.setValue("-1");
				Ext.getCmp('user_process_name').hide();
			}
		});
	},
	changeLicenseUsenameAndMachinename: function(val)
	{
		var remoteCmd = Ext.getCmp('remote_cmd');
		remoteCmd.removeAll();
		remoteCmd.hide();
		var thisForm = this.getForm();
		thisForm.findField('rmt_cmds').show();
		thisForm.findField('msg_box').hide();
		thisForm.findField('user_session_id').hide();
		thisForm.findField('user_process_name').hide();
		Ext.getCmp('execute').setVisible(false);
		rcLoadMask.show();
		Ext.Ajax.request({
			url : '/final/monitor/GetUserOrDeviceNames.jsp',
			method : 'POST',
			scope:this,
			timeout:60000,
			success: function(response)
			{
				rcLoadMask.hide();
				var jsonData=Ext.decode(response.responseText);
				var thisForm = this.getForm();
				thisForm.findField('ctx_user_machine_name').show();
				thisForm.findField('license_username').hide();
				thisForm.findField('license_machinename').hide();
				thisForm.findField('outputRqrd').hide();
				thisForm.findField('timeOutTextbox').hide();
				if(jsonData.isTimeout)
				{
					Ext.MessageBox.alert('Remote Control',jsonData.timeout_message);
				}
				else
				{
					var usernamesOpts = thisForm.findField('license_username');
					usernamesOpts.getStore().removeAll();
					usernamesOpts.getStore().loadRawData(jsonData['usernamesOpts']);
					usernamesOpts.setValue("-1");

					var devicenamesOpts = thisForm.findField('license_machinename');
					devicenamesOpts.getStore().removeAll();
					devicenamesOpts.getStore().loadRawData(jsonData['devicenamesOpts']);
					devicenamesOpts.setValue("-1");

					if(val=='username')
					{
						var usernames=jsonData['usernamesOpts'];
						if(usernames.length == 1){
							 var msg = Ext.MessageBox.show({
								title : 'Remote Control Action',
								msg : '<div style="min-width:250px;align:center"><span>No Users found</span></div>',
								modal:true,
								maskCls :'windowModal',
								buttons : Ext.MessageBox.OK,
								icon : Ext.MessageBox.WARNING
							});
						}
						else {
							thisForm.findField('license_username').show();
							thisForm.findField('license_machinename').hide();
						}
					}
					else
					{
						var devices=jsonData['devicenamesOpts'];
						if(devices.length == 1){
							 var msg = Ext.MessageBox.show({
								title : 'Remote Control Action',
								msg : '<div style="min-width:250px;align:center"><span>No Devices found</span></div>',
								modal:true,
								maskCls :'windowModal',
								buttons : Ext.MessageBox.OK,
								icon : Ext.MessageBox.WARNING
							});
						}
						else {
							thisForm.findField('license_username').hide();
							thisForm.findField('license_machinename').show();
						}
					}
				}
			},
			failure: function(response)
			{
				rcLoadMask.hide();
			}
		});
	}
})