var cmd = Ext.create('RemoteControlAction.view.RemoteControlActionCmd')
Ext.define('RemoteControlAction.controller.Main',{
	extend:'Ext.app.Controller',
	views:['Main'],
	refs:[
		{selector:'main', ref:'main'},
		{selector:'remotecontrolactionForm',ref:'remotecontrolactionForm'},
		{selector:'cmd',ref:'cmd'}
	],
	init:function(){
		me=this;
		this.control({
			'remotecontrolactionForm button[name="execute"]':{
				'click':this.showResult
			},
			'remotecontrolactionForm button[name="upload"]':{
				'click':this.fileUpload
			},
			'remotecontrolactionForm combo[id="usernames"]':{
				'select':this.loadSessionFormData
			},
			'remotecontrolactionForm combo[id="delivery_grp_name"]':{
				'select':this.changeDeliveryGroup
			},
			'remotecontrolactionForm combo[id="machine_name"]':{
				'select':this.changeDnsName
			},
			'remotecontrolactionForm combo[id="rmt_cmds"]':{
				'select':this.loadActionData
			},
			'remotecontrolactionForm combo[id="logonModes"]':{
				'select':this.changelogonModes
			},
			'remotecontrolactionForm combo[id="user_session_id"]':{
				'select':this.changeSessionId
			},
			'remotecontrolactionForm combo[id="user_process_name"]':{
				'select':this.changeProcessName
			},
			'remotecontrolactionForm combo[id="license_username"]':{
				'select':this.changeLicenseUsername
			},
			'remotecontrolactionForm combo[id="license_machinename"]':{
				'select':this.changeLicenseMachinename
			},
			'remotecontrolactionForm combo[id="ad_username"]':{
				'select':this.changeADUsername
			},
			'main' :
			{
				'boxready' : this.loadDefaultFormData
			},
			'main  #upbutton':
			{
				'click':this.toggleForm
			},
			'main button[id="bckBtn"]':
			{
				'click' : this.goBack
			}
		});
	},
	toggleForm:function(){
		var ornt = Ext.getCmp('remotecontrolform');
		ornt.toggleCollapse(true);
	},
	showResult : function()
	{
		var allowed="true";
		rcLoadMask = new Ext.LoadMask(Ext.getBody(), {
			msg : executingLbl+", "+waitLbl+".."
		});
		var thisForm = this.getRemotecontrolactionForm().getForm();
		var s_username = thisForm.findField('usernames').getValue();
		var rmt_cmd = thisForm.findField('rmt_cmds').getValue();
		var tmp = rmt_cmd.substring(rmt_cmd.indexOf(":")+1);
		if(rmt_cmd.indexOf(":")>-1){
			rmt_cmd = rmt_cmd.substring(0,rmt_cmd.indexOf(":"));
			
			if(rmt_cmd &&  rmt_cmd.startsWith("FILE#")){
				rmt_cmd = 'executeCustomScript';
				tmp = 'file';
			}
		}
		else if(rmt_cmd &&  rmt_cmd.startsWith("CMD#")){
				tmp = 'CMD';
		}else {
			if(rmt_cmd &&  rmt_cmd.startsWith("FILE#")){
				rmt_cmd = 'executeCustomScript';
			}
		}
		if((tmp == "OS" && !rmt_cmd.startsWith("RC_") ) || tmp == "Other" || tmp == "CMD" ){
			this.showOSResult();
		}
		else {
		var user_session_id = thisForm.findField('user_session_id').getValue();
		var user_process_id = thisForm.findField('user_process_name').getValue();
		var user_session_message = thisForm.findField('msg_box').getValue();
		var logon_mode = thisForm.findField('logonModes').getValue();

		var delivery_group_name = thisForm.findField('delivery_grp_name').getValue();
		var machine_name = thisForm.findField('machine_name').getValue();

		var license_user_name = thisForm.findField('license_username').getValue();
		var license_machine_name = thisForm.findField('license_machinename').getValue();

		var ad_user_name = thisForm.findField('ad_username').getValue();
		
		if(rmt_cmd == 'RC_29')
		{
			ad_user_name = thisForm.findField('arugumentsTextBox').getValue();
			if(ad_user_name != undefined && ad_user_name!=null && ad_user_name.trim().length ==0){
				Ext.Msg.show({
					title:alertTitle,
					msg: alertMsg1,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn:function(i){
						Ext.getCmp("arugumentsTextBox").focus(true);
					}
				});
				return;
			}
		}
		var ad_password = thisForm.findField('ad_password').getValue();
		var ad_confirm_password = thisForm.findField('ad_confirm_password').getValue();
		var outputRqrd = thisForm.findField('outputRqrd').getValue();
		var timeOut = thisForm.findField('timeOutTextbox').getValue();
		if(rmt_cmd=='RC_30' && ad_password != ad_confirm_password)
		{
			Ext.MessageBox.alert(alertTitle,password_alert);
			return;
		}

		var delivery_group_enable_disable = thisForm.findField('delivery_group_enable_disable').getValue();
		if(delivery_group_enable_disable=="true" || delivery_group_enable_disable==true)
		{
			delivery_group_enable_disable='enable';
		}
		else
		{
			delivery_group_enable_disable="disable";
		}
		if(rmt_cmd=='RC_5' && user_session_message.trim().length==0)
		{
			Ext.MessageBox.alert(alertTitle,msg_alert);
			allowed="false";
		}
		
		if(allowed=="true")
		{
			var remoteCmd = Ext.getCmp('remote_cmd');
			remoteCmd.removeAll();
			Ext.getCmp('execute').setDisabled(true);			
			rcLoadMask.show();
			remoteCmd.show();
			var hiddenQStr = publicJson['hiddenQStr'];
			var displayTxtCmd = filterEncode(thisForm.findField('rmt_cmds').displayTplData[0].displayField);
			var key_value_params = "ctx_username="+s_username+"&rmt_cmd="+rmt_cmd+"&user_session_id="+user_session_id+"&user_process_id="+user_process_id+"&user_session_message="+user_session_message+'&logon_mode='+logon_mode+'&machine_name='+machine_name+'&delivery_group_name='+delivery_group_name+'&delivery_group_enable_disable='+delivery_group_enable_disable+'&license_user_name='+license_user_name+'&license_machine_name='+license_machine_name+'&ad_user_name='+ad_user_name+'&ad_password='+ad_password+"&response="+outputRqrd+"&txtTimeout="+timeOut+hiddenQStr+"&displayTxtCmd="+displayTxtCmd+'&test='+tmp+"&hostname="+hostName+'&port='+init_port+'&comptype='+init_comp_type;
			if(rmt_cmd=='executeCustomScript'){
				var fileName = thisForm.findField('rmt_cmds').getValue();
				if(fileName &&  fileName.startsWith("FILE#")){
					fileName = fileName.substring(fileName.indexOf("#") + 1);
					if(fileName.indexOf(":") > -1){
						fileName = fileName.substring(0, fileName.indexOf(":"));
					}
				}
				var params = thisForm.findField('arugumentsTextBox').getValue();
				key_value_params = key_value_params + '&agentIP='+agentIP+'&fileName='+fileName+'&customAction='+displayTxtCmd+"&customArguments="+params;
			}
			var timeOutValForAjax = (parseInt(timeOut)*1000)+10000;
			var winHeight = Ext.getCmp('remote_control').getHeight();
			var cmdHeight = winHeight - Ext.getCmp('remotecontrolform').getHeight()-40;
			if(rmt_cmd == 'RC_41'){
				var shadowMode = thisForm.findField('shadow_mode').getValue().shadow_mode;
				Ext.Ajax.request({
						url : '/final/monitor/RemoteControlActionUtils.jsp?cmd='+rmt_cmd+"&agentIP="+agentIP+"&shadowMode="+shadowMode+"&user_session_id="+user_session_id,
						method : 'POST',
						timeout:timeOutValForAjax,
						scope:this,
						success: function(response)
						{
							var displayMsg;
							if(outputRqrd == "Yes" || outputRqrd == "yes"){
								displayMsg = remoteControlLbl+". <br>"+downloadTitle+" ."+batfileTitle+".";
							}
							else{
								displayMsg = remoteControlSuccessTitle;
							}
							window.location.href= "../images/RemoteControl/shadow_"+agentIP+"_session"+user_session_id+".bat";
							Ext.getCmp('execute').setDisabled(false);
							rcLoadMask.hide();
							var updatepanel=Ext.getCmp('remote_cmd');
							var output="<ul align='center' class='f11-normal' style='margin:10px; width:100%; height:100%; display:table;'><div style='text-align:center; vertical-align:middle;display:table-cell;'><div><img src='"+imgPath+"/success_msg_icon.png'></div>";
							output = output +"<div style='margin-top:15px;'><span style='color:"+fontColorCode+";'><li>"+displayMsg+"<\/li></span></div></div></ul>";
							updatepanel.add({
    							xtype: 'panel',
    							margin:10,
    							height:cmdHeight,
    							cls:'formOuter',
    							id:'updatepanel',
    							html:output
  							});
  							updatepanel.doLayout();
  							remoteCmd.show();
						}
				});
			}
			else {
				Ext.Ajax.request({
					url : '/final/monitor/RemoteControlAppActionp.jsp',
					method : 'POST',
					params: key_value_params,
					timeout:timeOutValForAjax,
					scope:this,
					success: function(response)
					{
						Ext.getCmp('execute').setDisabled(false);
						rcLoadMask.hide();
						var jsonData=Ext.decode(response.responseText);
						if(!Ext.isEmpty(jsonData))
						{
							var result = jsonData['output'];
							var fieldModel = new Array();
							var columns = new Array();
							var updatepanel=Ext.getCmp('remote_cmd');
							var isGridView = jsonData['isGridView'];
							if(isGridView != 'undefined' && isGridView != undefined && isGridView == "true"){
								var tableData = jsonData['gridJson'];
								var errorMsg = tableData['errorMsg'];
								var gridTitle = tableData['gridTitle'];
								var colIdx = 0;
								if (errorMsg=='-') 
								{
									var tableColumns = tableData['tableColumns'];
									var gridValues = tableData['gridValues'];
									for (var key in tableColumns) {                    
										fieldModel.push({
											name: 'COLUMVal_' + colIdx,
											type: 'string'
										});
										columns.push({
											header: tableColumns[key],
											dataIndex: 'COLUMVal_' + colIdx,
											align: 'left',
											flex: 1,
											sortable: true,
										});
										colIdx++;
									}
									var ackStore = Ext.data.Store({
										fields: fieldModel,
										data: gridValues,
										proxy: {
											type: 'ajax',
											reader: {
												type: 'json'
											}
										}
									});	
									updatepanel.add({
										xtype: 'grid',
										store: ackStore,
										margin:'5 10 5 10',
										title: '<span class="f13-bold">'+gridTitle+'</span>',
										cls: 'gridSkin',
										height:cmdHeight+10,
										bodyStyle:'overflowY: auto',
										scroll:true,
										columns: columns,
									});
								}
								else {
									updatepanel.add({
										xtype: 'panel',
										scroll:true,
										margin:10,
										border:false,
										cls:'formOuter',
										height:cmdHeight,
										bodyStyle:'overflowY: auto',
										id:'updatepanel',
										html:result
									});
								}
							}
							else {
								updatepanel.add({
									xtype: 'panel',
									scroll:true,
									margin:10,
									border:false,
									cls:'formOuter',
									height:cmdHeight,
									id:'updatepanel',
									html:result,
									bodyStyle:'overflowY: auto',
								});
							}
							updatepanel.doLayout();
							remoteCmd.show();
							if(rmt_cmd=='fileupload' && result.indexOf("File uploaded successfully")>-1){
								Ext.getCmp('upload').setDisabled(true);
								Ext.Ajax.request({
									url : '/final/monitor/RemoteControlActionJson.jsp?comptype='+init_comp_type+'&layername='+init_layer_name+'&port='+init_port+'&agentIP='+agentIP,
									method : 'POST',
									scope:this,
									success: function(response)
									{
										var jsonText = response.responseText;
										var jsonData=Ext.decode(jsonText);
										var rmtCmdOpts = thisForm.findField('rmt_cmds');
										rmtCmdOpts.getStore().loadRawData(publicJson['RemoteCmds']);
										rmtCmdOpts.setValue(fileName);
									}
								});
							}
						}
					},
					failure:function()
					{
						Ext.getCmp('execute').setDisabled(false);
						rcLoadMask.hide();
						var updatepanel=Ext.getCmp('remote_cmd');
						var output="<ul align='center' class='f11-normal' style='margin:10px; width:100%; height:100%; display:table;'><div style='text-align:center; vertical-align:middle;display:table-cell;'><div><img src='"+imgPath+"/info_mgs_icon.png'></div>";
						output = output +"<div style='margin-top:15px;'><span style='color:"+fontColorCode+";'><li>"+timedoutTitle+" <\/li></span></div></div></ul>";
						updatepanel.add({
							xtype: 'panel',
							margin:10,
							height:cmdHeight,
							cls:'formOuter',
							id:'updatepanel',
							html:output
						});
						updatepanel.doLayout();
						remoteCmd.show();
					}
					});
				}
			}
		}
	},
	changeUsername :  function(combo)
	{
		var remoteCmd = Ext.getCmp('remote_cmd');
		remoteCmd.removeAll();
		remoteCmd.show();
		Ext.getCmp('execute').setVisible(false);
		var thisForm = this.getRemotecontrolactionForm().getForm();
		thisForm.findField('rmt_cmds').hide();	
		thisForm.findField('msg_box').hide();			
		thisForm.findField('user_session_id').hide();
		thisForm.findField('user_process_name').hide();
		var rmt_cmd = combo.getValue();
		if(combo.getValue() !='-1')
		{
			thisForm.findField('rmt_cmds').show();	
		}
	},
	changeDeliveryGroup :  function(combo)
	{
		var remoteCmd = Ext.getCmp('remote_cmd');
		remoteCmd.removeAll();
		remoteCmd.show();
		var rmt_cmd = Ext.getCmp('rmt_cmds').getValue();
		rmt_cmd = rmt_cmd.substring(0,rmt_cmd.indexOf(":"));
		Ext.getCmp('execute').setVisible(false);
		var thisForm = this.getRemotecontrolactionForm().getForm();
		thisForm.findField('outputRqrd').hide();
		thisForm.findField('timeOutTextbox').hide();
		thisForm.findField('msg_box').hide();			
		thisForm.findField('user_session_id').hide();
		thisForm.findField('user_process_name').hide();
		thisForm.findField('machine_name').hide();
		thisForm.findField('delivery_group_status').hide();
		if(combo.getValue() !='-1')
		{
			if(rmt_cmd=='RC_22'){
				thisForm.findField('delivery_group_status').hide();
			}
			else{
				thisForm.findField('delivery_group_status').show();
			}
			thisForm.findField('outputRqrd').show();
			thisForm.findField('timeOutTextbox').show();
			Ext.getCmp('execute').setVisible(true);
		}
	},
	changeDnsName :  function(combo)
	{
		var remoteCmd = Ext.getCmp('remote_cmd');
		remoteCmd.removeAll();
		remoteCmd.show();
		var thisForm = this.getRemotecontrolactionForm().getForm();
		thisForm.findField('outputRqrd').hide();
		thisForm.findField('timeOutTextbox').hide();
		Ext.getCmp('execute').setVisible(false);
		
		thisForm.findField('msg_box').hide();			
		thisForm.findField('user_session_id').hide();
		thisForm.findField('user_process_name').hide();
		thisForm.findField('delivery_grp_name').hide();
		thisForm.findField('delivery_group_status').hide();
		if(combo.getValue() !='-1')
		{
			thisForm.findField('delivery_group_status').show();
			thisForm.findField('outputRqrd').show();
				thisForm.findField('timeOutTextbox').show();
			Ext.getCmp('execute').setVisible(true);
		}
	},
	changeCommand :  function()
	{
		var rmt_cmd = Ext.getCmp('rmt_cmds').getValue();
		rmt_cmd = rmt_cmd.substring(0,rmt_cmd.indexOf(":"));
		var winHeight = Ext.getCmp('remote_control').getHeight();
		var cmdHeight = winHeight - Ext.getCmp('remotecontrolform').getHeight()-40;
		Ext.getCmp('execute').setVisible(false);
		var thisForm = this.getRemotecontrolactionForm().getForm();
		thisForm.findField('outputRqrd').setValue('Yes');
		thisForm.findField('shadow_mode').hide();
		rcLoadMask.hide();
		if(rmt_cmd=='-1')
		{
			thisForm.findField('msg_box').hide();			
			thisForm.findField('user_session_id').hide();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_grp_name').hide();
			thisForm.findField('delivery_group_status').hide();
		}
		else if(rmt_cmd=='DownloadImage')
		{
			// Show me screenshot
			thisForm.findField('msg_box').hide();
			thisForm.findField('user_session_id').show();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('delivery_grp_name').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_group_status').hide();

			thisForm.findField('user_session_id').setValue(singleSessionId);
			thisForm.findField('user_process_name').setValue('-1');
			thisForm.findField('msg_box').setValue('none');
			thisForm.findField('logonModes').setValue('-1');
			thisForm.findField('outputRqrd').show();
			thisForm.findField('timeOutTextbox').show();
			Ext.getCmp('execute').setVisible(true);
		}
		else if(rmt_cmd=='RC_0')
		{
			//View session
			thisForm.findField('msg_box').hide();
			thisForm.findField('user_session_id').show();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('delivery_grp_name').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_group_status').hide();

			thisForm.findField('user_session_id').setValue(singleSessionId);
			thisForm.findField('user_process_name').setValue('-1');
			thisForm.findField('msg_box').setValue('none');
			thisForm.findField('logonModes').setValue('-1');
			thisForm.findField('outputRqrd').show();
			thisForm.findField('timeOutTextbox').show();
			Ext.getCmp('execute').setVisible(true);
		}
		else if(rmt_cmd=='RC_1' || rmt_cmd=='RC_11' || rmt_cmd=='RC_12' || rmt_cmd=='RC_13' || rmt_cmd=='RC_21' || rmt_cmd=='RC_45' || rmt_cmd=='RC_46' || rmt_cmd=='RC_47')
		{
			// Get user processes (query process <username>)
			thisForm.findField('msg_box').hide();
			thisForm.findField('user_session_id').hide();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('delivery_grp_name').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_group_status').hide();

			thisForm.findField('user_session_id').setValue(singleSessionId);
			thisForm.findField('user_process_name').setValue('-1');
			thisForm.findField('msg_box').setValue('none');
			thisForm.findField('logonModes').setValue('-1');
			thisForm.findField('outputRqrd').show();
			thisForm.findField('timeOutTextbox').show();
			Ext.getCmp('execute').setVisible(true);
		}
		else if(rmt_cmd=='RC_2'  || rmt_cmd=='RC_54' || rmt_cmd=='RC_41' || rmt_cmd=='RC_42' || rmt_cmd=='RC_43')
		{
			//View processes of a session (query process /ID:<session id>)
			thisForm.findField('msg_box').hide();
			thisForm.findField('user_session_id').show();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('delivery_grp_name').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_group_status').hide();

			thisForm.findField('user_session_id').setValue(singleSessionId);
			thisForm.findField('user_process_name').setValue('-1');
			thisForm.findField('msg_box').setValue('none');
			thisForm.findField('logonModes').setValue('-1');
			thisForm.findField('outputRqrd').show();
			thisForm.findField('timeOutTextbox').show();

			if(rmt_cmd=='RC_41'){
				thisForm.findField('shadow_mode').show();
			}
			if(singleSessionId!='-1')
				Ext.getCmp('execute').setVisible(true);
			else				
				Ext.getCmp('execute').setVisible(false);
		}
		else if(rmt_cmd=='RC_3')
		{
			// Disconnect the session (tsdiscon <session id>)
			thisForm.findField('msg_box').hide();
			thisForm.findField('user_session_id').show();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('delivery_grp_name').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_group_status').hide();			

			thisForm.findField('user_session_id').setValue(singleSessionId);
			thisForm.findField('user_process_name').setValue('-1');
			thisForm.findField('msg_box').setValue('none');
			thisForm.findField('logonModes').setValue('-1');
			thisForm.findField('outputRqrd').show();
			thisForm.findField('timeOutTextbox').show();
			if(singleSessionId!='-1')
				Ext.getCmp('execute').setVisible(true);
			else				
				Ext.getCmp('execute').setVisible(false);
		}
		else if(rmt_cmd=='RC_4')
		{
			// Logoff the session  (logoff.exe <sessionid>)
			thisForm.findField('msg_box').hide();
			thisForm.findField('user_session_id').show();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('delivery_grp_name').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_group_status').hide();			

			thisForm.findField('user_session_id').setValue(singleSessionId);
			thisForm.findField('user_process_name').setValue('-1');
			thisForm.findField('msg_box').setValue('none');
			thisForm.findField('logonModes').setValue('-1');
			thisForm.findField('outputRqrd').show();
			thisForm.findField('timeOutTextbox').show();
			if(singleSessionId!='-1')
				Ext.getCmp('execute').setVisible(true);
			else				
				Ext.getCmp('execute').setVisible(false);
		}
		else if(rmt_cmd=='RC_5')
		{
			// Send Message to a session (<msg.exe <sessionid> /Time:10 <message to send>)
			thisForm.findField('msg_box').hide();
			thisForm.findField('user_session_id').show();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('delivery_grp_name').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_group_status').hide();

			thisForm.findField('user_session_id').setValue(singleSessionId);
			thisForm.findField('outputRqrd').show();
			thisForm.findField('timeOutTextbox').show();
			if(singleSessionId!='-1')
			{
				thisForm.findField('msg_box').show();
				Ext.getCmp('execute').setVisible(true);
			}
			else				
				Ext.getCmp('execute').setVisible(false);
		}
		else if(rmt_cmd=='RC_6')
		{
			// Kill a process running in a session (taskkill /f /FI "Session eq <sessionid>" /PID <pid> /T)
			thisForm.findField('msg_box').hide();
			thisForm.findField('user_session_id').show();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('delivery_grp_name').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_group_status').hide();

			thisForm.findField('user_session_id').setValue(singleSessionId);
			if(singleSessionId!='-1')
			{
				this.getRemotecontrolactionForm().loadSessionData();
			}
			else				
				Ext.getCmp('execute').setVisible(false);
		}
		else if(rmt_cmd=='RC_8')
		{
			// display services hosted in process
			thisForm.findField('msg_box').hide();
			thisForm.findField('user_session_id').show();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('delivery_grp_name').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_group_status').hide();

			thisForm.findField('user_session_id').setValue(singleSessionId);
			if(singleSessionId!='-1')
			{
				this.getRemotecontrolactionForm().loadSessionData();
			}
			else				
				Ext.getCmp('execute').setVisible(false);
		}
		else if(rmt_cmd=='RC_9')
		{
			// display services hosted in process
			thisForm.findField('msg_box').hide();
			thisForm.findField('user_session_id').show();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('delivery_grp_name').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_group_status').hide();

			thisForm.findField('user_session_id').setValue(singleSessionId);
			if(singleSessionId!='-1')
			{
				this.getRemotecontrolactionForm().loadSessionData();
			}
			else				
				Ext.getCmp('execute').setVisible(false);
		}
		else if(rmt_cmd=='RC_10' || rmt_cmd=='RC_23')
		{
			//printer
			thisForm.findField('msg_box').hide();
			thisForm.findField('user_session_id').show();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('delivery_grp_name').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_group_status').hide();			

			thisForm.findField('user_session_id').setValue(singleSessionId);
			thisForm.findField('user_process_name').setValue('-1');
			thisForm.findField('msg_box').setValue('none');
			thisForm.findField('logonModes').setValue('-1');
			thisForm.findField('outputRqrd').show();
			thisForm.findField('timeOutTextbox').show();
			if(singleSessionId!='-1')
				Ext.getCmp('execute').setVisible(true);
			else				
				Ext.getCmp('execute').setVisible(false);
		}
		else if(rmt_cmd=='RC_14')
		{
			// Changes the XenApp Logon Mode for the selected server
			thisForm.findField('msg_box').hide();
			thisForm.findField('user_session_id').hide();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('logonModes').show();
			thisForm.findField('delivery_grp_name').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_group_status').hide();

			thisForm.findField('user_session_id').setValue(singleSessionId);
			thisForm.findField('user_process_name').setValue('-1');
			thisForm.findField('msg_box').setValue('none');
			thisForm.findField('logonModes').setValue('-1');
			Ext.getCmp('execute').setVisible(false);
		}
		else if(rmt_cmd=='RC_16')
		{
			// Drain Remote Desktop Sessions
			thisForm.findField('usernames').hide();
			thisForm.findField('msg_box').hide();
			thisForm.findField('user_session_id').hide();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('delivery_grp_name').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_group_status').hide();
			thisForm.findField('outputRqrd').show();
			thisForm.findField('timeOutTextbox').show();
			Ext.getCmp('execute').setVisible(true);
		}
		else if(rmt_cmd=='RC_17')
		{
			//Lock User's Desktop session
			thisForm.findField('msg_box').hide();
			thisForm.findField('user_session_id').show();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('delivery_grp_name').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_group_status').hide();

			thisForm.findField('user_session_id').setValue(singleSessionId);
			thisForm.findField('user_process_name').setValue('-1');
			thisForm.findField('msg_box').setValue('none');
			thisForm.findField('logonModes').setValue('-1');
			thisForm.findField('outputRqrd').show();
			thisForm.findField('timeOutTextbox').show();
			if(singleSessionId!='-1')
				Ext.getCmp('execute').setVisible(true);
			else				
				Ext.getCmp('execute').setVisible(false);
		}
		else if(rmt_cmd=='RC_18')
		{
			//List users mapped network drives
			thisForm.findField('msg_box').hide();
			thisForm.findField('user_session_id').show();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('delivery_grp_name').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_group_status').hide();

			thisForm.findField('user_session_id').setValue(singleSessionId);
			thisForm.findField('user_process_name').setValue('-1');
			thisForm.findField('msg_box').setValue('none');
			thisForm.findField('logonModes').setValue('-1');
			thisForm.findField('outputRqrd').show();
			thisForm.findField('timeOutTextbox').show();
			if(singleSessionId!='-1')
				Ext.getCmp('execute').setVisible(true);
			else				
				Ext.getCmp('execute').setVisible(false);
		}
		else if(rmt_cmd=='RC_19')
		{
			//Enable Maintenance on Brokered machine
			thisForm.findField('msg_box').hide();
			thisForm.findField('user_session_id').hide();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('machine_name').show();
			thisForm.findField('delivery_grp_name').hide();			
			thisForm.findField('delivery_group_status').hide();

			thisForm.findField('user_session_id').setValue(singleSessionId);
			thisForm.findField('user_process_name').setValue('-1');
			thisForm.findField('msg_box').setValue('none');
			thisForm.findField('logonModes').setValue('-1');
			thisForm.findField('machine_name').setValue('-1');
			thisForm.findField('delivery_group_status').setValue('-1');
			Ext.getCmp('execute').setVisible(false);
		}
		else if(rmt_cmd=='RC_20' || rmt_cmd=='RC_22')
		{
			//Enable/Disable Desktop Delivery Group
			//Citrix Delivery Controller 7.x component.
			thisForm.findField('msg_box').hide();
			thisForm.findField('user_session_id').hide();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_grp_name').show();			
			thisForm.findField('delivery_group_status').hide();

			thisForm.findField('user_session_id').setValue(singleSessionId);
			thisForm.findField('user_process_name').setValue('-1');
			thisForm.findField('msg_box').setValue('none');
			thisForm.findField('logonModes').setValue('-1');
			thisForm.findField('machine_name').setValue('-1');
			thisForm.findField('delivery_grp_name').setValue('-1');
			Ext.getCmp('execute').setVisible(false);
		}
		else if(rmt_cmd=='RC_25')
		{
			// Release Citrix user license
			thisForm.findField('msg_box').hide();
			thisForm.findField('user_session_id').hide();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('delivery_grp_name').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_group_status').hide();
			thisForm.findField('user_session_id').setValue(singleSessionId);
			thisForm.findField('ctx_user_machine_name').show();
			Ext.getCmp('execute').setVisible(false);
		}
		else if(rmt_cmd=='RC_27' || rmt_cmd=='RC_28' || rmt_cmd=='RC_29')
		{
			// Unlock AD Accounts // Unlock AD Accounts //Disable Active Directory account
			thisForm.findField('msg_box').hide();
			thisForm.findField('user_session_id').hide();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('delivery_grp_name').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_group_status').hide();
			thisForm.findField('user_session_id').setValue(singleSessionId);
			thisForm.findField('ctx_user_machine_name').hide();
			thisForm.findField('ad_username').setValue('-1');
			thisForm.findField('ad_password').hide();
			thisForm.findField('ad_confirm_password').hide();
			Ext.getCmp('execute').setVisible(false);
			var adUserNameOpts = thisForm.findField('ad_username');
			if(adUserNameOpts.getStore().totalCount == 1)
			{
				adUserNameOpts.hide();
				var height=Ext.getCmp('remote_control').getHeight();
				var updatepanel=Ext.getCmp('remote_cmd');
				var output="<ul align='center' style='width:100%; height:100%; display:table;' class='f14-normal'><div style='text-align:center; vertical-align:middle;display:table-cell;'><div><img src='"+imgPath+"/info_mgs_icon.png'></div>";
				output = output +"<div style='margin-top:15px;' class='f14-normal'><span><li>"+noUsersLbl+"!<\/li></span></div></div></ul>";
				updatepanel.add(
				{
					xtype: 'container',
					margin:10,
					cls:'formOuter',
					height:cmdHeight,
					//style:{'border':'1px solid #d2d2d2 !important'},
					//bodyStyle:{'background':'#fbfbfb','overflow':'auto'},
					html:output
				});
				updatepanel.doLayout();
				updatepanel.show();
			}
			else {
				adUserNameOpts.show();
			}

		}
		else if(rmt_cmd=='RC_30'  || rmt_cmd=='RC_50')
		{
			//Reset Active Directory User Password
			thisForm.findField('msg_box').hide();
			thisForm.findField('user_session_id').hide();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('delivery_grp_name').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_group_status').hide();
			thisForm.findField('user_session_id').setValue(singleSessionId);
			thisForm.findField('ctx_user_machine_name').hide();
			
			thisForm.findField('ad_password').hide();
			thisForm.findField('ad_confirm_password').hide();
			Ext.getCmp('execute').setVisible(false);
			var adUserNameOpts = thisForm.findField('ad_username');
			if(adUserNameOpts.getStore().totalCount == 1)
			{
				adUserNameOpts.hide();
				var height=Ext.getCmp('remote_control').getHeight();
				var updatepanel=Ext.getCmp('remote_cmd');
				updatepanel.removeAll();
				var output="<ul align='center' class='f11-normal' style='margin:10px; width:100%; height:100%; display:table;'><div style='text-align:center; vertical-align:middle;display:table-cell;'><div><img src='"+imgPath+"/info_mgs_icon.png'></div>";
				output = output +"<div style='margin-top:15px;'><span style='color:"+fontColorCode+";'><li>"+noUsersLbl+"!<\/li></span></div></div></ul>";
				updatepanel.add({
					xtype: 'container',
					margin:10,
					cls:'formOuter',
					height:cmdHeight,
					border:false,
					html:output
				});
				updatepanel.doLayout();
				updatepanel.show();
			}
			else {
				adUserNameOpts.show();
			}
		}
		else if(rmt_cmd=='RC_15' || rmt_cmd=='RC_36' || rmt_cmd=='RC_37' || rmt_cmd=='RC_38' || rmt_cmd=='RC_39' || rmt_cmd=='RC_40' || rmt_cmd == 'RC_47' || rmt_cmd == 'RC_49' || task_name == 'RC_51' || task_name == 'RC_52' || task_name == 'RC_53' )
		{
			//Reset Active Directory User Password
			thisForm.findField('msg_box').hide();
			thisForm.findField('user_session_id').hide();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('delivery_grp_name').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_group_status').hide();
			thisForm.findField('user_session_id').hide();
			thisForm.findField('ctx_user_machine_name').hide();
			thisForm.findField('usernames').hide();
			thisForm.findField('ad_username').hide();
			thisForm.findField('ad_password').hide();
			thisForm.findField('ad_confirm_password').hide();
			thisForm.findField('outputRqrd').show();
			thisForm.findField('timeOutTextbox').show();
			Ext.getCmp('execute').setVisible(true);
			
		}
		else
		{
			thisForm.findField('msg_box').hide();
			thisForm.findField('user_session_id').hide();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('logonModes').hide();
		}
		var remoteCmd = Ext.getCmp('remote_cmd');
		remoteCmd.show();
	},
	resizeMe:function(){
		cmd.setWidth(Ext.getBody().getViewSize().width -10);
		cmd.setHeight(Ext.getBody().getViewSize().height -10)
	},
	showCmd:function(){
		cmd.show();		
	},
	cmdBack:function(bt){
		cmd.hide();
	},
	fileUpload :  function(combo)
	{
		var remoteCmd = Ext.getCmp('remote_cmd');
		remoteCmd.removeAll();
		rcLoadMask.hide();
		var thisForm = this.getRemotecontrolactionForm().getForm();
		var fileName = thisForm.findField('fileupload').getValue();
		var customTaskName = thisForm.findField('custom_taskname').getValue();
		var isValidArgs = true;
		var argsErrMsg = '';
		if(fileName!=null && fileName.length >0){
			if(Ext.isEmpty(customTaskName)){
				argsErrMsg = taskNameEmptyLbl+', '+taskNameLbl+'.';
				isValidArgs = false;
			}
			else if(!checkspace(fileName)){
				argsErrMsg = spaceLbl+'.';
				isValidArgs = false;
			}
			else if(!checkspecialChar(fileName,"`~!@#%^&*()+={}[]|\\;\"\'<>,?"))
			{
				argsErrMsg = 'Special characters are not allowed for the file name.';
				isValidArgs = false;
			}
		}
		if (thisForm.isValid())
		{
			if(isValidArgs){
				Ext.getCmp('upload').setDisabled(true);
				rcLoadMask = new Ext.LoadMask(Ext.getBody(), {
					msg : "Uploading the script to the Agent, please wait.."
				});
				rcLoadMask.show();
				thisForm.submit(
				{
					url : "/final/monitor/RemoteControlFileUpload.jsp?fileName="+fileName+"&taskName="+customTaskName+"&agentIP="+agentIP,
					scope:this,
					async : true,
					method : 'POST',
					enctype : 'multipart/form-data',
					success: function (form, action)
					{
						var jsonText = action.response.responseText;
						jsonText = Ext.decode(jsonText);
						var alertTextSuccessMsg = jsonText['success'];
						var ErrMsgsJson =jsonText['ErrMsgsJson'];
						if (!Ext.isEmpty(jsonText))
						{
							if(Ext.isEmpty(ErrMsgsJson))
							{
								rcLoadMask = new Ext.LoadMask(Ext.getBody(), {
									msg : "Uploading the script to the Agent, please wait.."
								});
								rcLoadMask.show();
								var thisForm = this.getRemotecontrolactionForm().getForm();
								var rmt_cmd = thisForm.findField('rmt_cmds').getValue();
								Ext.getCmp('execute').setDisabled(true);	
								thisForm.findField('fileupload').setRawValue(fileName);
								var hiddenQStr = publicJson['hiddenQStr'];
								var displayTxtCmd = thisForm.findField('rmt_cmds').displayTplData[0].displayField;
								var outputRqrd = thisForm.findField('outputRqrd').getValue();
								var timeOut = thisForm.findField('timeOutTextbox').getValue();
								var key_value_params = "rmt_cmd="+rmt_cmd+"&response="+outputRqrd+"&txtTimeout="+timeOut+hiddenQStr+"&displayTxtCmd="+displayTxtCmd+"&hostname="+hostName+'&port='+init_port+'&comptype='+init_comp_type;
								key_value_params = key_value_params + '&agentIP='+agentIP+'&fileName='+fileName+'&customAction='+customTaskName;
								var timeOutValForAjax = (parseInt(timeOut)*1000)+10000;
								var winHeight = Ext.getCmp('remote_control').getHeight();
								var cmdHeight = winHeight - Ext.getCmp('remotecontrolform').getHeight()-40;
								Ext.Ajax.request({
									url : '/final/monitor/RemoteControlAppActionp.jsp',
									method : 'POST',
									params: key_value_params,
									timeout:timeOutValForAjax,
									scope:this,
									success: function(response)
									{
										var jsonData=Ext.decode(response.responseText);
										if(!Ext.isEmpty(jsonData))
										{
											var updatepanel=Ext.getCmp('remote_cmd');
											var result = jsonData['output'];
											updatepanel.add({
												xtype: 'panel',
												scroll:true,
												margin:10,
												border:false,
												cls:'formOuter',
												height:cmdHeight,
												id:'updatepanel',
												html:result,
												bodyStyle:'overflowY: auto',
											});
										}
										thisForm.findField('fileupload').setRawValue('');
										updatepanel.doLayout();
										if(rmt_cmd=='fileupload' && result.indexOf("Custom action has been defined successfully")>-1){
											Ext.getCmp('upload').setDisabled(true);
											Ext.Ajax.request({
												url : '/final/monitor/RemoteControlActionJson.jsp?comptype='+init_comp_type+'&layername='+init_layer_name+'&port='+init_port+'&agentIP='+agentIP,
												method : 'POST',
												scope:this,
												success: function(response)
												{
													var jsonText = response.responseText;
													var jsonData=Ext.decode(jsonText);
													var rmtCmdOpts = thisForm.findField('rmt_cmds');
													rmtCmdOpts.getStore().loadRawData(jsonData['RemoteCmds']);
													rmtCmdOpts.setValue(fileName);
													Ext.getCmp('execute').setDisabled(false);
													Ext.getCmp('execute').setVisible(true);
													Ext.getCmp('upload').setVisible(false);
													Ext.getCmp('upload').setDisabled(true);
													thisForm.findField('fileupload').hide();
													thisForm.findField('custom_taskname').hide();
													var argumentsObj = thisForm.findField('arugumentsTextBox');
													argumentsObj.emptyText = "none";
													argumentsObj.applyEmptyText();
													argumentsObj.show();
													argumentsObj.setValue('');
												}
											});
										}
										rcLoadMask.hide();
										remoteCmd.show();
									}
								});
								jsonText = null;
								Ext.destroy(jsonText);
							}
							else{
								rcLoadMask.hide();
								var msg = Ext.MessageBox.show({
									title : RCATitle,
									width: 400,
									modal: true,
									msg : ErrMsgsJson ,
									buttons : Ext.MessageBox.OK,
									maskCls :'windowModal',
									icon: 'iconExclamation'
								});
								Ext.WindowManager.bringToFront(msg);
							}
						}
					},
					failure: function (form, action)
					{
						alert("File uploading failed!");						
					}
				});
			}
			else{
				var msg = Ext.MessageBox.show({
					title : RCATitle,
					width:400,
					modal:true,
					msg :  argsErrMsg,
					buttons : Ext.MessageBox.OK,
					maskCls :'windowModal',
					icon: 'iconExclamation'
				});
				Ext.WindowManager.bringToFront(msg);
			}
		}
	},
	loadDefaultFormData : function()
	{
		var thisForm = this.getRemotecontrolactionForm().getForm();
		thisForm.findField('usernames').hide();
		thisForm.findField('msg_box').hide();
		thisForm.findField('user_session_id').hide();
		thisForm.findField('user_process_name').hide();
		thisForm.findField('cmdSyntax').hide();
		thisForm.findField('arugumentsTextBox').hide();
		thisForm.findField('outputRqrd').hide();
		thisForm.findField('timeOutTextbox').hide();
		Ext.getCmp('execute').setVisible(false);
		
		var screenLabels = publicJson['screenLabels'];				
		var rmtCmdOpts = thisForm.findField('rmt_cmds');
		rmtCmdOpts.getStore().loadRawData(publicJson['RemoteCmds']);
		rmtCmdOpts.setValue(publicJson['pageParams']['selectedCmd']);
		
		var arugumentsTextBox = thisForm.findField('arugumentsTextBox');
		//arugumentsTextBox.setValue(publicJson['pageParams']['arguments']);
		arugumentsTextBox.setFieldLabel(screenLabels['monitor.remotecontrol.Arguments']);

		var outputRqrdCombo = thisForm.findField('outputRqrd');
		outputRqrdCombo.getStore().loadRawData(publicJson['yesNoOpts']);
		outputRqrdCombo.setValue(publicJson['pageParams']['outputRequired']);
		outputRqrdCombo.setFieldLabel(screenLabels['monitor.remotecontrol.Output required']);

		var timeOutTextbox = thisForm.findField('timeOutTextbox');
		timeOutTextbox.setValue(publicJson['pageParams']['selectedTimeOutPeriod']);
		timeOutTextbox.setFieldLabel(screenLabels['monitor.remotecontrol.Timeout']);
			
		if (Ext.get('loadmask'))
		{
			Ext.get('loadmask').remove();
		}
	},
	showOSResult : function()
	{
		var thisForm = this.getRemotecontrolactionForm().getForm();
		var commandOpts = thisForm.findField('rmt_cmds').getValue();
		var displayTxtCmd = thisForm.findField('rmt_cmds').displayTplData[0].displayField;
		if(commandOpts.indexOf(":")>-1)
			commandOpts = commandOpts.substring(0,commandOpts.indexOf(":"));
		var command = commandOpts;
		var cmdSyntax = thisForm.findField('cmdSyntax').getValue();
		var aruguments = thisForm.findField('arugumentsTextBox').getValue().trim();
		var outputRqrd = thisForm.findField('outputRqrd').getValue();
		var timeOut = thisForm.findField('timeOutTextbox').getValue();
		if(commandOpts == "-1"){
			Ext.Msg.show({
				title:alertTitle,
				msg: commandAlert,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}
		if(commandOpts == "tracert"){
			if(aruguments!=null && aruguments.length ==0){
				Ext.Msg.show({
					title:alertTitle,
					msg:validIPTitle,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn:function(i){
						Ext.getCmp("arugumentsTextBox").focus(true);
					}
				});
				return;
			}
		}
		if(commandOpts == "dir"){
			if(aruguments != null && aruguments.length == 0){
				Ext.Msg.show({
					title:alertTitle,
					msg: validfilePathTitle,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn:function(i){
						Ext.getCmp("arugumentsTextBox").focus(true);
					}
				});
				return;
			}
		}
		if(commandOpts == "net start" || commandOpts == "net stop" ){
			if(aruguments != null && aruguments.length == 0){
				Ext.Msg.show({
					title:alertTitle,
					msg:serviceNameTitle,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn:function(i){
						Ext.getCmp("arugumentsTextBox").focus(true);
					}
				});
				return;
			}
		}
		if(commandOpts=='Other') // this is for other option
		{
			commandOpts = cmdSyntax;
			if(cmdSyntax != null && cmdSyntax != undefined && cmdSyntax.trim() == "")
			{
				Ext.Msg.show({
					title:alertTitle,
					msg: enterCommandAlert,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn:function(i){
						Ext.getCmp("cmdSyntax").focus(true);
					}
				});
				return;
			}
		}
		else
		{
			if(aruguments!=null && (aruguments!="none" && aruguments!=""))
				commandOpts = commandOpts+ " "+aruguments;
		}
		if(!checkNumberVal("+",timeOut) || timeOut.indexOf(".")>-1)
		{
			Ext.Msg.show({
				title:alertTitle,
				msg: timeoutInpAlert,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'	
			});
			return false;
		}
		else
		{
			var winHeight = Ext.getCmp('remote_control').getHeight();
			var cmdHeight = winHeight - Ext.getCmp('remotecontrolform').getHeight()-40;
			var remoteCmd = Ext.getCmp('remote_cmd');
			remoteCmd.removeAll();
			var commandOpts1 = commandOpts.replace(/\r\n|\r|\n/g,'#');
			var hiddenQStr = publicJson['hiddenQStr'];
			var paramsForReq = "isJsonResp=true&response1=yes&&agentIP="+encodeURIComponent(agentIP)+"&hostName="+encodeURIComponent(hostName)
			+"&selCmd="+encodeURIComponent(commandOpts)+"&txtCmd1="+encodeURIComponent(commandOpts)
			+"&displayTxtCmd="+encodeURIComponent(displayTxtCmd)
			+"&arguments="+encodeURIComponent(aruguments)+"&txtCmd="+encodeURIComponent(commandOpts1)+"&response="+outputRqrd+"&txtTimeout="+timeOut+hiddenQStr;
			var timeOutValForAjax = (parseInt(timeOut)*1000)+10000;
			//rcLoadMask.show();
			if(commandOpts1=="RC_42" || commandOpts1=="RC_43"){
				  var sessionID = Ext.getCmp('user_session_id').getValue();
				  paramsForReq=paramsForReq +"user_session_id="+sessionID;
			}
			Ext.getCmp('execute').setDisabled(true);
			if(commandOpts1 == "compmgmt" || commandOpts1 == "mstsc"){
				var servUser = thisForm.findField('serv_user').getValue().trim();
				if(commandOpts1 == "compmgmt" && Ext.isEmpty(servUser)){
					Ext.getCmp('execute').setDisabled(false);
					var msg = Ext.MessageBox.show({
						title : RCATitle,
						width:300,
						msg : '<div style="min-height:35px;">'+userNameTitle+', <br>'+validUserNameTitle+'.</div>',
						modal:true,
						maskCls :'windowModal',
						buttons : Ext.MessageBox.OK,
						icon : Ext.MessageBox.WARNING
					});
					Ext.WindowManager.bringToFront(msg);
				}
				else{
					Ext.Ajax.request({
						url : '/final/monitor/RemoteControlActionUtils.jsp?cmd='+commandOpts1+"&agentIP="+agentIP+"&username="+encodeURIComponent(servUser),
						method : 'POST',
						timeout:timeOutValForAjax,
						scope:this,
						success: function(response)
						{
							Ext.getCmp('execute').setDisabled(false);
							rcLoadMask.hide();
							var displayMsg;
							if(commandOpts1 == "compmgmt"){
								if(outputRqrd == "Yes" || outputRqrd == "yes"){
									displayMsg = computerManagementTitle+". <br>"+downloadTitle+"."+batfileTitle+".."
								}
								else{
									displayMsg = remoteControlSuccessTitle;
								}
								window.location.href= "../images/RemoteControl/compmgmt_"+agentIP+".bat";
							}else {
								if(outputRqrd == "Yes" || outputRqrd == "yes"){
									displayMsg = RDPInitiateTitle+". "+downTitle+" ."+rdpTitle+"..";
								}
								else{
									displayMsg = remoteControlSuccessTitle;
								}
								var filePath ="../images/RemoteControl/"+agentIP+".rdp";
								var fileName = agentIP + ".rdp";
								
								this.downloadRCAFile(fileName);
								
							}
							Ext.getCmp('execute').setDisabled(false);
							rcLoadMask.hide();
							var updatepanel=Ext.getCmp('remote_cmd');
							var output="<ul align='center' style='margin:10px; width:95%; height:93%; display:table;' class='f14-normal'><div style='text-align:center; vertical-align:middle;display:table-cell;'><div><img src='"+imgPath+"/success_msg_icon.png'></div>";
							output = output +"<div style='margin-top:15px;'><span style='color:"+fontColorCode+";'><li>"+displayMsg+"<\/li></span></div></div></ul>";
							
							var updatepanelTitle = commandTitle+" - "+commandOpts1;

							if(commandOpts1 == 'RC_24'){
								updatepanelTitle = outputTitle;//or Result
							}
							updatepanel.add({
								xtype: 'panel',
								margin:'0 10 10 10',
								title:updatepanelTitle,
								bodyStyle:{'overflowY':'auto','box-shadow':'none'},
								border:true,
								bodyCls:'configWinBody',
								header:{
									style:{'border':'0px','background':'transparent !important','padding-left':'0px'},
								},
								height:cmdHeight+10,
								id:'updatepanel',
								html:output
							});
							updatepanel.doLayout();
							remoteCmd.show();
						},
						failure:function()
						{
							Ext.getCmp('execute').setDisabled(false);
							rcLoadMask.hide();
							var updatepanel=Ext.getCmp('remote_cmd');
							var output="<ul align='center' class='f11-normal' style='margin:10px; width:95%; height:93%; display:table;'><div style='text-align:center; vertical-align:middle;display:table-cell;'><div><img src='"+imgPath+"/error_msg_icon.png'></div>";
							output = output +"<div style='margin-top:15px;'><span style='color:"+fontColorCode+";'><li>"+timedoutTitle+"<\/li></span></div></div></ul>";
							updatepanel.add({
								xtype: 'panel',
								margin:10,
								height:cmdHeight,
								cls:'formOuter',
								id:'updatepanel',
								html:output
							});
							updatepanel.doLayout();
							remoteCmd.show();
						}
					});
				}
			}
			else if(commandOpts1 == "ping" && Ext.isEmpty(aruguments)){
				Ext.getCmp('execute').setDisabled(false);
				var msg = Ext.MessageBox.show({
					title : RCATitle,
					width:300,
					msg : '<div>'+validIPTitle+'.</div>',
					modal:true,
					maskCls :'windowModal',
					buttons : Ext.MessageBox.OK,
					icon : Ext.MessageBox.WARNING,
					fn:function(i){
						Ext.getCmp("arugumentsTextBox").focus(true);
					}
				});
				Ext.WindowManager.bringToFront(msg);
			}
			else {
				if(commandOpts1.startsWith("shutdown")){
					var displayMsg = "";
					if(commandOpts1[commandOpts1.length-1]=='r'){
						displayMsg = rebootTitle+"..";
					}
					else if(commandOpts1[commandOpts1.length-1]=='s'){
						displayMsg = shutdownTitle+"..";
					}
					Ext.getCmp('execute').setDisabled(false);
					var updatepanel=Ext.getCmp('remote_cmd');
					var output="<ul align='center' style='margin:10px; width:95%; height:93%; display:table;' class='f14-normal'><div style='text-align:center; vertical-align:middle;display:table-cell;'><div><img src='"+imgPath+"/info_mgs_icon.png'></div>";
					output = output +"<div style='margin-top:15px;'>"+displayMsg+"</div></div></ul>";
					updatepanel.add({
						xtype: 'panel',
						margin:10,
						height:cmdHeight,
						cls:'formOuter',
						id:'updatepanel',
						html:output
					});
					updatepanel.doLayout();
					remoteCmd.show();
				}
				else {
					rcLoadMask.show();
				}
				Ext.Ajax.request({
					url : '/final/monitor/RemoteControlActionp.jsp',
					method : 'POST',
					params: paramsForReq,
					timeout:timeOutValForAjax,
					scope:this,
					success: function(response)
					{
						Ext.getCmp('execute').setDisabled(false);
						rcLoadMask.hide();
						var jsonText = response.responseText;	
						var jsonData=Ext.decode(jsonText);
						if(!Ext.isEmpty(jsonData))
						{
							var errorMessage = jsonData['errorMessage'];
							if(errorMessage!=null && errorMessage!="-")
							{
								//alert("error occured");
							}
							else if(!commandOpts1.startsWith("shutdown"))
							{
								var result = jsonData['output'];
								var updatepanel=Ext.getCmp('remote_cmd');
								var isGridView = jsonData['isGridView'];
								if(isGridView != 'undefined' && isGridView != undefined && isGridView == "true"){
									var fieldModel = new Array();
									var columns = new Array();
									var tableData = jsonData['gridJson'];
									var tableColumns = tableData['tableColumns'];
									var gridValues = tableData['gridValues'];
									var gridTitle = tableData['gridTitle'];
									var colIdx = 0;
									if (gridValues.length > 0) 
									{
										for (var key in tableColumns) {                    

											fieldModel.push({
												name: 'COLUMVal_' + colIdx,
												type: 'string'
											});
											columns.push({
												header: tableColumns[key],
												dataIndex: 'COLUMVal_' + colIdx,
												align: 'left',
												flex: 1,
												sortable: true,
												
											});
											colIdx++;
										}
										var ackStore = Ext.data.Store({
											fields: fieldModel,
											data: gridValues,
											proxy: {
												type: 'ajax',
												reader: {
													type: 'json'
												}
											}
										});	
										if(commandOpts1.indexOf("wmic os list")>-1){
    											updatepanel.add({
    												xtype: 'panel',
    												bodyStyle:'overflowY: auto',
    												margin:'5 10 0 10',
    												border:false,
    												cls:'formOuter',
    												height:30,
    												id:'updatepanel',
    												html:'<span class="f13-bold" style="margin: 5px 0 0px 10px;display: block;">'+WMITitle+'..</span>'
    											});
    											cmdHeight = cmdHeight - 30;
    											updatepanel.add({
    												xtype: 'grid',
    												store: ackStore,
    												margin:'0 10 5 10',
    												title:'<span class="f13-bold">'+gridTitle+'</span>',
    												cls: 'gridSkin',
    												height:cmdHeight+10,
    												bodyStyle:'overflowY: auto',
    												columns: columns,
    											});
										}
										else {
    											updatepanel.add({
    												xtype: 'grid',
    												store: ackStore,
    												margin:'5 10 5 10',
    												title:'<span class="f13-bold">'+gridTitle+'</span>',
    												cls: 'gridSkin',
    												height:cmdHeight+10,
    												bodyStyle:'overflowY: auto',
    												columns: columns,
    											});
    								}
									}
									else {
										updatepanel.add({
											xtype: 'panel',
											bodyStyle:'overflowY: auto',
											margin:10,
											border:false,
											cls:'formOuter',
											height:cmdHeight,
											id:'updatepanel',
											html:result
										});
									}
								}
								else {
									var updatepanelTitle1 = commandTitle+" - "+commandOpts1;

									if(commandOpts1 == 'RC_24'){
										updatepanelTitle1 = outputTitle;//or Result
									}
									updatepanel.add({
										xtype: 'panel',
										scroll:true,
										margin:'0 10 10 10',
										title:updatepanelTitle1,
										bodyStyle:{'overflowY':'auto','box-shadow':'none'},
										border:true,
										bodyCls:'configWinBody',
										header:{
											style:{'border':'0px','background':'transparent !important','padding-left':'0px'},
										},
										height:cmdHeight+10,
										id:'updatepanel',
										html:result
									});
								}
								updatepanel.doLayout();
								remoteCmd.show();
							}
						}
					},
					failure:function()
					{
						Ext.getCmp('execute').setDisabled(false);
						rcLoadMask.hide();
						var updatepanel=Ext.getCmp('remote_cmd');
						var output="<ul align='center' style='margin:10px; width:95%; height:93%; display:table;' class='f14-normal'><div style='text-align:center; vertical-align:middle;display:table-cell;'><div><img src='"+imgPath+"/error_msg_icon.png'></div>";
						output = output +"<div style='margin-top:15px;'>"+timedoutTitle+"</div></div></ul>";
						updatepanel.add({
							xtype: 'panel',
							margin:10,
							height:cmdHeight,
							cls:'formOuter',
							id:'updatepanel',
							html:output
						});
						updatepanel.doLayout();
						remoteCmd.show();
					}
				});
			}
		}
	},
	downloadRCAFile: function(fileName)
	{
		Ext.defer(function(){
					window.location.href= "../monitor/eg_scripts/RemoteControlAction/data/RCAFileDownload.jsp?fileName=" + encodeURIComponent(fileName);
		},500);
		
	},
	loadFormData: function () {
	    var thisForm = this.getRemotecontrolactionForm().getForm();
		var selected_user_name = Ext.getCmp('usernames').getValue();
		rcLoadMask.show();
		Ext.Ajax.request({
			url : '/final/monitor/RemoteControlActionUserInfo.jsp?hostname='+hostName+'&comptype='+init_comp_type+'&layername='+init_layer_name+'&test='+init_test_name+'&selected_user_name='+encodeURIComponent(selected_user_name),
			method : 'POST',
			scope:this,
			timeout:60000,
			success: function(response)
			{
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
			
				var userSessionOpts = thisForm.findField('user_session_id');
				userSessionOpts.getStore().loadRawData(jsonData['sessionIdsOpts']);
				var start_sid = jsonData['pageParams']['selectedSessionId'];
				userSessionOpts.setValue('-1');
				if(start_sid=='-1') {
					Ext.getCmp('user_session_id').hide();
				}
				else {
					Ext.getCmp('user_session_id').show();
				}
				singleSessionId=jsonData['pageParams']['singleSessionId'];
				var userProcessOpts = thisForm.findField('user_process_name');
				userProcessOpts.getStore().loadRawData(jsonData['processOpts']);
				var start_process = jsonData['pageParams']['selectedProcess'];
				userProcessOpts.setValue('-1');
				if(start_process=='-1') {
					Ext.getCmp('user_process_name').hide();
				}
				else {
					Ext.getCmp('user_process_name').show();
				}
				var msgBox = thisForm.findField('msg_box');
				msgBox.setValue(jsonData['pageParams']['arguments']);

				var lononModesOpts = thisForm.findField('logonModes');
				lononModesOpts.getStore().loadRawData(jsonData['logonModesOpts']);
				var start_logonMode = jsonData['pageParams']['selectedLogonMode'];
				lononModesOpts.setValue(start_logonMode);
				if(start_logonMode=='-1') {
					Ext.getCmp('logonModes').hide();
				}
				else {
					Ext.getCmp('logonModes').show();
				}

				var deliveryGroupOpts = thisForm.findField('delivery_grp_name');
				deliveryGroupOpts.getStore().loadRawData(jsonData['deliveryGroupOpts']);
				var start_deliveryGrp = jsonData['pageParams']['selectedLogonMode'];
				deliveryGroupOpts.setValue(start_deliveryGrp);
				if(start_deliveryGrp=='-1') {
					Ext.getCmp('delivery_grp_name').hide();
				}
				else {
					Ext.getCmp('delivery_grp_name').show();
				}

				var machineNameOpts = thisForm.findField('machine_name');
				machineNameOpts.getStore().loadRawData(jsonData['machineNameOpts']);
				var start_machineName = jsonData['pageParams']['selectedLogonMode'];
				machineNameOpts.setValue(start_machineName);
				if(start_machineName=='-1') {
					Ext.getCmp('machine_name').hide();
				}
				else {
					Ext.getCmp('machine_name').show();
				}

				var adUserNameOpts = thisForm.findField('ad_username');
				adUserNameOpts.getStore().removeAll();
				adUserNameOpts.getStore().loadRawData(jsonData['adUsernamesOpts']);
				adUserNameOpts.setValue('-1');
				Ext.getCmp('ad_username').hide();
				if(selected_user_name != -1){
					this.changeCommand();
				}
			},
			failure: function(response)
			{
				Ext.getCmp('execute').setVisible(false);
				rcLoadMask.hide();
				Ext.MessageBox.alert(actionTitle,failedetailsLbl);

				var thisForm = this.getRemotecontrolactionForm().getForm();
				var userSessionOpts = thisForm.findField('user_session_id');
				userSessionOpts.setValue("-1");

				var userProcessOpts = thisForm.findField('user_process_name');
				userProcessOpts.setValue("-1");
				Ext.getCmp('user_process_name').hide();
			}
		});        
    },
	loadActionData : function()
	{
		var task_name ; 
		var isCustomScript = false;
		var remoteCmd = Ext.getCmp('remote_cmd');
		if(remoteCmd!=null)
			remoteCmd.removeAll();
		var rmt_cmd = Ext.getCmp('rmt_cmds').getValue();
		var thisForm = this.getRemotecontrolactionForm().getForm();
		thisForm.findField('usernames').hide();
		thisForm.findField('ad_username').hide();
		thisForm.findField('ctx_user_machine_name').hide();
		thisForm.findField('license_username').hide();
		thisForm.findField('license_machinename').hide();
		thisForm.findField('fileupload').hide();
		thisForm.findField('custom_taskname').hide();
		thisForm.findField('outputRqrd').hide();
		thisForm.findField('timeOutTextbox').hide();
		thisForm.findField('outputRqrd').setValue("Yes");
		thisForm.findField('ad_password').hide();
		thisForm.findField('ad_confirm_password').hide();
		Ext.getCmp('upload').setVisible(false);
		Ext.getCmp('execute').setVisible(false);
		Ext.getCmp('arugumentsTextBox').setValue("");
		thisForm.findField('shadow_mode').hide();
		init_test_name =rmt_cmd;
		if(rmt_cmd.indexOf(":")>-1){
			task_name = rmt_cmd.substring(0,rmt_cmd.indexOf(":"));
			init_test_name = rmt_cmd.substring(rmt_cmd.indexOf(":")+1);
		}
		else{
			isCustomScript = true;
		}
		if(rmt_cmd == "fileupload"){
			thisForm.findField('serv_user').hide();
			thisForm.findField('msg_box').hide();
			thisForm.findField('user_session_id').hide();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('delivery_grp_name').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_group_status').hide();
			thisForm.findField('cmdSyntax').hide();
			thisForm.findField('outputRqrd').show();
			//thisForm.findField('timeOutTextbox').setValue('300');
			thisForm.findField('timeOutTextbox').show();
			thisForm.findField('fileupload').show();
			thisForm.findField('fileupload').setRawValue('');
			var argumentsObj = Ext.getCmp('arugumentsTextBox');
			argumentsObj.hide();
			thisForm.findField('custom_taskname').show();
			thisForm.findField('custom_taskname').setValue('');
			var uploadObj = Ext.getCmp('upload');
			uploadObj.setVisible(true);
			if(!uploadObj.isDisabled()){
				uploadObj.setDisabled(true);
			}
		}
		else if(init_test_name == "OS"|| init_test_name == "Other"){
			thisForm.findField('serv_user').hide();
			thisForm.findField('msg_box').hide();
			thisForm.findField('user_session_id').hide();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('delivery_grp_name').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_group_status').hide();
			if(task_name=='Other')
			{
				thisForm.findField('cmdSyntax').show();
				thisForm.findField('cmdSyntax').setValue('');
				thisForm.findField('arugumentsTextBox').hide();
			}
			else
			{
				thisForm.findField('cmdSyntax').hide();
				if(task_name == 'RC_47' || task_name == 'RC_44' || rmt_cmd.startsWith("FILE#")){
					thisForm.findField('arugumentsTextBox').hide();
				} else {
					thisForm.findField('arugumentsTextBox').show();
				}
			}
			thisForm.findField('outputRqrd').show();
			thisForm.findField('timeOutTextbox').show();
			if(task_name == "mstsc" || task_name == "compmgmt"){
				thisForm.findField('serv_user').setValue("");
				thisForm.findField('serv_user').show();
				thisForm.findField('arugumentsTextBox').hide();
			}
			else {
				var argumentsTextBox = thisForm.findField('arugumentsTextBox');
				var argument = publicJson['arguments'][task_name];
				var argument_Label = publicJson['arguments'][task_name+"_LABEL"];
				argumentsTextBox.emptyText = argument;
				argumentsTextBox.setFieldLabel(argumentsLbl);
				if(argument_Label != undefined ){
					argumentsTextBox.setFieldLabel(argument_Label);
				}
				argumentsTextBox.applyEmptyText();
			}
			Ext.getCmp('execute').setVisible(true);
		}
		else {
			thisForm.findField('serv_user').hide();
			thisForm.findField('cmdSyntax').hide();
			thisForm.findField('arugumentsTextBox').hide();
			thisForm.findField('msg_box').hide();
			thisForm.findField('user_session_id').hide();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('delivery_grp_name').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_group_status').hide();

			thisForm.findField('user_session_id').setValue(singleSessionId);
			thisForm.findField('user_process_name').setValue('-1');
			thisForm.findField('msg_box').setValue('none');
			thisForm.findField('logonModes').setValue('-1');
			if(isCustomScript){
				thisForm.findField('outputRqrd').show();
				thisForm.findField('timeOutTextbox').show();
				var argumentsObj = Ext.getCmp('arugumentsTextBox');
				argumentsObj.show();
				argumentsObj.emptyText = "none";
				argumentsObj.applyEmptyText();
				Ext.getCmp('execute').setVisible(true);
				Ext.getCmp('execute').setDisabled(false);
			}
			else {
				if(task_name=='RC_15' || task_name=='RC_36' || task_name=='RC_37' || task_name == 'RC_49' || task_name == 'RC_51' || task_name == 'RC_52' || task_name == 'RC_53' ){
					thisForm.findField('usernames').hide();
					thisForm.findField('outputRqrd').show();
					thisForm.findField('timeOutTextbox').show();
					Ext.getCmp('execute').setVisible(true);
				} else if(task_name=='RC_29'){
					
					var argumentsTextBox = thisForm.findField('arugumentsTextBox');
					argumentsTextBox.setFieldLabel(ad_username_label);
					argumentsTextBox.emptyText = "Enter username";
					argumentsTextBox.applyEmptyText();
					thisForm.findField('arugumentsTextBox').show();
					thisForm.findField('usernames').hide();
					thisForm.findField('outputRqrd').show();
					thisForm.findField('timeOutTextbox').show();
					Ext.getCmp('execute').setVisible(true);
				}
				else {
					rcLoadMask.show();
					thisForm.findField('outputRqrd').hide();
					thisForm.findField('timeOutTextbox').hide();
					Ext.getCmp('execute').setVisible(false);
					Ext.Ajax.request({
						url : '/final/monitor/RemoteControlActionSessionJson.jsp?comptype='+init_comp_type+'&layername='+init_layer_name+'&test='+init_test_name+'&task_name='+task_name+'&port='+init_port,
						method : 'POST',
						scope:this,
						timeout:60000,
						success: function(response)
						{
							if(init_test_name=='ChangeLoginTest' || init_test_name=='CtxXcXDSiteTest' || init_test_name=='CtxXcXDSiteSiteTest' || init_test_name=='CtxXcXDCGroupTest' || init_test_name=='CtxXcXDCBrMachTest' || init_test_name=='ADUserLockOutTest'  || init_test_name=='CitrixLicenseTest'  || init_test_name=='ADUsersTest' || init_test_name == 'CtxXcXDDesktopsTest')
							{
								this.loadFormData();
							}
							else
							{
								rcLoadMask.hide();
								thisForm.findField('usernames').show();
								var jsonData=Ext.decode(response.responseText);
								var usernamesOpts = thisForm.findField('usernames');
								usernamesOpts.getStore().removeAll();
								usernamesOpts.getStore().loadRawData(jsonData['usernamesOpts']);
								usernamesOpts.setValue("-1");
								var winHeight = Ext.getCmp('remote_control').getHeight();
								var cmdHeight = winHeight - Ext.getCmp('remotecontrolform').getHeight()-40;
								var usernames=jsonData['usernamesOpts'];
								if(usernames.length == 1){
									thisForm.findField('usernames').hide();
									var height=Ext.getCmp('remote_control').getHeight();
									var updatepanel=Ext.getCmp('remote_cmd');
									updatepanel.removeAll();
									var output="<ul align='center' class='f11-normal' style='margin:10px; width:100%; height:100%; display:table;'><div style='text-align:center; vertical-align:middle;display:table-cell;'><div><img src='"+imgPath+"/info_mgs_icon.png'></div>";
									output = output +"<div style='margin-top:15px;'><span style='color:"+fontColorCode+";'><li>No Users found!<\/li></span></div></div></ul>";
									updatepanel.add({
										xtype: 'panel',
										margin:10,
										cls:'formOuter',
										height:cmdHeight,
										border:false,
										html:output
									});
									updatepanel.doLayout();
									updatepanel.show();
								}
							}
							
						},
						failure: function(response)
						{
							rcLoadMask.hide();
							alert("failure...");
						}
					});
				}
			}
		}
		
	},
	loadSessionFormData : function()
	{
		var remoteCmd = Ext.getCmp('remote_cmd');
		if(remoteCmd!=null)
			remoteCmd.removeAll();
		this.loadFormData();
	},
	changelogonModes: function()
	{
		var remoteCmd = Ext.getCmp('remote_cmd');
		if(remoteCmd!=null)
			remoteCmd.removeAll();
		var logonModesValue = Ext.getCmp('logonModes').getValue();
		if(logonModesValue == '-1')
		{
			var thisForm = this.getRemotecontrolactionForm().getForm();
			thisForm.findField('msg_box').hide();
			thisForm.findField('user_session_id').hide();
			thisForm.findField('user_process_name').hide();
			Ext.getCmp('execute').setVisible(false);
		}
		else
		{
			Ext.getCmp('execute').setVisible(true);
		}
	},
	changeSessionId: function()
	{		
		var remoteCmd = Ext.getCmp('remote_cmd');
		if(remoteCmd!=null)
			remoteCmd.removeAll();
		Ext.getCmp('execute').setVisible(true);
		var thisForm = this.getRemotecontrolactionForm().getForm();
		var rmt_cmd = Ext.getCmp('rmt_cmds').getValue();
		rmt_cmd = rmt_cmd.substring(0,rmt_cmd.indexOf(":"));
		var s_session_id = Ext.getCmp('user_session_id').getValue();
		if(rmt_cmd == '-1')
		{
			thisForm.findField('msg_box').hide();
			thisForm.findField('user_session_id').hide();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('logonModes').hide();
			Ext.getCmp('execute').setVisible(false);
		}
		else if(s_session_id == '-1')
		{
			thisForm.findField('msg_box').hide();
			thisForm.findField('user_session_id').show();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('logonModes').hide();
			Ext.getCmp('execute').setVisible(false);
		}
		else if(rmt_cmd=='RC_0' || rmt_cmd=='RC_2' || rmt_cmd=='RC_54' || rmt_cmd=='RC_3' || rmt_cmd=='RC_4' || rmt_cmd=='RC_17' || rmt_cmd=='RC_18')
		{
			thisForm.findField('msg_box').hide();
			thisForm.findField('user_session_id').show();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('logonModes').hide();
		}
		else if(rmt_cmd=='RC_5')
		{
			thisForm.findField('msg_box').show();
			thisForm.findField('user_session_id').show();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('logonModes').hide();
		}
		else if(rmt_cmd=='RC_6')
		{
			Ext.getCmp('execute').setVisible(false);
			this.getRemotecontrolactionForm().loadSessionData();
		}		
		else if(rmt_cmd=='RC_8')
		{
			//display services hosted in process
			Ext.getCmp('execute').setVisible(false);
			this.getRemotecontrolactionForm().loadSessionData();
		}
		else if(rmt_cmd=='RC_9')
		{
			Ext.getCmp('execute').setVisible(false);
			this.getRemotecontrolactionForm().loadSessionData();
		}
		else if(rmt_cmd=='RC_14')
		{
			// Changes the XenApp Logon Mode for the selected server
			thisForm.findField('msg_box').hide();
			thisForm.findField('user_session_id').hide();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('logonModes').hide();

			thisForm.findField('user_session_id').setValue(singleSessionId);
			thisForm.findField('user_process_name').setValue('-1');
			thisForm.findField('msg_box').setValue('none');
			thisForm.findField('logonModes').setValue('-1');
			Ext.getCmp('execute').setVisible(true);
		}
		else
		{
			thisForm.findField('msg_box').hide();
			thisForm.findField('user_session_id').show();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('logonModes').hide();
		}
	},
	changeProcessName: function() 
	{	
		var remoteCmd = Ext.getCmp('remote_cmd');
		if(remoteCmd!=null)
			remoteCmd.removeAll();
		var thisForm = this.getRemotecontrolactionForm().getForm();
		thisForm.findField('outputRqrd').show();
			thisForm.findField('timeOutTextbox').show();
		if(Ext.getCmp('user_process_name').getValue() == '-1') {
			Ext.getCmp('execute').setVisible(false);
		}
		else {
			Ext.getCmp('execute').setVisible(true);
		}
	},
	changeLicenseUsername: function()
	{		
		var remoteCmd = Ext.getCmp('remote_cmd');
		if(remoteCmd!=null)
			remoteCmd.removeAll();
		if(Ext.getCmp('license_username').getValue() == '-1') {
			Ext.getCmp('execute').setVisible(false);
		}
		else {
			Ext.getCmp('outputRqrd').show();
			Ext.getCmp('timeOutTextbox').show();
			Ext.getCmp('execute').setVisible(true);
		}
	},
	changeLicenseMachinename: function()
	{	
		var remoteCmd = Ext.getCmp('remote_cmd');
		if(remoteCmd!=null)
			remoteCmd.removeAll();
		if(Ext.getCmp('license_machinename').getValue() == '-1') {
			Ext.getCmp('execute').setVisible(false);
		}
		else {
			Ext.getCmp('outputRqrd').show();
			Ext.getCmp('timeOutTextbox').show();
			Ext.getCmp('execute').setVisible(true);
		}
	},
	changeADUsername: function()
	{
		var thisForm = this.getRemotecontrolactionForm().getForm();
		var remoteCmd = Ext.getCmp('remote_cmd');
		if(remoteCmd!=null)
			remoteCmd.removeAll();
		var rmt_cmd = Ext.getCmp('rmt_cmds').getValue();
		rmt_cmd = rmt_cmd.substring(0,rmt_cmd.indexOf(":"));
	
		Ext.getCmp('ad_password').hide();
		Ext.getCmp('ad_confirm_password').hide();
		if(Ext.getCmp('ad_username').getValue() == '-1') {
			Ext.getCmp('execute').setVisible(false);
		}
		else
		{
			if(rmt_cmd=='RC_30')
			{
				Ext.getCmp('ad_password').show();
				Ext.getCmp('ad_confirm_password').show();
			}
			thisForm.findField('outputRqrd').show();
			thisForm.findField('timeOutTextbox').show();
			Ext.getCmp('execute').setVisible(true);
		}
	}
});
function checkspace(field)
{
	var s_val;
	if(typeof(field)=='object')
	{
		s_val = field.value;
	}
	else
	{
		s_val = field;
	}
	for(count = 0; count < s_val.length; count++)
	{
		if(s_val.charAt(count) == ' ')
		{
			//alert(_checkblank);
			return false;
		}
	}
	return true;
}
function checkspecialChar(field,s_spl)
{
	if(typeof(field)=='object')
	{
		obj_val = field.value;
	}
	else
	{
		obj_val = field;
	}
	for(var i=0; i<obj_val.length; i++)
	{
		check_char = s_spl.indexOf(obj_val.charAt(i))
		//Returns value 1 if the special character listed in splChar is found
		if(check_char >= 0)
		{
			return false;
		}
	}
	return true;
}