Ext.define('RumAppMenuModel', {
    extend: 'Ext.data.Model',
    fields: [{
        name: 'name'
    }, {
        name: 'caption'
    }, {
        name: 'captionl'
    }, {
        name: 'children'
    }, {
        name: 'menu_iconCls'
    }, {
        name: 'id'
    }, {
        name: 'isParent'
    }]
});

Ext.create('Ext.data.Store', {
    id: 'rumappmenu_model_id',
    model: 'RumAppMenuModel',
    autoLoad: true,
    data: dashInfo.tabArray
});

var rumappflowMenuTpl = new Ext.XTemplate(
    '<div class="sidebarmenu">',
    '<ul>',
    '<tpl for=".">',
    '<li class="x-item <tpl if="children"><tpl if="id != \'seeMore\'">has-sub</tpl> submenuitems</tpl>" id={id}>',
    '<a href="javascript:void(0)" id="{id}-link"><img id="{id}-images"  style="vertical-align:middle;" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="{menu_iconCls}" /><span>{captionl}</span></a>',
    '<tpl if="children">',
    '<ul class="<tpl if="id == \'seeMore\'">seeMoreMenu </tpl>submenu">',
    '<tpl for="children">',
    '<li  class="x-item x-item-child" index={#} id={id}>',
    '<a href="javascript:void(0)" id="{id}-link"><img id="{id}-images" style="vertical-align:middle;" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="{menu_iconCls}" /> <span>{captionl}</span></a>',
    '</li>',
    '</tpl>',
    '</ul>',
    '</tpl>',
    '</li>',
    '</tpl>',
    '</ul>',
    '</div>'
);

Ext.define('RumAppFlow.view.AppFlowMenu', {
    extend: 'Ext.view.View',
    ui: 'sidebar',
    alias: 'widget.appflowmenu',
    id: 'rumappmenu_view_id',
    store: Ext.data.StoreManager.lookup('rumappmenu_model_id'),
    tpl: rumappflowMenuTpl,
    trackOver: false,
    multiSelect: true,
    scroll: true,
    autoScroll: true,
    //overItemCls:'eg-menu-view-over',
    //itemSelector: 'li.menu-wrap',
    itemSelector: '.x-item',
    emptyText: '',
    listeners: {
        itemclick: function(menu, record, item, index, event, eOpts) {
            var selectedRecord = record.data,
                subMenuIndex = "";
            selected = menu.getSelectionModel().getSelection(),
                me = this,
                selectedRecord = record.data,
                visibleSubmenu = $('li ul.submenu:visible'),
                submenu = $(item).find('ul.submenu'),
                seeMoreID = $('li.x-item-selected #seeMore-link').is(":visible");
            thatSubMenu = $("" + me.itemSelector + ".x-item-selected").find('.submenu');

            if (!Ext.isEmpty(record.get('children'))) {
                //submenu child event
                var childrenIndex = Ext.fly(item).getAttribute('index'),
                    subMenuItems = record.get('children');

                if (!Ext.isEmpty(subMenuItems[childrenIndex - 1])) {
                    selectedRecord = subMenuItems[childrenIndex - 1];
                    subMenuIndex = childrenIndex - 1;

                    var thisSubMenu = $(item).parent().closest("li" + me.itemSelector + ".x-item-selected").find('.submenu').is(":visible");

                    var moreLinkVisible = $("li" + me.itemSelector + "").find('#seeMore-link').is(":visible");
                    $(this).siblings().find("ul").hide();
                    //close other submenu 
                    if (!thisSubMenu) {
                        thatSubMenu.slideUp({
                            easing: 'swing'
                        });
                        //remove the arrow selected
                        $("" + me.itemSelector + ".x-item-selected").removeClass('x-selected');
                    } else {
                        //    
                    }
                    //load the view Fn
                    requestParams.selectedTab = selectedRecord.id;
                    setSession(requestParams.selectedTab);
                    var me = this,
                        innerCard = RumAppFlow.app.getController('Main').getMain().getComponent('appflow_ground').getComponent('cardID');

                    if (!Ext.isEmpty(innerCard)) {
                        innerCard.stopAnimation();
                        innerCard.animate({
                            duration: 500,
                            to: {
                                'opacity': 0
                            },
                            listeners: {
                                afteranimate: function() {
                                    RumAppFlow.app.getController('Main').addPage(selectedRecord.caption);
                                }
                            },
                            scope: RumAppFlow.app.getController('Main').getMain()
                        });
                    }
                } else {
                    //Parent item event
                    //if menu is open 
                    $(item).addClass('currentSel').siblings().removeClass('currentSel');
                    if (!submenu.is(":visible")) {
                        var moreLinkVisible = $(this.getNode(record)).find('#seeMore-link').is(":visible");
                        if (moreLinkVisible) {
                            $("li" + me.itemSelector + "").find('#seeMore-link').hide();

                        } else {
                            $("li" + me.itemSelector + "").find('#seeMore-link').show();

                        }
                        if (submenu.length >= 1) {
                            event.preventDefault();
                            submenu.slideToggle('fast', function() {
                                //to roll the submenu arrow
                                $(item).addClass('x-selected');
                            });
                        }
                        return false;
                    } else
                        return false;
                }

            } else {
                //Parent without children  event
                selectedRecord = record.data;
                if (visibleSubmenu.length >= 1) {
                    event.preventDefault();

                    if (!$('#seeMore-link').is(':empty'))
                        $("" + me.itemSelector + "").find('#seeMore-link').show();

                    if ($("" + me.itemSelector + "").hasClass('x-selected'))
                        $("" + me.itemSelector + "").removeClass('x-selected');

                    visibleSubmenu.slideUp({
                        speed: 'fast',
                        easing: 'swing'
                    });

                }
                //load the view Fn
                requestParams.selectedTab = selectedRecord.id;
                setSession(requestParams.selectedTab);
                var innerCard = RumAppFlow.app.getController('Main').getMain().getComponent('appflow_ground').getComponent('cardID');
                if (!Ext.isEmpty(innerCard)) {
                    innerCard.stopAnimation();
                    innerCard.animate({
                        duration: 500,
                        to: {
                            'opacity': 0
                        },
                        listeners: {
                            afteranimate: function() {
                                RumAppFlow.app.getController('Main').addPage(selectedRecord.caption);
                            }
                        },
                        scope: RumAppFlow.app.getController('Main').getMain()
                    });
                }
            }
        },
        viewready: function(view) {
            //for POC
            var allRecords = view.store.snapshot || view.store.data;
            var dupData = dashInfo.tabArray;
            //Highlight menu onload
            var index = null;
            var subIndex = null;
            for (var r = 0; r < dupData.length; r++) {
                if (Ext.isEmpty(dupData[r].children)) {
                    if (requestParams.activeView == dupData[r].id) {
                        index = r;
                    }
                } else {
                    var childrenArray = dupData[r].children;
                    for (var y = 0; y < childrenArray.length; y++) {
                        if (requestParams.activeView == childrenArray[y].id) {
                            subIndex = y;
                            index = r;
                        }
                    }
                }
            }

            view.onLoadSelectItem(index, allRecords.items[index], subIndex)
            view.toggleMenu();
            RumAppFlow.app.getController('Main').addPage(requestParams.activeView);
            RumAppFlow.app.getController('Main').getMain().setTitle(dashInfo.dash_title);
            var isBackFromRUM = false;
            if (backParams.isBackFromRUM != undefined && backParams.isBackFromRUM != null && backParams.isBackFromRUM == "true")
                isBackFromRUM = true;
            try {
                if (!isBackFromRUM) {
                    RumAppFlow.app.getController('Main').getMain().addTool({
                        xtype: 'combo',
                        cls: 'dropdown',
                        fieldLabel: 'Services',
                        cls: 'dropdown',
                        labelSeparator: '',
                        width: 300,
                        labelWidth: 55,
                        editable: false,
                        hidden: false,
                        labelStyle: {
                            'white-space': 'nowrap;'
                        },
                        name: 'componentsDropDown',
                        itemId: 'componentsDropDown',
                        id: 'componentsDropDown',
                        labelAlign: 'left',
                        displayField: 'name',
                        valueField: 'value',
                        queryMode: 'local',
                        store: Ext.create('Ext.data.Store', {
                            data: rumPageParams.serviceCombo[0].value,
                            fields: ['state', 'name', 'value', 'hasRUMComp', 'comp_type_rum']
                        }),
                        value: rumPageParams.serviceCombo[0].selected,
                        margin: '2 10 0 10',
                        listeners: {
                            'render': function() {
                                //alert("rumPageParams.serviceCombo=-=-=->",rumPageParams.serviceCombo)
                                $('#componentsDropDown-inputEl').addClass('state_' + rumPageParams.serviceCombo[0].selectedState);
                            },
                            'select': function(combobox) {
                                var selected_dash_ser = combobox.getValue();
                                var hasRUMComp = combobox.findRecordByValue(selected_dash_ser).get('hasRUMComp');
                                if (hasRUMComp == "true") {
                                    var comp_type_rum = combobox.findRecordByValue(selected_dash_ser).get('comp_type_rum');
                                    var rum_url = "/final/monitor/rumAppFlow.jsp?iniName=eg_rumdashboard&userBased=true&fromMenu=true&showConfig=true&dashboard_name=RUM_Dashboard&appliesTo=" + comp_type_rum + "&isBackFromRUM=false&filter=Service&filterBy=" + selected_dash_ser;
                                    goToCitrixDashboard(rum_url);
                                } else {
                                    var ctxUrl = "/final/monitor/citrixDashboard.jsp?&userBased=true&fromMenu=true&showConfig=true&iniName=eg_citrixdashboard&dashboard_name=Citrix_Dashboard&filter=Service&filterBy=" + selected_dash_ser + "&fromServiceHomePage=true&fromSerComboChange=true";
                                    goToCitrixDashboard(ctxUrl);
                                }
                            }
                        },
                        tpl: Ext.create('Ext.XTemplate',
                            '<ul style="white-space:nowrap">',
                            '<tpl for=".">',
                            '<li class="x-boundlist-item"><img src="/final/images/spacer.gif" style="padding-left:18px;vertical-align:middle" class="state_{state}"/>{name}</li>',
                            '</tpl>',
                            '</ul>'
                        )
                    });
                }

                if (rumPageParams.serviceCombo[0].rumcomboNeeded) {
                    RumAppFlow.app.getController('Main').getMain().addTool({
                        xtype: 'combo',
                        cls: 'dropdown',
                        fieldLabel: 'Components',
                        cls: 'dropdown',
                        labelSeparator: '',
                        margin: '2 10 0 10',
                        labelWidth: 75,
                        width: 300,
                        editable: false,
                        hidden: false,
                        labelStyle: {
                            'white-space': 'nowrap;'
                        },
                        labelAlign: 'left',
                        displayField: 'name',
                        valueField: 'value',
                        queryMode: 'local',
                        name: 'componentsDropDown',
                        itemId: 'componentsDropDown1',
                        id: 'componentsDropDown1',
                        store: Ext.create('Ext.data.Store', {
                            data: rumPageParams.serviceCombo[0].rumArray,
                            fields: ['name', 'value']
                        }),
                        value: rumPageParams.serviceCombo[0].selectedRum,
                        listeners: {
                            'select': function(combobox) {
                                var selected_dash_ser = Ext.getCmp('componentsDropDown').getValue();
                                var comp_type_rum = combobox.getValue();
                                var rum_url = "/final/monitor/rumAppFlow.jsp?iniName=eg_rumdashboard&userBased=true&fromMenu=true&showConfig=true&dashboard_name=RUM_Dashboard&appliesTo=" + comp_type_rum + "&isBackFromRUM=false&filter=Service&filterBy=" + selected_dash_ser;
                                goToCitrixDashboard(rum_url);
                            }
                        }
                    });
                }
            } catch (ey) {}

            RumAppFlow.app.getController('Main').getMain().addTool({
                xtype: 'button',
                id: 'backButton',
                margin: 0,
                padding: 0,
                cls: 'backbutton',
                iconCls: 'iconBack',
                text: 'Back'
            });
        }
    },
    toggleMenu: function() {
        var me = this;
        $("#" + this.id).hover(
            //open
            function() {
                $(this).addClass('sidebarmenu-open');
                if ($("" + me.itemSelector + "").hasClass('x-item-selected')) {
                    // $(""+me.itemSelector+".x-item-selected").find('.submenu').show();
                    $("" + me.itemSelector + ".x-item-selected").find('.submenu').slideToggle('fast', function() {
                        //callback
                    });

                    if (!$('#seeMore-link').is(':empty')) {
                        $("" + me.itemSelector + ".x-item-selected").find('#seeMore-link').hide();
                    }
                }
                $(this).stop().animate({
                    width: 251,
                }, 300, 'linear', function() {
                    // callback

                });
            },
            //close
            function() {
                $(this).removeClass('sidebarmenu-open');
                //hide subMenu, if selected item has children 
                if ($("" + me.itemSelector + "").hasClass('x-item-selected')) {

                    $("" + me.itemSelector + "").find('.submenu').slideUp('fast', function() {
                        //callback
                    });
                }
                //Always show seeMore link in close state
                if (!$('#seeMore-link').is(':empty')) {
                    $('#seeMore-link').show();
                }
                //if submenu arrow is unselected submenuItem
                if ($("" + me.itemSelector + "").hasClass('x-selected')) {
                    $("" + me.itemSelector + "").removeClass('x-selected');
                }

                $(this).stop().animate({
                    width: 51
                }, 300, 'linear', function() {
                    // callback

                });
            }
        );
    },
    onItemSelect: function(record) {
        var node = this._selectedNode; //this.getNode(record);
        if (node) {
            Ext.fly(this.getNode(record)).addCls(this.selectedItemCls);
            Ext.fly(node).addCls(this.selectedItemCls);
        }
    },
    onLoadSelectItem: function(selectedIndex, record, submenuIndex) {
        var node = record;
        if (node) {
            this.getSelectionModel().select(selectedIndex);
            Ext.fly(this.getNode(record)).addCls(this.selectedItemCls);
            Ext.fly(node).addCls(this.selectedItemCls);
            if (!Ext.isEmpty(node.data.children)) {
                var subMenuItem = node.data.children[submenuIndex];
                Ext.get(subMenuItem.id).addCls(this.selectedItemCls);
            }

            //animation on load
            $(".x-item").css({
                'marginLeft': "300px"
            });
            $(".x-item").each(function(i) {
                $(this).delay(100 * i).animate({
                    marginLeft: "0"
                }, 500);
            });
        }

    },
    onItemDeselect: function(record) {
        var node = this._deselectedNode; //this.getNode(record);
        Ext.select('li.x-item.x-item-selected').removeCls(this.selectedItemCls);
        Ext.select('li.x-item').removeCls(this.overItemCls);
        if (node) {
            Ext.fly(this.getNode(record)).removeCls(this.selectedItemCls);
            Ext.fly(node).removeCls(this.selectedItemCls);
        }
    },
    processItemEvent: function(record, item, index, e) {
        if (e.type == "mousedown" && e.button == 0) {
            this._deselectedNode = this._selectedNode;
            this._selectedNode = item;
        }
    },
    updateIndexes: function(startIndex, endIndex) {
        var ns = this.all.elements,
            records = this.store.getRange(),
            i, j;

        startIndex = startIndex || 0;
        endIndex = endIndex || ((endIndex === 0) ? 0 : (ns.length - 1));
        for (i = startIndex, j = startIndex - 1; i <= endIndex; i++) {
            if (!Ext.fly(ns[i]).is('.x-item-child')) {
                j++;
            }
            ns[i].viewIndex = i;

            ns[i].viewRecordId = records[j].internalId;
            if (!ns[i].boundView) {
                ns[i].boundView = this.id;
            }
        }
    }
});