 Ext.define('RumAppFlow.view.ChartPanel', {
     extend: 'Ext.panel.Panel',
     alias: 'widget.chartpanel',
	//cls:'animation_box',
	 border: true,
     flex: 1,
     ui: 'eg-x-panel',
     margin: '0 1 1 0',
     bodyPadding: '0 20 20 20',
     height: 301,
     title: 'Response Time Breakup - Desktop',
	legendPosition: 'bottom', // top,left, bottom and right
    chartType: 'area', // pie,line,column,area -  chart type
     layout: {
         type: 'vbox',
         align: 'stretch'
     },
     config: {
         data: null
     },
	showMaxMin:false,
	data:[],
	historyData:[],
     constructor: function(config) {
         this.initConfig(config);
         this.callParent(arguments);
     },
	addChartHistory:function(){
		 var me = this,historyItems=[];		
		if(!Ext.isEmpty(me.historyData)){
			 for(var i=0;i<me.historyData.length;i++){
				if(i%2 == 0){
						margin = '0 30 0 0';
					}else{
						margin = '0 0 0 0';
					}
				 var items ={
					xtype:'container',
					margin:margin,
					flex:1,
					items:[
					 {
						xtype:'label',
						cls:'font_bold9 grayColor',
						text:me.historyData[i].chartHistory,
					},{
						xtype:'box',
						height:65,
						cls:"chartminmax",
						html:'<div style="padding-top:20px"><div style="width:50%;float:left;text-align:center"><div class="font_normal18">'+me.historyData[i].avg+'</div><div class="font_normal12" style="margin-top:3px;">avg</div></div><div style="width:50%;float:right;text-align:center"><div class="font_normal18">'+me.historyData[i].min+'</div><div class="font_normal12" style="margin-top:3px;">max</div></div></div>'
					}	
					]
				 };
				historyItems.push(items);
			 }
		}
		var historyContainer = {
			xtype:'container',
			height:90,
			layout:{
					type:'hbox',
					align:'stretch'
			},
			items:historyItems
		};
		return historyContainer;
	 },
     initComponent: function() {
         var me = this;
		me.mon(me, 'boxready', me.loadChart, me);
		if(me.showMaxMin){
			me.items =[
			me.addChartHistory(),
			{
				xtype:'container',
				cls:'chartholder',
				flex:1,
				layout:{
						type:'vbox',
						align:'stretch'
				},
				html:'chartTorender'
			}
			]
		}
        me.callParent(arguments);
		 me.mon(me, 'resize', me.resizePanel, me);
		 me.mon(me, 'removed', me.destroyChart, me);
     },
     updateChart: function(dataW) {
         var me = this;
		 try
		 {
			if(typeof(dataW.data) == "string"){
				if(!Ext.isEmpty(dataW.data) && dataW.data.toLowerCase().trim() == "no data found")
					$('#' + me.body.id).html('<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>No Data Found!</div></div></div>');
			}
			else if(!Ext.isEmpty(dataW.data) && !Ext.isEmpty(dataW.data.length) && dataW.data.length > 1)
			{
				var ddata = dataW.data;
				for(var t=0;t<ddata.length;t++){
					if(Ext.isEmpty(ddata[t].data) && ddata[t].data.length == 0)
						$('#' + me.body.id).html('<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>No Data Found!</div></div></div>');
					else
					{
						if(!Ext.isEmpty(dataW.yaxisop))
							$('#' + me.body.id).highcharts(me.chartConfig(dataW.data,dataW.chartType,dataW.xaxis,dataW.yaxis,dataW.yaxisop,dataW.isAllZero,dataW.fmts));				
						else
							$('#' + me.body.id).highcharts(me.chartConfig(dataW.data,dataW.chartType,dataW.xaxis,dataW.yaxis,null,dataW.isAllZero,dataW.fmts));

						break;
					}
				}
			}
			else
			{
				if(!Ext.isEmpty(dataW.yaxisop))
					$('#' + me.body.id).highcharts(me.chartConfig(dataW.data,dataW.chartType,dataW.xaxis,dataW.yaxis,dataW.yaxisop,dataW.isAllZero,dataW.fmts));				
				else
					$('#' + me.body.id).highcharts(me.chartConfig(dataW.data,dataW.chartType,dataW.xaxis,dataW.yaxis,null,dataW.isAllZero,dataW.fmts));				
			}			
		 }
		 catch (ert)
		 {
			if(!Ext.isEmpty(dataW.yaxisop))
				$('#' + me.body.id).highcharts(me.chartConfig(dataW.data,dataW.chartType,dataW.xaxis,dataW.yaxis,dataW.yaxisop,dataW.isAllZero,dataW.fmts));				
			else
				$('#' + me.body.id).highcharts(me.chartConfig(dataW.data,dataW.chartType,dataW.xaxis,dataW.yaxis,null,dataW.isAllZero,dataW.fmts));	
		 }
		
     },
	destroyChart:function(){
			 var me = this,chartObj = $('#' + me.body.id).highcharts();
			if(!Ext.isEmpty(chartObj)){
				chartObj.destroy();
			}
	 },
	resizePanel:function(){
		 var me = this,chartObj = $('#' + me.body.id).highcharts();
		 if(!Ext.isEmpty(chartObj)){
			chartObj.reflow();
		 }
	 },
     loadChart: function() {
         var me = this;
		 if(me.showMaxMin){

		 }else{
			 try
			 {
				if(typeof(me.data) == "string"){
					if(!Ext.isEmpty(me.data) && me.data.toLowerCase().trim() == "no data found")
						$('#' + me.body.id).html('<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>No Data Found!</div></div></div>');
				}
				else if(!Ext.isEmpty(me.data) && !Ext.isEmpty(me.data.length) && me.data.length > 1)
				{
					var ddata = me.data;
					for(var t=0;t<ddata.length;t++){
						if(Ext.isEmpty(ddata[t].data) && ddata[t].data.length == 0)
							$('#' + me.body.id).html('<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>No Data Found!</div></div></div>');
						else
						{
							if(!Ext.isEmpty(me.yaxisop))
								$('#' + me.body.id).highcharts(me.chartConfig(me.data,me.chartType,me.xaxis,me.yaxis,me.yaxisop,me.isAllZero,me.fmts));	
							else
								$('#' + me.body.id).highcharts(me.chartConfig(me.data,me.chartType,me.xaxis,me.yaxis,null,me.isAllZero,me.fmts));

							break;
						}
					}
				}
				else
				{
					if(!Ext.isEmpty(me.yaxisop))
						$('#' + me.body.id).highcharts(me.chartConfig(me.data,me.chartType,me.xaxis,me.yaxis,me.yaxisop,me.isAllZero,me.fmts));				
					else
						$('#' + me.body.id).highcharts(me.chartConfig(me.data,me.chartType,me.xaxis,me.yaxis,null,me.isAllZero,me.fmts));				
				}
			 }
			 catch (ert)
			 {
				 if(!Ext.isEmpty(me.yaxisop))
					$('#' + me.body.id).highcharts(me.chartConfig(me.data,me.chartType,me.xaxis,me.yaxis,me.yaxisop,me.isAllZero,me.fmts));				
				else
					$('#' + me.body.id).highcharts(me.chartConfig(me.data,me.chartType,me.xaxis,me.yaxis,null,me.isAllZero,me.fmts));
			 }
			
		 }
		 
     },
     chartLegendAlignment: function(obj) {
         var me = this,
				alignment, 
				verticalAlign = me.legendPosition;
         switch (verticalAlign) {
             case "top":
                 alignment = "center";
                 verticalAlign = "top";
                 Ext.apply(obj, {
                     align: alignment,
                     verticalAlign: verticalAlign,
                     layout: 'horizontal'
                 });

                 break;
             case "bottom":
                 alignment = "center";
                 verticalAlign = "bottom";
                 Ext.apply(obj, {
                     align: alignment,
                     verticalAlign: verticalAlign,
                     layout: 'horizontal'
                 });

                 break;
             case "left":
                 alignment = "left";
                 verticalAlign = "middle";
                 Ext.apply(obj, {
                     align: alignment,
                     verticalAlign: verticalAlign,
                     layout: 'vertical'
                 });

                 break;
             case "right":
                 alignment = "right";
                 verticalAlign = "middle";
                 Ext.apply(obj, {
                     align: alignment,
                     verticalAlign: verticalAlign,
                     layout: 'vertical'
                 });

                 break;
         }

     },
     chartConfig: function(data,chartType,xaxisL,yaxisL,yaxisL2,isAllZero,s_time_fout) {
        var me = this;
        var rotation = 270;
		chartType = me.chartType;
		if(Ext.isEmpty(xaxisL) && xaxisL == undefined)
			xaxisL = "";
		if(Ext.isEmpty(yaxisL) && yaxisL == undefined)
			yaxisL = "";
		// @chartConfig
		var maxVal = null;
		var xDtaformate = '';
		if(!Ext.isEmpty(mgrDateFormat))
		{
			xDtaformate = tooltipDateFormate(mgrDateFormat);
		}
		if(!Ext.isEmpty(isAllZero) && (isAllZero || isAllZero == "true"))
			maxVal = 10;
		s_time_fout =(s_time_fout == null || s_time_fout == '')?'HH:mm':s_time_fout;
		me.chartProps = {
             chart: {
                 type: chartType,
				margin: [0, 0, 0, 0],	
				backgroundColor: 'transparent',
				 style: {
					fontFamily: 'Roboto',
					fontWeight: 300
				},
				styledMode: true,
             },
			title: {
				text: ''
			},
             exporting: {
                 enabled: false
             },
             credits: {
                 enabled: false
             },
				
             legend: {
                 symbolWidth: 6,
                 symbolHeight: 6,
                 squareSymbol: false,
                 symbolRadius: 6,
                 itemMarginTop: 10,
                 itemHoverStyle: {
                     "color": "#84b8e4"
                 },
                 itemStyle: {
                     fontSize: "11px",
                     fontWeight: 300,
					 color:strRumSkin == "Dark"?"#c0c0c0":"#969696"
                 },
                 y: -35
             },
			 tooltip: {
				//xDateFormat:xDtaformate,
				valueDecimals: 4,
				backgroundColor :'rgba(255, 255, 255, 0.85)',
				borderWidth: 1,
				borderColor :'rgba(255, 255, 255, 0.85)',
				shared: true,
				formatter: function() {
					var s ='';
					var bgcolor='rgba(255, 255, 255, 0.85)';
					var legendSize = data.length;
					var seriesCounter = data.length;
					var tipColor = "#2a292a";
					if(legendSize==1 || (strRumSkin=='Dark' || strRumSkin=='dark') )
						s = '<span style="color:'+tipColor+'">'+Highcharts.dateFormat(xDtaformate,this.x,true)+'</span><br/>';
					else
						s = '<span>'+Highcharts.dateFormat (xDtaformate,this.x,true)+'</span><br/>'
					jQuery.each(this.points, function(i, point) {
						var val = Highcharts.numberFormat (point.y,4, '.','');
						var val_ar = val.split('.');
						if(val_ar.length>1)
						{
							if(val_ar[1]=='0000')
								val = val_ar[0];
						}
						if (point.series.name != '' && point.series.name != undefined && !(point.series.name.indexOf("Series") > -1)) {
							if(legendSize==1)
								s += '<b><span style="color:'+tipColor+'">'+ Ext.String.htmlDecode(point.series.name) +' :  '+val+'</span></b><br/>';
							else
								s += '<b><span style="color:' + this.series.color + '">'+ Ext.String.htmlDecode(point.series.name) +'  :  '+val+'</span></b><br/>';
						}
						else
						{
							s += '<br/> <b><span style="color:'+tipColor+'">'+val+'</span></b><br/>';
						}
					});
					return s;
				}
             }
            /* series: [{
                 data: data
             }]*/
         }
		// @setting the chartConfig
		 switch(chartType){
			case "pie" :
		
			Ext.apply(me.chartProps, {
				 chart: {
						type: chartType,
						backgroundColor: 'transparent',
						style: {
							fontFamily: 'Roboto',
							fontWeight: 300
						},
						styledMode: true,
						events: {
							load: function(event) {
								jQuery('.highcharts-legend-item rect').attr('height', '6').attr('y', '17');
								jQuery('.highcharts-legend-item rect').attr('width', '6').attr('x', '0');
							}
						}
					},
					tooltip: {
						enabled:true,
						 formatter: function() {
							var s = '';		
							//var tipColor = (strRumSkin == 'Dark')?"#2a292a":"#c0c0c0";
							var tipColor = "#2a292a";
							s += '<span><b style="color:'+this.point.color+'">'+Ext.String.htmlDecode(this.point.name)+'</b>:<b style="color:'+tipColor+'">'+this.point.y+' %</b></span>';
							return s;
						 }
					},
					plotOptions: {
						pie:{
							shadow: false,
							showInLegend: true,
							startAngle: 0,
							endAngle: 360,
							borderWidth: 0,
							size: '100%',
							shadow: false,
							dataLabels: {
								distance: -25,
								enabled: false,
								formatter: function() {
									return Math.round(this.percentage * 100) / 100 + ' %';
								},
								style: {
									fontWeight: 'bold',
									color: '#FFFFFF',
									textShadow: false,
									textOutline: false
								}
							}
						}

					 },
					legend: {
						 symbolWidth: 6,
						 symbolHeight: 6,
						 squareSymbol: false,
						 symbolRadius: 6,
						 itemMarginTop: 10,
						 itemHoverStyle: {
							 "color": "#84b8e4"
						 },
						 itemStyle: {
							 fontSize: "11px",
							 fontWeight: 300,
							 color:strRumSkin == "Dark"?"#c0c0c0":"#969696"
						 },
						 y: 0
					 },
				  series: [{
							data: data
					}]
			});
			break;
		
			case "area" :
			Ext.apply(me.chartProps, {
                     chart: {
							type: chartType,
							backgroundColor: 'transparent',
							zoomType: 'x',
							style: {
								fontFamily: 'Roboto',
								fontWeight: 300
							},
							events: {
								load: function(event) {
									jQuery('.highcharts-legend-item rect').attr('height', '6').attr('y', '17');
									jQuery('.highcharts-legend-item rect').attr('width', '6').attr('x', '0');
								}
							},
							styledMode: true
						},
						yAxis: {
							max:maxVal,
							allowDecimals: false,
							gridLineWidth: 0,
							lineWidth: 1,
							gridLineColor: strRumSkin == "Dark"?"#666666":"#e1e1e1",
							lineColor:strRumSkin == "Dark"?"#666666":"#e1e1e1",
							minorTickLength: 0,
							tickLength: 0,
							title: {
								//text: 'Page load time'
								text: yaxisL,
								style:
								{
									color: strRumSkin == "Dark"?"#c0c0c0":"#969696"
								}
							},
							labels: {
								style: {
									color : strRumSkin == "Dark"?"#c0c0c0":"#969696"
								}
							}
						},
						xAxis: {
							type: 'datetime',
							//tickInterval: ticketInterval,
							//categories:categoryArray,
							gridLineWidth: 1,
							gridLineColor: strRumSkin == "Dark"?"#666666":"#e1e1e1",
							lineColor:strRumSkin == "Dark"?"#666666":"#e1e1e1",
							minorTickLength: 0,
							tickLength: 0,
							labels: {
								y:10,
								rotation: rotation,
								style: {
									color : strRumSkin == "Dark"?"#c0c0c0":"#969696"
								},
								formatter: function() {
									return  Highcharts.dateFormat(s_time_fout, this.value);
								}
							},
							title: {
								//text: 'Time (hrs)'
								text: xaxisL,
								//offset:50,
								y:10,
								style:
								{
									color: strRumSkin == "Dark"?"#c0c0c0":"#969696"
								}
							}
						},
						showInLegend: false,
						plotOptions: {
							 series:{
								 marker: {
									enabled: false
								},
								fillOpacity: 0.95,
								lineWidth:0
							 }
						},
					  series: data
                 });
			break;
			case "line" :
			Ext.apply(me.chartProps, {
                     chart: {
							type: chartType,
							backgroundColor: 'transparent',
							zoomType: 'x',
							style: {
								fontFamily: 'Roboto',
								fontWeight: 300
							},
							events: {
								load: function(event) {
									jQuery('.highcharts-legend-item rect').attr('height', '6').attr('y', '17');
									jQuery('.highcharts-legend-item rect').attr('width', '6').attr('x', '0');
								}
							},
							styledMode: true
						},
						yAxis: {
							max:maxVal,
							allowDecimals: false,
							min: 0,
							gridLineWidth: 0,
							lineWidth: 1,
							gridLineColor: strRumSkin == "Dark"?"#666666":"#e1e1e1",
							lineColor:strRumSkin == "Dark"?"#666666":"#e1e1e1",
							minorTickLength: 0,
							tickLength: 0,
							title: {
								//text: 'Page load time'
								text: yaxisL,
								style:
								{
									color: strRumSkin == "Dark"?"#c0c0c0":"#969696"
								}
							},
							labels: {
								style: {
									color : strRumSkin == "Dark"?"#c0c0c0":"#969696"
								}
							}
						},
						showInLegend: false,
						xAxis: {
							type: 'datetime',
							//tickInterval: ticketInterval,
							//categories:categoryArray,
							gridLineWidth: 1,
							gridLineColor: strRumSkin == "Dark"?"#666666":"#e1e1e1",
							lineColor:strRumSkin == "Dark"?"#666666":"#e1e1e1",
							minorTickLength: 0,
							tickLength: 0,
							allowDecimals: false,
							labels: {
								y:10,
								rotation: rotation,
								style: {
									color : strRumSkin == "Dark"?"#c0c0c0":"#969696"
								},
								formatter: function() {
									return  Highcharts.dateFormat(s_time_fout, this.value);
								}
							},
							title: {
								//text: 'Time (hrs)'
								y:10,
								text: xaxisL,
								style:
								{
									color: strRumSkin == "Dark"?"#c0c0c0":"#969696"
								}
							}
						},
						plotOptions: {
							series:{
								 marker: {
									enabled:true,
									 lineWidth: 0,
									radius: 3,
									lineColor: 'transparent',
									symbol:'circle'
								}
								
							 }
						},
					
					  series: data
                 });
			break;
			case "column":
				
			Ext.apply(me.chartProps, {
                     chart: {
							type: chartType,
							backgroundColor: 'transparent',
							zoomType: 'x',
							style: {
								fontFamily: 'Roboto',
								fontWeight: 300
							},
							events: {
								load: function(event) {
									jQuery('.highcharts-legend-item rect').attr('height', '6').attr('y', '17');
									jQuery('.highcharts-legend-item rect').attr('width', '6').attr('x', '0');
								}
							},
							styledMode: true
						},
					yAxis: [{
							max:maxVal,
							min:0,
							allowDecimals: false,
							gridLineWidth: 0,
							lineWidth: 1,
							lineColor:strRumSkin == "Dark"?"#666666":"#e1e1e1",
							minorTickLength: 0,
							tickLength: 0,
							title: {
								//text: 'Page load time'
								text: yaxisL,
								style:
								{
									color: strRumSkin == "Dark"?"#c0c0c0":"#969696"
								}
							},
							labels: {
								enabled:true,
								style: {
									color : strRumSkin == "Dark"?"#c0c0c0":"#969696"
								}
							}
						},{
							max:maxVal,
							min:0,
							allowDecimals: false,
							gridLineWidth: 0,
							lineWidth: 1,
							lineColor:strRumSkin == "Dark"?"#666666":"#e1e1e1",
							minorTickLength: 0,
							tickLength: 0,
							title: {
								//text: 'Page load time'
								useHTML:true,
								text: '<div style="padding-top:10px !important">'+yaxisL2+'</div>',
								rotation:270,
								style:
								{
									color: strRumSkin == "Dark"?"#c0c0c0":"#969696"
								}
							},
							labels: {
								enabled:true,
								style: {
									color : strRumSkin == "Dark"?"#c0c0c0":"#969696"
								}
							},
							opposite: true
						}],
						xAxis: {
							type: 'datetime',
							//tickInterval: ticketInterval,
							//categories:categoryArray,
							gridLineWidth: 1,
							gridLineColor: strRumSkin == "Dark"?"#666666":"#e1e1e1",
							lineColor:strRumSkin == "Dark"?"#666666":"#e1e1e1",
							minorTickLength: 0,
							tickLength: 0,
							allowDecimals: false,
							labels: {
								y:10,
								rotation: rotation,
								style: {
									color : strRumSkin == "Dark"?"#c0c0c0":"#969696"
								},
								formatter: function() {
									return  Highcharts.dateFormat(s_time_fout, this.value);
								}
							},
							title: {
								//text: 'Time (hrs)'
								y:10,
								text: xaxisL,
								style:
								{
									color: strRumSkin == "Dark"?"#c0c0c0":"#969696"
								}
							}
						},
					plotOptions: {							
							 series: {
								borderWidth: 0,
								marker: {
								   enabled: false
								},
								allowPointSelect: true
							}
					},
					  series: data
                 });
				break;
		 }
         me.chartLegendAlignment(me.chartProps.legend);
		 var colorArray = [];
		 if(strSkin == "Light")
		 {
			 colorArray.push("#969696");
			 colorArray.push("#969696");
		 }
		 else
		 {
			 colorArray.push("#c6c6c6");
			 colorArray.push("#c6c6c6");
		 }
		 if(chartType == "column")
			 me.chartProps= jQuery.extend(true,me.chartProps,getUserThemeFor(strSkin,true,colorArray));
		 else
			  me.chartProps= jQuery.extend(true,me.chartProps,getUserThemeFor(strSkin));
         return me.chartProps;
     }
    
 });
 