 Ext.define('RumAppFlow.view.ChartPanelNew', {
     extend: 'Ext.panel.Panel',
     alias: 'widget.chartpanelnew',
	//cls:'animation_box',
	 border: true,
     flex: 1,
     ui: 'eg-x-panel',
     margin: '0 1 1 0',
     bodyPadding: '0 20 20 20',
     title: 'Response Time Breakup - Desktop',
	legendPosition: 'bottom', // top,left, bottom and right
    chartType: 'area', // pie,line,column,area -  chart type
     config: {
         data: null
     },
	chartPanel:'multiple' ,// 'single, multiple'
	showMaxMin:false,
	data:[{
			"title":"LINE",
			"chartHistory":"Last 4 hour",
			"chartType": "line",
			"legendPosition": "top",
			"data":[{
								data: [29.9, 71.5, 106.4, 129.2, 144.0, 176.0, 135.6, 148.5, 216.4, 194.1, 95.6, 54.4]
						}]
		},{
			"title":"PIE",
			"chartHistory":"Last 1 hour",
			"chartMinMax":[
										{
												"chartHistory":"Last 5 hour",
												"avg" : 0.04,
												 "min":0.05
										},{
												"chartHistory":"Last hour",
												"avg" : 0.04,
												 "min":0.05
										}
			],
			"chartType": "pie",
			"legendPosition": "bottom",
			"data":[
							{
								 "name": "Browser",
								 "y": 10,
								 "color": "#409fb4"
							 },
							 {
								 "name": "Server Time",
								 "y": 4,
								 "color": "#f1be5c"
							 },
							 {
								 "name": "Network",
								 "y": 12,
								 "color": "#24384b"
							 },
							 {
								 "name": "Content Download Time",
								 "y": 12,
								 "color": "#e57e73"
							 }	
					]
		}],
	historyData:[],
     constructor: function(config) {
         this.initConfig(config);
         this.callParent(arguments);
     },
	addChartHistory:function(){
		 var me = this,historyItems=[];
			if(!Ext.isEmpty(me.historyData)){
				 for(var i=0;i<me.historyData.length;i++){
						if(i%2 == 0){
								margin = '0 30 0 0';
							}else{
								margin = '0 0 0 0';
							}
						 var items ={
							xtype:'container',
							margin:margin,
							flex:1,
							items:[
							 {
								xtype:'label',
								cls:'font_bold9 grayColor',
								text:me.historyData[i].chartHistory,
							},{
								xtype:'box',
								height:65,
								cls:"chartminmax",
								html:'<div style="padding-top:20px"><div style="width:50%;float:left;text-align:center"><div class="font_normal18">'+me.historyData[i].avg+'</div><div class="font_normal12" style="margin-top:3px;">avg</div></div><div style="width:50%;float:right;text-align:center"><div class="font_normal18">'+me.historyData[i].min+'</div><div class="font_normal12" style="margin-top:3px;">max</div></div></div>'
							}	
							]
						 };
						historyItems.push(items);
				 }
			}
			var historyContainer = {
				xtype:'container',
				height:90,
				layout:{
						type:'hbox',
						align:'stretch'
				},
				items:historyItems
			};
			return historyContainer;
	 },
     initComponent: function() {
         var me = this;
		me.mon(me, 'boxready', me.loadChart, me);
		if(me.showMaxMin){
			me.items =[
			me.addChartHistory(),
			{
				xtype:'container',
				cls:'chartholder',
				flex:1,
				layout:{
						type:'vbox',
						align:'stretch'
				},
				html:'chartTorender'
			}
			]
		};
		//@ checking chartPanelType
		if(me.chartPanel == "single"){
			Ext.apply(me,{
				height: 301,
				layout:{
					type: 'vbox',
					 align: 'stretch'
				}
			});
		}else{
			Ext.apply(me,{
				defaults:{
					columnWidth: 0.5,
					height: 301
				},
				layout:{
					type:'column'
				}
			});
		}
        me.callParent(arguments);
		 me.mon(me, 'resize', me.resizePanel, me);
		 me.mon(me, 'removed', me.destroyChart, me);
     },
     updateChart: function(el,data,chartType) {
         var me = this;
         $('#' + el).highcharts(me.chartConfig(data,chartType));
     },
	destroyChart:function(){
			 var me = this,chartObj = $('#' + me.body.id).highcharts();
			if(!Ext.isEmpty(chartObj)){
				chartObj.destroy();
			}
	 },
	resizePanel:function(){
		 var me = this,chartObj = $('#' + me.body.id).highcharts();
		 if(!Ext.isEmpty(chartObj)){
			chartObj.reflow();
		 }
	 },
	loadMultipleChart:function(datax,charttypex){
		 var me = this,panel= {},chartitemArry=[],margin="";
		 if(!Ext.isEmpty(datax)){
				 //Ext.suspendLayouts();
				 for (var i= 0; i <  datax.length;i++ ){
							panel = {
								xtype:'panel',
								border: true,
								 flex: 1,
								data:datax[i].data,
								 ui: 'eg-x-panel',
								 margin: '0 8 8 0',
								bodyPadding: '0 20 20 20',
								listeners:{
									resize:function(panel){
										
										me.resizePanel();
									},
									boxready:function(panel){
										$('#' + panel.body.id).highcharts(me.chartConfig(datax,charttypex));
									}
								}
							}
					chartitemArry.push(panel)		
				 }
					//Ext.resumeLayouts(true);
		 }
			return chartitemArry;
	 },
     loadChart: function() {
         var me = this;
		 if(me.showMaxMin){
			// alert(me.showMaxMin)
		 }else{
			 if(me.data.length == 1){
				$('#' + me.body.id).highcharts(me.chartConfig(me.data,me.chartType));
			 }else{
				me.add(me.loadMultipleChart(me.data,me.chartType))
			 }
			 
		 }
		 
     },
     chartLegendAlignment: function(obj) {
         var me = this,
				alignment, 
				verticalAlign = me.legendPosition;
         switch (verticalAlign) {
             case "top":
                 alignment = "center";
                 verticalAlign = "top";
                 Ext.apply(obj, {
                     align: alignment,
                     verticalAlign: verticalAlign,
                     layout: 'horizontal'
                 });

                 break;
             case "bottom":
                 alignment = "center";
                 verticalAlign = "bottom";
                 Ext.apply(obj, {
                     align: alignment,
                     verticalAlign: verticalAlign,
                     layout: 'horizontal'
                 });

                 break;
             case "left":
                 alignment = "left";
                 verticalAlign = "middle";
                 Ext.apply(obj, {
                     align: alignment,
                     verticalAlign: verticalAlign,
                     layout: 'vertical'
                 });

                 break;
             case "right":
                 alignment = "right";
                 verticalAlign = "middle";
                 Ext.apply(obj, {
                     align: alignment,
                     verticalAlign: verticalAlign,
                     layout: 'vertical'
                 });

                 break;
         }

     },
     chartConfig: function(data,chartType) {
         var me = this;
		 chartType = me.chartType;
		// @chartConfig
		 me.chartProps = {
             chart: {
                 type: chartType,
				margin: [0, 0, 0, 0],
                 backgroundColor: 'transparent'
             },
             title: "",
             exporting: {
                 enabled: false
             },
             credits: {
                 enabled: false
             },
				
             legend: {
                 symbolWidth: 6,
                 symbolHeight: 6,
                 squareSymbol: false,
                 symbolRadius: 6,
                 itemMarginTop: 10,
                 itemHoverStyle: {
                     "color": "#84b8e4"
                 },
                 itemStyle: {
                     fontSize: "11px",
                     fontWeight: "normal",
                     fontFamily: "Arial"
                 },
                 y: 0
             },
             tooltip: {
                 formatter: function() {
                     return Ext.String.htmlDecode(this.point.name) + '</b>: ' + Math.round(this.percentage * 100) / 100 + ' %';
                 }
             }
            /* series: [{
                 data: data
             }]*/
         }
		// @setting the chartConfig
		 switch(chartType){
			case "pie" :
		
			Ext.apply(me.chartProps, {
                     chart: {
							type: chartType,
						
							 backgroundColor: 'transparent'
						},
						 plotOptions: {
							 pie: {
								 shadow: false,
								 showInLegend: true,
									loading: 'loading',
								 startAngle: 0,
								 endAngle: 360,
								 borderWidth: 0,
								 size: '85%',
								 shadow: false,
								 dataLabels: {
									 distance: -25,
									 enabled: false,
									 formatter: function() {
										 return Math.round(this.percentage * 100) / 100 + ' %';
									 },
									 style: {
										 fontWeight: 'bold',
										 color: '#FFFFFF'
									 }
								 }
							 }

						 },
					  series: [{
								data: data
						}]
                 });
			break;
			case "area" :
			Ext.apply(me.chartProps, {
                     chart: {
							type: chartType,
							 backgroundColor: 'transparent'
						},
						yAxis: {
							allowDecimals: false,
							gridLineWidth: 0,
							title: {
									 text: 'Page load time'
							}
						},
						xAxis: {
							gridLineWidth: 1,
							 categories: ['11', '11:20', '11:30', '11:40', '11:50'],
							
							title: {
									 text: 'Time hrs'
							}
						},
						showInLegend: false,
						plotOptions: {
							
							 series:{
							 fillOpacity: 1
							 }
						},
					  series: data
                 });
			break;
			case "line" :
			Ext.apply(me.chartProps, {
                     chart: {
							type: chartType,
							 backgroundColor: 'transparent'
						},
						yAxis: {
							allowDecimals: false,
							gridLineWidth: 0,
							title: {
									 text: 'Page load time'
							}
						},
						xAxis: {
							gridLineWidth: 1,
							allowDecimals: false,
							title: {
									 text: 'Time hrs'
							}
						},
						plotOptions: {
						
						},
					  series: data
                 });
			break;
			case "column":
				
			Ext.apply(me.chartProps, {
                     chart: {
							type: chartType,
							 backgroundColor: 'transparent'
						},
					yAxis: {
							allowDecimals: false,
							gridLineWidth: 0,
							title: {
									 text: 'Page load time'
							}
						},
						xAxis: {
							gridLineWidth: 1,
							allowDecimals: false,
							title: {
									 text: 'Time hrs'
							}
						},
					plotOptions: {
							 series: {
									allowPointSelect: true
							}
					},
					  series: data
                 });
				break;
		 }
         me.chartLegendAlignment(me.chartProps.legend);
		 var colorArray = [];
		 colorArray.push("#969696");
		 colorArray.push("#969696");
		 if(chartType == "column")
			 me.chartProps= jQuery.extend(true,me.chartProps,getUserThemeFor(strSkin,true,colorArray));
		 else
	 		 me.chartProps= jQuery.extend(true,me.chartProps,getUserThemeFor(strSkin));
         return me.chartProps;
     }
    
 });
 