 Ext.define('RumAppFlow.view.ChartParentPanel', {
	 extend: 'Ext.panel.Panel',
     alias: 'widget.chartparentpanel',
	requires:['RumAppFlow.view.ChartPanel'],
	margin:'10 0 0 0',
	defaults:{
		columnWidth: 0.5,
		 height: 301
	 },
	layout:'column',
	manageOverflow:2,
	config: {
         data: null
     },
     constructor: function(config) {
         this.initConfig(config);
         this.callParent(arguments);
     },
	initComponent: function() {
         var me = this,item=[];
		// @ render the chart panel
		me.renderChart(me.data)
        me.callParent(arguments);
     },
	chartPanelObj:function(){
		return { xtype:'chartpanel' }
	 },
	updateChartData:function(chartData){
		for (var i= 0; i < chartData.length;i++ )
		{
			var chartDataEl = chartData[i]['Application_Block_'+(i+1)+'_Value'][0];

			if(Ext.isEmpty(chartDataEl.data))
				chartDataEl.data = chartDataEl.DataSet;

			Ext.getCmp(chartDataEl.chartType+"_id_"+i).updateChart(chartDataEl);
		}

	 },
	renderChart:function(objdata){
		var me = this,chartitemArry=[],margin="";
		if(!Ext.isEmpty(objdata)){
			 Ext.suspendLayouts();
			 
			for (var i= 0; i <  objdata.length;i++ )
			{
				if(i%2 == 0){
					margin = '0 8 8 0';
				}else{
					margin = '0 2 8 0';
				}
				var data = objdata[i]['Application_Block_'+(i+1)+'_Value'][0].data;
				if(Ext.isEmpty(data))
					data = objdata[i]['Application_Block_'+(i+1)+'_Value'][0].DataSet;

				var chartTyepe = objdata[i]['Application_Block_'+(i+1)+'_Value'][0].chartType;
				chartitemArry.push(Ext.apply(me.chartPanelObj(), {
					id:chartTyepe+"_id_"+i,
					"title": objdata[i]['Application_Block_'+(i+1)+'_Value'][0].title,
					"data":data,
					"historyData":objdata[i]['Application_Block_'+(i+1)+'_Value'][0].chartMinMax,
					margin:margin,
					tools:[
					{
						xtype:'label',
						cls:'font_bold9 grayColor',
						text: objdata[i]['Application_Block_'+(i+1)+'_Value'][0].chartHistory
					}
					],
					"chartType": objdata[i]['Application_Block_'+(i+1)+'_Value'][0].chartType,
					"legendPosition": objdata[i]['Application_Block_'+(i+1)+'_Value'][0].legendPosition,
					"xaxis": objdata[i]['Application_Block_'+(i+1)+'_Value'][0].xaxis,
					"yaxis": objdata[i]['Application_Block_'+(i+1)+'_Value'][0].yaxis,
					"yaxisop": objdata[i]['Application_Block_'+(i+1)+'_Value'][0].yaxisop,
					"isAllZero": objdata[i]['Application_Block_'+(i+1)+'_Value'][0].isAllZero,
					"fmts": objdata[i]['Application_Block_'+(i+1)+'_Value'][0].fmts,
				}));
			}
			me.items = chartitemArry;
			Ext.resumeLayouts(true);
		}

	 }
 })