Ext.define('RumAppFlow.view.DonutChart', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.donutchart',
    initComponent: function() {
        var me = this;
        me.mon(me, 'boxready', function() {
            me.loadChartContainers(me.data)
        }, me);
        me.callParent();
    },
	updateData:function(data){
		var me = this;
		me.loadChartContainers(data)
	},
    border: true,
    ui: 'eg-x-panel',
    margin: '0 1 1 0',
	bodyCls:'highChartbody',
    bodyPadding: '0 10 10 10',
    layout: {
        type: 'vbox',
        align: 'stretch'
    },
    loadChartContainers: function(data) {
        var me = this;
		var donutData = data;
		var nodata = false;
		try
		{
			for(var u=0;u<donutData.length;u++){
				if(donutData[u].value == "-" || donutData[u].value == "0")
					nodata = true;
				else
					break;
			}
			
		}
		catch (e1)
		{
		}
		if(nodata)
			me.update('<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>No Data Found!</div></div></div>');
		else
			me.chartConfig(me.body.id, data);
        
        //}
    },
    chartConfig: function(id, chartdata) {
        var me = this;
        var charta = new Highcharts.Chart({
            chart: {
                renderTo: id,			
				//margin:0,
				marginBottom:22,
				 style: {
                        fontFamily: 'Roboto',
                        fontWeight: 'normal'
                },
                styledMode: true,
				spacing:0,
                backgroundColor: 'transparent',
                type: 'pie',			
            },			
            tooltip: {
                enabled: false
            },
            exporting: {
                enabled: false
            },
            credits: {
                enabled: false
            },
			title:{
				text:"<span id='addText' style='position:relative; left:-28px;top:64px;width:283px;right:0;bottom:0;'></span>",
				align: 'center',
				useHTML:true,				
			},
			tooltip: {
				enabled:true,
				 formatter: function() {
					var s = '';		
					//var tipColor = (strRumSkin == 'Dark')?"#2a292a":"#c0c0c0";
					var tipColor = "#2a292a";
					s += '<span><b style="color:'+this.point.color+'">'+this.point.name+'</b>:<b style="color:'+tipColor+'">'+this.point.y+' </b></span>';
					return s;
				 }
			},
			legend: {
                 symbolWidth: 6,
                 symbolHeight: 6,
                 squareSymbol: false,
                 symbolRadius: 6,
                 itemMarginTop: 10,
                 itemHoverStyle: {
                     "color": "#84b8e4"
                 },
                 itemStyle: {
                     fontSize: "11px",
                     fontWeight: "400",
                     fontFamily: "Roboto",
					 color:strRumSkin == "Dark"?"#c0c0c0":"#969696"
                 },
                y:-2
             },
            plotOptions: {
                pie: {
					innerSize: '60%',					
                    allowPointSelect: false,
                    borderWidth: 0,
                    //slicedOffset: 0,
					startAngle: 180,
                    showInLegend: true,
					dataLabels: {
						enabled: false,
						color:strRumSkin == "Dark"?"#c0c0c0":"#969696",
						overflow: "none",
						connectorColor: '#cccccc',
						zIndex:2,
						align: "center",
						x:20,
						softConnector: true,
						padding: 0,
						distance:8,
						style:{
							"text-anchor":"middle",
							width: '100px',
							textShadow: false,
							textOutline: false
						 },
						maxStaggerLines:1,
						//enabled: true,
						formatter: function() {
							return '<tspan>'+this.y+'</tspan><tspan> '+ this.key+'</tspan>';
						},
						
					 },
					 point:{
						   events : {
							legendItemClick: function(e){
								e.preventDefault();
							}
						   }
					   }
                },
				point: {
					events: {
						legendItemClick: function () {
							return false; // <== returning false will cancel the default action
						}
					}
				}
            },
            series: [{
                data: chartdata
            }]
        }, function(chart) {
            // on complete
		var textX = chart.plotLeft + (chart.series[0].center[0]);
        var textY = chart.plotTop  + (chart.series[0].center[1]);
		var total_pages_view = 0;
		Ext.each(chart.series[0].data, function(el){
			total_pages_view += el.value;
		});
        var span = '<span id="pieChartInfoText" style="position:relative;text-align:center">';
        span += '</span>';
			
        $("#addText").append(span);
		
        span = $('#pieChartInfoText');	
       
		Ext.defer(function(){
				$('#pieChartInfoText').append('<span  class="labelRobotoboldCls" style="font-size:16px;padding-top:10px">'+total_pages_view+'</span><br><span style="font-size:11px;line-height:11px;!important">Total page<br> views</span>');
			},500);
	

        });
    }

});