Ext.define('RumAppFlow.view.ErrorView', {
    extend: 'Ext.panel.Panel',
	requires:['RumAppFlow.view.DonutChart',
		'RumAppFlow.view.RumAppflowErrorGrid',
		'RumAppFlow.view.ChartPanel'
	],
    alias: 'widget.errorview',
    initComponent: function() {
        var me = this;
        me.callParent();
    },
	flex:1,
	layout:{
		type:'vbox',
		align:'stretch'
	},
	updateData:function(jsonData){
		Ext.getCmp('errorgrid_script').loadData(jsonData[1].Application_Block_1_Value[0]);
		Ext.getCmp('errordonut_script').updateData(jsonData[2].Application_Block_2_Value[0].data);
		Ext.getCmp('errorgrid_slowP').loadData(jsonData[3].Application_Block_3_Value[0]);
		Ext.getCmp('errorgrid_urlP').loadData(jsonData[5].Application_Block_5_Value[0]);
		Ext.getCmp('errorgrid_bigChart').updateChart(jsonData[4].Application_Block_4_Value[0]);
	},
	listeners:{
		'afterrender':function(e){
			var me = this;
			var jsonData = this.data;
			me.add(							
				{
					xtype:'container',
					height:233,
					layout:{
						type:'hbox',
						align:'stretch'
					},
					listeners:{
						'afterrender':function(e){
							var me = this;
							me.add
							(
								{
									xtype: 'rumappflowerrorgrid',
									id:'errorgrid_script',
									flex: 1,
									height: 228,
									margin: '0 10 2 0',
									data:jsonData[1].Application_Block_1_Value[0],
									title:jsonData[1].Application_Block_1_Value[0].title

								},
								{
									xtype:'donutchart',
									id:'errordonut_script',
									title:jsonData[2].Application_Block_2_Value[0].title,
									data:jsonData[2].Application_Block_2_Value[0].data,
									width: 283,
									margin: '0 2 2 0',
									height: 228
								}
							);
						}
					},
					items:[]
				},
				{
					xtype:'container',
					height:446,
					flex:1,
					margin:'10 0 10 0',
					layout:{
						type:'hbox',
						align:'stretch'
					},
					html:'box2',
					listeners:{
						'afterrender':function(e){
							var me = this;
							var isAllZeroVal = null;
							if(!Ext.isEmpty(jsonData[4].Application_Block_4_Value[0].isAllZero)){
								isAllZeroVal = jsonData[4].Application_Block_4_Value[0].isAllZero;
							}
							me.add(
								{
									xtype:'container',
									flex:0.5,
									html:'box2.1',
									layout:{
										type:'vbox',
										align:'stretch'
									},
									listeners:{
									'afterrender':function(e){
										var me = this;
										me.add(											
										{
											xtype: 'rumappflowerrorgrid',
											id:'errorgrid_slowP',
											flex: 1,
											margin: '0 10 2 0',
											overriderRenderer:function(value,rowObj,fileds,i){
												var me = this;
												/*if(fileds[i]["name"] == "browser"){
													return function(value){
														return '<span data-qclass="yellowTip"  data-qtip=' + value.name + ' ><img src="../images/clear.png" class="'+ value.cls + '" style= "vertical-align: middle;margin-right:3px;" /> ' + value.name + '</span>';
													};
												}else*/{
													return value;
												}
												this.callParent();														
											},
											data:jsonData[3].Application_Block_3_Value[0],											
										},
										{
											xtype: 'rumappflowerrorgrid',
											id:'errorgrid_urlP',
											flex: 1,
											margin: '10 10 2 0',
											data:jsonData[5].Application_Block_5_Value[0]
										});
										}
									},
									items:[]
								},
								{
									xtype: 'chartpanel',
									id:'errorgrid_bigChart',
									legendPosition: 'top',
									chartType:jsonData[4].Application_Block_4_Value[0].chartType,
									data:jsonData[4].Application_Block_4_Value[0].data,
									title:jsonData[4].Application_Block_4_Value[0].title,
									xaxis:jsonData[4].Application_Block_4_Value[0].xaxis,
									yaxis:jsonData[4].Application_Block_4_Value[0].yaxis,
									fmts:jsonData[4].Application_Block_4_Value[0].fmts,
									isAllZero:isAllZeroVal,
									flex:1
								}
							);
						}
					},
					items:[]
					
				}			
			);
		}
	},
	items:[]
});