Ext.define('RumAppFlow.view.GenericWindow',{
		extend:'Ext.window.Window',
		alternateClassName: 'RumAppFlow.GenericWindow',
		alias: 'widget.genericwindow',
		ghost:false,
		modal:true,
		shadow : false,
		resizable:false,
		ui:'eg-new-window',
		cls:'animation_box',
		maskOpacity:'0.9',
		maskColor:'#000',
		closeAction : 'hide',
		cssMask:false,
		maskCls:'windowModal',
		initComponent: function() {
			var me = this;
			if(me.modal){
				me.mon(me, 'show', function(){me.addMaskCls()}, me);
				me.mon(me, 'hide', function(){me.removeMaskCls()}, me);
				me.mon(me, 'destroy', function(){me.removeMaskCls()}, me);
			}
			me.center();
			me.callParent();
		},
		addMaskCls:function(){
			var me = this, myMask = document.getElementById(me.getEl().id).nextSibling;
			if(!Ext.isEmpty(myMask)){
			var myMaskId = Ext.get(myMask).getAttribute('id');
			if(me.cssMask){
				Ext.get(myMask).addCls(me.maskCls);
			}else{
				Ext.get(myMask).setOpacity(me.maskOpacity);
				Ext.get(myMaskId).setStyle('background', me.maskColor);
			}
			}
			// resize stay in center
			Ext.EventManager.onWindowResize(function() {
					me.center();
			},me);
		},
		removeMaskCls:function(){
				var me = this, myMask = document.getElementById(me.getEl().id).nextSibling;
				if(!Ext.isEmpty(myMask)){
					var myMaskId = Ext.get(myMask).getAttribute('id');
					Ext.destroy(myMaskId);
				}
		}

});