Ext.define('RumAppFlow.view.GeoMapControls', {
    extend: 'Ext.container.Container',
    alias: 'widget.geomapcontrols',
    autoDestroy: true,
    //margin: '0 10 0 0',
    padding: 10,
    width: '100%',
    border: false,
    layout: {
        type: "hbox"
    },
    id: 'geomapHeaderID',
    items: [{
			xtype: 'label',
			cls: "b_label",
			text: 'Geo Map',
			margin: '2 0 0 0',
        },
        {
            xtype: 'button',
            margin: '0 5',
            cls: 'infobutton',
            infoToolTip: function(btn) {
                var me = this;
                var tooltip = Ext.create("Ext.tip.ToolTip", {
                    anchor: "top",
					shadow: true,
                    anchorOffset: 25,
                    mouseOffset: [0, 0],
                    target: btn.id,
					renderTo:'appflow_ground',
                    cls: "moreoptionstooltip",
                    listeners: {
                        hide: function(tooltip) {
                            if (!Ext.isEmpty(tooltip)) {
                                Ext.destroy(tooltip);
                            }
                        },
                        render: function(a) {
                            Ext.EventManager.onWindowResize(function(b, c) {
                                a.hide();
                            });
							var titneed = "World";
							var dynTitle = Ext.getCmp('geo_id_mapdetails').needTitle;
							if(!Ext.isEmpty(dynTitle))
								titneed = dynTitle;
							this.update("<div class='t_b'><div class='t_h'>How to read?</div> <ol><li>Showing response time and hits for  "+titneed+"</li></ol></div>");
                        }
                    },
                    getTargetXY: function() {
                        var x = btn.el.getXY()[0];
                        var y = btn.el.getXY()[1];
                        return [x - tooltip.anchorOffset - 12, btn.getHeight() + y];
                    },
                    autoHide: false,
                    anchorToTarget: true,
                    width: 210,
                    padding: "10 2 10 10",
                    style: 'text-align:left',
					//html: "<div class='t_b'><div class='t_h'>How to read?</div> <ol><li>Showing response time and hits for world</li></ol></div>"
                });
				return tooltip;
            },
            handler: function(btn) {
                btn.infoToolTip(btn).show();				
            },
			iconCls: 'big_infoIcon'
        },
		{
			xtype: 'combo',
			//fieldLabel:'Timeline',
			fieldLabel:'',
			cls:'dropdown',
			labelSeparator:'',
			width:120,
			labelWidth:130,
			labelStyle: {'white-space':'nowrap;'},
			name:'worldCombo',
			hidden:true,
			id:'countryComboId',
			//labelAlign:'top',
			margin:"2 10 0 10",
			displayField : 'name',
			valueField : 'value',
			queryMode : 'local',
			store:Ext.create('Ext.data.Store',{
				fields:['name','value'],
			}),
		},
		{
			xtype: 'combo',
			//fieldLabel:'Timeline',
			fieldLabel:'',
			cls:'dropdown',
			labelSeparator:'',
			width:120,
			labelWidth:130,
			labelStyle: {'white-space':'nowrap;'},
			name:'regionCombo',
			hidden:true,
			id:'regionComboId',
			//labelAlign:'top',
			margin:"2 10 0 0",
			displayField : 'name',
			valueField : 'value',
			queryMode : 'local',
			store:Ext.create('Ext.data.Store',{
				fields:['name','value'],
			}),
		}
    ]
})