/*
* "roadmap" displays the default road map view. This is the default map type.
* "satellite" displays Google Earth satellite images
* "hybrid" displays a mixture of normal and satellite views
* "terrain" displays a physical map based on terrain information.
*/
strRumSkin == "Dark"?'dark':'light';
Ext.getBody().on('click',function(event){
	var tarid = event.target.id;
	var tarCls = event.target.className;
	if(tarid != undefined && tarid != null && tarid.trim().length > 0 && !(tarid.indexOf("mapfilter") != -1) && tarCls != undefined && tarCls != null && tarCls.trim().length > 0 && !(tarCls.indexOf("x-form-check-group") != -1))
	{
		try
		{
			var tooltip1 = $("#filtermenu");
			if(!Ext.isEmpty(tooltip1))
				tooltip1.hide();			
		}
		catch (er)
		{
		}
		
	}
});

Ext.define('RumAppFlow.view.GeoPanel', {
	extend: 'Ext.ux.GMapPanel',
	alias: 'widget.geopanel',
	markers:new Array(),
	padding:10,
	controllersShow:true,
	//jsonData:Ext.decode(jsonData),
	jsonData:'',
	jsonData1:'',
	infoBoxArray:[],
	markerArray:[],
	feauturesArray:[],
	stateArray:[],
	listenerArray:[],
	access:null,
	cb_json:[],
	cb_geo:[],
	mapMode:'Country',
	zoomLevel:0,
	initComponent : function(){
		var me = this;
		Ext.applyIf(this,{
            plain: true,
            gmapType: 'map',
			mapType:'satellite',
            border: false,
			
        });
		this.callParent(arguments);
    },
	mapStyle:'default', //light,dark,default
	styleMap:function(){
		var me = this,style;
		//options = Ext.apply({}, this.mapOptions);
		switch(me.mapStyle){
			case 'light':
				style = lightStyle;
				break;
			case 'dark':
				style = darkStyle;
				break;
		}
		var styledMapType = new google.maps.StyledMapType(style,{name: 'Styled Map'});
		this.gmap.mapTypes.set('styled_map', styledMapType);
		this.gmap.setMapTypeId('styled_map');
	},
	zoom:1,
	updateData:function(data){
		try
		{
			this.jsonData = data;
			this.access=null;
			this.closeAllInfoBox();
			this.clearMap(this);
			this.removeAllListeners(this);
			var mapMode = data.mapMode;
			this.mapMode=mapMode;
			this.makeFilterDisable();
			if(mapMode == undefined || mapMode == null || mapMode == "Country")
			{
				var countryComboIdObj = Ext.getCmp('countryComboId');
				countryComboIdObj.getStore().loadRawData(data.countryArray);
				countryComboIdObj.setValue(data.selectedCountry);
				this.refreshMapDetails(this);
			}
			else
			{
				if(mapMode != undefined && mapMode != null && mapMode == "Region")
				{
					var regionComboIdObj = Ext.getCmp('regionComboId');
					regionComboIdObj.getStore().loadRawData(data.regionArray);
					regionComboIdObj.setValue(data.selectedRegion);
				}
				this.loadRegionDetails(this);
			}
		}
		catch (e)
		{
			return;
		}
		
	},
	stateCheck:function(me,stateArray){
		var oldStateArray = me.stateArray;

		try
		{
			var add_el = [];
			var remove_el = [];
			if(!Ext.isEmpty(stateArray) && !Ext.isEmpty(oldStateArray)){
				for(var c in oldStateArray){
					var el = oldStateArray[c];
					if(stateArray.indexOf(el) == -1)
						remove_el.push(el);
				}

				for(var c in stateArray)
				{
					var el = stateArray[c];
					if(oldStateArray.indexOf(el) == -1)
						add_el.push(el);
				}
			}
			else if( !Ext.isEmpty(stateArray) && Ext.isEmpty(oldStateArray)){
				for(var c in stateArray)
					add_el.push(stateArray[c]);
			}
			else if(Ext.isEmpty(stateArray) && !Ext.isEmpty(oldStateArray)){
				for(var c in oldStateArray)
					remove_el.push(stateArray[c]);
			}

			if(!Ext.isEmpty(add_el)){
				for (var a in add_el )
				{
					var st = add_el[a];
					if(st=='GOOD')
					{
						var st_good = Ext.getCmp('filtermenu_Normal');
						if(st_good.isDisabled()){
							st_good.setValue(true);
							st_good.setDisabled(false);
						}
					}
					else if(st=='UNKNOWN')
					{
						var st_unknown = Ext.getCmp('filtermenu_Unknown');
						if(st_unknown.isDisabled()){
							st_unknown.setValue(true);
							st_unknown.setDisabled(false);
						}
					}
					else if(st=='LOW')
					{
						var st_minor = Ext.getCmp('filtermenu_Minor');
						if(st_minor.isDisabled()){
							st_minor.setValue(true);
							st_minor.setDisabled(false);
						}
					}
					else if(st=='INTERMEDIATE')
					{
						var st_major = Ext.getCmp('filtermenu_Major');
						if(st_major.isDisabled()){
							st_major.setValue(true);
							st_major.setDisabled(false);
						}
					}
					else if(st=='HIGH')
					{
						var st_critical = Ext.getCmp('filtermenu_Critical');
						if(st_critical.isDisabled()){
							st_critical.setValue(true);
							st_critical.setDisabled(false);
						}
					}
				}
			}

			if(!Ext.isEmpty(remove_el)){
				for (var a in remove_el )
				{
					var st = remove_el[a];
					if(st=='GOOD')
					{
						var st_good = Ext.getCmp('filtermenu_Normal');
						st_good.setValue(false);
						st_good.setDisabled(true);
						
					}
					else if(st=='UNKNOWN')
					{
						var st_unknown = Ext.getCmp('filtermenu_Unknown');
						st_unknown.setValue(false);
						st_unknown.setDisabled(true);
					}
					else if(st=='LOW')
					{
						var st_minor = Ext.getCmp('filtermenu_Minor');
						st_minor.setValue(false);
						st_minor.setDisabled(true);
					}
					else if(st=='INTERMEDIATE')
					{
						var st_major = Ext.getCmp('filtermenu_Major');
						st_major.setValue(false);
						st_major.setDisabled(true);
					}
					else if(st=='HIGH')
					{
						var st_critical = Ext.getCmp('filtermenu_Critical');
						st_critical.setValue(false);
						st_critical.setDisabled(true);
					}
				}
			}

		}
		catch (w)
		{
		}
	},
	clearMap:function(me){
		try
		{
			var disableArrfea=[];
			var disableArricon=[];

			
			if(!Ext.isEmpty(me)){
				disableArrfea = me.feauturesArray;
				disableArricon = me.markerArray;

				if(!Ext.isEmpty(disableArrfea)){
					for(var c in disableArrfea){
						for (var l in disableArrfea[c] )
						{
							disableArrfea[c][l].setMap(null);
						}
					}
					me.feauturesArray=[];
				}

				if(!Ext.isEmpty(disableArricon)){
					for(var c in disableArricon)
						disableArricon[c].setMap(null);
					me.markerArray=[];
				}

				me.infoBoxArray=[];
			}
			
		}
		catch (e)
		{
		}
	},
	createMap: function(center, marker) {
		var me = this;

		try
		{
			options = Ext.apply({}, this.mapOptions);
			options = Ext.applyIf(options, {
				zoom: me.zoom,
				center: center,
				disableDefaultUI: true,
				mapTypeControl: false,
				scaleControl: false,
				backgroundColor: 'none',
				minZoom:1,
				draggable:true,
				zoomControl: false,
				zoomControlOptions: {
				  style: google.maps.ZoomControlStyle.LARGE 
				},
				mapTypeControlOptions: {
						mapTypeIds: []
				},
				mapTypeId: me.mapType
			});
			
			me.gmap = new google.maps.Map(me.body.dom, options);
			me.styleMap();
			me.setmapFixedView(me);
		}
		catch (e)
		{
			this.add({
				xtype:'panel',
				autoDestroy:true,
				layout:'fit',
				//layout:{type:'vbox',align:'stretch',pack:'center'},
				//mapData:null,
				border:false,
				//style:{'border':'1px solid blue'},
				cls: 'datapanel1',
				align:'center',
				id:'errMapIds',
				//flex:1,
				html:'<center><div style="margin:20% 0 auto 0"><img class="iconInformation" src="/final/images/spacer.gif"/><div class="commonErrorMsgText">No internet connection to display Geo Map</div></div></center>'
			});
			return;
		}
        
		// @adding the Header
		if(me.controllersShow){
			
			Ext.create('RumAppFlow.view.GeoMapControls', {
				//style:{"border":"1px solid brown !important"},
				id:'geoMapControls-'+me.id,
				margin:'-25px 10px 0 10px',
				renderTo:'geo_map_header_id'
			});

			//@appending the zoom buttons
			//$('#'+me.id+'-body').append('<div class="gmap_control"><div id="zoomout" title="Zoom in" class="zoombt">+</div><div title="Zoom out" id="zoomin" class="zoombt">-</div></div><div title="Filters" id="mapfilter" class="gmap_filters"><span>_<br>_<br>_</span></div><div style="class="filter_menu" id="filter_menu"></div>');
			$('#'+this.id+'-body').append('<div class="gmap_control" style="top: 0 !important"><div id="zoomout" title="Zoom in" class="zoombt zoomout"><span>+</span></div><div title="Zoom out" id="zoomin" class="zoombt zoomin"><span>-</span></div></div><div title="Filters" id="mapfilter" class="gmap_filters"><span class="geomap_filter_menu"></span></div><div class="filter_menu" id="filter_menu"></div>');
			me.mapControl();

		}

		try
		{
			google.maps.event.addListener(me.gmap, 'click', function(e) {
				//alert('map click ----4---');
				var tooltip1 = $("#filtermenu");
				if(!Ext.isEmpty(tooltip1))
					tooltip1.hide();		
			});	
		}
		catch (e)
		{
		}
		
			

		var data = me.jsonData;
		var mapMode = data.mapMode;
		if(mapMode != undefined && mapMode != null && mapMode != "" && mapMode != "Country")
			me.updateData(data);
		else
			me.loadMapDetails(me);

		//me.loadMapDetails(me);
    },
	mapControl:function() {
		 var me = this,map= this.gmap,
		filtermenu = Ext.create('RumAppFlow.view.GeoMapFliters',{
					renderTo:'filter_menu',
					id:'filtermenu',
					hidden:true,
					map:me,
			});
		 $('body').on( "click","#zoomin",function() {
		   var currentZoomLevel = map.getZoom();
		   if(currentZoomLevel != 0){
				map.setZoom(currentZoomLevel - 1);}     
		  });

		 $('body').on( "click","#zoomout",function() {
		   var currentZoomLevel = map.getZoom();
		   if(currentZoomLevel != 21){
				map.setZoom(currentZoomLevel + 1);}
		  });
		 $('#mapfilter').click(function(){
				$( "#filtermenu").slideToggle( "slow");	
		 });		 
	},
	refreshMapDetails:function(me){
		try
		{
			var data = me.jsonData;
			var colorArray = [];
			if(!Ext.isEmpty(data) && !Ext.isEmpty(data.colorArray) )
				colorArray = data.colorArray;

			var jsonArray = [];
			if(!Ext.isEmpty(data) && !Ext.isEmpty(data.resultArray) )
				jsonArray = data.resultArray;
			
			var stateArray = [];
			if(!Ext.isEmpty(data) && !Ext.isEmpty(data.stateArray) )
				stateArray = data.stateArray;

			me.stateCheck(me,stateArray);
			me.stateArray=stateArray;
			if (!Ext.isEmpty( jsonArray))
			{
				var colorClass;
				var markerLocation;

				if(jsonArray.length > 0)
				{
					Ext.getCmp('filtermenu_Response_Time').setValue(true);
					Ext.getCmp('filtermenu_Requests').setValue(true);
					Ext.getCmp('filtermenu_Response_Time').setDisabled(false);
					Ext.getCmp('filtermenu_Requests').setDisabled(false);
				}
				
				if(!Ext.isEmpty(stateArray)){
					for (var a in stateArray )
					{
						var st = stateArray[a];
						if(st=='GOOD')
						{
							Ext.getCmp('filtermenu_Normal').setValue(true);
							Ext.getCmp('filtermenu_Normal').setDisabled(false);
						}
						else if(st=='UNKNOWN')
						{
							Ext.getCmp('filtermenu_Unknown').setValue(true);
							Ext.getCmp('filtermenu_Unknown').setDisabled(false);
						}
						else if(st=='LOW')
						{
							Ext.getCmp('filtermenu_Minor').setValue(true);
							Ext.getCmp('filtermenu_Minor').setDisabled(false);
						}
						else if(st=='INTERMEDIATE')
						{
							Ext.getCmp('filtermenu_Major').setValue(true);
							Ext.getCmp('filtermenu_Major').setDisabled(false);
						}
						else if(st=='HIGH')
						{
							Ext.getCmp('filtermenu_Critical').setValue(true);
							Ext.getCmp('filtermenu_Critical').setDisabled(false);
						}
					}
				}

				for(var item=0; item<jsonArray.length; item++)
				{
					var jsonItem=jsonArray[item];
					var tempCon = new Array();
					tempCon.push(jsonItem.DispInfo);
					tempCon.push(jsonItem.CountryCode);
					tempCon.push(jsonItem.magnitude);
					tempCon.push(jsonItem.RealInfo);
					tempCon.push(jsonItem.State);
					tempCon.push(jsonItem.CountryLAT);
					tempCon.push(jsonItem.CountryLNG);
					tempCon.push(jsonItem.LocDetails);
					tempCon.push(jsonItem.BottomLocDetails);
					try
					{
						colorClass =colorArray[jsonItem.Info];	
					}
					catch (w)
					{
					}

					if(jsonItem.CountryCode == 'NIL' )
						continue;
					
					markerLocation = null;
					markerLocation = { lat: parseFloat(jsonItem.CountryLAT), lng: parseFloat(jsonItem.CountryLNG)};
					
					var infobox = new InfoBox({
						content: "",
						 //disableAutoPan: true,
						 //maxWidth: "340px",
						 pixelOffset: new google.maps.Size(-167, -30),
						 zIndex: null,
						 boxStyle: {
							border: "0px solid orange",
							//background: "url('https://google-maps-utility-library-v3.googlecode.com/svn/trunk/infobox/examples/tipbox.gif') no-repeat",
							opacity: 1.0,
							width: "auto",
							margin:"25 0 0 0"
						},
						closeBoxMargin: "7px 7px 0px 0px", //-108px -58px 2px 2px  - Normal:12px 4px 2px 2px   -58px 130px 2px 2px
						closeBoxURL: "/final/images/Light/iconMapClose.png",
						infoBoxClearance: new google.maps.Size(1, 1)
					});


					me.infoBoxArray.push(infobox);
					var onclickText='';
					var UEDclickText="";
					var moveNext='';
					
					onclickText =" onclick=\"moveNext('"+me.mapMode+"','"+jsonItem.CountryCode+"','"+jsonItem.Info+"')\" ";
					
					var locDetailsDiv="";
					var info_height="height:100px";
					if(jsonItem.BottomLocDetails.length>3)
						info_height="height:150px";
					//locDetailsDiv = locDetailsDiv+"<div id='infobox' style='width:340px;"+info_height+";'>";
					locDetailsDiv = locDetailsDiv+"<div id='infobox' class='google_infobox'  style='width:335px'>";
					locDetailsDiv = locDetailsDiv+"<div style='position: absolute;top: -10px;left: 157px;'><img src='/final/images/"+strRumSkin+"/iconMapArrow.png'/></div><ul class='rumMapData infoboxheader'>";

					//locDetailsDiv = locDetailsDiv+"<li><div  data-qclass='yellowTip' "+onclickText+" data-qtip='"+jsonItem.DispInfo+"' ><table cellspacing='0' cellpadding='0' border='1'><tr><td><img data-qclass='yellowTip' data-qtip='"+jsonItem.DispInfo+"' src='/final/images/clear.png' class='state_"+jsonItem.State+"' width='15' height='15' border='0' style='margin-left:5px'/></td><td style='padding:1px 0 0 5px;width:185px;font-size:18px;text-align:left;color:"+jsonItem.StateCode+" !important;white-space: nowrap'><div class='mouse' title='"+jsonItem.DispInfo+"' style='text-overflow:ellipsis;width:185px;overflow:hidden;text-align:left !important'>"+jsonItem.DispInfo+"</div></td></tr></table></div></li>";
					locDetailsDiv = locDetailsDiv+"<li class='headerList'><div  class='header_content'   data-qclass='yellowTip' "+onclickText+" data-qtip='"+jsonItem.DispInfo+"' ><table cellspacing='0' cellpadding='0' border='0' style='table-layout:auto;width:auto'><tr><td class='gtitle'  style='text-align:left;color:"+jsonItem.StateCode+" !important;white-space: nowrap'><div class='mouse' title='"+jsonItem.DispInfo+"' style='text-overflow:ellipsis;overflow:hidden;text-align:left !important;padding-left: 5px;'>"+jsonItem.DispInfo+"</div></td><td class='header' style='padding:1px 0 0 5px;width:47px;text-align:left;white-space: nowrap'><div title='Click here to Users View' data-qtip='Click here to Users View' data-qclass='yellowTip' class='mouse iconUxUser' "+UEDclickText+" style='position:absolute;margin-top:-8px;left:91.5%;text-overflow:ellipsis;overflow:hidden;text-align:left !important;display:none !important;'>&nbsp;</div></td></tr></table></div></li>";


					if(jsonItem.HeaderMeasureName!=null && jsonItem.HeaderMeasureName!=undefined && jsonItem.HeaderMeasureName!="")
					{
						if(!Ext.isEmpty(jsonItem.DD_URL) && jsonItem.DD_URL!=null && jsonItem.DD_URL!=undefined)
						{
							locDetailsDiv = locDetailsDiv+"<li class='infocontentlist'><span style='font-size:17px;text-transform:lowercase;color:#000;font-weight:bold' class='rumVisitsText'>"+jsonItem.HeaderMeasureValue+"</span>&nbsp;"+jsonItem.HeaderMeasureDispName+"</li>";
						}
						else
						{
							locDetailsDiv = locDetailsDiv+"<li class='infocontentlist'><span style='font-size:17px;text-transform:lowercase;color:#000;font-weight:bold' > "+jsonItem.HeaderMeasureValue+"</span>&nbsp;"+jsonItem.HeaderMeasureDispName+"</li>";
						}
					}

					locDetailsDiv = locDetailsDiv+"</ul>";
					locDetailsDiv = locDetailsDiv+"<div  class='info_overflow'><ul class='rumMapData' style='list-style:none;margin:0px;padding:0px;display:inline-block;line-height:1.5em;'>";
					// Preparing the content to be shown on the popup window
					// || jsonDetailsItem.MeasureDispName == 'Apdex Score'
					for(var d=0; d<jsonItem.BottomLocDetails.length; d++)
					{
						var jsonDetailsItem=jsonItem.BottomLocDetails[d];
						if(jsonDetailsItem!=null && jsonDetailsItem!=undefined)
						{
							var mapInfoMeasure = jsonDetailsItem.MeasureDispName;
							
							if(jsonDetailsItem.MeasureUnit.toLowerCase() == 'milliseconds')
								jsonDetailsItem.MeasureUnit=' ms';

							if(jsonDetailsItem.MeasureUnit == 'Seconds')
								jsonDetailsItem.MeasureUnit=' S';

							if(!Ext.isEmpty(jsonDetailsItem.DD_URL) && jsonDetailsItem.DD_URL!=null && jsonDetailsItem.DD_URL!=undefined)
							{
								//locDetailsDiv = locDetailsDiv+"<li class='infocontentlist'><div style='display:table;margin:auto'><img style='vertical-align: text-bottom;' src='/final/images/clear.png'  class='stateSymbol_"+jsonDetailsItem.State+"'/><span class ='value' style='text-transform:lowercase;' class='rumVisitsText'>"+jsonDetailsItem.MeasureValue+"</span><span class ='unit'>"+jsonDetailsItem.MeasureUnit+" </span></div><div class='url'></div><span style='display:block'>"+jsonDetailsItem.MeasureDispName+"</span></li>";
								locDetailsDiv = locDetailsDiv+"<li class='infocontentlist'><div style='' class='d_m_b10'><img style='vertical-align: text-bottom;margin-left:-5px' src='/final/images/clear.png'  class='stateSymbol_"+jsonDetailsItem.State+"'/><span class ='value' style='text-transform:lowercase;' class='rumVisitsText'>"+jsonDetailsItem.MeasureValue+"</span><span class ='unit'>"+jsonDetailsItem.MeasureUnit+" </span></div><div><span  class='displayname'>"+jsonDetailsItem.MeasureDispName+"</span></div></li>";
							}
							else
							{
								//locDetailsDiv = locDetailsDiv+"<li class='infocontentlist'><div style='display:table;margin:auto'><img style='vertical-align: text-bottom;' src='/final/images/clear.png'  class='stateSymbol_"+jsonDetailsItem.State+"'/><span class ='value' style='text-transform:lowercase;'> "+jsonDetailsItem.MeasureValue+"</span><span class ='unit'>"+jsonDetailsItem.MeasureUnit+" </span></div><div class='url'></div><span style='display:block'>"+jsonDetailsItem.MeasureDispName+"</span></li>";
								locDetailsDiv = locDetailsDiv+"<li class='infocontentlist'><div style='' class='d_m_b10'><img style='vertical-align: text-bottom;margin-left:-5px' src='/final/images/clear.png'  class='stateSymbol_"+jsonDetailsItem.State+"'/><span class ='value' style='text-transform:lowercase;'> "+jsonDetailsItem.MeasureValue+"</span><span class ='unit'>"+jsonDetailsItem.MeasureUnit+" </span></div><div><span  class='displayname'>"+jsonDetailsItem.MeasureDispName+"</span></div></li>";
							}
						}
					}
					locDetailsDiv = locDetailsDiv+"</ul></div>";
					locDetailsDiv = locDetailsDiv+"</div>";


					if (Ext.isEmpty( jsonItem.CountryCode))
					{
						tempCon.push("No_Code");
					}
					else
					{
						tempCon.push(jsonItem.CountryCode);
						var xhr = new XMLHttpRequest();
						
						var url = "geojson/"+jsonItem.CountryCode+".geojson" ;
						xhr.open('GET', url, false);
						var style = GRAY;
						if(jsonItem.State == "HIGH")
							style = HIGH;
						else if(jsonItem.State == "INTERMEDIATE")
							style = INTERMEDIATE;
						else if(jsonItem.State == "LOW")
							style = LOW;
						else if(jsonItem.State == "UNKNOWN")
							style = UNKNOWN;
						else if(jsonItem.State == "GOOD")
							style = GOOD;
						
						xhr.onload = function() {
							if(xhr.status == 200)
								me.loadGeoJSON(me,xhr.responseText,style,infobox,markerLocation,locDetailsDiv,tempCon,colorClass);
							
						};
						xhr.send();
					}
				}
				me.addZoomChangeListener(me);
			}
			me.setmapFixedView(me);
			//me.gmap.setZoom(1);
			//me.filterCheck(me);
		}
		catch (e)
		{
		}
		me.zoomLevel = me.gmap.getZoom();
	},
	makeFilterDisable:function(){
		try
		{
			Ext.getCmp('filtermenu_Response_Time').setValue(false);
			Ext.getCmp('filtermenu_Requests').setValue(false);
			Ext.getCmp('filtermenu_Response_Time').setDisabled(true);
			Ext.getCmp('filtermenu_Requests').setDisabled(true);

			Ext.getCmp('filtermenu_Normal').setValue(false);
			Ext.getCmp('filtermenu_Normal').setDisabled(true);

			Ext.getCmp('filtermenu_Minor').setValue(false);
			Ext.getCmp('filtermenu_Minor').setDisabled(true);

			Ext.getCmp('filtermenu_Unknown').setValue(false);
			Ext.getCmp('filtermenu_Unknown').setDisabled(true);

			Ext.getCmp('filtermenu_Major').setValue(false);
			Ext.getCmp('filtermenu_Major').setDisabled(true);

			Ext.getCmp('filtermenu_Critical').setValue(false);
			Ext.getCmp('filtermenu_Critical').setDisabled(true);
		}
		catch (e)
		{
		}
	},
	loadMapDetails:function(me){
		try
		{
			me.removeAllListeners(me);
			var data = me.jsonData;
			var mapMode = data.mapMode;
			me.mapMode=mapMode;
			var colorArray = [];
			if(!Ext.isEmpty(data) && !Ext.isEmpty(data.colorArray) )
				colorArray = data.colorArray;
			var jsonArray = [];
			if(!Ext.isEmpty(data) && !Ext.isEmpty(data.resultArray) )
				jsonArray = data.resultArray;
			
			var stateArray = [];
			if(!Ext.isEmpty(data) && !Ext.isEmpty(data.stateArray) )
				stateArray = data.stateArray;

			me.stateArray=stateArray;
			var latlangBounds = [];
			if (!Ext.isEmpty( jsonArray))
			{
				var colorClass;
				var markerLocation;
				if(jsonArray.length > 0){
					Ext.getCmp('filtermenu_Response_Time').setValue(true);
					Ext.getCmp('filtermenu_Requests').setValue(true);
					Ext.getCmp('filtermenu_Response_Time').setDisabled(false);
					Ext.getCmp('filtermenu_Requests').setDisabled(false);
				}

				if(!Ext.isEmpty(stateArray)){
					for (var a in stateArray )
					{
						var st = stateArray[a];
						if(st=='GOOD')
						{
							Ext.getCmp('filtermenu_Normal').setValue(true);
							Ext.getCmp('filtermenu_Normal').setDisabled(false);
						}
						else if(st=='UNKNOWN')
						{
							Ext.getCmp('filtermenu_Unknown').setValue(true);
							Ext.getCmp('filtermenu_Unknown').setDisabled(false);
						}
						else if(st=='LOW')
						{
							Ext.getCmp('filtermenu_Minor').setValue(true);
							Ext.getCmp('filtermenu_Minor').setDisabled(false);
						}
						else if(st=='INTERMEDIATE')
						{
							Ext.getCmp('filtermenu_Major').setValue(true);
							Ext.getCmp('filtermenu_Major').setDisabled(false);
						}
						else if(st=='HIGH')
						{
							Ext.getCmp('filtermenu_Critical').setValue(true);
							Ext.getCmp('filtermenu_Critical').setDisabled(false);
						}
					}
				}
				

				var countryComboObj = Ext.getCmp('countryComboId');
				try
				{
					countryComboObj.getStore().loadRawData(data.countryArray);
					countryComboObj.setValue(data.selectedCountry);
					countryComboObj.show();
				}
				catch (e)
				{
					alert(e)
				}
				for(var item=0; item<jsonArray.length; item++)
				{
					var jsonItem=jsonArray[item];
					var tempCon = new Array();
					tempCon.push(jsonItem.DispInfo);
					tempCon.push(jsonItem.CountryCode);
					tempCon.push(jsonItem.magnitude);
					tempCon.push(jsonItem.RealInfo);
					tempCon.push(jsonItem.State);
					tempCon.push(jsonItem.CountryLAT);
					tempCon.push(jsonItem.CountryLNG);
					tempCon.push(jsonItem.LocDetails);
					tempCon.push(jsonItem.BottomLocDetails);
					
					try
					{
						colorClass =colorArray[jsonItem.Info];	
					}
					catch (w)
					{
					}
					

					if(jsonItem.CountryCode == 'NIL' )
						continue;
					
					markerLocation = null;
					markerLocation = { lat: parseFloat(jsonItem.CountryLAT), lng: parseFloat(jsonItem.CountryLNG)};
					latlangBounds.push(markerLocation);
					var infobox = new InfoBox({
						content: "",
						 //disableAutoPan: true,
						 //maxWidth: "340px",
						 pixelOffset: new google.maps.Size(-167, -30),
						 zIndex: null,
						 boxStyle: {
							border: "0px solid red",
							//background: "url('https://google-maps-utility-library-v3.googlecode.com/svn/trunk/infobox/examples/tipbox.gif') no-repeat",
							opacity: 1.0,
							width: "auto",
							margin:"25 0 0 0"
						},
						closeBoxMargin: "7px 7px 0px 0px", //-108px -58px 2px 2px  - Normal:12px 4px 2px 2px   -58px 130px 2px 2px
						closeBoxURL: "/final/images/Light/iconMapClose.png",
						infoBoxClearance: new google.maps.Size(1, 1)
					});


					me.infoBoxArray.push(infobox);
					var onclickText='';
					var UEDclickText ="";
					onclickText =" onclick=\"moveNext('"+me.mapMode+"','"+jsonItem.CountryCode+"','"+jsonItem.combo+"')\" ";

					var locDetailsDiv="";
					var info_height="height:100px";
					if(jsonItem.BottomLocDetails.length>3)
						info_height="height:150px";
						locDetailsDiv = locDetailsDiv+"<div id='infobox' class='google_infobox'  style='width:335px'>";
					locDetailsDiv = locDetailsDiv+"<div style='position: absolute;top: -10px;left: 157px;'><img src='/final/images/"+strRumSkin+"/iconMapArrow.png'/></div><ul class='rumMapData infoboxheader'>";


					//locDetailsDiv = locDetailsDiv+"<li><div  data-qclass='yellowTip' "+onclickText+" data-qtip='"+jsonItem.DispInfo+"' ><table cellspacing='0' cellpadding='0' border='0'><tr><td><img data-qclass='yellowTip' data-qtip='"+jsonItem.DispInfo+"' src='/final/images/clear.png' class='state_"+jsonItem.State+"' width='15' height='15' border='0' style='margin-left:5px'/></td><td style='padding:1px 0 0 5px;width:185px;font-size:18px;text-align:left;color:"+jsonItem.StateCode+" !important;white-space: nowrap'><div class='mouse' title='"+jsonItem.DispInfo+"' style='text-overflow:ellipsis;width:185px;overflow:hidden;text-align:left !important'>"+jsonItem.DispInfo+"</div></td></tr></table></div></li>";

						locDetailsDiv = locDetailsDiv+"<li class='headerList'><div  class='header_content' data-qclass='yellowTip' "+onclickText+" data-qtip='"+jsonItem.DispInfo+"' ><table cellspacing='0' cellpadding='0' border='0' style='table-layout:auto;width:auto'><tr><td class='gtitle' style='width:100%;text-align:left;color:"+jsonItem.StateCode+" !important;white-space: nowrap'><div class='mouse' title='"+jsonItem.DispInfo+"' style='text-overflow:ellipsis;overflow:hidden;text-align:left !important;padding-left: 5px;'>"+jsonItem.DispInfo+"</div></td><td class='header' style='display:inline-block;float:left;padding:4px 0 0 0px;width:47px;white-space: nowrap'><div title='Click here to Users View' data-qtip='Click here to Users View' data-qclass='yellowTip' class='mouse iconUxUser' "+UEDclickText+" style='position:absolute;left:91.5%;float:right;margin-top:-17px;text-overflow:ellipsis;overflow:hidden;text-align:left !important;display:none !important;'>&nbsp;</div></td></tr></table></div></li>";


					if(jsonItem.HeaderMeasureName!=null && jsonItem.HeaderMeasureName!=undefined && jsonItem.HeaderMeasureName!="")
					{
						if(!Ext.isEmpty(jsonItem.DD_URL) && jsonItem.DD_URL!=null && jsonItem.DD_URL!=undefined)
						{
							locDetailsDiv = locDetailsDiv+"<li style='padding-top:4px;white-space:normal;display:inline-block;float:left;text-align:right'><span style='font-size:17px;text-transform:lowercase;font-weight:bold' class='rumVisitsText'>"+jsonItem.HeaderMeasureValue+"</span>&nbsp;"+jsonItem.HeaderMeasureDispName+"</li>";
						}
						else
						{
							locDetailsDiv = locDetailsDiv+"<li style='padding-top:4px;white-space:normal;display:inline-block;float:left;text-align:right'><span style='font-size:17px;text-transform:lowercase;font-weight:bold' > "+jsonItem.HeaderMeasureValue+"</span>&nbsp;"+jsonItem.HeaderMeasureDispName+"</li>";
						}
					}

					locDetailsDiv = locDetailsDiv+"</ul>";
					locDetailsDiv = locDetailsDiv+"<div class='info_overflow'><ul class='rumMapData' style='list-style:none;margin:0px;padding:0px;display:inline-block;line-height:1.5em;'>";
					// Preparing the content to be shown on the popup window
					// || jsonDetailsItem.MeasureDispName == 'Apdex Score'
					for(var d=0; d<jsonItem.BottomLocDetails.length; d++)
					{
						var jsonDetailsItem=jsonItem.BottomLocDetails[d];
						if(jsonDetailsItem!=null && jsonDetailsItem!=undefined)
						{
							var mapInfoMeasure = jsonDetailsItem.MeasureDispName;
							
							if(jsonDetailsItem.MeasureUnit.toLowerCase() == 'milliseconds')
								jsonDetailsItem.MeasureUnit=' ms';
							
							if(jsonDetailsItem.MeasureUnit == 'Seconds')
								jsonDetailsItem.MeasureUnit=' S';

							if(!Ext.isEmpty(jsonDetailsItem.DD_URL) && jsonDetailsItem.DD_URL!=null && jsonDetailsItem.DD_URL!=undefined)
							{
								//locDetailsDiv = locDetailsDiv+"<li style='text-align:center;padding:3px 8px 10px 8px;white-space:normal;display:inline-block;float:left'><span style='font-size:17px;font-weight:bold;text-transform:lowercase;color:"+jsonDetailsItem.StateCode+" !important;' class='rumVisitsText'> "+jsonDetailsItem.MeasureValue+" "+jsonDetailsItem.MeasureUnit+" </span><br/>"+jsonDetailsItem.MeasureDispName+"</li>";

								locDetailsDiv = locDetailsDiv+"<li  class='infocontentlist'><div style='' class='d_m_b10'><img style='vertical-align: text-bottom;margin-left:-5px' src='/final/images/clear.png' class='stateSymbol_"+jsonDetailsItem.State+"/><span class ='value' style='text-transform:lowercase;' class='rumVisitsText'>"+jsonDetailsItem.MeasureValue+"</span> <span class ='unit'>" +jsonDetailsItem.MeasureUnit+" </span></div><div><span class='displayname'>"+jsonDetailsItem.MeasureDispName+"</span></div></li>";
							}
							else
							{
								//locDetailsDiv = locDetailsDiv+"<li style='text-align:center;padding:0px 5px 0px 5px;white-space:normal;display:inline-block;float:left'><span style='font-size:17px;font-weight:bold;text-transform:lowercase;color:"+jsonDetailsItem.StateCode+" !important;'> "+jsonDetailsItem.MeasureValue+" "+jsonDetailsItem.MeasureUnit+" </span><br/>"+jsonDetailsItem.MeasureDispName+"</li>";

								locDetailsDiv = locDetailsDiv+"<li  class='infocontentlist'><div style='' class='d_m_b10'><img style='vertical-align: text-bottom;margin-right:-5px' src='/final/images/clear.png' class='stateSymbol_"+jsonDetailsItem.State+"'/><span class ='value' style='text-transform:lowercase;'> "+jsonDetailsItem.MeasureValue+"</span><span class ='unit'>" +jsonDetailsItem.MeasureUnit+" </span></div><div><span class='displayname'>"+jsonDetailsItem.MeasureDispName+"</span></div></li>";
							}
						}
					}
					locDetailsDiv = locDetailsDiv+"</ul></div>";
					locDetailsDiv = locDetailsDiv+"</div>";


					if (Ext.isEmpty( jsonItem.CountryCode))
					{
						tempCon.push("No_Code");
					}
					else
					{
						tempCon.push(jsonItem.CountryCode);
						var xhr = new XMLHttpRequest();
						
						var url = "geojson/"+jsonItem.CountryCode+".geojson" ;
						xhr.open('GET', url, false);
						var style = GRAY;
						if(jsonItem.State == "HIGH")
							style = HIGH;
						else if(jsonItem.State == "INTERMEDIATE")
							style = INTERMEDIATE;
						else if(jsonItem.State == "LOW")
							style = LOW;
						else if(jsonItem.State == "UNKNOWN")
							style = UNKNOWN;
						else if(jsonItem.State == "GOOD")
							style = GOOD;
						
						xhr.onload = function() {
							if(xhr.status == 200)
								me.loadGeoJSON(me,xhr.responseText,style,infobox,markerLocation,locDetailsDiv,tempCon,colorClass);
						};
						xhr.send();
					}
				}

				me.addZoomChangeListener(me);
			}
			//me.setmapBounds(latlangBounds,me);
			//me.setmapFixedView(me);
			//me.gmap.setZoom(1);
		}
		catch (e)
		{
			//console.log('aa==>',e)
		}
		me.zoomLevel = me.gmap.getZoom();		
	},
	loadRegionDetails:function(me){
		try
		{
			me.cb_json=[];
			me.cb_geo=[];
			
			var data = me.jsonData;
			var colorArray = [];
			if(!Ext.isEmpty(data) && !Ext.isEmpty(data.colorArray) )
				colorArray = data.colorArray;
			var jsonArray = [];
			if(!Ext.isEmpty(data) && !Ext.isEmpty(data.resultArray) )
				jsonArray = data.resultArray;
			
			var stateArray = [];
			if(!Ext.isEmpty(data) && !Ext.isEmpty(data.stateArray) )
				stateArray = data.stateArray;

			me.stateArray=stateArray;
			var latlangBounds = [];
			if (!Ext.isEmpty( jsonArray))
			{
				var colorClass;
				var markerLocation;

				Ext.getCmp('filtermenu_Response_Time').setValue(false);
				Ext.getCmp('filtermenu_Response_Time').setDisabled(true);

				Ext.getCmp('filtermenu_Requests').setValue(false);
				Ext.getCmp('filtermenu_Requests').setDisabled(true);
				if(jsonArray.length > 0){
					Ext.getCmp('filtermenu_Requests').setValue(true);
					Ext.getCmp('filtermenu_Requests').setDisabled(false);
				}

				if(!Ext.isEmpty(stateArray)){
					for (var a in stateArray )
					{
						var st = stateArray[a];
						if(st=='GOOD')
						{
							Ext.getCmp('filtermenu_Normal').setValue(true);
							Ext.getCmp('filtermenu_Normal').setDisabled(false);
						}
						else if(st=='UNKNOWN')
						{
							Ext.getCmp('filtermenu_Unknown').setValue(true);
							Ext.getCmp('filtermenu_Unknown').setDisabled(false);
						}
						else if(st=='LOW')
						{
							Ext.getCmp('filtermenu_Minor').setValue(true);
							Ext.getCmp('filtermenu_Minor').setDisabled(false);
						}
						else if(st=='INTERMEDIATE')
						{
							Ext.getCmp('filtermenu_Major').setValue(true);
							Ext.getCmp('filtermenu_Major').setDisabled(false);
						}
						else if(st=='HIGH')
						{
							Ext.getCmp('filtermenu_Critical').setValue(true);
							Ext.getCmp('filtermenu_Critical').setDisabled(false);
						}
					}
				}
				
				//TODO
				for(var item=0; item<jsonArray.length; item++)
				{
					var jsonItem=jsonArray[item];
					var tempCon = new Array();
					tempCon.push(jsonItem.DispInfo);
					tempCon.push(jsonItem.magnitude);
					tempCon.push(jsonItem.RealInfo);
					tempCon.push(jsonItem.State);
					tempCon.push(jsonItem.CountryLAT);
					tempCon.push(jsonItem.CountryLNG);
					tempCon.push(jsonItem.LocDetails);
					tempCon.push(jsonItem.BottomLocDetails);
					
					
					try
					{
						colorClass =colorArray[jsonItem.Info];	
					}
					catch (w)
					{
					}
					

					
					
					var onclickText =" onclick=\"moveNext('"+me.mapMode+"','"+jsonItem.CountryCode+"','"+jsonItem.combo+"')\" ";
					var className = 'mouse';
					if(me.mapMode != undefined && me.mapMode == 'City')
					{
						onclickText='';
						className='';
					}

					var locDetailsDiv="";
					var info_height="height:100px";
					var UEDclicktext="";

					if(jsonItem.BottomLocDetails.length>3)
						info_height="height:150px";
					//locDetailsDiv = locDetailsDiv+"<div id='infobox' style='width:340px;"+info_height+";'>";
					locDetailsDiv = locDetailsDiv+"<div id='infobox' class='google_infobox'  style='width:335px'>";
					//locDetailsDiv = locDetailsDiv+"<ul class='rumMapData' style='list-style:none;margin:0px;padding:3px 0 10px 0;height:27px;border-bottom:1px solid #cccccc'>";


					locDetailsDiv = locDetailsDiv+"<div style='position: absolute;top: -10px;left: 157px;'><img src='/final/images/"+strRumSkin+"/iconMapArrow.png'/></div><ul class='rumMapData infoboxheader'>";

					
					//locDetailsDiv = locDetailsDiv+"<li><div  data-qclass='yellowTip' "+onclickText+" data-qtip='"+jsonItem.DispInfo+"' ><table cellspacing='0' cellpadding='0' border='0' style='table-layout:auto;width:auto'><tr><td class='header' style='width:100%;display:inline-block;float:left;padding:4px 0 0 5px;text-align:left;color:"+jsonItem.StateCode+" !important;white-space: nowrap'><div class='mouse' title='"+jsonItem.DispInfo+"' style='margin-top:-3px;text-overflow:ellipsis;overflow:hidden;text-align:left !important'>"+jsonItem.DispInfo+"</div></td><td class='header' style='display:inline-block;float:left;padding:4px 0 0 0px;width:47px;white-space: nowrap'><div class='mouse iconUxUser' "+UEDclickText+"style='position:absolute;left:86%;float:right;margin-top:-17px;text-overflow:ellipsis;overflow:hidden;text-align:left !important'>&nbsp;</div></td></tr></table></div></li>";

					locDetailsDiv = locDetailsDiv+"<li class='headerList'><div  class='header_content'  "+onclickText+" data-qtip='"+jsonItem.DispInfo+"' ><table cellspacing='0' cellpadding='0' border='0' style='table-layout:auto;width:auto'><tr><td class='gtitle' style='width:100%;color:"+jsonItem.StateCode+" !important;white-space: nowrap'><div class='"+className+"' title='"+jsonItem.DispInfo+"' style='text-overflow:ellipsis;overflow:hidden;text-align:left !important;padding-left: 5px;'>"+jsonItem.DispInfo+"</div></td><td class='header' style='display:inline-block;float:left;padding:4px 0 0 5px;text-align:left;white-space: nowrap'><div title='Click here to Users View' data-qtip='Click here to Users View' data-qclass='yellowTip' class='mouse iconUxUser' "+UEDclicktext+" style='position:absolute;left:91.5%;float:right;margin-top:-17px;text-overflow:ellipsis;overflow:hidden;text-align:left !important;display:none !important'>&nbsp;</div></td></tr></table></div></li>";


					if(jsonItem.HeaderMeasureName!=null && jsonItem.HeaderMeasureName!=undefined && jsonItem.HeaderMeasureName!="")
					{
						if(!Ext.isEmpty(jsonItem.DD_URL) && jsonItem.DD_URL!=null && jsonItem.DD_URL!=undefined)
						{
							locDetailsDiv = locDetailsDiv+"<li style='padding-top:4px;white-space:normal;display:inline-block;float:left;text-align:right'><span style='font-size:17px;text-transform:lowercase;color:#000;font-weight:bold' class='rumVisitsText'>"+jsonItem.HeaderMeasureValue+"</span>&nbsp;"+jsonItem.HeaderMeasureDispName+"</li>";
						}
						else
						{
							locDetailsDiv = locDetailsDiv+"<li style='padding-top:4px;white-space:normal;display:inline-block;float:left;text-align:right'><span style='font-size:17px;text-transform:lowercase;color:#000;font-weight:bold' > "+jsonItem.HeaderMeasureValue+"</span>&nbsp;"+jsonItem.HeaderMeasureDispName+"</li>";
						}
					}

					locDetailsDiv = locDetailsDiv+"</ul><div  class='info_overflow'>";
					locDetailsDiv = locDetailsDiv+"<ul class='rumMapData' style='	list-style:none;margin:0px;padding:0px;display:inline-block;line-height:1.5em;'>";
					// Preparing the content to be shown on the popup window
					// || jsonDetailsItem.MeasureDispName == 'Apdex Score'
					for(var d=0; d<jsonItem.BottomLocDetails.length; d++)
					{
						var jsonDetailsItem=jsonItem.BottomLocDetails[d];
						if(jsonDetailsItem!=null && jsonDetailsItem!=undefined)
						{
							var mapInfoMeasure = jsonDetailsItem.MeasureDispName;
							
							if(jsonDetailsItem.MeasureUnit.toLowerCase() == 'milliseconds')
								jsonDetailsItem.MeasureUnit=' ms';

							if(jsonDetailsItem.MeasureUnit == 'Seconds')
								jsonDetailsItem.MeasureUnit=' S';

							//locDetailsDiv = locDetailsDiv+"<li style='text-align:center;padding:0px 8px 0px 8px;white-space:normal;display:inline-block;float:left'><div style='float:left' class='stateSymbol_"+jsonDetailsItem.State+"'></div><span class ='value' style='text-transform:lowercase;'> "+jsonDetailsItem.MeasureValue+"</span><span class ='unit'>"+jsonDetailsItem.MeasureUnit+" </span><br/><span style='margin-top:10px;display:block'>"+jsonDetailsItem.MeasureDispName+"</span></li>";

							if(!Ext.isEmpty(jsonDetailsItem.DD_URL) && jsonDetailsItem.DD_URL!=null && jsonDetailsItem.DD_URL!=undefined)
							{
								//locDetailsDiv = locDetailsDiv+"<li style='text-align:center;padding:3px 8px 10px 8px;white-space:normal;display:inline-block;float:left'><span style='font-size:17px;font-weight:bold;text-transform:lowercase;color:"+jsonDetailsItem.StateCode+" !important;' class='rumVisitsText'> "+jsonDetailsItem.MeasureValue+" "+jsonDetailsItem.MeasureUnit+" </span><br/>"+jsonDetailsItem.MeasureDispName+"</li>";

								locDetailsDiv = locDetailsDiv+"<li class='infocontentlist'><div style='' class='d_m_b10'><img style='vertical-align: text-bottom;margin-left:-5px' src='/final/images/clear.png'  class='stateSymbol_"+jsonDetailsItem.State+"'/><span class ='value' style='text-transform:lowercase;'> "+jsonDetailsItem.MeasureValue+"</span><span class ='unit'>"+jsonDetailsItem.MeasureUnit+" </span></div><div><span  class='displayname'>"+jsonDetailsItem.MeasureDispName+"</span></div></li>";
							}
							else
							{
								//locDetailsDiv = locDetailsDiv+"<li style='text-align:center;padding:0px 8px 0px 8px;white-space:normal;display:inline-block;float:left'><span style='font-size:17px;font-weight:bold;text-transform:lowercase;color:"+jsonDetailsItem.StateCode+" !important;'> "+jsonDetailsItem.MeasureValue+" "+jsonDetailsItem.MeasureUnit+" </span><br/>"+jsonDetailsItem.MeasureDispName+"</li>";

								locDetailsDiv = locDetailsDiv+"<li class='infocontentlist'><div style='display:table' class='d_m_b10'><img style='vertical-align: text-bottom;margin-left:-5px' src='/final/images/clear.png'  class='stateSymbol_"+jsonDetailsItem.State+"'/><span class ='value' style='text-transform:lowercase;'> "+jsonDetailsItem.MeasureValue+"</span><span class ='unit'>"+jsonDetailsItem.MeasureUnit+" </span></div><div><span  class='displayname'>"+jsonDetailsItem.MeasureDispName+"</span></div></li>";
							}
						}
					}
					locDetailsDiv = locDetailsDiv+"</ul></div>";
					locDetailsDiv = locDetailsDiv+"</div>";
					
					var geoLat = jsonItem.CountryLAT;
					var geoLan = jsonItem.CountryLNG;

					var combo = jsonItem.combo;

					var infobox = new InfoBox({
						content: locDetailsDiv,
						 //disableAutoPan: true,
						 //maxWidth: "340px",
						 pixelOffset: new google.maps.Size(-167, -30),
						 zIndex: null,
						 boxStyle: {
							border: "0px solid blue",
							
							opacity: 1.0,
							width: "auto",
							margin:"25 0 0 0"
						},
						closeBoxMargin: "7px 7px 0px 0px",//-108px -58px 2px 2px  - Normal:12px 4px 2px 2px   -58px 130px 2px 2px
						closeBoxURL: "/final/images/Light/iconMapClose.png",
						infoBoxClearance: new google.maps.Size(1, 1)
					});


					me.infoBoxArray.push(infobox);

					var wid,hit;
					var obj = getStyle(colorClass);
					if(obj != null && obj != undefined){
						wid=obj.width;
						hit=obj.height;
					}

					var markerLocation = null;
					markerLocation = { lat: parseFloat(geoLat), lng: parseFloat(geoLan)};
					latlangBounds.push(markerLocation);

					var centerMarker =  new MarkerWithLabel
					({
					   position: markerLocation,
					   draggable: false,
					   raiseOnDrag: false,
					   map: me.gmap,
					   labelAnchor: new google.maps.Point(2,8),//may be (0,5) --> if so then it display the label from center of bubble
					   labelClass: "labels", 
					   labelStyle: {opacity: 0.90, color:labelColor},
					   icon : image
					});


					var iconMarker =   new MarkerWithLabel({
						position: markerLocation,
						map: me.gmap,
						icon:image,
						draggable:false,
						labelAnchor: new google.maps.Point(wid,hit),
						labelContent: '',
						info:combo,
						labelClass:colorClass,
						infoBox:infobox,
						cm:centerMarker
					  });
					
					me.markerArray.push(iconMarker);

					var zl = google.maps.event.addListener(iconMarker, 'click',function(e)
							{
									me.access = this.info;
								//	code to open infoBox
								me.closeAllInfoBox();
								this.infoBox.open(me.gmap,this.cm);
								
							});
					
					me.listenerArray.push(zl);
					
				}

				me.setmapBounds(latlangBounds,me);
				me.addZoomChangeListener(me);
			}
			else
			{
					var countryComboObj = Ext.getCmp('countryComboId');
					var regionComboIdObj = Ext.getCmp('regionComboId');
					var _cname = countryComboObj.getValue();
					
					if(me.mapMode=='City')
					{
						moveNext('Country',_cname);
					}
					else if(me.mapMode=='Region')
					{
						countryComboObj.setValue('World');
						RumAppFlow.app.getController('Main').geoComboOnChange(countryComboObj);
					}
			}

			//me.setmapBounds(latlangBounds,me);
			//me.setmapFixedView(me);
			//me.gmap.setZoom(2);
		}
		catch (e)
		{
			//console.log('aa==>',e)
		}
		me.zoomLevel = me.gmap.getZoom();
	},
	loadRegionDetails_old:function(me){
		try
		{
			me.cb_json=[];
			me.cb_geo=[];
			
			var data = me.jsonData;
			var colorArray = [];
			if(!Ext.isEmpty(data) && !Ext.isEmpty(data.colorArray) )
				colorArray = data.colorArray;
			var jsonArray = [];
			if(!Ext.isEmpty(data) && !Ext.isEmpty(data.resultArray) )
				jsonArray = data.resultArray;
			
			var stateArray = [];
			if(!Ext.isEmpty(data) && !Ext.isEmpty(data.stateArray) )
				stateArray = data.stateArray;

			me.stateArray=stateArray;
			var latlangBounds = [];
			if (!Ext.isEmpty( jsonArray))
			{
				var colorClass;
				var markerLocation;

				Ext.getCmp('filtermenu_Response_Time').setValue(false);
				Ext.getCmp('filtermenu_Response_Time').setDisabled(true);

				Ext.getCmp('filtermenu_Requests').setValue(false);
				Ext.getCmp('filtermenu_Requests').setDisabled(true);
				if(jsonArray.length > 0){
					Ext.getCmp('filtermenu_Requests').setValue(true);
					Ext.getCmp('filtermenu_Requests').setDisabled(false);
				}

				if(!Ext.isEmpty(stateArray)){
					for (var a in stateArray )
					{
						var st = stateArray[a];
						if(st=='GOOD')
						{
							Ext.getCmp('filtermenu_Normal').setValue(true);
							Ext.getCmp('filtermenu_Normal').setDisabled(false);
						}
						else if(st=='UNKNOWN')
						{
							Ext.getCmp('filtermenu_Unknown').setValue(true);
							Ext.getCmp('filtermenu_Unknown').setDisabled(false);
						}
						else if(st=='LOW')
						{
							Ext.getCmp('filtermenu_Minor').setValue(true);
							Ext.getCmp('filtermenu_Minor').setDisabled(false);
						}
						else if(st=='INTERMEDIATE')
						{
							Ext.getCmp('filtermenu_Major').setValue(true);
							Ext.getCmp('filtermenu_Major').setDisabled(false);
						}
						else if(st=='HIGH')
						{
							Ext.getCmp('filtermenu_Critical').setValue(true);
							Ext.getCmp('filtermenu_Critical').setDisabled(false);
						}
					}
				}
				
				//TODO
				for(var item=0; item<jsonArray.length; item++)
				{
					var jsonItem=jsonArray[item];
					var tempCon = new Array();
					tempCon.push(jsonItem.DispInfo);
					tempCon.push(jsonItem.magnitude);
					tempCon.push(jsonItem.RealInfo);
					tempCon.push(jsonItem.State);
					tempCon.push(jsonItem.CountryLAT);
					tempCon.push(jsonItem.CountryLNG);
					tempCon.push(jsonItem.LocDetails);
					tempCon.push(jsonItem.BottomLocDetails);
					
					
					try
					{
						colorClass =colorArray[jsonItem.Info];	
					}
					catch (w)
					{
					}
					

					if(jsonItem.CountryCode == 'NIL' )
						continue;
					
					var onclickText =" onclick=\"moveNext('"+me.mapMode+"','"+jsonItem.CountryCode+"','"+jsonItem.combo+"')\" ";
					var className = 'mouse';
					if(me.mapMode != undefined && me.mapMode == 'City')
					{
						onclickText='';
						className='';
					}

					var locDetailsDiv="";
					var info_height="height:100px";
					var UEDclicktext="";

					if(jsonItem.BottomLocDetails.length>3)
						info_height="height:150px";
					//locDetailsDiv = locDetailsDiv+"<div id='infobox' style='width:340px;"+info_height+";'>";
					locDetailsDiv = locDetailsDiv+"<div id='infobox' class='google_infobox'  style='width:335px'>";
					//locDetailsDiv = locDetailsDiv+"<ul class='rumMapData' style='list-style:none;margin:0px;padding:3px 0 10px 0;height:27px;border-bottom:1px solid #cccccc'>";


					locDetailsDiv = locDetailsDiv+"<div style='position: absolute;top: -10px;left: 157px;'><img src='/final/images/"+strRumSkin+"/iconMapArrow.png'/></div><ul class='rumMapData infoboxheader'>";

					
					//locDetailsDiv = locDetailsDiv+"<li><div  data-qclass='yellowTip' "+onclickText+" data-qtip='"+jsonItem.DispInfo+"' ><table cellspacing='0' cellpadding='0' border='0' style='table-layout:auto;width:auto'><tr><td class='header' style='width:100%;display:inline-block;float:left;padding:4px 0 0 5px;text-align:left;color:"+jsonItem.StateCode+" !important;white-space: nowrap'><div class='mouse' title='"+jsonItem.DispInfo+"' style='margin-top:-3px;text-overflow:ellipsis;overflow:hidden;text-align:left !important'>"+jsonItem.DispInfo+"</div></td><td class='header' style='display:inline-block;float:left;padding:4px 0 0 0px;width:47px;white-space: nowrap'><div class='mouse iconUxUser' "+UEDclickText+"style='position:absolute;left:86%;float:right;margin-top:-17px;text-overflow:ellipsis;overflow:hidden;text-align:left !important'>&nbsp;</div></td></tr></table></div></li>";

					locDetailsDiv = locDetailsDiv+"<li class='headerList'><div  class='header_content'  "+onclickText+" data-qtip='"+jsonItem.DispInfo+"' ><table cellspacing='0' cellpadding='0' border='0' style='table-layout:auto;width:auto'><tr><td class='gtitle' style='width:100%;color:"+jsonItem.StateCode+" !important;white-space: nowrap'><div class='"+className+"' title='"+jsonItem.DispInfo+"' style='text-overflow:ellipsis;overflow:hidden;text-align:left !important;padding-left: 5px;'>"+jsonItem.DispInfo+"</div></td><td class='header' style='display:inline-block;float:left;padding:4px 0 0 5px;text-align:left;white-space: nowrap'><div title='Click here to Users View' data-qtip='Click here to Users View' data-qclass='yellowTip' class='mouse iconUxUser' "+UEDclicktext+" style='position:absolute;left:91.5%;float:right;margin-top:-17px;text-overflow:ellipsis;overflow:hidden;text-align:left !important;display:none !important'>&nbsp;</div></td></tr></table></div></li>";


					if(jsonItem.HeaderMeasureName!=null && jsonItem.HeaderMeasureName!=undefined && jsonItem.HeaderMeasureName!="")
					{
						if(!Ext.isEmpty(jsonItem.DD_URL) && jsonItem.DD_URL!=null && jsonItem.DD_URL!=undefined)
						{
							locDetailsDiv = locDetailsDiv+"<li style='padding-top:4px;white-space:normal;display:inline-block;float:left;text-align:right'><span style='font-size:17px;text-transform:lowercase;color:#000;font-weight:bold' class='rumVisitsText'>"+jsonItem.HeaderMeasureValue+"</span>&nbsp;"+jsonItem.HeaderMeasureDispName+"</li>";
						}
						else
						{
							locDetailsDiv = locDetailsDiv+"<li style='padding-top:4px;white-space:normal;display:inline-block;float:left;text-align:right'><span style='font-size:17px;text-transform:lowercase;color:#000;font-weight:bold' > "+jsonItem.HeaderMeasureValue+"</span>&nbsp;"+jsonItem.HeaderMeasureDispName+"</li>";
						}
					}

					locDetailsDiv = locDetailsDiv+"</ul><div  class='info_overflow'>";
					locDetailsDiv = locDetailsDiv+"<ul class='rumMapData' style='	list-style:none;margin:0px;padding:0px;display:inline-block;line-height:1.5em;'>";
					// Preparing the content to be shown on the popup window
					// || jsonDetailsItem.MeasureDispName == 'Apdex Score'
					for(var d=0; d<jsonItem.BottomLocDetails.length; d++)
					{
						var jsonDetailsItem=jsonItem.BottomLocDetails[d];
						if(jsonDetailsItem!=null && jsonDetailsItem!=undefined)
						{
							var mapInfoMeasure = jsonDetailsItem.MeasureDispName;
							
							if(jsonDetailsItem.MeasureUnit.toLowerCase() == 'milliseconds')
								jsonDetailsItem.MeasureUnit=' ms';

							if(jsonDetailsItem.MeasureUnit == 'Seconds')
								jsonDetailsItem.MeasureUnit=' S';

							//locDetailsDiv = locDetailsDiv+"<li style='text-align:center;padding:0px 8px 0px 8px;white-space:normal;display:inline-block;float:left'><div style='float:left' class='stateSymbol_"+jsonDetailsItem.State+"'></div><span class ='value' style='text-transform:lowercase;'> "+jsonDetailsItem.MeasureValue+"</span><span class ='unit'>"+jsonDetailsItem.MeasureUnit+" </span><br/><span style='margin-top:10px;display:block'>"+jsonDetailsItem.MeasureDispName+"</span></li>";

							if(!Ext.isEmpty(jsonDetailsItem.DD_URL) && jsonDetailsItem.DD_URL!=null && jsonDetailsItem.DD_URL!=undefined)
							{
								//locDetailsDiv = locDetailsDiv+"<li style='text-align:center;padding:3px 8px 10px 8px;white-space:normal;display:inline-block;float:left'><span style='font-size:17px;font-weight:bold;text-transform:lowercase;color:"+jsonDetailsItem.StateCode+" !important;' class='rumVisitsText'> "+jsonDetailsItem.MeasureValue+" "+jsonDetailsItem.MeasureUnit+" </span><br/>"+jsonDetailsItem.MeasureDispName+"</li>";

								locDetailsDiv = locDetailsDiv+"<li class='infocontentlist'><div style='' class='d_m_b10'><img style='vertical-align: text-bottom;margin-left:-5px' src='/final/images/clear.png'  class='stateSymbol_"+jsonDetailsItem.State+"'/><span class ='value' style='text-transform:lowercase;'> "+jsonDetailsItem.MeasureValue+"</span><span class ='unit'>"+jsonDetailsItem.MeasureUnit+" </span></div><div><span  class='displayname'>"+jsonDetailsItem.MeasureDispName+"</span></div></li>";
							}
							else
							{
								//locDetailsDiv = locDetailsDiv+"<li style='text-align:center;padding:0px 8px 0px 8px;white-space:normal;display:inline-block;float:left'><span style='font-size:17px;font-weight:bold;text-transform:lowercase;color:"+jsonDetailsItem.StateCode+" !important;'> "+jsonDetailsItem.MeasureValue+" "+jsonDetailsItem.MeasureUnit+" </span><br/>"+jsonDetailsItem.MeasureDispName+"</li>";

								locDetailsDiv = locDetailsDiv+"<li class='infocontentlist'><div style='display:table' class='d_m_b10'><img style='vertical-align: text-bottom;margin-left:-5px' src='/final/images/clear.png'  class='stateSymbol_"+jsonDetailsItem.State+"'/><span class ='value' style='text-transform:lowercase;'> "+jsonDetailsItem.MeasureValue+"</span><span class ='unit'>"+jsonDetailsItem.MeasureUnit+" </span></div><div><span  class='displayname'>"+jsonDetailsItem.MeasureDispName+"</span></div></li>";
							}
						}
					}
					locDetailsDiv = locDetailsDiv+"</ul></div>";
					locDetailsDiv = locDetailsDiv+"</div>";

					var c_json = new Object();
					c_json.locDetailsDiv=locDetailsDiv;
					c_json.colorClass=colorClass;
					c_json.combo=jsonItem.combo;
					me.cb_json.push(c_json);
					
					//var geocoderObj = new google.maps.Geocoder();
					//if(geocoderObj)
					//{
						//geocoderObj.geocode( { 'address':jsonItem.RealInfo},function(results, status) {
							//if ( ( status == google.maps.GeocoderStatus.OK || jsonItem.CountryLAT ) && results != undefined && results[0] != undefined ) 
							if(!Ext.isEmpty(jsonItem.CountryLAT))
							{
								var geo = results[0];
								//var geoLat = geo.geometry.location.lat().toFixed(5);
								//var geoLan = geo.geometry.location.lng().toFixed(5);
								var geoLat = jsonItem.CountryLAT;
								var geoLan = jsonItem.CountryLNG;
								var c_geo = new Object();
								c_geo.geoLat=geoLat;
								c_geo.geoLan=geoLan;
								me.cb_geo.push(c_geo);
								me.callbackfunction(me);
							}
							else
							{
								me.cb_geo.push(null);
								me.callbackfunction(me);
							}
						//});
					//}
					
				}
			}
			//me.setmapBounds(latlangBounds,me);
			//me.setmapFixedView(me);
			//me.gmap.setZoom(2);
		}
		catch (e)
		{
			//console.log('aa==>',e)
		}
		me.zoomLevel = me.gmap.getZoom();
	},
	callbackfunction:function(me){
		try
		{
			
			if(me.cb_geo.length == me.cb_json.length)
			{
				var latlangBounds = [];
				for(var a in me.cb_json)
				{
					var c_geo = me.cb_geo[a];
					var c_json = me.cb_json[a];

					if(c_geo == null || c_geo == undefined)
						continue;

					var geoLat = c_geo.geoLat;
					var geoLan = c_geo.geoLan;

					var locDetailsDiv = c_json.locDetailsDiv;
					var colorClass = c_json.colorClass;
					var combo = c_json.combo;

					var infobox = new InfoBox({
						content: locDetailsDiv,
						 //disableAutoPan: true,
						 //maxWidth: "340px",
						 pixelOffset: new google.maps.Size(-167, -30),
						 zIndex: null,
						 boxStyle: {
							border: "0px solid blue",
							
							opacity: 1.0,
							width: "auto",
							margin:"25 0 0 0"
						},
						closeBoxMargin: "7px 7px 0px 0px",//-108px -58px 2px 2px  - Normal:12px 4px 2px 2px   -58px 130px 2px 2px
						closeBoxURL: "/final/images/Light/iconMapClose.png",
						infoBoxClearance: new google.maps.Size(1, 1)
					});


					me.infoBoxArray.push(infobox);

					var wid,hit;
					var obj = getStyle(colorClass);
					if(obj != null && obj != undefined){
						wid=obj.width;
						hit=obj.height;
					}

					var markerLocation = null;
					markerLocation = { lat: parseFloat(geoLat), lng: parseFloat(geoLan)};
					latlangBounds.push(markerLocation);

					var centerMarker =  new MarkerWithLabel
					({
					   position: markerLocation,
					   draggable: false,
					   raiseOnDrag: false,
					   map: me.gmap,
					   labelAnchor: new google.maps.Point(2,8),//may be (0,5) --> if so then it display the label from center of bubble
					   labelClass: "labels", 
					   labelStyle: {opacity: 0.90, color:labelColor},
					   icon : image
					});


					var iconMarker =   new MarkerWithLabel({
						position: markerLocation,
						map: me.gmap,
						icon:image,
						draggable:false,
						labelAnchor: new google.maps.Point(wid,hit),
						labelContent: '',
						info:combo,
						labelClass:colorClass,
						infoBox:infobox,
						cm:centerMarker
					  });
					
					me.markerArray.push(iconMarker);

					var zl = google.maps.event.addListener(iconMarker, 'click',function(e)
							{
									me.access = this.info;
								//	code to open infoBox
								me.closeAllInfoBox();
								this.infoBox.open(me.gmap,this.cm);
								
							});
					
					me.listenerArray.push(zl);
				}

				me.setmapBounds(latlangBounds,me);
				me.addZoomChangeListener(me);

			}
		}
		catch (e)
		{
			alert(e)
		}
	},
	removeAllListeners:function(me){
		var listenerArray = me.listenerArray;
		if(listenerArray != undefined && listenerArray != null){
			for(var l=0;l<listenerArray.length;l++){
				google.maps.event.removeListener(listenerArray[l]);
			}
		}
		me.listenerArray=[];
	},
	addZoomChangeListener:function(me){

		//if(me.selectedView != undefined && me.selectedView != null && me.selectedView !='Geo_View')
			return;

		me.zoomLevel = me.gmap.getZoom();
		/*var zl = google.maps.event.addListener(me.gmap, 'zoom_changed',function(e)
		{
			if(me.access != null && me.access != undefined && me.access != ''){

				var countryComboObj = Ext.getCmp('countryComboId');
				var regionComboObj = Ext.getCmp('regionComboId');

				if(me.zoomLevel < me.gmap.getZoom()){
					if(me.mapMode == 'Country'){
						countryComboObj.setValue(me.access);
						RumAppFlow.app.getController('Main').geoComboOnChange(countryComboObj);
					}
					else if(me.mapMode == 'Region'){
						regionComboObj.setValue(me.access);
						RumAppFlow.app.getController('Main').geoComboOnChange(regionComboObj);
					}
				}
				else{
					if(me.mapMode == 'Region'){
						countryComboObj.setValue('World');
						RumAppFlow.app.getController('Main').geoComboOnChange(countryComboObj);
					}
					else if(me.mapMode == 'City'){
						regionComboObj.setValue('AllRegion');
						RumAppFlow.app.getController('Main').geoComboOnChange(regionComboObj);
					}
				}
			}
		});

		me.listenerArray.push(zl);*/
	},
	setmapFixedView:function(me){
		try
		{
			var centerMap = new google.maps.LatLng(40.3780, 10.4359);
			//var centerMap = new google.maps.LatLng(6.349789, 16.540727);
			me.gmap.setCenter(centerMap);
			me.gmap.setZoom(1);
		}
		catch (e)
		{
			me.gmap.setZoom(1);
		}
	},
	setmapBounds:function(latlangBounds,me){
		try
		{
			if(latlangBounds != null && latlangBounds != undefined && latlangBounds.length > 0){
				var bounds = new google.maps.LatLngBounds();
				for (var i = 0; i < latlangBounds.length; i++) {
					bounds.extend(latlangBounds[i]);
				}
				var boundCheck = true;
				for (var i = 0; i < latlangBounds.length; i++) {
					if(isNaN(latlangBounds[i].lat) || isNaN(latlangBounds[i].lng))
					{
						boundCheck = false;
						break;
					}
				}
				if(latlangBounds.length == 1)
				{
					if(me.mapMode == 'Region')
						me.gmap.setZoom(3);
					else if(me.mapMode == 'City')
						me.gmap.setZoom(4);
					else
						me.gmap.setZoom(2);
					
					if(boundCheck)
						me.gmap.setCenter(bounds.getCenter());
				}
				else{
					Ext.defer(function(){
						if(boundCheck)
						{
							me.gmap.fitBounds(bounds);
							me.gmap.setCenter(bounds.getCenter());
						}
						else
						{
							if(me.mapMode == 'Region')
								me.gmap.setZoom(3);
							else if(me.mapMode == 'City')
								me.gmap.setZoom(4);
							else
								me.gmap.setZoom(2);
						}
					},1000)	
				}
			}else
				me.gmap.setZoom(1);
		}
		catch (e)
		{
			me.gmap.setZoom(1);
		}
	},
	loadGeoJSON:function(me,text,style,infobox,markerLocation,locDetailsDiv,detailsArray,colorClass){
		try
		{

			var wid,hit;
			var obj = getStyle(colorClass);
			if(obj != null && obj != undefined){
				wid=obj.width;
				hit=obj.height;
			}

			var iconMarker =   new MarkerWithLabel({
				position: markerLocation,
				map: me.gmap,
				icon:image,
				draggable:false,
				labelAnchor: new google.maps.Point(wid,hit),
				labelContent: '',
				info:detailsArray[1],
				labelClass:colorClass,
			  });
			
			me.markerArray.push(iconMarker);
			var centerMarker =  new MarkerWithLabel
			({
			   position: markerLocation,
			   draggable: false,
			   raiseOnDrag: false,
			   map: me.gmap,
			   labelAnchor: new google.maps.Point(2,8),//may be (0,5) --> if so then it display the label from center of bubble
			   labelClass: "labels", 
			   labelStyle: {opacity: 0.90, color:labelColor},
			   icon : image,
			});
			
			var zl = google.maps.event.addListener(iconMarker, 'click',function(e)
					{
						me.access = this.info;
						//	code to open infoBox
						infobox.setContent(locDetailsDiv);
						me.closeAllInfoBox();
						//me.gmap.setCenter(centerMarker.getPosition());
						infobox.open(me.gmap,centerMarker);
					
					});
			
			me.listenerArray.push(zl);

			var json = JSON.parse(text);
			var features = new GeoJSON(json,style);
			me.feauturesArray.push(features);
			for (var i = 0; i < features.length; i++){
				features[i].info=detailsArray[1];
				features[i].colorClass=colorClass;
				features[i].setMap(me.gmap);
				
				zl = google.maps.event.addListener(features[i], 'click',function(e)
				{
					me.access = this.info;
					//	code to open infoBox
					infobox.setContent(locDetailsDiv);
					me.closeAllInfoBox();
					//me.gmap.setCenter(centerMarker.getPosition());
					infobox.open(me.gmap,centerMarker);
					
				});
				me.listenerArray.push(zl);
			}
			
		}
		catch (e)
		{
		}
	},
	closeAllInfoBox:function(){
		try
		{
			var infoBoxArr = this.infoBoxArray;
			for(var a in infoBoxArr)
				infoBoxArr[a].close();
			
		}
		catch (e)
		{
		}
	},
	filterCheck:function(me){
		try
		{
			var disableArrfea=[];
			var disableArricon=[];
			if(!Ext.isEmpty(me)){
				disableArrfea = me.feauturesArray;
				disableArricon = me.markerArray;
								
				var response =  Ext.getCmp('filtermenu_Response_Time').getValue();
				var requests =  Ext.getCmp('filtermenu_Requests').getValue();
				var normal =  Ext.getCmp('filtermenu_Normal').getValue();
				var unknown =  Ext.getCmp('filtermenu_Unknown').getValue();
				var minor =  Ext.getCmp('filtermenu_Minor').getValue();
				var major =  Ext.getCmp('filtermenu_Major').getValue();
				var critical =  Ext.getCmp('filtermenu_Critical').getValue();
				
				if(!Ext.isEmpty(disableArrfea)){
					for(var c in disableArrfea){
						for (var l in disableArrfea[c] )
						{
							if(response){
								var cls = disableArrfea[c][l].colorClass;
								cls = cls.substring(cls.indexOf('_')+1);
								switch(cls){
									case 'GOOD' :if(normal)
													disableArrfea[c][l].setMap(me.gmap);
												else
													disableArrfea[c][l].setMap(null);
												 break;
									case 'UNKNOWN' :if(unknown)
														disableArrfea[c][l].setMap(me.gmap);
													else
														disableArrfea[c][l].setMap(null);
												 break;
									case 'LOW' :if(minor)
													disableArrfea[c][l].setMap(me.gmap);
												else
													disableArrfea[c][l].setMap(null);
												 break;
									case 'INTERMEDIATE' :if(major)
															disableArrfea[c][l].setMap(me.gmap);
														else
															disableArrfea[c][l].setMap(null);
														 break;
									case 'HIGH' :if(critical)
													disableArrfea[c][l].setMap(me.gmap);
												else
													disableArrfea[c][l].setMap(null);
												 break;
									default : disableArrfea[c][l].setMap(me.gmap);
												break;
								}
							}else{
								disableArrfea[c][l].setMap(null);
							}
						}
					}
				}
				
				if(!Ext.isEmpty(disableArricon)){
					for(var c in disableArricon){
						if(requests){
							var cls = disableArricon[c].labelClass;
							cls = cls.substring(cls.indexOf('_')+1);

							switch(cls){
								case 'GOOD' :if(normal)
												disableArricon[c].setMap(me.gmap);
											else
												disableArricon[c].setMap(null);
											 break;
								case 'UNKNOWN' :if(unknown)
													disableArricon[c].setMap(me.gmap);
												else
													disableArricon[c].setMap(null);
											 break;
								case 'LOW' :if(minor)
												disableArricon[c].setMap(me.gmap);
											else
												disableArricon[c].setMap(null);
											 break;
								case 'INTERMEDIATE' :if(major)
														disableArricon[c].setMap(me.gmap);
													else
														disableArricon[c].setMap(null);
													 break;
								case 'HIGH' :if(critical)
												disableArricon[c].setMap(me.gmap);
											else
												disableArricon[c].setMap(null);
											 break;
								default :	disableArricon[c].setMap(me.gmap);
											break;
							}
						}else{
							disableArricon[c].setMap(null);
						}
						
					}
				}
			}
		}
		catch (ert)
		{			
		}

	}	
});




function moveNext(mapMode,access,info){
	var countryComboObj = Ext.getCmp('countryComboId');
	var regionComboObj = Ext.getCmp('regionComboId');
	try
	{
		if(mapMode == 'Country'){
			countryComboObj.setValue(access);
			RumAppFlow.app.getController('Main').geoComboOnChange(countryComboObj);
		}
		else if(mapMode == 'Region'){
			if(info.indexOf("+")==0)
				info = info.substring(1);

			regionComboObj.setValue(info);
			RumAppFlow.app.getController('Main').geoComboOnChange(regionComboObj);
		}
	}
	catch (s)
	{
		alert(s)
	}
}