function clone(obj) {
    if (null == obj || "object" != typeof obj) return obj;
    var copy = obj.constructor();
    for (var attr in obj) {
        if (obj.hasOwnProperty(attr)) copy[attr] = obj[attr];
    }
    return copy;
}

Ext.require('Ext.grid.column.Template',function(){
	Ext.override(Ext.grid.column.Template, {
		constructor: function(cfg){
    	   this.callParent(arguments);
            var tpl = (!Ext.isPrimitive(this.tpl) && this.tpl.compile) ? this.tpl : new Ext.XTemplate(this.tpl);    
    	    this.renderer = function(value, p, r, rowIndex, colIndex){
                var newData=Ext.apply({rowIndex: rowIndex, colIndex: colIndex}, r.data);
                return tpl.apply(newData);
            };

            this.tpl = tpl;
  
    	}
	})
});
Ext.define('RumAppFlow.view.OmniChannel', {
	 extend: 'Ext.grid.Panel',
	alias:'widget.omnichannel',
	store: Ext.create('Ext.data.Store', {
		//storeId:'omnichannelStore',
		fields:['grp_url','page_views', 'user_exp_index', 'avg_page_load','js_errors'],
		data:[],
		proxy:{
			type: 'memory',
			reader: {
				type: 'json'
			}
		}
	}),
	//flex:1,
	ui:'x-big-grid',
	cls:'x-big-grid-border',
	disableSelection:true,
	id:'omnichannelID',
	autoScroll:false,
	scroll:false,
	viewConfig: {
		flex:1,
		
		emptyText: '<div style="display:block;height:'+(Ext.getBody().getViewSize().height - 360)+';width:100%;position:relative" id="nodata"><div style="display:table-cell;vertical-align:middle;text-align:center;position:absolute;bottom:0;top:0;left:0;right:0;margin:auto;height:20px"><div style="margin:auto;" class="iconInformation"></div><div>No Data Found!</div></div></div>',
		deferEmptyText: false,
	},
	
	border:true,
	autoDestroy:true,
	initComponent:function(){
		var me = this;
		me.getStore().loadRawData(me.data);
		if (!Ext.isEmpty(me.store)) {
			var data = me.store.data.items;
            me.mon(me, 'viewready', function() {
                me.loadChart(data);
            }, me);
			 
        }
		me.callParent();
	 },
	 loadChart: function(data) {
        var me = this;
		me.store.loadData(data);
		data =  me.store.data.items;
		
		var cv = Ext.getCmp('omni_combo').getValue();
		var indexName='page_views';
		var indexName2='device';
		if(cv =='device')
		{
			indexName='page_views';
			indexName2='device';
		}
		else
		 {
			indexName='grp_url';
			indexName2='url';
		 }

        for (var i = 0; i < data.length; i++) {				
			var title = data[i].data[indexName][indexName2];
			for (var keys in  data[i].data.user_exp_index)
			{
				$('#user_exp_chart_'+i).highcharts(me.chartConfig(data[i].data.user_exp_index.chartData,title,'User Experience Index',data[i].data.user_exp_index.fmts));
				$('#avg_page_load_chart_'+i).highcharts(me.chartConfig(data[i].data.avg_page_load.chartData,title,'Avg Page Load Time',data[i].data.avg_page_load.fmts));
				$('#js_errors_chart_'+i).highcharts(me.chartConfig(data[i].data.js_errors.chartData,title,'Js Errors',data[i].data.js_errors.fmts));
			}         
        }		
    },
	drillDown:function(data,title,yaxis,fmts){
		var ddata = clone(data);
		var isAllZeroflag = false;
		var sum = 0;
		//For displaying Zero Values in area Chart
		for(var t=0; t< ddata.length;t++){
			sum += ddata[t][1];
		}
		if(sum == 0)
			isAllZeroflag = true

		var colorTit = strRumSkin == "Dark"?"#c6c6c6":"#2a292a";
		var items = Ext.create('RumAppFlow.view.ChartPanel',{
			tools:[
			{
				xtype:'label',
				cls:'font_bold9 grayColor',
				text:"Last 1 hour",
			}
			],
			ui:'x-plain-panel',
			title: '<div style="color:'+colorTit+'">Response Time Breakup - '+title+'</div>',
			legendPosition: 'bottom', // top,left, bottom and right
			chartType: 'area', // pie,line,column,area -  chart type
			xaxis:'Time (HH:mm)',
			yaxis:yaxis,
			fmts:fmts,
			isAllZero:isAllZeroflag,
			data:[{
				showInLegend: false, 
				"data": data,
				"color":"#b2a8e1"
			}]
		});
		Ext.create('RumAppFlow.GenericWindow', {
			title:'',
			ghost:false,
			modal:true,
			maskOpacity:'0.9',
			maskColor:'black',
			cssMask:false,
			bodyPadding:50,
			ui:'eg-new-window',
			items:[items]
		}).show();
	},
    chartConfig: function(data,title,yaxis,fmts) {
		var jsonDataArray = clone(data);
		var sum = 0;
		var maxVal = null;
		//For displaying Zero Values in area Chart
		for(var t=0; t< jsonDataArray.length;t++){
			sum += jsonDataArray[t][1];
		}
		if(sum == 0){
			for(var t=0; t< jsonDataArray.length;t++){
				jsonDataArray[t] = 1;
			}	
			maxVal = 10;
		}
		var me = this,
            config = {
				credits: {
					enabled: false
				},						
				chart: {
					zoomType: null,
					events: {
					click: function (event) {			
						event.stopPropagation();
						 me.drillDown(data,title,yaxis,fmts);									
					}
					},
					type: 'area',
					spacingBottom: 0,
					spacingTop: 0,
					spacingLeft: 0,
					spacingRight: 0,
					
					backgroundColor: null
				},
				exporting: {
					enabled: false
				},
				title:
				{
					text:""
				},
				tooltip: {
					enabled: false
				},
				xAxis: {
					allowDecimals: false,
					visible: false,
					minorGridLineWidth: 0,
					minorTickLength: 0,
					tickLength: 0,
					lineColor: 'transparent',
					labels: {
						enabled: false
					}
				},
				yAxis: {
					max: maxVal,
					minorGridLineWidth: 0,
					visible: false,
					lineColor: 'transparent',
					gridLineColor: 'transparent',
					minorTickLength: 0,
					tickLength: 0,
					
					labels: {
						enabled: false
					}
				},
				plotOptions: {
					trackByArea: true,
					area: {
						
						marker: {
							enabled: false,
							symbol: null,
							states: {
								hover: {
									enabled: false
								}
							}
						},
						
						showInLegend: false,
						lineColor:'transparent',
						color: '#b2a8e1',
					}
				},
				series: [{						
					// @ updatinig the data
					 enableMouseTracking: false,
					 data: jsonDataArray
				}]
		};
		config= jQuery.extend(true,config,getUserThemeFor(strSkin));
        return config;
    },
    columns: [
        { 
		 text: 'Page Views',  
		sortable : false,
		menuDisabled : true,
		 dataIndex: 'page_views' ,
		xtype: 'templatecolumn',
		flex:1,
		minWidth:285,
		overCls : 'header-over',
		align : 'center',
		tpl : new Ext.XTemplate(
				'<div>',
				'<tpl if="page_views">',
				'<tpl for="page_views">',
					'<div style="display:inline-block;vertical-align: middle;padding-top:10px">',
					'<div style="display:inline-block;position:relative;margin-right:30px;top:-15px">',
					//'<div style="text-transform: uppercase;text-align: center;font-weight:bold" class="font_normal10" >{device}</div>',
					'<img src="/final/images/clear.png" width="67px" height="61px"  style="margin-right: -20px;vertical-align: middle;background-color:transparent" class="appflow_device_user_{device}"/>',
					'<img src="../images/Light/state_component_combo_{state}.png" style="position:absolute;left: 0;bottom: 3px;" width="14px" height="14px">',
					'</div>',
					'<div  style="display:inline-block;text-align: left;">',
					'<div style="line-height:31px;" class="font_normal35">{value}</div>',
					'<div style="line-height:2px;height:1px;margin:5px 0px 8px 0px" class="tabsep"></div>',
					'<div style="display:inline-block;vertical-align: middle;margin-left: 3px;">',
					'<ul class="ul_userexp">',
					'<tpl for="userExp">',
					'<li ><div class="font_bold14" style="margin:0px 0px 5px 0px">{value}</div><div class="font_normal10 legend_{label}">{label}</div></li>',
					'</tpl>',
					'</ul>',
					'</div>',
					'</div>',
					'</div>', 
					 
				'</tpl>',
				'<tpl else>',
				
				'<tpl for="grp_url">',
					'<div style="margin-top:5px">',
					
					'<div style="position:relative;">',
					'<div  class="url_info" data-qtip="{url}" data-qclass="yellowTip">',
					'<div class="urlstate" style="padding-bottom:5px">',
					'<img src="../images/Light/state_component_combo_{state}.png" width="14px" height="14px" style="vertical-align: text-bottom;margin-right:10px">{value}',
					'</div>',
					'<div class="urlbox trim_text" style="text-align:left" >{url}</div>',
					'</div>',
					'</div>',
					'<div>',
					'<ul class="ul_userexp border">',
					'<tpl for="userExp">',
					'<li ><div class="font_bold14" style="margin:5px 0px 5px 0px">{value}</div><div class="font_normal10 legend_{label}">{label}</div></li>',
					'</tpl>',
					'</ul>',
					'</div>', 
					'</div>', 
				'</tpl>',
				'<div style="clear:both"></div>',
						'</tpl>',
				'</div>'
			),	
		},
        { 
			text: 'User Experience Index (Apdex)', 
			dataIndex: 'user_exp_index',
			xtype: 'templatecolumn',
			flex: 1 ,
			sortable : false,
			menuDisabled : true,
			overCls : 'header-over',
			align : 'center',
			tpl:new Ext.XTemplate(
				'<div >',
				'<tpl for="user_exp_index">',
					'<div  style="height:30px;line-height: 30px;">',
					'<span class="font_normal25"  style="vertical-align: middle;"><img  style="vertical-align: top;margin-right:10px" src="/final/images/clear.png"   class="smiley{user_exp}_big_medium" />{value}</span>',
					'</div>', 
					//'<div id="user_exp_chart_{#}" style="width:125px;height:28px">{rowIndex}</div>', 
				'</tpl>',
				'<div id="user_exp_chart_{rowIndex}" style="width:127px;height:35px;margin:0px auto"></div>', 
				'</div>'
			)			
		},
        { 
			text: 'Avg Page Load Time (s)', 
			dataIndex: 'avg_page_load' ,
			xtype: 'templatecolumn',
			flex: 1,
			sortable : false,
			menuDisabled : true,
			overCls : 'header-over',
			align : 'center',
			tpl:new Ext.XTemplate(
				'<div>',
				'<tpl for="avg_page_load">',
					'<div style="height:30px;line-height: 30px;"><span class="font_normal25" style="vertical-align: middle;">{value}</span><span style="vertical-align: sub;" class="font_bold14">s</span></div>', 
				'</tpl>',
				'<div id="avg_page_load_chart_{rowIndex}" style="width:127px;height:35px;margin:0px auto"></div>', 
				'</div>'
			)
		},
        { 
			text: 'JS Errors', 
			dataIndex: 'js_errors' ,
			xtype: 'templatecolumn',
			flex: 1,
			maxWidth:190,
			sortable : false,
			menuDisabled : true,
			overCls : 'header-over',
			align : 'center',
			tpl:new Ext.XTemplate(
				'<div>',
				'<tpl for="js_errors">',
					'<div  style="height:30px;line-height: 30px;"><span class="font_normal25" style="vertical-align: middle;">{value}</span><span style="vertical-align: sub;"  class="font_bold14">%</span></div>', 
				'</tpl>',
				'<div id="js_errors_chart_{rowIndex}" style="width:127px;height:35px;margin:0px auto"></div>', 
				'</div>'
			)
		}
    ]
	 });