
Ext.define('RumAppFlow.view.OmniChannelMainPanel', {
	 extend: 'Ext.panel.Panel',
	alias:'widget.omnichannelmainpanel',
	requires:['RumAppFlow.view.OmniChannel'],
	flex:1,
	layout: {
		type: 'vbox',
		align: 'stretch'
	},
	initComponent:function(){
	 var me = this;
	 
	 me.callParent();
	 },
	updateData:function(data){		
		Ext.getCmp('omnichannelID').loadChart(data.grid);
		Ext.getCmp('omni_combo').getStore().loadRawData(data.comboObj.combo_arr);
	 },
	listeners:{
		afterrender:function(){
			var me = this;
			var omniData = me.data;
			Ext.get(me.id+'-body').on('scroll',me.scrollMe,Ext.get(me.id));
			me.add(
			{
				xtype:"omnichannel",
				id:'omnichannelID',
				data:omniData.grid
			}
			);
			me.addDocked({
				xtype: 'toolbar',
				dock: 'top',
				padding:'20 20 20 20',
				listeners:{
					'afterrender':function(ee){
						var me = this;
						me.add(
							{	
								xtype:'combo',
								cls:'dropdown ',
								width:250,
								labelCls : 'big_font_label',
								labelSeparator:"",
								fieldLabel:'Omni channel',
								id:'omni_combo',
								//value:"By Devices",
								listeners:{
									select:function(r){
										RumAppFlow.app.getController("Main").changeOmniCombo(r.value);
									}
								},
								margin:'0 10 0 0',
								displayField : 'name',
								valueField : 'value',
								queryMode : 'local',
								store:Ext.create('Ext.data.Store',{
									data :omniData.comboObj.combo_arr,
									fields:['name','value'],
								}),
								value:omniData.comboObj.selectedValue,
							}/*,
							'->',
							{
								xtype:'label',
								cls:'labelCls',
								
								padding:'2 3 0 0',
								text:'Showing'
							},{
								xtype:'radiofield',
								cls:'radiobt',
								 boxLabel  : 'Current measurement',
								name      : 'size',
								inputValue: 'm'
							},{
								xtype:'radiofield',
								 boxLabel  : '',
								cls:'radiobt',
								margin:'5 0 0 15',
								name      : 'size',
								inputValue: 'm'
							},
							{	
								xtype:'combo',
								cls:'dropdown ',
								labelSeparator:"",
								margin:'5 0 0 5',
								width:110,
								value:"Last By 30 days",
								listeners:{
									select:function(){
										//alert('change');
									}
								},
								store:['By Devices','By Page Groups']
							}*/
						);
					}
				},
				items: []
			});
		}
	 },
	scrollMe:function(){
		 var me = this;
		if(!Ext.isEmpty(Ext.get(me.id).select('.x-grid-header-ct'))){
			Ext.get(me.id).select('.x-grid-header-ct').setTop(Ext.get(this.id+'-body').getScroll().top);
		}
	 },
	scroll:true,
	autoScroll:true,
	 ui: 'eg-x-panel',
	bodyPadding:'0 20 10 20',
	dockedItems: [],
	items:[]	
});


	