Ext.define('RumAppFlow.view.OverviewWidgets', {
     extend: 'Ext.container.Container',
	alias:'widget.overviewwidgets',
	requires:[
			'RumAppFlow.view.TrafficWidget',
			'RumAppFlow.view.UniqueSessionsWidget',
			'RumAppFlow.view.UxEWidget',
			'RumAppFlow.view.PageLoadTimeWidget',
			'RumAppFlow.view.ErrorWidget'
	 ],
	layout:{
			type:'hbox',
			align:'stretch'
	},
	flex:1,
	padding:0,
	defaults:{
		flex:1,
		padding:'0 5 10 5',
		border:true,
		margin:'5 0',
		layout:{
			type:'fit'
		}
	},
	autoDestroy:true,	
	initComponent:function(){
		var overviewwidgets =  this;
		overviewwidgets.callParent();
	},
	updateData:function(jsonData){
		Ext.getCmp('trafficwidget_id').updateData(jsonData[0]);
		Ext.getCmp('uniquesessionswidget_id').updateData(jsonData[1]);
		Ext.getCmp('uxewidget_id').updateData(jsonData[2]);
		Ext.getCmp('pageloadtimewidget_id').updateData(jsonData[3]);
		Ext.getCmp('errorwidget_id').updateData(jsonData[4]);
	},
	listeners:{
		'afterrender':function(e){
			var me = this;
			try
			{
				me.add(
				{
					
					minWidth:150,
					xtype:'trafficwidget',
					id:'trafficwidget_id',
					data:me.data[0]
				},
				{
					
					xtype:'uniquesessionswidget',
					id:'uniquesessionswidget_id',
					minWidth:220,
					data:me.data[1]
				},
				{
					minWidth:220,
					xtype:'uxewidget',
					id:'uxewidget_id',
					data:me.data[2]
				},
				{
					//flex:1,
					minWidth:80,
					xtype:'pageloadtimewidget',
					id:'pageloadtimewidget_id',
					data:me.data[3]
				},
				{
					flex:1,
					//minWidth:220,
					xtype:'errorwidget',
					id:'errorwidget_id',
					data:me.data[4]
				});								
			}
			catch (e)
			{
			}			
		}
	},
	items:[]
 });