Ext.define('PageLoadTimeWidgetModel', {
    extend: 'Ext.data.Model',
    fields: [
        { name:'state', type:'string' },
        { name:'heading', type:'string' },
        { name:'value', type:'string' },
		{ name:'legend', type:'string' },
		{ name:'dd_url', type:'string' },
		{ name:'graphID', type:'string' }
    ]
});

Ext.create('Ext.data.Store', {
    id:'pageloadTimewidget_id',
    model: 'PageLoadTimeWidgetModel',
	autoLoad:true,
    data: [
        {  state:'GOOD' ,heading:'Page Load Time',value:14.23,legend:'Sec'}
    
    ]
});
// .stateIconRumAppFlowHealthy, .stateIconRumAppFlowMinor, .stateIconRumAppFlowMajor, .stateRumAppFlowNotOk
Ext.define('RumAppFlow.view.PageLoadTimeWidget', {
     extend: 'Ext.container.Container',
	alias:'widget.pageloadtimewidget',
	cls:'widgetcon',
	autoDestroy:true,
	ui:'pageloadtimewidget',
	updateData:function(data){
		var me = this;
		Ext.getCmp('dataview_'+this.id).store.loadRawData(data);
		try
		{
			if(!Ext.isEmpty(data.graphData) && data.graphData.trim().toLowerCase() == "no data found"){
				$('#pageload-graph').html('<div style="display:table;height:100%;width:100%;text-align:center;font-size:10px;margin-top:25px !important">-</div>');
			}
			else
				$('#pageload-graph').highcharts(getpageLoadTimeWidgetJson(data)); 
			
		}
		catch (et)
		{
			$('#pageload-graph').highcharts(getpageLoadTimeWidgetJson(data)); 
		}	
	},
	listeners:{
		'afterrender':function(e){
			var pageloadTimewidgetTpl = new Ext.XTemplate(
				'<div class="widgetholders">',
				'<tpl for=".">',
				'<div class="s_box">',
					 '<div class="font_bold12 div_center" style="float:left;width:70%"><img style="position: absolute;top: 0;bottom: 0;margin: auto;" src="/final/images/clear.png" class="stateSymbol_{state}" /><span style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:20px;padding-top:2px;" data-qtip="{heading}">{heading}</span></div>',
					 '<div style="position:absolute;text-align:right;padding-right:8px" class="div_center"><span  class="font_bold18" style="text-align:right"><a style="border:0px solid green !important;" href="javascript:void(0);" onclick=\'javascript:showDDPopup("{dd_url}")\'>{value}</a></span><span class="font_normal10 trim_text" style="text-transform:lowercase;text-align:right;vertical-align:middle;width:100%"> {legend}</span></div>',
					 '<div style="clear:both"></div>',
					 '</div>',
					'<div class="b_box">',
					  '<div class="font_bold12"><img style="vertical-align:sub" src="/final/images/clear.png" class="stateSymbol_{state}" /> <span data-qtip="{heading}">{heading}</ span></div>',
						'<div class="font_normal31 d_m_t20" style="text-align:center"><a style="border:0px solid green !important;" href="javascript:void(0);" onclick=\'javascript:showDDPopup("{dd_url}")\'>{value}</a></div>',
						'<div class="font_normal11 legendLabel" style="text-align:center">{legend}</div>',
						'<div id="pageload-graph" class="appflow_rum_graph" style="width:120px;height:35px;"></div>',
					'</div>',
				'</tpl>',
				'</div>'
			);
			var pageLoadtimeWidg = this.pageLoadtimeWidgPanel(this.data,this,pageloadTimewidgetTpl);
			this.add(pageLoadtimeWidg);
		}
	},
	pageLoadtimeWidgPanel:function(data1,thisObje,tplDes){
		var item = {
			xtype:'dataview',
			padding:'5 5 5 5',
			id:'dataview_'+this.id,
			//store: Ext.data.StoreManager.lookup('trafficWidget_model_id'),
			store: Ext.create('Ext.data.Store', {
				id:'pageloadTimewidget_id',
				model: 'PageLoadTimeWidgetModel',
				autoLoad:true,
				data:data1
			}),
			tpl:tplDes,
			listeners:{
				viewready:function(x){
					var me = this;
					try
					{
						if(!Ext.isEmpty(data1.graphData) && data1.graphData.trim().toLowerCase() == "no data found"){
							$('#pageload-graph').html('<div style="display:table;height:100%;width:100%;text-align:center;font-size:10px;margin-top:25px !important">-</div>');
						}
						else
							$('#pageload-graph').highcharts(getpageLoadTimeWidgetJson(data1)); 
						
					}
					catch (et)
					{
						$('#pageload-graph').highcharts(getpageLoadTimeWidgetJson(data1)); 
					}					
				}
			}
		}
		return item;
	},
	items:[]
 });

function getpageLoadTimeWidgetJson(dataforGraph){
	var maxVal = null;
	var jsonDataArray = dataforGraph.graphData;
	var sum = 0;
	for(var g=0;g<jsonDataArray.length;g++){
		sum += jsonDataArray[g];
	}
	if(sum == 0){
		maxVal = 10;	
	}
	var columnData = jsonDataArray;
	var dataArray = [];
	var lowVal = 0;
	var dynContWidth = 100;
	if(columnData.length <= 2)
		dynContWidth = columnData.length * 16;
	else if(columnData.length > 2 && columnData.length <= 5)
		dynContWidth = columnData.length * 15;
	else if(columnData.length % 2 == 0)
		dynContWidth = columnData.length * 16;
	else
		dynContWidth = columnData.length * 17;

	if(dynContWidth > 200)
		dynContWidth = 200;
	//dynContWidth = 100;
	//if(dynContWidth != undefined && dynContWidth != null && chartType.toUpperCase() == 'COLUMN')
		$("#pageload-graph").css("width", dynContWidth);

	try
	{
		//var maxVal = null;
		//var colorVal = "#556ebc";
		for(var r = 0; r< columnData.length ;r++)
		{
			if(lowVal > columnData[r])
				lowVal = columnData[r];
			dataArray.push(columnData[r]);
			//colorVal = columnData[r].color;
		}
	}
	catch (e)
	{
	}

	/*var total = 0;
	var minpLength = 2;
	$.each(dataArray,function() {
		total += this;
	});
	if(total == 0)
	{
		maxVal = 1;
		if(chartType.toUpperCase() == 'AREA'){
			maxVal = 10;
			for(var t=0;t<dataArray.length;t++){
				dataArray[t] = 1;		
			}
		}
	}*/	
	var jsonData= {
		chart: {
			type: 'column',
			spacingBottom: 0,
			spacingTop: 0,
			spacingLeft:10,
			spacingRight:10,
			backgroundColor: null
			},
			tooltip: {
				enabled: false
			},
			credits: {
				enabled: false
			},
			exporting: {
				 enabled: false
			},
			title: {
				text: ''
			},
			xAxis: {
				allowDecimals: false,
				reversed:true,
				visible: false,
				minorGridLineWidth: 0,
				minorTickLength: 0,
				tickLength: 0,
				minPadding: 0.5,
				maxPadding: 0.5,
				lineColor: 'transparent',
				labels: {
				   enabled: false
				},
			},
			yAxis: {
				max:maxVal,
				minorGridLineWidth: 0,
				visible: false,
				lineColor: 'transparent',
				gridLineColor: 'transparent',
				minorTickLength: 0,
				tickLength: 0,
				labels: {
					enabled: false
				}
			},
			labels: {
			   enabled: false
			},
			plotOptions: {
				series: {
					pointPadding: 0,
					groupPadding: 0,
					 pointWidth: 4,
					 showInLegend: false
				},
				column: {
					minPointLength: 2,
					borderWidth:0
				},
			},

			series: [{
				color:'#D19FC9',
				data: dataArray,
				crisp:false
			}]
		}
	jsonData= jQuery.extend(true,jsonData,getUserThemeFor(strSkin));
	return jsonData;
};