Ext.define('RumAppFlow.view.PageView', {
	extend: 'Ext.panel.Panel',
	alias:'widget.pageviewpanel',
	requires:['RumAppFlow.view.Pageviewdetailtab','RumAppFlow.view.RumAppflowGrid'],
	config: {
       numberofHits:"500"
     },
    constructor: function(config) {
         this.initConfig(config);
         this.callParent(arguments);
     },
	applyNumberofHits : function(){	
		var me = this;
		Ext.defer(function(){Ext.get('url_hitsID').update(me.fullData.numberofHits);},100)   
    },
	initComponent:function(){
		var me = this;
		me.mon(me,'boxready',function(){me.loadChartContainers()},me);
		me.callParent();
	},
	scrollMe:function(){
		var me = this;
		if(Ext.get(this.id+'-body').getScroll().top == 0){
			Ext.get(me.id).select('.x-toolbar').removeCls('toolbarshd');
		}else{
			Ext.get(me.id).select('.x-toolbar').addCls('toolbarshd');
		}
	},
	ui: 'eg-x-panel',
	margin:'0 2 2 0',
	bodyPadding:'0 20 20 20',
	dockedItems: [],
	boxItem:function(data){
		var me = this, box = {
			xtype:'box',
			ui:'boxCls',
			cls:'animation_box',
			flex:1,
			padding:20,
			margin:'10 0 0 0',
			data:data,
			listeners:{
				render: function(box){
					box.getEl().on({
						mouseenter:function(){
							box.getEl().addCls('selectBoxhover');
						},
						mouseleave:function(){
							box.getEl().removeCls('selectBoxhover');
						},
						click: function() {
							box.getEl().radioCls('selectBox');
							Ext.getCmp('loadItemsID').removeAll(true);
							boxElemntClickedId = box.boxState;
							if(box.boxState == 'Slow')
							{
								Ext.getCmp('loadItemsID').add({
									xtype:'pageviewdetailtab',
									id:'pageviewdetailtabId_clicked_slow',
									data:me.fullData.slow
								});
							}
							if(box.boxState == 'Errors')
							{
								Ext.getCmp('loadItemsID').add(Ext.create('RumAppFlow.view.RumAppflowGrid',{
									ui:'graybox',
									xtype:'rumappflowgrid',
									id:'rumappflowgrid_clicked_errors',
									gridData:me.fullData.error,
									title:'Summary of error messages',
									margin:'20px 250px 0px 250px',
									height:200,
									minWidth:600,
									maxWidth:1300
								}));
							}
							else if(box.boxState == 'Healthy')
							{
								Ext.getCmp('loadItemsID').add(Ext.create('RumAppFlow.view.RumAppflowGrid',{
									ui:'graybox',
									xtype:'rumappflowgrid',
									id:'rumappflowgrid_clicked_healthy',
									gridData:me.fullData.healthy,
									title:'Summary of best performing URLs',
									margin:'20px 250px 0px 250px',
									minWidth:600,
									height:200,
									maxWidth:1300
								}));
							}						

						}
					});
				},
				afterrender:function(box){					
					Ext.apply(box,{boxState:box.data[0].name});
					me.loadChart(box.id,box.data);
					if(box.boxState == boxElemntClickedId){
						box.getEl().radioCls('selectBox');
					}
					else
					{
						if(box.data[0].name =="Slow"){
							box.getEl().radioCls('selectBox');
						}
					}
				}
			}
		}	
	return box;
	},
	loadItems:function(){
		var me = this,itemArry=[];
		for (var t=0;t<me.data.length ;t++ )
		{
			for (var key in me.data[t] )
			{				
				var data = me.data[t][key];
				itemArry.push(me.boxItem(data));
			}
		}		
		return itemArry;
	},
	loadChartContainers:function(data){
		var me = this;
		if(!Ext.isEmpty(Ext.getCmp('pageViewChartID'))){
			Ext.getCmp('pageViewChartID').removeAll(true);
			Ext.get(me.id+'-body').on('scroll',me.scrollMe,Ext.get(me.id));
			Ext.getCmp('pageViewChartID').add(me.loadItems());
		}
	},
	loadChart:function(id,chartdata){
		var me = this;
		if(strRumSkin == "Dark"){
			for(var r=0;r<chartdata.length;r++){
				if(chartdata[r].color == "#e8e8e8"){
					chartdata[r].color = "#5c5c5c"
				}
			}
		}
		var chart = new Highcharts.Chart({
        chart: {
            renderTo: id,
			width:193,
			backgroundColor: null,
			height:193,
            type: 'pie'
        },
		tooltip: {
            enabled: false
        },
		exporting: {
		enabled: false
	},
				credits: {
		enabled: false
	},
        plotOptions: {
            pie: {
             innerSize: '92%',
			allowPointSelect: true,
			 borderWidth: 0 ,
			slicedOffset: 0,
			 dataLabels: {
                        enabled: false
                    },
                    showInLegend: false
            }
        },
        title: {
            text: ''
        },
        series: [{
            data: chartdata
			}]
    } ,function(chart) { 
		// on complete
       // var textX = chart.plotLeft + (chart.series[0].center[0]);
        //var textY = chart.plotTop  + (chart.series[0].center[1]);
        var div = '<div  class="animation_box data_center" style="color:'+chart.series[0].data[0].color+'">';
        div += '<div class="labelRobotonormalCls" style="font-size:30px;margin-top:45px">'+chart.series[0].data[0].value+'</div>';
        div += '<div style="font-size: 13px;padding-top:5px">'+chart.series[0].data[0].name+'</div>';
        div += '</div>';
        $("#"+id).append(div);

    });
	},
	loadPanelndGrid:function(me){
		var pageViewData = me.fullData;
		var defaultclick = me.fullData.defaultClick;
		me.addDocked({
			xtype: 'toolbar',
			ui:'plain',
			dock: 'top',
			padding:'20 20 20 20',
			listeners:{
				'afterrender':function(e){
					var me = this;
					me.add({
						xtype:'uribox',
						fieldLabel:'Page Views',
						labelCls:'big_font_label',
						width:200,
						id:'pageuriBox_Id',
						data:pageViewData.uriArray
					});
				}
			},
			items: []
		});
		me.add({
			xtype:"panel",
			ui:'plain',
			minWidth:700,
			margin:'0 150px 0px 150px',
			title:'<div class="url_hit" style="display:inline-block"><span class="font_r_l_20">Total Hits</span> <span class="font_r_b_40" id="url_hitsID"></span></div>',
			layout:{type:'hbox',align:'stretch'},
			titleAlign:'center',
			id:'pageViewChartID'
		},
		{
			xtype:'container',
			layout:{type:'vbox',align:'stretch',pack:'center'},
			id:'loadItemsID',
			
			listeners:{
				'afterrender':function(e){
					var me = this;
					me.add(
					{
						xtype:'pageviewdetailtab',
						minWidth:700,
						id:'pageviewdetailtabId',
						data:pageViewData[defaultclick]
					});
				}
			},
			items:[]
		});
	},
	updatePVpanel:function(jdata,uriUpdate){
		var me = this;
		var pageViewData = me.fullData;
		var defaultclick = me.fullData.defaultClick;
		var refreshUriList = me.fullData.refreshUriList;
		var uriBox = Ext.getCmp('pageuriBox_Id');
		if(Ext.isEmpty(uriUpdate))
		{
			uriBox.data = pageViewData.uriArray;
		}
		
		if(!Ext.isEmpty(refreshUriList) && refreshUriList != undefined && refreshUriList != null && refreshUriList.length > 0)
		{
			uriBox.selectedURL = refreshUriList;
			//updating the value in the field
			if(uriBox.selectedURL.length == 1 && uriBox.selectedURL[0].trim().toLowerCase() == "allurls")
				triggerURI.setNumberURL(0);
			else
				uriBox.setNumberURL(uriBox.selectedURL.length);
		}
		else if(Ext.isEmpty(uriUpdate))
		{
			uriBox.selectedURL = "all";
			//updating the value in the field
			uriBox.setNumberURL(0);
		}

		me.applyNumberofHits();
		me.loadChartContainers();
		try
		{
			if(!Ext.isEmpty(Ext.getCmp('pageviewdetailtabId')))
			{
				Ext.getCmp('pageviewdetailtabId').update(pageViewData[defaultclick]);							
			}
			else if(!Ext.isEmpty(Ext.getCmp('pageviewdetailtabId_clicked_slow')))
			{
				Ext.getCmp('pageviewdetailtabId_clicked_slow').update(pageViewData.slow);	
			}
			else if(!Ext.isEmpty(Ext.getCmp('rumappflowgrid_clicked_errors')))
			{
				Ext.getCmp('rumappflowgrid_clicked_errors').updateData(pageViewData.error);	
			}
			else if(!Ext.isEmpty(Ext.getCmp('rumappflowgrid_clicked_healthy')))
			{
				Ext.getCmp('rumappflowgrid_clicked_healthy').updateData(pageViewData.healthy);	
			}			
		}
		catch (ert)
		{
		}
	},
	listeners:{
		'afterrender':function(e){
			var me = this;
			me.loadPanelndGrid(me);
		}
	},
	items:[]	
});