Ext.define('RumAppFlow.view.Pageviewdetailtab', {
	extend:'Ext.tab.Panel',
	requires:['RumAppFlow.view.RumAppflowGrid'],
	alias:'widget.pageviewdetailtab',
	frame:false,
	ui:'fancyTab',
	title:'Summary of slow page views',
	tabPosition: 'left',
	height:266,
	margin:'5px 150px 0px 150px',
	padding:0,
	defaults:{
		bodyPadding:'0 5',
		layout:{
			type:'vbox',
			align:'stretch'
		}
	},
	update:function(data){
		var me = this;
		Ext.getCmp('rumappflowgrid_p_0').setTitle('<div class="fancy_tab_title"><span style="float:left;width:150px">'+data.browser.title+'</span><span  style="position: absolute; right: 0px;" class="value">'+data.browser.value+'</span></div>');
		Ext.getCmp('rumappflowgrid_0').updateData(data.browser);
		Ext.getCmp('rumappflowgrid_p_1').setTitle('<div class="fancy_tab_title"><span style="float:left;width:150px">'+data.network.title+'</span><span  style="position: absolute; right: 0px;" class="value">'+data.network.value+'</span></div>');
		Ext.getCmp('rumappflowgrid_1').updateData(data.network);
		Ext.getCmp('rumappflowgrid_p_2').setTitle('<div class="fancy_tab_title"><span style="float:left;width:150px">'+data.server.title+'</span><span  style="position: absolute; right: 0px;" class="value">'+data.server.value+'</span></div>');
		Ext.getCmp('rumappflowgrid_2').updateData(data.server);
		Ext.getCmp('rumappflowgrid_p_3').setTitle('<div class="fancy_tab_title"><span style="float:left;width:150px">'+data.content.title+'</span><span  style="position: absolute; right: 0px;" class="value">'+data.content.value+'</span></div>');
		Ext.getCmp('rumappflowgrid_3').updateData(data.content);
	},
	listeners:{
		'afterrender':function(e){
			var me = this;
			me.add({
				title: '<div class="fancy_tab_title"><span style="float:left;width:150px">'+me.data.browser.title+'</span><span  style="position: absolute; right: 0px;" class="value">'+me.data.browser.value+'</span></div>',
				id:'rumappflowgrid_p_0',
				items:[
				{
					xtype:'rumappflowgrid',
					id:'rumappflowgrid_0',
					ui:'graybox',
					cls:'noborder',
					title:'Top 5 URLs based on Browser Time',
					pvgridData:me.data.browser
				}
				]
			}, {
				title: '<div class="fancy_tab_title"><span style="float:left;width:150px">'+me.data.network.title+'</span><span  style="position: absolute; right: 0px;" class="value">'+me.data.network.value+'</span></div>',
				id:'rumappflowgrid_p_1',
				items:[
				{
					xtype:'rumappflowgrid',
					id:'rumappflowgrid_1',
					ui:'graybox',
					cls:'noborder',
					title:'Top 5 URLs based on Network Time',
					pvgridData:me.data.network
				}
				]
				
			},{
				title: '<div class="fancy_tab_title"><span  style="float:left;width:150px">'+me.data.server.title+'</span><span   style="position: absolute; right: 0px;" class="value">'+me.data.server.value+'</span></div>',
				id:'rumappflowgrid_p_2',
				items:[
				{
					xtype:'rumappflowgrid',
					id:'rumappflowgrid_2',
					ui:'graybox',
					cls:'noborder',
					title:'Top 5 URLs based on Server Time',
					pvgridData:me.data.server
				}
				]					
			},{
				title: '<div class="fancy_tab_title"><span style="float:left;width:150px">'+me.data.content.title+'</span><span  style="position: absolute; right: 0px;" class="value">'+me.data.content.value+'</span></div>',
				id:'rumappflowgrid_p_3',
				cls:'last',
				items:[
				{
					xtype:'rumappflowgrid',
					id:'rumappflowgrid_3',
					ui:'graybox',
					cls:'noborder',
					title:'Top 5 URLs based on Content Download Time',
					pvgridData:me.data.content
				}
				]
				
			});
			me.setActiveTab(0);
		}
	},
	items: []
});