Ext.define('RumAppFlow.view.ResponseTimePiechart', {
	extend:'Ext.panel.Panel',
	alias:'widget.responsetimepiechart',
	requires:['RumAppFlow.view.ToogleChart'],
	border:true,
	itemId:'responsetimepiechart',
	ui:'eg-x-panel',
	bodyCls:'pieChart',
	autoDestroy:true,
	margin:'0 9 10 0',
	chartMarginTop:0,
	chartMarginLeft:0,
	chartMarginBottom:0,
	chartMarginRight:0,
	legendWidth:null,
	legendContainerWidth:null,
	formatLegend:null,
	legendOffset:0,
	legendLayout : 'vertical' ,// 'horizontal' or 'vertical'
	chartLegendUseHTML:false,
	bodyPadding:'0 10 0 10',
	title:'Response Time Breakup',
	layout: {
		 type: 'vbox',
		 align: 'stretch'
	},
	legendPosition: 'right', // top,left, bottom and right
	initComponent:function(){
		var me = this;
		me.mon(me,'boxready',me.loadChart,me);
		me.callParent();
		me.mon(me, 'resize', me.resizePanel, me);
		 me.mon(me, 'removed', me.destroyChart, me);
     },
	destroyChart:function(){
			 var me = this,chartObj = $('#' + me.body.id).highcharts();
			if(!Ext.isEmpty(chartObj)){
				chartObj.destroy();
			}
	 },
	resizePanel:function(){
		 var me = this,chartObj = $('#pie_id').highcharts();
		 if(!Ext.isEmpty(chartObj)){
			chartObj.reflow();
			
		 }
	 },
	updateData:function(data){
		Ext.getCmp('tooglechart_id').data = data;
		Ext.getCmp('tooglechart_id').updateData(data);
	},
	updateChart:function(el,data){
		var me = this;
		var donutData = data;
		var nodata = false;

		try
		{
			if(donutData.length == 0)
				nodata = true;
		}
		catch(e)
		{
			nodata=true;
		}

		try
		{
			for(var u=0;u<donutData.length;u++){
				if(donutData[u].value == "-" || donutData[u].value == "0")
					nodata = true;
				else if(donutData[u].value != "0"){
					nodata = false;
					break;
				}
			}
			
		}
		catch (e1)
		{
			nodata = false;
		}		

		if(nodata)
			$('#pie_id').html('<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>No Data Found!</div></div></div>');
		else
			$('#pie_id').highcharts(me.chartConfig(data));
	},
	loadChart:function(){
		var me = this;
		var donutData = this.Jdata.donut1.data;
		var nodata = false;

		try
		{
			if(donutData.length == 0)
				nodata = true;
		}
		catch(e)
		{
			nodata=true;
		}

		try
		{
			for(var u=0;u<donutData.length;u++){
				if(donutData[u].value == "-" || donutData[u].value == "0")
					nodata = true;
				else if(donutData[u].value != "0"){
					nodata = false;
					break;
				}					
			}
			
		}
		catch (e1)
		{
			nodata = false;
		}
		try
		{
			me.setTitle(this.Jdata.donut1.title);	
		}
		catch (erty)
		{
		}
		
		if(nodata)
			$('#pie_id').html('<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>No Data Found!</div></div></div>');
		else
			$('#pie_id').highcharts(me.chartConfig(this.Jdata.donut1.data));
	},
	chartLegendAlignment: function(obj) {
		var me = this,
		alignment, 
		verticalAlign = me.legendPosition;
         switch (verticalAlign) {
             case "top":
                 alignment = "center";
                 verticalAlign = "top";
                 Ext.apply(obj, {
                     align: alignment,
                     verticalAlign: verticalAlign,
                      layout: me.legendLayout == 'horizontal' ? 'horizontal' : 'vertical'
                 });

                 break;
             case "bottom":
                 alignment = "left";
                 verticalAlign = "bottom";
                 Ext.apply(obj, {
                     align: alignment,
                     verticalAlign: verticalAlign,
					 itemDistance: 10,
                      layout: me.legendLayout == 'horizontal' ? 'horizontal' : 'vertical'
                 });

                 break;
             case "left":
                 alignment = "left";
                 verticalAlign = "middle";
                 Ext.apply(obj, {
                     align: alignment,
                     verticalAlign: verticalAlign,
                     layout: me.legendLayout == 'horizontal' ? 'horizontal' : 'vertical'
                 });

                 break;
             case "right":
                 alignment = "right";
                 verticalAlign = "middle";
                 Ext.apply(obj, {
                     align: alignment,
                     verticalAlign: verticalAlign,
                      layout: me.legendLayout == 'horizontal' ? 'horizontal' : 'vertical'
                 });

                 break;
         }

     },
	chartConfig:function(data){
		var me = this,
		config = {
			chart: {
				type: 'pie',
			
				marginTop: me.chartMarginTop,
				marginLeft: me.chartMarginLeft,
				marginBottom: me.chartMarginBottom,
				marginRight: me.chartMarginRight,
				backgroundColor:'transparent'
			},
			title: {
				text: ''
			},
			exporting: {
				enabled: false
			},
			credits: {
				enabled: false
			},
			plotOptions: {
				pie: {
					showInLegend: true,
					startAngle: 0,
					endAngle: 360,
					borderWidth: 0,
					size: '100%',
					innerSize: '40%',
					dataLabels: {
						distance:-16,						
						enabled: true,
						formatter: function() {
							var dataLabelVal = Math.round(this.percentage*100/100);
							if(dataLabelVal < 5)
								return null;
							else
								return dataLabelVal+'%';
						},
						style: {
							fontWeight:'500',
							'font-family':'Arial',
							color: '#FFFFFF',
							fontSize:'10px',
							textShadow: false,
							textOutline: false
						}
					}
				}
			}, 
			legend: {
				symbolWidth:6,
				symbolHeight:6,
				width: me.legendContainerWidth,
				itemMarginBottom:10,
				useHTML:me.chartLegendUseHTML,
				itemWidth:me.legendWidth,
				x: me.legendOffset,				
				itemDistance: 10,
				itemHoverStyle:{
					"color": "#84b8e4"
				},
				itemStyle:{
					fontSize:"11px",
					fontWeight:"400",
					fontFamily:"Roboto",
					color:strRumSkin == "Dark"?"#c0c0c0":"#969696"
				},
				labelFormatter: function () {
					var nameN = Ext.String.htmlDecode(this.name);
					if(!Ext.isEmpty(me.formatLegend))
					{
						var legValue = me.formatLegend;
						if(nameN != null && nameN.length > legValue)
							nameN = "<span data-qtip='"+nameN+"'>"+nameN.substring(0,legValue)+"..</span>";
					}
					return nameN;
				}
			},
			tooltip: {
				formatter: function() {
					if(this.point.name == "Empty")
						return null;

					return  Ext.String.htmlDecode(this.point.name) +'</b>: '+ Math.round(this.percentage*100)/100 +' %';
				}
			},
			series: [{
				data: data
			}]
		};
		me.chartLegendAlignment(config.legend);
		config= jQuery.extend(true,config,getUserThemeFor(strSkin));
		return config;
	},
	listeners:{
		'afterrender':function(e){
			var me = this;
			me.add(
			{
				xtype:'tooglechart',
				id:'tooglechart_id',
				ldata:me.Jdata,
				height:23
			},
			{
				xtype:'container',
				flex:1,
				id:'pie_id'
			});
		}
	},
	items:[]
});