Ext.define('RumAppFlow.view.RumAppflowErrorGrid', {
	extend:'Ext.panel.Panel',
	alias:'widget.rumappflowerrorgrid',
	title: 'Top 5 Slow Page Groups for the Site',
	ui:'eg-x-panel',
	autoDestroy:true,
	bodyPadding:'0 10 10 10',
	flex:1,
	layout: {
		 type: 'vbox',
		 align: 'stretch'
	},
	ui:'eg-x-panel',
	margin:'0 2 10 0',
	overriderRenderer:function(value,row,data,i){
			var me = this;
			return function(value){ return value};
			me.callParent();
			
	},	
	config: {
		data: {},
		storeData:[],
		storefileds:[],
		gridColumns:[]
     },
	
     constructor: function(config) {
		 var me = this;
         me.initConfig(config);
         me.callParent(arguments);
     },
	loadData:function(data){
		 var me = this;
		
		 if(!Ext.isEmpty(data)){
				if(data.title){
					Ext.getCmp(me.id).setTitle(data.title);
				}
				if(data.columns){
					for (var i=0;i< data.columns.length;i++ )
					{
						if(data.data.items[i]){
							data.columns[i].renderer = me.overriderRenderer(data.columns[i],data.data[i],data.fields,i);
							if(!Ext.isEmpty(data.columns[i].headeralign)){
								data.columns[i].align = "left"
							}else{
								data.columns[i].align = data.columns[i].headeralign;
							}
							data.columns[i].menuDisabled =  true;
						}
						if(data.columns[i].text.toLowerCase() == "url" || data.columns[i].text.toLowerCase() == "script"){					
							data.columns[i].renderer = function(value) {
								value = "<span class='f16' data-qclass='yellowTip' data-qtip='"+value+"'>"+value+"</span>";
								return value;
							}
						}
					}
					me.gridColumns = data.columns;
				}
				if(data.fields){
					me.storefields = data.fields;
				}
				if(data.data && data.data.items.length > 0){
					me.storeData = data.data.items;
				}
			}
		Ext.getCmp(me.id+'_grid').getStore().loadRawData(me.storeData);
		Ext.getCmp(me.id+'_grid').reconfigure(Ext.getCmp(me.id+'_grid').getStore(), me.gridColumns);
		Ext.getCmp(me.id+'_grid').getView().refresh();
	
	 },
	initComponent:function(){
			var me = this;
			
			if(!Ext.isEmpty(me.data)){
				if(me.data.title){
					me.title = me.data.title;
				}
				if(me.data.columns){
					for (var i=0;i< me.data.columns.length;i++ )
					{
						if(me.data.data.items[i])
						{
							me.data.columns[i].renderer = me.overriderRenderer(me.data.columns[i],me.data.data[i],me.data.fields,i);
							if(!Ext.isEmpty(me.data.columns[i].headeralign)){
								me.data.columns[i].align = me.data.columns[i].headeralign;
							}
							else
							{
								me.data.columns[i].align = 'left';
							}
							me.data.columns[i].menuDisabled =  true;
						}
						if(me.data.columns[i].text.toLowerCase() == "url" || me.data.columns[i].text.toLowerCase() == "script"){					
							me.data.columns[i].renderer = function(value) {
								value = "<span class='f16' data-qclass='yellowTip' data-qtip='"+value+"'>"+value+"</span>";
								return value;
							}
						}
							
					}
					me.gridColumns = me.data.columns;
				}
				if(me.data.fields){
					me.storefields = me.data.fields;
				}
				if(me.data.data && me.data.data.items.length > 0){
					me.storeData = me.data.data.items;
				}
			}
			me.items = me.loadGrid();
			me.callParent();
	},
	loadGrid:function(){
		var me = this;
		var grid = Ext.create('Ext.grid.Panel', {
				flex:1,
				border: 0,
				id:me.id+'_grid',
				viewConfig: {
					emptyText: '<div style="display:table;height:98%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>No Data Found!</div></div></div>',
					deferEmptyText: false,
				},
				style: {
					borderColor: 'transparent',
					borderWidth :'1px',
					borderStyle: 'solid'
				},
				columnLines : true,
				ui:'eg-grid-skin',
				store: new  Ext.create('Ext.data.Store', {
					fields: me.storefields,
					data:me.storeData					
				}),
				columns: me.gridColumns
			});
		return grid;
	}
   
});