Ext.define('RumAppFlow.view.RumAppflowGrid', {
	extend:'Ext.panel.Panel',
	alias:'widget.rumappflowgrid',
	title: 'Top 5 Slow Page Groups for the Site',
	ui:'eg-x-panel',
	autoDestroy:true,
	bodyPadding:'0 10 10 10',
	flex:1,
	layout: {
		 type: 'vbox',
		 align: 'stretch'
	},

	margin:'0 2 10 0',
	initComponent:function(){
			var me = this;
			me.items = me.loadGrid();
			me.callParent();
	},
	updateData:function(jsonData){
		try
		{
			if(!Ext.isEmpty(jsonData[0].data.items) && jsonData[0].data.items != undefined && jsonData[0].data.items != null)
				Ext.getCmp('gridPanel_'+this.id).getStore().loadData(jsonData[0].data.items);
			else
				Ext.getCmp('gridPanel_'+this.id).getStore().loadData([]);
			/*if(jsonData[0].columns[0].text.toLowerCase() == "country"){
				jsonData[0].columns[0].renderer = function(value) {
					value = "<span class='f16' data-qclass='yellowTip'  data-qtip='"+value.name+"' ><img src='../images/clear.png' class='flag " + value.flag + "' style= 'vertical-align: middle' /> " + value.name + "</span>";
					return value;
				}
			}
			else*/ if(jsonData[0].columns[0].text.toLowerCase() == "page groups"){					
				jsonData[0].columns[0].renderer = function(value) {
					value = "<span class='f16' data-qclass='yellowTip' data-qtip='"+value+"'>"+value+"</span>";
					return value;
				}
			}
			Ext.getCmp('gridPanel_'+this.id).reconfigure(Ext.getCmp('gridPanel_'+this.id).getStore(), jsonData[0].columns);	
		}
		catch (e1)
		{
			if(!Ext.isEmpty(jsonData.grid.data.items) && jsonData.grid.data.items != undefined && jsonData.grid.data.items != null)
				Ext.getCmp('gridPanel_'+this.id).getStore().loadData(jsonData.grid.data.items);
			else
				Ext.getCmp('gridPanel_'+this.id).getStore().loadData([]);
			Ext.getCmp('gridPanel_'+this.id).reconfigure(Ext.getCmp('gridPanel_'+this.id).getStore(), jsonData.grid.columns);
		}	
		//Ext.getCmp(me.id+'_grid').reconfigure(st, me.gridColumns);
		Ext.getCmp('gridPanel_'+this.id).getView().refresh();
	},
	loadGrid:function(){
		var me = this;
		var fieldData = [];
		var columnData = [];
		var valData = [];
		try
		{

			if(!Ext.isEmpty(me.gridData) && me.gridData != undefined && me.gridData != null){
				fieldData = me.gridData[0].fields;
				columnData = me.gridData[0].columns;
				/*if(columnData[0].text.toLowerCase() == "country"){					
					columnData[0].renderer = function(value) {
						value = "<span class='f16' data-qclass='yellowTip'  data-qtip='"+value.name+"' ><img src='../images/clear.png' class='flag " + value.flag + "' style= 'vertical-align: middle' /> " + value.name + "</span>";
						return value;
					}
				}
				else*/ if(columnData[0].text.toLowerCase() == "page groups"){					
					columnData[0].renderer = function(value) {
						value = "<span class='f16' data-qclass='yellowTip' data-qtip='"+value+"'>"+value+"</span>";
						return value;
					}
				}
				if(!Ext.isEmpty(me.gridData[0].data.items) && me.gridData[0].data.items != undefined && me.gridData[0].data.items != null)
					valData = me.gridData[0].data.items;
			}	
			else if(!Ext.isEmpty(me.pvgridData) && me.pvgridData != undefined && me.pvgridData != null){
				fieldData = me.pvgridData.grid.fields;
				columnData = me.pvgridData.grid.columns;
				if(!Ext.isEmpty(me.pvgridData.grid.data.items) && me.pvgridData.grid.data.items != undefined && me.pvgridData.grid.data.items != null)
					valData = me.pvgridData.grid.data.items;
			}
			else
			{
				fieldData = [];
				columnData = [];
				valData = [];
			}
		}
		catch (we)
		{
			fieldData = [];
			columnData = [];
			valData = [];

		}
		
		var grid = Ext.create('Ext.grid.Panel', {
				flex:1,
				border: 0,
				id:'gridPanel_'+this.id,
				style: {
					borderColor: 'transparent',
					borderWidth :'1px',
					borderStyle: 'solid'
				},
				viewConfig: {
					emptyText: '<div style="display:table;height:98%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>No Data Found!</div></div></div>',
					deferEmptyText: false,
				},
				columnLines : true,
				ui:'eg-grid-skin',
				store: Ext.create('Ext.data.Store', {
					fields:fieldData,
					id:'responseTimestoreID',
					data:valData,
					proxy: {
						type: 'memory',
						reader: {
							type: 'json',
							root: 'items'
						}
					}
				}),
				columns:columnData				
			});
		return grid;
	}
   
});