Ext.define('RumAppFlow.view.ToogleChart',{
		extend:'Ext.container.Container',
		alias:'widget.tooglechart',
		ui:'chart-controllers',
		autoDestroy:true,
		layout: {
		 type: 'hbox'
		},		
		updateData:function(data){
			Ext.getCmp('Donut_container').donutData = data;

			try
			{
				var component = Ext.ComponentQuery.query('panel[itemId="responsetimepiechart"]')[0];
				component.setTitle(data.donut1.title);
			}
			catch (erty)
			{
			}
			var enduser_id_Obj = Ext.getCmp('enduser_id');	
			var desktop_id_Obj = Ext.getCmp('desktop_id');	
			var tablet_id_Obj = Ext.getCmp('tablet_id');	
			var mobile_id_Obj = Ext.getCmp('mobile_id');
			if(!Ext.isEmpty(enduser_id_Obj.pressed) && enduser_id_Obj.pressed){
				enduser_id_Obj.update(data);
			}
			else if(!Ext.isEmpty(desktop_id_Obj.pressed) && desktop_id_Obj.pressed){
				desktop_id_Obj.update(data);
			}
			else if(!Ext.isEmpty(tablet_id_Obj.pressed) && tablet_id_Obj.pressed){
				tablet_id_Obj.update(data);
			}
			else if(!Ext.isEmpty(mobile_id_Obj.pressed) && mobile_id_Obj.pressed){
				mobile_id_Obj.update(data);
			}
		},
		listeners:{
			'afterrender':function(e){
				var me = this;
				var donutData = me.ldata;
				me.add(
					{
						xtype:'container',
						id:'Donut_container',
						donutData:me.ldata,
						defaults:{
							xtype:'button',
							toggleGroup :true,
							enableToggle:true,
							listeners:{
								 mouseover: function(btn) {
								btn.setTooltip(btn.textData);
								btn.btnEl.dom.setAttribute('data-qclass','new_yellowTip');
							},
								toggle:function(btn){
									if(btn.pressed == true){
										btn.setText(btn.textData);

										btn.disable();
									}else{
										btn.setText("");
										btn.enable();
									}
								}
							},
							
						},
						layout: {
							type: 'hbox'
						},
						listeners:{
							'afterrender':function(e){
								var me = this;
								me.add(						
									{
										text:'End User',
										iconCls:'appflow_device_b_w_enduser',
										id:'enduser_id',
										padding:'3 5 2 5',
										textData:'End User',
										pressed:true,
										update:function(Ddata){
											// updating the chart
											var component = Ext.ComponentQuery.query('panel[itemId="responsetimepiechart"]')[0];
											component.updateChart("pie_id",Ddata.donut1.data);
										},
										handler:function(){
											// updating the chart
											var component = Ext.ComponentQuery.query('panel[itemId="responsetimepiechart"]')[0];
											component.setTitle(me.donutData.donut1.title);
											component.updateChart("pie_id",me.donutData.donut1.data);
										}
									},
									{
									 xtype: 'menuseparator'
									},
									{
										text:'',
										iconCls:'appflow_device_b_w_desktop',
										id:'desktop_id',
										padding:'3 5 2 5',
										textData:'Desktop',
										//disabled:true,
										//pressed:true,
										update:function(Ddata){
											// updating the chart
											var component = Ext.ComponentQuery.query('panel[itemId="responsetimepiechart"]')[0];
											component.updateChart("pie_id",Ddata.donut2.data);
										},
										handler:function(){
											// updating the chart
											var component = Ext.ComponentQuery.query('panel[itemId="responsetimepiechart"]')[0];
											component.setTitle(me.donutData.donut2.title);
											component.updateChart("pie_id",me.donutData.donut2.data);
										}
										
									},
									{
									 xtype: 'menuseparator'
									},
									{
										text:'',
										padding:'3 5 2 5',
										textData:'Tablet',
										iconCls:'appflow_device_b_w_tablet',
										id:'tablet_id',
										update:function(Ddata){
											// updating the chart
											var component = Ext.ComponentQuery.query('panel[itemId="responsetimepiechart"]')[0];
											component.updateChart("pie_id",Ddata.donut3.data);
										},
										handler:function(){
											// updating the chart
											var component = Ext.ComponentQuery.query('panel[itemId="responsetimepiechart"]')[0];
											component.setTitle(me.donutData.donut3.title);
											component.updateChart("pie_id",me.donutData.donut3.data);
										}
										
									},
									{
									 xtype: 'menuseparator'
									},
									{
										text:'',
										padding:'3 5 2 5',
										textData:'Mobile',
										iconCls:'appflow_device_b_w_mobile',
										id:'mobile_id',
										update:function(Ddata){
											// updating the chart
											var component = Ext.ComponentQuery.query('panel[itemId="responsetimepiechart"]')[0];
											component.updateChart("pie_id",Ddata.donut4.data);
										},
										handler:function(){
											// updating the chart
											var component = Ext.ComponentQuery.query('panel[itemId="responsetimepiechart"]')[0];
											component.setTitle(me.donutData.donut4.title);
											component.updateChart("pie_id",me.donutData.donut4.data);
										}
									}
								);
							}
						},
						items:[]
					}	
				);			
			}
		},
		items:[]
});